/*
 Copyright (C) 2011 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

[CCode (cprefix = "Indicate", lower_case_cprefix = "indicate_")]
namespace Indicate {
	[CCode (cheader_filename = "libindicate/indicator.h")]
	public class Indicator : GLib.Object {
		[CCode (has_construct_function = false)]
		public Indicator ();
		public bool get_displayed ();
		public uint get_id ();
		public virtual unowned string get_property (string key);
		[CCode (cname = "indicate_indicator_hide")]
		public void emit_hide ();
		public bool is_visible ();
		public virtual unowned GLib.PtrArray list_properties ();
		public void set_displayed (bool displayed);
		public virtual void set_property (string key, string data);
		public void set_property_bool (string key, bool value);
		public void set_property_int (string key, int value);
		public void set_property_time (string key, GLib.TimeVal time);
		public void set_server (Indicate.Server server);
		[CCode (cname = "indicate_indicator_show")]
		public void emit_show ();
		[CCode (cname = "indicate_indicator_user_display")]
		public void emit_user_display ();
		[CCode (has_construct_function = false)]
		public Indicator.with_server (Indicate.Server server);
		public virtual signal void displayed (bool displayed);
		public virtual signal void hide ();
		public virtual signal void modified (string property);
		public virtual signal void show ();
		public virtual signal void user_display ();
	}
	[CCode (cheader_filename = "libindicate/listener.h")]
	public class Listener : GLib.Object {
		[CCode (has_construct_function = false)]
		public Listener ();
		public void display (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator);
		public void displayed (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, bool displayed);
		public void get_property (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_cb callback, void* data);
		public void get_property_bool (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_bool_cb callback, void* data);
		public void get_property_int (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_int_cb callback, void* data);
		public void get_property_time (Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, Indicate.indicate_listener_get_property_time_cb callback, void* data);
		public static unowned Indicate.Listener ref_default ();
		public void set_default_max_indicators (int max);
		public void set_server_max_indicators (Indicate.ListenerServer server, int max);
		public virtual signal void indicator_added (Indicate.ListenerServer indicator, Indicate.ListenerIndicator p1);
		public virtual signal void indicator_modified (Indicate.ListenerServer indicator, Indicate.ListenerIndicator property, string p2);
		public virtual signal void indicator_removed (Indicate.ListenerServer indicator, Indicate.ListenerIndicator p1);
		public virtual signal void server_added (Indicate.ListenerServer type, string p1);
		public virtual signal void server_count_changed (Indicate.ListenerServer count, uint p1);
		public virtual signal void server_removed (Indicate.ListenerServer type, string p1);
	}
	[Compact]
	[CCode (cheader_filename = "libindicate/listener.h")]
	public class ListenerIndicator {
		public static GLib.Type get_gtype ();
		public uint get_id ();
	}
	[Compact]
	[CCode (cheader_filename = "libindicate/listener.h")]
	public class ListenerServer {
		public static bool check_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
		public static void get_count (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.indicate_listener_get_server_uint_property_cb callback, void* data);
		public unowned string get_dbusname ();
		public static void get_desktop (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.indicate_listener_get_server_property_cb callback, void* data);
		public static GLib.Type get_gtype ();
		public static void remove_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
		public static void show_interest (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.Interests interest);
	}
	[CCode (cheader_filename = "libindicate/server.h")]
	public static class Server : GLib.Object {
		public void add_indicator (Indicate.Indicator indicator);
		public virtual bool check_interest (Indicate.Interests interest);
		[NoWrapper]
		public virtual bool get_indicator_count (uint count) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_list (out unowned GLib.Array indicators) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_properties (uint id, string properties) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_property (uint id, string property, string value) throws GLib.Error;
		[NoWrapper]
		public virtual bool get_indicator_property_group (uint id, GLib.PtrArray properties, string value) throws GLib.Error;
		public int get_max_indicators ();
		public virtual uint get_next_id ();
		public void hide ();
		[NoWrapper]
		public virtual void indicator_added (uint id);
		[NoWrapper]
		public virtual bool indicator_displayed (string sender, uint id, bool displayed) throws GLib.Error;
		[NoWrapper]
		public virtual void indicator_removed (uint id);
		[NoWrapper]
		public virtual int max_indicators_get ();
		[NoWrapper]
		public virtual bool max_indicators_set (string sender, int max);
		public static unowned Indicate.Server ref_default ();
		public void remove_indicator (Indicate.Indicator indicator);
		[NoWrapper]
		public virtual bool remove_interest (string sender, Indicate.Interests interest);
		public void set_count (uint count);
		public static void set_dbus_object (string obj);
		public void set_default ();
		public void set_desktop_file (string path);
		public void set_type (string type);
		public void show ();
		[NoWrapper]
		public virtual bool show_indicator_to_user (uint id) throws GLib.Error;
		[NoWrapper]
		public virtual bool show_interest (string sender, Indicate.Interests interest);
		[NoAccessorMethod]
		public uint count { get; set; }
		[NoAccessorMethod]
		public string desktop { owned get; set; }
		[NoAccessorMethod]
		public string type { owned get; set; }
		public virtual signal void indicator_delete (uint p0);
		public virtual signal void indicator_modified (uint id, string property);
		public virtual signal void indicator_new (uint p0);
		public virtual signal void interest_added (uint interest);
		public virtual signal void interest_removed (uint interest);
		public virtual signal void max_indicators_changed (int max);
		public virtual signal void server_count_changed (uint count);
		public virtual signal void server_display ();
		public virtual signal void server_hide (string type);
		public virtual signal void server_show (string type);
	}
	[CCode (cprefix = "INDICATE_INTEREST_", cheader_filename = "libindicate/interests.h")]
	public enum Interests {
		NONE,
		SERVER_DISPLAY,
		SERVER_SIGNAL,
		INDICATOR_DISPLAY,
		INDICATOR_SIGNAL,
		INDICATOR_COUNT,
		LAST
	}
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_property_bool_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, bool propertydata);
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, string propertydata);
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_property_int_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, int propertydata);
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_property_time_cb (Indicate.Listener listener, Indicate.ListenerServer server, Indicate.ListenerIndicator indicator, string property, GLib.TimeVal propertydata);
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_server_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, string value);
	[CCode (cheader_filename = "libindicate/listener.h")]
	public delegate void indicate_listener_get_server_uint_property_cb (Indicate.Listener listener, Indicate.ListenerServer server, uint value);
}
