
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 189 of yacc.c  */
#line 456 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 383 "preproc.y"

	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 214 of yacc.c  */
#line 994 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 1019 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   85484

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  616
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2452
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4252

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1612,  1614,  1616,  1618,  1622,  1623,  1625,  1626,  1628,
    1630,  1632,  1636,  1637,  1639,  1641,  1643,  1645,  1647,  1649,
    1652,  1653,  1655,  1658,  1660,  1663,  1664,  1667,  1669,  1672,
    1675,  1682,  1691,  1700,  1705,  1711,  1716,  1721,  1726,  1730,
    1738,  1747,  1754,  1761,  1768,  1775,  1779,  1781,  1785,  1789,
    1791,  1793,  1795,  1797,  1799,  1801,  1805,  1809,  1813,  1815,
    1819,  1823,  1825,  1829,  1843,  1845,  1849,  1854,  1860,  1865,
    1873,  1876,  1878,  1879,  1882,  1883,  1885,  1886,  1893,  1902,
    1911,  1913,  1917,  1923,  1929,  1937,  1947,  1955,  1965,  1971,
    1978,  1985,  1990,  1992,  1994,  1996,  1998,  2000,  2002,  2004,
    2006,  2010,  2014,  2018,  2022,  2024,  2028,  2030,  2033,  2036,
    2040,  2046,  2049,  2052,  2053,  2060,  2068,  2076,  2084,  2093,
    2102,  2109,  2118,  2128,  2138,  2146,  2157,  2165,  2174,  2183,
    2192,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2223,  2225,  2227,  2229,  2234,  2237,  2242,  2245,
    2251,  2256,  2261,  2265,  2269,  2273,  2275,  2277,  2279,  2281,
    2284,  2287,  2289,  2291,  2293,  2296,  2299,  2301,  2304,  2307,
    2309,  2311,  2319,  2327,  2338,  2340,  2342,  2345,  2350,  2356,
    2358,  2362,  2365,  2368,  2371,  2374,  2376,  2379,  2382,  2387,
    2391,  2394,  2397,  2400,  2403,  2406,  2408,  2412,  2414,  2417,
    2421,  2422,  2424,  2428,  2431,  2438,  2445,  2455,  2459,  2460,
    2464,  2465,  2479,  2494,  2496,  2497,  2500,  2501,  2503,  2507,
    2512,  2517,  2524,  2526,  2529,  2530,  2532,  2534,  2535,  2537,
    2539,  2540,  2550,  2563,  2571,  2574,  2575,  2579,  2582,  2584,
    2588,  2592,  2595,  2597,  2601,  2605,  2609,  2612,  2615,  2617,
    2619,  2621,  2623,  2626,  2628,  2630,  2632,  2634,  2639,  2645,
    2647,  2651,  2655,  2657,  2660,  2665,  2671,  2673,  2675,  2677,
    2679,  2683,  2687,  2690,  2693,  2696,  2699,  2701,  2704,  2707,
    2709,  2711,  2713,  2717,  2720,  2721,  2724,  2726,  2730,  2736,
    2738,  2741,  2743,  2744,  2750,  2758,  2764,  2772,  2778,  2786,
    2790,  2796,  2802,  2808,  2810,  2814,  2826,  2837,  2848,  2851,
    2854,  2855,  2865,  2868,  2869,  2874,  2879,  2884,  2886,  2888,
    2890,  2891,  2899,  2906,  2913,  2920,  2927,  2935,  2945,  2955,
    2962,  2969,  2976,  2983,  2990,  2999,  3008,  3015,  3022,  3029,
    3038,  3047,  3056,  3065,  3072,  3074,  3075,  3078,  3079,  3087,
    3094,  3101,  3108,  3115,  3122,  3129,  3137,  3144,  3151,  3158,
    3165,  3173,  3181,  3191,  3201,  3208,  3215,  3222,  3231,  3240,
    3249,  3256,  3258,  3260,  3264,  3268,  3270,  3272,  3274,  3276,
    3278,  3280,  3282,  3283,  3285,  3287,  3289,  3291,  3293,  3295,
    3296,  3303,  3312,  3315,  3318,  3321,  3324,  3327,  3331,  3335,
    3338,  3341,  3344,  3347,  3351,  3354,  3360,  3365,  3369,  3373,
    3377,  3379,  3381,  3382,  3386,  3389,  3392,  3394,  3398,  3401,
    3403,  3404,  3413,  3424,  3428,  3433,  3438,  3439,  3442,  3448,
    3451,  3452,  3456,  3460,  3464,  3468,  3472,  3476,  3480,  3484,
    3488,  3492,  3496,  3500,  3504,  3509,  3513,  3517,  3519,  3520,
    3526,  3533,  3538,  3541,  3542,  3547,  3551,  3557,  3564,  3569,
    3576,  3583,  3589,  3597,  3599,  3600,  3607,  3619,  3631,  3643,
    3657,  3667,  3679,  3690,  3695,  3698,  3704,  3707,  3708,  3713,
    3719,  3725,  3728,  3733,  3735,  3737,  3739,  3740,  3742,  3743,
    3745,  3746,  3750,  3751,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3773,  3779,  3784,  3788,  3789,  3791,  3793,
    3795,  3797,  3802,  3811,  3815,  3816,  3822,  3824,  3829,  3832,
    3834,  3838,  3841,  3845,  3846,  3853,  3856,  3857,  3863,  3867,
    3868,  3871,  3874,  3877,  3881,  3883,  3887,  3889,  3892,  3894,
    3895,  3903,  3905,  3909,  3911,  3913,  3917,  3923,  3926,  3928,
    3932,  3940,  3941,  3945,  3948,  3951,  3954,  3955,  3958,  3961,
    3963,  3965,  3969,  3973,  3975,  3978,  3983,  3988,  3991,  3995,
    4001,  4007,  4009,  4011,  4021,  4023,  4026,  4031,  4036,  4041,
    4044,  4048,  4050,  4054,  4059,  4062,  4064,  4065,  4069,  4073,
    4078,  4083,  4088,  4093,  4096,  4098,  4100,  4101,  4103,  4105,
    4106,  4108,  4114,  4116,  4117,  4119,  4120,  4124,  4126,  4130,
    4135,  4139,  4144,  4149,  4152,  4155,  4160,  4164,  4170,  4179,
    4181,  4182,  4184,  4186,  4188,  4192,  4193,  4195,  4197,  4199,
    4201,  4203,  4205,  4209,  4210,  4213,  4214,  4216,  4220,  4222,
    4223,  4225,  4228,  4233,  4238,  4241,  4242,  4245,  4249,  4252,
    4253,  4255,  4259,  4261,  4264,  4266,  4269,  4275,  4282,  4288,
    4290,  4293,  4295,  4300,  4304,  4309,  4315,  4320,  4326,  4331,
    4337,  4340,  4345,  4347,  4350,  4353,  4356,  4358,  4360,  4361,
    4366,  4369,  4371,  4374,  4377,  4382,  4384,  4388,  4390,  4393,
    4397,  4399,  4402,  4403,  4406,  4411,  4416,  4417,  4419,  4423,
    4426,  4429,  4433,  4439,  4446,  4449,  4453,  4457,  4462,  4463,
    4465,  4467,  4469,  4471,  4473,  4476,  4482,  4484,  4486,  4488,
    4490,  4493,  4497,  4501,  4502,  4504,  4506,  4508,  4510,  4512,
    4515,  4518,  4521,  4524,  4527,  4529,  4533,  4534,  4536,  4538,
    4540,  4542,  4548,  4551,  4553,  4555,  4557,  4559,  4565,  4568,
    4571,  4574,  4576,  4580,  4584,  4587,  4589,  4590,  4594,  4595,
    4601,  4604,  4610,  4613,  4615,  4618,  4622,  4623,  4625,  4627,
    4629,  4631,  4633,  4635,  4639,  4643,  4647,  4651,  4655,  4659,
    4663,  4664,  4666,  4671,  4673,  4677,  4683,  4686,  4689,  4693,
    4697,  4701,  4705,  4709,  4713,  4717,  4721,  4725,  4729,  4732,
    4735,  4739,  4743,  4746,  4750,  4756,  4761,  4768,  4772,  4778,
    4783,  4790,  4795,  4802,  4808,  4816,  4820,  4823,  4828,  4831,
    4835,  4839,  4844,  4848,  4853,  4857,  4862,  4868,  4875,  4882,
    4890,  4897,  4905,  4912,  4920,  4924,  4929,  4934,  4941,  4944,
    4948,  4953,  4955,  4959,  4962,  4965,  4969,  4973,  4977,  4981,
    4985,  4989,  4993,  4997,  5001,  5005,  5008,  5011,  5017,  5024,
    5031,  5039,  5043,  5048,  5050,  5052,  5055,  5060,  5062,  5064,
    5066,  5069,  5072,  5075,  5078,  5080,  5085,  5091,  5098,  5107,
    5114,  5121,  5127,  5129,  5131,  5136,  5138,  5143,  5145,  5150,
    5152,  5157,  5159,  5161,  5163,  5165,  5167,  5169,  5176,  5181,
    5186,  5191,  5196,  5203,  5209,  5215,  5221,  5226,  5233,  5238,
    5243,  5248,  5253,  5259,  5267,  5275,  5285,  5290,  5297,  5303,
    5311,  5319,  5327,  5330,  5334,  5338,  5342,  5347,  5348,  5353,
    5355,  5359,  5363,  5365,  5367,  5369,  5372,  5375,  5376,  5379,
    5380,  5382,  5386,  5390,  5393,  5396,  5397,  5404,  5406,  5407,
    5411,  5412,  5415,  5418,  5419,  5421,  5426,  5429,  5432,  5435,
    5440,  5444,  5450,  5452,  5454,  5456,  5458,  5460,  5462,  5464,
    5466,  5468,  5470,  5472,  5474,  5476,  5478,  5480,  5485,  5487,
    5492,  5494,  5499,  5501,  5504,  5506,  5509,  5511,  5515,  5517,
    5521,  5525,  5529,  5532,  5534,  5538,  5542,  5543,  5545,  5547,
    5549,  5551,  5553,  5555,  5557,  5559,  5564,  5568,  5571,  5575,
    5576,  5580,  5584,  5587,  5590,  5592,  5593,  5596,  5599,  5603,
    5606,  5608,  5610,  5614,  5620,  5622,  5625,  5630,  5633,  5634,
    5636,  5637,  5639,  5642,  5645,  5648,  5652,  5658,  5660,  5663,
    5664,  5667,  5669,  5670,  5672,  5674,  5676,  5680,  5684,  5686,
    5690,  5694,  5697,  5699,  5701,  5703,  5705,  5707,  5711,  5713,
    5716,  5718,  5722,  5724,  5726,  5728,  5730,  5732,  5734,  5736,
    5739,  5741,  5743,  5745,  5747,  5749,  5752,  5758,  5761,  5765,
    5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,  5790,
    5793,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,
    5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,
    5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,
    5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,
    5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,
    5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,  5910,  5912,
    5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,  5930,  5932,
    5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,  5950,  5952,
    5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,  5970,  5972,
    5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,  5990,  5992,
    5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,  6010,  6012,
    6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,  6032,
    6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,  6050,  6052,
    6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,  6070,  6072,
    6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,  6090,  6092,
    6094,  6096,  6098,  6100,  6102,  6104,  6106,  6108,  6110,  6112,
    6114,  6116,  6118,  6120,  6122,  6124,  6126,  6128,  6130,  6132,
    6134,  6136,  6138,  6140,  6142,  6144,  6146,  6148,  6150,  6152,
    6154,  6156,  6158,  6160,  6162,  6164,  6166,  6168,  6170,  6172,
    6174,  6176,  6178,  6180,  6182,  6184,  6186,  6188,  6190,  6192,
    6194,  6196,  6198,  6200,  6202,  6204,  6206,  6208,  6210,  6212,
    6214,  6216,  6218,  6220,  6222,  6224,  6226,  6228,  6230,  6232,
    6234,  6236,  6238,  6240,  6242,  6244,  6246,  6248,  6250,  6252,
    6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,  6270,  6272,
    6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,  6290,  6292,
    6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,  6310,  6312,
    6314,  6316,  6318,  6320,  6322,  6324,  6326,  6328,  6330,  6332,
    6334,  6336,  6338,  6340,  6342,  6344,  6346,  6348,  6350,  6352,
    6354,  6356,  6358,  6360,  6362,  6364,  6366,  6368,  6370,  6372,
    6374,  6376,  6378,  6380,  6382,  6384,  6386,  6388,  6390,  6392,
    6394,  6396,  6398,  6400,  6402,  6404,  6406,  6408,  6410,  6412,
    6414,  6416,  6418,  6420,  6422,  6424,  6426,  6428,  6430,  6432,
    6434,  6436,  6438,  6440,  6442,  6444,  6446,  6448,  6450,  6452,
    6454,  6456,  6458,  6460,  6462,  6464,  6466,  6468,  6470,  6472,
    6474,  6476,  6478,  6480,  6482,  6484,  6486,  6488,  6490,  6492,
    6494,  6496,  6498,  6500,  6502,  6504,  6506,  6508,  6510,  6512,
    6514,  6516,  6518,  6520,  6522,  6524,  6526,  6528,  6530,  6532,
    6534,  6536,  6538,  6540,  6542,  6544,  6546,  6548,  6550,  6552,
    6554,  6556,  6557,  6560,  6565,  6569,  6572,  6574,  6576,  6578,
    6580,  6582,  6583,  6592,  6593,  6608,  6611,  6617,  6621,  6624,
    6627,  6631,  6639,  6641,  6643,  6645,  6646,  6649,  6652,  6654,
    6655,  6657,  6661,  6663,  6666,  6667,  6670,  6671,  6674,  6675,
    6677,  6681,  6686,  6690,  6692,  6694,  6696,  6698,  6701,  6702,
    6705,  6710,  6711,  6714,  6717,  6720,  6722,  6724,  6732,  6736,
    6738,  6740,  6742,  6744,  6747,  6748,  6750,  6754,  6758,  6762,
    6766,  6767,  6772,  6778,  6784,  6785,  6787,  6789,  6791,  6793,
    6796,  6799,  6802,  6804,  6807,  6808,  6816,  6817,  6823,  6824,
    6829,  6832,  6835,  6836,  6839,  6841,  6843,  6845,  6847,  6849,
    6851,  6853,  6855,  6857,  6859,  6861,  6867,  6870,  6872,  6876,
    6879,  6882,  6886,  6887,  6893,  6895,  6896,  6902,  6905,  6908,
    6910,  6912,  6914,  6917,  6920,  6924,  6926,  6929,  6932,  6936,
    6940,  6945,  6948,  6950,  6953,  6955,  6957,  6960,  6963,  6967,
    6969,  6971,  6973,  6975,  6976,  6978,  6982,  6988,  6989,  6992,
    6993,  6995,  6998,  7002,  7005,  7007,  7009,  7011,  7012,  7014,
    7016,  7018,  7020,  7022,  7025,  7028,  7032,  7033,  7035,  7038,
    7040,  7045,  7050,  7051,  7053,  7055,  7059,  7061,  7063,  7065,
    7067,  7070,  7073,  7075,  7078,  7081,  7083,  7085,  7087,  7092,
    7097,  7102,  7104,  7105,  7109,  7113,  7118,  7120,  7124,  7128,
    7133,  7135,  7139,  7143,  7145,  7147,  7149,  7156,  7158,  7162,
    7166,  7173,  7175,  7179,  7183,  7185,  7187,  7190,  7193,  7195,
    7197,  7199,  7201,  7203,  7205,  7207,  7209,  7211,  7213,  7215,
    7217,  7219,  7221,  7223,  7225,  7230,  7235,  7237,  7239,  7244,
    7249,  7253,  7254,  7262,  7264,  7265,  7266,  7274,  7278,  7283,
    7287,  7289,  7291,  7293,  7296,  7300,  7306,  7309,  7315,  7318,
    7320,  7322,  7324,  7326,  7328,  7330,  7332,  7334,  7336,  7338,
    7340,  7342,  7344,  7346,  7348,  7350,  7352,  7354,  7356,  7358,
    7360,  7362,  7364,  7366,  7368,  7370,  7372,  7374,  7376,  7378,
    7380,  7382,  7384,  7386,  7388,  7390,  7392,  7394,  7396,  7398,
    7400,  7402,  7404,  7406,  7408,  7410,  7412,  7414,  7416,  7418,
    7420,  7422,  7424,  7426,  7428,  7430,  7432,  7434,  7436,  7438,
    7440,  7442,  7444,  7446,  7448,  7450,  7452,  7454,  7456,  7458,
    7460,  7462,  7464,  7466,  7468,  7470,  7472,  7474,  7476,  7478,
    7480,  7482,  7484,  7486,  7488,  7490,  7492,  7494,  7496,  7498,
    7500,  7502,  7504,  7506,  7508,  7510,  7512,  7514,  7518,  7520,
    7521,  7523,  7526,  7528,  7531,  7533,  7535,  7538,  7541,  7543,
    7545,  7547,  7549,  7551,  7553,  7555,  7557,  7559,  7561,  7563,
    7565,  7567,  7569,  7571,  7573,  7576,  7580,  7582,  7585,  7587,
    7591,  7593,  7597,  7599,  7601,  7603,  7605,  7607,  7609,  7611,
    7613,  7615,  7617,  7619,  7621,  7623,  7625,  7627,  7629,  7631,
    7633,  7635,  7637,  7639,  7641,  7643,  7645,  7647,  7649,  7651,
    7653,  7655,  7657,  7659,  7661,  7663,  7665,  7667,  7669,  7671,
    7673,  7675,  7677,  7679,  7681,  7683,  7685,  7687,  7689,  7691,
    7693,  7695,  7697,  7699,  7701,  7703,  7705,  7707,  7709,  7711,
    7713,  7715,  7717,  7719,  7722,  7726,  7729,  7733,  7735,  7739,
    7743,  7747,  7751,  7755,  7759,  7761,  7763,  7764,  7767,  7770,
    7772,  7774,  7777
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     506,     0,    -1,   973,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   975,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1117,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   977,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1054,    -1,   980,    -1,   997,
      -1,  1055,    -1,  1037,    -1,  1052,    -1,  1038,    -1,   998,
      -1,  1042,    -1,  1064,    -1,  1056,    -1,  1043,    -1,  1072,
      -1,  1074,    -1,  1067,    -1,  1059,    -1,  1075,    -1,  1078,
      -1,  1080,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1107,    -1,
     334,   307,    -1,   192,   334,  1107,    -1,   431,   334,  1107,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1107,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,  1088,   525,    -1,
    1088,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1107,    -1,   376,  1107,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1087,    -1,   529,
     499,  1088,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1107,    -1,  1109,    -1,   892,  1107,
     894,    -1,   892,   497,   965,   498,  1107,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1107,    -1,   170,    -1,    -1,
    1088,    -1,  1107,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1120,    -1,   390,   417,   472,  1120,    -1,   390,   421,   256,
     268,  1120,    -1,   390,   385,   104,  1120,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
    1088,   548,    -1,    91,   748,  1088,   187,   302,   307,    -1,
      91,   748,  1088,   387,   302,   307,    -1,    91,   748,  1088,
     387,   399,   967,    -1,    91,   748,  1088,   387,   402,  1088,
      -1,   187,   748,  1088,   549,    -1,    91,   748,  1088,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1090,   484,   657,    -1,  1090,    -1,  1090,   499,  1090,
     484,   657,    -1,  1090,   499,  1090,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1107,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1107,    -1,   307,   781,  1107,    -1,   152,    -1,   225,
      -1,   348,   781,  1107,    -1,   195,   781,  1107,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1107,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
    1088,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
    1088,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,  1088,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1106,    -1,   489,  1106,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1107,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1107,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1090,    -1,  1107,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1107,    -1,    -1,   449,  1107,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   639,   322,   640,    -1,
     246,    -1,   175,    -1,   437,    -1,   426,    -1,   210,   642,
     643,    -1,    -1,   188,    -1,    -1,   372,    -1,   398,    -1,
     645,    -1,   644,   500,   645,    -1,    -1,   965,    -1,  1106,
      -1,  1107,    -1,  1105,    -1,   480,    -1,  1088,    -1,   215,
     955,    -1,    -1,   648,    -1,   648,   649,    -1,   649,    -1,
     649,   648,    -1,    -1,   302,   172,    -1,   172,    -1,   241,
     231,    -1,   241,   173,    -1,   187,   423,   957,   317,   955,
     549,    -1,   187,   423,   229,   200,   957,   317,   955,   549,
      -1,   147,   100,   957,   126,   497,   896,   498,   647,    -1,
     187,   100,   957,   549,    -1,   147,    88,   963,   658,   654,
      -1,   147,    88,   963,   659,    -1,   147,   319,   739,   654,
      -1,   147,   428,   680,   654,    -1,   147,   428,   680,    -1,
     147,   428,   680,    98,   497,   870,   498,    -1,   147,   428,
     680,    98,   194,   497,   662,   498,    -1,   147,   415,   378,
     331,   680,   654,    -1,   147,   415,   378,   179,   680,   654,
      -1,   147,   415,   378,   413,   680,   654,    -1,   147,   415,
     378,   138,   680,   654,    -1,   497,   655,   498,    -1,   656,
      -1,   655,   500,   656,    -1,  1090,   484,   657,    -1,  1090,
      -1,   723,    -1,   971,    -1,   922,    -1,   604,    -1,  1107,
      -1,   497,   925,   498,    -1,   497,   490,   498,    -1,   497,
     660,   498,    -1,   661,    -1,   660,   500,   661,    -1,  1109,
     484,   657,    -1,  1107,    -1,   662,   500,  1107,    -1,   147,
     319,   128,   680,   666,   210,   428,   872,   439,   959,   667,
      98,   664,    -1,   665,    -1,   664,   500,   665,    -1,   319,
     965,   739,   668,    -1,   319,   965,   739,   738,   668,    -1,
     217,   965,   963,   715,    -1,   217,   965,   497,   925,   498,
     963,   715,    -1,   402,   872,    -1,   170,    -1,    -1,   205,
     680,    -1,    -1,   353,    -1,    -1,   147,   319,   205,   680,
     439,   959,    -1,    91,   319,   205,   680,   439,   959,    85,
     664,    -1,    91,   319,   205,   680,   439,   959,   187,   671,
      -1,   672,    -1,   671,   500,   672,    -1,   319,   965,   497,
     925,   498,    -1,   217,   965,   497,   925,   498,    -1,   187,
     319,   128,   680,   439,   959,   549,    -1,   187,   319,   128,
     229,   200,   680,   439,   959,   549,    -1,   187,   319,   205,
     680,   439,   959,   549,    -1,   187,   319,   205,   229,   200,
     680,   439,   959,   549,    -1,   187,   329,   114,   956,   549,
      -1,   352,   329,   114,   956,   419,   957,    -1,   187,   678,
     229,   200,   679,   549,    -1,   187,   678,   679,   549,    -1,
     410,    -1,   382,    -1,   450,    -1,   237,    -1,   428,    -1,
     185,    -1,   144,    -1,   376,    -1,   415,   378,   331,    -1,
     415,   378,   179,    -1,   415,   378,   413,    -1,   415,   378,
     138,    -1,   680,    -1,   679,   500,   680,    -1,  1088,    -1,
    1088,   681,    -1,   499,   960,    -1,   681,   499,   960,    -1,
     426,   833,   865,   683,   549,    -1,   143,   228,    -1,   364,
     228,    -1,    -1,   134,   317,   685,   680,   254,   686,    -1,
     134,   317,    88,   963,   658,   254,   686,    -1,   134,   317,
     217,   963,   715,   254,   686,    -1,   134,   317,   319,   739,
     738,   254,   686,    -1,   134,   317,   140,   957,   317,   680,
     254,   686,    -1,   134,   317,   374,   957,   317,   680,   254,
     686,    -1,   134,   317,   374,   957,   254,   686,    -1,   134,
     317,   423,   957,   317,   680,   254,   686,    -1,   134,   317,
     319,   128,   680,   439,   959,   254,   686,    -1,   134,   317,
     319,   205,   680,   439,   959,   254,   686,    -1,   134,   317,
     261,   311,   604,   254,   686,    -1,   134,   317,   120,   497,
     872,    98,   872,   498,   254,   686,    -1,   134,   317,   612,
     260,   680,   254,   686,    -1,   134,   317,   415,   378,   331,
     680,   254,   686,    -1,   134,   317,   415,   378,   179,   680,
     254,   686,    -1,   134,   317,   415,   378,   413,   680,   254,
     686,    -1,   134,   317,   415,   378,   138,   680,   254,   686,
      -1,   133,    -1,   164,    -1,   376,    -1,   237,    -1,   382,
      -1,   410,    -1,   185,    -1,   428,    -1,   450,    -1,   144,
      -1,   411,    -1,   370,    -1,  1107,    -1,   307,    -1,   206,
     688,   689,   957,    -1,   206,   957,    -1,   286,   688,   689,
     957,    -1,   286,   957,    -1,   206,   688,   689,   957,  1120,
      -1,   206,   688,   957,  1120,    -1,   206,   689,   957,  1120,
      -1,   206,   957,  1120,    -1,   206,   688,   957,    -1,   206,
     689,   957,    -1,   293,    -1,   344,    -1,   207,    -1,   262,
      -1,    82,   967,    -1,   357,   967,    -1,   967,    -1,    89,
      -1,   213,    -1,   213,   967,    -1,   213,    89,    -1,   105,
      -1,   105,   967,    -1,   105,    89,    -1,   215,    -1,   234,
      -1,   219,   692,   317,   695,   419,   696,   698,    -1,   368,
     692,   317,   695,   215,   696,   549,    -1,   368,   219,   320,
     210,   692,   317,   695,   215,   696,   549,    -1,   693,    -1,
      89,    -1,    89,   345,    -1,    89,   497,   581,   498,    -1,
      89,   345,   497,   581,   498,    -1,   694,    -1,   693,   500,
     694,    -1,   381,   580,    -1,   355,   580,    -1,   147,   580,
      -1,  1088,   580,    -1,   954,    -1,   410,   954,    -1,   382,
     954,    -1,   212,   163,   459,   956,    -1,   212,   384,   956,
      -1,   217,   699,    -1,   164,   956,    -1,   260,   956,    -1,
     376,   956,    -1,   411,   956,    -1,   697,    -1,   696,   500,
     697,    -1,   966,    -1,   222,   966,    -1,   456,   219,   320,
      -1,    -1,   700,    -1,   699,   500,   700,    -1,   963,   715,
      -1,   219,   693,   419,   956,   703,   704,    -1,   368,   693,
     215,   956,   704,   549,    -1,   368,    86,   320,   210,   693,
     215,   956,   704,   549,    -1,   456,    86,   320,    -1,    -1,
     220,   114,   966,    -1,    -1,   147,   706,   237,   961,   317,
     955,   707,   497,   708,   498,   552,   591,   868,    -1,   147,
     706,   237,   137,   961,   317,   955,   707,   497,   708,   498,
     552,   591,   868,    -1,   433,    -1,    -1,   439,   959,    -1,
      -1,   709,    -1,   708,   500,   709,    -1,  1088,   710,   711,
     712,    -1,   899,   710,   711,   712,    -1,   497,   896,   498,
     710,   711,   712,    -1,   680,    -1,   439,   680,    -1,    -1,
      99,    -1,   178,    -1,    -1,   473,    -1,   474,    -1,    -1,
     147,   714,   217,   963,   717,   367,   722,   725,   729,    -1,
     147,   714,   217,   963,   717,   367,   410,   497,   731,   498,
     725,   729,    -1,   147,   714,   217,   963,   717,   725,   729,
      -1,   322,   361,    -1,    -1,   497,   716,   498,    -1,   497,
     498,    -1,   719,    -1,   716,   500,   719,    -1,   497,   718,
     498,    -1,   497,   498,    -1,   724,    -1,   718,   500,   724,
      -1,   720,   721,   723,    -1,   721,   720,   723,    -1,   721,
     723,    -1,   720,   723,    -1,   723,    -1,   234,    -1,   324,
      -1,   243,    -1,   234,   324,    -1,   446,    -1,  1089,    -1,
     723,    -1,   872,    -1,  1089,   681,   492,   428,    -1,   388,
    1089,   681,   492,   428,    -1,   719,    -1,   719,   170,   896,
      -1,   719,   484,   896,    -1,   727,    -1,   725,   727,    -1,
     116,   317,   307,   244,    -1,   367,   307,   317,   307,   244,
      -1,   403,    -1,   232,    -1,   395,    -1,   451,    -1,   202,
     380,   174,    -1,   202,   380,   253,    -1,   380,   174,    -1,
     380,   253,    -1,   146,   604,    -1,   373,   604,    -1,   538,
      -1,    98,   728,    -1,   260,   536,    -1,   455,    -1,   726,
      -1,  1107,    -1,  1107,   500,  1107,    -1,   456,   654,    -1,
      -1,   721,   723,    -1,   730,    -1,   731,   500,   730,    -1,
      91,   217,   700,   733,   734,    -1,   726,    -1,   733,   726,
      -1,   365,    -1,    -1,   187,   217,   963,   715,   549,    -1,
     187,   217,   229,   200,   963,   715,   549,    -1,   187,    88,
     963,   658,   549,    -1,   187,    88,   229,   200,   963,   658,
     549,    -1,   187,   319,   739,   738,   549,    -1,   187,   319,
     229,   200,   739,   738,   549,    -1,   497,   872,   498,    -1,
     497,   872,   500,   872,   498,    -1,   497,   300,   500,   872,
     498,    -1,   497,   872,   500,   300,   498,    -1,   919,    -1,
    1088,   499,   739,    -1,   147,   120,   497,   872,    98,   872,
     498,   456,   217,   700,   741,    -1,   147,   120,   497,   872,
      98,   872,   498,   457,   217,   741,    -1,   147,   120,   497,
     872,    98,   872,   498,   456,   243,   741,    -1,    98,   233,
      -1,    98,   101,    -1,    -1,   187,   120,   743,   497,   872,
      98,   872,   498,   549,    -1,   229,   200,    -1,    -1,   356,
     745,   955,   746,    -1,   356,   409,   957,   746,    -1,   356,
     164,   957,   746,    -1,   237,    -1,   410,    -1,   211,    -1,
      -1,    91,    88,   963,   658,   359,   419,   957,    -1,    91,
     144,   680,   359,   419,   957,    -1,    91,   164,   958,   359,
     419,   958,    -1,    91,   217,   700,   359,   419,   957,    -1,
      91,   222,   966,   359,   419,   966,    -1,    91,   612,   260,
     957,   359,   419,   957,    -1,    91,   319,   128,   680,   439,
     959,   359,   419,   957,    -1,    91,   319,   205,   680,   439,
     959,   359,   419,   957,    -1,    91,   376,   957,   359,   419,
     957,    -1,    91,   410,   864,   359,   419,   957,    -1,    91,
     382,   955,   359,   419,   957,    -1,    91,   450,   955,   359,
     419,   957,    -1,    91,   237,   955,   359,   419,   957,    -1,
      91,   410,   864,   359,   748,   957,   419,   957,    -1,    91,
     423,   957,   317,   955,   359,   419,   957,    -1,    91,   370,
     966,   359,   419,   966,    -1,    91,   438,   966,   359,   419,
     966,    -1,    91,   411,   957,   359,   419,   957,    -1,    91,
     415,   378,   331,   680,   359,   419,   957,    -1,    91,   415,
     378,   179,   680,   359,   419,   957,    -1,    91,   415,   378,
     413,   680,   359,   419,   957,    -1,    91,   415,   378,   138,
     680,   359,   419,   957,    -1,    91,   428,   680,   359,   419,
     957,    -1,   133,    -1,    -1,   387,   163,    -1,    -1,    91,
      88,   963,   658,   387,   376,   957,    -1,    91,   185,   680,
     387,   376,   957,    -1,    91,   217,   700,   387,   376,   957,
      -1,    91,   410,   864,   387,   376,   957,    -1,    91,   382,
     955,   387,   376,   957,    -1,    91,   450,   955,   387,   376,
     957,    -1,    91,   428,   680,   387,   376,   957,    -1,    91,
      88,   963,   658,   330,   419,   966,    -1,    91,   144,   680,
     330,   419,   966,    -1,    91,   164,   958,   330,   419,   966,
      -1,    91,   185,   680,   330,   419,   966,    -1,    91,   217,
     700,   330,   419,   966,    -1,    91,   612,   260,   957,   330,
     419,   966,    -1,    91,   319,   739,   738,   330,   419,   966,
      -1,    91,   319,   128,   680,   439,   959,   330,   419,   966,
      -1,    91,   319,   205,   680,   439,   959,   330,   419,   966,
      -1,    91,   376,   957,   330,   419,   966,    -1,    91,   428,
     680,   330,   419,   966,    -1,    91,   411,   957,   330,   419,
     966,    -1,    91,   415,   378,   179,   680,   330,   419,   966,
      -1,    91,   415,   378,   138,   680,   330,   419,   966,    -1,
      91,   212,   163,   459,   957,   330,   419,   966,    -1,    91,
     384,   957,   330,   419,   966,    -1,   303,    -1,   754,    -1,
     497,   753,   498,    -1,   753,   501,   755,    -1,   755,    -1,
     823,    -1,   802,    -1,   813,    -1,   807,    -1,   759,    -1,
     754,    -1,    -1,   381,    -1,   437,    -1,   175,    -1,   246,
      -1,   247,    -1,    90,    -1,    -1,   187,   374,   957,   317,
     955,   549,    -1,   187,   374,   229,   200,   957,   317,   955,
     549,    -1,   304,  1088,    -1,   271,  1088,    -1,   435,  1088,
      -1,   435,   490,    -1,    81,   763,    -1,   107,   763,   766,
      -1,   397,   421,   766,    -1,   135,   763,    -1,   193,   763,
      -1,   371,   763,    -1,   375,  1088,    -1,   358,   375,  1088,
      -1,   358,  1088,    -1,   371,   763,   419,   375,  1088,    -1,
     371,   763,   419,  1088,    -1,   341,   421,  1107,    -1,   135,
     342,  1107,    -1,   371,   342,  1107,    -1,   458,    -1,   421,
      -1,    -1,   256,   268,   532,    -1,   350,   318,    -1,   350,
     460,    -1,   764,    -1,   765,   500,   764,    -1,   765,   764,
      -1,   765,    -1,    -1,   147,   566,   450,   955,   580,    98,
     823,   768,    -1,   147,   322,   361,   566,   450,   955,   580,
      98,   823,   768,    -1,   456,   126,   320,    -1,   456,   118,
     126,   320,    -1,   456,   273,   126,   320,    -1,    -1,   272,
     962,    -1,   147,   164,   958,   509,   771,    -1,   771,   772,
      -1,    -1,   411,   773,   957,    -1,   411,   773,   170,    -1,
     276,   773,  1107,    -1,   276,   773,   170,    -1,   413,   773,
     957,    -1,   413,   773,   170,    -1,   191,   773,  1107,    -1,
     191,   773,   965,    -1,   191,   773,   170,    -1,   263,   773,
    1107,    -1,   263,   773,   170,    -1,   264,   773,  1107,    -1,
     264,   773,   170,    -1,   139,   270,   773,   967,    -1,   330,
     773,   957,    -1,   330,   773,   170,    -1,   484,    -1,    -1,
      91,   164,   958,   509,   776,    -1,    91,   164,   958,   387,
     411,   957,    -1,    91,   164,   958,   538,    -1,   776,   777,
      -1,    -1,   139,   270,   773,   967,    -1,   187,   164,   958,
      -1,   187,   164,   229,   200,   958,    -1,   147,   185,   680,
     781,   872,   571,    -1,    91,   185,   680,   548,    -1,    91,
     185,   680,   187,   302,   307,    -1,    91,   185,   680,   387,
     302,   307,    -1,    91,   185,   680,    85,   578,    -1,    91,
     185,   680,   187,   140,   957,   549,    -1,    98,    -1,    -1,
      91,   415,   378,   179,   680,   654,    -1,    91,   415,   378,
     138,   680,    85,   279,   210,   956,   456,   679,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   456,   679,
      -1,    91,   415,   378,   138,   680,    91,   279,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,    91,   279,
     210,   956,   361,   680,   456,   680,    -1,    91,   415,   378,
     138,   680,   187,   279,   210,   956,    -1,    91,   415,   378,
     138,   680,   187,   279,   229,   200,   210,   956,    -1,   147,
     666,   144,   680,   210,  1107,   419,  1107,   215,   680,    -1,
     130,   790,   955,   786,    -1,   130,   790,    -1,   130,   790,
     961,   317,   955,    -1,   439,   961,    -1,    -1,   440,   791,
     792,   790,    -1,   440,   791,   792,   790,   955,    -1,   440,
     791,   792,   790,   788,    -1,   789,   790,    -1,   789,   790,
     955,   793,    -1,    94,    -1,    93,    -1,   448,    -1,    -1,
     216,    -1,    -1,   214,    -1,    -1,   497,   956,   498,    -1,
      -1,   201,   796,   790,   795,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   820,    -1,   975,    -1,   800,    -1,
     789,    -1,    -1,   341,   996,   798,    98,   799,    -1,   341,
     996,   215,  1041,    -1,   497,   925,   498,    -1,    -1,   823,
      -1,   802,    -1,   813,    -1,   807,    -1,   199,   996,   801,
    1119,    -1,   147,   566,   410,   593,    98,   199,   996,   801,
      -1,   497,   924,   498,    -1,    -1,   246,   252,   955,   803,
     806,    -1,   823,    -1,   497,   804,   498,   823,    -1,   170,
     444,    -1,   805,    -1,   804,   500,   805,    -1,  1088,   946,
      -1,   366,   951,  1120,    -1,    -1,   175,   215,   866,   808,
     869,   806,    -1,   439,   857,    -1,    -1,   277,   833,   865,
     810,   812,    -1,   234,   811,   284,    -1,    -1,    83,   389,
      -1,   372,   389,    -1,   372,   198,    -1,   389,   437,   198,
      -1,   389,    -1,   389,   372,   198,    -1,   198,    -1,    83,
     198,    -1,   306,    -1,    -1,   437,   866,   387,   814,   856,
     869,   806,    -1,   815,    -1,   814,   500,   815,    -1,   816,
      -1,   817,    -1,   818,   484,   948,    -1,   497,   819,   498,
     484,   950,    -1,  1088,   946,    -1,   818,    -1,   819,   500,
     818,    -1,   169,   957,   821,   161,   822,   210,   823,    -1,
      -1,   821,   294,   377,    -1,   821,   377,    -1,   821,   110,
      -1,   821,   245,    -1,    -1,   456,   226,    -1,   457,   226,
      -1,   825,    -1,   824,    -1,   497,   825,   498,    -1,   497,
     824,   498,    -1,   827,    -1,   826,   837,    -1,   826,   836,
     850,   841,    -1,   826,   836,   840,   851,    -1,   828,   826,
      -1,   828,   826,   837,    -1,   828,   826,   836,   850,   841,
      -1,   828,   826,   836,   840,   851,    -1,   827,    -1,   824,
      -1,   381,   835,   951,   831,   856,   868,   848,   849,   907,
      -1,   855,    -1,   410,   864,    -1,   826,   432,   834,   826,
      -1,   826,   250,   834,   826,    -1,   826,   196,   834,   826,
      -1,   456,   829,    -1,   456,   354,   829,    -1,   830,    -1,
     829,   500,   830,    -1,   957,   793,    98,   824,    -1,   252,
     832,    -1,  1120,    -1,    -1,   414,   833,   955,    -1,   412,
     833,   955,    -1,   273,   414,   833,   955,    -1,   273,   412,
     833,   955,    -1,   218,   414,   833,   955,    -1,   218,   412,
     833,   955,    -1,   410,   955,    -1,   955,    -1,   410,    -1,
      -1,    89,    -1,   182,    -1,    -1,   182,    -1,   182,   317,
     497,   924,   498,    -1,    89,    -1,    -1,   837,    -1,    -1,
     323,   114,   838,    -1,   839,    -1,   838,   500,   839,    -1,
     896,   439,   922,   712,    -1,   896,   711,   712,    -1,   270,
     842,   314,   844,    -1,   314,   844,   270,   842,    -1,   270,
     842,    -1,   314,   844,    -1,   270,   842,   500,   844,    -1,
     314,   845,   846,    -1,   206,   847,   843,   846,   318,    -1,
     314,   845,   846,   206,   847,   843,   846,   318,    -1,   840,
      -1,    -1,   896,    -1,    89,    -1,   967,    -1,   497,   896,
     498,    -1,    -1,   896,    -1,   898,    -1,   372,    -1,   373,
      -1,   207,    -1,   293,    -1,   222,   114,   924,    -1,    -1,
     224,   896,    -1,    -1,   852,    -1,   210,   350,   318,    -1,
     850,    -1,    -1,   853,    -1,   852,   853,    -1,   210,   437,
     854,   812,    -1,   210,   389,   854,   812,    -1,   312,   954,
      -1,    -1,   444,   950,    -1,   855,   500,   950,    -1,   215,
     857,    -1,    -1,   858,    -1,   857,   500,   858,    -1,   864,
      -1,   864,   860,    -1,   867,    -1,   867,   860,    -1,   867,
      98,   497,   870,   498,    -1,   867,    98,  1088,   497,   870,
     498,    -1,   867,  1088,   497,   870,   498,    -1,   824,    -1,
     824,   860,    -1,   859,    -1,   497,   859,   498,   860,    -1,
     497,   859,   498,    -1,   858,   151,   257,   858,    -1,   858,
     861,   257,   858,   863,    -1,   858,   257,   858,   863,    -1,
     858,   290,   861,   257,   858,    -1,   858,   290,   257,   858,
      -1,    98,  1088,   497,   956,   498,    -1,    98,  1088,    -1,
    1088,   497,   956,   498,    -1,  1088,    -1,   216,   862,    -1,
     267,   862,    -1,   369,   862,    -1,   242,    -1,   325,    -1,
      -1,   439,   497,   956,   498,    -1,   317,   896,    -1,   955,
      -1,   955,   490,    -1,   318,   955,    -1,   318,   497,   955,
     498,    -1,   864,    -1,   865,   500,   864,    -1,   864,    -1,
     864,  1088,    -1,   864,    98,  1088,    -1,   899,    -1,   453,
     896,    -1,    -1,   453,   896,    -1,   453,   153,   312,   957,
      -1,   453,   153,   312,  1104,    -1,    -1,   871,    -1,   870,
     500,   871,    -1,  1088,   872,    -1,   874,   873,    -1,   388,
     874,   873,    -1,   874,    97,   495,   965,   496,    -1,   388,
     874,    97,   495,   965,   496,    -1,   874,    97,    -1,   388,
     874,    97,    -1,   873,   495,   496,    -1,   873,   495,  1118,
     496,    -1,    -1,   876,    -1,   878,    -1,   880,    -1,   884,
      -1,   891,    -1,   892,   894,    -1,   892,   497,   965,   498,
     894,    -1,   878,    -1,   881,    -1,   885,    -1,   891,    -1,
    1089,   877,    -1,  1089,   681,   877,    -1,   497,   924,   498,
      -1,    -1,   248,    -1,   249,    -1,   393,    -1,   109,    -1,
     351,    -1,   208,   879,    -1,   186,   339,    -1,   168,   877,
      -1,   167,   877,    -1,   310,   877,    -1,   112,    -1,   497,
     965,   498,    -1,    -1,   882,    -1,   883,    -1,   882,    -1,
     883,    -1,   111,   889,   497,   924,   498,    -1,   111,   889,
      -1,   886,    -1,   887,    -1,   886,    -1,   887,    -1,   888,
     497,   965,   498,   890,    -1,   888,   890,    -1,   124,   889,
      -1,   123,   889,    -1,   445,    -1,   289,   124,   889,    -1,
     289,   123,   889,    -1,   291,   889,    -1,   447,    -1,    -1,
     124,   387,  1088,    -1,    -1,   418,   497,   965,   498,   893,
      -1,   418,   893,    -1,   417,   497,   965,   498,   893,    -1,
     417,   893,    -1,   251,    -1,   475,   472,    -1,   457,   417,
     472,    -1,    -1,   470,    -1,   285,    -1,   165,    -1,   227,
      -1,   282,    -1,   895,    -1,   470,   419,   285,    -1,   165,
     419,   227,    -1,   165,   419,   282,    -1,   165,   419,   895,
      -1,   227,   419,   282,    -1,   227,   419,   895,    -1,   282,
     419,   895,    -1,    -1,   379,    -1,   379,   497,   965,   498,
      -1,   898,    -1,   896,    71,   872,    -1,   896,   103,   417,
     472,   896,    -1,   488,   896,    -1,   489,   896,    -1,   896,
     488,   896,    -1,   896,   489,   896,    -1,   896,   490,   896,
      -1,   896,   491,   896,    -1,   896,   492,   896,    -1,   896,
     493,   896,    -1,   896,   485,   896,    -1,   896,   486,   896,
      -1,   896,   484,   896,    -1,   896,   921,   896,    -1,   921,
     896,    -1,   896,   921,    -1,   896,    95,   896,    -1,   896,
     322,   896,    -1,   302,   896,    -1,   896,   269,   896,    -1,
     896,   269,   896,   195,   896,    -1,   896,   302,   269,   896,
      -1,   896,   302,   269,   896,   195,   896,    -1,   896,   230,
     896,    -1,   896,   230,   896,   195,   896,    -1,   896,   302,
     230,   896,    -1,   896,   302,   230,   896,   195,   896,    -1,
     896,   391,   419,   896,    -1,   896,   391,   419,   896,   195,
     896,    -1,   896,   302,   391,   419,   896,    -1,   896,   302,
     391,   419,   896,   195,   896,    -1,   896,   254,   307,    -1,
     896,   255,    -1,   896,   254,   302,   307,    -1,   896,   305,
      -1,   917,   327,   917,    -1,   896,   254,   425,    -1,   896,
     254,   302,   425,    -1,   896,   254,   204,    -1,   896,   254,
     302,   204,    -1,   896,   254,   434,    -1,   896,   254,   302,
     434,    -1,   896,   254,   182,   215,   896,    -1,   896,   254,
     302,   182,   215,   896,    -1,   896,   254,   312,   497,   925,
     498,    -1,   896,   254,   302,   312,   497,   925,   498,    -1,
     896,   108,   947,   897,    95,   897,    -1,   896,   302,   108,
     947,   897,    95,   897,    -1,   896,   108,   407,   897,    95,
     897,    -1,   896,   302,   108,   407,   897,    95,   897,    -1,
     896,   234,   937,    -1,   896,   302,   234,   937,    -1,   896,
     923,   918,   824,    -1,   896,   923,   918,   497,   896,   498,
      -1,   433,   824,    -1,   896,   254,   184,    -1,   896,   254,
     302,   184,    -1,   898,    -1,   897,    71,   872,    -1,   488,
     897,    -1,   489,   897,    -1,   897,   488,   897,    -1,   897,
     489,   897,    -1,   897,   490,   897,    -1,   897,   491,   897,
      -1,   897,   492,   897,    -1,   897,   493,   897,    -1,   897,
     485,   897,    -1,   897,   486,   897,    -1,   897,   484,   897,
      -1,   897,   921,   897,    -1,   921,   897,    -1,   897,   921,
      -1,   897,   254,   182,   215,   897,    -1,   897,   254,   302,
     182,   215,   897,    -1,   897,   254,   312,   497,   925,   498,
      -1,   897,   254,   302,   312,   497,   925,   498,    -1,   897,
     254,   184,    -1,   897,   254,   302,   184,    -1,   943,    -1,
     964,    -1,  1104,   946,    -1,   497,   896,   498,   946,    -1,
     938,    -1,   899,    -1,   824,    -1,   824,   945,    -1,   200,
     824,    -1,    97,   824,    -1,    97,   926,    -1,   917,    -1,
     963,   497,   498,   910,    -1,   963,   497,   924,   498,   910,
      -1,   963,   497,   446,   896,   498,   910,    -1,   963,   497,
     924,   500,   446,   896,   498,   910,    -1,   963,   497,    89,
     924,   498,   910,    -1,   963,   497,   182,   924,   498,   910,
      -1,   963,   497,   490,   498,   910,    -1,   155,    -1,   158,
      -1,   158,   497,   965,   498,    -1,   159,    -1,   159,   497,
     965,   498,    -1,   274,    -1,   274,   497,   965,   498,    -1,
     275,    -1,   275,   497,   965,   498,    -1,   156,    -1,   160,
      -1,   386,    -1,   438,    -1,   154,    -1,   157,    -1,   120,
     497,   896,    98,   872,   498,    -1,   203,   497,   928,   498,
      -1,   328,   497,   930,   498,    -1,   337,   497,   932,   498,
      -1,   405,   497,   933,   498,    -1,   422,   497,   896,    98,
     872,   498,    -1,   424,   497,   113,   936,   498,    -1,   424,
     497,   265,   936,   498,    -1,   424,   497,   420,   936,   498,
      -1,   424,   497,   936,   498,    -1,   308,   497,   896,   500,
     896,   498,    -1,   131,   497,   924,   498,    -1,   221,   497,
     924,   498,    -1,   266,   497,   924,   498,    -1,   463,   497,
     924,   498,    -1,   464,   497,   287,  1090,   498,    -1,   464,
     497,   287,  1090,   500,   902,   498,    -1,   464,   497,   287,
    1090,   500,   924,   498,    -1,   464,   497,   287,  1090,   500,
     902,   500,   924,   498,    -1,   465,   497,   903,   498,    -1,
     466,   497,   905,   896,   906,   498,    -1,   467,   497,   287,
    1090,   498,    -1,   467,   497,   287,  1090,   500,   896,   498,
      -1,   468,   497,   896,   500,   900,   901,   498,    -1,   469,
     497,   905,   896,    98,   874,   498,    -1,   449,   896,    -1,
     449,   294,   443,    -1,   500,   396,   471,    -1,   500,   396,
     294,    -1,   500,   396,   294,   443,    -1,    -1,   462,   497,
     903,   498,    -1,   904,    -1,   903,   500,   904,    -1,   896,
      98,  1090,    -1,   896,    -1,   184,    -1,   142,    -1,   340,
     454,    -1,   404,   454,    -1,    -1,   455,   908,    -1,    -1,
     909,    -1,   908,   500,   909,    -1,  1088,    98,   911,    -1,
     326,   911,    -1,   326,  1088,    -1,    -1,   497,   912,   913,
     836,   914,   498,    -1,  1088,    -1,    -1,   333,   114,   924,
      -1,    -1,   349,   915,    -1,   373,   915,    -1,    -1,   916,
      -1,   108,   916,    95,   916,    -1,   429,   338,    -1,   429,
     209,    -1,   153,   372,    -1,   372,   497,   924,   498,    -1,
     372,   497,   498,    -1,   497,   924,   500,   896,   498,    -1,
      96,    -1,   394,    -1,    89,    -1,   481,    -1,   920,    -1,
     488,    -1,   489,    -1,   490,    -1,   491,    -1,   492,    -1,
     493,    -1,   485,    -1,   486,    -1,   484,    -1,   481,    -1,
     319,   497,   739,   498,    -1,   919,    -1,   319,   497,   739,
     498,    -1,   919,    -1,   319,   497,   739,   498,    -1,   269,
      -1,   302,   269,    -1,   230,    -1,   302,   230,    -1,   896,
      -1,   924,   500,   896,    -1,   872,    -1,   925,   500,   872,
      -1,   495,   924,   496,    -1,   495,   927,   496,    -1,   495,
     496,    -1,   926,    -1,   927,   500,   926,    -1,   929,   215,
     896,    -1,    -1,  1109,    -1,   470,    -1,   285,    -1,   165,
      -1,   227,    -1,   282,    -1,   379,    -1,  1107,    -1,   896,
     931,   934,   935,    -1,   896,   931,   934,    -1,   335,   896,
      -1,   897,   234,   897,    -1,    -1,   896,   934,   935,    -1,
     896,   935,   934,    -1,   896,   934,    -1,   896,   935,    -1,
     924,    -1,    -1,   215,   896,    -1,   210,   896,    -1,   896,
     215,   924,    -1,   215,   924,    -1,   924,    -1,   824,    -1,
     497,   924,   498,    -1,   119,   942,   939,   941,   193,    -1,
     940,    -1,   939,   940,    -1,   452,   896,   416,   896,    -1,
     189,   896,    -1,    -1,   896,    -1,    -1,   953,    -1,   953,
     945,    -1,   499,   960,    -1,   499,   490,    -1,   495,   896,
     496,    -1,   495,   896,   502,   896,   496,    -1,   944,    -1,
     945,   944,    -1,    -1,   946,   944,    -1,   102,    -1,    -1,
     896,    -1,   170,    -1,   948,    -1,   949,   500,   948,    -1,
     497,   949,   498,    -1,   952,    -1,   951,   500,   952,    -1,
     896,    98,  1090,    -1,   896,  1109,    -1,   896,    -1,   490,
      -1,   972,    -1,  1088,    -1,   955,    -1,   954,   500,   955,
      -1,   953,    -1,   953,   945,    -1,   957,    -1,   956,   500,
     957,    -1,  1088,    -1,  1088,    -1,  1088,    -1,  1090,    -1,
    1088,    -1,  1107,    -1,  1089,    -1,   953,   945,    -1,   965,
      -1,  1106,    -1,  1107,    -1,  1105,    -1,   480,    -1,   963,
    1107,    -1,   963,   497,   924,   498,  1107,    -1,   875,  1107,
      -1,   892,  1107,   894,    -1,   892,   497,   965,   498,  1107,
     894,    -1,   425,    -1,   204,    -1,   307,    -1,  1101,    -1,
    1100,    -1,   482,    -1,  1088,    -1,   965,    -1,  1101,    -1,
     488,   965,    -1,   489,   965,    -1,    81,    -1,    82,    -1,
      83,    -1,    84,    -1,    85,    -1,    86,    -1,    87,    -1,
      88,    -1,    90,    -1,    91,    -1,    92,    -1,   100,    -1,
     101,    -1,   103,    -1,   105,    -1,   106,    -1,   107,    -1,
     114,    -1,   115,    -1,   116,    -1,   117,    -1,   118,    -1,
     121,    -1,   122,    -1,   125,    -1,   127,    -1,   128,    -1,
     129,    -1,   130,    -1,   134,    -1,   135,    -1,   136,    -1,
     137,    -1,   138,    -1,   141,    -1,   142,    -1,   143,    -1,
     144,    -1,   145,    -1,   146,    -1,   148,    -1,   149,    -1,
     150,    -1,   152,    -1,   161,    -1,   162,    -1,   163,    -1,
     164,    -1,   166,    -1,   169,    -1,   171,    -1,   173,    -1,
     174,    -1,   175,    -1,   176,    -1,   177,    -1,   179,    -1,
     180,    -1,   181,    -1,   184,    -1,   185,    -1,   186,    -1,
     187,    -1,   188,    -1,   190,    -1,   191,    -1,   192,    -1,
     194,    -1,   195,    -1,   197,    -1,   198,    -1,   199,    -1,
     201,    -1,   202,    -1,   205,    -1,   207,    -1,   209,    -1,
     211,    -1,   213,    -1,   217,    -1,   218,    -1,   220,    -1,
     223,    -1,   225,    -1,   226,    -1,   228,    -1,   229,    -1,
     231,    -1,   232,    -1,   233,    -1,   235,    -1,   236,    -1,
     237,    -1,   238,    -1,   239,    -1,   240,    -1,   245,    -1,
     246,    -1,   247,    -1,   253,    -1,   256,    -1,   258,    -1,
     259,    -1,   260,    -1,   261,    -1,   262,    -1,   263,    -1,
     264,    -1,   268,    -1,   271,    -1,   272,    -1,   273,    -1,
     276,    -1,   277,    -1,   278,    -1,   279,    -1,   280,    -1,
     281,    -1,   283,    -1,   284,    -1,   286,    -1,   287,    -1,
     288,    -1,   293,    -1,   294,    -1,   295,    -1,   296,    -1,
     297,    -1,   298,    -1,   299,    -1,   301,    -1,   303,    -1,
     304,    -1,   306,    -1,   309,    -1,   311,    -1,   312,    -1,
     315,    -1,   319,    -1,   320,    -1,   321,    -1,   329,    -1,
     330,    -1,   331,    -1,   332,    -1,   333,    -1,   334,    -1,
     336,    -1,   338,    -1,   341,    -1,   342,    -1,   340,    -1,
     344,    -1,   345,    -1,   346,    -1,   347,    -1,   348,    -1,
     349,    -1,   350,    -1,   352,    -1,   353,    -1,   354,    -1,
     356,    -1,   357,    -1,   358,    -1,   359,    -1,   360,    -1,
     361,    -1,   362,    -1,   363,    -1,   364,    -1,   365,    -1,
     367,    -1,   368,    -1,   370,    -1,   371,    -1,   373,    -1,
     374,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     380,    -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,
     387,    -1,   389,    -1,   390,    -1,   392,    -1,   395,    -1,
     396,    -1,   397,    -1,   398,    -1,   399,    -1,   400,    -1,
     401,    -1,   402,    -1,   403,    -1,   404,    -1,   406,    -1,
     408,    -1,   409,    -1,   411,    -1,   412,    -1,   413,    -1,
     414,    -1,   415,    -1,   421,    -1,   423,    -1,   426,    -1,
     427,    -1,   428,    -1,   429,    -1,   430,    -1,   431,    -1,
     434,    -1,   435,    -1,   436,    -1,   437,    -1,   440,    -1,
     441,    -1,   442,    -1,   443,    -1,   447,    -1,   449,    -1,
     450,    -1,   451,    -1,   454,    -1,   457,    -1,   458,    -1,
     459,    -1,   460,    -1,   461,    -1,   471,    -1,   472,    -1,
     109,    -1,   111,    -1,   112,    -1,   124,    -1,   131,    -1,
     167,    -1,   168,    -1,   200,    -1,   203,    -1,   208,    -1,
     221,    -1,   243,    -1,   249,    -1,   251,    -1,   266,    -1,
     289,    -1,   291,    -1,   300,    -1,   308,    -1,   310,    -1,
     324,    -1,   328,    -1,   337,    -1,   339,    -1,   351,    -1,
     372,    -1,   388,    -1,   393,    -1,   405,    -1,   417,    -1,
     418,    -1,   422,    -1,   424,    -1,   445,    -1,   462,    -1,
     463,    -1,   464,    -1,   465,    -1,   466,    -1,   467,    -1,
     468,    -1,   469,    -1,   104,    -1,   108,    -1,   110,    -1,
     151,    -1,   157,    -1,   214,    -1,   216,    -1,   230,    -1,
     242,    -1,   254,    -1,   255,    -1,   257,    -1,   267,    -1,
     269,    -1,   290,    -1,   305,    -1,   325,    -1,   326,    -1,
     327,    -1,   369,    -1,   391,    -1,   448,    -1,    89,    -1,
      93,    -1,    94,    -1,    95,    -1,    96,    -1,    97,    -1,
      98,    -1,    99,    -1,   102,    -1,   113,    -1,   119,    -1,
     120,    -1,   126,    -1,   132,    -1,   133,    -1,   140,    -1,
     147,    -1,   154,    -1,   155,    -1,   156,    -1,   158,    -1,
     159,    -1,   160,    -1,   170,    -1,   172,    -1,   178,    -1,
     182,    -1,   183,    -1,   189,    -1,   193,    -1,   196,    -1,
     204,    -1,   206,    -1,   210,    -1,   212,    -1,   215,    -1,
     219,    -1,   222,    -1,   224,    -1,   234,    -1,   241,    -1,
     250,    -1,   252,    -1,   265,    -1,   270,    -1,   274,    -1,
     275,    -1,   292,    -1,   302,    -1,   307,    -1,   313,    -1,
     314,    -1,   316,    -1,   317,    -1,   318,    -1,   322,    -1,
     323,    -1,   335,    -1,   343,    -1,   355,    -1,   366,    -1,
     381,    -1,   386,    -1,   394,    -1,   407,    -1,   410,    -1,
     416,    -1,   420,    -1,   425,    -1,   433,    -1,   438,    -1,
     439,    -1,   446,    -1,   452,    -1,   453,    -1,   455,    -1,
     456,    -1,   316,    -1,   292,    -1,    -1,   973,   974,    -1,
    1097,   979,   507,   501,    -1,  1097,   507,   501,    -1,  1097,
     999,    -1,  1004,    -1,  1115,    -1,    74,    -1,   503,    -1,
     504,    -1,    -1,   147,   566,   410,   593,    98,   976,   823,
     597,    -1,    -1,   147,   714,   374,   957,    98,   978,   317,
     756,   419,   955,   868,   183,   757,   752,    -1,   103,  1040,
      -1,     9,   419,   981,   988,   989,    -1,     9,   419,   170,
      -1,     9,   990,    -1,   164,   981,    -1,   982,   985,   987,
      -1,   983,   502,   984,   987,   491,   982,   993,    -1,   992,
      -1,  1107,    -1,   958,    -1,    -1,  1109,  1103,    -1,   481,
     986,    -1,   984,    -1,    -1,  1088,    -1,  1088,   499,   986,
      -1,    75,    -1,   502,   965,    -1,    -1,    98,  1040,    -1,
      -1,   438,   990,    -1,    -1,   991,    -1,   991,   491,   991,
      -1,   991,    21,   114,   991,    -1,   991,   439,   991,    -1,
     966,    -1,  1107,    -1,  1101,    -1,  1103,    -1,   481,   994,
      -1,    -1,  1088,   995,    -1,  1088,   995,   481,   994,    -1,
      -1,   484,   965,    -1,   484,  1109,    -1,   484,  1101,    -1,
     957,    -1,   992,    -1,   169,   957,   821,   161,   822,   210,
     996,    -1,   199,   231,  1041,    -1,  1000,    -1,  1011,    -1,
    1013,    -1,   604,    -1,   500,   604,    -1,    -1,   894,    -1,
     470,   419,   282,    -1,   470,   419,   379,    -1,   165,   419,
     165,    -1,   285,   419,   285,    -1,    -1,  1006,  1005,  1008,
    1007,    -1,  1097,   107,   169,    34,   501,    -1,  1097,   193,
     169,    34,   501,    -1,    -1,  1009,    -1,    74,    -1,  1013,
      -1,  1011,    -1,  1009,  1013,    -1,  1009,  1011,    -1,  1009,
      74,    -1,  1013,    -1,  1010,  1013,    -1,    -1,    70,  1012,
    1020,  1036,  1092,   873,   501,    -1,    -1,  1017,  1020,  1014,
    1033,   501,    -1,    -1,  1020,  1015,  1033,   501,    -1,  1023,
     501,    -1,   502,   965,    -1,    -1,  1018,  1019,    -1,  1018,
      -1,  1019,    -1,    56,    -1,    67,    -1,    65,    -1,    50,
      -1,    51,    -1,    69,    -1,  1029,    -1,  1025,    -1,  1021,
      -1,  1092,   497,  1001,  1002,   498,    -1,  1092,  1003,    -1,
    1027,    -1,   194,  1086,  1022,    -1,   194,  1022,    -1,   194,
    1086,    -1,   503,  1113,   504,    -1,    -1,  1027,  1024,   503,
    1010,   504,    -1,  1023,    -1,    -1,  1028,  1026,   503,  1010,
     504,    -1,    43,  1086,    -1,   432,  1086,    -1,    43,    -1,
     432,    -1,  1030,    -1,  1032,  1031,    -1,    44,    35,    -1,
      44,    35,   248,    -1,    44,    -1,    44,   248,    -1,    44,
      25,    -1,    44,    25,   248,    -1,    44,    25,    25,    -1,
      44,    25,    25,   248,    -1,    44,   123,    -1,    35,    -1,
      35,   248,    -1,   248,    -1,    25,    -1,    25,   248,    -1,
      25,    25,    -1,    25,    25,   248,    -1,     5,    -1,   123,
      -1,   186,    -1,    36,    -1,    -1,  1034,    -1,  1033,   500,
    1034,    -1,  1036,  1091,   873,  1016,  1035,    -1,    -1,   484,
    1114,    -1,    -1,   490,    -1,   490,   490,    -1,   169,   398,
    1109,    -1,    15,  1039,    -1,  1040,    -1,   153,    -1,    89,
      -1,    -1,   958,    -1,   170,    -1,   992,    -1,   992,    -1,
      72,    -1,    17,   957,    -1,    17,    89,    -1,    28,   957,
    1044,    -1,    -1,  1045,    -1,   439,  1049,    -1,  1046,    -1,
     439,  1048,    14,  1110,    -1,   252,  1048,    14,  1110,    -1,
      -1,    37,    -1,  1050,    -1,  1050,   500,  1049,    -1,  1051,
      -1,  1101,    -1,  1100,    -1,   965,    -1,   488,   965,    -1,
     489,   965,    -1,  1106,    -1,   488,  1106,    -1,   489,  1106,
      -1,  1107,    -1,  1105,    -1,  1108,    -1,    13,   244,   957,
    1046,    -1,    13,  1053,   957,  1046,    -1,    13,  1053,   957,
    1047,    -1,    29,    -1,    -1,     3,    14,  1110,    -1,   166,
      14,  1110,    -1,    18,    14,  1110,  1057,    -1,  1058,    -1,
    1057,   500,  1058,    -1,  1103,   484,  1063,    -1,   387,    14,
    1110,  1060,    -1,  1061,    -1,  1060,   500,  1061,    -1,  1063,
     484,  1062,    -1,   965,    -1,  1103,    -1,    10,    -1,    18,
      14,  1110,   443,  1062,  1065,    -1,  1066,    -1,  1065,   500,
    1066,    -1,  1103,   484,  1071,    -1,   387,    14,  1110,   443,
    1062,  1068,    -1,  1069,    -1,  1068,   500,  1069,    -1,  1071,
     484,  1070,    -1,  1106,    -1,  1062,    -1,   489,  1106,    -1,
     489,   965,    -1,  1107,    -1,     8,    -1,   163,    -1,    11,
      -1,    12,    -1,    22,    -1,    23,    -1,    24,    -1,   287,
      -1,    26,    -1,    27,    -1,   339,    -1,    31,    -1,    32,
      -1,    33,    -1,   428,    -1,   387,     4,   484,  1073,    -1,
     387,     4,   419,  1073,    -1,   317,    -1,   313,    -1,   387,
     139,   419,  1040,    -1,   387,   139,   484,  1040,    -1,   387,
     139,  1040,    -1,    -1,   428,  1076,  1092,   254,  1020,   873,
    1077,    -1,    30,    -1,    -1,    -1,    45,  1079,  1090,   254,
    1020,   873,  1077,    -1,    46,    38,  1081,    -1,    46,   302,
      16,  1081,    -1,    46,    40,  1081,    -1,   143,    -1,    39,
      -1,    42,    -1,    20,   957,    -1,    19,   419,   957,    -1,
     183,   957,   497,  1098,   498,    -1,   183,     6,    -1,     7,
     957,   497,  1098,   498,    -1,     7,   957,    -1,  1083,    -1,
    1084,    -1,     6,    -1,     7,    -1,     8,    -1,    10,    -1,
      11,    -1,    12,    -1,    16,    -1,    19,    -1,    20,    -1,
      21,    -1,    22,    -1,    23,    -1,    24,    -1,    26,    -1,
      27,    -1,    31,    -1,    32,    -1,    33,    -1,    34,    -1,
      37,    -1,    38,    -1,    39,    -1,    40,    -1,    42,    -1,
       9,    -1,    13,    -1,    15,    -1,    28,    -1,    45,    -1,
      46,    -1,     5,    -1,    25,    -1,    29,    -1,    35,    -1,
      43,    -1,    36,    -1,    44,    -1,  1090,    -1,  1109,    -1,
     968,    -1,   969,    -1,  1095,    -1,  1082,    -1,  1093,    -1,
     123,    -1,   444,    -1,  1109,    -1,  1094,    -1,   969,    -1,
    1082,    -1,  1093,    -1,   123,    -1,   444,    -1,  1109,    -1,
    1094,    -1,   970,    -1,  1082,    -1,  1093,    -1,  1085,    -1,
    1091,    -1,  1085,    -1,   123,    -1,   153,    -1,   244,    -1,
     248,    -1,   419,    -1,   432,    -1,   444,    -1,  1093,    -1,
    1095,    -1,  1092,    -1,   968,    -1,   971,    -1,  1084,    -1,
     139,    -1,  1109,    -1,   969,    -1,   970,    -1,  1083,    -1,
      50,    -1,    51,    -1,    56,    -1,    65,    -1,    67,    -1,
      70,    -1,    69,    -1,   968,    -1,  1095,    -1,   139,    -1,
     165,    -1,   227,    -1,   282,    -1,   285,    -1,   379,    -1,
     470,    -1,  1099,    -1,  1096,   500,  1099,    -1,    41,    -1,
      -1,  1113,    -1,  1103,  1102,    -1,  1103,    -1,  1103,  1102,
      -1,  1103,    -1,  1103,    -1,    22,  1103,    -1,    22,   957,
      -1,    73,    -1,   483,    -1,   479,    -1,   477,    -1,   478,
      -1,    77,    -1,    78,    -1,    79,    -1,    76,    -1,   480,
      -1,   476,    -1,    72,    -1,    80,    -1,   957,    -1,   992,
      -1,  1116,    -1,   497,   498,    -1,   497,  1112,   498,    -1,
    1111,    -1,  1112,  1111,    -1,  1114,    -1,  1113,   500,  1114,
      -1,  1112,    -1,   503,  1113,   504,    -1,  1116,    -1,   497,
      -1,   498,    -1,   500,    -1,   501,    -1,  1109,    -1,   965,
      -1,  1106,    -1,  1107,    -1,   490,    -1,   488,    -1,   489,
      -1,   491,    -1,   492,    -1,   307,    -1,    47,    -1,    48,
      -1,    49,    -1,    50,    -1,    51,    -1,    52,    -1,    53,
      -1,    54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,
      -1,    60,    -1,    59,    -1,    61,    -1,    62,    -1,    63,
      -1,    64,    -1,    65,    -1,    66,    -1,    67,    -1,    68,
      -1,    70,    -1,    69,    -1,     5,    -1,   194,    -1,   227,
      -1,   248,    -1,    25,    -1,   282,    -1,   285,    -1,   379,
      -1,    35,    -1,    36,    -1,    43,    -1,    44,    -1,   470,
      -1,   123,    -1,   208,    -1,   419,    -1,   432,    -1,   445,
      -1,   495,    -1,   496,    -1,   484,    -1,   502,    -1,   166,
     996,    -1,   166,   341,   996,    -1,   166,    89,    -1,   166,
     341,    89,    -1,   965,    -1,   497,  1118,   498,    -1,  1118,
     488,  1118,    -1,  1118,   489,  1118,    -1,  1118,   490,  1118,
      -1,  1118,   491,  1118,    -1,  1118,   492,  1118,    -1,  1107,
      -1,  1088,    -1,    -1,  1045,  1120,    -1,  1120,  1045,    -1,
    1045,    -1,  1120,    -1,   252,  1096,    -1,  1047,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1188,  1188,  1191,  1193,  1195,  1197,  1199,  1201,  1203,
    1205,  1207,  1209,  1211,  1213,  1215,  1217,  1219,  1221,  1223,
    1225,  1227,  1229,  1231,  1249,  1251,  1253,  1255,  1257,  1259,
    1261,  1263,  1265,  1267,  1269,  1271,  1273,  1275,  1277,  1279,
    1281,  1283,  1285,  1287,  1289,  1291,  1293,  1295,  1297,  1299,
    1301,  1305,  1307,  1309,  1311,  1313,  1315,  1317,  1319,  1321,
    1323,  1325,  1327,  1329,  1331,  1333,  1335,  1337,  1339,  1341,
    1343,  1345,  1347,  1349,  1351,  1353,  1355,  1357,  1359,  1361,
    1363,  1365,  1367,  1369,  1376,  1378,  1380,  1382,  1384,  1386,
    1388,  1390,  1392,  1394,  1396,  1402,  1404,  1406,  1408,  1410,
    1412,  1414,  1416,  1418,  1424,  1434,  1438,  1444,  1448,  1458,
    1468,  1469,  1480,  1487,  1493,  1504,  1510,  1519,  1526,  1532,
    1541,  1548,  1556,  1561,  1569,  1574,  1580,  1585,  1591,  1595,
    1599,  1603,  1607,  1611,  1615,  1619,  1623,  1627,  1631,  1635,
    1639,  1643,  1647,  1651,  1655,  1659,  1663,  1667,  1671,  1675,
    1679,  1683,  1691,  1699,  1707,  1715,  1723,  1731,  1735,  1743,
    1747,  1755,  1763,  1771,  1775,  1783,  1787,  1795,  1799,  1807,
    1812,  1818,  1823,  1829,  1833,  1837,  1841,  1845,  1849,  1857,
    1861,  1865,  1873,  1877,  1881,  1885,  1889,  1893,  1897,  1901,
    1905,  1910,  1914,  1918,  1922,  1926,  1930,  1938,  1942,  1950,
    1954,  1962,  1966,  1970,  1984,  1988,  1992,  1996,  2004,  2008,
    2012,  2016,  2024,  2028,  2032,  2036,  2040,  2044,  2048,  2056,
    2060,  2065,  2071,  2075,  2083,  2087,  2091,  2095,  2099,  2107,
    2111,  2119,  2123,  2127,  2131,  2135,  2144,  2152,  2156,  2164,
    2168,  2176,  2184,  2188,  2192,  2196,  2204,  2208,  2212,  2216,
    2224,  2228,  2236,  2240,  2244,  2248,  2252,  2256,  2260,  2264,
    2268,  2272,  2276,  2280,  2284,  2288,  2292,  2296,  2300,  2304,
    2308,  2312,  2316,  2320,  2324,  2328,  2332,  2336,  2340,  2344,
    2348,  2352,  2356,  2360,  2368,  2372,  2380,  2384,  2389,  2395,
    2400,  2406,  2414,  2419,  2425,  2429,  2437,  2441,  2445,  2449,
    2457,  2461,  2469,  2480,  2491,  2495,  2503,  2507,  2511,  2519,
    2524,  2530,  2534,  2538,  2542,  2546,  2550,  2554,  2558,  2562,
    2566,  2574,  2579,  2585,  2590,  2596,  2601,  2607,  2612,  2618,
    2622,  2630,  2634,  2638,  2642,  2646,  2650,  2655,  2661,  2666,
    2672,  2676,  2684,  2688,  2692,  2700,  2708,  2713,  2719,  2723,
    2727,  2735,  2739,  2743,  2747,  2751,  2755,  2759,  2767,  2771,
    2775,  2779,  2787,  2795,  2800,  2806,  2810,  2814,  2818,  2822,
    2826,  2834,  2838,  2846,  2850,  2854,  2858,  2866,  2871,  2877,
    2881,  2889,  2897,  2901,  2906,  2911,  2917,  2921,  2925,  2929,
    2934,  2940,  2948,  2956,  2960,  2964,  2968,  2972,  2980,  2985,
    2991,  2995,  2999,  3004,  3010,  3014,  3018,  3023,  3029,  3034,
    3040,  3045,  3051,  3059,  3064,  3070,  3074,  3082,  3090,  3094,
    3099,  3105,  3113,  3121,  3126,  3132,  3136,  3144,  3148,  3152,
    3156,  3160,  3164,  3168,  3172,  3176,  3180,  3184,  3188,  3196,
    3201,  3207,  3211,  3215,  3226,  3230,  3238,  3243,  3249,  3253,
    3261,  3265,  3273,  3278,  3284,  3289,  3295,  3299,  3307,  3312,
    3318,  3326,  3331,  3337,  3341,  3349,  3357,  3361,  3369,  3373,
    3377,  3385,  3390,  3396,  3400,  3408,  3416,  3420,  3428,  3432,
    3436,  3440,  3448,  3456,  3464,  3472,  3480,  3485,  3491,  3495,
    3503,  3508,  3514,  3518,  3526,  3530,  3534,  3542,  3550,  3554,
    3558,  3566,  3570,  3578,  3586,  3590,  3598,  3602,  3610,  3614,
    3622,  3626,  3630,  3634,  3642,  3647,  3653,  3658,  3664,  3668,
    3676,  3680,  3685,  3691,  3695,  3699,  3703,  3707,  3711,  3719,
    3724,  3730,  3734,  3741,  3745,  3753,  3759,  3763,  3771,  3775,
    3783,  3787,  3795,  3804,  3813,  3817,  3821,  3825,  3829,  3833,
    3837,  3841,  3845,  3849,  3853,  3861,  3869,  3873,  3881,  3885,
    3893,  3897,  3901,  3905,  3909,  3917,  3921,  3929,  3937,  3941,
    3949,  3957,  3961,  3969,  3977,  3981,  3989,  3993,  3997,  4001,
    4005,  4013,  4018,  4024,  4029,  4035,  4041,  4047,  4055,  4059,
    4067,  4071,  4079,  4083,  4091,  4095,  4103,  4107,  4115,  4123,
    4131,  4135,  4143,  4147,  4151,  4155,  4159,  4163,  4167,  4171,
    4175,  4179,  4183,  4187,  4195,  4199,  4207,  4211,  4219,  4223,
    4231,  4239,  4243,  4248,  4254,  4258,  4262,  4266,  4270,  4274,
    4278,  4282,  4286,  4290,  4294,  4298,  4302,  4306,  4310,  4314,
    4318,  4326,  4330,  4334,  4338,  4342,  4346,  4350,  4354,  4358,
    4362,  4366,  4370,  4378,  4382,  4390,  4395,  4400,  4404,  4408,
    4413,  4418,  4423,  4428,  4433,  4442,  4446,  4450,  4454,  4458,
    4468,  4478,  4488,  4492,  4496,  4506,  4510,  4514,  4524,  4532,
    4536,  4544,  4552,  4556,  4564,  4568,  4572,  4576,  4580,  4588,
    4592,  4600,  4604,  4608,  4612,  4620,  4624,  4628,  4632,  4636,
    4640,  4644,  4648,  4652,  4656,  4664,  4668,  4676,  4680,  4688,
    4693,  4699,  4703,  4711,  4719,  4727,  4731,  4739,  4744,  4750,
    4755,  4761,  4765,  4773,  4778,  4784,  4789,  4795,  4799,  4807,
    4811,  4815,  4823,  4827,  4832,  4838,  4842,  4847,  4853,  4857,
    4862,  4868,  4872,  4876,  4884,  4889,  4895,  4899,  4907,  4911,
    4919,  4923,  4931,  4935,  4943,  4947,  4951,  4955,  4959,  4967,
    4971,  4975,  4979,  4983,  4991,  4999,  5007,  5011,  5015,  5023,
    5027,  5031,  5039,  5043,  5051,  5055,  5059,  5063,  5067,  5071,
    5075,  5079,  5083,  5087,  5091,  5095,  5099,  5107,  5111,  5115,
    5119,  5127,  5131,  5139,  5144,  5150,  5158,  5162,  5170,  5178,
    5182,  5190,  5195,  5201,  5205,  5213,  5217,  5225,  5229,  5237,
    5241,  5245,  5249,  5257,  5261,  5269,  5273,  5277,  5285,  5289,
    5294,  5300,  5308,  5313,  5319,  5323,  5327,  5335,  5339,  5347,
    5352,  5358,  5362,  5366,  5370,  5374,  5378,  5382,  5386,  5390,
    5394,  5398,  5402,  5406,  5410,  5414,  5418,  5422,  5426,  5430,
    5434,  5438,  5442,  5446,  5454,  5459,  5465,  5470,  5476,  5480,
    5484,  5488,  5492,  5496,  5500,  5508,  5512,  5516,  5520,  5524,
    5528,  5532,  5536,  5540,  5544,  5548,  5552,  5556,  5560,  5564,
    5568,  5576,  5580,  5584,  5592,  5596,  5604,  5608,  5612,  5616,
    5620,  5628,  5633,  5639,  5643,  5647,  5651,  5659,  5663,  5668,
    5674,  5678,  5686,  5694,  5702,  5706,  5714,  5718,  5722,  5726,
    5730,  5734,  5738,  5742,  5746,  5750,  5754,  5758,  5762,  5766,
    5774,  5778,  5783,  5789,  5793,  5797,  5805,  5809,  5813,  5821,
    5826,  5832,  5836,  5844,  5849,  5854,  5860,  5866,  5874,  5882,
    5887,  5893,  5897,  5901,  5905,  5909,  5913,  5917,  5921,  5925,
    5929,  5933,  5937,  5941,  5945,  5949,  5953,  5961,  5966,  5972,
    5976,  5984,  5992,  5997,  6003,  6011,  6015,  6023,  6031,  6035,
    6039,  6043,  6047,  6055,  6060,  6066,  6074,  6078,  6082,  6086,
    6090,  6094,  6102,  6110,  6114,  6118,  6126,  6131,  6137,  6141,
    6145,  6153,  6157,  6165,  6169,  6177,  6182,  6188,  6193,  6199,
    6204,  6210,  6215,  6221,  6229,  6233,  6237,  6241,  6245,  6249,
    6253,  6261,  6266,  6272,  6278,  6288,  6293,  6299,  6303,  6307,
    6311,  6319,  6321,  6329,  6334,  6340,  6348,  6352,  6356,  6364,
    6368,  6376,  6384,  6389,  6395,  6403,  6408,  6414,  6422,  6427,
    6433,  6437,  6441,  6445,  6449,  6453,  6457,  6461,  6469,  6474,
    6480,  6488,  6492,  6500,  6504,  6512,  6520,  6528,  6536,  6540,
    6548,  6589,  6591,  6595,  6599,  6603,  6612,  6618,  6622,  6630,
    6634,  6642,  6646,  6654,  6658,  6662,  6666,  6670,  6674,  6678,
    6682,  6690,  6694,  6702,  6706,  6710,  6714,  6718,  6722,  6730,
    6734,  6742,  6746,  6754,  6762,  6767,  6769,  6775,  6779,  6783,
    6787,  6791,  6795,  6799,  6803,  6811,  6816,  6822,  6826,  6831,
    6837,  6841,  6845,  6850,  6856,  6861,  6867,  6875,  6879,  6887,
    6891,  6899,  6903,  6907,  6911,  6915,  6920,  6924,  6928,  6936,
    6941,  6947,  6951,  6959,  6963,  6968,  6974,  6982,  6990,  6994,
    7002,  7006,  7014,  7019,  7025,  7030,  7036,  7040,  7048,  7053,
    7059,  7063,  7071,  7075,  7083,  7088,  7094,  7098,  7106,  7111,
    7117,  7121,  7129,  7133,  7137,  7141,  7145,  7149,  7153,  7157,
    7163,  7167,  7171,  7179,  7183,  7187,  7191,  7195,  7199,  7207,
    7211,  7215,  7219,  7227,  7231,  7235,  7239,  7247,  7252,  7258,
    7262,  7270,  7274,  7278,  7282,  7290,  7294,  7302,  7306,  7310,
    7318,  7326,  7331,  7337,  7341,  7345,  7350,  7356,  7360,  7368,
    7376,  7378,  7380,  7384,  7388,  7392,  7400,  7410,  7421,  7430,
    7434,  7438,  7442,  7446,  7450,  7454,  7462,  7466,  7470,  7474,
    7482,  7486,  7494,  7499,  7505,  7509,  7513,  7517,  7521,  7525,
    7529,  7533,  7537,  7541,  7545,  7553,  7558,  7564,  7568,  7576,
    7580,  7588,  7596,  7604,  7608,  7616,  7620,  7628,  7636,  7644,
    7648,  7652,  7656,  7660,  7664,  7672,  7677,  7683,  7688,  7694,
    7698,  7702,  7706,  7714,  7722,  7726,  7731,  7737,  7741,  7745,
    7749,  7753,  7757,  7761,  7765,  7769,  7773,  7777,  7781,  7785,
    7790,  7796,  7800,  7808,  7812,  7816,  7820,  7824,  7828,  7832,
    7836,  7840,  7844,  7848,  7852,  7856,  7860,  7864,  7868,  7872,
    7876,  7880,  7884,  7888,  7892,  7896,  7900,  7904,  7908,  7912,
    7916,  7920,  7924,  7928,  7932,  7936,  7940,  7944,  7948,  7952,
    7956,  7960,  7964,  7968,  7972,  7976,  7980,  7984,  7988,  7992,
    7996,  8000,  8004,  8008,  8012,  8016,  8020,  8024,  8028,  8033,
    8037,  8045,  8049,  8053,  8057,  8061,  8065,  8069,  8073,  8077,
    8081,  8085,  8089,  8093,  8097,  8101,  8105,  8109,  8113,  8117,
    8121,  8125,  8129,  8137,  8141,  8145,  8149,  8153,  8157,  8161,
    8165,  8169,  8173,  8177,  8181,  8189,  8193,  8197,  8201,  8205,
    8209,  8213,  8217,  8221,  8225,  8229,  8233,  8237,  8241,  8245,
    8249,  8253,  8257,  8261,  8265,  8269,  8273,  8277,  8281,  8285,
    8289,  8293,  8297,  8301,  8305,  8309,  8313,  8317,  8321,  8325,
    8329,  8333,  8337,  8341,  8345,  8349,  8353,  8357,  8361,  8365,
    8369,  8373,  8381,  8385,  8393,  8397,  8401,  8406,  8412,  8420,
    8424,  8432,  8436,  8444,  8448,  8456,  8460,  8465,  8471,  8476,
    8482,  8486,  8494,  8502,  8506,  8511,  8517,  8525,  8529,  8536,
    8541,  8547,  8551,  8556,  8562,  8567,  8576,  8580,  8584,  8592,
    8596,  8600,  8608,  8612,  8616,  8624,  8628,  8636,  8640,  8644,
    8648,  8652,  8656,  8660,  8664,  8668,  8676,  8680,  8688,  8692,
    8700,  8704,  8708,  8712,  8716,  8720,  8728,  8732,  8740,  8744,
    8752,  8756,  8760,  8768,  8772,  8780,  8785,  8791,  8795,  8799,
    8803,  8807,  8811,  8815,  8819,  8827,  8831,  8839,  8847,  8852,
    8858,  8862,  8866,  8870,  8874,  8879,  8885,  8893,  8901,  8905,
    8909,  8917,  8921,  8929,  8937,  8941,  8949,  8957,  8962,  8968,
    8973,  8979,  8983,  8991,  8995,  8999,  9003,  9011,  9015,  9024,
    9026,  9034,  9039,  9045,  9049,  9057,  9061,  9069,  9077,  9081,
    9089,  9093,  9097,  9101,  9109,  9113,  9121,  9125,  9133,  9137,
    9145,  9149,  9157,  9165,  9173,  9181,  9189,  9197,  9205,  9209,
    9217,  9221,  9225,  9229,  9233,  9237,  9241,  9245,  9249,  9253,
    9257,  9261,  9265,  9269,  9270,  9275,  9281,  9289,  9293,  9294,
    9298,  9306,  9310,  9314,  9318,  9322,  9326,  9330,  9334,  9338,
    9342,  9346,  9350,  9354,  9358,  9362,  9366,  9370,  9374,  9378,
    9382,  9386,  9390,  9394,  9398,  9402,  9406,  9410,  9414,  9418,
    9422,  9426,  9430,  9434,  9438,  9442,  9446,  9450,  9454,  9458,
    9462,  9466,  9470,  9474,  9478,  9482,  9486,  9490,  9494,  9498,
    9502,  9506,  9510,  9514,  9518,  9522,  9526,  9530,  9534,  9538,
    9542,  9546,  9550,  9554,  9558,  9562,  9566,  9570,  9574,  9578,
    9582,  9586,  9590,  9594,  9598,  9602,  9606,  9610,  9614,  9618,
    9622,  9626,  9630,  9634,  9638,  9642,  9646,  9650,  9654,  9658,
    9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,  9698,
    9702,  9706,  9710,  9714,  9718,  9722,  9726,  9730,  9734,  9738,
    9742,  9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,  9778,
    9782,  9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,  9818,
    9822,  9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,  9858,
    9862,  9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,  9898,
    9902,  9906,  9910,  9914,  9918,  9922,  9926,  9930,  9934,  9938,
    9942,  9946,  9950,  9954,  9958,  9962,  9966,  9970,  9974,  9978,
    9982,  9986,  9990,  9994,  9998, 10002, 10006, 10010, 10014, 10018,
   10022, 10026, 10030, 10034, 10038, 10042, 10046, 10050, 10054, 10058,
   10062, 10066, 10070, 10074, 10078, 10082, 10086, 10090, 10094, 10098,
   10102, 10106, 10110, 10114, 10118, 10122, 10126, 10130, 10134, 10138,
   10142, 10146, 10150, 10154, 10158, 10162, 10166, 10170, 10174, 10178,
   10182, 10186, 10190, 10194, 10198, 10202, 10206, 10210, 10214, 10218,
   10222, 10226, 10230, 10234, 10238, 10242, 10246, 10250, 10258, 10262,
   10266, 10270, 10274, 10278, 10282, 10286, 10290, 10294, 10298, 10302,
   10306, 10310, 10314, 10318, 10322, 10326, 10330, 10334, 10338, 10342,
   10346, 10350, 10354, 10358, 10362, 10366, 10370, 10374, 10378, 10382,
   10386, 10390, 10394, 10398, 10402, 10406, 10410, 10414, 10418, 10422,
   10430, 10434, 10438, 10442, 10446, 10450, 10454, 10458, 10462, 10466,
   10470, 10474, 10478, 10482, 10486, 10490, 10494, 10498, 10502, 10506,
   10510, 10514, 10522, 10526, 10530, 10534, 10538, 10542, 10546, 10550,
   10554, 10558, 10562, 10566, 10570, 10574, 10578, 10582, 10586, 10590,
   10594, 10598, 10602, 10606, 10610, 10614, 10618, 10622, 10626, 10630,
   10634, 10638, 10642, 10646, 10650, 10654, 10658, 10662, 10666, 10670,
   10674, 10678, 10682, 10686, 10690, 10694, 10698, 10702, 10706, 10710,
   10714, 10718, 10722, 10726, 10730, 10734, 10738, 10742, 10746, 10750,
   10754, 10758, 10762, 10766, 10770, 10774, 10778, 10782, 10786, 10790,
   10794, 10798, 10802, 10806, 10810, 10814, 10818, 10822, 10826, 10834,
   10841, 10854, 10855, 10858, 10859, 10860, 10866, 10867, 10868, 10869,
   10870, 10873, 10873, 10883, 10882, 10892, 10908, 10910, 10913, 10915,
   10919, 10931, 10947, 10951, 10962, 10963, 10966, 10978, 10987, 10988,
   10991, 10992, 10993, 10996, 10997, 11000, 11001, 11004, 11005, 11008,
   11010, 11012, 11014, 11018, 11025, 11032, 11048, 11081, 11091, 11094,
   11096, 11109, 11110, 11112, 11114, 11118, 11131, 11138, 11175, 11184,
   11186, 11187, 11190, 11192, 11193, 11196, 11197, 11198, 11199, 11200,
   11207, 11206, 11216, 11218, 11220, 11221, 11222, 11225, 11226, 11227,
   11228, 11229, 11232, 11233, 11237, 11236, 11253, 11251, 11266, 11265,
   11278, 11284, 11285, 11288, 11290, 11291, 11294, 11295, 11296, 11297,
   11300, 11301, 11304, 11312, 11329, 11337, 11360, 11458, 11492, 11494,
   11496, 11500, 11504, 11503, 11554, 11556, 11555, 11570, 11576, 11583,
   11588, 11591, 11592, 11595, 11596, 11597, 11598, 11599, 11600, 11601,
   11609, 11617, 11620, 11621, 11622, 11623, 11624, 11625, 11633, 11641,
   11642, 11643, 11646, 11647, 11650, 11652, 11656, 11742, 11743, 11750,
   11751, 11752, 11758, 11767, 11770, 11771, 11772, 11773, 11776, 11777,
   11778, 11781, 11783, 11791, 11792, 11798, 11800, 11801, 11804, 11805,
   11808, 11815, 11822, 11822, 11824, 11824, 11826, 11833, 11834, 11837,
   11838, 11839, 11840, 11841, 11842, 11843, 11844, 11845, 11851, 11858,
   11865, 11874, 11875, 11887, 11898, 11909, 11913, 11914, 11917, 11922,
   11926, 11927, 11930, 11936, 11944, 11947, 11954, 11958, 11959, 11962,
   11965, 11969, 11970, 11973, 11979, 11987, 11988, 11997, 12006, 12018,
   12019, 12020, 12021, 12022, 12023, 12024, 12025, 12026, 12027, 12028,
   12029, 12030, 12031, 12032, 12039, 12040, 12043, 12044, 12051, 12052,
   12053, 12060, 12059, 12076, 12077, 12084, 12083, 12152, 12158, 12164,
   12172, 12178, 12184, 12190, 12196, 12202, 12208, 12214, 12220, 12231,
   12232, 12235, 12236, 12237, 12238, 12239, 12240, 12241, 12242, 12243,
   12244, 12245, 12246, 12247, 12248, 12249, 12250, 12251, 12252, 12253,
   12254, 12255, 12256, 12257, 12258, 12261, 12262, 12263, 12264, 12265,
   12266, 12270, 12271, 12272, 12273, 12274, 12275, 12276, 12279, 12282,
   12283, 12284, 12285, 12286, 12287, 12288, 12289, 12302, 12303, 12304,
   12305, 12306, 12307, 12308, 12313, 12314, 12315, 12316, 12317, 12318,
   12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333,
   12334, 12337, 12338, 12339, 12340, 12341, 12344, 12345, 12346, 12347,
   12350, 12351, 12352, 12353, 12354, 12355, 12356, 12373, 12374, 12375,
   12378, 12379, 12380, 12381, 12382, 12383, 12387, 12387, 12390, 12396,
   12397, 12400, 12402, 12407, 12417, 12424, 12425, 12426, 12429, 12462,
   12464, 12466, 12469, 12479, 12489, 12499, 12500, 12503, 12505, 12506,
   12507, 12510, 12512, 12520, 12521, 12522, 12526, 12527, 12531, 12532,
   12535, 12536, 12539, 12540, 12541, 12542, 12543, 12546, 12547, 12548,
   12549, 12550, 12551, 12552, 12553, 12554, 12555, 12556, 12557, 12558,
   12559, 12560, 12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568,
   12569, 12570, 12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578,
   12579, 12580, 12581, 12582, 12583, 12584, 12585, 12586, 12587, 12588,
   12589, 12590, 12591, 12592, 12593, 12594, 12595, 12596, 12597, 12598,
   12599, 12600, 12601, 12604, 12605, 12606, 12607, 12610, 12611, 12612,
   12613, 12614, 12615, 12616, 12617, 12618, 12621, 12622, 12623, 12624,
   12625, 12628, 12629
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE",
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT",
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER",
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE",
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT",
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P",
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE",
  "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", "CHAIN",
  "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS",
  "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT",
  "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT",
  "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P", "COPY", "COST",
  "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV",
  "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE",
  "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER",
  "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC",
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED",
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY",
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P",
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED",
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE",
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE",
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL",
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT",
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER",
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION",
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL",
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", "MAPPING", "MATCH",
  "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P",
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NEXT", "NO",
  "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P",
  "NONE", "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT",
  "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF",
  "OFFSET", "OIDS", "OLD", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS",
  "OR", "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY",
  "OWNED", "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSWORD",
  "PLACING", "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE",
  "PREPARE", "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL",
  "PROCEDURE", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK",
  "RECURSIVE", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT",
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW",
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P",
  "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION",
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE",
  "SMALLINT", "SOME", "STABLE", "STANDALONE_P", "START", "STATEMENT",
  "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", "STRIP_P",
  "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE",
  "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME",
  "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM",
  "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED",
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL",
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P",
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P",
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH",
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES",
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT",
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST",
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op",
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'",
  "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','",
  "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt",
  "opt_with", "OptRoleList", "OptRoleElem", "CreateUserStmt",
  "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt",
  "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt",
  "add_drop", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName",
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest",
  "var_name", "var_list", "var_value", "iso_level", "opt_boolean",
  "zone_value", "opt_encoding", "ColId_or_Sconst", "VariableResetStmt",
  "SetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "alter_using", "reloptions",
  "opt_reloptions", "reloption_list", "reloption_elem", "ClosePortalStmt",
  "CopyStmt", "copy_from", "copy_file_name", "copy_opt_list",
  "copy_opt_item", "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "CreateStmt", "OptTemp", "OptTableElementList", "TableElementList",
  "TableElement", "columnDef", "ColQualList", "ColConstraint",
  "ColConstraintElem", "ConstraintAttr", "TableLikeClause",
  "TableLikeOptionList", "TableLikeOption", "TableConstraint",
  "ConstraintElem", "opt_column_list", "columnList", "columnElem",
  "key_match", "key_actions", "key_update", "key_delete", "key_action",
  "OptInherit", "OptWith", "OnCommitOption", "OptTableSpace",
  "OptConsTableSpace", "create_as_target", "OptCreateAs", "CreateAsList",
  "CreateAsElement", "opt_with_data", "CreateSeqStmt", "AlterSeqStmt",
  "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly",
  "CreatePLangStmt", "opt_trusted", "handler_name", "validator_clause",
  "opt_validator", "opt_lancompiler", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", "create_generic_options",
  "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOpt", "TriggerForType", "TriggerFuncArgs",
  "TriggerFuncArg", "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt",
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition",
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition",
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt",
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt",
  "privileges", "privilege_list", "privilege", "privilege_target",
  "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "IndexStmt", "index_opt_unique", "access_method_clause", "index_params",
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context",
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type",
  "opt_force", "RenameStmt", "opt_column", "opt_set_data",
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList",
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event",
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "AnalyzeStmt",
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze",
  "opt_name_list", "ExplainStmt", "ExplainableStmt", "opt_analyze",
  "PrepareStmt", "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold",
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause",
  "simple_select", "with_clause", "cte_list", "common_table_expr",
  "into_clause", "OptTempTableName", "opt_table", "opt_all",
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list",
  "sortby", "select_limit", "opt_select_limit", "select_limit_value",
  "opt_select_fetch_first_value", "select_offset_value",
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause",
  "having_clause", "for_locking_clause", "opt_for_locking_clause",
  "for_locking_items", "for_locking_item", "locked_rels_list",
  "values_clause", "from_clause", "from_list", "table_ref", "joined_table",
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr",
  "relation_expr_list", "relation_expr_opt_alias", "func_table",
  "where_clause", "where_or_current_clause", "TableFuncElementList",
  "TableFuncElement", "Typename", "opt_array_bounds", "SimpleTypename",
  "ConstTypename", "GenericType", "opt_type_modifiers", "Numeric",
  "opt_float", "Bit", "ConstBit", "BitWithLength", "BitWithoutLength",
  "Character", "ConstCharacter", "CharacterWithLength",
  "CharacterWithoutLength", "character", "opt_varying", "opt_charset",
  "ConstDatetime", "ConstInterval", "opt_timezone", "opt_interval",
  "interval_second", "a_expr", "b_expr", "c_expr", "func_expr",
  "xml_root_version", "opt_xml_root_standalone", "xml_attributes",
  "xml_attribute_list", "xml_attribute_el", "document_or_content",
  "xml_whitespace_option", "window_clause", "window_definition_list",
  "window_definition", "over_clause", "window_specification",
  "opt_existing_window_name", "opt_partition_clause", "opt_frame_clause",
  "frame_extent", "frame_bound", "row", "sub_type", "all_Op", "MathOp",
  "qual_Op", "qual_all_Op", "subquery_Op", "expr_list", "type_list",
  "array_expr", "array_expr_list", "extract_list", "extract_arg",
  "overlay_list", "overlay_placing", "position_list", "substr_list",
  "substr_from", "substr_for", "trim_list", "in_expr", "case_expr",
  "when_clause_list", "when_clause", "case_default", "case_arg",
  "columnref", "indirection_el", "indirection", "opt_indirection",
  "opt_asymmetric", "ctext_expr", "ctext_expr_list", "ctext_row",
  "target_list", "target_el", "relation_name", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "SignedIconst", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "SpecialRuleRelation", "statements", "statement", "CreateAsStmt", "$@1",
  "RuleStmt", "$@2", "at", "ECPGConnect", "connection_target",
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name",
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@3", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@4", "var_declaration",
  "$@5", "$@6", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@7", "struct_union_type", "$@8",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "opt_sql", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@9", "opt_reference", "ECPGVar",
  "$@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "civar", "indicator", "cvariable", "ecpg_param", "ecpg_bconst",
  "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     640,   640,   640,   640,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   645,   645,   645,   645,   645,   645,   646,
     646,   647,   647,   647,   647,   647,   648,   648,   649,   649,
     650,   650,   651,   652,   653,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   655,   655,   656,   656,
     657,   657,   657,   657,   657,   658,   658,   659,   660,   660,
     661,   662,   662,   663,   664,   664,   665,   665,   665,   665,
     665,   666,   666,   667,   667,   668,   668,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   676,
     677,   677,   678,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   679,   679,   680,   680,   681,   681,
     682,   683,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   687,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   688,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   689,
     689,   690,   691,   691,   692,   692,   692,   692,   692,   693,
     693,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   699,   700,   701,   702,   702,   703,   703,   704,
     704,   705,   705,   706,   706,   707,   707,   708,   708,   709,
     709,   709,   710,   710,   710,   711,   711,   711,   712,   712,
     712,   713,   713,   713,   714,   714,   715,   715,   716,   716,
     717,   717,   718,   718,   719,   719,   719,   719,   719,   720,
     720,   720,   720,   720,   721,   722,   723,   723,   723,   724,
     724,   724,   725,   725,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   727,   727,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   736,   737,   737,   738,
     738,   738,   738,   739,   739,   740,   740,   740,   741,   741,
     741,   742,   743,   743,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   748,   748,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   752,   752,   752,   753,   753,   754,   754,   754,   754,
     754,   755,   755,   756,   756,   756,   756,   757,   757,   757,
     758,   758,   759,   760,   761,   761,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     763,   763,   763,   764,   764,   764,   765,   765,   765,   766,
     766,   767,   767,   768,   768,   768,   768,   769,   770,   771,
     771,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   773,   773,   774,
     774,   775,   776,   776,   777,   778,   778,   779,   780,   780,
     780,   780,   780,   781,   781,   782,   783,   783,   783,   783,
     783,   783,   784,   785,   785,   785,   786,   786,   787,   787,
     787,   788,   788,   789,   789,   790,   790,   791,   791,   792,
     792,   793,   793,   794,   795,   795,   795,   795,   795,   795,
     795,   796,   796,   797,   797,   798,   798,   799,   799,   799,
     799,   800,   800,   801,   801,   802,   803,   803,   803,   804,
     804,   805,   806,   806,   807,   808,   808,   809,   810,   810,
     811,   811,   811,   811,   811,   811,   811,   811,   812,   812,
     813,   814,   814,   815,   815,   816,   817,   818,   819,   819,
     820,   821,   821,   821,   821,   821,   822,   822,   822,   823,
     823,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   826,   827,   827,   827,   827,   827,   827,   828,
     828,   829,   829,   830,   831,   831,   831,   832,   832,   832,
     832,   832,   832,   832,   832,   833,   833,   834,   834,   834,
     835,   835,   835,   835,   836,   836,   837,   838,   838,   839,
     839,   840,   840,   840,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   843,   844,   845,   846,   846,
     847,   847,   848,   848,   849,   849,   850,   850,   851,   851,
     852,   852,   853,   853,   854,   854,   855,   855,   856,   856,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   859,   859,   859,   859,   860,
     860,   860,   860,   861,   861,   861,   861,   862,   862,   863,
     863,   864,   864,   864,   864,   865,   865,   866,   866,   866,
     867,   868,   868,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   875,   875,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   883,   884,   884,   885,   885,   886,   887,   888,
     888,   888,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   891,   891,   892,   893,   893,   893,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   895,   895,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   898,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   900,   900,   901,   901,   901,   901,   902,   903,
     903,   904,   904,   905,   905,   906,   906,   906,   907,   907,
     908,   908,   909,   910,   910,   910,   911,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   916,   916,   916,   917,
     917,   917,   918,   918,   918,   919,   919,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   921,   921,   922,   922,
     923,   923,   923,   923,   923,   923,   924,   924,   925,   925,
     926,   926,   926,   927,   927,   928,   928,   929,   929,   929,
     929,   929,   929,   929,   929,   930,   930,   931,   932,   932,
     933,   933,   933,   933,   933,   933,   934,   935,   936,   936,
     936,   937,   937,   938,   939,   939,   940,   941,   941,   942,
     942,   943,   943,   944,   944,   944,   944,   945,   945,   946,
     946,   947,   947,   948,   948,   949,   949,   950,   951,   951,
     952,   952,   952,   952,   953,   953,   954,   954,   955,   955,
     956,   956,   957,   958,   959,   960,   961,   962,   963,   963,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   964,   965,   966,   967,   967,   967,
     967,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   972,
     972,   973,   973,   974,   974,   974,   974,   974,   974,   974,
     974,   976,   975,   978,   977,   979,   980,   980,   980,   980,
     981,   981,   981,   981,   982,   982,   983,   984,   985,   985,
     986,   986,   986,   987,   987,   988,   988,   989,   989,   990,
     990,   990,   990,   991,   991,   991,   992,   993,   993,   994,
     994,   995,   995,   995,   995,   996,   996,   997,   998,   999,
    1000,  1000,  1001,  1002,  1002,  1003,  1003,  1003,  1003,  1003,
    1005,  1004,  1006,  1007,  1008,  1008,  1008,  1009,  1009,  1009,
    1009,  1009,  1010,  1010,  1012,  1011,  1014,  1013,  1015,  1013,
    1013,  1016,  1016,  1017,  1017,  1017,  1018,  1018,  1018,  1018,
    1019,  1019,  1020,  1020,  1020,  1020,  1020,  1020,  1021,  1021,
    1021,  1022,  1024,  1023,  1025,  1026,  1025,  1027,  1027,  1028,
    1028,  1029,  1029,  1030,  1030,  1030,  1030,  1030,  1030,  1030,
    1030,  1030,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1031,  1032,  1032,  1033,  1033,  1034,  1035,  1035,  1036,
    1036,  1036,  1037,  1038,  1039,  1039,  1039,  1039,  1040,  1040,
    1040,  1041,  1041,  1042,  1042,  1043,  1044,  1044,  1045,  1045,
    1046,  1047,  1048,  1048,  1049,  1049,  1050,  1050,  1050,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1051,  1052,  1052,
    1052,  1053,  1053,  1054,  1055,  1056,  1057,  1057,  1058,  1059,
    1060,  1060,  1061,  1062,  1062,  1063,  1064,  1065,  1065,  1066,
    1067,  1068,  1068,  1069,  1070,  1070,  1070,  1070,  1070,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1072,  1072,  1073,  1073,  1074,  1074,
    1074,  1076,  1075,  1077,  1077,  1079,  1078,  1080,  1080,  1080,
    1081,  1081,  1081,  1081,  1081,  1081,  1081,  1081,  1081,  1082,
    1082,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1084,  1084,  1084,  1084,  1084,
    1084,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1087,  1088,  1088,  1088,
    1088,  1088,  1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,
    1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,
    1090,  1091,  1091,  1091,  1091,  1091,  1092,  1092,  1092,  1092,
    1093,  1093,  1093,  1093,  1093,  1093,  1093,  1094,  1094,  1094,
    1095,  1095,  1095,  1095,  1095,  1095,  1096,  1096,  1097,  1098,
    1098,  1099,  1099,  1100,  1101,  1102,  1102,  1102,  1103,  1104,
    1105,  1106,  1107,  1107,  1107,  1107,  1107,  1108,  1109,  1109,
    1109,  1110,  1110,  1111,  1111,  1111,  1112,  1112,  1113,  1113,
    1114,  1114,  1115,  1115,  1115,  1115,  1115,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1117,  1117,  1117,  1117,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1118,  1119,  1119,  1119,  1119,
    1119,  1120,  1120
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       1,     1,     1,     1,     3,     0,     1,     0,     1,     1,
       1,     3,     0,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     4,     5,     4,     4,     4,     3,     7,
       8,     6,     6,     6,     6,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     2,     4,     2,     5,
       4,     4,     3,     3,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,    13,    14,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,    11,    10,    10,     2,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     6,     6,     8,     8,     6,     6,     6,     8,
       8,     8,     8,     6,     1,     0,     2,     0,     7,     6,
       6,     6,     6,     6,     6,     7,     6,     6,     6,     6,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       6,     8,     2,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     2,     4,     1,     1,     1,     0,     1,     0,     1,
       0,     3,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     3,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     3,     5,     8,     1,
       0,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     4,     4,     2,     0,     2,     3,     2,     0,
       1,     3,     1,     2,     1,     2,     5,     6,     5,     1,
       2,     1,     4,     3,     4,     5,     4,     5,     4,     5,
       2,     4,     1,     2,     2,     2,     1,     1,     0,     4,
       2,     1,     2,     2,     4,     1,     3,     1,     2,     3,
       1,     2,     0,     2,     4,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     2,     1,     4,     5,     6,     8,     6,
       6,     5,     1,     1,     4,     1,     4,     1,     4,     1,
       4,     1,     1,     1,     1,     1,     1,     6,     4,     4,
       4,     4,     6,     5,     5,     5,     4,     6,     4,     4,
       4,     4,     5,     7,     7,     9,     4,     6,     5,     7,
       7,     7,     2,     3,     3,     3,     4,     0,     4,     1,
       3,     3,     1,     1,     1,     2,     2,     0,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     4,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     4,
       1,     4,     1,     2,     1,     2,     1,     3,     1,     3,
       3,     3,     2,     1,     3,     3,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     3,     2,     3,     0,
       3,     3,     2,     2,     1,     0,     2,     2,     3,     2,
       1,     1,     3,     5,     1,     2,     4,     2,     0,     1,
       0,     1,     2,     2,     2,     3,     5,     1,     2,     0,
       2,     1,     0,     1,     1,     1,     3,     3,     1,     3,
       3,     2,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     2,     5,     2,     3,     6,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     4,     3,     2,     1,     1,     1,     1,
       1,     0,     8,     0,    14,     2,     5,     3,     2,     2,
       3,     7,     1,     1,     1,     0,     2,     2,     1,     0,
       1,     3,     1,     2,     0,     2,     0,     2,     0,     1,
       3,     4,     3,     1,     1,     1,     1,     2,     0,     2,
       4,     0,     2,     2,     2,     1,     1,     7,     3,     1,
       1,     1,     1,     2,     0,     1,     3,     3,     3,     3,
       0,     4,     5,     5,     0,     1,     1,     1,     1,     2,
       2,     2,     1,     2,     0,     7,     0,     5,     0,     4,
       2,     2,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     5,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     2,     2,     3,     0,     1,     2,     1,
       4,     4,     0,     1,     1,     3,     1,     1,     1,     1,
       2,     2,     1,     2,     2,     1,     1,     1,     4,     4,
       4,     1,     0,     3,     3,     4,     1,     3,     3,     4,
       1,     3,     3,     1,     1,     1,     6,     1,     3,     3,
       6,     1,     3,     3,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     4,     4,
       3,     0,     7,     1,     0,     0,     7,     3,     4,     3,
       1,     1,     1,     2,     3,     5,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     0,
       1,     2,     1,     2,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     2,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     2,     3,     1,     3,     3,
       3,     3,     3,     3,     1,     1,     0,     2,     2,     1,
       1,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    1981,     0,     2,     1,  2411,  2415,  2419,  2420,  2338,  2421,
    2422,  2387,  2388,  2389,  2390,  2391,  2392,  2393,  2394,  2395,
    2396,  2397,  2398,  2400,  2399,  2401,  2402,  2403,  2404,  2405,
    2406,  2407,  2408,  2410,  2409,  2359,  1988,  2356,  2353,  2354,
    2355,  2360,  2424,  2412,  2425,  2413,  2414,  2416,  2417,  2386,
    2418,  2426,  2427,  2428,  2423,  2358,  2351,  2352,  1595,  2431,
    2382,  2383,  2381,  2384,  2385,  2429,  2430,  2373,  2374,  2375,
    2376,  2432,  1989,  1990,  2378,  1982,  1986,  2050,  2123,  2379,
    2380,  2377,  1987,  2372,  2123,     0,  2241,  2242,  2243,     0,
    2244,  2245,  2246,  2172,  2137,  2247,     0,     0,  2248,  2249,
    2250,  2251,  2252,  2253,  2254,  2255,     0,  2256,  2257,  2258,
    2259,  2122,  2260,  2261,  2262,  2263,  2264,  2099,  2105,  2225,
       0,  2079,  2080,  2076,  2078,  2077,  2081,  2064,   922,   459,
     994,   993,     0,  1880,   922,  1881,  1838,  1882,  1839,  1840,
    1841,   241,     0,   996,  1842,     0,   922,   322,   337,  1883,
    1884,  2005,     0,  1843,  1844,     0,     0,     0,   459,   922,
       0,     0,  1845,  1012,  1846,     0,  1847,  1885,  1886,     0,
    1848,  1887,  1888,  1849,     0,  1850,  1851,  1889,  1890,  1891,
    1852,  1892,  1893,     0,     0,  1106,     0,  1853,  1894,  1854,
    1855,     0,  1895,  1856,  1857,  1858,  1896,  1897,  1898,  1859,
    1860,  1861,     0,  1862,     0,     0,     0,     0,     0,  1899,
     922,  1863,     0,  1113,     0,  1864,     0,  1900,  1865,     0,
    1866,     0,  1867,  1868,  1869,  1870,  1106,  2221,  2100,     0,
       0,   998,     0,  1871,  1901,     0,  1872,  1873,  1874,  1875,
    1876,  1877,  1878,  1879,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   996,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1082,  1069,  1115,  1081,     0,  1084,
    2317,  2318,    28,    92,   122,   104,   105,   110,  1985,  2039,
    2040,  2041,  2123,  2074,  2075,  2068,  2084,  2094,  2083,  2087,
    2095,  2082,  2101,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2319,  1290,  2316,    50,  2056,     0,  2123,  2058,  2057,     0,
    2265,  2266,  2267,  2268,  2269,  2270,  2320,  2321,  2322,  2323,
    2324,  2326,  2325,  2348,  1601,  1602,  1603,  1604,  1605,  1606,
    1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,  1616,
    1617,  1618,  1619,  1620,  1621,  1622,  1623,  1624,  2292,  1625,
    1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,  1634,  2329,
    1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,  1644,
    1645,  1646,  1647,  1648,  2330,  1649,  1650,  1651,  1652,  1653,
    1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,  1663,
    1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,  1683,
    1684,  1685,  2331,  1686,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1701,  1702,
    1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,  1712,
    1713,  1714,  1715,  1716,  1717,  1718,  2332,  1719,  1720,  2333,
    1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,
    1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,
    1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1749,  1752,
    1750,  1751,  1753,  1754,  1755,  1756,  1757,  1758,  1759,  1760,
    1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,  1769,  1770,
    1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,
    1781,  1782,  2334,  1783,  1784,  1785,  1786,  1787,  1788,  1789,
    1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,
    1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,  1809,
    2005,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,  1818,
    1819,  1820,  1821,  1822,  1823,  1824,  1825,  2293,  1826,  1827,
    1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,  2335,  1836,
    1837,  2023,  2327,  2289,  1998,  2019,  2290,  2239,  2240,  1596,
    2291,  2288,  2328,  2025,  2344,  2024,  2287,  2171,     0,     0,
    2136,  2135,  2139,  2138,  2140,  2133,  2134,  1573,  2026,  2144,
    2143,  1572,     0,  2146,  2271,  2272,  2273,  2274,  2276,  2275,
    2277,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,
    1911,  1912,  1913,  2302,  1914,  1915,  1916,  2315,  1917,  1918,
    2303,  1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,
    1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,
    1938,  1939,  1940,  1941,  1942,  2304,  2305,  1943,  1944,  1945,
    1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,
    1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,
    1966,  1967,  1968,  2306,  1969,  1970,  2307,  1971,  1972,  1973,
    2308,  1974,  1975,  1976,  1977,  1978,  2312,  2313,  2314,  2301,
    2097,  2278,  2300,  2311,  2309,  2310,  2107,  2103,  2111,  2106,
       0,     0,     0,     0,  2123,   921,   920,   906,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   458,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1995,     0,   930,   301,   300,   995,   984,   459,     0,   909,
     321,     0,     0,     0,     0,     0,     0,     0,   581,     0,
       0,     0,     0,     0,     0,     0,     0,   170,     0,     0,
     332,   331,     0,     0,   446,     0,   723,     0,     0,   459,
       0,     0,     0,  2004,  1999,  2009,     0,  2002,  2003,  2287,
       0,  2435,  1750,  2035,  2036,  2433,  1795,  1061,     0,   242,
     245,   243,   244,     0,     0,   823,   608,     0,   607,     0,
       0,     0,   605,     0,     0,     0,     0,   609,   603,     0,
     602,     0,     0,     0,   606,     0,   604,     0,     0,   910,
       0,  2089,  2090,  1688,  1024,  1011,   996,  1602,   672,   676,
     667,   673,   679,   680,   668,   665,   666,  1764,     0,     0,
       0,     0,   656,  1597,   671,  1598,   685,   378,   378,   378,
       0,   684,   689,   378,     0,   903,   937,  1577,  1105,     0,
       0,   658,   902,  1810,  1016,     0,     0,   827,     0,   828,
       0,  1779,   914,   228,  2285,  1787,  1867,  1810,  2286,   224,
    2280,  2281,  2283,   197,  2284,  2282,  2279,  1606,     0,     0,
     684,     0,   911,   912,  1112,  1110,     0,     0,     0,  1623,
       0,  1635,  1712,   221,  1775,  1780,  1787,  1867,  1810,  1835,
     179,     0,   235,  1787,  1867,  1810,     0,   930,  1980,  1979,
       0,  1085,  1568,  1191,  1564,  1565,     0,     0,  2098,   905,
     904,  1197,     0,   997,  1000,     0,  1156,  1762,  1089,  1091,
    1002,  1082,     0,  1984,   991,  1109,  1109,     0,  1109,     0,
    1074,  1082,  1077,  1081,     0,   922,     0,  2066,  2094,  2073,
    2129,  2070,     0,     0,  2119,  2115,  2112,  2120,  2121,  2114,
    2102,  1279,  1280,  1281,  1278,  1291,  1277,     0,  2045,  1282,
    2086,  2051,     0,  2061,  2060,  2059,  2361,  2362,  2173,  1997,
    2016,     0,     0,     0,     0,     0,     0,  2152,  2145,  2147,
    2149,  2109,  2108,  2104,     0,     0,     0,     0,  2231,  2232,
    2230,     0,  2227,  2229,     0,  2129,     0,     0,  2296,  2290,
    2299,  1578,  2291,  2288,  2287,     0,   616,   125,     0,     0,
       0,     0,     0,     0,  1627,  1675,  1475,  1485,  1483,  1484,
    1477,  1478,  1479,  1480,  1481,  1482,     0,   813,  1476,     0,
     125,     0,     0,     0,     0,     0,     0,     0,     0,  1716,
     125,     0,     0,     0,     0,     0,   926,   929,   907,   987,
       0,  1565,     0,     0,   641,     0,   650,   642,   647,     0,
     644,     0,     0,   652,     0,   643,   645,   646,   651,     0,
       0,   648,   649,     0,     0,   918,   378,     0,     0,     0,
       0,     0,   125,   974,     0,   336,   335,   125,   334,   333,
    1627,  1675,     0,   744,   125,     0,   172,   487,   462,     0,
       0,   548,  1716,   125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2008,  2014,     0,  2006,  2174,  2436,  2434,
    2132,     0,  1036,  1687,     0,   288,     0,     0,  1687,   965,
       0,  1687,     0,  1687,   165,  1570,  1627,  1675,  1687,     0,
       0,  1687,   157,  1687,     0,  1687,   288,  1687,   463,     0,
    1687,     0,  1687,  1716,   159,     0,  1687,   288,   614,     0,
       0,  2366,  2370,     0,  2368,  2363,  2088,  2142,  2141,  2038,
       0,  2446,     0,   669,   678,   677,   675,   674,   670,  1599,
    1600,     0,   663,   664,  2152,  2452,   662,   686,     0,     0,
     693,   692,   691,     0,     0,     0,   694,     0,  1195,  1039,
       0,   917,     0,     0,     0,     0,   830,   830,   830,   913,
     227,   225,     0,     0,     0,     0,     0,     0,   919,     0,
       0,     0,  1838,  1839,  1840,  1540,     0,  2292,  1841,  1842,
    1405,  1392,  1401,  1406,  1393,  1395,  1402,  1843,  1844,  1662,
    1845,  1846,  1591,  1847,  1848,  1234,  1850,  1851,  1852,  1397,
    1399,  1853,  1854,     0,  1592,  1856,  1857,  1739,  1859,  1860,
    1862,  1863,  1403,  1865,  1866,  1867,  1868,  1869,  1870,  1590,
       0,  1404,  1871,  1873,  1874,  1875,  1876,  1877,  1878,  1879,
    2350,  1584,  1486,  2349,     0,     0,  1563,     0,  1379,     0,
    1226,  1227,  1249,  1250,  1228,  1255,  1256,  1268,  1229,     0,
    1562,  1293,  1378,  1384,     0,  1377,  1373,  1096,  1558,  1541,
       0,  1374,  1580,  1594,  1593,  2344,  1549,  1583,  1581,  1582,
       0,     0,     0,   190,     0,     0,  2220,   237,     0,   238,
    1566,  1787,   180,   220,   192,   219,   193,   222,   223,   191,
       0,  1625,   181,     0,   188,     0,     0,     0,     0,     0,
       0,     0,   231,   908,     0,  1193,     0,     0,  1547,  1569,
    1192,   623,     0,     0,  1198,     0,   999,   996,  1554,  1553,
    1555,     0,  1090,     0,     0,     0,  1072,  1071,  1002,  1107,
    1108,     0,     0,     0,     0,     0,     0,     0,     0,  1149,
    1130,  1146,  1150,     0,  1078,  1157,  1983,  2129,  2130,     0,
    2124,     0,  2123,  2123,  2117,  2116,  2113,     0,     0,     0,
       0,     0,     0,     0,  2042,   443,  2044,   441,     0,     0,
    2018,     0,  2022,  2020,  2152,  2168,  2152,  2169,  2170,     0,
    2175,  2176,     0,  2153,  2357,     0,     0,  2159,     0,  2148,
    2154,  2156,  2158,  2157,  2166,  2162,  2165,  2167,  2110,  2123,
    2238,     0,  2233,  2236,     0,  2228,     0,  1579,     0,     0,
       0,     0,     0,   617,     0,     0,     0,   124,   963,   230,
     961,     0,     0,     0,     0,   968,     0,     0,     0,     0,
     777,     0,     0,     0,     0,     0,     0,   778,   776,   779,
     786,   799,   802,     0,   713,   163,   164,     0,     0,   855,
     855,     0,     0,   855,     0,     0,     0,     0,     0,     0,
       0,   247,   250,     0,     0,     0,     0,     0,     0,     0,
     127,   154,     0,     0,     0,   428,   440,     0,     0,     0,
       0,     0,   437,     0,   125,   248,   422,   425,     0,     0,
       0,   496,   495,   855,     0,   246,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   127,   156,
       0,     0,   249,     0,  2052,     0,   924,   925,     0,   928,
       0,   983,     0,     0,     0,     0,     0,     0,  1627,  1675,
       0,     0,     0,     0,     0,     0,   324,   307,   308,   125,
     306,     0,     0,   545,     0,  1237,  1266,  1244,  1266,  1266,
    1233,  1233,  1246,  1235,  1273,     0,  1266,  1233,  1238,     0,
    1236,  1276,  1276,  1261,     0,  1218,  1219,  1220,  1221,  1247,
    1248,  1222,  1253,  1254,  1223,  1290,  2297,  1233,  2298,  2295,
    2294,     0,   940,   973,     0,     0,   127,   582,     0,     0,
     546,     0,   127,     0,   168,     0,   491,     0,     0,     0,
       0,     0,     0,   507,   506,     0,     0,   547,     0,   127,
     424,     0,   414,   378,     0,     0,  1633,     0,  1576,     0,
       0,  2012,  2007,  2010,     0,  2000,  2014,  1064,  1066,  1065,
       0,  1063,     0,  1206,     0,   288,   286,   287,   543,   822,
       0,     0,     0,     0,   288,     0,     0,  1687,     0,  1687,
       0,     0,   288,   288,     0,     0,     0,     0,   492,     0,
     613,   611,   610,   612,     0,     0,     0,     0,     0,  1687,
     288,     0,     0,   601,  2364,     0,     0,  2367,     0,  2091,
    1496,     0,  2449,  1021,  2450,   337,     0,     0,  1003,  1010,
    1005,  1007,  1006,  1008,  1004,  1009,   655,   660,   661,     0,
    2451,  2336,  2342,     0,     0,   379,   381,     0,  1648,     0,
    1680,  1704,  1780,  1784,     0,  1805,     0,   695,   718,   690,
       0,     0,  1033,  1026,     0,     0,  1049,   657,  1014,  1498,
       0,     0,     0,   829,   826,   825,   824,   226,   198,     0,
       0,     0,   720,  1779,   916,     0,     0,  1382,  1383,  1265,
    1252,  1539,     0,     0,  1260,  1259,     0,     0,     0,     0,
    1242,  1241,  1240,  1381,  1506,     0,  1239,     0,     0,     0,
       0,  1266,  1266,  1264,  1312,     0,  1243,     0,     0,  1519,
       0,  1525,     0,     0,     0,  1272,     0,  1270,     0,     0,
    1348,     0,     0,     0,     0,     0,     0,     0,  1296,  1297,
    2293,  1379,  1496,     0,  1380,  1587,     0,     0,  1258,     0,
    1290,     0,     0,     0,     0,  1552,  1494,     0,     0,  1326,
    1492,     0,  1328,     0,     0,     0,  1486,  1485,  1483,  1484,
    1477,  1478,  1479,  1480,  1481,  1482,  1490,  1309,     0,  1561,
       0,  1308,  2152,     0,  1159,  1095,  1542,     0,  1585,     0,
    2343,  2345,  1375,  2217,  2216,  2215,  2214,  2185,     0,  2179,
    2180,     0,  2218,  2219,   239,   240,   236,     0,     0,   195,
     194,     0,   217,   218,   187,   216,     0,   212,   213,  1444,
    1443,   196,   186,   184,   209,   211,   210,   208,   182,   199,
     201,   202,   203,   185,   183,   234,   232,     0,     0,     0,
    1544,  1543,  1575,  1548,     0,     0,   288,  2123,  1199,     0,
    1159,  1051,  1053,  1054,     0,  1549,   988,  1557,     0,  1092,
       0,     0,   992,  1088,  1087,  1116,  1117,   737,  1086,  1140,
    1141,  1135,     0,  1155,  1155,  1132,  1123,  1131,  1124,     0,
    1136,  1293,  1148,  1076,  1129,  1075,     0,  1151,  1149,  1130,
       0,  2131,  2129,  2069,  1218,  2123,  2062,  2123,  2118,  2048,
    1284,  1285,  1286,  1287,  1288,  1289,  2049,     0,  2046,  1283,
    2047,   442,     0,     0,     0,  2015,     0,  1996,  2021,  2183,
       0,  2184,     0,     0,  2160,  2163,  2161,  2164,     0,     0,
    1218,  2339,  2234,  2339,  1218,     0,     0,     0,     0,     0,
       0,     0,   618,     0,     0,     0,  1805,   229,   959,     0,
       0,     0,     0,     0,   971,   372,     0,   285,     0,     0,
       0,     0,     0,     0,     0,   784,     0,     0,     0,     0,
     785,   782,   783,  1780,   801,   800,   798,   759,   761,   760,
       0,   763,   747,     0,   748,     0,     0,   758,   766,   764,
       0,     0,   854,   260,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
     283,     0,     0,     0,   282,     0,     0,     0,     0,     0,
       0,   814,     0,   153,     0,     0,   427,   439,     0,   431,
     432,   429,   433,   434,     0,     0,     0,     0,     0,     0,
     426,     0,     0,   489,   488,   494,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   498,
     499,     0,   500,     0,   155,     0,     0,     0,     0,     0,
       0,   207,   923,   927,   986,   985,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   310,     0,   568,  2294,   544,
       0,  1218,     0,  1214,  1210,  1279,  1278,  1277,     0,  1224,
    1233,  1230,     0,   938,   347,   453,   161,     0,     0,     0,
     556,   559,     0,   123,   172,   337,     0,   171,   173,   175,
     176,   177,   174,   178,   486,   490,     0,   461,     0,     0,
       0,     0,     0,   511,   510,   513,   512,     0,   508,     0,
       0,     0,   152,   421,   423,  1991,     0,   339,   403,     0,
     444,     0,     0,     0,     0,     0,  1993,     0,  2013,     0,
       0,     0,     0,  1062,     0,  1169,  1035,  1160,  1171,  1162,
    1164,  1200,  1568,     0,     0,  1033,     0,   805,     0,   966,
    1687,   288,     0,   803,   166,  1571,     0,     0,     0,     0,
       0,   807,   598,   158,     0,   288,   288,   464,     0,   288,
     160,     0,     0,     0,   456,   288,   615,  2365,  2371,  2369,
    1023,     0,  2447,  2448,     0,  1061,   659,     0,     0,  2341,
       0,   687,     0,   377,   701,     0,     0,   700,   711,   702,
     703,   697,   696,   704,     0,     0,   720,  1028,     0,  1029,
    1549,     0,  1025,     0,  1046,     0,  1044,     0,  1196,  1048,
    1037,  1015,     0,  1013,  1018,  1020,  1019,  1017,     0,     0,
       0,   684,     0,     0,   288,   915,     0,  1502,     0,  1503,
       0,     0,     0,  1538,  1534,     0,     0,     0,     0,     0,
    1510,  1511,  1512,  1509,  1513,  1508,     0,     0,  1514,  1507,
       0,     0,     0,     0,     0,  1263,  1262,     0,     0,     0,
       0,     0,     0,     0,  1351,  1384,     0,     0,  1470,     0,
    1496,  1524,     0,     0,  1274,     0,     0,     0,     0,     0,
       0,     0,  1496,  1530,     0,     0,     0,  1442,     0,  1439,
       0,     0,     0,     0,  1549,     0,     0,     0,     0,  1588,
    1294,  1310,  1560,     0,  1551,     0,     0,  1317,     0,  1531,
    1344,     0,  1349,  1332,     0,  1325,     0,  1330,  1334,  1313,
    1552,  1495,     0,  1493,     0,     0,  1311,     0,  1306,  1304,
    1305,  1298,  1299,  1300,  1301,  1302,  1303,  1307,  1474,  1472,
    1473,     0,     0,     0,  1329,  2260,  1681,  1712,     0,  1106,
    1106,  1094,  1104,  1559,     0,  1202,     0,     0,     0,     0,
    1455,     0,  2347,  2346,  1550,     0,     0,     0,  1567,     0,
       0,  1290,     0,   233,  1194,  1545,     0,   621,   622,   620,
    1218,  1058,     0,     0,  1206,     0,  1057,   990,   989,  1556,
    1001,  1093,     0,   735,   736,     0,   740,     0,     0,  1133,
    1147,     0,  1049,  1049,     0,     0,     0,  1138,  1139,  1126,
    1080,  1079,  2067,  2125,  2072,  2093,  2063,  2096,  1292,  2043,
    2085,     0,  2017,  2186,  2187,     0,  2177,  2178,  2150,  2155,
    2224,     0,  2340,     0,     0,   566,   565,     0,     0,     0,
     866,   832,   619,   867,   833,   960,     0,   962,     0,     0,
       0,     0,     0,   288,   969,   868,   284,   970,   859,     0,
       0,     0,   469,   470,     0,   780,   781,   869,   834,     0,
     860,   762,  1233,   746,     0,     0,   757,     0,   756,  1233,
    1233,   835,   162,   252,     0,   857,   264,   277,   272,   273,
     271,   288,   288,     0,     0,     0,     0,   274,   269,   270,
     266,   279,   280,   843,     0,   294,   297,   281,   262,   265,
     263,   251,     0,  1574,     0,     0,   809,     0,     0,   846,
       0,     0,   136,   138,   140,     0,     0,   134,   142,   137,
     139,   141,   135,   143,   133,     0,     0,   132,     0,     0,
       0,     0,   126,   874,   839,   430,   435,   841,   438,   862,
     436,  1605,  1663,  1788,     0,   476,   478,     0,   483,   880,
     840,     0,   861,   876,   848,     0,     0,     0,     0,     0,
       0,     0,   975,     0,     0,     0,   875,   853,   864,     0,
     847,   842,   863,     0,     0,   205,   204,   206,     0,     0,
       0,     0,     0,     0,     0,     0,   654,   630,   653,     0,
       0,     0,     0,     0,     0,     0,   624,   323,   304,   305,
       0,   303,   567,     0,     0,     0,  1215,  1211,     0,     0,
       0,     0,     0,     0,  1231,     0,     0,   958,   958,   958,
     958,   958,   958,   958,   939,   967,   452,   472,     0,   587,
     555,     0,     0,   378,   167,     0,     0,     0,   460,   554,
     552,   551,   553,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,     0,     0,   338,   340,   342,   343,   344,
       0,   415,   417,     0,     0,   407,     0,     0,     0,     0,
     726,   751,     0,   769,   752,     0,     0,     0,   789,   794,
     790,   772,     0,  2011,  2005,  1067,  1068,     0,  1082,     0,
    1171,     0,  1170,  1182,     0,     0,  1188,  1186,     0,  1188,
       0,  1188,     0,  1163,     0,  1165,  1182,  1569,     0,     0,
    1203,  1034,   288,     0,     0,   466,   288,     0,   288,     0,
     288,   288,     0,   900,   493,     0,   540,     0,     0,   288,
     600,  1497,     0,     0,  2151,  2337,   688,   380,     0,   699,
       0,     0,   710,   705,   707,     0,   714,     0,     0,  1031,
       0,  1047,  1040,  1042,  1041,     0,     0,  1038,  1499,   599,
       0,     0,   288,     0,   715,  1111,  1500,  1501,     0,     0,
       0,     0,  1535,     0,     0,  1418,  1394,  1396,  1232,  1408,
       0,  1245,  1419,  1420,  1398,  1400,     0,  1487,     0,     0,
    1409,  1353,  1354,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1366,  1365,  1410,  1469,
       0,     0,  1522,  1523,  1411,  1275,  1276,  1276,     0,     0,
    1529,     0,     0,     0,  1416,  1421,     0,     0,  1426,     0,
    1447,     0,     0,     0,  1376,  1497,  1267,  1268,     0,     0,
       0,     0,     0,     0,     0,     0,  1350,  1333,  1327,     0,
    1331,  1335,     0,     0,     0,     0,  1319,  1345,  1315,     0,
       0,  1321,     0,  1346,  1106,  1106,  1106,  1106,  1103,     0,
       0,  1158,     0,  1143,     0,     0,     0,  1455,     0,  1385,
    1455,     0,  2199,  2201,  2202,  2203,  2204,  2205,  2207,  2208,
    2210,  2211,  2212,  2200,  2206,  2209,  2213,  2190,  2191,     0,
    2181,  2182,   189,     0,   214,   200,     0,  2224,     0,     0,
    1052,  1033,  1055,  1118,     0,  1488,   740,   738,   739,  1120,
       0,     0,  1154,  1153,  1152,  1121,  1125,  1122,     0,     0,
    2127,  2053,     0,     0,  2223,  2226,  2237,  2235,  2065,   865,
     831,   858,   958,     0,   371,     0,     0,     0,   972,   451,
       0,   450,   448,   468,   774,     0,  1233,   749,   754,   755,
       0,   347,     0,     0,   253,     0,   261,   258,   275,   267,
     276,   268,   291,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   871,   148,     0,     0,     0,
       0,   129,   128,   149,   147,     0,   146,     0,   480,   481,
     479,   475,     0,   482,   484,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   870,   836,   625,
       0,     0,   626,   634,     0,     0,   627,     0,     0,     0,
       0,     0,     0,   636,   326,   311,   315,   974,   974,     0,
     316,   974,   312,   974,   309,   569,     0,  1739,  1477,  1478,
     563,   570,   560,   562,   561,   564,   535,     0,     0,     0,
    1216,     0,  2437,  2445,  2444,     0,  1290,     0,   958,   957,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     358,     0,     0,   352,     0,     0,   794,   346,   349,   350,
       0,   465,     0,   557,   558,     0,   337,     0,     0,   515,
     509,     0,   571,   549,     0,  1209,   472,  1024,   420,   339,
     364,   399,     0,   413,     0,   401,   400,   402,     0,   409,
     936,   453,     0,   726,     0,     0,   750,     0,     0,     0,
     787,   791,   788,     0,     0,   765,     0,   773,   743,     0,
    2028,  1060,  2037,  1173,  1180,     0,  1161,     0,  1187,  1183,
       0,  1184,     0,     0,  1185,     0,     0,  1180,     0,     0,
       0,   806,     0,   288,   804,     0,   594,     0,   596,   808,
     288,   288,   501,     0,   457,   414,  1066,   698,   712,   708,
       0,     0,   681,   717,  1027,  1030,  1032,  1045,  1043,   720,
       0,   682,   719,  1504,  1251,     0,  1537,  1533,     0,  1505,
       0,  1517,  1516,  1352,  1518,     0,  1371,     0,     0,  1363,
    1361,  1362,  1355,  1356,  1357,  1358,  1359,  1360,  1364,  1527,
    1526,  1520,  1521,  1271,  1269,     0,  1413,  1414,  1415,  1528,
    1422,     0,  1441,  1440,     0,     0,     0,  1428,     0,     0,
    1437,     0,  1471,  1257,  1290,  1295,     0,     0,  1318,  1532,
    1336,     0,     0,     0,  1314,     0,     0,     0,     0,  1323,
    1487,     0,     0,     0,     0,     0,     0,  1098,  1097,  1201,
       0,  1145,  1455,  1455,  1455,  1391,  1458,  1453,  1454,  1386,
    1586,     0,     0,     0,     0,  1546,  2222,     0,  1059,  1050,
       0,  1119,  1134,  1127,  1135,  2071,     0,  2126,  2188,  2189,
       0,   373,     0,     0,   794,   879,   449,   775,     0,   767,
     345,     0,   856,     0,     0,     0,     0,   295,   296,   299,
       0,     0,     0,     0,     0,   588,   574,     0,     0,   589,
     590,     0,     0,   811,   812,   810,   144,   130,   151,   150,
     131,   145,   477,   844,     0,     0,     0,     0,     0,   878,
     852,   877,   850,   849,   851,   845,   503,     0,   628,     0,
       0,   629,   640,   638,   637,   639,   631,   327,   125,     0,
       0,     0,     0,     0,     0,     0,   537,     0,     0,   542,
     531,   533,     0,     0,     0,  1212,     0,     0,     0,     0,
       0,     0,  1217,  1225,   530,     0,   949,   948,   947,   951,
     950,   953,   952,   944,   943,   956,   955,   942,   941,   946,
     945,     0,     0,   356,   360,   361,   359,   351,   794,   378,
     411,     0,     0,     0,     0,     0,   517,     0,   550,     0,
    1208,   497,  1022,     0,  1992,     0,   362,     0,   403,   341,
     416,   417,     0,     0,   412,     0,   931,   455,     0,     0,
     725,     0,   753,   770,   771,     0,     0,   794,   793,   895,
     896,   893,   894,     0,     0,  2001,  1172,     0,     0,  1174,
       0,     0,  1176,  1178,     0,     0,     0,     0,     0,  1572,
    1455,  1204,  1205,   288,   467,   288,   288,   901,   541,     0,
       0,     0,     0,   706,   288,     0,  1536,  1407,  1417,  1515,
       0,     0,  1372,     0,     0,  1412,  1872,     0,     0,  1445,
    1446,  1427,     0,  1725,  1432,     0,     0,     0,  1589,  1342,
    1340,  1337,     0,  1338,     0,     0,  1320,  1316,     0,  1322,
    1347,  1102,  1101,  1100,  1099,     0,     0,  1449,  1389,  1390,
    1387,  1460,  1457,     0,  2192,     0,  2195,  2193,  2194,  2198,
    1290,  1056,     0,     0,  2128,   964,     0,   794,   411,   768,
     254,   255,   256,   257,   290,     0,   872,   837,     0,     0,
     580,     0,     0,     0,     0,   873,   838,     0,     0,     0,
     980,     0,     0,   632,   633,   310,     0,   313,   318,     0,
     319,   314,   317,   539,   538,   536,   532,   534,  1213,     0,
     820,   820,  2438,  2439,  2440,  2441,  2442,  2443,     0,   535,
     954,     0,     0,   348,   411,   385,     0,   353,     0,   473,
       0,   936,   339,   472,   516,     0,     0,   572,   418,     0,
     403,     0,     0,   363,     0,   407,     0,   404,     0,   408,
       0,     0,     0,     0,   445,     0,     0,     0,     0,   727,
     734,   734,   792,     0,   796,     0,   764,   741,     0,  2027,
    2031,     0,  1181,  1190,     0,  1177,  1175,  1166,     0,  1168,
     821,   595,   597,   502,     0,   709,   716,   288,  1367,     0,
       0,     0,     0,  1423,     0,  1424,  1429,  1433,     0,  1430,
    1431,  1339,  1343,  1341,  1324,  1142,  1144,     0,  1083,     0,
    1115,  1455,  2197,  2196,   215,  1489,     0,     0,   411,   374,
       0,   259,   298,     0,     0,   586,   575,     0,     0,   591,
       0,     0,     0,     0,     0,   635,   302,   325,   320,   820,
       0,   817,   816,   529,     0,   355,   354,     0,   390,     0,
     471,     0,   584,   932,   485,   518,   519,   514,     0,   419,
     407,   368,   366,   370,   367,   365,   369,     0,   409,   405,
     406,     0,   933,     0,   454,   982,     0,     0,   293,     0,
       0,   732,   737,   737,   795,     0,     0,  1202,     0,  2029,
    1179,     0,  1167,   683,  1368,     0,  1369,     0,     0,  1435,
    1434,  1448,  1450,     0,     0,  1463,  1114,  1388,  1128,   378,
     375,   289,     0,   578,   585,   576,   586,     0,     0,   976,
       0,   977,   978,   981,   815,   819,   818,     0,   382,   383,
     384,     0,   357,   386,   387,     0,   474,     0,     0,     0,
     409,   398,   329,   934,   935,   293,   734,     0,   409,   728,
     733,   740,   740,   794,   797,     0,  2032,  2034,  2033,     0,
    1189,  1370,  1438,  1425,  1436,     0,     0,  1459,     0,     0,
       0,   385,     0,   577,   593,   592,     0,     0,     0,     0,
       0,   388,     0,   389,   410,   583,     0,   522,   330,   409,
     737,   292,  1202,   730,   729,   742,   899,  2030,  1451,  1452,
       0,     0,     0,  1461,  1464,  1462,  1456,   390,     0,   979,
       0,   395,     0,   394,     0,   392,   391,   573,   527,     0,
     520,   523,   528,   526,   524,   525,  1202,   740,   721,   898,
     897,     0,     0,  1468,  1467,  1466,   535,   579,     0,   393,
     397,   396,   504,     0,   722,   731,   881,   892,  1994,   882,
     890,   887,   889,   888,   886,     0,   376,     0,   521,     0,
     891,   885,  1082,  1069,  1465,     0,   883,   892,   522,   884,
       0,   505
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   245,   246,  1588,  2253,  2822,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1618,   256,   257,  1215,
    1764,  2357,   258,  2177,  1011,  2058,  2059,  2302,  2060,  2044,
    1454,  2061,  1589,  1610,   260,   261,  1448,  2036,   262,   263,
     264,  1631,  1632,  1595,  1808,  4001,  2244,  4128,  2784,  2785,
     265,   266,  2890,  1709,  2891,  3334,   841,  2324,  3658,  3659,
     267,  1761,  2944,  2945,  2946,  2947,  2915,  3377,  3378,  3379,
    2948,  3726,  3923,  2949,  2185,  1310,  1874,  1875,  4028,  4112,
    4113,  4114,  4195,  3728,  2955,  3409,  3734,  3907,  1781,  2388,
    2950,  2951,  3724,   268,   269,  2383,  1656,  1657,  2258,  3340,
     270,   869,  3241,  2916,  2917,  3934,   271,   829,   272,  1768,
     273,   274,   275,   276,  3381,  3908,  1661,  2834,  2835,  2836,
    2837,  3293,   277,  1766,  1662,  2366,   278,   279,   280,  2291,
     281,   282,   283,  1775,  2377,  2378,  3717,  3915,  4037,  4199,
    4200,  3899,  3669,  3670,  3671,   284,   285,   286,   287,  1760,
    2349,  2350,  3341,  1579,  1713,  2326,  2327,  3391,   288,  3615,
    3616,   870,  4118,  4095,   289,   290,  3619,  3620,   291,   292,
     293,   294,   295,   918,  1277,  1278,  2760,   296,  2076,   297,
    1194,  2877,   298,   940,   941,   299,   300,   950,  2501,   952,
    1886,  3032,  3033,  3472,  2467,  1130,   301,   302,  2476,  2504,
     303,   871,  3415,  3938,  3939,  4062,  2676,  3209,   304,   872,
    1614,  2213,  2395,  2962,  2963,  2215,  2216,  3424,  2217,  2964,
    2969,  2970,  2971,  3420,  3428,  3944,  3945,   305,  1612,  2206,
     306,   307,   308,  1636,  1146,   309,  4021,   310,  1247,   311,
     970,  1904,   312,  2224,  3255,   313,   314,  4228,  4239,  4240,
    4241,  3753,  4211,   315,  4230,   317,   318,   319,   832,  1166,
    1167,  1168,   320,  3736,   321,   322,  2343,  2914,  3360,   323,
     324,  2178,  2727,   325,   326,   327,  1754,   328,   329,   330,
     331,  1691,   332,   333,   334,   836,  1034,  1487,  1495,   335,
    1858,   926,   336,  1324,  2493,   337,  1291,  4231,  1892,  2478,
    2479,  2482,  4232,  1803,   340,  1896,  2487,  2490,  4233,  2080,
    2081,  2082,  2083,  2084,  2662,   342,  1241,  2402,  4234,  1408,
     345,   346,   347,   348,  1038,  1039,  2014,  2631,   959,  1501,
     996,  1049,  1050,  2095,  2096,  2114,  2115,  2106,  2678,  2108,
    2109,  2689,  2101,  3561,  3827,  2112,  2113,  1511,  1512,  2682,
     349,  2635,  2406,  2407,  2408,  2982,  2992,  3439,  3762,  2409,
    1319,  1032,  2410,  3163,  2415,  2936,  2937,  2218,  2334,  1735,
    1409,  1736,  2341,  1410,  1936,  1738,  1411,  1412,  1413,  1741,
    1414,  1415,  1416,  1417,  1920,  1978,  1418,  1419,  1955,  1078,
    1079,  1850,  2543,  1421,  1422,  3530,  3806,  3797,  2568,  2569,
    2051,  3526,  3988,  4081,  4082,  3569,  3567,  3831,  3990,  4150,
    4183,  4184,  1423,  2621,  2006,  1148,  1424,  3343,  2008,  2563,
    2166,  1918,  2510,  2526,  2527,  2540,  3079,  2547,  2552,  3102,
    3103,  2564,  2590,  1425,  2513,  2514,  3063,  1922,  1426,  1478,
    1974,  2022,  2586,  1490,  1491,  1036,  1427,  1428,  1429,  1887,
    1023,  3758,  1255,   683,  2792,  2071,  1170,   956,  1430,  1431,
    1432,   661,  1535,   662,   663,  1118,   787,  1024,     2,    75,
     352,  2941,   353,  2972,   354,   355,   874,   875,   876,  1233,
    1234,  1792,  1795,  1540,  2147,   664,   665,   884,  3755,  3949,
    4069,   924,   356,   357,   358,   359,  1536,  2143,  1080,    76,
      84,    77,  1081,   395,   396,  2125,   360,   804,  2126,  1517,
    1060,  3220,   362,   363,   364,   365,   366,   921,   367,  1062,
     368,  1063,   369,   370,   371,   372,  1070,   373,  1519,  1520,
    3587,  1521,   374,   375,   685,   686,  1289,   376,   377,  1098,
    1099,  1100,  1305,  1869,  1559,  1560,  1561,   378,   679,   379,
     380,   381,  1550,  1551,   382,  2029,  2030,  2150,  2031,   383,
    2703,  2704,   384,  3187,  3188,  3837,  3189,   385,  2025,   386,
     387,  1027,  3225,   388,   800,   389,  1112,   666,   667,   668,
    1120,   790,   983,  1025,  1121,  2838,   792,   793,   670,   671,
     672,  1870,    78,  2711,  1871,  1433,  1434,  2020,  1435,  1436,
    1437,  1438,  1439,  1567,   676,  1088,  1281,  1282,  2712,  1284,
      82,  1285,   393,  3355,  1853,  1306
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3839
static const int yypact[] =
{
   -3839,   363, 16995, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, 18250, -3839,
   -3839, -3839, -3839, -3839, 83140,   379, -3839, -3839, -3839, 44968,
   -3839, -3839, -3839,   189, 55826, -3839, 63362,   643, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, 69485, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, 48278,   330, -3839,
     314, -3839, -3839, -3839, -3839, -3839, -3839, -3839,   825,  5937,
   -3839, -3839, 60065, -3839,    43, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, 63833,   427, -3839,   662,  1199,    51, 11088, -3839,
   -3839, 45914, 58181, -3839, -3839, 69956,   802,   370,  3996,   825,
   17776, 64304, -3839,  1793, -3839, 42566, -3839, -3839, -3839, 56297,
   -3839, -3839, -3839, -3839,   786, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, 69485,   937,   678, 43050, -3839, -3839, -3839,
   -3839, 69485, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, 64775, -3839,   776,  1176, 70427, 70898, 55355, -3839,
    1267, -3839, 69485,   988, 47806, -3839, 71369, -3839, -3839,   748,
   -3839, 58652, -3839, -3839, -3839, -3839,   678, -3839, 48278, 40642,
   58652,  1166,   877, -3839, -3839, 71840, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839,  1437,   948, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839,   427, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839,   841, -3839,  1119,   857,  1528,   979,
   -3839, -3839, -3839, -3839,  9183, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, 84541,  1651, -3839, -3839, -3839,   990, -3839,  1011,
   -3839, -3839, -3839,  1464, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839,   746, -3839, -3839, -3839,  1504, 83607, -3839, -3839, 65246,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   45441, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839,   118, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, 69485, 69485,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, 65246,  1290, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839,   399,  1412, -3839, -3839,
   48278,  2044,  2044,  1690, 84541, -3839, -3839, -3839, 49222, 69485,
   69485, 69485,  1554, 49222, 69485, 60536, 37257, -3839, 69485, 69485,
   60536, 69485, 58652, 69485,  1386, 69485, 69485, 72311, 60536,  1524,
   -3839,  1765,   567, -3839, -3839, -3839, 60536,  5285,   937, -3839,
   -3839, 60536,  1371, 49222, 69485,  1326,  1406, 69485, -3839, 69485,
    1682,   805, 69485,  1170, 37745,  1489, 69485, 69485, 69485, 69485,
   -3839, -3839,  1487, 69485, -3839, 69485, -3839, 72782,  1450,  1550,
    1831,  1671,   432, -3839, -3839,  1529,  1535, -3839, -3839,  1960,
   65246, -3839, 61007, -3839, -3839, -3839,    98, -3839, 58652, -3839,
   -3839, -3839, -3839, 49694, 69485,  1817, -3839, 73253, -3839,  1886,
   50166, 73724, -3839, 38233,  1941, 74195, 74666, -3839, -3839, 75137,
   -3839, 75608,  1687, 76079, -3839, 76550, -3839,  1809, 77021, -3839,
   19661, -3839,  1576,  1917,  1590, -3839,   427,   197, -3839,    87,
     -35,   112, -3839, -3839,   -11,    41,    58,   197,  1618,  1618,
   61478, 69485,  1861, -3839, -3839, -3839,   -80,  1610,  1610,  1610,
    1804,  -106, -3839,  1610, 60536, -3839, -3839, -3839, -3839, 58652,
    1146, -3839, -3839,   937,   -22,  2010, 69485, -3839, 69485, -3839,
   60536, 69485, -3839, -3839, -3839,  2028,  1664,  1895, -3839,  1657,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839,  1844,  1876,  1898,
     -13,   937,  1752, -3839, -3839,  1908, 24674,   -93, 65246,   937,
   43534, 59123, 81260,   161, 46860,   937, 77492,  1761,   567,  1922,
   -3839,   884, -3839,  2146,  1783,  2015,   -16,   567, -3839, -3839,
   34874, -3839,  1381,  1788, -3839, -3839, 58652, 85008, -3839, -3839,
   -3839, 77963,  1902, -3839,  2080, 25167, -3839, 69485,  1806, -3839,
    1805,  1799,  1812, -3839, 60536,  1043,  1043,  2205,  1043,  1327,
    1366, -3839,  1250, -3839,   877,   825,  1829, -3839, -3839, -3839,
    1845, -3839,  1839,  1842, -3839,   691,  2113, -3839, -3839, -3839,
   -3839,  1955,  1962,  1972,  1985,  1914,  2011,   241, -3839, -3839,
   -3839, -3839,  2175, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
    2336,  2328, 45914, 45914,  2019,   484,   115,   152, -3839, -3839,
   -3839,  2218, -3839, -3839,  2223, 69485,  2053, 69485, -3839, -3839,
   -3839, 78434, -3839, -3839,  2044,  1845,  1381,  2013, -3839,   206,
   -3839, -3839,   212,   308,   349,     3,  1988,  1553,   771,  2049,
    1235,  2018,   231,  2256, 69485, 69485, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839,  2020, -3839, -3839,  2017,
    1462,  1041,  7799,   734,  2966,  1202,   944,  2201,  1103,  2311,
    1563,  3053, 69485,  2022,  2254,   390, -3839,   495, -3839,  2086,
    2210,  2212, 49222,  2034, -3839, 69485, -3839, -3839, -3839, 49222,
   -3839,  2222, 38721, -3839, 69485, -3839, -3839, -3839, -3839,  2156,
   69485, -3839, -3839,  2285, 69485, -3839,  1610,   325,  2050,  2422,
   52526, 69485,  2093,  2455,  2095, -3839, -3839,  2093, -3839, -3839,
   69485, 69485,  2060,  1117,  2093,  2457,  2464,  2141,  2241,  1007,
     900,    55,  2362,  2093, 60536, 60536, 60536,  2313, 69485, 78905,
   49222, 69485, 65717, -3839,  2072,  1529, -3839, -3839, -3839, -3839,
   -3839,   789,  2136,  2377,  2013,   273,  2378,  2082,  2380, -3839,
    2122,  2382,  2018,  2383,  2084, -3839, 79376, 79847,  2385,  2020,
   69485,  2387,  2084,  2389,  2273,  2391,   273,  2392, -3839,  1193,
    2408,  2292,  2410,  1552,  2084, 47333,  2413,    67, -3839, 19742,
   19661, -3839, 20275,  1447, -3839, -3839, -3839, -3839, -3839, -3839,
   27632,   514,  1457, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, 69485,  1861,  1861,  1414, -3839, -3839,  2121, 69485, 69485,
   -3839, -3839, -3839, 56768, 69485, 59594, -3839,   684, -3839,   -66,
   69485, -3839,  1917, 52526,  2522, 69485,  2414,  2414,  2414, -3839,
   -3839, -3839,  2353, 69485,  2417,  2419, 56768, 69485, -3839, 80318,
    2127,  -147,  1101,   196,  1135, 27632,  2133,   145,   145,  2134,
   -3839, -3839, -3839,   366,  2135,  2138, -3839,   373,   373,  2294,
    2139,  2140, -3839,   401,  2142, -3839,  1157,   428,  2143,  2144,
    2145,  1950,   145, 27632, -3839,  2147,   373,  2149,  2150,  2151,
    1232,  2152, -3839,  1241,  2155,   303,   362,  2158,  2159, -3839,
    2139, -3839,   175,  2160,  2164,  2165,  2166,  2167,  2168,  2169,
   -3839, -3839, -3839, -3839, 27632, 27632, -3839, 23688,  1381,   937,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839,    57, -3839,   460,
    8365, -3839, -3839,  2326, 27632, -3839, -3839,   431, -3839,  1381,
     468, -3839, -3839, -3839, -3839,  1365, -3839, -3839, -3839, -3839,
    1667,  1667,   140, -3839, 60065, 60065, -3839, -3839,   136,  2171,
   -3839,  1603, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   46387,  2575, -3839,  2521,   495,  1047,  2514, 41114, 41598,  1861,
    1861,  2411, -3839, -3839, 60536, -3839, 27632, 39698, -3839,  1381,
   -3839,    31,  2424, 69485, -3839, 35346, -3839,   427, -3839, 10270,
   -3839,  1358,  1806, 69485, 69485,  2578, -3839, -3839,  1805, -3839,
   -3839,  1528,  1528, 27632,  1528,   725,   -49, 25660, 27632,  2474,
    1031,  2475, -3839,  1327,  1366, -3839, -3839,  1845,  2196,  1617,
   -3839, 54413, 84074, 84074,  2440, -3839, -3839,   603,   727,  2310,
    2405,  1618,   994,  1151, -3839, -3839,  2192, -3839,  2525, 60065,
    2257, 45914, -3839, -3839,  2659, -3839,  2659, -3839, -3839,    81,
    2197, -3839,  2216, -3839, -3839,  1151,  1151, -3839,  2688, -3839,
    2203, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, 84541,
    2207, 69485, -3839,  2208,  2209, -3839, 85008,  1381, 40170,  1179,
    2288,  2290, 48278,  2211,  2293,  2297, 81731, -3839, -3839, -3839,
   -3839,  1324,   940,  2298,   575, -3839, 69485,  2394,   241,  2343,
   -3839,  2305,  2306,  2420,   241,   155, 82202, -3839, -3839, -3839,
   -3839, -3839,  3404, 21761, -3839, -3839, -3839,  2307,  2291,   154,
    2595,  2415,   -55,  1531,   418, 60536,  2491,  2312,  2321,  2244,
    1637,  2242, -3839,  2304,  2308, 51582,  2416, 39209,  2325, 81260,
   -3839, -3839,  2331,  2334,   241, -3839,  2631,   241,   241,  1128,
    2640,  2339,   453,  1096,  2093,  2242,  1957, -3839,  2258,  2342,
     244, -3839,  2441,   109,  1380,  2242,  2344,  2345, 69485, 69485,
   69485, 69485, 60536,  2346,  2347,  2395, 61949,  2351, -3839, -3839,
    2354,  1538,  2242,  1435, -3839,  1340, -3839, -3839,   567, -3839,
   69485, -3839, 60536,  2013, 52526,  2458,  2018,   241, 69485, 69485,
    2020,   511,  1257,  2460, 69485,  2520,  2322, -3839, -3839,  2093,
   -3839, 40170,  2060, -3839,  2282, -3839,  2335, -3839,  2335,  2335,
    2284,  2284,  2286, -3839, -3839,  1950,  2335,  2284, -3839, 53470,
   -3839,  1224,  1258, -3839,  2686,  2689, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839,  1518, -3839,  1470, -3839, -3839,
   -3839,  2700, -3839, -3839, 52526, 69485, -3839,  2618,  2350, 48278,
   -3839,  2340, -3839, 69485,   156,   937,  2348, 69485,  2515, 69485,
   69485, 69485, 69485, -3839, -3839,   815,    -3, -3839, 61949, -3839,
    1957,  2695,   440,  1610, 46860,  2586, 69485,  2483, -3839,  2309,
    2705, -3839, -3839,  2315,  1618, -3839,  2072, -3839,  1686, -3839,
    2427, -3839, 31069,  2356, 49222,   273, -3839, -3839, -3839, -3839,
   52526, 69485, 80789, 49222,   273, 69485, 69485,  2611,  2373,  2615,
    2379, 39209,   273,   103, 69485, 69485, 60536, 69485, -3839, 69485,
   -3839, -3839, -3839, -3839, 69485, 60536, 69485, 61949,  2616,  2617,
     273, 69485, 69485, -3839, -3839, 20009,  1501, -3839, 19661, -3839,
   10270,  1608,  1861, -3839,  1290,  1207, 69485, 65246, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839,  1861, -3839, -3839,  2806,
    2327, -3839,  1365, 69485,  1612, -3839, -3839,  1627, 69485,    64,
   49222, 69485, 69485, 60536, 60536, 69485,  2407,  2171,   527, -3839,
    2384, 34402,  2466, -3839,   143, 58652,  2524, -3839, -3839, -3839,
    1635,   687,   627, -3839, -3839, -3839, -3839, -3839, -3839, 59594,
   56297,  2621,   -63, 69485, -3839, 27632, 24181, -3839, -3839, -3839,
    2365, 10270,  2381, 27632, -3839, -3839, 27632,  1618,  1618, 27632,
   -3839, -3839, -3839, -3839,  2329,  1618, -3839, 27632, 27632,  1618,
    1618,  2335,  2335, -3839,  5152, 27632, -3839, 39209, 27632, 29111,
   21267, 27632,  2425,  2372,  1618, -3839,  1618, -3839, 27632, 23195,
   -3839, 27632,  2550, 27632,  1047,  2560, 27632,  1047,  2774,  2774,
     877,  1797,  4080,  2367,  1381, -3839,  2461,  1618, -3839,  1618,
    1221, 52526, 27632, 48278,  2433,   165, 27632,  2371,  1764, -3839,
   27632,   638, -3839,  2375, 27632,  2432,   114, 27632, 27632, 27632,
   27632, 27632, 27632, 27632, 27632, 27632, -3839, 29604,   260, -3839,
     654,   478, 57239, 24674,  2650, -3839,   181, 20773, -3839, 65246,
   -3839, -3839,  1381, -3839, -3839, -3839, -3839, -3839,    81,  2374,
   -3839,  2393, -3839, -3839, -3839, -3839, -3839, 60536,  2575, -3839,
   -3839,  2454, -3839, -3839, -3839, -3839,   671, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,  2376, -3839,
   -3839, -3839, -3839, -3839,  2376, -3839, -3839,  1861,  2386,  2074,
   -3839, -3839, -3839, -3839,  2651,  2653,   273, 84541, -3839, 69485,
       0, -3839, -3839, -3839,  2398, -3839, 57710, -3839, 25167, -3839,
    1639,  2139, -3839,  2628, -3839,  2390, -3839,  8448,  2628, -3839,
   -3839,   107,  2568,  2577,  2577, -3839,   -43, 10270,  2623,  1775,
   10270,  1802, -3839, -3839, -3839, -3839,   -64, -3839,  2474,  1031,
    1679, -3839,  1845, -3839, -3839, 18722, -3839, 19196, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839,  2397, -3839, -3839,
   -3839, -3839,   241,  2402,  2853, -3839, 45914, -3839, -3839, -3839,
    1960, -3839,  1960,  2881, -3839, -3839, -3839, -3839, 65246,  1271,
   -3839, 19661, -3839, 19661, -3839,  2404,  1665,  2477,  2484,  2528,
   69485, 69485, -3839, 48278, 69485, 69485, 69485, -3839,  2766,  2409,
   69485,  2654,  2655,  2429, -3839, -3839, 69485, -3839,  2601, 69485,
   27632,  2604, 69485,  1165,  2609, -3839,   876, 69485, 69485,  2605,
   -3839, -3839, -3839, 46860, -3839, -3839, -3839,  2607, -3839, -3839,
   53470, -3839, -3839,  1685, -3839, 52998, 50638, -3839, -3839,   664,
   69485, 69485, -3839, -3839, 69485, 69485, 69485, 69485, 62420, 69485,
   69485,   996,  1003, 69485, 62891, -3839, 60536, 69485, 69485, 48278,
   -3839, 69485,  2619,   645, -3839,  2569, 69485, 69485,  2435,  1699,
    2517, -3839, 69485,  4526, 69485, 69485, -3839, -3839,   241, -3839,
   -3839, -3839, -3839, -3839, 69485, 69485,   241, 69485,   241,  1213,
   -3839, 48750, 69485, -3839, -3839, -3839, 69485, 69485, 69485, 69485,
   69485,   762,  1026,  2579,  2581,  2583, 69485, 69485, 69485, -3839,
   -3839,  2561, -3839, 69485,  4526, 69485, 69485,  2527,  2529,    56,
    2600, -3839, -3839, -3839, -3839, -3839,  2697,  2854, 69485,  2707,
    2708,  2530,  2534,  2712,   843, 69485, 69485, 69485, 69485, 69485,
   69485,  2713,   843,  2639,   524, -3839,  1702, -3839,  2493, -3839,
   27632,  2871, 52526,  2487,  2488,  2559, -3839,  2565,  1618, -3839,
    1604, -3839,   815,  1471, -3839,   332,  4526,  2769, 69485,  1707,
   -3839,  2503, 60536,  4526, -3839,  2558, 56297, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839,  2777, -3839,   937,  2060,
    2060,  2060,  2060, -3839, -3839, -3839, -3839,  1581, -3839,  2496,
   69485,  2610,  4526, -3839,  1957,  2789, 60536, 54884,  1870,  2897,
    2773,   937,  2683, 60536, 22241,  3694, -3839, 65717, -3839,  2511,
    2778,  2779,  2801, -3839, 30590, 66188,  2513,  1573, -3839, 66188,
   66659, -3839,  1381,  2519, 26153,  2466,  2013, -3839,  2916, -3839,
    2824,   273,  2018, -3839,  2084, -3839, 69485, 69485, 69485, 69485,
    2020, -3839, -3839,  2084,  2709,   273,   273, -3839,  2711,   273,
    2084,  2641,  2819, 46860, -3839,    67, -3839, -3839, -3839, -3839,
   -3839, 27632, -3839, -3839,  2620, -3839, -3839, 65246,  1960, -3839,
    1716, -3839, 69485, -3839,  2084,  2572, 69485,  2532, -3839,  2084,
    2084,  2171,  2171,  2084, 67130,  2948,  2815, -3839,  1726, -3839,
   -3839, 24674, -3839,    47, -3839,   540,   772,  2755, -3839, -3839,
   -3839, -3839, 52526, -3839, -3839, -3839, -3839, -3839, 69485,    35,
    2727,  2545, 67130,  2935,   273, -3839,  1734, -3839,  1521, -3839,
    1526, 27632, 27632,    20, -3839,  7102,  1741,  2552,  2555,  1747,
   -3839, -3839, -3839, -3839, -3839, -3839,  2557,  2844, -3839, -3839,
    2562,  1748,  1756,  2564,  2566, -3839, -3839,  4255,  2567,  9208,
    2574, 29111, 29111,   402, -3839, -3839, 29111,  2580, -3839,  1762,
    9180,  2563,  2582,  2598, -3839,  2584,  2585,  9526, 26646, 27632,
   26646, 26646,  9555,  2563,  2591,  1763, 48278,  9871,  1769, -3839,
   27632, 48278,  5109, 27632, -3839, 27632, 69485,  2592,  2593, -3839,
   -3839,  5152, -3839,  2622, -3839, 29111, 29111,  3708, 23688, -3839,
   -3839,  2852, -3839, -3839,  1706, -3839,  2576, -3839, -3839,  4049,
     184, 27632,  2371, 27632,  2657, 39209, 10343, 27632,  4579,  3204,
    3204,   129,   129,    84,    84,    84,  1121,   478, -3839, -3839,
   -3839,  2606,  2152, 27632, -3839,  3063,  1586,  1638, 60536,  5519,
    9568, -3839, -3839, -3839, 31069,  2626, 27632, 27632, 27632,  2599,
    2772,  1770, -3839, -3839, -3839,  1025,  2881,    81, -3839,   567,
    1618,  1221, 42082, -3839, -3839, -3839, 27632, -3839, -3839, -3839,
   -3839, -3839,  1776, 35346,  2356, 25167,  1381, -3839, -3839, -3839,
   -3839, -3839, 27632, -3839, -3839,  2739,  1808, 27632,  1775, -3839,
   -3839, 60536,  2524,  2524, 27632, 27632, 25660, -3839, -3839,  2895,
   -3839, -3839, -3839, -3839,  1346, -3839, -3839, -3839, -3839, -3839,
   -3839,  2603, -3839,  2602, -3839,  2625, -3839, -3839, -3839, -3839,
     102,  2612,  2613,  2614,  1272, -3839, -3839, 69485, 69485, 69485,
   -3839, -3839, -3839, -3839, -3839, -3839,  2835, -3839, 27632,   122,
    2624,  2627, 69485,   273, -3839, -3839, 10270, -3839, -3839,  2669,
    2696, 69485,  2441, -3839,  2870, -3839, -3839, -3839, -3839,  2811,
   -3839, -3839,  1470, -3839, 50638, 52998, -3839, 52998, -3839,  1470,
    1479, -3839,  2084, -3839, 52526,    69, -3839, -3839, -3839, -3839,
   -3839,   273,   273, 69485, 69485, 69485, 69485, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839,  1779, -3839,  -141, -3839, -3839, -3839,
   -3839, -3839,  1548, -3839,  1355, 52526, -3839, 52054, 69485, -3839,
   69485,  2849, -3839, -3839, -3839,  2786,   485, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839,   915, 69485, -3839,  1618,  2788,
   69485,  2687, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, 48278, 48278, 48278,  1790, -3839, -3839,   937, -3839, -3839,
   -3839,  2706, -3839, -3839, -3839,  2848,  2850,  2855,  2714,  2716,
    2718,  2720, -3839,  2721,  2722,  2723, -3839, -3839, -3839, 69485,
   -3839, -3839, -3839, 69485, 69485, -3839, -3839, -3839,   843, 52526,
    2874,   843,   843, 69485, 69485,   843, -3839, -3839, -3839,  2877,
    2878,  2889,  2893,  2896,  2903,   843, -3839, -3839, -3839, -3839,
     325,  2204, -3839,    98, 36769,  5452,  2656,  2488,  2660,  1618,
   32972,   699,  2864,  2661, -3839,  1644,  2891,  2678,  2678,  2678,
    2678,  2678,  2678,  2678, -3839,  2745, -3839,  2842,  2736, -3839,
   -3839, 48278, 36769,  1610,   156,  2805,  1509,  3006, -3839, -3839,
   -3839, -3839, -3839, 60536,   815,   937,  1800, -3839, 52526, 69485,
   65246,  1437,  2674, 60536,  2675,  2672, -3839, -3839, -3839, -3839,
    1813, -3839, 52526,   -51,  2860,  2862,  1437, 69485,  2761, 60536,
    2746, -3839,  1818,     5, -3839,   937, 46860, 51110, -3839,  2839,
   -3839, -3839,  2869, -3839, 69485, -3839, -3839, 33930, 32499,  1573,
    2693, 69485, -3839,  2690, 31069,  2938,  2867, -3839, 31069,  2867,
    1385,  2867,  2940, -3839, 35818, -3839,  2701,  1369, 20773,  2892,
   10270, -3839,   273, 52526, 69485, -3839,   273,  2762,   273,  2764,
     273,   273, 60536, -3839, -3839, 60536, -3839, 69485, 61949,   273,
   -3839, 10270, 60536,   814, -3839, -3839, -3839, -3839, 69485,  2084,
   49222, 69485,   935, -3839, -3839,  2887, -3839,  1437, 69485,  1381,
     459, -3839, -3839, -3839, -3839,  3010,  3013, -3839, -3839, -3839,
   69485, 56768,   117, 69485, -3839, -3839, -3839, -3839,  2740,  1824,
    9900, 27632, -3839,  3020, 52526, -3839, -3839, -3839, -3839, -3839,
   27632, -3839, -3839, -3839, -3839, -3839, 27632, -3839, 27632,  3001,
   -3839,  3146,  3146, 52526, 29111,  1245,  2149, 29111, 29111, 29111,
   29111, 29111, 29111, 29111, 29111, 29111, 30097,   266, -3839, -3839,
   27632, 27632,  3008,  3001, -3839, -3839,  1329,  1329, 52526,  2724,
    2563,  2738,  2741, 27632, -3839, -3839,  1825, 48278, -3839, 27632,
    8295,  1833,  2792, 10142,  1381,  5576, -3839,  3113,   937, 27632,
    1321,  1990, 27632,  1836, 27632,  3023, -3839, -3839, -3839,  2748,
   -3839, -3839, 52526, 27632, 29111, 29111,  4539, -3839,  6184, 27632,
    2749,  6264, 23688, -3839,   678,   678,   678,   678, -3839, 60536,
   60536,  2513, 27632,  3027,  1850,  1851,  6061,  2772, 36290, -3839,
     965, 27139, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839,  2750, -3839,  2768,
   -3839, -3839,   495,  2757, -3839, -3839,  6039,   102,  2775, 69485,
   -3839,  2466, -3839, -3839,  2759, -3839,  1808, -3839, -3839, -3839,
    6378,  2943,  2171, -3839, -3839, -3839, -3839, -3839,   725,  1618,
    2780, -3839,  1960,  1025, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839,  2678,  6516, -3839, 69485, 69485,  1855, -3839, -3839,
   69485, -3839,  1988, -3839, -3839,  3019,  1500, -3839, -3839, -3839,
    2837, -3839,   696,  1625, -3839,  2838, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, 48278, 36769, 48278,  2858,  2861,   818,    79,
    2863,  2865,  2770,  2771,  2783, -3839,  2084,   197,   937, 69485,
   69485, -3839, -3839,  2084, -3839,   937,  2084,   937, -3839, -3839,
   -3839, -3839, 48750, -3839, -3839, 69485,  3057,    68,  1556, 69485,
   69485, 69485, 69485, 69485, 69485, 69485,  2441, -3839, -3839, -3839,
    2790,   843, -3839, -3839,  3018,  3032, -3839,   843,   843,   843,
     843,   843,   843, -3839,   222, -3839, -3839,  2455,  2455,  1206,
   -3839,  2455, -3839,  2455, -3839, -3839,  2493,  2759,  1618,  1151,
   -3839, -3839, -3839, -3839, -3839, -3839,  1171,  1618,  1882,  2791,
   -3839, 33451, -3839, -3839, -3839,  1721,  1221, 60536,  2678, -3839,
     712,   128,  1040,  1077, 67601, 68072, 68543,  2794, 69485, 29111,
   -3839,   716,   463, -3839,  3015, 60536,  2818, -3839, -3839, -3839,
    2800, -3839, 52526, -3839, -3839,  3200,  1207, 60536,  2840,  3094,
   -3839,  1859, -3839, -3839, 69485, -3839,  2842,  1590,  2866, 54884,
   -3839,  3065, 54884, -3839, 69485, -3839, -3839, -3839,  3171,  2899,
    2875,   332,   937,  2746, 69485,  2817, -3839, 50638, 27632, 27632,
   -3839,  2808, -3839,  2826,  4896, -3839,  2060, -3839, -3839,   925,
    2851, -3839, -3839, 66188,  2833, 69485,  1573, 31069, -3839, -3839,
    2776, -3839, 31069,  3064, -3839, 31069, 69485,  2836, 69485,  1860,
   44013, -3839,  2847,   273, -3839, 69485, -3839, 69485, -3839, -3839,
     273,   273, -3839,  2950, -3839,  2841,  1686,  2084, -3839, -3839,
    3116, 67130, -3839, -3839, -3839, -3839, -3839, -3839, -3839,   -63,
    3121, -3839, -3839, -3839, -3839, 27632, 10270, -3839,  2856, 10270,
    6785, 10270,  3008, -3839,   913,  3122, -3839,   903,  2843,   913,
    1251,  1251,   176,   176,    91,    91,    91,  3146,   266, 10270,
   10270, -3839, -3839, -3839, -3839,  2857, -3839, -3839, -3839,  2563,
   -3839, 28125, -3839, -3839,  2888,  2894,  2873, -3839, 27632, 28618,
    2868, 53470, -3839, -3839,  1221,  2774, 29111, 29111,   306, -3839,
     208, 27632, 52526,  1864,   306,  2051,  2368, 27632, 27632,  6953,
     311, 27632,  6927, 60536, 60536, 60536, 60536, -3839, -3839, 10270,
    3236,  3127,  2772,  2772,  2772, -3839, 82673, -3839, -3839, -3839,
   -3839, 27632,  1025,   343,   937, -3839, -3839,   877, -3839, -3839,
   39209, -3839, -3839, -3839,   107, -3839, 19661, -3839, -3839, -3839,
     197, -3839,  1867,  1871,  2818, -3839,  2211, -3839,  2924, -3839,
    2745,  3049, -3839,  3055,   197, 69485, 52526, -3839, -3839,  2883,
   69485, 69485,  1618,  1618, 52526,  2879, -3839,  1618,  1618,  2880,
   -3839, 69485, 69485, -3839, -3839, -3839, -3839, -3839,  2084,  2084,
   -3839, -3839, -3839, -3839, 69485, 69485, 69485, 69485,  3165, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839,  3115, -3839,   843,
     843, -3839, -3839, -3839, -3839, -3839, -3839, -3839,  2093,  3196,
     937,   937,  3067, 69485,   937,   937, -3839,  1187,  3203, -3839,
    3136,   646,  2882,  1374,  3164, -3839,  1540, 33451, 33451, 33451,
   33451, 33451, -3839, -3839,  3167,   197, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, 27632,  1473,   913, -3839, -3839, -3839, -3839,  2818,  1610,
    2945, 48278,  2947,  1437,   566, 69485,  3199,  3189, -3839,   937,
   -3839, -3839, -3839,   680, -3839,  2898,   148,  2900,  1870, -3839,
   -3839, -3839,   741, 69485, -3839,   174, -3839,  3131,  3178,  2901,
   -3839, 31548, -3839, 10270, 10270,   937, 53942,  2839, -3839, -3839,
   -3839, -3839, -3839,  2976, 69485, -3839, -3839, 69485,  1875, -3839,
   27632,  2902, -3839, -3839, 31069,  2776,  1884, 69485,  1887, 52526,
    2772, -3839, -3839,   273, -3839,   273,   273, -3839, -3839, 69485,
   69485,  3190,  3081, -3839,   273, 67130, 10270, -3839, -3839, -3839,
   29111,  3187, -3839,  2906, 52526, -3839,  2907,  1890,  1894, -3839,
   -3839, -3839,  7418,  2962, 10270,  3011,  2908,  2910, -3839,   581,
     581,   208,  1897, -3839, 29111, 29111,   306,   306, 27632,   306,
   -3839, -3839, -3839, -3839, -3839, 27632, 27632,  2954, -3839, -3839,
   -3839,  3078, -3839,  7539, -3839,  1151, -3839, -3839, -3839, -3839,
    1221, -3839,  2915,  1775, -3839, -3839,  3060,  2818,  2945, -3839,
   -3839, -3839, -3839, -3839,  2979, 36769, -3839, -3839, 32027, 39209,
   -3839,   818,  2922,  2923,    79, -3839, -3839,  1048,   -85,  2965,
    2084,  3212,   843, -3839, -3839, -3839,   937, -3839, -3839, 69485,
    2927, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, 49222,
    3325,  3325, -3839,  1606,  1606, -3839, -3839, -3839, 60536,  1171,
   -3839,  7618,  3124, -3839,  2945,  3149,  3198, -3839,  1912, -3839,
   69485,  2875, 54884,  2842, -3839,  1220,  3086, -3839, -3839,  3273,
    1870,   968,  1454, -3839, 60536,  2862,  3066, -3839,  3069, -3839,
    3311,  3123,  3320,   937, -3839, 69485, 31548, 27632,  1918, -3839,
   69014, 22714, -3839, 52998, -3839,  1927, -3839, -3839, 60536, -3839,
    2963,  1937, -3839, 10270, 69485, -3839, -3839, -3839,  1940, -3839,
   -3839, -3839, -3839, -3839,  1437, -3839, -3839,   117,   531, 29111,
   52526,  1949, 27632, -3839, 27632, -3839, -3839, -3839,    21, -3839,
   -3839, -3839,   581,   581,   306,  2563, 10270, 69485, -3839,  3334,
    3126,  2772, -3839, -3839, -3839, -3839,  3132, 60536,  2945, -3839,
   27632, -3839, -3839, 52526,  2018,   374, -3839, 52526, 52526, -3839,
   69485, 69485, 69485, 69485, 69485, -3839,  2204, -3839,  2927,  3325,
     766, -3839, -3839, -3839,  3241, -3839, -3839,   780,  3135,  3042,
   -3839, 48278,  3249, -3839, -3839, -3839, -3839, -3839, 49222, -3839,
    2862, -3839, -3839, -3839, -3839, -3839, -3839,  1952,  2899, -3839,
   -3839,  3137, -3839,  3140, -3839, -3839,  1956,  7888,  3007, 31548,
   69485, -3839,  1200,  1200, -3839,  4896, 53942,  2626,    86,  2981,
   -3839,  1959, -3839, -3839,   531,  1969, -3839,  1986,  1993,  3021,
   -3839,  2967, -3839,  3367, 27632,  1295, -3839, -3839, -3839,  1610,
   -3839, 10270,  1998, -3839, -3839, -3839,  3117,  1999,  2002,  2968,
    3016,  2968, -3839,  2084, -3839, -3839, -3839,  3283, -3839, -3839,
   -3839,    33, -3839,  3158,  3159, 69485, -3839, 69485,  3379,  2982,
    2899, -3839, -3839, -3839, -3839,  3007, 69014,  2244,  2899, -3839,
   -3839,  1808,  1808,  2839, -3839,  3295, -3839, -3839, -3839, 69485,
   -3839, -3839, -3839, -3839, -3839, 69485,  2983,  2563,   204,   204,
    2985,  3149, 49222, -3839, -3839, -3839, 69485,  3114,   620,   620,
    3310, -3839,  3051, -3839, -3839, -3839,   818, 44491, -3839,  2899,
    1200, -3839,  2626, -3839, -3839, -3839,   689, -3839, -3839, -3839,
      80,  3118,    72, -3839, -3839, -3839, -3839,  3135,  2018, -3839,
    3292, -3839,  3408, -3839,   550, -3839, -3839,  2879, -3839,  2003,
   -3839, -3839, -3839, -3839, -3839, -3839,  2626,  1808, -3839, -3839,
   -3839,  1633,  3398, -3839, -3839, -3839,  1171, -3839,  3147, -3839,
   -3839, -3839, -3839, 44491, -3839, -3839, -3839,  1658, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839,    80, -3839, 49222, -3839,  1278,
   -3839, -3839,  1419,  1812, -3839,  2998, -3839,  1658, 44491, -3839,
    2006, -3839
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3839, -3839,  3142, -3839, -1130,   149, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
    1145, -3839, -3839,  -101,  1306,  2032,   849, -3839, -3839, -3839,
   -3839,  -958,   171,   548, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839,   670,  1259,   737,  2467, -3839, -1607,  -622, -3839,   242,
   -3839, -3839, -3839,   616,  -368, -3839, -3839, -3839, -3839, -3839,
   -1675,  -124,   111, -3839,   110,  1287,   262, -3839,  -188, -3839,
   -3839, -3839, -3839,    75,   788,  -941, -1291,  1053,  -632,  -666,
    -592,  -587,  -628, -3839, -3509, -2920, -2601, -2496, -3839, -3839,
   -3839,   123, -3839, -1673, -3839, -3839,  1753, -1536, -3839,  -934,
   -3839, -3839,   577,  1339,   124, -3839, -3839,   -36, -3839, -3839,
   -3839, -3839, -3839, -3839, -3265, -3839, -1595, -3839,   245, -2739,
     704, -3839, -3839, -3839,  1780, -3839, -3839, -3839, -3839, -1704,
   -3839, -3839, -1664, -3839,  1205,   607, -3839, -3839, -3839,  -699,
    -672, -3839, -3732,  -119,  -117, -3839, -3839, -3839, -3839, -1196,
   -3839,   633, -2810, -1123, -3839, -3839,   663, -3839, -3839,  -611,
    -304,  1801, -3839,  -537, -3839, -3839, -3839,  -303, -3839, -3839,
   -3839, -3839, -3839, -3839, -1818,   287, -1089, -3839, -3839, -3839,
   -3839,  -898, -3839,  3374,  -187, -1661, -3839,  -152,  -122,  2247,
   -1283, -2432,    92, -3839, -3839, -1848, -3839, -3839, -3839, -2372,
   -1657, -3839,   151,  -370,  -491, -3033, -2834, -3092, -3839, -3839,
   -1235, -3839, -3839, -3839, -1514,  1353, -2177, -3839, -2150,   153,
   -3301,  -994, -2889, -3839, -3220,  -493, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -1245,  -844, -3839, -3589, -3839, -3839, -3839,
   -3839,   893, -3839,    14, -3839, -3839, -3839, -3839, -3839,  -636,
    -673, -3839, -3839, -3839,   199, -3839, -3839, -3839,  1567, -1132,
    -940,  2570, -1656,  -334, -3839, -3839, -3839, -3839, -2714, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -1398, -3839, -3839, -3839,
   -3839, -3839, -3839,  1492,  3416,  -239, -3839, -3839,  2083, -3839,
   -3839, -3839, -3839, -3839, -3839,  2296,   185,   -30, -3839, -3839,
     545, -2299,   -27, -3839, -3839, -3839, -3839,  -221,   -26, -3839,
     922, -3839, -3839, -1978, -3839,  2299,  1134,   126,   -47,    24,
    -242,  -230,  -206, -3839,  2573,  2101, -3839, -3839,  -197,  1158,
   -3839, -1051, -1041, -3839,   924,  -903,  1482,   916,    28,  -307,
   -3839, -2593,   386, -3839, -3839,  -901,  1496, -3839,  2094,  1512,
   -3839,  1537,   984, -2307,  1215, -2300,   631,  -482,  -142,  -157,
    2629,  2737, -3839, -3291,   964, -3202,   236,  1854, -1987, -1689,
   -3839, -3839, -1315,  9663, -3839, -3839, -3839, 12341, 12622, -3839,
   -3839, 13005, 13125, -3839, -1207,   504, 13174,  5449, -1336, -1717,
   -1446, 12337, -2280,   668, -1758, -3839, -3839, -3839,  -340,   516,
      78, -3839, -3839, -3839,  -505, -2552,  -502, -3839, -3839, -3839,
    -508, -3838, -1891, -3839,  -813, -3839, 13760,   970, -3839, -1077,
   -1289, -1820, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -2743,
   -2951,  -470,  1044, -3839, -3839,  1137, -3839, -3839, -3839, -1408,
    -944, -1950,  1051, -1961, -3839, -1039,  1173,  1648,  1444,  -980,
    5659,  -597, 11109,  -135, -2132, -1458, -1104, -3839,  -350, -3839,
      25,  3025,  -160,   253,  1216,   275, -2788, -3839, -3839, -3839,
    2360, -3839, -3839, -3839, -3839, -3839,  3035,   683, -3839,  2434,
   -3839,  1270,  1872, -3839, -3839,  1525,  -948,    32, -3839,  -469,
   -3839,  -139, -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839, -3839, -3839,  2161,    95, -3839,   -45, -3839,
   -3839, -3839, -3839, -3839,  3318,  -308, -3839,  2751,  -305, -3839,
   -3839, -3839, -3839, -3839, -3839, -3839, -3839, -3839,  2157,  1560,
   -3839,  2571, -3839, -3839, -3839,   -56,  2361, -3839, -3839, -3839,
   -1163,  1418,  2596,  -945,  1539, -3839, -3839, -3839, -3839, -3839,
   -3839, -3839, -3839,  1547, -3839, -3839,  1054, -1959,  1534, -3839,
   -3839,   479, -3839, -3839,   135, -3839,   488, -3839,  2267, -3839,
   -3839, -3839,   515, -3839, -3839, -3839,  -616,  9092,  1499,  -111,
     -98,  1109, -3839,  5281,  3935,   -81,  2193,    27,  7165, 11504,
     357, -3839,  3321,  1555,  1255,  -999,    49,  1847, 10658,   270,
   -1093,     7,    -2, -3839,  2021,  -637, -1153,  2442,  -757, -1803,
   -3839,  3720, -3839, -2351, -3839,  -956
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2299
static const yytype_int16 yytable[] =
{
      80,  1513,  1042,  1147,  1564,   944,   788,  1311,  1312,    79,
    1212,  1514,  1316,   885,  1822,  1515,   873,  1814,  1877,   789,
    1640,  1449,  2240,  2445,   868,  1777,   944,    74,  2339,  1026,
    1678,   343,  2468,   361,  1900,  1689,   791,  1583,  2755,   398,
    2331,  1147,  1930,  1931,  2411,  2449,  1456,   951,   338,   788,
    1957,   339,   341,  1911,  1057,  1096,   989,  1058,  2545,  1259,
    1472,  1946,   789,   964,  1021,  2756,  2758,  2275,  1464,  2645,
    3052,  2073,  1752,  1031,  2381,  1712,   830,  1756,  1479,   791,
    3427,  2132,  2134,  2135,  1762,  3211,   990,   675,  3169,  2358,
    1147,  2359,  3288,  1779,  3290,  1044,  2509,  2979,  1562,  2214,
    2360,  2661,   344,  2361,  3036,   391,  3344,  2362,  2363,  2993,
    2995,   391,  3384,  1010,  3581,  2794,  3001,   788,  1052,  2624,
    2270,  1805,   917,  3747,  2172,  1787,   684,  2669,  1852,  1847,
     789,  3721,  3224,  2441,  3344,  2666,  1611,  2694,   673,  1091,
    1924,  1925,  1053,  1534,  1542,  1543,  1509,   791,  1510,   878,
    2027,  3511,  1558,  1776,   413,  1981,  3710,  2503,    35,   413,
     413,   840,  3083,  1283,   684,  1943,    41,  4024,  1894,  2073,
      35,   842,  1577,  2710,  2074,  3418,  1294,  2714,    41,   397,
     413,  1976,   957,   877,  1806,   413,  1113,  1984,   413,  1553,
     943,  2379,  2865,  1322,  3361,  3362,  3363,  3364,  3365,  3366,
    1981,  1296,  1337, -1475,    37,    38,    39,    40,  4158,  3061,
   -1475,   943,   831,  1851,   945,  2634,  2919, -1676,   677,  3925,
    1806, -1266, -1266, -1266, -1266,   413,  2483,  2465,    37,    38,
      39,    40,  1984,  4181,  1806,   945,  1304,    37,    38,    39,
      40, -1706,  2222,  1237,  3766,  3041,  3768,  3083,  2179,   259,
    3050, -1261, -1261, -1261, -1261,  1706,  3252, -1579, -1579, -1579,
   -1579,  3081,  3082,  2579,  3405,  1307,  3097,  2584,  1041, -1266,
     413,  2684, -1266, -1266, -1266, -1266,  4011,   316,  3635,  1981,
    2179,  4214, -2297, -2297, -2297, -2297,  2584,  2222, -2298, -2298,
   -2298, -2298,  3930, -1724,  2180,  3008,  3617,  3010,  3689, -1261,
    3931,  2102,  4022,  2355,  1254,  3130,  3131,   343,  1262,  2034,
   -1753,  1984,  4180,  1314,   413,  4079,  1615,  1840,  1274,  2227,
      37,    38,    39,    40,   338,  2103,  1440,   339,   341,  2201,
    1973,  1453,  1689,  1580,  2181,  1854,  3492,  3083,  1700, -1615,
    2103,  2484,  4212,  3264,  2897,  3921,  1867,  1868,  1916,  2618,
     244,  1085,   801,   351,   802,   796,  2619,  4181,  3265,   351,
    3512,  1442,  1581,     3, -1679,   797,  2181,  2035,  2228,  1147,
     786,  4012,  1051,  2104,  3848,  2356, -1723,  1981,   344, -1276,
   -1276, -1276, -1276,  3922, -2295, -2295, -2295, -2295,  2104,   391,
    1806,  1441,   351,   399,  1315,  2075,  1957,  4244,  3618,  -328,
   -1491,    37,    38,    39,    40,  1930,  1931, -1491,  2202,  1984,
    4215,  4040,  1946,   786,  1985,  1816,   413,  1308,  1616,    37,
      38,    39,    40,   391,  1101, -2294, -2294, -2294, -2294,  3636,
    4104,  1087,  1807,   678,  1895,   351,  3042,  1816, -1276, -1276,
   -1276, -1276, -1884, -1884, -1884, -1884,  2239,  3932,  2466, -1233,
   -1233, -1233, -1233,   798,  3608,  2313,  3253,  2685,  1117,   889,
     980,  2309, -2299,  1131,   805,  2182, -1676,   980,  1807,   980,
    4159,  2015,  2512,  3083,   795,  1323,  3344, -1246, -1246, -1246,
   -1246,   786,  1807,  1333,  4236,  2016,  2866,  1315,  3904,  3419,
   -1706,  1084,  4080,  1198,  2380,   873,  1115,  2182,  1575,  1058,
    2663,   806,  2040,   351, -1273, -1273, -1273, -1273, -1475,  4182,
    2231,  1924,  1925,  2065,  2066,  2485,  2329,   795,  3590,  1943,
    3085,  2331,  2266,  1846,  2268,   259,  -125,  3947,  2276,  2045,
    3039,  1895,  2486,  2062,  2062,  1315,    37,    38,    39,    40,
    1987,  3789, -1724,  1244,    37,    38,    39,    40,   244,  1981,
    1252,  2273,  1759,   316,  1977,  2183,  2303,  1092,  1549, -1753,
    1988,  1989,    55,    58,   985,  3958,  2073,  1842,    58,    58,
    2306,   985,  2585,   985,    55,   938,   939,  2005,   799,  2325,
   -1723,  1984,  2460,  2028,  3095,   795,  2304,  2183, -1615,    58,
    1617,  3144,  1919,  2148,    58,   938,   939,  2900,  2743,  1558,
     938,   939,  3083,  1816,  2677,  3248,    57,  3249,  2073,  1093,
    2118,  1992,  2119, -1679,  2644,  3565,   803,  3471,  2205,  2002,
    2003,  2004,  2005, -1266,  3124,  1993,  2739,  3998,   878,    56,
      57,  1400,  1554,  4182,    58,  3706,  3084,   351,  1807,    57,
    1555,  1556, -1266,  1919,  3685, -1723,  2411,  1102,  4034,  1230,
    2545,  2545,  3083, -1261,  2620,  2545,  3085,   692,  2340, -1579,
   -1723,  3657,   877,  1823,  2195,  1154,  3092,  3093,  3094,  3095,
    2200,   351, -1261,  3197, -1266,  1127,  1476,  3436, -1579,    58,
    1477,  3440,  2392,  2012, -2297,   938,   939,  1292,  3191,   788,
   -2298,  2453,  1847, -1266,  2545,  2545,  2000,  2001,  2002,  2003,
    2004,  2005,   789, -2297,  3202, -1491,   890,  3279,  1686, -2298,
    2256,  1304,  1202,  2259,  2260,  2722,  1524,  1888,    56,  1104,
    4220,  3086,    57,    58,  1087,  1707,  1708,  4094,  1902,   938,
    1533,  1031,  1988,  1989,  2535,  2536,  1546,  4191,  3043,  2888,
    1912,  3314,  3315,  1239,  3342,  2190,  2600,    37,    38,    39,
      40,  1164,  2386,  1301,  3090,  3091,  3092,  3093,  3094,  3095,
    1952, -1233,  1249,  2310,  4133,  2314,  1304,  1293,  2129,  1295,
    3707,  1297,  3342,  1320,  2741,  2789,  4135,  1298,  1953,  4209,
    2232, -1276,   891,  1992,   892, -2299, -2295,  1996,    37,    38,
      39,    40,  2233,  2251,  2000,  2001,  2002,  2003,  2004,  2005,
    1954,  1193,  1318,    57,  3494, -2295,  1231,  3499,  3500,  3501,
    3502,  3503,  3504,  3505,  3506,  3507,  3508,  3425,  3666,  1952,
      56,    57,  1693,  1164,  1147,    58,  2390, -2294,  2315,  1696,
    2130,   391,  3835,  1227, -1233,  3085,  1195,  1953,  2506,  2508,
   -1276,  2234,  2389,  3918, -1884,  1165, -2294,  2845,  2270,  2516,
    1687, -1233,  2519,  2846,  1890,  3280,  1591,  4221,  3427,  1956,
    2531,  2532,   156, -1884,  3545,  3546,  2187,  4105,  2601,  1318,
    1929,  1635,  2602,  2549,  2551,   835,  2411,  2191,  2386, -1246,
    1789,  4208,  3686,  1402,  2565,  2131,  3087,  3088,  3089,  3704,
    3090,  3091,  3092,  3093,  3094,  3095,  2452,  2090,  1935,  1797,
    3086,  1452,  3579,  2471,  2472,  1462, -1273,  2603,  4063,  1587,
    2456,  1071,  1087,  4175,  4192,  4224,  3926,  1165,    80,    37,
      38,    39,    40,  1544,  1797, -1273,  2130,    79,  3927,  3044,
    -125,  2013,  2099,   174,  3194,  -125,  4210,  2387,    57,  1525,
    2641,  -125,  -125,  2889,  1446,    74,    57,  3705,  3668,  2847,
    1798,  2192,   943,  1097,   943,  1288,   943,  1979,  1592,  2013,
    2790,  1321,   943,  1299,  1300,  2017,  2000,  2001,  2002,  2003,
    2004,  2005,  3909,  1072,  3919,  3466,   945,  2430,   945,   837,
     945,  2131,  1075,  2475,  3083,  4193,   945,  1773, -1070,  1338,
    2373,    37,    38,    39,    40,  1688,  4108,  1443,  3601,  4106,
    3676,  1455,  1458,  1459, -1073,  4048,  1774,  4194,  1147,  2133,
    3828,  3829,  3830,    37,    38,    39,    40,   888,  2100,  3090,
    3091,  3092,  3093,  3094,  3095,  2904,  2622,  1816,  1073,  2604,
    1087,  1074,   684,  3172,  1799,  3612,  3173,  3174,   954,  4173,
    4174,    37,    38,    39,    40,  4002,  2498,  3175,  3176,  3177,
    2745,  3178,  3179,   786,  1482,  1658,  3180,  3181,  3182,  1799,
   -1070,  2374,  1402,  3912,  1659,   213,  1564,  3344,   213,  3090,
    3091,  3092,  3093,  3094,  3095,   351, -1073,   994,  1075,   351,
    2186,  3928,  1668,  1800,  1537,  3791,  2852,  3792,   958,  3703,
     675,   675,  2848,  4170,   221,  1566,  1125,   221,  1128,  1466,
    3749,  1593,   943,  2538,  1565,   965,  1075,  3784,  1800,  4041,
    2187,  2653,  4109,  1158,  3342,  4225,    37,    38,    39,    40,
    4120,  2849,  1557,  1669,   230,  1075,   945,  1816,   232,  2746,
    3759,   232,  1499,  3756,  1147,  3763,  1203,  3613,  3765,  4042,
     235,   673,   673,   235,  3045,  1769,  1563,  3243, -1233,    57,
    2876,  2623,  1221,    37,    38,    39,    40,   795,  1594, -1233,
    1562,  1929, -1233,  1582, -1233,  1042,  1801,  3085,  2650,  1017,
     995,  3750,  4110,  2929,  2930,  2931,  2932, -1237, -1237, -1237,
   -1237,  1891,  3468,  1660,   244,  3011,  1770,  3006,  3183,  2049,
      57,  1801,  1981,  2545,    58,  1710,  2545,  2545,  2545,  2545,
    2545,  2545,  2545,  2545,  2545,  2545,  4043, -1070,  2699,  3046,
    3691, -1244, -1244, -1244, -1244,  3793,  1076,  1205,  2424,  1206,
    3614,  3578,  3281, -1073,  1984,  1500,  2411,  2433,  4131,  4132,
    2411,  2050,  3086, -1235, -1235, -1235, -1235,  1505,  3483,  2440,
    3247,  2375,  2188,  1077,  3427,  1864,   805,  3693,  2086,  2358,
    3996,  2359,  2376,  2545,  2545,   980,  3809,  3810,  2644,   980,
    2360,  2160,  1860,  2361,  1058,  1861,  1862,  2362,  2363,   922,
    1893,  2093,  2094,  1458,  2098,  1670,  2138,    80,    80,  2139,
      80,  2464,  3740,   806,  2469,  2470,    79,    79,  2473,    79,
    2261,  3168,  4116,  3002,   350,  1053,  1053, -1070,  1053,  2673,
     350,  1507,   351,  1467,    74,    74,  3751,    74, -1238, -1238,
   -1238, -1238,  3184, -1073,  3463,  1045,   344, -1236, -1236, -1236,
   -1236,    57,  3083,  3775,  2825,  3776,  3893,  3894,  3895,  3896,
    3897,  1830,  2828,   350,  2830,   851,  4207,  1028,  1771, -1070,
     966,   344, -1070,  3666,   413,  1508,  3406,    37,    38,    39,
      40,  1597,  3999,  3967,  1288, -1073,  2850,  1671, -1073,   985,
    3883,   932,  3752,   985,  3185,  1917,   788,  2236,  1468,  1046,
    2773,  1642,  1831,  2140,  1035,  2261,   350,  2775,  2674,   789,
     933,  1598,  1033,  1333,  1933,  2851,  2335,  2019,  2032,  2033,
     853,  3470,  3083,    57,  1402,  2316,  2072,  3087,  3088,  3089,
    1643,  3090,  3091,  3092,  3093,  3094,  3095,  1975,  4026,  2262,
     788,  2263,  3667,   967,  1960,    57,  3536,  1980,  3884,  2774,
    1772,  1633,  1634,   981,  2886,   851,  2776,  3495,  2018,  3496,
     981,  1971,   981,  1673,  3059,  3471,  2317,  1599,   413,  4087,
    3268,  3237,  1047,    57,   350,  2904,  1045,  4122,  1072,  1043,
    2179,  1553,  2413,  3186,  2416,  2132, -1115,  3955,  1458,  2739,
   -1115,  2047,  1674,  2422,  2180,  1458,  1458,  1600,  2997,  1064,
    1537,   788,  2267,  3668,  1537,  1537,   684,   684,  2545,  1054,
     853,  1705,  3110,  2145,   789,  3019,  1658,   413,   943,  1065,
    1675,  1061,   943,   943,  2262,  2740,  2263,  1757,  1758,  1066,
    1046,  2072,  4090,  1073,  4010,  3085,  2336,  2241,  3662,  2167,
    3968,  3133,   945,   979, -2092,  1785,   945,   945,    57,  4168,
   -1115,  2708,  1016,  1759,  1832,  1051,  1051,  4172,  1051,   860,
    1131,   861,  1666,  1505,  3982,  3983,  2181,  1506,  2168,   675,
    2141,   838,  3269,  1818,  1820,     8,  1973,  3497,  1816,   391,
     391,  1048,  2242,  2243,  3663,    57,  2137,  3498,  1300,  3164,
    3165,  1667,  2155,  2157, -1115,  1601,  2169,  -337,  4206,  3943,
    3086,   684, -1114,  1047,  2149,  3085, -1114,   390,   350, -1237,
    2154,  2156,  1208,   390,  1209,   968,   969,  1067,  2318,  2073,
     673,  3889,  4035,  2239,  1602,  4044,   391,  1507,   207,  3367,
    1075,  2986,  1603,  2164,  1855,  1537,  1833,  2741,  1604,   991,
    2906,  1537,   350, -1244,  3836,  1605,   390,  3890,  4036,   860,
     805,   861,  1606,   943,  2762,  4045,  1856,  2987,    56,   943,
    1607,  2644,   156,    58,  2225, -1235, -1114,  2230,  1608,  3683,
    3086,  1508,  3442,  3369,  4148,  2545,  2545,   945,   788,  1042,
    1068,  1537,  2989,   945,  1537,  1537,  1857,   806,  2274,   390,
    1103,   789,  2907,  3246,  2222,  1022,  2184,  2182,  4149,   943,
    2319,  2229,   943,   943,  1022,  1590,  2419,  2277,  2351,  2411,
   -1114,  1952,  1048,  2335,  2411,  3270,  1609,  2411,   805,  4074,
    2299,  2337,  4046,   945,  2223,   807,   945,   945,  1641,  1953,
    2300,  3212,   122,   174,  1537,  3342,  1114,  1460,  1679,  3192,
   -1238,  3646,  1069,   839,  3271,  1952,  2644,  1129,  2062, -1236,
     126,  1954,   943,  2301,  2985,   806,   919,   390,  2038,  1097,
     786,  2454,  1402,  1953,  2908,  2909, -2299, -2299,  2488,  3090,
    3091,  3092,  3093,  3094,  3095,  1072,   945,  2910,    56,    57,
    1400,  1554,   351,    58,  2991,  1956,  2278,  2183,  2500,  1555,
    1556,  3150,  1837,  2364,  1156,  2297,  3637,  2900,  3480,  2660,
    3513,  3514,  1058,  3228,   786,  3902,  4246,   992,  4032,  4247,
    3373,  1838,  1458,  3844,  1162,  3638,  1952,  2499,  3602,  2986,
    1197,  2241,  1147,  4064,  2298,  2190,   351,   351,   351,  1163,
    1073,  2911,  1402,  2336,  1953,  3087,  3088,  3089,   156,  3090,
    3091,  3092,  3093,  3094,  3095,  2987,  3374,  3808,   213,  2398,
    3024,  1638,  1655,  1200,  1665,   207,  2405,  2294,  3375,  1201,
    2988,  1682,  1224,   156,   795,   786,  2242,  2243,   213,   980,
    2989,  2900,  3807,    80,   351,  1204,    80,   221,  3219,  1639,
    1213,   351,    79,  3543,  2497,    79,  2087,   351,  2088,   980,
    1225,   390,  3205,  2990,  1476,  1219, -1579,   221,  1477,  3029,
      74,  2494,   788,    74,  2495,  2496,  1476,  2239,  3266,   174,
    1477,   232,  2912,  1584,  2913,   789,   130,   131,  3135,  3943,
    3136,  1224,   980,   235,   230,   390,   817,  1075,  2933,  2545,
    1226,   232,  2582,  2934,   174,  2346,  3376,  3267,  1229,   213,
    3137,  2353,  1585,   235,  2296,  1041,   207,  1496,  1587,  3387,
   -1070,  3449,  1677,  2545,  2545,   344,   207,  3603,  2382,  3660,
    3661,  2904,  2528,  3664,   244,  3665,  4226,   191,   221,   795,
    1586,  2679,  2991,   985,  3592,  3593,  2591,  1848,  2592,  2241,
    1639,  1849,  2517,  2518,   244,  2281,  2282,  2283,  2284,  1226,
    2530,  3357,   191,   985,  2533,  2534,  2934,  1929,  2593,  1582,
    3309,  3250,   232,  3312,  3313,  1228,  1929,  3316,  2173,  2555,
    2023,  2556,  3385,  3940,  2024,  2311,  2312,  3323,  2337,  1287,
     413,  2321,  3598, -1082,  2242,  2243,   985,  1929,  3154,  2173,
    3155,  1848,  2577, -1082,  2578,  2448,  2411, -1082,  3422,  1587,
    1232,  2589,   786,  3138,   213,  2338,   350,  3056,  3139,  1587,
     350,  2451,  3057,    81,  3604,   244,  3058,  3605,  3677,  3678,
    3679,  3680,  3681,   413,   351,  2239,  3519,  1235,  3892,   213,
    2724,  4019,  2570,   221,  2651,  2573,  1246, -1082,  2241,  1250,
    3156,  1105,  3157,  2149,  2413,  1260,  2369,  2370,  2371,  2372,
    1689,  3083,   788,  1106,  1107,  1269,  2594, -1082,   221,  1275,
     230,  2595,  1644,  1941,  1942,   789,  2596,   232,  2545,   920,
    2696,  3205,  2696,  1108,  3476,  3537,  1109,  1290,  3109,   235,
    3111,  3112,  2072,  2242,  2243,   230,  3679,  3680,  3681,   392,
      58,  1929,   232,  2173,   391,   392,  2450,  1309,  2451,  3205,
    2461, -1082,  2462,  1304,   235,  2671,   795,  2122,  2123,  1645,
   -1082,  1313,  3083,  3994,  1325,  2463,   943,  2462,   788,  2446,
    4227,  3140,  1330,  2491,  2239,  2492,  1331,  2670,   392,  1816,
    3141,   789,  2400,  2401,   675,  1981,  3814,  2687,  2688,  1537,
     945,  1332,   391,  3596,   391,   244,  1333,  1566,  2786,    80,
     788,    80,  1042,  2716,  1334,  2492,  1565,   943,    79,  1982,
      79,  1339,   879,   789, -1137, -1137,  2111,  1984,  3940,  2122,
    2692,   392,  1985,  2753,  1557,  2754,    74,  1110,    74,  2597,
    1087,   945,  4099,  1646,  4101,   673,  1335,  2796,  2598,  2797,
    2892,  1459,  2893,  3276,  1502,  2920,  1504,  2921,  1563,  3677,
    3678,  3679,  3680,  3681,  3026,  1336,  2462,  3682,   981,  3283,
    1905,  1906,   981,  3286,  3037,  1340,  3038,  1111,   986, -1082,
    3748,  2926,  3055,  1463,  2451,   986,   786,   986,  1647,  3065,
    1648,  2451,  1465,   350,  3085,  3068,  3072,  2451,  2451,   392,
    1469,  2269,  1116,  3812,  3073,  1470,  2451,  1116,   351,  1022,
    3099,  3115,  2451,  2451,  1022,  1537,  1022,  3118,  3170,  3119,
    3171,  1471,  1022,  1537,  3198,  1537,  3199,  3262,  1480,  3263,
    1022,  3207,  3208,   943,  2413,  1022,  1650,  1116,  3291,  1485,
    3292,   943,  1476,   943,  1486,  1496,  1477,  1496,  3393,   390,
    3394,  3940,  1494,   390,  1986,  3085,  1493,   945,  1987,  3086,
    1497,  3403,  2878,  3404,  3325,   945,  3416,   945,  3417,  1503,
    2878,  1652,  3484,  3520,  2451,  3521,  2953,  2954,  1988,  1989,
    1516,  3527,  1022,  3528,  3539,  1518,  2451,  1116,  3673,  3674,
     795,  1619,  1522,  1990,  1116,  1523,  1042,  1620,  3562,  3563,
    2451,  2451,   351,  3594,  1654,  2462,  3326,  3718,  3770,  3719,
    3171,  1526,  3813,  2903,  2492,  3846,  2928,  2462,  1538,  3847,
    3086,  2462,  3880,  3952,  1527,  1816,  1991,  3215,  3216,  1992,
    3327,  1528,  3957,   392,  3394,  3959,  1621,  3394,  3973,  2958,
    3974,  1529,  3975,  1993,  2451,  3981,  1994,  2492,  1022,  3328,
     351,    35,   351,  1022,  1530,    37,    38,    39,    40,    41,
    4030,  1531,  4031,  3648,  1022,  3329,  4058,   392,  4059,  3651,
    3652,  3653,  3654,  3655,  3656,  4065,   786,  4066,  2978,  3330,
    1532,  3467,  3159,  3160,  1539,  4070,  1622,  1816,  4072,  3083,
    3394,  1458,  1541,  1623,  3798,  1022,  1624,  4076,   351,  2492,
    4121,  3205,  2037,  3479,  4125,   788,  4059,  4140,  1544,  1816,
     788,  3213,  3214,  3815,  1022,  1995,  1568,  4141,   789,  2492,
    1022,  1402,  1571,   789,  3087,  3088,  3089,  1569,  3090,  3091,
    3092,  3093,  3094,  3095,  4142,  3116,  3119,  1582,  1022,  1087,
    3121,  4143,   786,  2451,  2520,  1625,  4152,  4154,  2492,  2492,
    4155,  4222,  2492,  4223,  4251,  3971,  4223,  3441,  1596,  3444,
    1578,  3331,  1545,  1547,   351,  1613,  1637,  1635,  1672,  3332,
    4171,  1676,  1685,  1684,   786,  1690,   390,  1692,  3875, -1576,
     795,  1694,  1402,  1697,  1702,  3087,  3088,  3089,  3841,  3090,
    3091,  3092,  3093,  3094,  3095,  1704,   351,  1711,  1714,  1587,
    1626,  2826,  3333,  1753,  1755,  1996,  2521,  1759,  1997,  1998,
    1999,  1763,  2000,  2001,  2002,  2003,  2004,  2005,  -169,  1765,
    2655,  1767,  1778,  1784,  1794,  1802,  2656,  1804,  1809,  1810,
    1811,  1812,  1813,  1815,  1816,  1821,  1627,  1824,  4018,  1825,
    1826,  1827,  1829,    35,   413,  2870,   795,    37,    38,    39,
      40,    41,  2879,  2880,  2881,  2882,  2883,  2884,  1834,  1835,
    1836,  2522,  1971,  1841,  2523,  1628,  1116,  2544,  1873,  1629,
    1901,  1907,  3085,  1116,  1915,  1903,  2589,  1909,   795,  1910,
    1923,  1926,  1927,  1932,  2413,  1928,   244,  1934,  2413,  1937,
    1938,  1939,  1940,  1630,  1945,  3153,  1947,  1948,  1949,  1950,
    1458,   879,  1951,  2010,  1619,  1958,  1959,  1961,  2405,  1537,
    1620,  1962,  1963,  1964,  1965,  1966,  1967,  2052,  1022,  1022,
    1022,  2037,  2149,  2041,  1116,  3193,  2091,   943,  2077,  2067,
    1131,  4075,  3628,  3629,  1506,  2116,  2121,  3086,  2128,  1075,
    2136,  2042,  2142,   350,  2144,  2146,  1553,  2152,   846,  1621,
    2153,   945,  2158,  2159,  2161, -2241,  2163,  2170,  2524,  2171,
    2173,  2194,  2174,  3007,  4092,  3009,  2175,  2189,  4097,  4098,
     788,   788,   788,  2196,  2197,  2198,  2220,  2199,  2222,  2221,
    2236,  2237,  2226,   789,   789,   789,  3842,   350,   350,   350,
    2238,  2239,  2245,  2246,  2252,  2257,  2250,  2247,  3985,  1622,
    2254,  3873,  3874,  2255,  2264,  2271,  1623,  1022,  2265,  1624,
    4096,  2272,  1658,  2279,  2280,  2286,  2287,  1147,  3905,  4093,
    2293,  2288,  1724,  2295,  2322,  2308,   851,  2320,  2323,  2330,
    1022,  1929,  1919,  1935,  2332,   350,  2333,  2342,   848,  2348,
    2352,  2368,   350,  2385,  2043,  -724,  2391,  1660,   350,  2525,
    2393,  3397,   981,  2396,  2403,    55,  2394,    57,  1625,  2414,
     788,  2426,  2427,  3282,  2397,  2428,  2442,  2443,  2429,   786,
    2457,   392,   981,   789,   786,   392,  2474,  2458,  2477,  1124,
    2489,   853,  2481,  2512,  1124,  3294,  2502,  2566,  3432,   873,
    2351,   351,  2553,  3284,  2554,  1981,   351,  2571,  2576,  1402,
    2583,  2607,  3087,  3088,  3089,   981,  3090,  3091,  3092,  3093,
    3094,  3095,  2511,  1626,  1124,  2634,  2878,  2575,  2588,  2878,
    2878,  3367,  2605,  2878,  2646,  2649,  2652,  2647,  1046,  2657,
    2925,  2658,  2665,  2878,  2654,  3368,  2680,  2701,  1710,  2681,
    2672,  2027,  3345,  2686,  3398,  2698,  2717,  4078,  3354,  1627,
    2700,  1537,  2715,  2718,  2719,  2726,  2728,  1240,  2734,  3410,
    1042,  2737,  2730,  2731,  1124,  3369,  2744,  3370,  1022,   943,
    3345,  1124,  2749,   795,  3349,  3352,  2732,  2985,   795,  1537,
    3431,  2751,  1629,  3392,  2788,  2795,  2798,  2965,  2853,  4085,
    2854,    81,  2855,   945,  4047,  2859,  2863,   943,  2864,  4086,
    2867,  2868,  2869,  4217,  2887,  1597,  1630,  3553,  3554,  3555,
    3556,  2871,  2872,  3421,  1458,   344,  2875,  2885,  2896,  2873,
     860,   945,   861,  2874,  4015,   350,   390,  2894,  2901,  2918,
     344,   863,  2899,  2900,  2902,  1598,  3371,  2922,  2940,  2927,
    3474,   866,  2986,  2935,  2939,  2956,  2957,    55,    56,    57,
    2959,   344,  2974,    58,  2975,  2976,   788,  4147,  2405,   938,
    1533,  2977,  2405,  2984,  3003,  4005,  2998,  1124,  2987,   789,
     390,   390,   390,   986,  3004,  3017,  3012,   986,  3015,  3018,
    3022,  3028,  3030,  2988,  3035,  2503,  3522,  3867,  3868,  3047,
    3870,  1599,  3205,  2989,  3051,  1315,  1147,  3372,   392,  3053,
    3066,  1619,  3373,  3067,  1734,  3069,  1124,  1620,  3204,  3070,
    3071,   344,  3074,  2451,  3075,  3077,  2990,  3134,   390,  1022,
    3105,  1600,  3080,  3142,  4203,   390,  3149, -2153,  3098,  3162,
    3104,   390,  3106,  3107,   786,   786,   786,  2413,  3374,  3114,
    3127,  3128,  2413,  3760,  3129,  2413,  1621,  3167,  3168,  2966,
    3375,  3218,  3222,  3152,  3221,  3232,   351,   351,   351,  3223,
    3226,  3239,  3227,  1848,  3244,  3240,  1022,  3626,  3245,  3277,
    3278,  3235,  3285,  3287,  3236,  3295,  3534,  3296,  3311,  3297,
    4203,  3317,  3318,  3299,  3298,  3300,  1022,  3301,  1619,  3302,
    3303,  3304,  3305,  3319,  1620,  2991,  1622,  3320,  4151,  2139,
    3321,  3347,   788,  1623,   788,  4203,  1624,  3322,  3348,  3356,
    3951,  3358,  3359,  3380,  3382,   789,  3386,   789,  3570,  3388,
    3951,  3399,  3402,  3401,   786,  3407,  1971,  1899,  3376,  3408,
    3412,   788,  2786,  1621,  3609,  3414,  3429,  3435,   795,   795,
     795,  3433,  3438,  1124,   789,  3437,   351,  3445,  3448,   350,
    1124,  3455,   207,  3457,  3450,  1625,  1603,  3473,  3477,  2544,
    2544,  3478,  1604,  3487,  2544,  3761,  3101,  3083,  3100,  1605,
    1136,  1750,  3516,  1137,  1138,  1139,  1639,  1140,  1141,  1142,
    1143,  1144,  1145,  1622,  1607,  1916,  3517,  1976,  3541,  3518,
    1623,  3529,  1608,  1624,  3585,  3542,  2412,  3550,  1116,  3560,
    3572,  1124,  3573,  2544,  2544,  3574,  3580,  1116,   390,  3577,
    1626,  3583,  3345,  3597,  3586,  3599,  3606,  3634,  3623,  3624,
    1022,  1537,  3649,  3708,  3426,  1981,  3627,  3610,   795,  1022,
    3611,  3625,  3621,  3630,  3622,  3631,  3650,  3675,  3647,   943,
    1609,  3701,  1625,   350,  2968,  3426,  1627,  3711,  3713,  3715,
      81,    81,   943,    81,  3716,  3727,  3732,  1984,  3745,  2878,
    3733,  1124,  1985,   945,  3741,  2878,  2878,  2878,  2878,  2878,
    2878,  3764,  3723,  3746,  1116,  1663,   945,  1022,  1022,  1629,
    3757,  3735,  3754,  3767,  3779,  3782,  3785,  3790,  3780,  1022,
    3794,   350,  3799,   350,  1750,  3773,  2141,  1626,  3800,  3354,
    3825,  3826,  3849,  1664,  3787,  3795,  3850,  4071,  3688,  3690,
    3692,  3694,  3851,  1299,  1300,  3871,  1124,  3855,  3805,  3872,
     786,  3801,  3672,  3876,  3879,  3885,  3352,  3667,  3888,  3861,
    3864,  3891,  3898,  1627,  3906,  3687,  3910,  3914,  3916,   350,
    3933,  2413,   351,  3935,  1124,  3948,  3920,  3924,  3936,  3954,
    3964,  3965,  3969,  3970,  3972,  3977,  3979,  3978,  3980,  3987,
    3738,  3989,  1680,  3995,  2413,  3997,  1629,  4103,  4000,  4007,
    4008,  4013,  4014,  4020,  2679,  1124,  1124,  2462,  1124,  4027,
    3845,  3707,  1899,  4038,  1986,  4029,  4039,  4051,  1987,  4049,
    1681,  2009,  4050,  4052,  3852,  1124,  4053,  4068,  4084,  1047,
    4088,  4107,  4111,  4115,  4117,   350,  1022,  4123,  1988,  1989,
    4124,  2405,  4139,  4127,  4144,  4146,  2405,  4145,  1842,  2405,
    4094,  4157,  4156,  1990,   795,  4160,  4162,  4166,  4176,  4167,
    3566,  1022,   390,  4186,  2048,  4158,  4190,   350,  4159,  2249,
    4213,  4218,  4219,  4235,  4237,  4248,  1056,  1124,   392,  2924,
    2064,  3195,  3254,  4169,  2791,  3607,  3324,  4016,  4004,  1992,
    3725,  2763,  3729,  3600,  3903,  3027,   786,  3234,   786,  4187,
    1597,  4216,  4163,  1993,  1124,  3900,  4161,  3730,  1124,  1124,
    1022,  4196,  2742,  2384,  3411,  3737,  3289,  3632,   351,  1131,
     351,  3390,   392,   392,   392,   786,  2365,  2905,  2307,  4250,
    1598,  4238,  3887,  3886,  3383,  4197,  3335,  4006,  2347,  4153,
     960,  4009,  1889,  3783,  3739,  1899,  4056,   351,  4129,  2757,
    3742,  3839,  3840,  4134,  4249,  4229,   390,  4033,  2667,   925,
    3838,  2092,  3722,  3475,    80,  3200,  2413,  1473,  1859,  3023,
     392,  1863,  3781,    79,  2089,  1995,  3203,   392,  2149,  1750,
     788,  2691,  3217,   392,  3584,  2117,  1599,   986,  2344,   943,
    1492,    74,  3843,   789,  2690,   943,  2683,  2664,  3161,  2980,
     795,  3443,   795,  3956,   390,  1242,   390,   986,  3201,   943,
    3720,  3533,  4077,   945,  1750,  3523,  1600,  3858,  3859,   945,
    4178,  4185,  3862,  3863,  4179,  3206,  3147,  2878,  2878,   795,
    3062,  3145,  1865,   945,  3040,  1481,  1750,  3430,  3877,  3878,
     986,  2633,  3881,  3882,  2418,  1090,  3911,  2973,  2399,  1796,
    4177,  2702,   390,  1286,  2120,  3354,  3354,  3354,  3354,  3354,
    1022,  1059,  2693,  1898,  2127,  1996,  1576,  2707,  4119, -2299,
   -2299,  1548,  2000,  2001,  2002,  2003,  2004,  2005,  2709,  2706,
    3190,  3588,  3352,  3352,  3352,  3352,  3352,  3834,  2026,  2413,
     943,  3589,  3576,  3025,  2124,  1750,  1082,  3917,  2713,  2459,
    3772,  1845,    83,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2328,  1828,   945,     0,     0,   344,   390,     0,
       0,     0,     0,  3942,  1843,     0,     0,     0,     0,     0,
    1750,     0,  2544,     0,     0,  2544,  2544,  2544,  2544,  2544,
    2544,  2544,  2544,  2544,  2544,     0,     0,   207,     0,  2204,
     390,  1603,     0,     0,     0,  1750,     0,  1604,     0,  1981,
     392,     0,   350,     0,  1605,     0,     0,   350,  2405,     0,
       0,  1639,  2965,     0,     0,     0,  1022,     0,     0,  1607,
       0,     0,  4188,     0,     0,     0,     0,  1608,     0,     0,
    1597,  1984,  2544,  2544,     0,     0,  1985,     0,     0,     0,
       0,     0,     0,  1124,     0,  1124,     0,     0,     0,     0,
    1022,  1750,     0,     0,  1124,  2580,     0,  1022,     0,  1132,
    1598,     0,  3993,  1150,     0,     0,     0,     0,  2412,     0,
       0,     0,  1160,  3345,     0,  1609,     0,     0,     0,     0,
    3992,     0,  1537,     0,     0,     0,    81,     0,     0,    81,
    2878,     0,     0,     0,  4017,     0,     0,  1207,     0,     0,
     943,  1214,     0,     0,     0,     0,     0,  4245,     0,     0,
       0,     0,  1223,     0,     0,     0,  1599,     0,     0,     0,
       0,  1124,     0,  3132,   945,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3431,     0,     0,
     788,     0,     0,  3869,     0,     0,  1600,     0,     0,     0,
       0,  4054,     0,   789,     0,     0,  1124,  1124, -2299,     0,
       0,     0,  1987,     0,  1124,     0,     0,  1124,     0,     0,
    1124,     0,     0,     0,  2966,  2529,     0,     0,  1124,  1124,
       0,     0,  1988,  1989,   786,     0,  1124,     0,     0,  1124,
    1124,  1124,  1124,     0,     0,     0,     0, -2299,     0,  1124,
    1124,     0,  1124,     0,  1124,  4243,   351,  1124,   344,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1750,  1124,   392,     0,     0,  1124,     0,     0,
       0,  1124,     0,  1992,     0,  1124,     0,     0,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1993,  1124,     0,
       0,     0,     0,     0,  1124,     0,     0,  2544,  1124,     0,
       0,     0,     0,     0,     0,     0,     0,   350,   350,   350,
       0,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,  2967,     0,     0,     0,   390,     0,  1604,   795,     0,
     390,     0,  1022,     0,  1605,     0,     0,     0,  2412,     0,
       0,  1639,     0,     0,   893,     0,     0,     0,     0,  1607,
       0,     0,     0,  4136,     0,     0,   894,  1608,   392, -2299,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1124,
       0,     0,     0,     0,     0,     0,   895,  4137,     0,     0,
    1981,     0,     0,     0,     0,  1022,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   350,     0,     0,
     896,     0,     0,     0,     0,  1609,   392,     0,   392,  2968,
       0,  1981,  1984,     0,     0,     0,     0,  1985,     0,     0,
     897,     0,     0,     0,     0,  4205,     0,     0,     0,     0,
       0,     0,     0,     0,  4204,  1982,     0,     0,     0,     0,
       0,   898,    81,  1984,    81,     0,  2898,     0,  1985,  1996,
       0,     0,  4201,     0,   392,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,  2544,  2544,     0,     0,   899,     0,
       0,  1124,     0,   900,     0,     0,     0,     0,   901,     0,
       0,  4205,  4055,     0,     0,     0,     0,  4061,  4061,     0,
    4204,  1750,     0,   902,     0,   344,  1750,  1750,     0,     0,
       0,     0,     0,     0,  3143,     0,  4205,     0,  4201,     0,
       0,  4242,     0,     0,     0,  4204,     0,     0,     0,     0,
     392,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,  2417,  4201,     0,     0,     0,     0,     0, -2299,
       0,  2423,     0,  1987,   786,     0,     0,     0,     0,  2431,
    2432,     0,   392,     0,     0,     0,     0,     0,  4100,     0,
    4102,     0,     0,  1988,  1989,     0,   351,  2444,     0,     0,
    1986,     0,     0,     0,  1987,   903,     0,     0, -2299,     0,
       0,     0,     0,     0,     0,   904,  1981,     0,     0,     0,
     390,   390,   390,   350,  1988,  1989,     0,     0,     0,     0,
       0,     0,   817,     0,     0,     0,  3048,  4130,     0,  1990,
    1982,  1124,     0,  1750,  1992,     0,     0,     0,  1984,     0,
       0,     0,     0,  1985,     0,     0,   905,     0,  1993,     0,
     906,     0,   907,     0,     0,     0,     0,  1022,   908,     0,
     909,     0,  1991,     0,     0,  1992,     0,  1022,   795,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1993,
       0,     0,  1994,  1022,  4165,     0,   910,   911,     0,     0,
       0,   912,     0,  4061,     0,  1750,     0,     0,     0,   913,
     390,     0,     0,     0,   914,  1124,     0,     0,  2412,     0,
       0,     0,  2412,     0,   915,  1124,     0,     0,     0,     0,
   -2299,     0,     0,  4189,     0,     0,   916,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1022,     0,  2544,  1022,
       0,     0,     0,     0,     0,     0,  1022,     0,     0,     0,
       0,  1995,  1124,     0,  1116,     0,     0,     0,     0,   350,
       0,   350,  2544,  2544,     0,  1986,     0,     0,     0,  1987,
       0,     0,     0,     0,     0,  1022,     0,     0,     0,     0,
       0,     0,  1124,     0,     0,     0,     0,     0,   350,  1988,
    1989,     0,     0,  1750,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1990,     0,     0,     0,     0,     0,
    1996,     0,  1124,  1124,     0,     0,     0,  2000,  2001,  2002,
    2003,  2004,  2005,  2659,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1991,     0,     0,
    1992,  1996,  1124,  1124,  1997,  1998,  1999,  1124,  2000,  2001,
    2002,  2003,  2004,  2005,  1993,     0,     0,  1994,  2574,  1124,
    1124,  1124,  1124,     0,     0,     0,     0,   392,     0,     0,
       0,  1124,   392,     0,  1124,     0,  1124,     0,     0,     0,
       0,     0,     0,  1022,  1022,     0,  1124,  1124,     0,  1124,
    1981,     0,  2800,     0,     0,     0,   390,     0,  3251,     0,
       0,     0,  1124,     0,  1124,     0,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,     0,     0,  2544,     0,     0,
       0,     0,  1984,     0,  1124,     0,  1995,  1985,     0,  3272,
    1981,  3274,     0,     0,     0,  1124,     0,  1124,  1124,  1124,
       0,     0,     0,     0,     0,  2801,     0,     0,     0,     0,
       0,     0,     0,     0,  2802,  2803,  2804,  1124,     0,     0,
       0,     0,  1984,     0,     0,     0,  1124,  1985,     0,     0,
       0,     0,     0,  1124,     0,     0,     0,     0,  1124,     0,
       0,  2292,     0,     0,     0,  1124,  1124,  1124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2805,     0,
       0,     0,     0,  3310,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3547,     0,  1996,     0,     0,  1997,
    1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,  1124,
       0,     0,     0,     0,     0,  3076,     0,     0,     0,     0,
    2806,     0,   390,     0,   390,  2807,     0,     0,     0, -2299,
       0,     0,     0,  1987,     0,  1750,  1750,     0,  1750,     0,
       0,     0,     0,     0,     0,  1750,     0,     0,  2354,     0,
       0,   390,  3395,  1988,  1989,     0,     0,     0,     0,     0,
       0,  1022,     0,  2292,  2808,     0,  3251,     0, -2299,  1986,
       0,     0,     0,  1987,     0,     0,  1750,     0,  1750,  1022,
       0,  2809,  2810,  2811,  2812,  2813,     0,  2814,     0,     0,
       0,  1022,     0,  1988,  1989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1992,     0,     0,     0,  1990,     0,
       0,     0,   392,   392,   392,     0,     0,  3452,  1993,     0,
    2815,     0,  2292,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2412,     0,     0,  1992,     0,  2412,     0,  3005,  2412,
    1750,     0,     0,     0,     0,     0,  2816,     0,  1993,     0,
       0,     0,  3013,  3014,     0,     0,  3016,     0,     0,     0,
       0,     0,  3020,     0,  3336,  1750,     0,     0,  3488,     0,
       0,     0,     0,     0,     0,     0,     0,   350,     0,     0,
   -2299,     0,  2817,     0,  2818,     0,     0,  3493,     0,     0,
       0,     0,   392,  1750,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2819,     0,  1750,
       0,     0,  3515,     0,  2820,     0,     0,  2821,     0,     0,
    1995,  3054,     0,  1750,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1750,     0,
       0,     0,     0,     0,  2965,     0,  1899,  1022,  1022,  1022,
    1022,     0,     0,     0,     0,  1124,     0,     0,     0,  1124,
       0,     0,  1597,     0,     0,     0,     0,     0,     0,  1124,
    1996,     0,     0,     0,  1750,     0,     0,  2000,  2001,  2002,
    2003,  2004,  2005,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1598,     0,     0,     0,     0,     0,     0,     0,
       0,  1124,     0,     0,     0,     0,     0,     0,     0,     0,
    1996,     0,     0,  1997,  1998,  1999,     0,  2000,  2001,  2002,
    2003,  2004,  2005,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1124,     0,     0,  1750,     0,     0,     0,     0,
       0,  1124,     0,     0,     0,     0,     0,  1124,  1599,  1124,
       0,     0,     0,     0,  1750,  1124,     0,     0,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1124,     0,     0,
       0,  1124,  1124,     0,     0,     0,     0,     0,  1600,  1750,
       0,     0,     0,     0,  1124,  1747,     0,     0,   392,     0,
    1124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,     0,     0,  1124,     0,  1124,  2966,     0,     0,     0,
       0,     0,     0,  1750,  1124,  1124,  1124,     0,     0,     0,
    1124,     0,     0,  1124,     0,     0,     0,     0,     0,     0,
    1981,     0,     0,  1124,     0,  1116,     0,     0,     0,     0,
       0,     0,  1124,     0,     0,  2720,     0,     0,     0,  2723,
    3238,     0,     0,     0,  1982,     0,     0,     0,  2412,     0,
     390,     0,  1984,     0,  2735,     0,     0,  1985,     0,     0,
       0,     0,  2747,  1981,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3712,     0,  3256,  3257,
       0,     0,     0,     0,     0,  2761,     0,   350,     0,     0,
       0,     0,     0,     0,     0,  1984,     0,     0,  1747,   207,
    1985,     0,  2782,  1603,     0,     0,     0,     0,     0,  1604,
       0,     0,     0,     0,     0,     0,  1605,  2799,     0,  2823,
       0,     0,     0,  1639,   392,  1750,   392,     0,     0,     0,
       0,  1607,     0,     0,     0,     0,     0,  2839,     0,  1608,
       0,     0,  1116,     0,  2843,     0,     0,     0,     0,     0,
       0,  2856,     0,   392,     0,     0,     0,     0,  2860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1116,     0,     0,     0,     0,     0,  1986,
       0,     0,  1022,  1987,     0,     0,     0,  1609,     0,     0,
       0,  2968,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1988,  1989,     0,     0,     0,  1022,     0,
     669,     0,     0,  1172,     0,   687,     0,   691,  1990,     0,
    1116,     0,  1986,     0,     0,     0,  1987,   691,     0,     0,
    1124,     0,  1022,     0,     0,     0,  1899,     0,     0,     0,
       0,     0,     0,  1750,     0,  1173,  1988,  1989,     0,     0,
       0,  1991,     0,   687,  1992,     0,     0,     0,  1174,     0,
       0,  1990,     0,   691,     0,  1175,     0,     0,  1993,  1176,
       0,  1994,   687,   691,     0,     0,   691,     0,  1750,  1124,
    1124,  1022,   691,     0,     0,     0,   691,     0,     0,  1177,
     953,     0,     0,     0,  1991,     0,     0,  1992,  1124,     0,
    3854,     0,     0,  1124,   955,     0,  1124,   691,  3860,  3451,
    1178,  1993,   962,  3454,     0,  3456,     0,  3458,  3459,     0,
       0,     0,  1116,   691,     0,     0,  3464,   972,     0,   953,
       0,     0,     0,   993,     0,     0,     0,     0,     0,  3034,
    1995,     0,  1179,  1116,     0,     0,  1124,     0,     0,     0,
    1030,     0,     0,  1747,     0,     0,   691,     0,     0,  3481,
       0,     0,  1180,  1981,     0,     0,     0,  3034,     0,     0,
     390,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1124,  1995,     0,     0,  1181,  1982,  2219,  1124,
    1124,     0,  1750,     0,     0,  1984,     0,  1124,  1124,     0,
    1985,     0,  1124,  1750,     0,     0,     0,     0,  1124,  1124,
    1747,     0,  1124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1996,     0,  1124,  1997,  1998,  1999,  1116,  2000,  2001,  2002,
    2003,  2004,  2005,     0,  1182,     0,     0,    81,     0,  3122,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3395,     0,     0,     0,  1750,     0,  1747,
       0,   817,     0,  1996,     0,  1750,  1997,  1998,  1999,     0,
    2000,  2001,  2002,  2003,  2004,  2005,  1747,  1981,  1899,     0,
       0,     0,     0,     0,     0,  1183,     0,     0,     0,  1184,
       0,  1185,     0,     0,  1747,     0, -1806,  1186,     0,     0,
       0,  1982,     0,     0,     0,     0,     0,     0,     0,  1984,
     691,  1116,  1986,     0,  1985,     0,  1987,     0,     0,  1747,
       0,     0,     0,     0,     0,  1187,  1188,     0,     0,     0,
    1189,     0,     0,     0,     0,     0,  1988,  1989,  1190,     0,
       0,     0,     0,  1191,     0, -1806,     0,     0,     0,     0,
       0,  1990,  1124,     0,     0, -1806,     0,     0,     0, -1806,
       0,     0,   392,     0, -1806,  1192,     0,     0, -1806,     0,
       0, -1806,  3229, -1806,     0,  1747,     0,     0,     0,     0,
       0,     0,     0,     0,  1991,     0,     0,  1992,     0,     0,
       0,     0,  1124,     0,     0,     0,     0,  1750,     0, -1806,
       0,  1993,     0,     0,  1994,     0,     0,     0,     0,     0,
       0,  1124,     0,     0,     0,  1124,     0,     0,     0, -1806,
    1750,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1986,     0,     0,     0,
    1987,  1124,     0,     0,     0,  1750,     0,     0,     0,     0,
       0,     0,     0,  3275,  1899,     0,     0,     0,     0,     0,
    1988,  1989,     0, -1806,     0,  1124,  1124,     0,     0,  1124,
       0,     0, -1806,  1995,     0,  1990,  1124,  1124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1899,     0,     0,
       0,  1899,  1899,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,     0,  1991,  1124,
       0,  1992,     0,     0,     0, -1806,     0,     0,  3307,     0,
       0,     0,     0,     0,     0,  1993,     0,     0,  1994,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,   687,     0,     0,     0,     0,  1747,     0,     0,     0,
    3774,     0,     0,     0,     0,     0,     0,  3777,  3778,   958,
       0,     0,     0,  1996,     0,     0,  1997,  1998,  1999,     0,
    2000,  2001,  2002,  2003,  2004,  2005,     0,     0,     0,     0,
    3346, -1806,     0,     0,     0,     0,     0,  1124,  1124,   691,
     691,     0,     0,     0,  1750,     0,     0,  1995,     0,     0,
       0,     0, -1806,   691, -1806, -1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,  1750,     0,  1124,     0,  1124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1806,     0,     0, -1806, -1806,     0,
   -1806,  1124,     0,     0,  1750,   808,     0,     0,  1750,  1750,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2292,     0,     0,     0,     0,     0,     0,
       0,     0,   392,     0,     0,     0,  3469,  1996,     0,  1124,
    1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,
       0,     0,     0,     0,  3532,     0,     0,     0,  3482,     0,
    1124,   809,     0,     0,     0,     0,     0,  1750,     0,  4138,
    1126,   687,  1126,     0,     0,   669,     0,  1149,     0,   669,
     691,   810,   691,     0,   691,  1124,   691,  1126,   669,     0,
    1981,     0,     0,     0,     0,     0,     0,  1171,     0,     0,
       0,     0,   811,     0,     0,   691,     0,     0,   687,     0,
    1126,     0,  1981,   669,  1982,  1149,     0,   669,  1216,   691,
     691,     0,  1984,     0,   691,  2752,  1126,  1985,   669,   812,
    2219,  2759,     0,     0,   813,     0,  1982,     0,     0,   814,
       0,   691,     0,   691,  1984,     0,     0,     0,     0,  1985,
       0,     0,     0,  1124,   815,   691,     0,     0,   687,     0,
       0,     0,   691,     0,  1149,     0,   691,   691,     0,     0,
     691,     0,   691,     0,   691,     0,   691,     0,     0,  1126,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   691,   691,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3960,     0,  3961,  3962,     0,     0,     0,   691,     0,   691,
       0,  3966,  1329,     0,     0,  1981,   816,     0,  1124,     0,
       0,     0,     0,     0,     0,  3595,     0,  1747,     0,  1986,
       0,     0,     0,  1987,     0,     0,     0,     0,     0,   691,
       0,   687,     0,   817,     0,  1457,     0,  1984,     0,     0,
       0,  1986,  1985,  1988,  1989,  1987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   818,  1990,     0,
       0,     0,  1484,   819,     0,  1988,  1989,     0,   691,   820,
       0,   821,     0,     0,  3639,     0,  3641,     0,     0,  2219,
    1990,     0,     0,     0,     0,  1981,     0,     0,     0,     0,
       0,  1991,     0,     0,  1992,     0,     0,   822,   823,     0,
       0,     0,   824,     0,     0,     0,     0,     0,  1993,     0,
     825,  1994,     0,  1991,     0,   826,  1992,  1984,     0,     0,
       0,     0,  1985,   669,   669,   827,     0,     0,     0,  3548,
    1993,     0,     0,  1994,     0,     0,   691,   828,   691,     0,
       0,     0,   691,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2299,  1126,  1126,     0,  1987,     0,
       0,     0,     0,     0,     0,     0,     0,  1747,     0,     0,
    1995,     0,     0,     0,  4073,     0,     0,     0,  1988,  1989,
       0,     0,     0,   691,     0,     0,     0,     0,     0,  1981,
       0,     0,  1995, -2299,     0,     0,   691,     0,     0,  3551,
       0,     0,     0,  1149,     0,   691,     0,     0,     0,     0,
       0,   691,     0,  1982,  1133,  1126,     0,     0,     0,  1152,
       0,  1984,   691,     0,     0,     0,  1985,  1161,     0,  1992,
       0,  1126,  1126,     0, -2299,  1169,  3034,     0,  1987,     0,
    1196,     0,     0,  1993,     0,     0,     0,     0,     0,  1126,
    1788,     0,   691,  1793,     0,     0,     0,     0,  1988,  1989,
    1996,     0,     0,  1997,  1998,  1999,     0,  2000,  2001,  2002,
    2003,  2004,  2005, -2299,     0,  3575,     0,  1126,  1126,     0,
       0,   691,  1996,     0,     0,  1997,  1998,  1999,     0,  2000,
    2001,  2002,  2003,  2004,  2005,     0,  1457,     0,     0,  3564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1992,
       0,     0,     0,     0,     0, -2299,     0,     0,     0,     0,
       0,     0,   691,  1993,     0,     0,     0,  1981,     0,  1876,
    1876,     0,     0,     0,     0,   691,   953,     0,     0,     0,
       0,   691,     0,     0,     0,     0,   691,     0,  1986,     0,
       0,  1982,  1987,  1317,  1908,     0,     0,     0,   691,  1984,
    1914,     0,     0,     0,  1985,     0,     0,     0,     0,  1328,
       0,     0,  1988,  1989,     0,  3856,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3865,  1990,     0,  1745,
       0,     0,     0,     0,     0, -2299,     0,     0,     0,     0,
    1450,     0,     0,     0,     0,  1996,     0,     0,     0,     0,
       0,     0,  2000,  2001,  2002,  2003,  2004,  2005,     0,  1475,
    1991,     0,     0,  1992,     0,     0,     0,     0,     0,  2219,
    2759,     0,  2759,     0,     0,     0,     0,  1993,     0,  1747,
    1994,     0,     0,  1498,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   687,   687,     0,     0,     0,
    1747,     0,  1747,     0,     0,     0,     0,     0,     0,     0,
       0,  1457,     0,     0,     0,  1996,  1986,     0,  1457,  1457,
    1987,     0,  2000,  2001,  2002,  2003,  2004,  2005,     0,     0,
       0,     0,     0,     0,  2078,     0,  2085,     0,     0,  1995,
    1988,  1989,  1745,     0,   691,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1747,     0,     0,     0,     0,     0,
    3034,     0,     0,     0,     0,     0,     0,     0,  1991,     0,
     687,  1992,   669,     0,     0,     0,     0,     0,     0,  2759,
       0,     0,     0,     0,     0,  1993,     0,     0,  1994,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   691,     0,     0,     0,  1981,  2759,     0,  1996,
       0,     0,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,  1747,     0,     0,  3582,   691,     0,     0,
    1982,     0,     0,  1780,  1782,  1783,     0,  1747,  1984,     0,
       0,     0,     0,  1985,     0,     0,     0,     0,     0,     0,
       0,     0,  2759,     0,     0,     0,     0,  1995,     0,     0,
       0,     0,  2046,     0,     0,     0,     0,     0,  1149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1747,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1126,
    1126,  1126,  1126,     0,     0,     0,     0,   669,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1788,  1450,     0,     0,     0,     0,     0,     0,  1126,
    1126,     0,     0,     0,     0,  1126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1450,     0,  1996,  1981,  1747,
    1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,
       0,     0,     0,     0,  3591,  1986,     0,     0,  1747,  1987,
       0,     0,  1982,     0,  1981,     0,     0,  1745,     0,     0,
    1984,     0,     0,     0,     0,  1985,   691,     0,     0,  1988,
    1989,     0,     0,  1747,   669,     0,     0,     0,   691,     0,
    1126,  1126,  1126,  1126,  1990,     0,  1984,     0,     0,   669,
       0,  1985,  1745,     0,     0,  1457,     0,  1788,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1747,     0,     0,
       0,     0,     0,     0,  1745,     0,     0,  1991,     0,     0,
    1992,     0,   687,   691,     0,     0,   691,   691,     0,     0,
       0,     0,  1149,     0,  1993,   691,   691,  1994,   691,     0,
     691,     0,     0,     0,     0,   691,     0,   691,   669,     0,
       0,     0,  1126,  1126,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2068,     0,     0,     0,   691,   691,     0,
       0,     0,     0,  1745,     0,     0,     0,     0,  3818,     0,
       0,     0,     0,     0,  1876,     0,     0,  1986,     0,   691,
    1745,  1987,   691,   691,     0,     0,   691,     0,     0,     0,
       0,     0,  2480,  1981,     0,     0,  1995,     0,  1745,     0,
       0,  1988,  1989, -2299,     0,     0,     0,  1987,     0,     0,
     953,   953,     0,     0,  2505,     0,  1990,  1982,     0,  2759,
    3064,     0,     0,  1745,     0,  1984,     0,  1988,  1989,     0,
    1985,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2299,     0,     0,     0,     0,     0,  1149,  1991,
       0,     0,  1992,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1993,     0,     0,  1994,
       0,     0,     0,     0,     0,     0,     0,     0,  1992,  1745,
       0,     0,     0,     0,     0,     0,  1996,     0,     0,  1997,
    1998,  1999,  1993,  2000,  2001,  2002,  2003,  2004,  2005,     0,
       0,     0,   794,  3788,  2235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1747,  1995,     0,
       0,     0,     0,     0,     0,   794,     0,     0,     0,     0,
       0,  2285,  1986,     0,     0,     0,  1987,     0,     0,     0,
       0,     0,     0,     0, -2299,     0,     0,     0,     0,     0,
       0,  2305,  2219,     0,     0,     0,  1988,  1989,     0,     0,
    2085,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,   984,     0,     0,     0,     0,     0,     0,   984,
       0,   984,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1991,     0,     0,  1992,  1996,     0,
       0,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,
    2005,  1993,     0,     0,  1994,  3820,     0,   669,     0,     0,
    1745,     0,     0,     0,  1996,     0,     0,     0,     0,   691,
       0,  2000,  2001,  2002,  2003,  2004,  2005,     0,     0,     0,
       0,   669,   691,     0,     0,   669,   687,   691,     0,     0,
       0,   691,     0,     0,     0,     0,  1747,   691,     0,     0,
     669,     0,     0,   691,     0,     0,     0,  1747,   669,   691,
       0,     0,     0,     0,   691,  2435,     0,     0,     0,  1981,
       0,     0,     0,  1995,  2439,     0,     0,     0,     0,     0,
       0,   669,   691,     0,     0,  2764,  2765,   691,   691,   691,
     691,  2772,     0,  1982,   691,   691,     0,     0,   669,   691,
       0,  1984,   691,     0,     0,     0,  1985,  2793,  2793,     0,
       0,     0,     0,   669,     0,   669,   691,     0,     0,     0,
       0,  1747,  1450,  1450,     0,  1126,   691,     0,   691,  1747,
       0,     0,     0,   669,     0,     0,     0,   691,   691,   691,
     669,   691,     0,     0,     0,     0,     0,   669,   691,   691,
       0,     0,     0,     0,   669,     0,   691,   691,     0,     0,
       0,     0,     0,  1996,     0,     0,  1997,  1998,  1999,  1126,
    2000,  2001,  2002,  2003,  2004,  2005,  1126,  1126,  1126,  1126,
    1126,  1126,     0,     0,     0,     0,     0,     0,     0,     0,
    1981,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2793,
       0,     0,     0,     0,  1982,     0,     0,   953,     0,     0,
       0,     0,  1984,     0,     0,     0,     0,  1985,  1986,     0,
       0,     0,  1987,     0,     0,     0,     0,     0,     0,  1745,
       0,  2938,     0,     0,  1745,  1745,     0,     0,  2952,     0,
       0,  2632,  1988,  1989,     0,     0,     0,     0,  1793,     0,
       0,  3946,     0,     0,     0,     0,  2983,  1990,     0,  1981,
    2983,  2996,     0,     0,     0,     0,  2648,     0,     0,     0,
       0,     0,     0,     0,  1747,     0,     0,  1126,  2793,  1126,
    2793,     0,     0,  1982,     0,     0,     0,     0,     0,     0,
    1991,  1984,     0,  1992,  1457,     0,  1985,     0,     0,  1747,
       0,     0,     0,     0,     0,     0,     0,  1993,   691,     0,
    1994,     0,     0,  1876,     0,  2668,     0,   691,     0,     0,
       0,     0,     0,     0,     0,   669,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1986,
       0,     0,     0,  1987,     0,     0,     0,     0,     0,   691,
       0,  1745,     0,   669,     0,     0,     0,     0,     0,     0,
    2759,     0,     0,  1988,  1989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1990,  1995,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1991,     0,  1745,  1992,     0,     0,     0,  1986,     0,
       0,     0,  1987,     0,     0,     0,     0,  3126,  1993,     0,
       0,  1994,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1988,  1989,     0,     0,     0,     0,  2759,     0,
       0,     0,     0,     0,  1619,     0,  1149,  1990,     0,     0,
    1620,     0,     0,     0,     0,  2781,     0,     0,     0,  1996,
       0,     0,  1997,  1998,  1999,  1747,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,  1644,     0,  3976,     0,     0,     0,
    1991,     0,     0,  1992,     0,     0,     0,     0,     0,  1621,
    1995,     0,     0,  1457,     0,     0,     0,  1993,  1747,     0,
    1994,  1745,  1747,  1747,  2085,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1981,
       0,  1645,     0,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,  1122,     0,     0,     0,     0,  1122,  1622,
       0,     0,     0,  1982,     0,     0,  1623,     0,     0,  1624,
       0,  1984,     0,     0,     0,     0,  1985,     0,   669,   691,
     691,  3946,     0,     0,     0,     0,     0,     0,  1122,  1995,
       0,  2923,     0,  1876,     0,     0,     0,     0,     0,     0,
    1996,     0,   691,  1997,  1998,  1999,     0,  2000,  2001,  2002,
    2003,  2004,  2005,     0,     0,  1646,     0,  3991,  1625,     0,
       0,     0,     0,     0,     0,  2942,     0,     0,     0,     0,
       0,     0,  2960,     0,   691,   691,   691,   691,  1122,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   669,
    1647,   691,  1648,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1649,     0,     0,     0,   691,     0,  1996,
       0,   691,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,     0,     0,  4025,     0,  1986,     0,
       0,     0,  1987,     0,     0,     0,     0,     0,  1650,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     691,     0,  1988,  1989,   669,   691,     0,     0,     0,     0,
       0,     0,     0,     0,  2793,  2793,     0,  1990,  1651,     0,
       0,  1122,  1629,  1652,     0,     0,     0,   984,     0,     0,
       0,   984,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3353,     0,     0,     0,     0,  1653,     0,     0,     0,
    1991,     0,     0,  1992,     0,     0,  1654,     0,     0,     0,
    1122,     0,     0,  1745,  1745,     0,  1745,  1993,     0,     0,
    1994,     0,     0,  1745,     0,     0,     0,     0,     0,     0,
     691,   691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   691,     0,
       0,     0,     0,     0,  1745,     0,  1745,  1457,     0,     0,
       0,     0,     0,     0,     0,   687,     0,     0,   691,  2983,
       0,     0,  3434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3447,     0,     0,     0,  1995,
       0,     0,     0,     0,     0,   691,     0,  3158,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   691,   669,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   691,
       0,     0,   669,     0,     0,     0,     0,     0,  1745,  2480,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   691,     0,     0,   669,     0,     0,  1122,     0,     0,
    1450,     0,     0,  1745,  1122,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1748,  1981,     0,     0,  1996,
       0,  1745,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,     0,     0,  4126,  1745,     0,     0,
    1982,     0,     0,     0,     0,  1122,     0,     0,  1984,     0,
       0,  1745,     0,  1985,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1981,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,  3568,
       0,     0,  1745,     0,     0,  1122,     0,     0,     0,     0,
    1982,     0,     0,  1983,     0,     0,     0,     0,  1984,     0,
       0,     0,     0,  1985,     0,     0,     0,     0,     0,     0,
    2085,     0,     0,     0,     0,     0,     0,     0,  1748,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,  1745,     0,     0,  1876,  1876,     0,  1981,
       0,   669,     0,     0,     0,  1986,     0,     0,     0,  1987,
       0,     0,  1745,     0,     0,     0,     0,     0,  1122,     0,
       0,     0,     0,  1982,     0,     0,     0,  2673,     0,  1988,
    1989,  1984,     0,     0,     0,     0,  1985,  1745,     0,     0,
     691,   691,     0,     0,  1990,     0,     0,     0,     0,  1122,
    1122,     0,  1122,     0,     0,     0,   691,     0,     0,     0,
     669,   691,   669,   691,   691,   691,   691,     0,     0,  1122,
       0,  1745,  3389,     0,     0,  1986,     0,  1991,     0,  1987,
    1992,     0,  3400,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1993,     0,     0,  1994,  3413,  1988,
    1989,     0,     0,     0,     0,     0,  2674,     0,     0,     0,
       0,     0,  3353,     0,  1990,  3524,     0,     0,     0,     0,
       0,  1122,   794,     0,     0,   691,   691,   691,     0,   691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1991,  1122,     0,
    1992,  3460,  1122,  1122,  3461,  2938,     0,     0,  1986,     0,
    2764,  3465,  1987,  2764,  1993,  3731,  1995,  1994,     0,     0,
       0,     0,     0,     0,     0,  2793,     0,     0,     0,  3525,
       0,     0,  1988,  1989,     0,     0,     0,     0,     0,     0,
    1450,     0,     0,  1745,  2983,     0,   691,  1990,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2938,     0,  3769,
       0,   691,     0,     0,     0,     0,  2793,     0,  2793,     0,
       0,     0,     0,  1748,     0,     0,     0,   794,     0,     0,
    1991,   984,   669,  1992,     0,     0,  1995,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1993,     0,     0,
    1994,   984,     0,     0,     0,     0,  1996,     0,  1748,  1997,
    1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1748,     0,     0,     0,   984,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3557,  3558,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1745,     0,     0,     0,     0,     0,     0,     0,  1995,
       0,    55,     0,     0,     0,     0,  1996,  3832,     0,  1997,
    1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,  1748,
       0,  1149,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1748,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3853,  2675,     0,     0,
       0,   669,   691,     0,  1748,     0,     0,     0,     0,     0,
       0,     0,   669,   691,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   691,   691,  1126,   691,  1748,
       0,     0,     0,     0,   794,     0,     0,     0,     0,  1996,
       0,     0,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,  1876,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3353,  3353,
    3353,  3353,  3353,     0,     0,     0,     0,  1122,     0,  1122,
       0,     0,     0,     0,     0,  1748,     0,     0,  1122,     0,
    1745,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1745,     0,     0,     0,     0,   691,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   691,     0,  3684,     0,     0,     0,
       0,     0,  3941,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3709,  3950,     0,     0,   691,     0,
       0,     0,     0,     0,     0,  1122,  3714,     0,  3769,     0,
       0,     0,     0,     0,     0,  1745,     0,     0,     0,     0,
     691,  3731,     0,  1745,     0,     0,   669,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,  1122,     0,     0,     0,     0,     0,     0,  1122,     0,
       0,  1122,     0,     0,  1122,     0,     0,     0,     0,     0,
       0,     0,  1122,  1122,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,  1122,  1122,  1122,  1122,     0,     0,     0,
       0,     0,     0,  1122,  1122,     0,  1122,     0,  1122,     0,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
    1149,     0,     0,     0,     0,     0,  1748,  1122,   794,     0,
       0,  1122,     0,     0,     0,  1122,     0,     0,     0,  1122,
    1876,     0,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,     0,  1122,     0,     0,     0,     0,     0,  1122,     0,
       0,     0,  1122,     0,     0,     0,    85,     0,     0,     0,
       0,  2793,    89,  2764,     0,     0,    93,     0,    94,     0,
      96,    97,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   106,  3821,  3822,  3823,  3824,  1126,  3941,  1745,     0,
       0,  1126,  1126,     0,     0,     0,     0,     0,   119,   120,
       0,     0,     0,     0,     0,   691,     0,     0,     0,     0,
       0,     0,     0,  1745,     0,     0,     0,     0,     0,     0,
       0,  1981,     0,  1122,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,     0,  4083,     0,
       0,     0,     0,     0,   129,  1982,   130,   131,     0,  1981,
       0,     0,     0,  1984,     0,     0,     0,     0,  1985,     0,
    1055,  1126,  1126,  1126,  1126,   691,     0,     0,     0,   982,
       0,     0,     0,  1982,  1745,     0,   982,     0,   982,     0,
     141,  1984,   142,   143,     0,     0,  1985,   145,   146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   147,     0,
     148,     0,     0,     0,     0,     0,     0,     0,   794,     0,
    3941,  1126,     0,     0,     0,     0,     0,   151,     0,   152,
       0,     0,   155,     0,     0,  1122,     0,     0,   156,     0,
       0,     0,     0,     0,   157,     0,     0,     0,     0,     0,
     158,     0,     0,     0,     0,  1748,   159,     0,     0,     0,
    1748,  1748,   161,     0,   163,     0,     0,     0,     0,   165,
    3100,     0,  1745,     0,     0,  3101,   691,     0,  1126,     0,
       0,     0,   169,     0,   794,     0,     0,  1126,     0,     0,
    1986,     0,     0,     0,  1987,     0,     0,     0,     0,  1745,
    3950,     0,     0,     0,     0,     0,  4083,     0,     0,   174,
       0,     0,     0,     0,  1988,  1989,   794,  1126,  1986,     0,
       0,     0,  1987,     0,     0,     0,     0,     0,  4202,  1990,
       0,     0,  1745,     0,   183,   184,  1745,  1745,     0,     0,
     185,     0,  1988,  1989,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,  1990,     0,     0,
       0,     0,  1991,     0,     0,  1992,     0,   191,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,  1748,     0,  1993,
       0,     0,  1994,     0,  4202,     0,     0,     0,     0,     0,
    1991,     0,     0,  1992,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,     0,  1993,     0,  4202,
    1994,     0,     0,     0,     0,   204,     0,     0,     0,   205,
       0,   206,     0,  3078,     0,     0,   207,     0,     0,     0,
       0,   208,     0,     0,   210,     0,     0,  4023,   212,  1748,
       0,     0,     0,     0,   213,     0,     0,     0,     0,  1122,
     214,  1995,     0,   216,     0,     0,     0,     0,     0,  1122,
     219,     0,     0,  1450,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   221,     0,     0,     0,  1981,     0,  1995,
       0,     0,     0,     0,     0,     0,     0,  4067,     0,   226,
       0,   227,     0,     0,     0,     0,  1122,     0,   229,     0,
     230,  1982,     0,   231,  3108,     0,  1981,   232,     0,  1984,
       0,     0,     0,     0,  1985,     0,     0,     0,     0,   235,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,     0,
    1982,     0,     0,     0,     0,     0,  4089,  1748,  1984,     0,
       0,  1996,     0,  1985,  1997,  1998,  1999,     0,  2000,  2001,
    2002,  2003,  2004,  2005,     0,     0,  1122,  1122,     0,     0,
     244,     0,     0,     0,     0,     0,     0,     0,     0,  1996,
       0,     0,  1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,
    2004,  2005,     0,     0,     0,     0,  1122,  1122,     0,     0,
       0,  1122,     0,     0,     0, -1808,     0,     0,     0,     0,
       0,     0,     0,  1122,  1122,  1122,  1122,     0,     0,     0,
       0,   794,     0,     0,     0,  1122,   794,     0,  1122,     0,
    1122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,  1122,     0,  1122,     0,     0,  1986,     0,     0,     0,
    1987,     0,     0,     0, -1808,     0,  1122,     0,  1122,     0,
    3113,     0,  1122,     0, -1808,     0,     0,     0, -1808,     0,
    1988,  1989,     0, -1808,     0,  1986,     0, -1808,  1122,  1987,
   -1808,     0, -1808,     0,     0,  1990,     0,     0,     0,  1122,
       0,  1122,  1122,  1122,     0,     0,     0,     0,     0,  1988,
    1989,     0,     0,     0,     0,     0,     0,     0, -1808,     0,
       0,  1122,     0,     0,  1990,     0,     0,     0,  1991,     0,
    1122,  1992,     0,     0,     0,     0,     0,  1122, -1808,     0,
       0,     0,  1122,     0,     0,  1993,     0,     0,  1994,  1122,
    1122,  1122,     0,     0,     0,     0,     0,  1991,     0,     0,
    1992,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1993,     0,     0,  1994,     0,     0,
       0,     0, -1808,     0,     0,     0,     0,     0,     0,     0,
       0, -1808,     0,  1122,     0,     0,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1995,     0,  1748,
    1748,     0,  1748,     0,     0,     0,     0,     0,     0,  1748,
       0,     0,     0,     0, -1808,  1119,     0,     0,     0,     0,
       0,     0,  1981,     0,     0,     0,  1995,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1748,     0,  1748,     0,     0,     0,  1982,     0,     0,  3117,
       0,  1981,     0,     0,  1984,     0,     0,     0,   958,  1985,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,  1982,   794,   794,   794,     0,
   -1808,     0,     0,  1984,     0,     0,     0,  1996,  1985,     0,
    1997,  1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,
       0, -1808,     0, -1808, -1808,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1748,     0,  1996,     0,     0,  1997,
    1998,  1999,     0,  2000,  2001,  2002,  2003,  2004,  2005,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1748,
       0,     0,     0, -1808,     0,     0, -1808, -1808,     0, -1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   794,  1748,  1119,     0,
       0,     0,     0,     0,   982,     0,     0,     0,   982,     0,
       0,  1986,     0,  1748,     0,  1987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1748,     0,     0,
       0,     0,     0,     0,     0,  1988,  1989,  1119,     0,     0,
    1986,     0,  1748,     0,  1987,     0,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,     0,     0,     0,     0,  1122,
       0,     0,     0,  1122,  1988,  1989,     0,     0,     0,     0,
       0,     0,     0,  1122,     0,     0,     0,     0,  1748,  1990,
       0,     0,     0,  1991,     0,     0,  1992,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1993,     0,     0,  1994,     0,  1122,     0,     0,     0,     0,
       0,     0,  1991,     0,     0,  1992,     0,     0,     0,     0,
       0,     0,     0,  1981,     0,     0,     0,     0,     0,  1993,
       0,     0,  1994,     0,     0,     0,  1122,     0,     0,  1748,
       0,     0,     0,     0,     0,  1122,     0,  1982,     0,     0,
    3531,  1122,     0,  1122,     0,  1984,     0,     0,  1748,  1122,
    1985,     0,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1995,     0,  1119,  1122,  1122,     0,     0,     0,
       0,  1119,     0,  1748,     0,     0,     0,     0,  1122,     0,
       0,     0,   794,     0,  1122,     0,     0,     0,     0,     0,
       0,  1995,  1746,     0,  1122,     0,     0,  1122,     0,  1122,
       0,     0,     0,     0,     0,     0,     0,  1748,  1122,  1122,
    1122,     0,     0,     0,  1122,     0,  3485,  1122,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,  1122,     0,     0,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,     0,
       0,  1981,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1996,     0,     0,  1997,  1998,  1999,     0,  2000,
    2001,  2002,  2003,  2004,  2005,  1982,     0,     0,     0,     0,
       0,     0,  1986,  1984,     0,     0,  1987,     0,  1985,     0,
       0,  1996,  1119,     0,  1997,  1998,  1999,     0,  2000,  2001,
    2002,  2003,  2004,  2005,     0,     0,  1988,  1989,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,  1981,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   794,  1748,
     794,     0,     0,     0,     0,     0,     0,  1119,  1982,     0,
       0,     0,     0,     0,  1991,     0,  1984,  1992,     0,     0,
       0,  1985,     0,     0,     0,     0,     0,   794,     0,     0,
       0,  1993,     0,     0,  1994,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,  1119,     0,  1119,
    1986,     0,     0,     0,  1987,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,  1988,  1989,     0,     0,     0,     0,
       0,     0,     0,  1995,  1122,     0,     0,     0,     0,  1990,
       0,     0,     0,     0,     0,     0,     0,  1748,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,  1991,  1986,     0,  1992,     0,  1987,     0,     0,
       0,     0,  1748,  1122,  1122,     0,     0,     0,     0,  1993,
       0,     0,  1994,     0,     0,  1119,     0,  1988,  1989,  1119,
    1119,     0,  1122,     0,     0,     0,     0,  1122,     0,     0,
    1122,     0,  1990,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1996,     0,     0,  1997,  1998,  1999,     0,
    2000,  2001,  2002,  2003,  2004,  2005,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1991,     0,     0,  1992,     0,
    1122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1995,  1993,     0,     0,     0,     0,     0,     0,     0,
    1746,     0,     0,     0,     0,     0,     0,     0,   982,     0,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,     0,
       0,     0,     0,  1122,  1122,     0,  1748,     0,   982,     0,
       0,  1122,  1122,     0,     0,  1746,  1122,  1748,     0,     0,
       0,     0,  1122,  1122,     0,     0,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1746,     0,     0,
       0,   982,     0,     0,  1995,     0,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,  1996,   688,     0,  1997,  1998,  1999,     0,  2000,  2001,
    2002,  2003,  2004,  2005,     0,     0,     0,     0,     0,     0,
       0,  1748,     0,     0,     0,     0,     0,     0,     0,  1748,
       0,     0,     0,     0,     0,     0,  1746,     0,     0,     0,
     688,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1746,     0,     0,     0,     0,     0,   688,
     688,     0,     0,     0,     0,     0,     0,     0,     0,   688,
       0,  1746,     0,   674,  1996,     0,     0,  1997,  1998,  1999,
       0,  2000,  2001,  2002,  2003,  2004,  2005,     0,     0,     0,
       0,     0,     0,     0,   674,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     688,     0,     0,  1737,     0,     0,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,  1119,     0,     0,     0,
       0,     0,  1746,     0,     0,  1119,  1122,     0,     0,     0,
       0,  1748,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,     0,  1122,
       0,     0,     0,     0,  1748,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,     0,  1748,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,     0,  1122,
    1122,     0,     0,  1122,     0,     0,  1737,     0,     0,     0,
    1122,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,  1119,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,  1119,     0,
    1748,  1119,     0,  1122,     0,     0,     0,     0,     0,  1119,
    1119,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
    1119,  1119,  1119,  1119,     0,     0,     0,     0,     0,     0,
    1119,  1119,     0,  1119,  1122,  1119,     0,   688,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1746,  1119,     0,     0,     0,  1119,     0,
       0,     0,  1119,     0,     0,     0,  1119,     0,     0,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,     0,  1119,
       0,  1122,  1122,     0,     0,  1119,     0,     0,  1748,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1122,  1748,     0,  1122,     0,  1122,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,  1748,     0,
       0,     0,  1748,  1748,     0,     0,   843,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,   844,     0,
       0,     0,     0,     0,     0,     0,   794,     0,     0,     0,
       0,     0,     0,  1122,     0,   690,     0,     0,   845,     0,
       0,     0,     0,     0,     0,   693,     0,     0,     0,     0,
       0,     0,     0,     0,  1122,     0,     0,     0,   846,     0,
       0,  1748,  -582,     0,     0,     0,     0,     0,     0,     0,
       0,  1737,     0,     0,     0,     0,     0,     0,     0,  1122,
       0,   834,   847,     0,     0,     0,     0,     0,   848,     0,
       0,   883,     0,     0,   887,     0,     0,     0,     0,     0,
     883,     0,     0,   849,   942,     0,  1737,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,   688,     0,
       0,     0,     0,     0,     0,   961,     0,     0,  1737,     0,
     850,     0,  1746,     0,     0,  -745,   851,  1746,  1746,     0,
     852,   883,     0,     0,     0,     0,     0,  1122,     0,     0,
       0,     0,     0,     0,     0,  -724,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1040,     0,     0,     0,  -447,     0,
     688,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,   853,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1737,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1737,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1122,     0,     0,     0,     0,   854,     0,     0,
     855,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,  1119,     0,  1746,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -447,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   856,     0,
       0,     0,  -745,     0,   857,     0,     0,     0,     0,     0,
       0,     0,   858,  1737,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,   859,
     860,     0,   861,   862,     0,     0,  1119,     0,  1086,     0,
       0,   863,     0,     0,     0,   864,   865,     0,     0,     0,
       0,   866,     0,     0,     0,     0,   867,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1236,   688,     0,
     688,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,   688,     0,     0,  1746,   674,     0,   674,     0,   674,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,  1119,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,  1119,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,  1737,     0,     0,     0,     0,     0,
    1119,  1119,  1119,  1119,     0,     0,   688,     0,   688,     0,
       0,     0,  1119,     0,     0,  1119,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,  1119,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,  1119,     0,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,  1119,  1119,
    1119,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
     674,   674,     0,     0,  1552,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,  1119,  1119,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,  1094,  1095,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1746,  1746,     0,  1746,
       0,     0,     0,     0,     0,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1737,     0,     0,     0,     0,  1737,  1737,
       0,     0,     0,     0,     0,     0,     0,  1746,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1151,     0,
    1153,     0,  1155,     0,  1157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1199,     0,     0,     0,     0,     0,     0,
       0,  1746,  1872,     0,     0,     0,     0,  1217,  1218,     0,
       0,     0,  1220,     0,     0,     0,     0,     0,     0,     0,
     688,     0,     0,     0,     0,     0,  1746,     0,     0,  1086,
       0,   883,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,  1245,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1746,  1264,     0,     0,  1266,     0,
    1268,     0,  1271,     0,     0,     0,     0,     0,     0,     0,
    1746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1746,     0,     0,     0,     0,  1302,
    1303,     0,     0,     0,     0,     0,     0,  1737,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1326,  1119,  1327,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1119,     0,     0,  2021,     0,  1746,     0,     0,     0,     0,
       0,     0,   688,   688,     0,     0,     0,  1086,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   674,  1119,     0,     0,   674,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1040,     0,     0,     0,
       0,     0,     0,  1119,     0,  1737,  1746,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,  1119,     0,
    1119,     0,     0,     0,     0,  1746,  1119,     0,     0,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,     0,
       0,     0,  1119,  1119,     0,     0,     0,   688,     0,   674,
    1746,     0,     0,     0,     0,  1119,     0,  2151,     0,     0,
       0,  1119,     0,     0,  1570,     0,  1572,     0,     0,     0,
    1574,  1119,     0,     0,  1119,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,  1746,  1119,  1119,  1119,     0,     0,
       0,  1119,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,   674,     0,     0,     0,
       0,     0,   674,  1119,     0,     0,     0,     0,     0,     0,
       0,  1683,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1695,     0,     0,     0,     0,     0,
       0,     0,     0,  1701,     0,     0,     0,     0,     0,  1703,
       0,     0,   674,     0,     0,   674,   674,     0,     0,     0,
    1751,     0,  1123,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1790,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,   674,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,     0,     0,  1737,  1737,     0,
    1737,     0,     0,     0,     0,     0,     0,  1737,     0,  1897,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1737,     0,
    1737,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1746,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
    1119,  1119,     0,     0,     0,   688,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1119,
    2021,     0,  1737,     0,  1119,     0,     0,  1119,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1737,  1040,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,  1737,     0,     0,     0,     0,
    1119,  1119,     0,  1746,     0,     0,     0,     0,  1119,  1119,
    1737,     0,     0,  1119,  1746,     0,     0,     0,     0,  1119,
    1119,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,  1737,     0,     0,     0,
    1872,     0,     0,     0,     0,     0,  1123,  2643,     0,     0,
    2162,     0,     0,  1123,     0,     0,  2151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,  1749,  2193,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1737,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,  1123,     0,     0,     0,     0,     0,
     674,     0,     0,     0,   674,  1737,     0,     0,  2705,     0,
    1552,     0,     0,     0,     0,     0,   688,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,  1119,     0,     0,     0,  1119,     0,     0,     0,
       0,  1746,     0,     0,  2345,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2367,  1123,     0,     0,
       0,     0,  1119,     0,     0,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,  1119,  1123,  1123,
    1119,  1123,     0,     0,     0,     0,   674,  1119,  1119,     0,
       0,  2421,     0,     0,   674,  2425,   674,  1737,  1123,     0,
       0,     0,     0,     0,  2434,     0,  2436,     0,  2437,     0,
       0,     0,     0,  2438,     0,     0,     0,  1746,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2455,   883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,  1123,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,  1119,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,  1746,     0,  1119,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1737,     0,  1749,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,  1746,     0,     0,     0,  1746,
    1746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   688,  1872,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2642,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,     0,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1737,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1749,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,  1086,     0,  1737,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
    2721,     0,     0,     0,     0,  2725,     0,     0,     0,  2729,
       0,     0,     0,     0,     0,  2733,     0,     0,     0,     0,
       0,  2738,     0,     0,     0,  2151,  1123,  2748,  1123,     0,
     674,     0,  2750,     0,  1749,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1119,
       0,     0,     0,  1420,     0,  2766,  2767,  2770,  2771,     0,
       0,     0,  2777,  2780,     0,     0,     0,  2783,     0,     0,
    2787,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2824,     0,     0,     0,     0,     0,
       0,     0,  1489,     0,  2827,     0,  2829,     0,     0,     0,
       0,     0,     0,     0,  1123,  2840,  2841,  2842,     0,  2844,
       0,     0,     0,     0,     0,     0,  2857,  2858,     0,     0,
       0,     0,     0,     0,  2861,  2862,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
    1123,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
    1123,     0,  1737,  1123,     0,     0,     0,     0,     0,     0,
       0,  1123,  1123,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,  1123,  1123,  1123,  1123,     0,  1737,     0,     0,
       0,     0,  1123,  1123,     0,  1123,     0,  1123,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1749,  1123,     0,     0,     0,
    1123,     0,     0,     0,  1123,     0,     0,     0,  1123,     0,
       0,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
       0,  1123,     0,     0,     0,     0,     0,  1123,  1737,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1739,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,     0,     0,     0,     0,   688,     0,
       0,     0,     0,     0,     0,     0,  1737,  3049,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1737,     0,   688,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1739,     0,  1737,     0,     0,     0,
    1737,  1737,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1921,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1944,     0,     0,     0,  1749,     0,     0,     0,     0,  1749,
    1749,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1968,  1969,     0,  1972,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2011,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2069,     0,     0,     0,     0,     0,     0,
       0,     0,  1740,     0,     0,     0,     0,  3230,  3231,     0,
       0,     0,     0,     0,  1123,     0,  1749,     0,     0,     0,
    2097,     0,     0,     0,  2107,  2110,     0,     0,     0,     0,
    3242,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2705,     0,  3258,  3259,  3260,  3261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,  1739,
       0,     0,   674,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
       0,     0,     0,     0,  1739,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3306,     0,
       0,     0,     0,  3308,     0,     0,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,  1123,     0,  3396,   883,
    1123,     0,  1739,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,  1123,  1123,  1123,  3242,     0,     0,     0,
    1739,     0,     0,     0,  1123,     0,     0,  1123,     0,  1123,
       0,     0,     0,     0,     0,     0,   883,     0,     0,  1123,
    1123,     0,  1123,     0,     0,  1739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,  1123,     0,     0,
       0,  1123,     0,  3453,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3462,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
    1123,  1123,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,  1739,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,  1123,  1123,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1740,     0,     0,     0,     0,  1742,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2151,  1123,     0,     0,  1740,     0,     0,     0,     0,
       0,     0,   674,     0,     0,     0,     0,     0,   674,     0,
       0,     0,     0,     0,     0,     0,     0,  1740,  1749,  1749,
    2515,  1749,   674,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2537,     0,     0,  2539,     0,     0,  2550,     0,
       0,     0,     0,     0,     0,  2557,  2562,     0,     0,  1749,
    2567,  1749,     0,  2572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,  2581,
       0,     0,  1739,  2587,     0,  1743,     0,  2599,  1742,     0,
       0,  2606,     0,  1740,  2608,  2609,  2610,  2611,  2612,  2613,
    2614,  2615,  2616,   674,  2617,     0,     0,     0,     0,     0,
    1420,  1740,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1749,  1744,     0,  1740,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,  3633,     0,     0,     0,     0,  3640,
       0,  3642,  3643,  3644,  3645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1489,  1749,     0,     0,     0,
       0,     0,  1740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1749,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1749,     0,  3696,  3698,  3700,     0,  3702,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,  1123,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,  1123,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2736,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1739,     0,     0,     0,     0,  1739,  1739,     0,  3771,
       0,     0,     0,     0,     0,  1123,     0,     0,  1749,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
    1123,     0,  1123,  1742,     0,     0,     0,  1749,  1123,     0,
       0,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
    1123,     0,     0,  1740,  1123,  1123,     0,     0,     0,     0,
       0,     0,  1749,     0,     0,     0,     0,  1123,  1742,     0,
       0,     0,     0,  1123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,  1123,     0,  1123,     0,
    1742,     0,     0,     0,     0,     0,  1749,  1123,  1123,  1123,
       0,     0,     0,  1123,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,  2895,     0,     0,
       0,     0,     0,  1739,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,  1743,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1742,     0,     0,     0,
    3857,     0,     0,     0,     0,     0,   674,     0,     0,     0,
       0,  3866,     0,     0,  1742,  1739,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3000,  1744,     0,     0,     0,     0,     0,     0,  1742,
    1743,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,  3021,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,     0,  1742,     0,     0,  1420,  1743,
       0,     0,     0,     0,  3913,     0,     0,     0,     0,     0,
       0,     0,  1740,  1739,     0,     0,  1743,  1740,  1740,     0,
       0,     0,  3929,     0,     0,     0,     0,     0,     0,  3060,
       0,     0,     0,     0,  1743,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,  1123,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,  1744,  1749,     0,  3963,     0,
       0,     0,     0,     0,     0,  2562,     0,  2562,  2562,     0,
       0,     0,     0,  1744,     0,     0,     0,  3120,     0,     0,
    3123,     0,  3125,     0,     0,     0,     0,     0,     0,     0,
       0,  1749,  1123,  1123,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,  1743,     0,     0,  3146,     0,
    3148,  1123,     0,     0,  3151,     0,  1123,     0,     0,  1123,
       0,     0,     0,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3166,     0,     0,     0,     0,
       0,     0,     0,     0,  1744,     0,  1742,     0,     0,  1123,
       0,     0,     0,  3196,     0,     0,     0,     0,     0,     0,
       0,     0,  1489,     0,     0,     0,     0,     0,     0,  2097,
       0,     0,     0,     0,  3210,     0,  1740,     0,     0,     0,
       0,  2110,  2110,  2107,     0,  1123,     0,     0,     0,     0,
       0,     0,  1123,  1123,     0,  1749,     0,     0,     0,     0,
    1123,  1123,     0,     0,     0,  1123,  1749,     0,     0,     0,
       0,  1123,  1123,     0,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3233,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,  1739,     0,  1739,     0,
       0,     0,     0,     0,     0,  1739,  1743,     0,     0,     0,
    1749,     0,     0,     0,  1740,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1739,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1744,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2007,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
    1739,     0,     0,     0,     0,  1742,     0,     0,     0,     0,
    1742,  1742,     0,     0,  4164,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,  2007,
    1749,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1739,  1123,     0,     0,     0,  1123,     0,
       0,     0,     0,  1749,     0,     0,     0,     0,     0,  1739,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1739,  1123,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,  1123,
       0,     0,  1123,     0,     0,     0,     0,     0,     0,  1123,
    1123,     0,     0,     0,     0,  1743,     0,  1742,     0,     0,
    1743,  1743,     0,     0,  1739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,  1740,     0,  1740,
       0,     0,     0,     0,  1744,     0,  1740,     0,     0,  1744,
    1744,     0,     0,  1123,     0,     0,     0,     0,  3486,  1742,
       0,     0,     0,     0,     0,  1739,     0,  3489,     0,     0,
       0,     0,     0,  3490,     0,  3491,     0,  1740,     0,  1740,
       0,     0,     0,     0,  1739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3509,  3510,     0,
    1123,  1123,     0,     0,     0,     0,     0,  1749,     0,  1739,
       0,     0,     0,     0,     0,     0,  2567,  1743,     0,     0,
       0,     0,     0,     0,     0,     0,  3535,     0,     0,  3538,
       0,  3540,     0,  1123,  1749,     0,  1123,     0,  1123,     0,
    3544,     0,     0,  1739,     0,     0,  3549,     0,     0,  3552,
       0,  1740,     0,     0,     0,     0,     0,  1742,     0,  3559,
       0,     0,     0,     0,  1123,     0,  1744,  1749,  3021,     0,
       0,  1749,  1749,     0,     0,     0,  1740,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1740,     0,     0,  1123,     0,     0,     0,     0,  1744,     0,
    1749,     0,     0,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,  1740,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
    2007,     0,     0,     0,     0,     0,     0,  1743,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2007,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2007,  1740,     0,     0,     0,  2546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1739,     0,     0,     0,     0,  2007,  2007,
    1740,     0,  2007,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3743,  3744,     0,  1739,  1742,
    1742,     0,  1742,     0,  1740,     0,     0,     0,     0,  1742,
       0,  2007,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1742,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3786,     0,     0,     0,     0,     0,     0,  2007,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2007,     0,     0,
       0,     0,     0,     0,     0,  3802,  3804,  2007,     0,     0,
    2007,     0,  1739,     0,  1742,     0,     0,     0,  3811,  1743,
    1743,     0,  1743,  1739,  3816,  3817,  1740,     0,  3819,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,  3833,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1743,     0,  1743,     0,     0,     0,     0,  1742,  1744,  1744,
       0,  1744,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,  1742,     0,     0,     0,  1739,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,  1742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,  1744,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1743,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,     0,  1742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3901,  1740,
       0,     0,     0,  1744,     0,     0,     0,  1743,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1743,     0,     0,     0,     0,  1744,  1742,
       0,     0,     0,     0,     0,     0,     0,  1743,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1742,     0,
       0,     0,  1743,     0,     0,     0,  1744,  3953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1739,     0,  1744,  1742,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,  1743,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
       0,  1744,     0,     0,     0,     0,     0,  1742,     0,     0,
       0,     0,     0,  1740,     0,  3984,     0,     0,     0,     0,
       0,     0,     0,  3986,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,     0,     0,  1743,     0,     0,  1740,     0,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1743,     0,  1742,
       0,     0,     0,     0,  4057,  2007,     0,     0,     0,     0,
       0,     0,  1744,     0,  1739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2007,     0,  2007,
       0,  2546,  2546,  3096,     0,     0,  2546,     0,     0,  2567,
    2007,  1739,     0,     0,     0,     0,  1744,  2007,     0,     0,
       0,     0,  2007,     0,     0,     0,     0,  2007,     0,     0,
       0,     0,  2007,     0,     0,     0,     0,  4091,     0,     0,
       0,  2007,     0,     0,  1739,  2546,  2546,  2007,  1739,  1739,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2007,
       0,     0,     0,     0,     0,     0,  2007,     0,  2007,  2007,
    2007,  2007,  2007,  2007,  2007,  2007,  2007,  2007,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1742,     0,  1743,
       0,  1740,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1740,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2007,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1743,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1742,     0,     0,     0,
       0,     0,  1743,     0,     0,     0,     0,  1742,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1744,  1740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,  1740,
    1740,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2007,  1743,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1743,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1744,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2007,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1742,     0,     0,     0,     0,     0,
    1744,  2007,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2007,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3096,  3096,     0,  2546,     0,     0,  2546,  2546,  2546,
    2546,  2546,  2546,  2546,  2546,  2546,  2546,  3096,     0,     0,
    1742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2007,     0,     0,  2007,     0,  2007,     0,     0,     0,     0,
    3096,  3096,     0,     0,  1743,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2546,  2546,  2007,     0,  2007,     0,
       0,  2007,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,  2007,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1744,     0,     0,     0,     0,  1742,     0,
       0,     0,     0,     0,     0,     0,  2007,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,     0,
    2007,     0,     0,     0,     0,  1742,     0,     0,     0,     0,
    1743,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,  1742,     0,
       0,     0,  1742,  1742,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       6,     7,     0,     0,     0,     0,     8,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,    35,  1743,    36,
       0,    37,    38,    39,    40,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1743,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,  2546,
       0,     0,  1743,  1743,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1744,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,  1744,  1744,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,  2007,     0,     0,  2007,
    2007,  2007,     0,     0,  3096,     0,     0,     0,     0,  3096,
    3096,  3096,  3096,  3096,  3096,  3096,  3096,  3096,  3096,  2007,
    2007,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2007,  2546,  2546,  2007,     0,
    2007,     0,    49,     0,  2007,  3096,  3096,     0,     0,  2007,
       0,     0,  2007,     0,     0,     0,     0,     0,     0,  2007,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    51,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3096,     0,    54,     0,     0,     0,     0,
       0,    55,    56,    57,     0,     0,     0,    58,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,    67,    68,     0,    69,    70,    71,    72,    73,
       0,     0,     0,  2007,  2007,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2007,     0,     0,     0,
    2546,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2007,     0,  2007,     0,     0,     0,     0,  3096,
    3096,  2007,     0,     0,  2546,  2546,  2007,  2007,     0,  2007,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2007,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3096,  2546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3096,  3096,  2007,     0,  2007,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,  2007,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,  3096,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,  2007,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   701,   422,   423,   424,   702,
     703,   704,   705,   706,   707,   708,   425,   426,   709,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,   710,
     431,   432,   433,   434,   435,   711,   712,   436,   437,   713,
     140,   439,   714,   440,   441,   442,   443,   144,   715,   716,
     444,   445,   446,   447,   448,   717,   718,   450,   451,   452,
     453,   454,   455,   719,   456,   457,   458,   149,   459,   720,
     721,   722,   723,   150,   724,   725,   726,   460,   461,   462,
     463,   464,   465,   153,   154,   466,   727,   467,   728,   468,
     469,   470,   471,   472,   729,   473,   474,   475,   730,   731,
     476,   477,   478,   479,   480,   732,   481,   482,   483,   733,
     484,   485,   734,   486,   487,   488,   162,   489,   490,   164,
     735,   491,   736,   492,   166,   493,   737,   494,   738,   495,
     167,   739,   168,   496,   497,   740,   498,   170,   741,   499,
     742,   500,   501,   502,   503,   504,   171,   505,   506,   507,
     743,   508,   509,   510,   511,   512,   513,   744,   172,   173,
     745,   514,   515,   516,   746,   175,   747,   176,   748,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,   749,   180,   181,   526,   182,   750,   527,   528,   529,
     751,   752,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,   188,   189,   753,   543,
     544,   545,   546,   547,   548,   549,   190,   550,   754,   551,
     552,   192,   553,   755,   193,   554,   194,   555,   556,   756,
     757,   557,   758,   759,   760,   558,   559,   560,   761,   762,
     195,   196,   197,   198,   199,   561,   562,   563,   564,   565,
     566,   763,   567,   200,   568,   201,   569,   570,   571,   764,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,   765,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   766,   592,   593,   209,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,   767,   604,   605,
     606,   607,   768,   608,   215,   609,   610,   217,   611,   218,
     769,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,   770,   623,   624,   771,   625,   626,   627,
     628,   629,   772,   222,   223,   773,   774,   631,   224,   632,
     225,   775,   633,   634,   635,   636,   637,   638,   776,   777,
     639,   640,   641,   642,   778,   779,   643,   644,   645,   646,
     780,   233,   781,   648,   234,   649,   650,   651,   782,   783,
     652,   784,   785,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    85,     0,     0,    86,    87,    88,    89,
      90,    91,    92,    93,     0,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   106,   920,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,   119,   120,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,   132,   133,     0,     0,   134,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,   141,     0,   142,
     143,   144,     0,     0,   145,   146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   147,     0,   148,     0,     0,
       0,   149,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,   151,     0,   152,   153,   154,   155,
       0,     0,     0,     0,     0,   156,     0,     0,     0,     0,
       0,   157,     0,     0,     0,     0,     0,   158,     0,     0,
       0,     0,     0,   159,   160,     0,     0,     0,     0,   161,
     162,   163,     0,   164,     0,     0,   165,     0,   166,     0,
       0,     0,     0,     0,   167,     0,   168,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   172,   173,     0,     0,   174,     0,     0,   175,
       0,   176,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,   180,   181,     0,   182,
       0,   183,   184,     0,     0,     0,     0,   185,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,   187,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
     190,     0,     0,     0,   191,   192,     0,     0,   193,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,     0,   205,     0,   206,     0,
       0,     0,     0,   207,     0,     0,     0,     0,   208,   209,
       0,   210,   211,     0,     0,   212,     0,     0,     0,     0,
       0,   213,     0,     0,     0,     0,     0,   214,   215,     0,
     216,   217,     0,   218,     0,     0,     0,   219,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
     221,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,   224,     0,   225,     0,   226,     0,   227,     0,
       0,     0,   228,     0,     0,   229,     0,   230,     0,     0,
     231,     0,     0,     0,   232,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,   235,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,     0,     0,     0,    55,     0,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   244,   104,   105,
       0,  -122,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   149,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
     154,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   160,     0,     0,     0,
       0,     0,   162,     0,     0,   164,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,   167,     0,   168,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
       0,     0,   171,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   172,   173,     0,     0,     0,     0,
       0,   175,     0,   176,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,   180,   181,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   187,   188,   189,     0,     0,     0,     0,     0,     0,
       0,     0,   190,     0,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   195,   196,   197,   198,
     199,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   209,     0,     0,   211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,   217,     0,   218,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
     223,     0,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,     0,     0,
     234,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   236,   237,   238,   239,   240,   241,
     242,   243,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,  2695,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   153,   154,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     160,     0,     0,     0,     0,     0,   162,     0,     0,   164,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     167,     0,   168,     0,     0,     0,     0,   170,     0,     0,
       0,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   172,   173,
       0,     0,     0,     0,     0,   175,     0,   176,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,   180,   181,     0,   182,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,     0,     0,
       0,     0,     0,     0,     0,     0,   190,     0,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,   196,   197,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   209,     0,     0,   211,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,     0,     0,   217,     0,   218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,   223,     0,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,     0,     0,   234,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   236,   237,
     238,   239,   240,   241,   242,   243,     4,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
    2697,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,    42,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     6,     7,     0,     0,     0,    49,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      51,    35,     0,     0,     0,    37,    38,    39,    40,    41,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,    42,     0,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1279,     0,
       0,    51,     0,    71,  1280,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,    44,    55,    56,
      57,     0,     0,     0,    58,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,    45,    65,    66,  1279,
    1844,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,    49,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,    35,     0,     0,
       0,    37,    38,    39,    40,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    51,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,    44,     0,    55,    56,    57,     0,     0,
       0,    58,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,    45,     0,    65,    66,  1279,  2447,     0,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    51,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
       0,    55,    56,    57,     0,     0,     0,    58,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1279,     0,     0,     0,     0,    71,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,  2636,   422,   423,   424,     0,     0,     0,     0,
    1341,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1342,   137,  1343,  1344,     0,   431,   432,   433,
     434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,
     440,   441,   442,   443,  1349,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,     0,  1350,  1351,  1352,
    1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,   465,
    1357,  1358,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,  2637,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,  1360,   489,   490,  1361,  1362,   491,     0,
     492,  1363,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,  1364,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,  1365,  1366,     0,  1367,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,  1368,
     181,   526,   182,     0,   527,   528,   529,  1369,  1370,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1371,   188,  1372,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,  1373,   551,   552,   192,   553,
    1374,  1375,   554,  1376,   555,   556,     0,     0,   557,  1019,
       0,     0,  1377,   559,   560,     0,     0,   195,   196,   197,
     198,  1378,   561,   562,   563,   564,   565,   566,     0,   567,
    1379,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1380,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,  1381,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,  1382,
     608,   215,   609,   610,   217,   611,  1383,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,  1384,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,
     634,   635,   636,   637,   638,     0,  1390,   639,   640,   641,
     642,  1391,     0,   643,   644,   645,   646,   647,  1392,  2638,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,
    1397,  1398,  1399,   658,   659,   660,     0,     0,     0,    55,
      56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,
       0,  1404,  1405,  2639,     0,     0,     0,     0,     0,     0,
    1407,  2640,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,  1373,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
    1390,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  1404,  1405,     0,     0,     0,
       0,     0,     0,     0,  1407,  2548,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1715,   137,  1716,  1717,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1718,  1719,   439,     0,   440,   441,
     442,   443,     0,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,  1720,  1721,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,     0,   489,   490,     0,     0,   491,     0,   492,  1722,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,     0,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,  2207,   508,   509,   510,   511,
     512,   513,     0,   172,  2208,     0,   514,   515,   516,  1365,
    1723,     0,  1724,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,     0,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1725,   188,  1726,     0,   543,   544,   545,   546,   547,   548,
     549,     0,   550,     0,   551,   552,   192,   553,     0,     0,
     554,  1727,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,  2209,   196,   197,   198,     0,
     561,   562,   563,   564,   565,   566,     0,   567,     0,   568,
       0,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1728,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,     0,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,  2210,
     609,   610,   217,   611,  1730,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,     0,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1731,  1732,
       0,     0,   631,     0,   632,     0,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,     0,  1733,  2211,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,     0,     0,     0,     0,     0,     0,     0,
       0,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  2212,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1715,   137,  1716,  1717,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1718,  1719,   439,     0,   440,   441,
     442,   443,     0,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,  1720,  1721,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,     0,   489,   490,     0,     0,   491,     0,   492,  1722,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,     0,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,  2207,   508,   509,   510,   511,
     512,   513,     0,   172,  2208,     0,   514,   515,   516,  1365,
    1723,     0,  1724,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,     0,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1725,   188,  1726,     0,   543,   544,   545,   546,   547,   548,
     549,     0,   550,     0,   551,   552,   192,   553,     0,     0,
     554,  1727,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,  2209,   196,   197,   198,     0,
     561,   562,   563,   564,   565,   566,     0,   567,     0,   568,
       0,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1728,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,     0,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,  2210,
     609,   610,   217,   611,  1730,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,     0,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1731,  1732,
       0,     0,   631,     0,   632,     0,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,     0,  1733,  2211,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,     0,     0,     0,     0,     0,     0,     0,
       0,   658,   659,   660,     0,     0,     0,    55,     0,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,  2961,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,  4060,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     694,    86,    87,    88,   400,    90,    91,    92,   401, -1565,
     402,    95,     0, -1565,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,  2558,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
    2559,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
    2560,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,  2561,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
    1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,   213,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,   221,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,  1390,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,  1970,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,   235,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  1404,  1405,     0,     0,
       0,     0,     0,     0,     0,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
     182,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,  1373,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,   217,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,  1390,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,
    1405,     0,     0,     0,     0,     0,  1916,  2507,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,   182,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,  1373,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,   217,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,  1406,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,  1488,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,  1373,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
    1390,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  1404,  1405,     0,     0,     0,
       0,     0,     0,     0,  1407,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2105,
     422,   423,   424,     0,     0,     0,     0,  1341,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1342,
     137,  1343,  1344,     0,   431,   432,   433,   434,   435,  1345,
    1346,   436,   437,  1347,  1348,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,  1357,  1358,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
    1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,  1365,  1366,
       0,  1367,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1371,
     188,  1372,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,  1373,   551,   552,   192,   553,  1374,  1375,   554,
    1376,   555,   556,     0,     0,   557,  1019,     0,     0,  1377,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1380,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,  1381,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,  1383,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1385,  1386,     0,
       0,   631,  1387,   632,  1388,  1389,   633,   634,   635,   636,
     637,   638,     0,  1390,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,   647,  1392,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,    56,    57,  1400,
    1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,
       0,     0,     0,     0,     0,     0,     0,  1407,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1341,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1342,   137,  1343,  1344,     0,   431,   432,   433,
     434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,
     440,   441,   442,   443,  1349,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,  2999,  1350,  1351,  1352,
    1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,   465,
    1357,  1358,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,  1360,   489,   490,  1361,  1362,   491,     0,
     492,  1363,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,  1364,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,  1365,  1366,     0,  1367,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,  1368,
     181,   526,   182,     0,   527,   528,   529,  1369,  1370,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1371,   188,  1372,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,  1373,   551,   552,   192,   553,
    1374,  1375,   554,  1376,   555,   556,     0,     0,   557,  1019,
       0,     0,  1377,   559,   560,     0,     0,   195,   196,   197,
     198,  1378,   561,   562,   563,   564,   565,   566,     0,   567,
    1379,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1380,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,  1381,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,  1382,
     608,   215,   609,   610,   217,   611,  1383,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,  1384,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,
     634,   635,   636,   637,   638,     0,  1390,   639,   640,   641,
     642,  1391,     0,   643,   644,   645,   646,   647,  1392,     0,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,
    1397,  1398,  1399,   658,   659,   660,     0,     0,     0,    55,
      56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,
       0,  1404,  1405,     0,     0,     0,     0,     0,     0,     0,
    1407,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1341,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1342,   137,  1343,  1344,     0,
     431,   432,   433,   434,   435,  1345,  1346,   436,   437,  1347,
    1348,   439,     0,   440,   441,   442,   443,  1349,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
    1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,
     463,   464,   465,  1357,  1358,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1359,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,  1360,   489,   490,  1361,
    1362,   491,     0,   492,  1363,   493,     0,   494,     0,   495,
     167,  2559,   168,   496,   497,     0,   498,  1364,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,  1365,  1366,     0,  1367,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,  1368,   181,   526,   182,     0,   527,   528,   529,
    1369,  1370,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1371,   188,  1372,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,  1373,   551,
     552,   192,   553,  1374,  1375,   554,  1376,   555,   556,     0,
       0,   557,  1019,     0,     0,  1377,   559,   560,     0,     0,
     195,   196,   197,   198,  1378,   561,   562,   563,   564,   565,
     566,     0,   567,  1379,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,  1380,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,  1381,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,  1382,   608,   215,   609,   610,   217,   611,  1383,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,  1384,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1385,  1386,     0,     0,   631,  1387,   632,
    1388,  1389,   633,   634,   635,   636,   637,   638,     0,  1390,
     639,   640,   641,   642,  1391,     0,   643,   644,   645,   646,
     647,  1392,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,  1393,
    1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,
       0,     0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,
       0,     0,     0,     0,  1404,  1405,     0,     0,     0,     0,
       0,     0,     0,  1407,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,  1341,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1342,   137,
    1343,  1344,     0,   431,   432,   433,   434,   435,  1345,  1346,
     436,   437,  1347,  1348,   439,     0,   440,   441,   442,   443,
    1349,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,
     460,   461,   462,   463,   464,   465,  1357,  1358,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1359,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,  1360,
     489,   490,  1361,  1362,   491,     0,   492,  1363,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
    1364,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,  1365,  1366,     0,
    1367,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,  1368,   181,   526,   182,     0,
     527,   528,   529,  1369,  1370,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1371,   188,
    1372,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,  1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,
     555,   556,     0,     0,   557,  1019,     0,     0,  1377,   559,
     560,     0,     0,   195,   196,   197,   198,  1378,   561,   562,
     563,   564,   565,   566,     0,   567,  1379,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
    1380,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,  1381,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,  1382,   608,   215,   609,   610,
     217,   611,  1383,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,  1384,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1385,  1386,     0,     0,
     631,  1387,   632,  1388,  1389,   633,   634,   635,   636,   637,
     638,     0,  1390,   639,   640,   641,   642,  1391,     0,   643,
     644,   645,   646,   647,  1392,  3571,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,
     659,   660,     0,     0,     0,    55,    56,    57,  1400,  1401,
    1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,     0,
       0,     0,     0,     0,     0,     0,  1407,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1341,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1342,   137,  1343,  1344,     0,   431,   432,   433,   434,
     435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,
     441,   442,   443,  1349,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,
    1354,  1355,  1356,   460,   461,   462,   463,   464,   465,  1357,
    1358,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,  1360,   489,   490,  1361,  1362,   491,     0,   492,
    1363,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,  1364,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
    1365,  1366,     0,  1367,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,  1368,   181,
     526,   182,     0,   527,   528,   529,  1369,  1370,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1371,   188,  1372,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,  1373,   551,   552,   192,   553,  1374,
    1375,   554,  1376,   555,   556,     0,     0,   557,  1019,     0,
       0,  1377,   559,   560,     0,     0,   195,   196,   197,   198,
    1378,   561,   562,   563,   564,   565,   566,     0,   567,  1379,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1380,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,  1381,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,  1382,   608,
     215,   609,   610,   217,   611,  1383,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,  1384,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1385,
    1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,   634,
     635,   636,   637,   638,     0,  1390,   639,   640,   641,   642,
    1391,     0,   643,   644,   645,   646,   647,  1392,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,
    1398,  1399,   658,   659,   660,     0,     0,     0,    55,    56,
      57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,
    1404,  1405,     0,     0,     0,     0,     0,     0,     0,  1407,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,     0,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,  3796,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,  3803,   545,   546,   547,   548,   549,   190,   550,
    1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,  1390,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  1404,  1405,     0,     0,
       0,     0,     0,     0,     0,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
     182,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,   217,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  2541,
    2542,     0,     0,     0,     0,     0,     0,     0,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,     0,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,     0,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,     0,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,     0,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,     0,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,     0,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,     0,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,     0,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,     0,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  2541,  2542,     0,     0,     0,
       0,     0,     0,     0,  1407,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
    1346,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,  1361,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
     188,   189,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,   192,   553,     0,  1375,   554,
     194,   555,   556,     0,     0,   557,  1019,     0,  1020,   558,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   213,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
     221,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,  1387,   632,  1388,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,  1970,   233,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,   235,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  2404,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,  1346,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
    1349,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,  1361,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
    1364,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,  1368,   181,   526,   182,     0,
     527,   528,   529,  1369,  1370,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,   188,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,   192,   553,     0,  1375,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,  1020,   558,   559,
     560,     0,     0,   195,   196,   197,   198,  1378,   561,   562,
     563,   564,   565,   566,     0,   567,  1379,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,  1382,   608,   215,   609,   610,
     217,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,  1384,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,  1387,   632,  1388,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,  1391,     0,   643,
     644,   645,   646,   647,   233,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,
     659,   660,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  2404,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,  1346,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,  1361,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,   192,   553,     0,  1375,   554,   194,   555,
     556,     0,     0,   557,  1019,     0,     0,   558,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
    1387,   632,  1388,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,   233,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  3937,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,     0,     0,     0,   150,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,   180,   181,   526,   182,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,   188,   189,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,   192,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,  1019,     0,     0,   558,   559,   560,     0,
       0,   195,   196,   197,   198,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,   217,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,  4003,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2981,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
   -1169,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0, -1169,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0, -1169,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518, -1169,   519,   520,   521,
     522,   523,   524,   525,     0,   180, -1169,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187, -1169,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593, -1169,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,  1496,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      57,     0,     0,     0,    58,     0,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,  3350,  3351,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    57,
       0,     0,     0,    58,     0,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  3351,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   213,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
     221,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,  1970,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,   235,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   244,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,   213,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,   221,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,  1970,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,   235,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   244,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
    1019,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,  1474,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,  2079,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,  3446,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  3566,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   701,   422,
     423,   424,   702,   703,   704,   705,   706,   707,   708,   425,
     426,   709,   427,   133,   428,   429,   430,   135,  1715,   137,
    1716,  1717,   710,   431,   432,   433,   434,   435,   711,   712,
     436,   437,  1718,  1719,   439,   714,   440,   441,   442,   443,
       0,   715,   716,   444,   445,   446,   447,   448,   449,   718,
     450,   451,   452,   453,   454,   455,   719,   456,   457,   458,
     149,   459,     0,   721,   722,   723,   150,   724,   725,   726,
     460,   461,   462,   463,   464,   465,  1720,  1721,   466,   727,
     467,   728,   468,   469,   470,   471,   472,   729,   473,   474,
     475,   730,   731,   476,   477,  1359,   479,   480,   732,   481,
     482,   483,   733,   484,   485,   734,   486,   487,   488,     0,
     489,   490,     0,   735,   491,   736,   492,  1722,   493,   737,
     494,   738,   495,   167,   739,   168,   496,   497,   740,   498,
       0,   741,   499,   742,   500,   501,   502,   503,   504,   171,
     505,   506,   507,   743,   508,   509,   510,   511,   512,   513,
     744,   172,     0,     0,   514,   515,   516,  1365,  1723,   747,
    1724,   748,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,   749,     0,   181,   526,   182,   750,
     527,   528,   529,   751,   752,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1725,   188,
    1726,   753,   543,   544,   545,   546,   547,   548,   549,     0,
     550,   754,   551,   552,   192,   553,   755,     0,   554,  1727,
     555,   556,   756,   757,   557,   758,   759,   760,  3337,   559,
     560,   761,   762,     0,   196,   197,   198,     0,   561,   562,
     563,   564,   565,   566,   763,   567,     0,   568,     0,   569,
     570,   571,   764,   572,   573,   574,   575,   576,   577,   578,
    1728,   579,   580,   581,   765,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   766,   592,   593,   209,   594,
     595,     0,   596,   597,   598,   599,   600,   601,   602,   603,
     767,   604,   605,   606,   607,   768,   608,  2210,   609,   610,
     217,   611,  1730,   769,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,     0,   622,   770,   623,   624,   771,
     625,   626,   627,   628,   629,   772,  1731,  1732,     0,   774,
     631,     0,   632,     0,   775,   633,   634,   635,   636,   637,
     638,     0,   777,   639,   640,   641,   642,   778,   779,   643,
     644,   645,   646,     0,  1733,   781,   648,   234,   649,   650,
     651,   782,   783,   652,   784,   785,   653,   654,   655,   656,
     657,     0,     0,     0,     0,     0,     0,     0,     0,   658,
     659,   660,     0,     0,     0,    55,    56,    57,     0,     0,
    1136,    58,     0,  1137,  1138,  1139,     0,  3338,  3339,  1142,
    1143,  1144,  1145,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,  1134,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,  1135,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,     0,     0,     0,  1136,     0,
       0,  1137,  1138,  1139,     0,  1140,  1141,  1142,  1143,  1144,
    1145,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,  1210,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
    1211,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,     0,     0,     0,     0,  1136,     0,     0,  1137,
    1138,  1139,     0,  1140,  1141,  1142,  1143,  1144,  1145,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,  1256,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,  1257,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1258,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,     0,     0,     0,  1136,     0,     0,  1137,  1138,  1139,
       0,  1140,  1141,  1142,  1143,  1144,  1145,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,  1698,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,  1699,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,  1136,     0,     0,  1137,  1138,  1139,     0,  1140,
    1141,  1142,  1143,  1144,  1145,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,     0,     0,     0,
    1136,     0,     0,  1137,  1138,  1139,     0,  1140,  1141,  1142,
    1143,  1144,  1145,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   701,   422,   423,
     424,   702,   703,   704,   705,   706,   707,   708,   425,   426,
     709,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   710,   431,   432,   433,   434,   435,   711,   712,   436,
     437,   713,   140,   439,   714,   440,   441,   442,   443,   144,
     715,   716,   444,   445,   446,   447,   448,   717,   718,   450,
     451,   452,   453,   454,   455,   719,   456,   457,   458,   149,
     459,   720,   721,   722,   723,   150,   724,   725,   726,   460,
     461,   462,   463,   464,   465,   153,   154,   466,   727,   467,
     728,   468,   469,   470,   471,   472,   729,   473,   474,   475,
     730,   731,   476,   477,   478,   479,   480,   732,   481,   482,
     483,   733,   484,   485,   734,   486,   487,   488,   162,   489,
     490,   164,   735,   491,   736,   492,   166,   493,   737,   494,
     738,   495,   167,   739,   168,   496,   497,   740,   498,   170,
     741,   499,   742,   500,   501,   502,   503,   504,   171,   505,
     506,   507,   743,   508,   509,   510,   511,   512,   513,   744,
     172,   173,   745,   514,   515,   516,   746,   175,   747,   176,
     748,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,   749,   180,   181,   526,   182,   750,   527,
     528,   529,   751,   752,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
     753,   543,   544,   545,   546,   547,   548,   549,   190,   550,
     754,   551,   552,   192,   553,   755,   193,   554,   194,   555,
     556,   756,   757,   557,   758,   759,   760,   558,   559,   560,
     761,   762,   195,   196,   197,   198,   199,   561,   562,   563,
     564,   565,   566,   763,   567,   200,   568,   201,   569,   570,
     571,   764,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,   765,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   766,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,   767,
     604,   605,   606,   607,   768,   608,   215,   609,   610,   217,
     611,   218,   769,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,   770,   623,   624,   771,   625,
     626,   627,   628,   629,   772,   222,   223,   773,   774,   631,
     224,   632,   225,   775,   633,   634,   635,   636,   637,   638,
     776,   777,   639,   640,   641,   642,   778,   779,   643,   644,
     645,   646,   780,   233,   781,   648,   234,   649,   650,   651,
     782,   783,   652,   784,   785,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,  2070,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,     0,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,  1729,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,     0,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
    2165,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,  1029,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,  2053,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,  2054,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,  2055,     0,   557,
       0,  2056,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,  2057,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,     0,     0,
       0,     0,   938,  1533,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,  2063,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,  2054,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,  2055,     0,   557,     0,  2056,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,  2057,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    56,    57,     0,     0,     0,
      58,     0,     0,     0,     0,     0,   938,  1533,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,  2054,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,  2055,     0,   557,     0,  2056,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,  2057,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    56,
      57,     0,     0,     0,    58,     0,     0,     0,     0,     0,
     938,  1533,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   927,   416,
     417,   418,   419,   420,   421,   928,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   929,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   930,   166,   493,     0,   494,     0,   931,
       0,   932,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
     933,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   934,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   935,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     936,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   937,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,   938,   939,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,     0,     0,     0,     0,
      41,   414,   927,   416,   417,   418,   419,   420,   421,   928,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   929,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   930,   166,   493,
       0,   494,     0,   931,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   934,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   935,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   936,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   937,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,   938,   939,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,   682,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,  1444,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,  1445,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,  1403,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  4198,     0,    58,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,   630,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    57,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,  1089,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    57,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    57,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,  2039,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    57,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,    57,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1839,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
     997,    57,    86,    87,    88,   400,    90,    91,    92,   401,
     998,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   999,   437,   974,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,  1000,     0,  1001,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,  1002,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,  1003,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,  1004,   595,   211,   596,
     597,   598,  1005,   600,   601,   602,   603,     0,   604,   605,
     606,  1006,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1007,   223,     0,     0,  1008,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     978,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,  1009,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   701,   422,   423,
     424,   702,   703,   704,   705,   706,   707,   708,   425,   426,
     709,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   710,   431,   432,   433,   434,   435,   711,   712,   436,
     437,   713,   140,   439,   714,   440,   441,   442,   443,   144,
     715,   716,   444,   445,   446,   447,   448,   717,   718,   450,
     451,   452,   453,   454,   455,   719,   456,   457,   458,   149,
     459,   720,   721,   722,   723,   150,   724,   725,   726,   460,
     461,   462,   463,   464,   465,   153,   154,   466,   727,   467,
     728,   468,   469,   470,   471,   472,   729,   473,   474,   475,
     730,   731,   476,   477,   478,   479,   480,   732,   481,   482,
     483,   733,   484,   485,   734,   486,   487,   488,   162,   489,
     490,   164,   735,   491,   736,   492,   166,   493,   737,   494,
     738,   495,   167,   739,   168,   496,   497,   740,   498,   170,
     741,   499,   742,   500,   501,   502,   503,   504,   171,   505,
     506,   507,   743,   508,   509,   510,   511,   512,   513,   744,
     172,   173,   745,   514,   515,   516,   746,   175,   747,   176,
     748,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,   749,   180,   181,   526,   182,   750,   527,
     528,   529,   751,   752,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,   188,   189,
     753,   543,   544,   545,   546,   547,   548,   549,   190,   550,
     754,   551,   552,   192,   553,   755,   193,   554,   194,   555,
     556,   756,   757,   557,   758,   759,   760,   558,   559,   560,
     761,   762,   195,   196,   197,   198,   199,   561,   562,   563,
     564,   565,   566,   763,   567,   200,   568,   201,   569,   570,
     571,   764,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,   765,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   766,   592,   593,   209,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,   767,
     604,   605,   606,   607,   768,   608,   215,   609,   610,   217,
     611,   218,   769,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,   770,   623,   624,   771,   625,
     626,   627,   628,   629,   772,   222,   223,   773,   774,   631,
     224,   632,   225,   775,   633,   634,   635,   636,   637,   638,
     776,   777,   639,   640,   641,   642,   778,   779,   643,   644,
     645,   646,   780,   233,   781,   648,   234,   649,   650,   651,
     782,   783,   652,   784,   785,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,  2831,   419,   420,   421,   701,
     422,   423,   424,   702,   703,   704,   705,   706,   707,   708,
     425,   426,   709,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,   710,   431,   432,   433,   434,   435,   711,
     712,   436,   437,   713,   140,   439,   714,   440,   441,   442,
     443,   144,   715,   716,   444,   445,   446,   447,   448,   717,
     718,   450,   451,   452,   453,   454,   455,   719,   456,   457,
     458,   149,   459,   720,   721,   722,   723,   150,   724,   725,
     726,   460,   461,   462,   463,   464,   465,   153,   154,   466,
     727,   467,   728,   468,   469,   470,   471,   472,   729,   473,
     474,   475,   730,   731,   476,   477,   478,  2832,   480,   732,
     481,   482,   483,   733,   484,   485,   734,   486,   487,   488,
     162,   489,   490,   164,   735,   491,   736,   492,   166,   493,
     737,   494,   738,   495,   167,   739,   168,   496,   497,   740,
     498,   170,   741,   499,   742,   500,   501,   502,   503,   504,
     171,   505,   506,   507,   743,   508,   509,   510,   511,   512,
     513,   744,   172,   173,   745,   514,   515,   516,   746,   175,
     747,   176,   748,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,   749,   180,   181,   526,   182,
     750,   527,   528,   529,   751,   752,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
     188,   189,   753,   543,   544,   545,   546,   547,   548,   549,
     190,   550,   754,   551,   552,   192,   553,   755,   193,   554,
     194,   555,   556,   756,   757,   557,   758,   759,   760,   558,
     559,   560,   761,   762,   195,   196,   197,   198,   199,   561,
     562,   563,   564,   565,   566,   763,   567,   200,   568,   201,
     569,   570,   571,   764,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,   765,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   766,   592,   593,   209,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,   767,   604,   605,   606,   607,   768,  2833,   215,   609,
     610,   217,   611,   218,   769,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,   770,   623,   624,
     771,   625,   626,   627,   628,   629,   772,   222,   223,   773,
     774,   631,   224,   632,   225,   775,   633,   634,   635,   636,
     637,   638,   776,   777,   639,   640,   641,   642,   778,   779,
     643,   644,   645,   646,   780,   233,   781,   648,   234,   649,
     650,   651,   782,   783,   652,   784,   785,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,   180,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,   188,   189,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,   192,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,  1019,     0,
       0,   558,   559,   560,     0,     0,   195,   196,   197,   198,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,   217,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,     0,     0,
       0,   150,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1243,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
     180,   181,   526,   182,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,   188,   189,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
    1019,     0,     0,   558,   559,   560,     0,     0,   195,   196,
     197,   198,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,   217,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
       0,     0,     0,   150,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1251,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,   180,   181,   526,   182,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,   188,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,   192,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,     0,   558,   559,   560,     0,     0,
     195,   196,   197,   198,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,   217,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,  2207,   508,   509,   510,   511,   512,   513,     0,
     172,  2208,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,  2209,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2210,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,  2211,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,  2199,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,  2210,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
    3423,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1715,   137,  1716,  1717,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,  1718,  1719,   439,     0,   440,
     441,   442,   443,     0,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,  1720,
    1721,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,     0,   489,   490,     0,     0,   491,     0,   492,
    1722,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,     0,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,     0,     0,   514,   515,   516,
    1365,  1723,     0,  1724,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,     0,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1725,   188,  1726,     0,   543,   544,   545,   546,   547,
     548,   549,  2248,   550,     0,   551,   552,   192,   553,     0,
       0,   554,  1727,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,     0,   196,   197,   198,
       0,   561,   562,   563,   564,   565,   566,     0,   567,     0,
     568,     0,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1728,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,     0,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
    1729,   609,   610,   217,   611,  1730,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,     0,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1731,
    1732,     0,     0,   631,     0,   632,     0,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,     0,  1733,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,     0,     0,     0,     0,     0,     0,
       0,     0,   658,   659,   660,     0,     0,     0,    55,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1715,   137,  1716,  1717,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,  1718,  1719,   439,
       0,   440,   441,   442,   443,     0,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,     0,     0,
       0,   150,     0,     0,     0,   460,   461,   462,   463,   464,
     465,  1720,  1721,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,     0,   489,   490,     0,     0,   491,
       0,   492,  1722,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,     0,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,     0,     0,   514,
     515,   516,  1365,  1723,     0,  1724,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
       0,   181,   526,   182,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1725,   188,  1726,     0,   543,   544,   545,
     546,   547,   548,   549,  3273,   550,     0,   551,   552,   192,
     553,     0,     0,   554,  1727,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,     0,   196,
     197,   198,     0,   561,   562,   563,   564,   565,   566,     0,
     567,     0,   568,     0,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1728,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,     0,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,  1729,   609,   610,   217,   611,  1730,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,     0,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1731,  1732,     0,     0,   631,     0,   632,     0,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,     0,  1733,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,     0,     0,     0,     0,
       0,     0,     0,     0,   658,   659,   660,     0,     0,     0,
      55,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1715,   137,  1716,  1717,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,  1718,
    1719,   439,     0,   440,   441,   442,   443,     0,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
       0,     0,     0,   150,     0,     0,     0,   460,   461,   462,
     463,   464,   465,  1720,  1721,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1359,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,     0,   489,   490,     0,
       0,   491,     0,   492,  1722,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,     0,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,     0,
       0,   514,   515,   516,  1365,  1723,     0,  1724,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,     0,   181,   526,   182,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1725,   188,  1726,     0,   543,
     544,   545,   546,   547,   548,   549,     0,   550,     0,   551,
     552,   192,   553,     0,     0,   554,  1727,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
       0,   196,   197,   198,     0,   561,   562,   563,   564,   565,
     566,     0,   567,     0,   568,     0,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,  1728,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,     0,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,  1729,   609,   610,   217,   611,  1730,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,     0,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1731,  1732,     0,     0,   631,     0,   632,
       0,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
       0,  1733,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,     0,     0,
       0,     0,     0,     0,     0,     0,   658,   659,   660,     0,
       0,     0,    55,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,     0,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,     0,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2210,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1715,
     137,  1716,  1717,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1718,  1719,   439,     0,   440,   441,   442,
     443,     0,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,     0,     0,     0,   150,     0,     0,
       0,   460,   461,   462,   463,   464,   465,  1720,  1721,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
       0,   489,   490,     0,     0,   491,     0,   492,  1722,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,     0,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,     0,     0,   514,   515,   516,  1365,  1723,
       0,  1724,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,     0,   181,   526,   182,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1725,
     188,  1726,     0,   543,   544,   545,   546,   547,   548,   549,
       0,   550,     0,   551,   552,   192,   553,     0,     0,   554,
    1727,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,     0,   196,   197,   198,     0,   561,
     562,   563,   564,   565,   566,     0,   567,     0,   568,     0,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1728,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,     0,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,     0,   609,
     610,   217,   611,  1730,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,     0,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1731,  1732,     0,
       0,   631,     0,   632,     0,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,     0,  1733,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,     0,     0,     0,     0,     0,     0,     0,     0,
     658,   659,   660,     0,     0,     0,    55,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,     0,   137,     0,     0,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,     0,   439,     0,   440,
     441,   442,   443,     0,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,     0,     0,     0,   150,
       0,     0,     0,   460,   461,   462,   463,   464,   465,     0,
       0,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,     0,   489,   490,     0,     0,   491,     0,   492,
       0,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,     0,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,     0,     0,   514,   515,   516,
       0,     0,     0,     0,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,     0,   181,
     526,   182,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,     0,   188,     0,     0,   543,   544,   545,   546,   547,
     548,   549,     0,   550,     0,   551,   552,   192,   553,     0,
       0,   554,     0,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,     0,   196,   197,   198,
       0,   561,   562,   563,   564,   565,   566,     0,   567,     0,
     568,     0,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,     0,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,     0,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
       0,   609,   610,   217,   611,     0,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,     0,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,     0,
       0,     0,     0,   631,     0,   632,     0,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,     0,     0,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,     0,     0,     0,     0,     0,     0,
       0,     0,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   701,   422,   423,   424,   702,   703,   704,   705,
     706,   707,   708,   425,   426,   709,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,   710,   431,   432,   433,
     434,   435,   711,   712,   436,   437,     0,   140,   439,   714,
     440,   441,   442,   443,   144,   715,   716,   444,   445,   446,
     447,   448,   717,   718,   450,   451,   452,   453,   454,   455,
     719,   456,   457,   458,   149,   459,     0,   721,   722,   723,
     150,   724,   725,   726,   460,   461,   462,   463,     0,   465,
     153,   154,   466,   727,   467,   728,   468,   469,   470,   471,
     472,   729,   473,   474,   475,   730,   731,   476,   477,   478,
     479,   480,   732,   481,   482,   483,   733,   484,   485,   734,
     486,   487,   488,   162,   489,   490,   164,   735,   491,   736,
     492,   166,   493,   737,   494,   738,   495,   167,   739,   168,
     496,   497,   740,   498,   170,   741,   499,   742,   500,   501,
       0,   503,   504,   171,   505,   506,   507,   743,   508,   509,
     510,   511,   512,   513,   744,   172,   173,     0,   514,   515,
     516,     0,   175,   747,   176,   748,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,   749,   180,
     181,   526,   182,   750,   527,   528,   529,   751,   752,   530,
     531,   532,   533,   534,   535,     0,   537,   538,     0,   540,
     541,   542,   187,   188,   189,   753,   543,   544,   545,   546,
     547,   548,   549,   190,   550,   754,   551,   552,   192,   553,
     755,   193,   554,   194,   555,   556,   756,   757,   557,   758,
     759,   760,   558,   559,   560,   761,   762,   195,   196,   197,
     198,   199,   561,   562,   563,   564,   565,   566,   763,   567,
     200,   568,   201,   569,   570,   571,   764,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,   765,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   766,
     592,   593,   209,   594,   595,   211,   596,   597,   598,   599,
     600,   601,     0,   603,   767,   604,   605,   606,   607,   768,
     608,   215,   609,   610,   217,   611,   218,   769,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
     770,   623,   624,   771,   625,   626,   627,   628,   629,   772,
     222,   223,     0,   774,   631,   224,   632,   225,   775,   633,
     634,   635,   636,   637,   638,     0,   777,   639,   640,   641,
     642,   778,   779,   643,   644,   645,   646,     0,   233,   781,
     648,   234,   649,   650,   651,   782,   783,   652,   784,   785,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,     0,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
    2179,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,  2180,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,  2181,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,  2943,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,  2182,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,  2183,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   987,   420,   421,   946,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,   947,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,   988,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
     948,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,   949,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   680,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,   681,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,   682,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   946,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,   947,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,   948,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   949,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,  1878,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
    1879,   495,     0,     0,     0,  1880,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,  1881,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,  1019,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,  1882,   600,   601,   602,   603,     0,
    1883,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,  1884,  1885,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,  2625,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,  2626,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,  2627,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,  2628,
     625,  2629,   627,  2630,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,   130,   131,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,  1019,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,   880,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
     881,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   882,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,  1019,     0,
    1020,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,  1447,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,  1019,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,   947,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,   948,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,   949,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,   682,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  1238,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,   932,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,   933,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,  2289,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,  2290,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2768,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,  2769,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
    2778,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,  2779,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,   689,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   833,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   923,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   963,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,  1791,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,  2981,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,  2994,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,  3031,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,  3695,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,  3697,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,  3699,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,  4060,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   886,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   971,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   973,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   974,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,     0,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   975,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   976,   223,     0,     0,   977,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   978,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,  1012,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   974,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,     0,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,  1013,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1014,   223,     0,     0,
    1015,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   978,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,  1037,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
    1159,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,  1222,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1248,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1253,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,  1261,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1263,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,  1265,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,  1267,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,  1270,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,  1272,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,  1273,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
    1276,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,  1460,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   999,   437,   974,   140,  1461,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,     0,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
    1003,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,  1004,   595,   211,   596,   597,   598,  1005,   600,
     601,   602,   603,     0,   604,   605,   606,  1451,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1007,
     223,     0,     0,  1008,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   978,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,  1009,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,  1483,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
       0,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
    1573,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,  1786,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1817,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,  1819,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,  1913,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,  2420,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   999,   437,   974,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,     0,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,  1003,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
    1004,   595,   211,   596,   597,   598,  1005,   600,   601,   602,
     603,     0,   604,   605,   606,  1451,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1007,   223,     0,
       0,  1008,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   978,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,  1009,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   999,   437,   974,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
       0,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,  1003,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,  1004,   595,   211,   596,   597,   598,  1005,   600,   601,
     602,   603,     0,   604,   605,   606,  1451,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,  2176,   626,   627,   628,   629,     0,  1007,   223,
       0,     0,  1008,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   978,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,  1009,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   999,   437,   974,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,     0,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
    1003,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,  1004,   595,   211,   596,   597,   598,  2203,   600,
     601,   602,   603,     0,   604,   605,   606,  1451,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1007,
     223,     0,     0,  1008,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   978,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,  1009,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,     0,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,     0,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,     0,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,    86,    87,    88,    55,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2054,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,     0,    35,     0,   394,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,   154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     162,     0,     0,   164,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,   167,     0,   168,     0,     0,     0,
       0,   170,     0,     0,     0,     0,     0,     0,     0,     0,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   172,   173,     0,     0,     0,     0,     0,   175,
       0,   176,     0,     0,   177,   178,     0,   179,     0,     0,
       0,     0,     0,     0,     0,     0,   180,   181,     0,   182,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,   189,     0,     0,     0,     0,     0,     0,     0,     0,
     190,     0,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   195,   196,   197,   198,   199,     0,
       0,     0,     0,     0,     0,     0,     0,   200,     0,   201,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   209,
       0,     0,   211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,   217,     0,   218,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,   223,     0,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,    86,    87,    88,    55,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2055,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,     0,    35,
       0,  1083,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
      86,    87,    88,    55,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,   154,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   162,     0,     0,   164,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   172,   173,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,   196,
     197,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,   217,     0,   218,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,   223,     0,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
       0,     0,   234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,    86,    87,    88,
      55,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   154,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   160,     0,     0,     0,     0,
       0,   162,     0,     0,   164,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   167,     0,   168,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   172,   173,     0,     0,     0,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,   190,     0,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   195,   196,   197,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     209,     0,     0,   211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,   217,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,   223,
       0,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,     0,     0,     0,    86,    87,    88,    55,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     0,     0,
       0,     0,     0,     0,    55
};

static const yytype_int16 yycheck[] =
{
       2,  1052,   244,   816,  1097,   165,   117,   948,   949,     2,
     854,  1052,   953,   152,  1259,  1054,   151,  1252,  1309,   117,
    1150,  1001,  1629,  1841,   148,  1221,   186,     2,  1745,   226,
    1160,    78,  1880,    78,  1323,  1167,   117,  1126,  2215,    84,
    1729,   854,  1357,  1358,  1802,  1848,  1004,   169,    78,   160,
    1386,    78,    78,  1336,   362,   692,   208,   362,  1949,   903,
    1016,  1376,   160,   202,   221,  2215,  2216,  1662,  1008,  2028,
    2502,  1479,  1202,   230,  1778,  1198,   132,  1207,  1022,   160,
    2969,  1527,  1528,  1529,  1214,  2678,   208,    89,  2640,  1764,
     903,  1764,  2831,  1223,  2833,   334,  1916,  2404,  1097,  1613,
    1764,  2079,    78,  1764,  2476,    78,  2894,  1764,  1764,  2409,
    2410,    84,  2922,   214,  3206,  2247,  2415,   228,   348,  2010,
    1656,  1244,   158,  3424,  1582,  1229,    94,  2088,  1291,  1282,
     228,  3396,    30,  1837,  2922,  2085,  1130,  2124,    89,    21,
    1347,  1348,   348,  1077,  1092,  1093,  1049,   228,  1049,   151,
      10,  3102,  1097,    98,    73,    71,  3376,   220,    72,    73,
      73,   110,    71,   920,   132,  1372,    80,  3899,   234,  1577,
      72,   147,  1116,  2160,   143,   170,    89,  2164,    80,    84,
      73,   124,   184,   151,   117,    73,   802,   103,    73,    37,
     165,   194,   136,   215,  2908,  2909,  2910,  2911,  2912,  2913,
      71,    89,   215,    89,    76,    77,    78,    79,   175,   189,
      96,   186,   169,  1290,   165,   215,  2348,   252,    29,  3728,
     117,    76,    77,    78,    79,    73,    83,   163,    76,    77,
      78,    79,   103,   153,   117,   186,   252,    76,    77,    78,
      79,   252,   133,   880,  3446,   198,  3448,    71,   126,    78,
     215,    76,    77,    78,    79,  1196,   187,    76,    77,    78,
      79,  2541,  2542,  1980,   315,   345,  2546,   102,   244,   124,
      73,   314,    76,    77,    78,    79,   361,    78,   210,    71,
     126,   209,    76,    77,    78,    79,   102,   133,    76,    77,
      78,    79,   118,   252,   140,  2427,   217,  2429,   170,   124,
     126,   350,  3891,   147,   901,  2585,  2586,   354,   905,   173,
     252,   103,   108,   419,    73,   294,    85,  1275,   915,   374,
      76,    77,    78,    79,   354,   389,   419,   354,   354,   174,
    1407,   170,  1464,   330,   212,  1291,  3079,    71,  1182,   252,
     389,   198,  4180,   484,  2331,   197,  1302,  1303,   495,    89,
     497,   396,    38,    78,    40,    25,    96,   153,   499,    84,
    3103,   998,   359,     0,   252,    35,   212,   231,   423,  1182,
     117,   456,   348,   437,  3594,   219,   215,    71,   354,    76,
      77,    78,    79,   235,    76,    77,    78,    79,   437,   362,
     117,   484,   117,    14,   500,   364,  1732,  4235,   319,   177,
      89,    76,    77,    78,    79,  1720,  1721,    96,   253,   103,
     338,  3920,  1727,   160,   108,   500,    73,   497,   187,    76,
      77,    78,    79,   396,    25,    76,    77,    78,    79,   361,
    4019,   399,   365,   244,   500,   160,   389,   500,    76,    77,
      78,    79,    76,    77,    78,    79,   497,   273,   384,    76,
      77,    78,    79,   123,  3264,  1700,   387,   500,   808,    89,
     207,  1696,   254,   813,   421,   343,   501,   214,   365,   216,
     437,  1427,   452,    71,   117,   497,  3264,    76,    77,    78,
      79,   228,   365,   499,  4216,  1429,   430,   500,  3708,   484,
     501,   396,   471,   843,   497,   630,   804,   343,  1114,   804,
     500,   458,  1460,   228,    76,    77,    78,    79,   394,   429,
      92,  1718,  1719,  1469,  1470,   372,  1712,   160,  3232,  1726,
     254,  2210,  1652,  1280,  1654,   354,    73,  3747,   419,  1463,
    2480,   500,   389,  1467,  1468,   500,    76,    77,    78,    79,
     234,  3492,   501,   893,    76,    77,    78,    79,   497,    71,
     900,   307,   497,   354,   497,   433,  1688,   439,   443,   501,
     254,   255,   476,   482,   207,  3767,  1974,   500,   482,   482,
    1693,   214,   407,   216,   476,   488,   489,   493,   248,  1709,
     419,   103,  1873,   443,   493,   228,  1690,   433,   501,   482,
     359,   407,   447,  1541,   482,   488,   489,   495,  2193,  1544,
     488,   489,    71,   500,   497,  2755,   478,  2757,  2016,   491,
    1513,   305,  1513,   501,  2022,  3167,   302,   500,  1612,   490,
     491,   492,   493,   478,  2574,   319,   294,  3847,   630,   477,
     478,   479,   480,   429,   482,   172,   234,   362,   365,   478,
     488,   489,   497,   447,  3358,   484,  2404,   248,  3913,   217,
    2541,  2542,    71,   478,   394,  2546,   254,    14,  1747,   478,
     499,   439,   630,  1260,  1598,   822,   490,   491,   492,   493,
    1604,   396,   497,  2660,   478,   810,   495,  2984,   497,   482,
     499,  2988,  1786,   252,   478,   488,   489,   926,  2647,   800,
     478,  1854,  1845,   497,  2585,  2586,   488,   489,   490,   491,
     492,   493,   800,   497,  2665,   394,   336,   222,   318,   497,
    1644,   252,   847,  1647,  1648,  2173,    25,  1314,   477,   800,
     170,   319,   478,   482,   692,   400,   401,   353,  1325,   488,
     489,   888,   254,   255,  1941,  1942,   252,   117,   198,   215,
    1337,  2873,  2874,   882,  2894,   170,   108,    76,    77,    78,
      79,   256,   312,   940,   488,   489,   490,   491,   492,   493,
     457,    97,   897,  1697,  4065,   254,   252,   927,   165,   929,
     307,   931,  2922,   960,   442,   130,  4067,   937,   475,    90,
     362,   478,   412,   305,   414,   254,   478,   481,    76,    77,
      78,    79,   374,  1637,   488,   489,   490,   491,   492,   493,
     497,   837,   959,   478,  3084,   497,   374,  3087,  3088,  3089,
    3090,  3091,  3092,  3093,  3094,  3095,  3096,  2967,   172,   457,
     477,   478,  1172,   256,  1637,   482,  1784,   478,   317,  1179,
     227,   804,   489,   869,   170,   254,   838,   475,  1915,  1916,
     478,   423,  1783,   163,   478,   350,   497,    85,  2384,  1926,
     460,   478,  1929,    91,   170,   370,    85,   307,  3747,   497,
    1937,  1938,   175,   497,  3144,  3145,   170,   101,   230,  1026,
     497,   497,   234,  1950,  1951,   448,  2634,   302,   312,   478,
    1230,  4172,   170,   481,  1961,   282,   484,   485,   486,   173,
     488,   489,   490,   491,   492,   493,  1852,  1494,   497,   110,
     319,  1002,  3201,  1883,  1884,  1006,   478,   269,  3941,   456,
    1866,   165,   880,  4133,   294,  4206,   175,   350,   920,    76,
      77,    78,    79,   439,   110,   497,   227,   920,   187,   389,
     477,   500,   207,   246,  2651,   482,   247,   497,   478,   248,
    2017,   488,   489,   419,  1000,   920,   478,   231,   302,   187,
     161,   376,   927,   439,   929,   923,   931,   497,   187,   500,
     315,   963,   937,   938,   939,   497,   488,   489,   490,   491,
     492,   493,  3711,   227,   294,   161,   927,  1821,   929,   317,
     931,   282,   379,   456,    71,   365,   937,    87,   147,   991,
     175,    76,    77,    78,    79,   500,   216,   999,   302,   233,
    3351,  1003,  1004,  1005,   147,  3925,   106,   387,  1821,   282,
    3562,  3563,  3564,    76,    77,    78,    79,   215,   293,   488,
     489,   490,   491,   492,   493,  2340,   372,   500,   282,   391,
     998,   285,  1000,     8,   245,   217,    11,    12,   252,  4131,
    4132,    76,    77,    78,    79,  3855,   419,    22,    23,    24,
     174,    26,    27,   800,  1027,   321,    31,    32,    33,   245,
     219,   246,   481,   497,   330,   381,  2159,  3855,   381,   488,
     489,   490,   491,   492,   493,   800,   219,    89,   379,   804,
     140,   340,   138,   294,  1077,   182,  2282,   184,   410,  3369,
    1092,  1093,   330,  4126,   410,  1097,   809,   410,   811,   215,
     175,   330,  1077,  1947,  1097,   329,   379,  3479,   294,   141,
     170,  2067,   332,   826,  3264,  4207,    76,    77,    78,    79,
    4040,   359,  1097,   179,   437,   379,  1077,   500,   444,   253,
    3437,   444,    89,  3433,  1947,  3442,   849,   319,  3445,   171,
     456,  1092,  1093,   456,   372,   138,  1097,  2742,   484,   478,
     307,   497,   865,    76,    77,    78,    79,   800,   387,   495,
    2159,   497,   498,   499,   500,  1407,   377,   254,   497,   421,
     182,   246,   392,  2369,  2370,  2371,  2372,    76,    77,    78,
      79,   497,  3030,   449,   497,  2430,   179,  2422,   163,   142,
     478,   377,    71,  3084,   482,  1197,  3087,  3088,  3089,  3090,
    3091,  3092,  3093,  3094,  3095,  3096,   238,   366,  2142,   437,
     170,    76,    77,    78,    79,   312,   470,   412,  1815,   414,
     402,  3199,   307,   366,   103,   182,  2984,  1824,  4062,  4063,
    2988,   184,   319,    76,    77,    78,    79,   206,  3058,  1836,
    2754,   426,   302,   497,  4133,  1292,   421,   170,  1487,  2924,
    3843,  2924,   437,  3144,  3145,  1002,  3536,  3537,  2666,  1006,
    2924,  1569,  1292,  2924,  1569,  1292,  1292,  2924,  2924,   160,
    1317,  1501,  1502,  1275,  1504,   331,   282,  1279,  1280,   285,
    1282,  1878,  3414,   458,  1881,  1882,  1279,  1280,  1885,  1282,
     162,   326,  4031,  2416,    78,  1501,  1502,   456,  1504,    99,
      84,   270,  1027,   419,  1279,  1280,   381,  1282,    76,    77,
      78,    79,   287,   456,  3018,   196,  1292,    76,    77,    78,
      79,   478,    71,  3455,  2258,  3457,  3677,  3678,  3679,  3680,
    3681,   138,  2266,   117,  2268,   218,  4170,   228,   331,   498,
     164,  1317,   501,   172,    73,   314,  2953,    76,    77,    78,
      79,   116,  3848,  3785,  1322,   498,   330,   413,   501,  1002,
     173,   215,   437,  1006,   339,  1341,  1477,   239,   484,   250,
     374,   330,   179,   379,   497,   162,   160,   374,   178,  1477,
     234,   146,   216,   499,  1360,   359,   165,    22,  1444,  1445,
     273,   456,    71,   478,   481,   138,  1477,   484,   485,   486,
     359,   488,   489,   490,   491,   492,   493,  1409,  3904,   281,
    1521,   283,   241,   237,  1390,   478,    95,  1419,   231,   423,
     413,  1134,  1135,   207,  2322,   218,   423,   182,  1430,   184,
     214,  1407,   216,   330,  2511,   500,   179,   202,    73,  3991,
      85,  2732,   323,   478,   228,  2760,   196,  4048,   227,   501,
     126,    37,  1802,   428,  1804,  2901,   206,  3764,  1460,   294,
     210,  1463,   359,  1813,   140,  1467,  1468,   232,  2412,     5,
    1463,  1582,   376,   302,  1467,  1468,  1444,  1445,  3369,   500,
     273,  1194,  2559,  1539,  1582,  2443,   321,    73,  1463,    25,
     387,   501,  1467,  1468,   281,   330,   283,  1210,  1211,    35,
     250,  1582,  3998,   282,   456,   254,   285,   411,   302,   330,
    3790,  2588,  1463,   207,   503,  1228,  1467,  1468,   478,  4120,
     270,  2158,   216,   497,   331,  1501,  1502,  4128,  1504,   412,
    1880,   414,   330,   206,  3814,  3815,   212,   210,   359,  1541,
    1533,   342,   187,  1256,  1257,    41,  2623,   302,   500,  1522,
    1523,   432,   456,   457,   348,   478,  1531,   312,  1533,  2636,
    2637,   359,  1555,  1556,   314,   330,   387,   450,  4169,  3746,
     319,  1539,   206,   323,  1549,   254,   210,    78,   362,   478,
    1555,  1556,   412,    84,   414,   409,   410,   123,   331,  2997,
    1541,   217,   372,   497,   359,   141,  1569,   270,   363,   126,
     379,   216,   367,  1576,   147,  1598,   413,   442,   373,   342,
     139,  1604,   396,   478,  3573,   380,   117,   243,   398,   412,
     421,   414,   387,  1598,  2221,   171,   169,   242,   477,  1604,
     395,  3039,   175,   482,  1620,   478,   270,  1623,   403,  3356,
     319,   314,   257,   170,   349,  3536,  3537,  1598,  1759,  1891,
     186,  1644,   267,  1604,  1647,  1648,   199,   458,  1660,   160,
     248,  1759,   191,  2752,   133,   221,  1591,   343,   373,  1644,
     413,   140,  1647,  1648,   230,  1127,  1811,  1663,  1759,  3437,
     314,   457,   432,   165,  3442,   330,   451,  3445,   421,  3969,
     350,   470,   238,  1644,  1619,   128,  1647,  1648,  1150,   475,
     360,  2681,    51,   246,  1697,  3855,    16,   104,  1160,  2649,
     478,  3306,   248,   146,   359,   457,  3124,   163,  2652,   478,
      69,   497,  1697,   383,   151,   458,   159,   228,   125,   439,
    1477,  1855,   481,   475,   263,   264,   485,   486,  1895,   488,
     489,   490,   491,   492,   493,   227,  1697,   276,   477,   478,
     479,   480,  1477,   482,   369,   497,   376,   433,  1910,   488,
     489,  2605,   210,  1765,   378,   330,   210,   495,  3051,  2077,
    3106,  3107,  2077,   501,  1521,   302,   498,   210,  3910,   501,
     307,   229,  1784,  3586,   260,   229,   457,  1909,   163,   216,
     419,   411,  2605,  3943,   359,   170,  1521,  1522,  1523,    34,
     282,   330,   481,   285,   475,   484,   485,   486,   175,   488,
     489,   490,   491,   492,   493,   242,   343,  3534,   381,  1794,
    2457,   359,  1152,   497,  1154,   363,  1802,  1678,   355,   423,
     257,  1161,   382,   175,  1477,  1582,   456,   457,   381,  1586,
     267,   495,  3531,  1845,  1569,   163,  1848,   410,   502,   387,
     361,  1576,  1845,  3142,  1901,  1848,   498,  1582,   500,  1606,
     410,   362,  2675,   290,   495,   378,   497,   410,   499,  2466,
    1845,  1901,  1983,  1848,  1901,  1901,   495,   497,   330,   246,
     499,   444,   411,   330,   413,  1983,    93,    94,   182,  4066,
     184,   382,  1639,   456,   437,   396,   346,   379,   317,  3790,
     450,   444,  1983,   322,   246,  1756,   433,   359,   237,   381,
     204,  1762,   359,   456,   376,  1891,   363,   498,   456,   410,
     501,  2998,   359,  3814,  3815,  1901,   363,   302,  1779,  3327,
    3328,  3246,  1934,  3331,   497,  3333,   303,   304,   410,  1582,
     387,  2101,   369,  1586,  3235,  3236,   182,   500,   184,   411,
     387,   504,  1927,  1928,   497,  1668,  1669,  1670,  1671,   450,
    1935,   317,   304,  1606,  1939,  1940,   322,   497,   204,   499,
    2868,   492,   444,  2871,  2872,   144,   497,  2875,   499,  1954,
     313,  1956,  2923,  3741,   317,  1698,  1699,  2885,   470,    72,
      73,  1704,   492,   196,   456,   457,  1639,   497,   412,   499,
     414,   500,  1977,   206,  1979,   504,  3764,   210,  2966,   456,
     481,  1987,  1759,   307,   381,   497,   800,   496,   312,   456,
     804,   500,   496,     2,   399,   497,   500,   402,   488,   489,
     490,   491,   492,    73,  1759,   497,  3113,   502,   498,   381,
    2175,  3889,  1964,   410,  2046,  1967,   229,   250,   411,   163,
     412,     7,   414,  2028,  2404,   114,  1769,  1770,  1771,  1772,
    3192,    71,  2173,    19,    20,   378,   302,   270,   410,   260,
     437,   307,   115,   123,   124,  2173,   312,   444,  3969,   503,
    2125,  2894,  2127,    39,  3040,    95,    42,   497,  2558,   456,
    2560,  2561,  2173,   456,   457,   437,   490,   491,   492,    78,
     482,   497,   444,   499,  2077,    84,   498,   497,   500,  2922,
     498,   314,   500,   252,   456,  2091,  1759,   500,   501,   162,
     323,   317,    71,  3840,   114,   498,  2101,   500,  2239,  1842,
     497,   425,   104,   498,   497,   500,   472,   498,   117,   500,
     434,  2239,   456,   457,  2146,    71,    95,   372,   373,  2142,
    2101,   256,  2125,  3242,  2127,   497,   499,  2159,  2239,  2161,
    2271,  2163,  2404,   498,   320,   500,  2159,  2142,  2161,    95,
    2163,   419,   151,  2271,   372,   373,  1508,   103,  3936,   500,
     501,   160,   108,   498,  2159,   500,  2161,   143,  2163,   425,
    2158,  2142,  4010,   236,  4012,  2146,   320,   498,   434,   500,
     498,  2203,   500,  2800,  1046,   498,  1048,   500,  2159,   488,
     489,   490,   491,   492,   498,   317,   500,   496,  1002,  2816,
    1327,  1328,  1006,  2820,   498,   317,   500,   183,   207,   432,
    3426,  2355,   498,   472,   500,   214,  1983,   216,   281,   498,
     283,   500,   320,  1027,   254,   498,   498,   500,   500,   228,
     104,   294,   808,  3542,   498,   472,   500,   813,  1983,   815,
     498,   498,   500,   500,   820,  2258,   822,   498,   498,   500,
     500,   256,   828,  2266,   498,  2268,   500,   498,   490,   500,
     836,   473,   474,  2258,  2634,   841,   329,   843,   498,   387,
     500,  2266,   495,  2268,   214,   498,   499,   498,   498,   800,
     500,  4059,   497,   804,   230,   254,   500,  2258,   234,   319,
     498,   498,  2314,   500,   110,  2266,   498,  2268,   500,   114,
    2322,   364,   498,   498,   500,   500,   456,   457,   254,   255,
     501,   498,   888,   500,   498,   490,   500,   893,   456,   457,
    1983,    85,   503,   269,   900,   503,  2588,    91,   498,   498,
     500,   500,  2077,   498,   397,   500,   152,   498,   498,   500,
     500,   248,   498,  2338,   500,   498,  2368,   500,   193,   498,
     319,   500,  3663,   498,   419,   500,   302,  2684,  2685,   305,
     176,   419,   498,   362,   500,   498,   130,   500,   498,  2391,
     500,   419,   498,   319,   500,   498,   322,   500,   954,   195,
    2125,    72,  2127,   959,   419,    76,    77,    78,    79,    80,
     498,   497,   500,  3311,   970,   211,   498,   396,   500,  3317,
    3318,  3319,  3320,  3321,  3322,   498,  2173,   500,  2404,   225,
     419,  3028,  2629,  2630,    98,   498,   180,   500,   498,    71,
     500,  2443,   114,   187,  3521,  1001,   190,   498,  2173,   500,
     498,  3264,   500,  3050,   498,  2566,   500,   498,   439,   500,
    2571,  2682,  2683,    95,  1020,   391,   248,   498,  2566,   500,
    1026,   481,   419,  2571,   484,   485,   486,   254,   488,   489,
     490,   491,   492,   493,   498,  2566,   500,   499,  1044,  2457,
    2571,   498,  2239,   500,   165,   239,   498,   498,   500,   500,
     498,   498,   500,   500,   498,  3794,   500,  2989,   459,  2991,
     497,   307,  1094,  1095,  2239,   497,   499,   497,   317,   315,
    4127,   210,   268,   501,  2271,   439,  1027,   317,  3658,   317,
    2173,   497,   481,   311,   378,   484,   485,   486,  3577,   488,
     489,   490,   491,   492,   493,   260,  2271,   497,   126,   456,
     294,  2264,   348,    98,   459,   481,   227,   497,   484,   485,
     486,   104,   488,   489,   490,   491,   492,   493,   104,   428,
     496,   330,   210,   260,   502,   439,   502,   200,   200,   497,
     200,   459,   200,   200,   500,   200,   330,   200,  3879,   200,
     317,   200,   200,    72,    73,  2308,  2239,    76,    77,    78,
      79,    80,  2315,  2316,  2317,  2318,  2319,  2320,   200,   317,
     200,   282,  2588,   200,   285,   359,  1172,  1949,   497,   363,
      98,   268,   254,  1179,   497,   211,  2602,   210,  2271,   210,
     497,   497,   497,   339,  2984,   497,   497,   497,  2988,   497,
     497,   497,   497,   387,   497,  2621,   497,   497,   497,   497,
    2652,   630,   497,   327,    85,   497,   497,   497,  2634,  2652,
      91,   497,   497,   497,   497,   497,   497,   153,  1224,  1225,
    1226,   500,  2647,    98,  1230,  2650,    98,  2652,   254,   268,
    3030,  3970,  3279,  3280,   210,   210,   490,   319,   248,   379,
     285,   170,   500,  1477,   169,   438,    37,   500,   140,   130,
     484,  2652,    14,   500,   497,   497,   497,   419,   379,   419,
     499,   317,   419,  2426,  4003,  2428,   419,   419,  4007,  4008,
    2831,  2832,  2833,   380,   419,   419,   419,   307,   133,   438,
     239,   419,   317,  2831,  2832,  2833,  3580,  1521,  1522,  1523,
     419,   497,   500,   439,   419,   114,   330,   439,  3825,   180,
     419,  3649,  3650,   419,   114,   497,   187,  1313,   419,   190,
    4005,   419,   321,   419,   419,   419,   419,  3580,  3709,  4004,
     419,   376,   251,   419,   254,   317,   218,   317,   456,   497,
    1336,   497,   447,   497,    98,  1569,    97,    87,   170,   439,
     450,   276,  1576,    98,   273,   237,   210,   449,  1582,   470,
     317,  2940,  1586,    98,   377,   476,   497,   478,   239,   453,
    2921,   200,   439,  2815,   499,   200,   200,   200,   439,  2566,
      14,   800,  1606,  2921,  2571,   804,   419,   500,   444,   808,
     306,   273,   366,   452,   813,  2837,   215,   287,  2977,  2974,
    2921,  2566,   417,  2818,   472,    71,  2571,   287,   387,   481,
     417,   419,   484,   485,   486,  1639,   488,   489,   490,   491,
     492,   493,   497,   294,   843,   215,  2868,   500,   497,  2871,
    2872,   126,   497,  2875,   500,   421,   500,   484,   250,   228,
     322,   228,   484,  2885,   498,   140,   318,    34,  2890,   312,
     500,    10,  2894,   270,  2941,   498,   419,  3974,  2900,   330,
     498,  2894,   498,   419,   376,   139,   497,   886,   307,  2956,
    3152,   307,   258,   258,   893,   170,   307,   172,  1474,  2894,
    2922,   900,   317,  2566,  2899,  2900,   497,   151,  2571,  2922,
    2977,   324,   363,  2935,   315,   500,   419,    98,   359,  3990,
     359,   920,   359,  2894,  3924,   384,   419,  2922,   419,  3990,
     350,   254,    98,  4188,   315,   116,   387,  3154,  3155,  3156,
    3157,   254,   254,  2965,  2966,  2941,   254,   254,    97,   439,
     412,  2922,   414,   439,  3872,  1759,  1477,   484,   419,   210,
    2956,   423,   495,   495,   419,   146,   241,   484,   199,   212,
    3037,   433,   216,   497,   384,    98,   223,   476,   477,   478,
     317,  2977,   491,   482,   226,   226,  3117,  4084,  2984,   488,
     489,   210,  2988,   500,    98,  3859,   497,   996,   242,  3117,
    1521,  1522,  1523,  1002,   200,   384,   317,  1006,   317,   210,
     410,   459,   500,   257,    86,   220,  3117,  3634,  3635,   284,
    3637,   202,  3855,   267,   317,   500,  3859,   302,  1027,   114,
     498,    85,   307,   498,  1200,   498,  1035,    91,   319,   215,
     498,  3037,   498,   500,   498,   498,   290,   215,  1569,  1625,
     472,   232,   498,   497,  4167,  1576,   419,    14,   498,   453,
     498,  1582,   498,   498,  2831,  2832,  2833,  3437,   343,   498,
     498,   498,  3442,   317,   472,  3445,   130,   498,   326,   260,
     355,   206,   500,   497,   501,   270,  2831,  2832,  2833,   484,
     498,   442,   498,   500,   244,   419,  1672,  3277,   307,   270,
     334,   497,   334,   436,   497,   419,  3128,   279,   254,   279,
    4223,   254,   254,   419,   279,   419,  1692,   419,    85,   419,
     419,   419,   419,   254,    91,   369,   180,   254,  4089,   285,
     254,   495,  3263,   187,  3265,  4248,   190,   254,   498,   498,
    3757,   270,   484,   321,   428,  3263,   361,  3265,  3170,   163,
    3767,   497,   500,   498,  2921,   315,  3152,  1323,   433,   317,
     419,  3292,  3263,   130,  3265,   439,   317,   497,  2831,  2832,
    2833,   498,   325,  1172,  3292,   257,  2921,   257,   497,  1983,
    1179,   439,   363,   439,   312,   239,   367,   320,   198,  2541,
    2542,   198,   373,   193,  2546,   439,   215,    71,   210,   380,
     481,  1200,   498,   484,   485,   486,   387,   488,   489,   490,
     491,   492,   493,   180,   395,   495,   498,   124,   215,   498,
     187,   449,   403,   190,  3219,   497,  1802,   498,  1804,   222,
     500,  1230,   484,  2585,  2586,   498,   497,  1813,  1759,   484,
     294,   318,  3264,   244,   484,   428,   428,   210,   498,   498,
    1826,  3264,   254,   258,   456,    71,  3278,   419,  2921,  1835,
     419,   498,   419,  3285,   419,  3287,   254,   496,   498,  3264,
     451,   497,   239,  2077,   455,   456,   330,   497,    98,   459,
    1279,  1280,  3277,  1282,   210,   240,   135,   103,   500,  3311,
     411,  1290,   108,  3264,   497,  3317,  3318,  3319,  3320,  3321,
    3322,   257,   456,   497,  1880,   359,  3277,  1883,  1884,   363,
     497,   456,   481,   497,   384,   219,   215,   215,   497,  1895,
     497,  2125,   454,  2127,  1323,   498,  3339,   294,   454,  3351,
     114,   224,   428,   387,   498,   498,   307,  3954,  3360,  3361,
    3362,  3363,   307,  3338,  3339,   200,  1345,   484,   500,   254,
    3117,   498,  3347,   177,   307,   172,  3351,   241,   496,   500,
     500,   217,   215,   330,   439,  3360,   439,   188,   199,  2173,
     259,  3741,  3117,   215,  1373,   419,   498,   497,   497,   497,
     210,   320,   215,   497,   497,   443,   498,   396,   498,   455,
    3412,   333,   359,   498,  3764,   355,   363,  4014,   439,   497,
     497,   456,   210,    98,  3584,  1404,  1405,   500,  1407,   280,
    3590,   307,  1578,   347,   230,   237,   163,   126,   234,   373,
     387,  1420,   373,   320,  3604,  1424,   126,   484,   114,   323,
     318,   210,   317,   411,   205,  2239,  2012,   320,   254,   255,
     320,  3437,   481,   456,   443,    98,  3442,   500,   500,  3445,
     353,   188,   456,   269,  3117,   317,   317,    98,   183,   497,
     497,  2037,  1983,   498,  1463,   175,   372,  2271,   437,  1635,
     372,   199,    84,    95,   347,   497,   354,  1476,  1477,  2354,
    1468,  2652,  2765,  4125,  2245,  3263,  2890,  3875,  3858,   305,
    3399,  2224,  3402,  3251,  3702,  2462,  3263,  2729,  3265,  4151,
     116,  4187,  4114,   319,  1503,  3685,  4113,  3404,  1507,  1508,
    2086,  4159,  2193,  1780,  2957,  3411,  2832,  3292,  3263,  3889,
    3265,  2934,  1521,  1522,  1523,  3292,  1766,  2342,  1694,  4248,
     146,  4223,  3671,  3670,  2921,  4166,  2893,  3861,  1757,  4096,
     186,  3864,  1315,  3471,  3413,  1711,  3936,  3292,  4059,  2216,
    3417,  3573,  3574,  4066,  4247,  4211,  2077,  3911,  2086,   163,
    3573,  1498,  3397,  3038,  3586,  2663,  3936,  1017,  1292,  2455,
    1569,  1292,  3466,  3586,  1493,   391,  2672,  1576,  3573,  1578,
    3711,  2119,  2686,  1582,  3218,  1511,   202,  1586,  1754,  3584,
    1037,  3586,  3584,  3711,  2118,  3590,  2104,  2080,  2634,  2404,
    3263,  2990,  3265,  3765,  2125,   888,  2127,  1606,  2664,  3604,
    3394,  3127,  3972,  3584,  1613,  3119,   232,  3612,  3613,  3590,
    4145,  4149,  3617,  3618,  4146,  2675,  2602,  3649,  3650,  3292,
    2513,  2600,  1292,  3604,  2481,  1026,  1635,  2974,  3660,  3661,
    1639,  2013,  3664,  3665,  1810,   630,  3713,  2397,  1796,  1235,
    4139,  2146,  2173,   922,  1517,  3677,  3678,  3679,  3680,  3681,
    2236,   363,  2122,  1322,  1523,   481,  1115,  2153,  4038,   485,
     486,  1095,   488,   489,   490,   491,   492,   493,  2159,  2152,
    2646,  3222,  3677,  3678,  3679,  3680,  3681,  3572,  1441,  4059,
    3685,  3223,  3197,  2458,  1521,  1694,   395,  3719,  2163,  1872,
    3450,  1279,     2,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1711,  1266,  3685,    -1,    -1,  3713,  2239,    -1,
      -1,    -1,    -1,  3745,  1277,    -1,    -1,    -1,    -1,    -1,
    1729,    -1,  3084,    -1,    -1,  3087,  3088,  3089,  3090,  3091,
    3092,  3093,  3094,  3095,  3096,    -1,    -1,   363,    -1,   365,
    2271,   367,    -1,    -1,    -1,  1754,    -1,   373,    -1,    71,
    1759,    -1,  2566,    -1,   380,    -1,    -1,  2571,  3764,    -1,
      -1,   387,    98,    -1,    -1,    -1,  2352,    -1,    -1,   395,
      -1,    -1,  4152,    -1,    -1,    -1,    -1,   403,    -1,    -1,
     116,   103,  3144,  3145,    -1,    -1,   108,    -1,    -1,    -1,
      -1,    -1,    -1,  1802,    -1,  1804,    -1,    -1,    -1,    -1,
    2386,  1810,    -1,    -1,  1813,  1981,    -1,  2393,    -1,   814,
     146,    -1,  3835,   818,    -1,    -1,    -1,    -1,  2404,    -1,
      -1,    -1,   827,  3855,    -1,   451,    -1,    -1,    -1,    -1,
    3835,    -1,  3855,    -1,    -1,    -1,  1845,    -1,    -1,  1848,
    3872,    -1,    -1,    -1,  3876,    -1,    -1,   852,    -1,    -1,
    3855,   856,    -1,    -1,    -1,    -1,    -1,  4237,    -1,    -1,
      -1,    -1,   867,    -1,    -1,    -1,   202,    -1,    -1,    -1,
      -1,  1880,    -1,   195,  3855,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3964,    -1,    -1,
    4031,    -1,    -1,  3636,    -1,    -1,   232,    -1,    -1,    -1,
      -1,  3933,    -1,  4031,    -1,    -1,  1915,  1916,   230,    -1,
      -1,    -1,   234,    -1,  1923,    -1,    -1,  1926,    -1,    -1,
    1929,    -1,    -1,    -1,   260,  1934,    -1,    -1,  1937,  1938,
      -1,    -1,   254,   255,  3711,    -1,  1945,    -1,    -1,  1948,
    1949,  1950,  1951,    -1,    -1,    -1,    -1,   269,    -1,  1958,
    1959,    -1,  1961,    -1,  1963,  4227,  3711,  1966,  3964,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1981,  1982,  1983,    -1,    -1,  1986,    -1,    -1,
      -1,  1990,    -1,   305,    -1,  1994,    -1,    -1,  1997,  1998,
    1999,  2000,  2001,  2002,  2003,  2004,  2005,   319,  2007,    -1,
      -1,    -1,    -1,    -1,  2013,    -1,    -1,  3369,  2017,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2831,  2832,  2833,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,
      -1,   367,    -1,    -1,    -1,  2566,    -1,   373,  3711,    -1,
    2571,    -1,  2628,    -1,   380,    -1,    -1,    -1,  2634,    -1,
      -1,   387,    -1,    -1,    88,    -1,    -1,    -1,    -1,   395,
      -1,    -1,    -1,  4068,    -1,    -1,   100,   403,  2077,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2088,
      -1,    -1,    -1,    -1,    -1,    -1,   120,  4068,    -1,    -1,
      71,    -1,    -1,    -1,    -1,  2681,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2921,    -1,    -1,
     144,    -1,    -1,    -1,    -1,   451,  2125,    -1,  2127,   455,
      -1,    71,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,
     164,    -1,    -1,    -1,    -1,  4167,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4167,    95,    -1,    -1,    -1,    -1,
      -1,   185,  2161,   103,  2163,    -1,  2332,    -1,   108,   481,
      -1,    -1,  4167,    -1,  2173,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,  3536,  3537,    -1,    -1,   212,    -1,
      -1,  2190,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
      -1,  4223,  3935,    -1,    -1,    -1,    -1,  3940,  3941,    -1,
    4223,  2210,    -1,   237,    -1,  4211,  2215,  2216,    -1,    -1,
      -1,    -1,    -1,    -1,   195,    -1,  4248,    -1,  4223,    -1,
      -1,  4227,    -1,    -1,    -1,  4248,    -1,    -1,    -1,    -1,
    2239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4247,  1805,  4248,    -1,    -1,    -1,    -1,    -1,   230,
      -1,  1814,    -1,   234,  4031,    -1,    -1,    -1,    -1,  1822,
    1823,    -1,  2271,    -1,    -1,    -1,    -1,    -1,  4011,    -1,
    4013,    -1,    -1,   254,   255,    -1,  4031,  1840,    -1,    -1,
     230,    -1,    -1,    -1,   234,   319,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,   329,    71,    -1,    -1,    -1,
    2831,  2832,  2833,  3117,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,   346,    -1,    -1,    -1,  2492,  4060,    -1,   269,
      95,  2330,    -1,  2332,   305,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,   370,    -1,   319,    -1,
     374,    -1,   376,    -1,    -1,    -1,    -1,  2933,   382,    -1,
     384,    -1,   302,    -1,    -1,   305,    -1,  2943,  4031,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,  2959,  4117,    -1,   410,   411,    -1,    -1,
      -1,   415,    -1,  4126,    -1,  2394,    -1,    -1,    -1,   423,
    2921,    -1,    -1,    -1,   428,  2404,    -1,    -1,  2984,    -1,
      -1,    -1,  2988,    -1,   438,  2414,    -1,    -1,    -1,    -1,
     391,    -1,    -1,  4156,    -1,    -1,   450,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3012,    -1,  3790,  3015,
      -1,    -1,    -1,    -1,    -1,    -1,  3022,    -1,    -1,    -1,
      -1,   391,  2451,    -1,  3030,    -1,    -1,    -1,    -1,  3263,
      -1,  3265,  3814,  3815,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,  3051,    -1,    -1,    -1,    -1,
      -1,    -1,  2481,    -1,    -1,    -1,    -1,    -1,  3292,   254,
     255,    -1,    -1,  2492,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,
     481,    -1,  2511,  2512,    -1,    -1,    -1,   488,   489,   490,
     491,   492,   493,  2076,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,   481,  2541,  2542,   484,   485,   486,  2546,   488,   489,
     490,   491,   492,   493,   319,    -1,    -1,   322,   498,  2558,
    2559,  2560,  2561,    -1,    -1,    -1,    -1,  2566,    -1,    -1,
      -1,  2570,  2571,    -1,  2573,    -1,  2575,    -1,    -1,    -1,
      -1,    -1,    -1,  3159,  3160,    -1,  2585,  2586,    -1,  2588,
      71,    -1,    86,    -1,    -1,    -1,  3117,    -1,  2764,    -1,
      -1,    -1,  2601,    -1,  2603,    -1,    -1,    -1,  2607,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3969,    -1,    -1,
      -1,    -1,   103,    -1,  2623,    -1,   391,   108,    -1,  2795,
      71,  2797,    -1,    -1,    -1,  2634,    -1,  2636,  2637,  2638,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,  2656,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,  2665,   108,    -1,    -1,
      -1,    -1,    -1,  2672,    -1,    -1,    -1,    -1,  2677,    -1,
      -1,  1676,    -1,    -1,    -1,  2684,  2685,  2686,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,    -1,  2869,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   195,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,  2728,
      -1,    -1,    -1,    -1,    -1,   500,    -1,    -1,    -1,    -1,
     234,    -1,  3263,    -1,  3265,   239,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,  2754,  2755,    -1,  2757,    -1,
      -1,    -1,    -1,    -1,    -1,  2764,    -1,    -1,  1763,    -1,
      -1,  3292,  2938,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,  3357,    -1,  1778,   278,    -1,  2952,    -1,   269,   230,
      -1,    -1,    -1,   234,    -1,    -1,  2795,    -1,  2797,  3375,
      -1,   295,   296,   297,   298,   299,    -1,   301,    -1,    -1,
      -1,  3387,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   305,    -1,    -1,    -1,   269,    -1,
      -1,    -1,  2831,  2832,  2833,    -1,    -1,  3003,   319,    -1,
     334,    -1,  1837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3437,    -1,    -1,   305,    -1,  3442,    -1,  2421,  3445,
    2869,    -1,    -1,    -1,    -1,    -1,   370,    -1,   319,    -1,
      -1,    -1,  2435,  2436,    -1,    -1,  2439,    -1,    -1,    -1,
      -1,    -1,  2445,    -1,  2893,  2894,    -1,    -1,  3064,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3711,    -1,    -1,
     391,    -1,   406,    -1,   408,    -1,    -1,  3083,    -1,    -1,
      -1,    -1,  2921,  2922,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,  2938,
      -1,    -1,  3108,    -1,   438,    -1,    -1,   441,    -1,    -1,
     391,  2504,    -1,  2952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2967,    -1,
      -1,    -1,    -1,    -1,    98,    -1,  3142,  3553,  3554,  3555,
    3556,    -1,    -1,    -1,    -1,  2984,    -1,    -1,    -1,  2988,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,  2998,
     481,    -1,    -1,    -1,  3003,    -1,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3030,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3061,    -1,    -1,  3064,    -1,    -1,    -1,    -1,
      -1,  3070,    -1,    -1,    -1,    -1,    -1,  3076,   202,  3078,
      -1,    -1,    -1,    -1,  3083,  3084,    -1,    -1,  3087,  3088,
    3089,  3090,  3091,  3092,  3093,  3094,  3095,  3096,    -1,    -1,
      -1,  3100,  3101,    -1,    -1,    -1,    -1,    -1,   232,  3108,
      -1,    -1,    -1,    -1,  3113,  1200,    -1,    -1,  3117,    -1,
    3119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3129,    -1,    -1,  3132,    -1,  3134,   260,    -1,    -1,    -1,
      -1,    -1,    -1,  3142,  3143,  3144,  3145,    -1,    -1,    -1,
    3149,    -1,    -1,  3152,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,  3162,    -1,  3741,    -1,    -1,    -1,    -1,
      -1,    -1,  3171,    -1,    -1,  2170,    -1,    -1,    -1,  2174,
    2733,    -1,    -1,    -1,    95,    -1,    -1,    -1,  3764,    -1,
    3711,    -1,   103,    -1,  2189,    -1,    -1,   108,    -1,    -1,
      -1,    -1,  2197,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3382,    -1,  2771,  2772,
      -1,    -1,    -1,    -1,    -1,  2220,    -1,  4031,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,  1323,   363,
     108,    -1,  2237,   367,    -1,    -1,    -1,    -1,    -1,   373,
      -1,    -1,    -1,    -1,    -1,    -1,   380,  2252,    -1,  2254,
      -1,    -1,    -1,   387,  3263,  3264,  3265,    -1,    -1,    -1,
      -1,   395,    -1,    -1,    -1,    -1,    -1,  2272,    -1,   403,
      -1,    -1,  3858,    -1,  2279,    -1,    -1,    -1,    -1,    -1,
      -1,  2286,    -1,  3292,    -1,    -1,    -1,    -1,  2293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3889,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,  3898,   234,    -1,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,  3924,    -1,
      89,    -1,    -1,    88,    -1,    94,    -1,    96,   269,    -1,
    3936,    -1,   230,    -1,    -1,    -1,   234,   106,    -1,    -1,
    3369,    -1,  3948,    -1,    -1,    -1,  3542,    -1,    -1,    -1,
      -1,    -1,    -1,  3382,    -1,   120,   254,   255,    -1,    -1,
      -1,   302,    -1,   132,   305,    -1,    -1,    -1,   133,    -1,
      -1,   269,    -1,   142,    -1,   140,    -1,    -1,   319,   144,
      -1,   322,   151,   152,    -1,    -1,   155,    -1,  3417,  3418,
    3419,  3997,   161,    -1,    -1,    -1,   165,    -1,    -1,   164,
     169,    -1,    -1,    -1,   302,    -1,    -1,   305,  3437,    -1,
    3606,    -1,    -1,  3442,   183,    -1,  3445,   186,  3614,  3002,
     185,   319,   191,  3006,    -1,  3008,    -1,  3010,  3011,    -1,
      -1,    -1,  4038,   202,    -1,    -1,  3019,   206,    -1,   208,
      -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,  2474,
     391,    -1,   217,  4059,    -1,    -1,  3485,    -1,    -1,    -1,
     229,    -1,    -1,  1578,    -1,    -1,   235,    -1,    -1,  3052,
      -1,    -1,   237,    71,    -1,    -1,    -1,  2502,    -1,    -1,
    4031,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3521,   391,    -1,    -1,   261,    95,  1613,  3528,
    3529,    -1,  3531,    -1,    -1,   103,    -1,  3536,  3537,    -1,
     108,    -1,  3541,  3542,    -1,    -1,    -1,    -1,  3547,  3548,
    1635,    -1,  3551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,  3571,   484,   485,   486,  4152,   488,   489,   490,
     491,   492,   493,    -1,   319,    -1,    -1,  3586,    -1,   500,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3769,    -1,    -1,    -1,  3606,    -1,  1694,
      -1,   346,    -1,   481,    -1,  3614,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,  1711,    71,  3794,    -1,
      -1,    -1,    -1,    -1,    -1,   370,    -1,    -1,    -1,   374,
      -1,   376,    -1,    -1,  1729,    -1,   147,   382,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
     399,  4237,   230,    -1,   108,    -1,   234,    -1,    -1,  1754,
      -1,    -1,    -1,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,    -1,    -1,    -1,    -1,    -1,   254,   255,   423,    -1,
      -1,    -1,    -1,   428,    -1,   196,    -1,    -1,    -1,    -1,
      -1,   269,  3701,    -1,    -1,   206,    -1,    -1,    -1,   210,
      -1,    -1,  3711,    -1,   215,   450,    -1,    -1,   219,    -1,
      -1,   222,  2717,   224,    -1,  1810,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,    -1,  3741,    -1,    -1,    -1,    -1,  3746,    -1,   250,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
      -1,  3760,    -1,    -1,    -1,  3764,    -1,    -1,    -1,   270,
    3769,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,
     234,  3790,    -1,    -1,    -1,  3794,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2798,  3970,    -1,    -1,    -1,    -1,    -1,
     254,   255,    -1,   314,    -1,  3814,  3815,    -1,    -1,  3818,
      -1,    -1,   323,   391,    -1,   269,  3825,  3826,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4003,    -1,    -1,
      -1,  4007,  4008,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3855,    -1,   302,  3858,
      -1,   305,    -1,    -1,    -1,   366,    -1,    -1,  2863,    -1,
      -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3889,   630,    -1,    -1,    -1,    -1,  1981,    -1,    -1,    -1,
    3453,    -1,    -1,    -1,    -1,    -1,    -1,  3460,  3461,   410,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
     498,   432,    -1,    -1,    -1,    -1,    -1,  3936,  3937,   678,
     679,    -1,    -1,    -1,  3943,    -1,    -1,   391,    -1,    -1,
      -1,    -1,   453,   692,   455,   456,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3969,  3970,    -1,  3972,    -1,  3974,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   495,    -1,    -1,   498,   499,    -1,
     501,  4000,    -1,    -1,  4003,    88,    -1,    -1,  4007,  4008,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3018,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4031,    -1,    -1,    -1,  3031,   481,    -1,  4038,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,  3053,    -1,
    4059,   144,    -1,    -1,    -1,    -1,    -1,  4066,    -1,  4068,
     809,   810,   811,    -1,    -1,   814,    -1,   816,    -1,   818,
     819,   164,   821,    -1,   823,  4084,   825,   826,   827,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,   836,    -1,    -1,
      -1,    -1,   185,    -1,    -1,   844,    -1,    -1,   847,    -1,
     849,    -1,    71,   852,    95,   854,    -1,   856,   857,   858,
     859,    -1,   103,    -1,   863,  2210,   865,   108,   867,   212,
    2215,  2216,    -1,    -1,   217,    -1,    95,    -1,    -1,   222,
      -1,   880,    -1,   882,   103,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,  4152,   237,   894,    -1,    -1,   897,    -1,
      -1,    -1,   901,    -1,   903,    -1,   905,   906,    -1,    -1,
     909,    -1,   911,    -1,   913,    -1,   915,    -1,    -1,   918,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   940,   941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3773,    -1,  3775,  3776,    -1,    -1,    -1,   966,    -1,   968,
      -1,  3784,   971,    -1,    -1,    71,   319,    -1,  4237,    -1,
      -1,    -1,    -1,    -1,    -1,  3240,    -1,  2332,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,   998,
      -1,  1000,    -1,   346,    -1,  1004,    -1,   103,    -1,    -1,
      -1,   230,   108,   254,   255,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   370,   269,    -1,
      -1,    -1,  1031,   376,    -1,   254,   255,    -1,  1037,   382,
      -1,   384,    -1,    -1,  3299,    -1,  3301,    -1,    -1,  2394,
     269,    -1,    -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   305,    -1,    -1,   410,   411,    -1,
      -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,   319,    -1,
     423,   322,    -1,   302,    -1,   428,   305,   103,    -1,    -1,
      -1,    -1,   108,  1092,  1093,   438,    -1,    -1,    -1,   195,
     319,    -1,    -1,   322,    -1,    -1,  1105,   450,  1107,    -1,
      -1,    -1,  1111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   230,  1134,  1135,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2492,    -1,    -1,
     391,    -1,    -1,    -1,  3967,    -1,    -1,    -1,   254,   255,
      -1,    -1,    -1,  1162,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    -1,   391,   269,    -1,    -1,  1175,    -1,    -1,   195,
      -1,    -1,    -1,  1182,    -1,  1184,    -1,    -1,    -1,    -1,
      -1,  1190,    -1,    95,   815,  1194,    -1,    -1,    -1,   820,
      -1,   103,  1201,    -1,    -1,    -1,   108,   828,    -1,   305,
      -1,  1210,  1211,    -1,   230,   836,  3471,    -1,   234,    -1,
     841,    -1,    -1,   319,    -1,    -1,    -1,    -1,    -1,  1228,
    1229,    -1,  1231,  1232,    -1,    -1,    -1,    -1,   254,   255,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,   269,    -1,   496,    -1,  1256,  1257,    -1,
      -1,  1260,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,  1275,    -1,    -1,   498,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,  1301,   319,    -1,    -1,    -1,    71,    -1,  1308,
    1309,    -1,    -1,    -1,    -1,  1314,  1315,    -1,    -1,    -1,
      -1,  1320,    -1,    -1,    -1,    -1,  1325,    -1,   230,    -1,
      -1,    95,   234,   954,  1333,    -1,    -1,    -1,  1337,   103,
    1339,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,   970,
      -1,    -1,   254,   255,    -1,  3610,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3621,   269,    -1,  1200,
      -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,
    1001,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,    -1,
      -1,    -1,   488,   489,   490,   491,   492,   493,    -1,  1020,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,  2754,
    2755,    -1,  2757,    -1,    -1,    -1,    -1,   319,    -1,  2764,
     322,    -1,    -1,  1044,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1444,  1445,    -1,    -1,    -1,
    2795,    -1,  2797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1460,    -1,    -1,    -1,   481,   230,    -1,  1467,  1468,
     234,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,  1483,    -1,  1485,    -1,    -1,   391,
     254,   255,  1323,    -1,  1493,  1494,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2869,    -1,    -1,    -1,    -1,    -1,
    3785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,
    1539,   305,  1541,    -1,    -1,    -1,    -1,    -1,    -1,  2894,
      -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1571,    -1,    -1,    -1,    71,  2922,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,  2938,    -1,    -1,   498,  1596,    -1,    -1,
      95,    -1,    -1,  1224,  1225,  1226,    -1,  2952,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2967,    -1,    -1,    -1,    -1,   391,    -1,    -1,
      -1,    -1,  1463,    -1,    -1,    -1,    -1,    -1,  1637,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3003,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1668,
    1669,  1670,  1671,    -1,    -1,    -1,    -1,  1676,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1690,  1313,    -1,    -1,    -1,    -1,    -1,    -1,  1698,
    1699,    -1,    -1,    -1,    -1,  1704,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1336,    -1,   481,    71,  3064,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,   498,   230,    -1,    -1,  3083,   234,
      -1,    -1,    95,    -1,    71,    -1,    -1,  1578,    -1,    -1,
     103,    -1,    -1,    -1,    -1,   108,  1755,    -1,    -1,   254,
     255,    -1,    -1,  3108,  1763,    -1,    -1,    -1,  1767,    -1,
    1769,  1770,  1771,  1772,   269,    -1,   103,    -1,    -1,  1778,
      -1,   108,  1613,    -1,    -1,  1784,    -1,  1786,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3142,    -1,    -1,
      -1,    -1,    -1,    -1,  1635,    -1,    -1,   302,    -1,    -1,
     305,    -1,  1811,  1812,    -1,    -1,  1815,  1816,    -1,    -1,
      -1,    -1,  1821,    -1,   319,  1824,  1825,   322,  1827,    -1,
    1829,    -1,    -1,    -1,    -1,  1834,    -1,  1836,  1837,    -1,
      -1,    -1,  1841,  1842,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1474,    -1,    -1,    -1,  1856,  1857,    -1,
      -1,    -1,    -1,  1694,    -1,    -1,    -1,    -1,   195,    -1,
      -1,    -1,    -1,    -1,  1873,    -1,    -1,   230,    -1,  1878,
    1711,   234,  1881,  1882,    -1,    -1,  1885,    -1,    -1,    -1,
      -1,    -1,  1891,    71,    -1,    -1,   391,    -1,  1729,    -1,
      -1,   254,   255,   230,    -1,    -1,    -1,   234,    -1,    -1,
    1909,  1910,    -1,    -1,  1913,    -1,   269,    95,    -1,  3264,
      98,    -1,    -1,  1754,    -1,   103,    -1,   254,   255,    -1,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,  1947,   302,
      -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   305,  1810,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,   319,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,   117,   498,  1625,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2019,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3382,   391,    -1,
      -1,    -1,    -1,    -1,    -1,   160,    -1,    -1,    -1,    -1,
      -1,  1672,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,  1692,  3417,    -1,    -1,    -1,   254,   255,    -1,    -1,
    2079,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,   207,    -1,    -1,    -1,    -1,    -1,    -1,   214,
      -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   228,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   302,    -1,    -1,   305,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,   319,    -1,    -1,   322,   498,    -1,  2146,    -1,    -1,
    1981,    -1,    -1,    -1,   481,    -1,    -1,    -1,    -1,  2158,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,  2170,  2171,    -1,    -1,  2174,  2175,  2176,    -1,    -1,
      -1,  2180,    -1,    -1,    -1,    -1,  3531,  2186,    -1,    -1,
    2189,    -1,    -1,  2192,    -1,    -1,    -1,  3542,  2197,  2198,
      -1,    -1,    -1,    -1,  2203,  1826,    -1,    -1,    -1,    71,
      -1,    -1,    -1,   391,  1835,    -1,    -1,    -1,    -1,    -1,
      -1,  2220,  2221,    -1,    -1,  2224,  2225,  2226,  2227,  2228,
    2229,  2230,    -1,    95,  2233,  2234,    -1,    -1,  2237,  2238,
      -1,   103,  2241,    -1,    -1,    -1,   108,  2246,  2247,    -1,
      -1,    -1,    -1,  2252,    -1,  2254,  2255,    -1,    -1,    -1,
      -1,  3606,  1883,  1884,    -1,  2264,  2265,    -1,  2267,  3614,
      -1,    -1,    -1,  2272,    -1,    -1,    -1,  2276,  2277,  2278,
    2279,  2280,    -1,    -1,    -1,    -1,    -1,  2286,  2287,  2288,
      -1,    -1,    -1,    -1,  2293,    -1,  2295,  2296,    -1,    -1,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,  2308,
     488,   489,   490,   491,   492,   493,  2315,  2316,  2317,  2318,
    2319,  2320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2348,
      -1,    -1,    -1,    -1,    95,    -1,    -1,  2356,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,  2210,
      -1,  2380,    -1,    -1,  2215,  2216,    -1,    -1,  2387,    -1,
      -1,  2012,   254,   255,    -1,    -1,    -1,    -1,  2397,    -1,
      -1,  3746,    -1,    -1,    -1,    -1,  2405,   269,    -1,    71,
    2409,  2410,    -1,    -1,    -1,    -1,  2037,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3769,    -1,    -1,  2426,  2427,  2428,
    2429,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,
     302,   103,    -1,   305,  2443,    -1,   108,    -1,    -1,  3794,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,  2457,    -1,
     322,    -1,    -1,  2462,    -1,  2086,    -1,  2466,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2474,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,  2498,
      -1,  2332,    -1,  2502,    -1,    -1,    -1,    -1,    -1,    -1,
    3855,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,  2394,   305,    -1,    -1,    -1,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,  2576,   319,    -1,
      -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   254,   255,    -1,    -1,    -1,    -1,  3943,    -1,
      -1,    -1,    -1,    -1,    85,    -1,  2605,   269,    -1,    -1,
      91,    -1,    -1,    -1,    -1,  2236,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,  3970,   488,   489,   490,   491,
     492,   493,    -1,    -1,   115,    -1,   498,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,   130,
     391,    -1,    -1,  2652,    -1,    -1,    -1,   319,  4003,    -1,
     322,  2492,  4007,  4008,  2663,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,   162,    -1,    -1,    -1,   800,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   808,    -1,    -1,    -1,    -1,   813,   180,
      -1,    -1,    -1,    95,    -1,    -1,   187,    -1,    -1,   190,
      -1,   103,    -1,    -1,    -1,    -1,   108,    -1,  2717,  2718,
    2719,  4066,    -1,    -1,    -1,    -1,    -1,    -1,   843,   391,
      -1,  2352,    -1,  2732,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,  2741,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,   236,    -1,   498,   239,    -1,
      -1,    -1,    -1,    -1,    -1,  2386,    -1,    -1,    -1,    -1,
      -1,    -1,  2393,    -1,  2773,  2774,  2775,  2776,   893,    -1,
      -1,    -1,    -1,    -1,    -1,   900,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2798,
     281,  2800,   283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   294,    -1,    -1,    -1,  2816,    -1,   481,
      -1,  2820,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,   498,    -1,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,   329,   330,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2859,    -1,   254,   255,  2863,  2864,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2873,  2874,    -1,   269,   359,    -1,
      -1,   996,   363,   364,    -1,    -1,    -1,  1002,    -1,    -1,
      -1,  1006,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2900,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,   397,    -1,    -1,    -1,
    1035,    -1,    -1,  2754,  2755,    -1,  2757,   319,    -1,    -1,
     322,    -1,    -1,  2764,    -1,    -1,    -1,    -1,    -1,    -1,
    2939,  2940,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2957,    -1,
      -1,    -1,    -1,    -1,  2795,    -1,  2797,  2966,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2974,    -1,    -1,  2977,  2978,
      -1,    -1,  2981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2994,    -1,    -1,    -1,   391,
      -1,    -1,    -1,    -1,    -1,  3004,    -1,  2628,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3017,  3018,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3028,
      -1,    -1,  3031,    -1,    -1,    -1,    -1,    -1,  2869,  3038,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3050,    -1,    -1,  3053,    -1,    -1,  1172,    -1,    -1,
    2681,    -1,    -1,  2894,  1179,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1200,    71,    -1,    -1,   481,
      -1,  2922,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,   498,  2938,    -1,    -1,
      95,    -1,    -1,    -1,    -1,  1230,    -1,    -1,   103,    -1,
      -1,  2952,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2967,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,    -1,    -1,  3168,
      -1,    -1,  3003,    -1,    -1,  1290,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
    3199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1345,    -1,    -1,  3064,    -1,    -1,  3235,  3236,    -1,    71,
      -1,  3240,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,  3083,    -1,    -1,    -1,    -1,    -1,  1373,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    99,    -1,   254,
     255,   103,    -1,    -1,    -1,    -1,   108,  3108,    -1,    -1,
    3279,  3280,    -1,    -1,   269,    -1,    -1,    -1,    -1,  1404,
    1405,    -1,  1407,    -1,    -1,    -1,  3295,    -1,    -1,    -1,
    3299,  3300,  3301,  3302,  3303,  3304,  3305,    -1,    -1,  1424,
      -1,  3142,  2933,    -1,    -1,   230,    -1,   302,    -1,   234,
     305,    -1,  2943,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,  2959,   254,
     255,    -1,    -1,    -1,    -1,    -1,   178,    -1,    -1,    -1,
      -1,    -1,  3351,    -1,   269,   340,    -1,    -1,    -1,    -1,
      -1,  1476,  1477,    -1,    -1,  3364,  3365,  3366,    -1,  3368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,  1503,    -1,
     305,  3012,  1507,  1508,  3015,  3394,    -1,    -1,   230,    -1,
    3399,  3022,   234,  3402,   319,  3404,   391,   322,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3414,    -1,    -1,    -1,   404,
      -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,
    3051,    -1,    -1,  3264,  3433,    -1,  3435,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3446,    -1,  3448,
      -1,  3450,    -1,    -1,    -1,    -1,  3455,    -1,  3457,    -1,
      -1,    -1,    -1,  1578,    -1,    -1,    -1,  1582,    -1,    -1,
     302,  1586,  3471,   305,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,
     322,  1606,    -1,    -1,    -1,    -1,   481,    -1,  1613,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1635,    -1,    -1,    -1,  1639,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3159,  3160,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,
      -1,   476,    -1,    -1,    -1,    -1,   481,  3566,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,  1694,
      -1,  3580,    -1,    -1,    -1,    -1,  3417,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3605,   439,    -1,    -1,
      -1,  3610,  3611,    -1,  1729,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3621,  3622,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3634,  3635,  3636,  3637,  1754,
      -1,    -1,    -1,    -1,  1759,    -1,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,  3663,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3677,  3678,
    3679,  3680,  3681,    -1,    -1,    -1,    -1,  1802,    -1,  1804,
      -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,  1813,    -1,
    3531,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3542,    -1,    -1,    -1,    -1,  3715,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3733,    -1,  3357,    -1,    -1,    -1,
      -1,    -1,  3741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3375,  3754,    -1,    -1,  3757,    -1,
      -1,    -1,    -1,    -1,    -1,  1880,  3387,    -1,  3767,    -1,
      -1,    -1,    -1,    -1,    -1,  3606,    -1,    -1,    -1,    -1,
    3779,  3780,    -1,  3614,    -1,    -1,  3785,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1915,  1916,    -1,    -1,    -1,    -1,    -1,    -1,  1923,    -1,
      -1,  1926,    -1,    -1,  1929,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1937,  1938,    -1,    -1,    -1,    -1,    -1,    -1,
    1945,    -1,    -1,  1948,  1949,  1950,  1951,    -1,    -1,    -1,
      -1,    -1,    -1,  1958,  1959,    -1,  1961,    -1,  1963,    -1,
      -1,  1966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3859,    -1,    -1,    -1,    -1,    -1,  1981,  1982,  1983,    -1,
      -1,  1986,    -1,    -1,    -1,  1990,    -1,    -1,    -1,  1994,
    3879,    -1,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,    -1,  2007,    -1,    -1,    -1,    -1,    -1,  2013,    -1,
      -1,    -1,  2017,    -1,    -1,    -1,     3,    -1,    -1,    -1,
      -1,  3910,     9,  3912,    -1,    -1,    13,    -1,    15,    -1,
      17,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,  3553,  3554,  3555,  3556,  3935,  3936,  3769,    -1,
      -1,  3940,  3941,    -1,    -1,    -1,    -1,    -1,    45,    46,
      -1,    -1,    -1,    -1,    -1,  3954,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3794,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,  2088,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,  3987,    -1,
      -1,    -1,    -1,    -1,    91,    95,    93,    94,    -1,    71,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
     107,  4010,  4011,  4012,  4013,  4014,    -1,    -1,    -1,   207,
      -1,    -1,    -1,    95,  3855,    -1,   214,    -1,   216,    -1,
     127,   103,   129,   130,    -1,    -1,   108,   134,   135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   145,    -1,
     147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,    -1,
    4059,  4060,    -1,    -1,    -1,    -1,    -1,   164,    -1,   166,
      -1,    -1,   169,    -1,    -1,  2190,    -1,    -1,   175,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
     187,    -1,    -1,    -1,    -1,  2210,   193,    -1,    -1,    -1,
    2215,  2216,   199,    -1,   201,    -1,    -1,    -1,    -1,   206,
     210,    -1,  3943,    -1,    -1,   215,  4115,    -1,  4117,    -1,
      -1,    -1,   219,    -1,  2239,    -1,    -1,  4126,    -1,    -1,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,  3970,
    4139,    -1,    -1,    -1,    -1,    -1,  4145,    -1,    -1,   246,
      -1,    -1,    -1,    -1,   254,   255,  2271,  4156,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,  4167,   269,
      -1,    -1,  4003,    -1,   271,   272,  4007,  4008,    -1,    -1,
     277,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,    -1,   302,    -1,    -1,   305,    -1,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2330,    -1,  2332,    -1,   319,
      -1,    -1,   322,    -1,  4223,    -1,    -1,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   341,    -1,    -1,   319,    -1,  4248,
     322,    -1,    -1,    -1,    -1,   352,    -1,    -1,    -1,   356,
      -1,   358,    -1,   335,    -1,    -1,   363,    -1,    -1,    -1,
      -1,   368,    -1,    -1,   371,    -1,    -1,  3898,   375,  2394,
      -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,  2404,
     387,   391,    -1,   390,    -1,    -1,    -1,    -1,    -1,  2414,
     397,    -1,    -1,  3924,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,    -1,    -1,    -1,    71,    -1,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3948,    -1,   426,
      -1,   428,    -1,    -1,    -1,    -1,  2451,    -1,   435,    -1,
     437,    95,    -1,   440,    98,    -1,    71,   444,    -1,   103,
      -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,   456,
      -1,    -1,    -1,    -1,    -1,    -1,  2481,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,    -1,  3997,  2492,   103,    -1,
      -1,   481,    -1,   108,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,  2511,  2512,    -1,    -1,
     497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,  2541,  2542,    -1,    -1,
      -1,  2546,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2558,  2559,  2560,  2561,    -1,    -1,    -1,
      -1,  2566,    -1,    -1,    -1,  2570,  2571,    -1,  2573,    -1,
    2575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2585,  2586,    -1,  2588,    -1,    -1,   230,    -1,    -1,    -1,
     234,    -1,    -1,    -1,   196,    -1,  2601,    -1,  2603,    -1,
     215,    -1,  2607,    -1,   206,    -1,    -1,    -1,   210,    -1,
     254,   255,    -1,   215,    -1,   230,    -1,   219,  2623,   234,
     222,    -1,   224,    -1,    -1,   269,    -1,    -1,    -1,  2634,
      -1,  2636,  2637,  2638,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,    -1,
      -1,  2656,    -1,    -1,   269,    -1,    -1,    -1,   302,    -1,
    2665,   305,    -1,    -1,    -1,    -1,    -1,  2672,   270,    -1,
      -1,    -1,  2677,    -1,    -1,   319,    -1,    -1,   322,  2684,
    2685,  2686,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,  2728,    -1,    -1,    -1,    -1,    -1,    -1,
     808,    -1,    -1,    -1,    -1,   813,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,  2754,
    2755,    -1,  2757,    -1,    -1,    -1,    -1,    -1,    -1,  2764,
      -1,    -1,    -1,    -1,   366,   843,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2795,    -1,  2797,    -1,    -1,    -1,    95,    -1,    -1,    98,
      -1,    71,    -1,    -1,   103,    -1,    -1,    -1,   410,   108,
      -1,    -1,    -1,    -1,    -1,   893,    -1,    -1,    -1,    -1,
      -1,    -1,   900,    -1,    -1,    95,  2831,  2832,  2833,    -1,
     432,    -1,    -1,   103,    -1,    -1,    -1,   481,   108,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,   453,    -1,   455,   456,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2869,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,
      -1,    -1,    -1,   495,    -1,    -1,   498,   499,    -1,   501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2921,  2922,   996,    -1,
      -1,    -1,    -1,    -1,  1002,    -1,    -1,    -1,  1006,    -1,
      -1,   230,    -1,  2938,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2952,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   255,  1035,    -1,    -1,
     230,    -1,  2967,    -1,   234,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2984,
      -1,    -1,    -1,  2988,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2998,    -1,    -1,    -1,    -1,  3003,   269,
      -1,    -1,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,   322,    -1,  3030,    -1,    -1,    -1,    -1,
      -1,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,  3061,    -1,    -1,  3064,
      -1,    -1,    -1,    -1,    -1,  3070,    -1,    95,    -1,    -1,
      98,  3076,    -1,  3078,    -1,   103,    -1,    -1,  3083,  3084,
     108,    -1,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,
    3095,  3096,   391,    -1,  1172,  3100,  3101,    -1,    -1,    -1,
      -1,  1179,    -1,  3108,    -1,    -1,    -1,    -1,  3113,    -1,
      -1,    -1,  3117,    -1,  3119,    -1,    -1,    -1,    -1,    -1,
      -1,   391,  1200,    -1,  3129,    -1,    -1,  3132,    -1,  3134,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3142,  3143,  3144,
    3145,    -1,    -1,    -1,  3149,    -1,   416,  3152,    -1,    -1,
      -1,    -1,  1230,    -1,    -1,    -1,    -1,  3162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3171,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    95,    -1,    -1,    -1,    -1,
      -1,    -1,   230,   103,    -1,    -1,   234,    -1,   108,    -1,
      -1,   481,  1290,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,    -1,    71,  1323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3263,  3264,
    3265,    -1,    -1,    -1,    -1,    -1,    -1,  1345,    95,    -1,
      -1,    -1,    -1,    -1,   302,    -1,   103,   305,    -1,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,  3292,    -1,    -1,
      -1,   319,    -1,    -1,   322,  1373,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1404,  1405,    -1,  1407,
     230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1424,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   391,  3369,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1476,    -1,
      -1,    -1,   302,   230,    -1,   305,    -1,   234,    -1,    -1,
      -1,    -1,  3417,  3418,  3419,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,  1503,    -1,   254,   255,  1507,
    1508,    -1,  3437,    -1,    -1,    -1,    -1,  3442,    -1,    -1,
    3445,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
    3485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,   319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1586,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3521,    -1,    -1,    -1,
      -1,    -1,    -1,  3528,  3529,    -1,  3531,    -1,  1606,    -1,
      -1,  3536,  3537,    -1,    -1,  1613,  3541,  3542,    -1,    -1,
      -1,    -1,  3547,  3548,    -1,    -1,  3551,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,    -1,    -1,
      -1,  1639,    -1,    -1,   391,    -1,  3571,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,   481,    94,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3614,
      -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1711,    -1,    -1,    -1,    -1,    -1,   151,
     152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   161,
      -1,  1729,    -1,   165,   481,    -1,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   186,    -1,  1754,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     202,    -1,    -1,  1200,    -1,    -1,  3701,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1802,    -1,  1804,    -1,    -1,    -1,
      -1,    -1,  1810,    -1,    -1,  1813,  3741,    -1,    -1,    -1,
      -1,  3746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3760,    -1,    -1,    -1,  3764,
      -1,    -1,    -1,    -1,  3769,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3790,    -1,    -1,    -1,  3794,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1880,    -1,    -1,    -1,    -1,    -1,    -1,  3814,
    3815,    -1,    -1,  3818,    -1,    -1,  1323,    -1,    -1,    -1,
    3825,  3826,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1915,  1916,    -1,
      -1,    -1,    -1,    -1,    -1,  1923,    -1,    -1,  1926,    -1,
    3855,  1929,    -1,  3858,    -1,    -1,    -1,    -1,    -1,  1937,
    1938,    -1,    -1,    -1,    -1,    -1,    -1,  1945,    -1,    -1,
    1948,  1949,  1950,  1951,    -1,    -1,    -1,    -1,    -1,    -1,
    1958,  1959,    -1,  1961,  3889,  1963,    -1,   399,  1966,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1981,  1982,    -1,    -1,    -1,  1986,    -1,
      -1,    -1,  1990,    -1,    -1,    -1,  1994,    -1,    -1,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,    -1,  2007,
      -1,  3936,  3937,    -1,    -1,  2013,    -1,    -1,  3943,  2017,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3969,  3970,    -1,  3972,    -1,  3974,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4000,    -1,    -1,  4003,    -1,
      -1,    -1,  4007,  4008,    -1,    -1,    88,    -1,    -1,    -1,
    2088,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4031,    -1,    -1,    -1,
      -1,    -1,    -1,  4038,    -1,    96,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4059,    -1,    -1,    -1,   140,    -1,
      -1,  4066,   144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4084,
      -1,   142,   164,    -1,    -1,    -1,    -1,    -1,   170,    -1,
      -1,   152,    -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,
     161,    -1,    -1,   185,   165,    -1,  1613,    -1,    -1,    -1,
      -1,    -1,  2190,    -1,    -1,    -1,    -1,    -1,   630,    -1,
      -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,  1635,    -1,
     212,    -1,  2210,    -1,    -1,   217,   218,  2215,  2216,    -1,
     222,   202,    -1,    -1,    -1,    -1,    -1,  4152,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,    -1,    -1,   260,    -1,
     692,    -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,    -1,
      -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4237,    -1,    -1,    -1,    -1,   319,    -1,    -1,
     322,    -1,    -1,    -1,    -1,    -1,    -1,  1754,    -1,    -1,
      -1,    -1,  2330,    -1,  2332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   370,    -1,
      -1,    -1,   374,    -1,   376,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   384,  1810,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2394,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2404,    -1,    -1,   411,
     412,    -1,   414,   415,    -1,    -1,  2414,    -1,   399,    -1,
      -1,   423,    -1,    -1,    -1,   427,   428,    -1,    -1,    -1,
      -1,   433,    -1,    -1,    -1,    -1,   438,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   879,   880,    -1,
     882,    -1,    -1,  2451,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2481,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   923,    -1,    -1,  2492,   927,    -1,   929,    -1,   931,
      -1,    -1,    -1,    -1,    -1,   937,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2511,  2512,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2541,  2542,    -1,    -1,    -1,  2546,    -1,
      -1,    -1,    -1,    -1,  1981,    -1,    -1,    -1,    -1,    -1,
    2558,  2559,  2560,  2561,    -1,    -1,   998,    -1,  1000,    -1,
      -1,    -1,  2570,    -1,    -1,  2573,    -1,  2575,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2585,  2586,    -1,
    2588,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2601,    -1,  2603,    -1,    -1,    -1,  2607,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2623,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2634,    -1,  2636,  2637,
    2638,    -1,    -1,    -1,    -1,  1077,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2656,    -1,
    1092,  1093,    -1,    -1,  1096,    -1,    -1,  2665,    -1,    -1,
      -1,    -1,    -1,    -1,  2672,    -1,    -1,    -1,    -1,  2677,
      -1,    -1,    -1,    -1,    -1,    -1,  2684,  2685,  2686,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   678,   679,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   692,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2728,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2754,  2755,    -1,  2757,
      -1,    -1,    -1,    -1,    -1,    -1,  2764,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2210,    -1,    -1,    -1,    -1,  2215,  2216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,    -1,  2797,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   819,    -1,
     821,    -1,   823,    -1,   825,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   844,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2869,  1304,    -1,    -1,    -1,    -1,   858,   859,    -1,
      -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1322,    -1,    -1,    -1,    -1,    -1,  2894,    -1,    -1,   880,
      -1,   882,    -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   894,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2922,   906,    -1,    -1,   909,    -1,
     911,    -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2938,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2952,    -1,    -1,    -1,    -1,   940,
     941,    -1,    -1,    -1,    -1,    -1,    -1,  2394,    -1,  2967,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   966,  2984,   968,    -1,    -1,
    2988,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2998,    -1,    -1,  1435,    -1,  3003,    -1,    -1,    -1,    -1,
      -1,    -1,  1444,  1445,    -1,    -1,    -1,   998,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1463,  3030,    -1,    -1,  1467,  1468,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1037,    -1,    -1,    -1,
      -1,    -1,    -1,  3061,    -1,  2492,  3064,    -1,    -1,    -1,
      -1,    -1,  3070,    -1,    -1,    -1,    -1,    -1,  3076,    -1,
    3078,    -1,    -1,    -1,    -1,  3083,  3084,    -1,    -1,  3087,
    3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,  3096,    -1,
      -1,    -1,  3100,  3101,    -1,    -1,    -1,  1539,    -1,  1541,
    3108,    -1,    -1,    -1,    -1,  3113,    -1,  1549,    -1,    -1,
      -1,  3119,    -1,    -1,  1105,    -1,  1107,    -1,    -1,    -1,
    1111,  3129,    -1,    -1,  3132,    -1,  3134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3142,  3143,  3144,  3145,    -1,    -1,
      -1,  3149,    -1,    -1,  3152,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3162,    -1,  1598,    -1,    -1,    -1,
      -1,    -1,  1604,  3171,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1175,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1184,    -1,    -1,    -1,    -1,    -1,  1190,
      -1,    -1,  1644,    -1,    -1,  1647,  1648,    -1,    -1,    -1,
    1201,    -1,   808,    -1,    -1,    -1,    -1,   813,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1231,    -1,    -1,    -1,    -1,    -1,    -1,   843,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1697,  3264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   893,    -1,    -1,
      -1,    -1,    -1,    -1,   900,    -1,    -1,    -1,    -1,    -1,
    1301,    -1,    -1,    -1,    -1,    -1,    -1,  2754,  2755,    -1,
    2757,    -1,    -1,    -1,    -1,    -1,    -1,  2764,    -1,  1320,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,    -1,
    2797,  3369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3382,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     996,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3417,
    3418,  3419,    -1,    -1,    -1,  1857,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3437,
    1872,    -1,  2869,    -1,  3442,    -1,    -1,  3445,    -1,  1035,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3485,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2938,  1493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3521,    -1,  2952,    -1,    -1,    -1,    -1,
    3528,  3529,    -1,  3531,    -1,    -1,    -1,    -1,  3536,  3537,
    2967,    -1,    -1,  3541,  3542,    -1,    -1,    -1,    -1,  3547,
    3548,    -1,    -1,  3551,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3571,    -1,    -1,  3003,    -1,    -1,    -1,
    2012,    -1,    -1,    -1,    -1,    -1,  1172,  2019,    -1,    -1,
    1571,    -1,    -1,  1179,    -1,    -1,  2028,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3606,    -1,
      -1,    -1,    -1,    -1,  1200,  1596,  3614,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3064,    -1,    -1,
      -1,    -1,    -1,    -1,  1230,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3083,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3701,  1290,    -1,    -1,    -1,    -1,    -1,
    2142,    -1,    -1,    -1,  2146,  3142,    -1,    -1,  2150,    -1,
    2152,    -1,    -1,    -1,    -1,    -1,  2158,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1323,    -1,    -1,
      -1,    -1,    -1,  3741,    -1,    -1,    -1,    -1,  3746,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1345,
      -1,    -1,  3760,    -1,    -1,    -1,  3764,    -1,    -1,    -1,
      -1,  3769,    -1,    -1,  1755,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1767,  1373,    -1,    -1,
      -1,    -1,  3790,    -1,    -1,    -1,  3794,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3814,  3815,  1404,  1405,
    3818,  1407,    -1,    -1,    -1,    -1,  2258,  3825,  3826,    -1,
      -1,  1812,    -1,    -1,  2266,  1816,  2268,  3264,  1424,    -1,
      -1,    -1,    -1,    -1,  1825,    -1,  1827,    -1,  1829,    -1,
      -1,    -1,    -1,  1834,    -1,    -1,    -1,  3855,    -1,    -1,
    3858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1856,  1857,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1476,  3889,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1503,    -1,    -1,
      -1,  1507,  1508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3936,  3937,
      -1,    -1,    -1,    -1,    -1,  3943,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3969,  3970,    -1,  3972,    -1,  3974,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3417,    -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4000,    -1,    -1,  4003,    -1,    -1,    -1,  4007,
    4008,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2457,  2458,  1613,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2019,    -1,
    4038,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4059,    -1,    -1,    -1,    -1,    -1,    -1,  4066,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4084,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3531,    -1,    -1,    -1,  1694,    -1,
      -1,    -1,    -1,    -1,    -1,  3542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4152,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2158,    -1,  3606,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3614,    -1,    -1,
    2171,    -1,    -1,    -1,    -1,  2176,    -1,    -1,    -1,  2180,
      -1,    -1,    -1,    -1,    -1,  2186,    -1,    -1,    -1,    -1,
      -1,  2192,    -1,    -1,    -1,  2647,  1802,  2198,  1804,    -1,
    2652,    -1,  2203,    -1,  1810,    -1,    -1,  1813,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4237,
      -1,    -1,    -1,   996,    -1,  2226,  2227,  2228,  2229,    -1,
      -1,    -1,  2233,  2234,    -1,    -1,    -1,  2238,    -1,    -1,
    2241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1035,    -1,  2265,    -1,  2267,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1880,  2276,  2277,  2278,    -1,  2280,
      -1,    -1,    -1,    -1,    -1,    -1,  2287,  2288,    -1,    -1,
      -1,    -1,    -1,    -1,  2295,  2296,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1915,
    1916,    -1,    -1,    -1,    -1,    -1,    -1,  1923,    -1,    -1,
    1926,    -1,  3769,  1929,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1937,  1938,    -1,    -1,    -1,    -1,    -1,    -1,  1945,
      -1,    -1,  1948,  1949,  1950,  1951,    -1,  3794,    -1,    -1,
      -1,    -1,  1958,  1959,    -1,  1961,    -1,  1963,    -1,    -1,
    1966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1981,  1982,    -1,    -1,    -1,
    1986,    -1,    -1,    -1,  1990,    -1,    -1,    -1,  1994,    -1,
      -1,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,
      -1,  2007,    -1,    -1,    -1,    -1,    -1,  2013,  3855,    -1,
      -1,  2017,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2457,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2088,    -1,    -1,    -1,    -1,    -1,  2940,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3943,  2498,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3970,    -1,  2977,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1323,    -1,  4003,    -1,    -1,    -1,
    4007,  4008,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2190,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1373,    -1,    -1,    -1,  2210,    -1,    -1,    -1,    -1,  2215,
    2216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1404,  1405,    -1,  1407,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1476,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1200,    -1,    -1,    -1,    -1,  2718,  2719,    -1,
      -1,    -1,    -1,    -1,  2330,    -1,  2332,    -1,    -1,    -1,
    1503,    -1,    -1,    -1,  1507,  1508,    -1,    -1,    -1,    -1,
    2741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3222,    -1,  2773,  2774,  2775,  2776,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2404,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2414,  1578,
      -1,    -1,  3264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3277,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1613,  2451,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2859,    -1,
      -1,    -1,    -1,  2864,    -1,    -1,  1635,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2481,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2492,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2511,  2512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1694,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2541,  2542,    -1,  2939,  2940,
    2546,    -1,  1711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2558,  2559,  2560,  2561,  2957,    -1,    -1,    -1,
    1729,    -1,    -1,    -1,  2570,    -1,    -1,  2573,    -1,  2575,
      -1,    -1,    -1,    -1,    -1,    -1,  2977,    -1,    -1,  2585,
    2586,    -1,  2588,    -1,    -1,  1754,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2601,    -1,  2603,    -1,    -1,
      -1,  2607,    -1,  3004,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3017,  2623,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2634,    -1,
    2636,  2637,  2638,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2656,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2665,
      -1,    -1,    -1,    -1,    -1,    -1,  2672,    -1,    -1,    -1,
      -1,  2677,    -1,    -1,    -1,    -1,    -1,    -1,  2684,  2685,
    2686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1578,    -1,    -1,    -1,    -1,  1200,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3573,  2728,    -1,    -1,  1613,    -1,    -1,    -1,    -1,
      -1,    -1,  3584,    -1,    -1,    -1,    -1,    -1,  3590,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,  2754,  2755,
    1923,  2757,  3604,    -1,    -1,    -1,    -1,    -1,  2764,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1945,    -1,    -1,  1948,    -1,    -1,  1951,    -1,
      -1,    -1,    -1,    -1,    -1,  1958,  1959,    -1,    -1,  2795,
    1963,  2797,    -1,  1966,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,    -1,  1982,
      -1,    -1,  1981,  1986,    -1,  1200,    -1,  1990,  1323,    -1,
      -1,  1994,    -1,  1711,  1997,  1998,  1999,  2000,  2001,  2002,
    2003,  2004,  2005,  3685,  2007,    -1,    -1,    -1,    -1,    -1,
    2013,  1729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2869,  1200,    -1,  1754,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,    -1,
      -1,    -1,    -1,    -1,  3295,    -1,    -1,    -1,    -1,  3300,
      -1,  3302,  3303,  3304,  3305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2088,  2922,    -1,    -1,    -1,
      -1,    -1,  1810,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2938,    -1,    -1,    -1,    -1,    -1,  1323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2952,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2967,    -1,  3364,  3365,  3366,    -1,  3368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2984,    -1,
      -1,    -1,  2988,    -1,    -1,    -1,    -1,  1323,    -1,    -1,
      -1,    -1,  2998,    -1,    -1,    -1,    -1,  3003,    -1,    -1,
      -1,    -1,    -1,  3855,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2190,    -1,    -1,
      -1,    -1,    -1,    -1,  3030,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2210,    -1,    -1,    -1,    -1,  2215,  2216,    -1,  3450,
      -1,    -1,    -1,    -1,    -1,  3061,    -1,    -1,  3064,    -1,
      -1,    -1,    -1,    -1,  3070,    -1,    -1,    -1,    -1,    -1,
    3076,    -1,  3078,  1578,    -1,    -1,    -1,  3083,  3084,    -1,
      -1,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,
    3096,    -1,    -1,  1981,  3100,  3101,    -1,    -1,    -1,    -1,
      -1,    -1,  3108,    -1,    -1,    -1,    -1,  3113,  1613,    -1,
      -1,    -1,    -1,  3119,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3129,    -1,    -1,  3132,    -1,  3134,    -1,
    1635,    -1,    -1,    -1,    -1,    -1,  3142,  3143,  3144,  3145,
      -1,    -1,    -1,  3149,    -1,    -1,  3152,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3162,  2330,    -1,    -1,
      -1,    -1,    -1,  2332,    -1,  3171,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1694,
      -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,
    3611,    -1,    -1,    -1,    -1,    -1,  4068,    -1,    -1,    -1,
      -1,  3622,    -1,    -1,  1729,  2394,    -1,    -1,  1613,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2414,  1578,    -1,    -1,    -1,    -1,    -1,    -1,  1754,
    1635,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,  2451,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,
      -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,  2481,  1694,
      -1,    -1,    -1,    -1,  3715,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2210,  2492,    -1,    -1,  1711,  2215,  2216,    -1,
      -1,    -1,  3733,    -1,    -1,    -1,    -1,    -1,    -1,  2512,
      -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,
      -1,    -1,    -1,  3369,    -1,    -1,    -1,    -1,    -1,  1754,
      -1,    -1,    -1,    -1,    -1,  1711,  3382,    -1,  3779,    -1,
      -1,    -1,    -1,    -1,    -1,  2558,    -1,  2560,  2561,    -1,
      -1,    -1,    -1,  1729,    -1,    -1,    -1,  2570,    -1,    -1,
    2573,    -1,  2575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3417,  3418,  3419,    -1,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,  2601,    -1,
    2603,  3437,    -1,    -1,  2607,    -1,  3442,    -1,    -1,  3445,
      -1,    -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2638,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1810,    -1,  1981,    -1,    -1,  3485,
      -1,    -1,    -1,  2656,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2665,    -1,    -1,    -1,    -1,    -1,    -1,  2672,
      -1,    -1,    -1,    -1,  2677,    -1,  2394,    -1,    -1,    -1,
      -1,  2684,  2685,  2686,    -1,  3521,    -1,    -1,    -1,    -1,
      -1,    -1,  3528,  3529,    -1,  3531,    -1,    -1,    -1,    -1,
    3536,  3537,    -1,    -1,    -1,  3541,  3542,    -1,    -1,    -1,
      -1,  3547,  3548,    -1,    -1,  3551,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2728,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3571,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2754,  2755,    -1,  2757,    -1,
      -1,    -1,    -1,    -1,    -1,  2764,  1981,    -1,    -1,    -1,
    3606,    -1,    -1,    -1,  2492,    -1,    -1,    -1,  3614,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2795,    -1,  2797,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1981,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1420,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3701,    -1,    -1,    -1,    -1,
    2869,    -1,    -1,    -1,    -1,  2210,    -1,    -1,    -1,    -1,
    2215,  2216,    -1,    -1,  4115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2894,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3741,    -1,    -1,    -1,  1489,
    3746,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2922,  3760,    -1,    -1,    -1,  3764,    -1,
      -1,    -1,    -1,  3769,    -1,    -1,    -1,    -1,    -1,  2938,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2952,  3790,    -1,    -1,    -1,  3794,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2967,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3814,  3815,
      -1,    -1,  3818,    -1,    -1,    -1,    -1,    -1,    -1,  3825,
    3826,    -1,    -1,    -1,    -1,  2210,    -1,  2332,    -1,    -1,
    2215,  2216,    -1,    -1,  3003,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3855,
      -1,    -1,  3858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2754,  2755,    -1,  2757,
      -1,    -1,    -1,    -1,  2210,    -1,  2764,    -1,    -1,  2215,
    2216,    -1,    -1,  3889,    -1,    -1,    -1,    -1,  3061,  2394,
      -1,    -1,    -1,    -1,    -1,  3064,    -1,  3070,    -1,    -1,
      -1,    -1,    -1,  3076,    -1,  3078,    -1,  2795,    -1,  2797,
      -1,    -1,    -1,    -1,  3083,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3100,  3101,    -1,
    3936,  3937,    -1,    -1,    -1,    -1,    -1,  3943,    -1,  3108,
      -1,    -1,    -1,    -1,    -1,    -1,  3119,  2332,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3129,    -1,    -1,  3132,
      -1,  3134,    -1,  3969,  3970,    -1,  3972,    -1,  3974,    -1,
    3143,    -1,    -1,  3142,    -1,    -1,  3149,    -1,    -1,  3152,
      -1,  2869,    -1,    -1,    -1,    -1,    -1,  2492,    -1,  3162,
      -1,    -1,    -1,    -1,  4000,    -1,  2332,  4003,  3171,    -1,
      -1,  4007,  4008,    -1,    -1,    -1,  2894,    -1,    -1,  2394,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4038,    -1,  2922,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2938,    -1,    -1,  4059,    -1,    -1,    -1,    -1,  2394,    -1,
    4066,    -1,    -1,    -1,  2952,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4084,  2967,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3264,    -1,    -1,    -1,    -1,
    1850,    -1,    -1,    -1,    -1,    -1,    -1,  2492,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3003,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4152,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2492,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,  3064,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1944,  3083,    -1,    -1,    -1,  1949,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3382,    -1,    -1,    -1,    -1,  1968,  1969,
    3108,    -1,  1972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3418,  3419,    -1,  3417,  2754,
    2755,    -1,  2757,    -1,  3142,    -1,    -1,    -1,    -1,  2764,
      -1,  2011,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2795,    -1,  2797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3485,    -1,    -1,    -1,    -1,    -1,    -1,  2069,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2097,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3528,  3529,  2107,    -1,    -1,
    2110,    -1,  3531,    -1,  2869,    -1,    -1,    -1,  3541,  2754,
    2755,    -1,  2757,  3542,  3547,  3548,  3264,    -1,  3551,  2764,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3571,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2795,    -1,  2797,    -1,    -1,    -1,    -1,  2922,  2754,  2755,
      -1,  2757,    -1,    -1,    -1,    -1,    -1,    -1,  2764,    -1,
      -1,    -1,    -1,  2938,    -1,    -1,    -1,  3606,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3614,    -1,  2952,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,
      -1,  2797,  2967,    -1,    -1,    -1,    -1,    -1