
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__PGL_GOALSYM_H
#define POLYGRAPH__PGL_GOALSYM_H

#include "xstd/Time.h"
#include "pgl/PglRecSym.h"

class BigSize;

// run goal specification
class GoalSym: public RecSym {
	public:
		static String TheType;

	public:
		GoalSym();
		GoalSym(const String &aType, PglRec *aRec);

		virtual bool isA(const String &type) const;

		Time duration() const;
		bool xactCount(int &count) const;
		bool fillSize(BigSize &sz) const;
		bool errs(double &ratio, int &count) const;

	protected:
		virtual SynSym *dupe(const String &dType) const;
};

#endif
