//
// URIStreamFactory.h
//
// $Id: //poco/1.2/Foundation/include/Poco/URIStreamFactory.h#1 $
//
// Library: Foundation
// Package: URI
// Module:  URIStreamFactory
//
// Definition of the URIStreamFactory class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_URIStreamFactory_INCLUDED
#define Foundation_URIStreamFactory_INCLUDED


#include "Poco/Foundation.h"
#include <istream>


namespace Poco {


class URI;


class Foundation_API URIStreamFactory
	/// This class defines the interface that all
	/// URI stream factories must implement.
	///
	/// Subclasses must implement the open() method.
{
public:
	URIStreamFactory();
		/// Creates the URIStreamFactory.

	virtual std::istream* open(const URI& uri) = 0;
		/// Tries to create and open an input stream for the
		/// resource specified by the given URI.
		///
		/// If the stream cannot be opened for whatever reason,
		/// an appropriate IOException must be thrown.

protected:
	virtual ~URIStreamFactory();
		/// Destroys the URIStreamFactory.

private:
	URIStreamFactory(const URIStreamFactory&);
	URIStreamFactory& operator = (const URIStreamFactory&);
	
	friend class URIStreamOpener;
};


} // namespace Poco


#endif // Foundation_URIStreamFactory_INCLUDED
