/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file balloon_layer.hpp
 * \brief The balloon layer contains all balloons.
 * \author Angibaud Sebastien
 */
#ifndef __PTB_BALLOON_LAYER_HPP__
#define __PTB_BALLOON_LAYER_HPP__

#include "ptb/speaker_item.hpp"
#include "engine/layer/gui_layer.hpp"
#include "communication/typed_message.hpp"
#include <string>
#include <list>

namespace ptb
{
  /**
   * \brief The balloon layer contains the balloons of the text said by the
   *        items.
   */
  class balloon_layer:
    public bear::communication::messageable,
    public bear::engine::gui_layer
  {
  public:
    /**
     * \brief A message that adds a speaker in the layer.
     * \author Sebastien Angibaud
     */
    class msg_add_speaker:
      public bear::communication::typed_message<balloon_layer>
    {
    public:
      msg_add_speaker();
      void set_speaker( ptb::speaker_item* speaker );
      bool apply_to( balloon_layer& that );

    private:
      /** \brief Pointer to the speaker. */
      speaker_item* m_speaker;

    }; // class msg_add_speaker

    /** \brief The type of a list of scene elements retrieved from the layer. */
    typedef bear::engine::gui_layer::scene_element_list scene_element_list;

  public:
    balloon_layer();

    void build();
    void progress( bear::universe::time_type elapsed_time );
    void render( scene_element_list& e ) const;

    bool add_speaker( speaker_item* speaker);

    static const std::string& default_name();

  private:
    void adjust_balloon_position(speaker_item*);

    bear::universe::coordinate_type adjust_position_x
    ( speaker_item*, const bear::universe::rectangle_type& cam, bool& right);

    bear::universe::coordinate_type adjust_position_y
    ( speaker_item*, const bear::universe::rectangle_type& cam, bool& top);

  private:
    /** \brief Default name of the balloon layer. */
    static const std::string s_default_name;

    /** \brief List of speakers. */
    std::list<speaker_item*> m_speakers;

    /** \brief  The size of the border. */
    static const unsigned int s_border;

  }; // class balloon_layer
} // namespace ptb

#endif // __PTB_BALLOON_LAYER_HPP__
