/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_plee.cpp
 * \brief Implementation of the ptb::state_plee class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_plee.hpp"


/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_plee::state_plee( ptb::plee* plee_instance )
{
  m_plee_instance = plee_instance;
} // state_plee::state_plee()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_plee::do_move_left()
{
  m_plee_instance->apply_move_left();
} // state_plee::do_move_left()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_plee::do_move_right()
{
  m_plee_instance->apply_move_right();
} // state_plee::do_move_right()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do a jump.
 */
void ptb::state_plee::do_jump()
{
  if ( m_plee_instance->has_bottom_contact() )
    {
      m_plee_instance->apply_impulse_jump();
      if ( game_variables::get_air_power(m_plee_instance->get_index() ) ) 
	m_plee_instance->set_air_float(true);
      m_plee_instance->start_action_model("jump");
    }
} // state_plee::do_jump()


/*----------------------------------------------------------------------------*/
/**
 * \brief Stop a vertical jump.
 */
void ptb::state_plee::do_stop_vertical_jump()
{
  m_plee_instance->set_air_float(false);
} // state_plee::do_stop_vertical_jump()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee doing slap.
 */
void ptb::state_plee::do_slap()
{
  if (m_plee_instance->has_bottom_contact() )
    m_plee_instance->start_action_model("slap");
  else
    m_plee_instance->start_action_model("start_cling");
} // state_plee::do_slap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee look upward.
 */
void ptb::state_plee::do_look_upward()
{

} // state_plee::do_look_upward()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to look up.
 */
void ptb::state_plee::do_stop_look_upward()
{

} // state_plee::do_stop_look_upward()

/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to look up.
 */
void ptb::state_plee::do_continue_look_upward()
{

} // state_plee::do_continue_look_upward()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee crouch.
 */
void ptb::state_plee::do_crouch()
{

} // state_plee::do_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee continue to crouch.
 */
void ptb::state_plee::do_continue_crouch()
{

} // state_plee::do_continue_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to crouch.
 */
void ptb::state_plee::do_stop_crouch()
{

} // state_plee::do_stop_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief To unchain Plee.
 */
void ptb::state_plee::unchain()
{

} // state_plee::unchain()

/*----------------------------------------------------------------------------*/
/**
 * \brief To chain Plee.
 */
void ptb::state_plee::chain()
{
  m_plee_instance->start_action_model("captive");
} // state_plee::chain()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee throw.
 */
void ptb::state_plee::do_start_throw()
{
  m_plee_instance->start_action_model("maintain");
} // state_plee::do_start_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee drop a power.
 */
void ptb::state_plee::do_start_drop()
{
  m_plee_instance->apply_drop();
} // state_plee::do_start_drop()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee want throw.
 */
void ptb::state_plee::do_stop_throw()
{

} // state_plee::do_stop_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee is injured.
 */
void ptb::state_plee::do_injured()
{
  m_plee_instance->start_action_model("injured");
} // state_plee::do_injured()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee is not injured now.
 */
void ptb::state_plee::do_finish_injured()
{
  // do nothing
} // state_plee::do_finish_injured()
