/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file action_file_player_item.hpp
 * \brief An item that send actions to a player.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_ACTION_FILE_PLAYER_ITEM_HPP__
#define __PTB_ACTION_FILE_PLAYER_ITEM_HPP__

#include "engine/base_item.hpp"
#include "engine/item_brick/item_with_toggle.hpp"
#include "ptb/action_file_player.hpp"
#include "engine/export.hpp"

namespace ptb
{
  /**
   * \brief An item that send actions to a player.
   *
   * This item send the actions of a file.
   *
   * The valid fields for this item are
   *  - \a file_path: (string) [required] The path to the file in which the
   *    actions are saved,
   *  - any field supported by the parent classes.
   *
   * \author Sbastien Angibaud
   */
  class action_file_player_item:
    public bear::engine::item_with_toggle< bear::engine::base_item >,
    public ptb::action_file_player
  {
    DECLARE_BASE_ITEM(action_file_player_item, ptb);

  private:
    /** \brief The type of the parent class. */
    typedef bear::engine::item_with_toggle< bear::engine::base_item > super;
        
  public:
    action_file_player_item();
    
    bool set_string_field( const std::string& name, const std::string& value );
    bool set_u_integer_field( const std::string& name, unsigned int value );

    bool is_valid() const;
   
  private:
     void get_dependent_items( std::list<physical_item*>& d ) const;

  protected:
    void set_marionette(bool b);
    virtual void finish();
    virtual void progress_on( bear::universe::time_type elapsed_time );

  private:
    /** \brief The item that is controlled. */
    physical_item* m_item;
  }; // class action_file_player_item
} // namespace ptb

#endif // __PTB_ACTION_FILE_PLAYER_ITEM_HPP__
