/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame.hpp
 * \brief The base frame, with default borders and background.
 * \author Julien Jorge
 */
#ifndef __PTB_FRAME_HPP__
#define __PTB_FRAME_HPP__

#include "gui/window.hpp"
#include "gui/static_text.hpp"
#include "ptb/layer/windows_layer.hpp"

namespace ptb
{
  /**
   * \brief The base frame, with default borders and background.
   * \author Julien Jorge
   */
  class frame:
    public bear::gui::window
  {
  public:
    frame( windows_layer* owning_layer );

    bear::visual::sprite get_arrow() const;
    bear::visual::sprite get_cursor() const;
    bear::visual::sprite get_checkbox_off() const;
    bear::visual::sprite get_checkbox_on() const;
    bear::visual::sprite get_background() const;
    bear::visual::sprite get_slider_bar() const;
    bear::visual::sprite get_slider() const;
    bear::gui::static_text::font_type get_font() const;
    claw::graphic::rgba_pixel get_border_color() const;

    virtual void on_focus();

  protected:
    void show_window( frame* wnd ) const;
    void close_window() const;

    bear::gui::frame& get_frame();

  private:
    bear::gui::frame* create_frame(const windows_layer* owner);

    bear::visual::sprite* create_corner(const windows_layer* owner) const;
    bear::visual::sprite*
    create_horizontal_border(const windows_layer* owner) const;
    bear::visual::sprite*
    create_vertical_border(const windows_layer* owner) const;
    bear::visual::sprite* create_background(const windows_layer* owner) const;

    bear::visual::sprite get_frame_sprite_at
    ( unsigned int x, unsigned int y, unsigned int w, unsigned int h ) const;

    bear::visual::sprite get_frame_sprite_at
    ( const windows_layer* owner, unsigned int x, unsigned int y,
      unsigned int w, unsigned int h ) const;

  protected:
    /** \brief The layer owning this window. */
    windows_layer* const m_owning_layer;

  private:
    /** \brief The frame in the window. */
    bear::gui::frame* m_content_frame;

  }; // class frame
} // namespace ptb

#endif // __PTB_FRAME_HPP__
