;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../../common.scm")

(define flying-wasp
  (lambda (dest_image)

    (let ( (flying_name "wasp-flying.xcf.bz2") )
      (let ( (flying_image (car (gimp-file-load 1 flying_name flying_name)))
             )

        ; layer names
        (let ( (sash_3        0)
               (sash_2        1)
               (sash_1        2)
               (buckle_1      3)
               (back_buckle   4)
               (paws_1        5)
               (abdomen_1     6)
               (sting_1       7)
               (left_wing_3   8)
               (left_wing_2   9)
               (left_wing_1  10)
               (eye_1        11)
               (base         12)
               (right_wing_3 13)
               (right_wing_2 14)
               (right_wing_1 15) )

          (set-layer-opacity flying_image (list left_wing_1) 40)
          (set-layer-opacity flying_image (list right_wing_1) 40)
          (set-layer-opacity flying_image (list left_wing_2) 80)
          (set-layer-opacity flying_image (list right_wing_2) 80)
          (create-layer flying_image 
                        (list buckle_1 back_buckle paws_1 abdomen_1 eye_1 base
                              sash_1
                              left_wing_1 left_wing_2 right_wing_1 right_wing_2)
                        0 0 92 63 dest_image)

          (set-layer-opacity flying_image (list left_wing_2) 40)
          (set-layer-opacity flying_image (list right_wing_2) 40)
          (set-layer-opacity flying_image (list left_wing_3) 80)
          (set-layer-opacity flying_image (list right_wing_3) 80)
          (create-layer flying_image 
                        (list buckle_1 back_buckle paws_1 abdomen_1 eye_1 base
                              sash_2
                              left_wing_2 left_wing_3 right_wing_2 right_wing_3)
                        92 0 92 63 dest_image)

          (set-layer-opacity flying_image (list left_wing_3) 40)
          (set-layer-opacity flying_image (list right_wing_3) 40)
          (set-layer-opacity flying_image (list left_wing_2) 80)
          (set-layer-opacity flying_image (list right_wing_2) 80)
          (create-layer flying_image 
                        (list buckle_1 back_buckle paws_1 abdomen_1 eye_1 base
                              sash_3
                              left_wing_3 left_wing_2 right_wing_3 right_wing_2)
                        184 0 92 63 dest_image)

          (set-layer-opacity flying_image (list left_wing_2) 40)
          (set-layer-opacity flying_image (list right_wing_2) 40)
          (set-layer-opacity flying_image (list left_wing_1) 80)
          (set-layer-opacity flying_image (list right_wing_1) 80)
          (create-layer flying_image 
                        (list buckle_1 back_buckle paws_1 abdomen_1 eye_1 base
                              sash_1
                              left_wing_2 left_wing_1 right_wing_2 right_wing_1)
                        276 0 92 63 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define flying-wasp

(define dying-wasp
  (lambda (dest_image)

    (let ( (dying_name "wasp-shooting.xcf.bz2") )
      (let ( (dying_image (car (gimp-file-load 1 dying_name dying_name)))
             )

        ; layer names
        (let ( (buckle        0)
               (left_wing_3   1)
               (left_wing_2   2)
               (left_wing_1   3)
               (sash          4)
               (paws          5)
               (paws_1        6)
               (abdomen      10)
               (eyelid       25)
               (base         26)
               (right_wing_3 27)
               (right_wing_2 28)
               (right_wing_1 29) )

          (set-layer-opacity dying_image (list left_wing_1) 40)
          (set-layer-opacity dying_image (list right_wing_1) 40)
          (set-layer-opacity dying_image (list left_wing_2) 80)
          (set-layer-opacity dying_image (list right_wing_2) 80)
          (create-layer dying_image 
                        (list buckle sash paws paws_1 abdomen eyelid base
                              left_wing_1 left_wing_2 right_wing_1 right_wing_2)
                        0 63 89 91 dest_image)

          (set-layer-opacity dying_image (list left_wing_2) 40)
          (set-layer-opacity dying_image (list right_wing_2) 40)
          (set-layer-opacity dying_image (list left_wing_3) 80)
          (set-layer-opacity dying_image (list right_wing_3) 80)
          (create-layer dying_image 
                        (list buckle sash paws paws_1 abdomen eyelid base
                              left_wing_2 left_wing_3 right_wing_2 right_wing_3)
                        89 63 89 91 dest_image)

          (set-layer-opacity dying_image (list left_wing_3) 40)
          (set-layer-opacity dying_image (list right_wing_3) 40)
          (set-layer-opacity dying_image (list left_wing_2) 80)
          (set-layer-opacity dying_image (list right_wing_2) 80)
          (create-layer dying_image 
                        (list buckle sash paws paws_1 abdomen eyelid base
                              left_wing_3 left_wing_2 right_wing_3 right_wing_2)
                        178 63 89 91 dest_image)

          (set-layer-opacity dying_image (list left_wing_2) 40)
          (set-layer-opacity dying_image (list right_wing_2) 40)
          (set-layer-opacity dying_image (list left_wing_1) 80)
          (set-layer-opacity dying_image (list right_wing_1) 80)
          (create-layer dying_image 
                        (list buckle sash paws paws_1 abdomen eyelid base
                              left_wing_2 left_wing_1 right_wing_2 right_wing_1)
                        267 63 89 91 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define dying-wasp

(define wasp-soul
  (lambda (dest_image)

    (let ( (soul_name "soul.xcf.bz2") )
      (let ( (soul_image (car (gimp-file-load 1 soul_name soul_name)))
             )

        ; layer names
        (let ( (stars_1  0)
               (stars_2  1)
               (stars_3  2)
               (stars_4  3)
               (merged   4) )

          (create-layer soul_image (list stars_1 merged)
                        0 153 95 90 dest_image)
          (create-layer soul_image (list stars_2 merged)
                        95 153 95 90 dest_image)
          (create-layer soul_image (list stars_3 merged)
                        190 153 95 90 dest_image)
          (create-layer soul_image (list stars_4 merged)
                        285 153 95 90 dest_image)

          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define wasp-soul

(let ( (dest_name "wasp.png") )
  (let ( (dest_image (car (gimp-image-new 512 256 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 512 256 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (flying-wasp dest_image);
    (dying-wasp dest_image);
    (wasp-soul dest_image);

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
