;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../common.scm")

(let ( (src_name "corrupting-bonus-disapearing.xcf.bz2")
       (dest_name "corrupting-bonus-disapearing.png") )
  (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
         (dest_image (car (gimp-image-new 128 128 RGB)))
         )
    (let ( (bk (car (gimp-layer-new dest_image 128 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (let ( (top 0)
           (bottom 1) )

      ; we increase the top alone
      (create-layer src_image (list top)  12  12  8  8 dest_image)
      (create-layer src_image (list top)  41   8 14 14 dest_image)
      (create-layer src_image (list top)  70   6 20 20 dest_image)
      (create-layer src_image (list top)  99   3 26 26 dest_image)

      ; we increase the bottom
      (create-layer src_image (list bottom)  12  44  8  8 dest_image)
      (create-layer src_image (list bottom)  41  41 14 14 dest_image)
      (create-layer src_image (list bottom)  70  38 20 20 dest_image)
      (create-layer src_image (list bottom)  99  35 26 26 dest_image)
      ; and we keep the full size for the top
      (create-layer src_image (list top)  0 32 32 32 dest_image)
      (create-layer src_image (list top) 32 32 32 32 dest_image)
      (create-layer src_image (list top) 64 32 32 32 dest_image)
      (create-layer src_image (list top) 96 32 32 32 dest_image)

      ; we keep the full size for the bottom
      (create-layer src_image (list bottom)  0 64 32 32 dest_image)
      (create-layer src_image (list bottom) 32 64 32 32 dest_image)
      (create-layer src_image (list bottom) 64 64 32 32 dest_image)
      (create-layer src_image (list bottom) 96 64 32 32 dest_image)
      ; and we decrease the top
      (create-layer src_image (list top)   3 67 26 26 dest_image)
      (create-layer src_image (list top)  38 70 20 20 dest_image)
      (create-layer src_image (list top)  73 73 14 14 dest_image)
      (create-layer src_image (list top) 108 76  8  8 dest_image)

      ; then we decrease the bottom
      (create-layer src_image (list bottom)   3  99 26 26 dest_image)
      (create-layer src_image (list bottom)  38 102 20 20 dest_image)
      (create-layer src_image (list bottom)  73 105 14 14 dest_image)
      (create-layer src_image (list bottom) 108 108  8  8 dest_image)
      ) ; let

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
