/*
    Bear Engine - Level editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/code/level_overview_frame.cpp
 * \brief Implementation of the bf::level_overview_frame class.
 * \author Julien Jorge
 */
#include "bf/level_overview_frame.hpp"

#include "bf/ingame_view_frame.hpp"
#include "bf/level_thumbnail_ctrl.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param parent The level for which we want the view.
 */
bf::level_overview_frame::level_overview_frame( ingame_view_frame& parent )
  : wxFrame(&parent, wxID_ANY, _("Level overview"))
{
  m_thumbnail = new level_thumbnail_ctrl(this);
  m_thumbnail->set_view(&parent);

  wxBoxSizer* s = new wxBoxSizer( wxVERTICAL );
  s->Add(m_thumbnail, 1, wxALL | wxEXPAND);
  s->Add(new wxButton( this, wxID_REFRESH ));

  SetSizer(s);
} // level_overview_frame::level_overview_frame()

/*----------------------------------------------------------------------------*/
/**
 * \brief Procedure called when clicking on the refresh button.
 * \param event This event occured.
 */
void bf::level_overview_frame::on_refresh(wxCommandEvent& event)
{
  m_thumbnail->update();
} // level_overview_frame::on_refresh()

/*----------------------------------------------------------------------------*/
/**
 * \brief Procedure called when closing the window.
 * \param event This event occured.
 */
void bf::level_overview_frame::on_close(wxCloseEvent& event)
{
  if ( event.CanVeto() )
    {
      Hide();
      event.Veto();
    }
  else
    Destroy();
} // level_overview_frame::on_close()

/*----------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE(bf::level_overview_frame, wxFrame)
  EVT_BUTTON( wxID_REFRESH, bf::level_overview_frame::on_refresh )
  EVT_CLOSE( bf::level_overview_frame::on_close )
END_EVENT_TABLE()
