/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

#ifndef YAWPCONFIG_H
#define YAWPCONFIG_H

//--- LOCAL ---
#include "yawpdefines.h"
#include "pageanimator.h"
#include "weatherservice.h"
#include "utils.h"
#include "ui_yawplocationspage.h"
#include "ui_yawpsettingspage.h"
#include "ui_yawppanelpage.h"
#include "ui_yawpthemepage.h"

//--- QT4 ---
#include <QButtonGroup>
#include <QObject>
#include <QMap>

//--- KDE4 ---
#include <plasma/dataengine.h>
#include <plasma/weather/weatherutils.h>

#include <kdebug.h>

class KProgressDialog;
class KConfigDialog;


/** Configuration window.
	@author Ruan <ruans@kr8.co.za>
 */
class YawpConfigDialog : public QObject,
                         private Ui::LocationsPage,
                         private Ui::SettingsPage,
                         private Ui::PanelPage,
                         private Ui::ThemePage
{
	Q_OBJECT
public:
	YawpConfigDialog( KConfigDialog * parent );
	virtual ~YawpConfigDialog();

	void setData( const Yawp::ConfigData * data );
	void getData( Yawp::ConfigData * data );

	const WeatherServiceModel * weatherModel() const   { return m_pWeatherModel; }
	void copyCities( const WeatherServiceModel * model );

	bool cityModelChanged() const                      { return m_bCityModelChanged; }
	bool unitsChanged() const                          { return m_bUnitsChanged; }

signals:
	void save();
	
protected slots:
	void sliderAnimationDurationValue(int ms);

	void changeThemeState(int state);
	void selectCustomThemeFile();
	void enableYawpBackground();
	void enableCustomFontColorOptions(int state);

	void enableCompactPanelLayout(bool enabled);
	void enableExtendedTooltipOptions(bool enabled);

	void addCity();
	void deleteCity();
	void moveSelectedCityUp();
	void moveSelectedCityDown();
	void locationSelected( const QModelIndex & index );

private:
	void updateLocationButtons();
	void initAnimationCombo( QComboBox * pComboBox );
	void moveSelectedCity( int offset );

private:
	KConfigDialog              * m_pConfigDlg;
	WeatherServiceModel        * m_pWeatherModel;
	bool                         m_bCityModelChanged;
	bool                         m_bUnitsChanged;

// This is used to map localized theme names to the english names
	QMap <int, QString>   m_theme_map;
};

#endif //YAWP_CONFIG_H
