/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef GAMELIST
#define GAMELIST

/// Qt
#include <QGraphicsWidget>
#include <QModelIndex>
#include <QItemSelectionModel>
#include <QAbstractItemDelegate>
#include <QPointer>
#include <QItemDelegate>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneWheelEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneResizeEvent>
#include <QTime>

/// KDE
#include <Plasma/ScrollBar>
#include <Plasma/FrameSvg>


class GameItem;
class GameList : public QGraphicsWidget
{
	Q_OBJECT


enum Hover
{
	Nothing = 0,
	Add = 1,
	Remove = 2,
	Edit = 3,
	Item = 4
};


public:
	GameList( QGraphicsWidget *parent = 0 );
	~GameList();


public slots:
	void setModel( QAbstractItemModel *m );
	void setSelectionModel( QItemSelectionModel *selectionModel ){ _selectionModel = selectionModel; };
	void setColor( const QColor& c );
	void setFont( const QFont& f );

	QAbstractItemModel* model(){ return _model; };
	QAbstractItemDelegate* delegate(){ return _delegate; };
	//QRectF boundingRect() const { return QRectF( QPoint( 0, 0 ), geometry().size() ); };
	QItemSelectionModel* selectionModel() const{ return _selectionModel; };
	QModelIndexList selectedRows();
	int row( const QGraphicsItem *item, const QPointF& point );
	void setPaintFrame( const bool &paint ){ _frame = paint; update(); };


private slots:
	void setItemDelegate( QAbstractItemDelegate *dele ){ _delegate = dele; };
	void initPaintRange();
	void dataChanged( const QModelIndex &topLeft, const QModelIndex &bottomRight );
	void selectionChanged( const QItemSelection &topLeft, const QItemSelection &bottomRight );
	void scrollChanged( int value );
	void qupdate(){ scrollChanged( verticalScrollBar->value() ); };
	void calcSize();
	void startDrag();
	QModelIndex indexAt( const QPointF &p ) const;
	void calcFrameRect();
	void calcButtonRects();


private:
	mutable QVector<QModelIndex> intersectVector;
	QAbstractItemModel *_model;
	QPointer<QAbstractItemDelegate> _delegate;
	QItemSelectionModel *_selectionModel;
	Plasma::ScrollBar *verticalScrollBar;

	int firstItem;
	int lastItem;
	int lastItemOffset;
	int firstItemOffset;
	QColor _color;
	QFont _font;

	Hover hstate;
	Plasma::FrameSvg *hover;
	Plasma::FrameSvg *selectionFrame;
	Plasma::FrameSvg *listFrame;

	QList<QRectF> itemRects;
	QList<QRect> buttonRects;
	QRectF frameRect;
	bool _frame;
	int rectId;

	KIcon *add;
	KIcon *edit;
	KIcon *remove;

	QTimer *timer;
	QModelIndex dragIndex;
	QWidget *dragWidget;


protected:
	void paint( QPainter *painter,  const QStyleOptionGraphicsItem *,  QWidget * );
	void mousePressEvent( QGraphicsSceneMouseEvent *event );
	void keyPressEvent( QKeyEvent *event );
	void wheelEvent( QGraphicsSceneWheelEvent *event );
	void mouseDoubleClickEvent( QGraphicsSceneMouseEvent *event );
	void hoverMoveEvent( QGraphicsSceneHoverEvent *event );
	void hoverLeaveEvent( QGraphicsSceneHoverEvent *event );
	void resizeEvent( QGraphicsSceneResizeEvent *event );
	void mouseReleaseEvent( QGraphicsSceneMouseEvent *event );


signals:
	void clicked( const QModelIndex& idx, const Qt::MouseButton& button );
	void doubleClick( const QModelIndex& idx );
	void addClicked();
	void removeClicked();
	void editClicked();


};


#endif

