/* Copyright (c) 2001-2010, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.test;

import com.pixelmed.dose.*;

import junit.framework.*;

import com.pixelmed.dicom.*;

public class TestCompositeInstanceContext extends TestCase {
	
	// constructor to support adding tests to suite ...
	
	public TestCompositeInstanceContext(String name) {
		super(name);
	}
	
	// add tests to suite manually, rather than depending on default of all test...() methods
	// in order to allow adding TestCompositeInstanceContext.suite() in AllTests.suite()
	// see Johannes Link. Unit Testing in Java pp36-47
	
	public static Test suite() {
		TestSuite suite = new TestSuite("TestCompositeInstanceContext");
		
		suite.addTest(new TestCompositeInstanceContext("TestCompositeInstanceContextConstructor"));
		
		return suite;
	}
	
	protected void setUp() {
	}
	
	protected void tearDown() {
	}
	
	public void TestCompositeInstanceContextConstructor() throws Exception {
		
		String patientName = "Smith^Mary";
		String patientID = "3764913624";
		String patientBirthDate = "19600101";
		String patientSex = "F";
		String studyID = "612386812";
		String seriesNumber = "12";
		String instanceNumber = "38";
		String referringPhysicianName = "Jones^Harriet";
		
		String studyDate = "20100324";
		String studyTime = "142211";
		
		UIDGenerator u = new UIDGenerator("9999");
		String sopInstanceUID = u.getNewSOPInstanceUID(studyID,seriesNumber,instanceNumber);
		String seriesInstanceUID = u.getNewSeriesInstanceUID(studyID,seriesNumber);
		String studyInstanceUID = u.getNewStudyInstanceUID(studyID);
		
		AttributeList list = new AttributeList();

		{ Attribute a = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID); a.addValue(sopInstanceUID); list.put(a); }
		{ Attribute a = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID); a.addValue(seriesInstanceUID); list.put(a); }
		{ Attribute a = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID); a.addValue(studyInstanceUID); list.put(a); }
		{ Attribute a = new PersonNameAttribute(TagFromName.PatientName); a.addValue(patientName); list.put(a); }
		{ Attribute a = new LongStringAttribute(TagFromName.PatientID); a.addValue(patientID); list.put(a); }
		{ Attribute a = new DateAttribute(TagFromName.PatientBirthDate); a.addValue(patientBirthDate); list.put(a); }
		{ Attribute a = new CodeStringAttribute(TagFromName.PatientSex); a.addValue(patientSex); list.put(a); }
		{ Attribute a = new ShortStringAttribute(TagFromName.StudyID); a.addValue(studyID); list.put(a); }
		{ Attribute a = new PersonNameAttribute(TagFromName.ReferringPhysicianName); a.addValue(referringPhysicianName); list.put(a); }
		{ Attribute a = new ShortStringAttribute(TagFromName.AccessionNumber); list.put(a); }
		{ Attribute a = new IntegerStringAttribute(TagFromName.SeriesNumber); a.addValue(seriesNumber); list.put(a); }
		{ Attribute a = new IntegerStringAttribute(TagFromName.InstanceNumber); a.addValue(instanceNumber); list.put(a); }
		{ Attribute a = new LongStringAttribute(TagFromName.Manufacturer); list.put(a); }
		{ Attribute a = new CodeStringAttribute(TagFromName.PatientOrientation); list.put(a); }
		{ Attribute a = new CodeStringAttribute(TagFromName.Laterality); list.put(a); }
		{ Attribute a = new DateAttribute(TagFromName.StudyDate); a.addValue(studyDate); list.put(a); }
		{ Attribute a = new TimeAttribute(TagFromName.StudyTime); a.addValue(studyTime); list.put(a); }
		
		CompositeInstanceContext cic = new CompositeInstanceContext(list);
		AttributeList cicList = cic.getAttributeList();
		
		assertEquals("Checking SOPInstanceUID",sopInstanceUID,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SOPInstanceUID));
		assertEquals("Checking SeriesInstanceUID",seriesInstanceUID,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SeriesInstanceUID));
		assertEquals("Checking StudyInstanceUID",studyInstanceUID,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.StudyInstanceUID));
		assertEquals("Checking PatientName",patientName,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.PatientName));
		assertEquals("Checking PatientID",patientID,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.PatientID));
		assertEquals("Checking PatientBirthDate",patientBirthDate,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.PatientBirthDate));
		assertEquals("Checking PatientSex",patientSex,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.PatientSex));
		assertEquals("Checking StudyID",studyID,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.StudyID));
		assertEquals("Checking ReferringPhysicianName",referringPhysicianName,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.ReferringPhysicianName));
		assertEquals("Checking AccessionNumber","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.AccessionNumber));
		assertEquals("Checking SeriesNumber",seriesNumber,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SeriesNumber));
		assertEquals("Checking InstanceNumber",instanceNumber,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.InstanceNumber));
		assertEquals("Checking Manufacturer","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.Manufacturer));
		assertEquals("Checking PatientOrientation","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.PatientOrientation));
		assertEquals("Checking Laterality","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.Laterality));
		assertEquals("Checking StudyDate",studyDate,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.StudyDate));
		assertEquals("Checking StudyTime",studyTime,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.StudyTime));
		
		cic.removeSeries();
		cicList = cic.getAttributeList();
		assertEquals("Checking SeriesInstanceUID","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SeriesInstanceUID));
		assertEquals("Checking SeriesNumber","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SeriesNumber));
		assertEquals("Checking Laterality","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.Laterality));
		{
			AttributeList newList = new AttributeList();
			{ Attribute a = new IntegerStringAttribute(TagFromName.SeriesNumber); a.addValue(seriesNumber); newList.put(a); }
			cic.putAll(newList);
		}
		assertEquals("Checking SeriesNumber",seriesNumber,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SeriesNumber));
		
		cic.removeInstance();
		assertEquals("Checking SOPInstanceUID","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.SOPInstanceUID));
		assertEquals("Checking InstanceNumber","",Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.InstanceNumber));
		{ Attribute a = new IntegerStringAttribute(TagFromName.InstanceNumber); a.addValue(instanceNumber); cic.put(a); }
		assertEquals("Checking InstanceNumber",instanceNumber,Attribute.getSingleStringValueOrEmptyString(cicList,TagFromName.InstanceNumber));
	}
	
}
