/*
 * PIMPPA - pcfg
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>

#include "pimppa.h"

MYSQL *db;
	
void usage(char *progname)
{
	fprintf(stderr, "Usage: %s -k <key> -d <data>\n\n%s", progname,
	"-k <key>        Configuration key, MUST\n"
	"-d <data>       Value related to this key, MUST\n"
	"\nRunning without arguments prints the current keys & values.\n");
}

int printcurrent(void)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	
	p_query(db, "SELECT * FROM p_misc ORDER BY misc_key");
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		while((sql_row=mysql_fetch_row(sql_res)))
		{
			printf("Key : %s\nData: %s\n", sql_row[0], sql_row[1]);
		}
		mysql_free_result(sql_res);
	}

	return(0);
}

int main(int argc, char *argv[])
{
	char key[PATH_MAX];
	char data[PATH_MAX];
	int go=1;

	key[0]=data[0]=0;

	db=p_connect();
	if(!db)
		return(-1);

	p_initcfg(db);

	if(argc==1)
	{
		printcurrent();
		mysql_close(db);
		return(0);
	}

	while(go)
	{
		switch(getopt(argc, argv, "hk:d:V"))
		{
			case 'k':
				strcpy(key, optarg);
				break;
			case 'd':
				strcpy(data, optarg);
				break;
			case -1:
				go=0;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
			default:
				usage(argv[0]);
				return(0);
				break;
		}
	}
	
	if(!key[0])
	{
		fprintf(stderr, "Please supply key with -n <key>\n");
		return(0);
	}	
	if(!data[0])
	{
		fprintf(stderr, "Please supply data with -d <data>\n");
		return(0);
	}

/****************** Ok, lets add **********************/

	p_setmisc(db, key, data);
	
	fprintf(stderr, "Ok...\n");

	return(0);
}

