/* Generated from "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod" by precompile.pike
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 2


#line 1 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: mpq.cmod,v 1.32 2008/07/31 14:52:26 mast Exp $
*/

#include "global.h"
#include "gmp_machine.h"

#if defined(HAVE_GMP2_GMP_H) && defined(HAVE_LIBGMP2)
#define USE_GMP2
#else /* !HAVE_GMP2_GMP_H || !HAVE_LIBGMP2 */
#if defined(HAVE_GMP_H) && defined(HAVE_LIBGMP)
#define USE_GMP
#endif /* HAVE_GMP_H && HAVE_LIBGMP */
#endif /* HAVE_GMP2_GMP_H && HAVE_LIBGMP2 */

#if defined(USE_GMP) || defined(USE_GMP2)

#include "interpret.h"
#include "svalue.h"
#include "stralloc.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "pike_error.h"
#include "builtin_functions.h"
#include "module_support.h"
#include "bignum.h"
#include "operators.h"
#include "mapping.h"
#include "gc.h"

#include "my_gmp.h"

#include <limits.h>
#include <math.h>


#define sp Pike_sp
#define fp Pike_fp

#ifndef DEFAULT_CMOD_STORAGE
#define DEFAULT_CMOD_STORAGE
#endif
#line 49 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
#define THISMPQ (&(THIS->n))

#define PUSH_REDUCED(o) push_object(o)

/*! @module Gmp
 */

/*! @class mpq
 *! Rational number stored in canonical form. The canonical from means
 *! that the denominator and the numerator have no common factors, and
 *! that the denominator is positive. Zero has the unique
 *! representation 0/1. All functions canonicalize their result.
 */

/*  id PROG_GMP_MPQ_ID; */

#undef class_mpq_defined
#define class_mpq_defined
DEFAULT_CMOD_STORAGE struct program *mpq_program=NULL;
static int mpq_program_fun_num=-1;

#undef var_n_mpq_defined
#define var_n_mpq_defined

#undef THIS
#define THIS ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MPQ
#define THIS_MPQ ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MPQ
#define OBJ2_MPQ(o) ((struct mpq_struct *)(o->storage+mpq_storage_offset))

#undef GET_MPQ_STORAGE
#define GET_MPQ_STORAGE ((struct mpq_struct *)(o->storage+mpq_storage_offset)
static ptrdiff_t mpq_storage_offset;
struct mpq_struct {

#ifdef var_n_mpq_defined
#line 66 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
MP_RAT n;
#endif /* var_n_mpq_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct mpq_struct *mpq_gdb_dummy_ptr;
#endif
#line 68 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
static void get_mpq_from_digits(MP_RAT *tmp,
				  struct pike_string *digits,
				  int base)
    {
      p_wchar0 *str;
  
      if(digits->size_shift)
	Pike_error("Illegal characters, cannot convert to mpq.\n");
      str=STR0(digits);
      
      get_mpz_from_digits(mpq_numref(tmp), digits, base);
      
      if(!base || ((base >= 2) && (base <= 36)))
      {
	int offset = 0;
	int neg = 0;
	int dotfound = 0;
	
	if(digits->len > 1)
	{
	  if(str[0] == '+')
	    offset ++;
	  else if(str[0] == '-')
	  {
	    offset ++;
	    neg = 1;
	  }
	  
	  /* We need to fix the case with binary
	     0b101... and -0b101... numbers. */
	  if(!base && digits->len > 2)
	  {
	    if(str[offset] == '0')
	    {
	      switch(str[offset+1])
	      {
		case 'b':
		case 'B':
		  offset+=2;
		  base=2;
		  break;
		  
		case '0':
		  offset+=2;
		  base=8;
		  break;
		  
		case 'x':
		  offset+=2;
		  base=16;
		  break;
	      }
	    }
	  }
	}

	if(!base) base=10;
	
	mpq_set_ui(tmp, 0, 1);
	while(str[offset])
	{
	  int x=255;
	  if(str[offset] == '.')
	  {
	    offset++;
	    if(dotfound)
	      Pike_error("Invalid digits, cannot convert to mpq.\n");
	    dotfound++;
	    continue;
	  }
	  
	  if(str[offset] >= '0' && str[offset] <= '9')
	    x=str[offset]-'0';
	  else if(str[offset] >='a' && str[offset] <= 'z')
	    x=str[offset]-'a';
	  else if(str[offset] >='A' && str[offset] <= 'Z')
	    x=str[offset]-'A';
	  
	  if(x > base)
	    Pike_error("Invalid digits, cannot convert to mpq.\n");
	  
	  mpz_mul_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     base);
	  if(dotfound)
	  {
	    mpz_mul_ui(mpq_denref(tmp),
		       mpq_denref(tmp),
		       base);
	  }
	  mpz_add_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     x);
	  offset++;
	}

	if(dotfound)
	  mpq_canonicalize(tmp);

	if(neg)
	  mpz_neg(mpq_numref(tmp), mpq_numref(tmp));
      }
      else if(base == 256)
      {
	mpq_set_ui(tmp, 1, 1);
	get_mpz_from_digits(mpq_numref(tmp), digits, base);
      }
      else
      {
	Pike_error("invalid base.\n");
      }
    }

  int get_new_mpq(MP_RAT *tmp, struct svalue *s,
		  int throw_error, const char *arg_func, int arg, int args)
    {
      switch(s->type)
      {
	case T_FLOAT:
	{
	  double t;
	  int y;
	  t=FREXP((double) s->u.float_number, &y);

	  t*=pow(2.0,48.0);
	  y-=48;

	  mpz_set_d(mpq_numref(tmp), t);
	  mpz_set_ui(mpq_denref(tmp), 1);
	  if(y>0)
	    mpz_mul_2exp(mpq_numref(tmp),mpq_numref(tmp),y);
	  else if(y<0)
	    mpz_mul_2exp(mpq_denref(tmp),mpq_denref(tmp),-y);

	  mpq_canonicalize(tmp);
	  break;
	}
	  
	case T_INT:
	  get_new_mpz(mpq_numref(tmp), s, 1, arg_func, arg, args);
	  mpz_set_si(mpq_denref(tmp),1);
	  break;
	  
	case T_OBJECT:
	  if(IS_MPZ_OBJ (s->u.object))
	  {
	    mpq_set_z(tmp, OBTOMPZ(s->u.object));
	    break;
	  }
	  
	  if(s->u.object->prog == mpq_program)
	  {
	    mpq_set(tmp, OBTOMPQ(s->u.object));
	    break;
	  }
	  
	  if (s->u.object->prog) {
	    if (throw_error)
	      SIMPLE_ARG_TYPE_ERROR (arg_func, arg, "int|float|Gmp.mpq|Gmp.mpz");
	    else
	      return 0;
	  } else {
	    /* Destructed object. Use as zero. */
	    mpq_set_si(tmp, 0, 1);
	  }
	  break;
	  
	default:
	  if (throw_error)
	    SIMPLE_ARG_TYPE_ERROR (arg_func, arg, "int|float|Gmp.mpq|Gmp.mpz");
	  else
	    return 0;
      }

      return 1;
    }

/* Converts an svalue, located on the stack, to an mpq object */
  static MP_RAT *debug_get_mpq(struct svalue *s,
			       int throw_error, const char *arg_func, int arg, int args)
  {
    struct object *o = fast_clone_object (mpq_program);
    ONERROR uwp;
    SET_ONERROR (uwp, do_free_object, o);
    if (get_new_mpq (OBTOMPQ (o), s, throw_error, arg_func, arg, args)) {
      UNSET_ONERROR (uwp);
      free_svalue(s);
      s->u.object=o;
      s->type=T_OBJECT;
      return OBTOMPQ (o);
    }
    else {
      UNSET_ONERROR (uwp);
      free_object (o);
      return NULL;
    }
  }

#ifdef DEBUG_MALLOC
#define get_mpq(S, THROW_ERROR, ARG_FUNC, ARG, ARGS)			\
  ((S)->type <= MAX_REF_TYPE ? debug_malloc_touch((S)->u.object) : 0,	\
   debug_get_mpq((S), (THROW_ERROR), (ARG_FUNC), (ARG), (ARGS)))
#else
#define get_mpq debug_get_mpq
#endif

  /*! @decl static void create(void|string|int|float|Gmp.mpz|Gmp.mpq x)
   *! @decl static void create(int numerator, int denominator)
   *! @decl static void create(string x, int base)
   */
  #define f_mpq_create_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_create_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_create(INT32 args) {
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * x;
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * base;
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
x=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
} else x = NULL;
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 1) {
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",2,"void|int");
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
base=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
} else base = NULL;
#line 281 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    switch(args)
    {
      case 1:
	if(sp[-args].type == T_STRING)
	  get_mpq_from_digits(THISMPQ, sp[-args].u.string, 0);
	else
	  get_new_mpq(THISMPQ, sp-args, 1, "Gmp.mpq", 1, args);
	break;
	
      case 2:
	/* Args are string of digits and integer base */
	/* or int num / den */
	
	if (sp[1-args].type != T_INT)
#ifdef AUTO_BIGNUM
	  if(sp[1-args].type != T_OBJECT ||
	     sp[1-args].u.object->prog != bignum_program ||
	     sp[-args].type == T_STRING)
#endif
	  SIMPLE_ARG_TYPE_ERROR ("Gmp.mpq", 2, "int");

	switch(sp[-args].type)
	{
	  case T_STRING:
	    get_mpq_from_digits(THISMPQ, sp[-args].u.string, sp[1-args].u.integer);
	    break;

#ifdef AUTO_BIGNUM
	  case T_OBJECT:
	    if(sp[-args].u.object->prog != bignum_program)
#endif
	  default:
	      SIMPLE_ARG_TYPE_ERROR ("Gmp.mpq", 1, "int|string");

	  case T_INT:
	    mpq_set_num(THISMPQ,get_mpz(sp-args, 1, "Gmp.mpq", 1, args));
	    mpq_set_den(THISMPQ,get_mpz(sp-args+1, 1, "Gmp.mpq", 2, args));
	    mpq_canonicalize(THISMPQ);
	    break;
	}
	break;
	
      default:
	SIMPLE_WRONG_NUM_ARGS_ERROR ("Gmp.mpq", 2);

      case 0:
	break;	/* Needed by AIX cc */
    }
  }
  
  }
/*! @decl int get_int()
   */
  #define f_mpq_get_int_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_int_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_get_int(INT32 args) {
#line 334 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_int",args,0);
{
      struct object *res = fast_clone_object(mpzmod_program);
      mpz_tdiv_q(OBTOMPZ(res), mpq_numref(THISMPQ), mpq_denref(THISMPQ));
      /* FIXME */
#ifdef AUTO_BIGNUM
      mpzmod_reduce(res);
#else
      free_object(res);
      push_int(mpz_get_si(OBTOMPZ(res)));
#endif /* AUTO_BIGNUM */
    }

  }
/*! @decl static int __hash()
   */
  #define f_mpq_cq___hash_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq___hash_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq___hash(INT32 args) {
#line 349 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("__hash",args,0);
#line 351 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(
#line 353 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
mpz_get_si(mpq_numref(THISMPQ)) * 1000003 +
	mpz_get_si(mpq_denref(THISMPQ)));  push_int(ret_); return; }while(0);
#line 355 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl float get_float()
   */
  #define f_mpq_get_float_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_float_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_get_float(INT32 args) {
#line 359 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_float",args,0);
{
      do { FLOAT_TYPE ret_=((FLOAT_TYPE) mpq_get_d(THISMPQ));  push_float(ret_); return; }while(0);
#line 362 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl string get_string()
   */
  #define f_mpq_get_string_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_string_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_get_string(INT32 args) {
#line 366 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_string",args,0);
{
      push_string(low_get_mpz_digits(mpq_numref(THISMPQ),10));
      push_constant_text("/");
      push_string(low_get_mpz_digits(mpq_denref(THISMPQ),10));
      f_add(3);
    }

  }
#line 374 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
static int lookup(const char *name,
		    struct mapping *m,
		    char *ind,
		    int def,
		    int arg, int args)
    {
      struct svalue *sv;
      if((sv=simple_mapping_string_lookup(m,ind)))
      {
	if(sv->type == T_INT)
	{
	  return sv->u.integer;
	}else{
	  bad_arg_error (name, Pike_sp - args, args, arg, NULL, Pike_sp + arg - 1 - args,
			 "Bad argument %d to %s(). "
			 "The field \"%s\" doesn't hold an integer.\n",
			 arg, name, ind);
	}
      }
      return def;
    }
		    
  /*! @decl static string _sprintf(int c, mapping flags)
   */
  #define f_mpq_cq__sprintf_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__sprintf_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__sprintf(INT32 args) {
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
INT_TYPE c;
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct mapping * flags;
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
c=Pike_sp[0-2].u.integer;
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
#line 400 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT_TYPE precision, width, base = 0, mask_shift = 0;
      struct pike_string *s = 0;
      INT_TYPE flag_left;

      precision=lookup("Gmp.Mpq->_sprintf",flags,"precision",7, 2, args);
      width=lookup("Gmp.Mpq->_sprintf",flags,"width",-1, 2, args);
      flag_left=lookup("Gmp.Mpq->_sprintf",flags,"flag_left",0, 2, args);
      pop_n_elems(args);
      if(precision<0) precision=0;
      
      switch(c)
      {
	default:
	  push_undefined();
	  return;

	case 'O':
	  push_constant_text ("Gmp.mpq(");
	  f_mpq_get_string(0);
	  push_constant_text (")");
	  f_add (3);
	  return;

	  /* Fixme: Support g/e/E */
	case 'g':
	case 'e':
	case 'E':
	case 'f':
	{
	  mpz_t tmp;
	  ptrdiff_t len;
	  base=10;

	  mpz_init(tmp);
	  mpz_ui_pow_ui(tmp, 10, precision);
	  mpz_mul(tmp, tmp, mpq_numref(THISMPQ));
	  mpz_tdiv_q(tmp, tmp, mpq_denref(THISMPQ));
	  /* one for the pot... */
	  precision++;
	  /* present 'tmp' and insert dot */
	  len = mpz_sizeinbase(tmp, base) + 3;
	  s = begin_shared_string(len);
	  if(len/2 > precision)
	  {
	    mpz_get_str(s->str+1, base, tmp);
	    /* Find NULL character */
	    len-=4;
	    if (len < 1) len = 1;
	    while(s->str[len]) len++;
	    MEMMOVE(s->str, s->str+1, len-precision);
	  }else{
	    mpz_get_str(s->str, base, tmp);
	    /* Find NULL character */
	    len-=5;
	    if (len < 0) len = 0;
	    while(s->str[len]) len++;
	    MEMMOVE(s->str+len-precision+1,
		    s->str+len-precision,
		    precision+1);
	    len++;
	  }
	  mpz_clear(tmp);
	  s->str[len-precision]='.';
	  push_string(end_and_resize_shared_string(s, len));
	}
      }
    }
  
  }
/*! @decl static int(0..1) _is_type(string arg)
   */
  #define f_mpq_cq__is_type_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__is_type_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__is_type(INT32 args) {
#line 471 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct pike_string * arg;
#line 471 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 471 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_is_type",1,"string");
#line 471 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(arg=Pike_sp[0-1].u.string);
#line 473 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      push_constant_text("float");
      f_eq(2);
    }

  }
/*! @decl static int|string|float|object cast(string s)
   */
  #define f_mpq_cast_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cast_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cast(INT32 args) {
#line 480 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct pike_string * s;
#line 480 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 480 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("cast",1,"string");
#line 480 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 482 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      add_ref(s);
      
      pop_n_elems(args);
      
      switch(s->str[0])
      {
	case 'i':
	  if(!strncmp(s->str, "int", 3))
	  {
	    free_string(s);
	    f_mpq_get_int(0);
	    return;
	  }
	  break;
	  
	case 's':
	  if(!strcmp(s->str, "string"))
	  {
	    free_string(s);
	    f_mpq_get_string(0);
	    return;
	  }
	  break;

	case 'f':
	  if(!strcmp(s->str, "float"))
	  {
	    free_string(s);
	    f_mpq_get_float(0);
	    return;
	  }
	  break;
	  
	case 'o':
	  if(!strcmp(s->str, "object"))
	  {
	    push_object(this_object());
	  }
	  break;
	  
	case 'm':
	  if(!strcmp(s->str, "mixed"))
	  {
	    push_object(this_object());
	  }
	  break;
	  
      }
      
      free_string(s);

      SIMPLE_ARG_ERROR ("Gmp.mpq->cast", 1,
			"Cannot cast to other type than sitrng, int or float.\n");
    }

  }
/*! @decl static Gmp.mpq `+(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_add_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_add_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_add(INT32 args) {
#line 540 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 540 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 540 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 542 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1, "Gmp.mpq->`+", e + 1, args);
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 553 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq ``+(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_backtick_add_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_add_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_add(INT32 args) {
#line 557 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 557 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 557 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 559 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1, "Gmp.mpq->``+", e + 1, args);
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 570 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq `+=(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_add_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_add_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_add_eq(INT32 args) {
#line 574 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 574 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 574 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 576 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    INT32 e;
    for(e=0; e<args; e++)
      get_mpq(sp+e-args, 1, "Gmp.mpq->`+=", e + 1, args);
    for(e=0;e<args;e++)
      mpq_add(THISMPQ, THISMPQ, OBTOMPQ(sp[e-args].u.object));
    
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 584 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}
  

}
#line 587 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
#ifdef BIG_PIKE_INT
#define TOOBIGTEST || sp[e-args].u.integer>MAX_INT32
#else
#define TOOBIGTEST 
#endif

  static void mult_convert_args(INT32 args, const char *arg_func)
    {
      INT32 e;
      for(e=0; e<args; e++)
      {
	if(sp[e-args].type == T_OBJECT)
	{
	  if(sp[e-args].u.object->prog == mpzmod_program)
	    continue;
#ifdef AUTO_BIGNUM
	  if(sp[e-args].u.object->prog == bignum_program)
	    continue;
#endif
	}
	
	if(sp[e-args].type != T_INT || sp[e-args].u.integer<=0 TOOBIGTEST)
	  get_mpq(sp+e-args, 1, arg_func, e + 1, args);
      }
    }
  
  static void mult_args(MP_RAT *res,
			INT32 e,
			INT32 args)
    {
      int norm=0;
      for(;e<args;e++)
      {
	if(sp[e-args].type == T_INT)
	{
	  mpz_mul_ui(mpq_numref(res),
		      mpq_numref(res),
		      sp[e-args].u.integer);
	  norm++;
	}
	else if(sp[e-args].u.object->prog == mpq_program)
	{
	  mpq_mul(res, res, OBTOMPQ(sp[e-args].u.object));
	}else{
	  norm++;
	  mpz_mul(mpq_numref(res),
		   mpq_numref(res),
		   OBTOMPZ(sp[e-args].u.object));
	}
      }
      
      if(norm) mpq_canonicalize(res);
    }
  
  /*! @decl static Gmp.mpq `*(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2A_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2A_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2A(INT32 args) {
#line 643 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 643 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 643 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 645 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args, "Gmp.mpq->`*");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 654 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq ``*(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_backtick_2A_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2A_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2A(INT32 args) {
#line 658 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 658 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 658 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 660 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args, "Gmp.mpq->``*");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 669 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq `*=(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2A_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2A_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2A_eq(INT32 args) {
#line 673 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 673 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 673 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 675 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    mult_convert_args(args, "Gmp.mpq->`*=");
    mult_args(THISMPQ, 0,args);
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 679 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}
  
  }
/*! @decl static Gmp.mpq `-(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2D_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2D_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2D(INT32 args) {
#line 683 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 683 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 683 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 685 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      if (args)
	for (e = 0; e<args; e++)
	  get_mpq(sp + e - args, 1, "Gmp.mpq->`-", e + 1, args);
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      if(args)
      {
	for(e=0;e<args;e++)
	  mpq_sub(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      }else{
	mpq_neg(OBTOMPQ(res), OBTOMPQ(res));
      }
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 705 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq ``-(int|float|object sv)
   */
  #define f_mpq_cq__backtick_backtick_2D_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2D_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2D(INT32 args) {
#line 709 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 709 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``-",args,1);
#line 709 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 711 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      MP_RAT *a=get_mpq(sv, 1, "Gmp.mpq->``-", 1, args);
      res = fast_clone_object(mpq_program);
      mpq_sub(OBTOMPQ(res), a, THISMPQ);
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 717 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq `/(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2F_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2F_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2F(INT32 args) {
#line 721 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 721 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 721 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 723 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1, "Gmp.mpq->`/", e + 1, args)))
	  SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpq->`/");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)	
	mpq_div(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 737 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}
  
  }
/*! @decl static Gmp.mpq ``/(int|float|object sv)
   */
  #define f_mpq_cq__backtick_backtick_2F_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2F_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2F(INT32 args) {
#line 741 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 741 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``/",args,1);
#line 741 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 743 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      struct object *res = NULL;
      if(!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpq->``/");

      a=get_mpq(sv, 1, "Gmp.mpq->``/", 1, args);
      
      res=fast_clone_object(mpq_program);
      mpq_div(OBTOMPQ(res), a, THISMPQ);
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 755 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq `%(int|float|object ... a)
   *! @expr{a%b =  a -  floor(a/b)*b @}
   */
  #define f_mpq_cq__backtick_25_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_25_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_25(INT32 args) {
#line 760 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 760 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 760 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 762 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      mpq_t tmp;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1, "Gmp.mpq->`%", e, args)))
	  SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpq->`%");

      res = fast_clone_object(mpq_program);
      
      mpq_init(tmp);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      for(e=0;e<args;e++)
      {
	mpz_mul(mpq_numref(tmp),
		mpq_numref(OBTOMPQ(res)),
		mpq_denref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_denref(tmp));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_numref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_set_si(mpq_denref(tmp),1);
	
	mpq_mul(tmp, tmp, OBTOMPQ(sp[e-args].u.object));
	mpq_sub(OBTOMPQ(res), OBTOMPQ(res), tmp);
      }
      mpq_clear(tmp);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 798 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static Gmp.mpq ``%(int|float|object a)
   */
  #define f_mpq_cq__backtick_backtick_25_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_25_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_25(INT32 args) {
#line 802 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 802 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``%",args,1);
#line 802 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
a=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 804 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      
      struct object *res;
      if(!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpq->``%");

      a=get_mpq(sp-1, 1, "Gmp.mpq->``%", 1, 1);
      
      res=fast_clone_object(mpq_program);
      
      mpz_mul(mpq_numref(OBTOMPQ(res)), mpq_numref(a), mpq_denref(THISMPQ));
      
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_denref(OBTOMPQ(res)));
		 
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_numref(a));
      
      mpz_set_si(mpq_denref(OBTOMPQ(res)),1);
      
      mpq_mul(OBTOMPQ(res), OBTOMPQ(res), THISMPQ);
      mpq_sub(OBTOMPQ(res), a, OBTOMPQ(res));
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 831 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl Gmp.mpq invert()
   */
  #define f_mpq_invert_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_invert_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_invert(INT32 args) {
#line 835 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("invert",args,0);
{
      struct object *res;
      if (!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpq->invert");
      res = fast_clone_object(mpq_program);
      mpq_inv(OBTOMPQ(res), THISMPQ);
      do { struct object * ret_=(res);  push_object(ret_); return; }while(0);
#line 843 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}
  
  }
/*! @decl static Gmp.mpq `~()
   *! Defined as @expr{-1-x@}.
   */
  #define f_mpq_cq__backtick_7E_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_7E_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_7E(INT32 args) {
#line 848 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`~",args,0);
#line 850 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      struct object *o;
      o=fast_clone_object(mpq_program);
      mpq_set_si(OBTOMPQ(o), -1, 1);
      mpq_sub(OBTOMPQ(o),OBTOMPQ(o), THISMPQ);
      
      do { struct object * ret_=(o);  push_object(ret_); return; }while(0);
#line 857 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `>(mixed q)
   */
  #define f_mpq_cq__backtick_3E_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3E_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3E(INT32 args) {
#line 861 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 861 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`>",args,1);
#line 861 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 863 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "Gmp.mpq->`>", 1, args)) > 0); pop_stack(); push_int(ret_); return; }while(0);
#line 865 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `<(mixed q)
   */
  #define f_mpq_cq__backtick_3C_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3C_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3C(INT32 args) {
#line 869 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 869 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`<",args,1);
#line 869 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 871 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "Gmp.mpq->`<", 1, args)) < 0); pop_stack(); push_int(ret_); return; }while(0);
#line 873 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `>=(mixed q)
   */
  #define f_mpq_cq__backtick_3E_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3E_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3E_eq(INT32 args) {
#line 877 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 877 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`>=",args,1);
#line 877 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 879 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "Gmp.mpq->`>=", 1, args)) >= 0); pop_stack(); push_int(ret_); return; }while(0);
#line 881 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `<=(mixed q)
   */
  #define f_mpq_cq__backtick_3C_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3C_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3C_eq(INT32 args) {
#line 885 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 885 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`<=",args,1);
#line 885 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 887 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "Gmp.mpq->`<=", 1, args)) <= 0); pop_stack(); push_int(ret_); return; }while(0);
#line 889 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}


  }
/*! @decl static int(0..1) `==(mixed q)
   */
  #define f_mpq_cq__backtick_eq_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_eq_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_eq_eq(INT32 args) {
#line 894 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 894 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`==",args,1);
#line 894 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 896 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    MP_RAT *arg=get_mpq(q, 0, NULL, 0, 0);
    do { INT_TYPE ret_=(arg && !mpq_cmp(THISMPQ, arg)); pop_stack(); push_int(ret_); return; }while(0);
#line 899 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `!=(mixed q)
   */
  #define f_mpq_cq__backtick_21_eq_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_21_eq_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_21_eq(INT32 args) {
#line 903 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 903 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`!=",args,1);
#line 903 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 905 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    MP_RAT *arg=get_mpq(q, 0, NULL, 0, 0);
    do { INT_TYPE ret_=(!(arg && !mpq_cmp(THISMPQ, arg))); pop_stack(); push_int(ret_); return; }while(0);
#line 908 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl int(-1..1) sgn()
   */
  #define f_mpq_sgn_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_sgn_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_sgn(INT32 args) {
#line 912 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("sgn",args,0);
{
      do { INT_TYPE ret_=(mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 915 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl static int(0..1) `!(mixed q)
   */
  #define f_mpq_cq__backtick_21_defined
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_21_fun_num = 0;
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_21(INT32 args) {
#line 919 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 921 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(!mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 923 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

  }

#undef internal_init_mpq_defined
#define internal_init_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void init_mpq_struct(void)
#line 926 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_init(THISMPQ);
    }
  
  
#undef internal_exit_mpq_defined
#define internal_exit_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void exit_mpq_struct(void)
#line 936 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_clear(THISMPQ);
    }

  
#undef internal_gc_recurse_mpq_defined
#define internal_gc_recurse_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void gc_recurse_mpq_struct(void)
#line 945 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
{
    if (mc_count_bytes (Pike_fp->current_object))
      mc_counted_bytes +=
#ifdef MPZ_T_HAS__MP_ALLOC
	mpq_numref (THISMPQ)[0]._mp_alloc * sizeof (mp_limb_t) +
	mpq_denref (THISMPQ)[0]._mp_alloc * sizeof (mp_limb_t) +
#else
	mpz_size (mpq_numref (THISMPQ)) * sizeof (mp_limb_t) +
	mpz_size (mpq_denref (THISMPQ)) * sizeof (mp_limb_t) +
#endif
	sizeof (mpq_t);
  }

#ifdef mpq_event_handler_defined
static void mpq_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_mpq_defined
  case PROG_EVENT_INIT: init_mpq_struct(); break;

#endif /* internal_init_mpq_defined */

#ifdef internal_exit_mpq_defined
  case PROG_EVENT_EXIT: exit_mpq_struct(); break;

#endif /* internal_exit_mpq_defined */

#ifdef internal_gc_recurse_mpq_defined
  case PROG_EVENT_GC_RECURSE: gc_recurse_mpq_struct(); break;

#endif /* internal_gc_recurse_mpq_defined */
  default: break; 
  }
}

#endif /* mpq_event_handler_defined */
/*! @endclass
 */

/*! @endmodule
 */

#line 965 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
#endif /* USE_GMP */


void pike_init_mpq_module(void)
{
  
#ifdef class_mpq_defined

#ifdef PROG_MPQ_ID
#line 64 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  START_NEW_PROGRAM_ID(MPQ);
#else
#line 64 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  start_new_program();

#endif /* PROG_MPQ_ID */

#ifndef tObjImpl_MPQ

#undef tObjImpl_MPQ
#define tObjImpl_MPQ tObj

#endif /* tObjImpl_MPQ */

#ifdef THIS_MPQ
  mpq_storage_offset = ADD_STORAGE(struct mpq_struct);
#endif /* THIS_MPQ */

#ifdef mpq_event_handler_defined
  pike_set_prog_event_callback(mpq_event_handler);

#ifndef mpq_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* mpq_gc_live_obj */

#endif /* mpq_event_handler_defined */

#ifdef f_mpq_create_defined
  f_mpq_create_fun_num =
#line 278 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("create", f_mpq_create, tOr3(tFunc(tOr5(tVoid,tString,"\10\200\0\0\0\177\377\377\377",tFloat,tObj),tVoid),tFunc(tString "\10\200\0\0\0\177\377\377\377",tVoid),tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_create_defined */

#ifdef f_mpq_get_int_defined
  f_mpq_get_int_fun_num =
#line 334 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_int", f_mpq_get_int, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_int_defined */

#ifdef f_mpq_cq___hash_defined
  f_mpq_cq___hash_fun_num =
#line 349 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("__hash", f_mpq_cq___hash, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq___hash_defined */

#ifdef f_mpq_get_float_defined
  f_mpq_get_float_fun_num =
#line 359 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_float", f_mpq_get_float, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_float_defined */

#ifdef f_mpq_get_string_defined
  f_mpq_get_string_fun_num =
#line 366 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_string", f_mpq_get_string, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_string_defined */

#ifdef f_mpq_cq__sprintf_defined
  f_mpq_cq__sprintf_fun_num =
#line 398 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("_sprintf", f_mpq_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__sprintf_defined */

#ifdef f_mpq_cq__is_type_defined
  f_mpq_cq__is_type_fun_num =
#line 471 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("_is_type", f_mpq_cq__is_type, tFunc(tString,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__is_type_defined */

#ifdef f_mpq_cast_defined
  f_mpq_cast_fun_num =
#line 480 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("cast", f_mpq_cast, tFunc(tString,tOr4("\10\200\0\0\0\177\377\377\377",tString,tFloat,tObj)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cast_defined */

#ifdef f_mpq_cq__backtick_add_defined
  f_mpq_cq__backtick_add_fun_num =
#line 540 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`+", f_mpq_cq__backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_defined */

#ifdef f_mpq_cq__backtick_backtick_add_defined
  f_mpq_cq__backtick_backtick_add_fun_num =
#line 557 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``+", f_mpq_cq__backtick_backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_add_defined */

#ifdef f_mpq_cq__backtick_add_eq_defined
  f_mpq_cq__backtick_add_eq_fun_num =
#line 574 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`+=", f_mpq_cq__backtick_add_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_eq_defined */

#ifdef f_mpq_cq__backtick_2A_defined
  f_mpq_cq__backtick_2A_fun_num =
#line 643 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`*", f_mpq_cq__backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2A_defined */

#ifdef f_mpq_cq__backtick_backtick_2A_defined
  f_mpq_cq__backtick_backtick_2A_fun_num =
#line 658 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``*", f_mpq_cq__backtick_backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2A_defined */

#ifdef f_mpq_cq__backtick_2A_eq_defined
  f_mpq_cq__backtick_2A_eq_fun_num =
#line 673 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`*=", f_mpq_cq__backtick_2A_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2A_eq_defined */

#ifdef f_mpq_cq__backtick_2D_defined
  f_mpq_cq__backtick_2D_fun_num =
#line 683 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`-", f_mpq_cq__backtick_2D, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2D_defined */

#ifdef f_mpq_cq__backtick_backtick_2D_defined
  f_mpq_cq__backtick_backtick_2D_fun_num =
#line 709 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``-", f_mpq_cq__backtick_backtick_2D, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2D_defined */

#ifdef f_mpq_cq__backtick_2F_defined
  f_mpq_cq__backtick_2F_fun_num =
#line 721 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`/", f_mpq_cq__backtick_2F, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2F_defined */

#ifdef f_mpq_cq__backtick_backtick_2F_defined
  f_mpq_cq__backtick_backtick_2F_fun_num =
#line 741 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``/", f_mpq_cq__backtick_backtick_2F, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2F_defined */

#ifdef f_mpq_cq__backtick_25_defined
  f_mpq_cq__backtick_25_fun_num =
#line 760 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`%", f_mpq_cq__backtick_25, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_25_defined */

#ifdef f_mpq_cq__backtick_backtick_25_defined
  f_mpq_cq__backtick_backtick_25_fun_num =
#line 802 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``%", f_mpq_cq__backtick_backtick_25, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_25_defined */

#ifdef f_mpq_invert_defined
  f_mpq_invert_fun_num =
#line 835 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("invert", f_mpq_invert, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_invert_defined */

#ifdef f_mpq_cq__backtick_7E_defined
  f_mpq_cq__backtick_7E_fun_num =
#line 848 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`~", f_mpq_cq__backtick_7E, tFunc(tNone,tObj), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_7E_defined */

#ifdef f_mpq_cq__backtick_3E_defined
  f_mpq_cq__backtick_3E_fun_num =
#line 861 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`>", f_mpq_cq__backtick_3E, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3E_defined */

#ifdef f_mpq_cq__backtick_3C_defined
  f_mpq_cq__backtick_3C_fun_num =
#line 869 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`<", f_mpq_cq__backtick_3C, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3C_defined */

#ifdef f_mpq_cq__backtick_3E_eq_defined
  f_mpq_cq__backtick_3E_eq_fun_num =
#line 877 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`>=", f_mpq_cq__backtick_3E_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3E_eq_defined */

#ifdef f_mpq_cq__backtick_3C_eq_defined
  f_mpq_cq__backtick_3C_eq_fun_num =
#line 885 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`<=", f_mpq_cq__backtick_3C_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3C_eq_defined */

#ifdef f_mpq_cq__backtick_eq_eq_defined
  f_mpq_cq__backtick_eq_eq_fun_num =
#line 894 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`==", f_mpq_cq__backtick_eq_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_eq_eq_defined */

#ifdef f_mpq_cq__backtick_21_eq_defined
  f_mpq_cq__backtick_21_eq_fun_num =
#line 903 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`!=", f_mpq_cq__backtick_21_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_21_eq_defined */

#ifdef f_mpq_sgn_defined
  f_mpq_sgn_fun_num =
#line 912 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("sgn", f_mpq_sgn, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_sgn_defined */

#ifdef f_mpq_cq__backtick_21_defined
  f_mpq_cq__backtick_21_fun_num =
#line 919 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`!", f_mpq_cq__backtick_21, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_21_defined */
#line 64 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  mpq_program=end_program();
#line 64 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
  mpq_program_fun_num=add_program_constant("mpq",mpq_program,0);

#endif /* class_mpq_defined */
#line 971 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

void pike_exit_mpq_module(void)
{
  
#ifdef class_mpq_defined
  if(mpq_program) {
#line 64 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
    free_program(mpq_program);
    mpq_program=0;
  }

#endif /* class_mpq_defined */
#line 976 "/home/zino/hack-local/Pike/7.8-distmaker/src/modules/Gmp/mpq.cmod"
}

