#line 1 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
#include "global.h"
RCSID("$Id: libbzip2mod.cmod,v 1.15 2005/03/22 16:56:53 grubba Exp $");
#include "interpret.h"
#include "svalue.h"
#include "stralloc.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "threads.h"
#include "dynamic_buffer.h"
#include "module_support.h"
#include "builtin_functions.h"
#include "libbzip2mod_config.h"

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_BZLIB_H
#include <bzlib.h>
#endif

/* These constants are the default values that
   are sent to a Bz2 stream when it is initialized */
#define DEFAULT_COMPRESSION_RATE 9
#define DEFAULT_WORK_FACTOR 30

/* Constants used when keeping track of
   the open mode of a file. They are added
   only to make the code more easy to read */
#define NO_FILE_MODE 0
#define READ_MODE 1
#define WRITE_MODE 2


/* The initial amount of bytes that are allocated
   as for deflate/inflate when memory is needed */
#define DEFL_BUF_SIZE 500000
#define INFL_BUF_SIZE 500000


/* Why use double prefixes? */
#ifdef HAVE_BZ2_BZCOMPRESSINIT
#define bzCompressInit		BZ2_bzCompressInit
#define bzCompress		BZ2_bzCompress
#define bzCompressEnd		BZ2_bzCompressEnd
#define bzDecompressInit	BZ2_bzDecompressInit
#define bzDecompress		BZ2_bzDecompress
#define bzDecompressEnd		BZ2_bzDecompressEnd
#define bzReadOpen		BZ2_bzReadOpen
#define bzReadClose		BZ2_bzReadClose
#define bzRead			BZ2_bzRead
#define bzWriteOpen		BZ2_bzWriteOpen
#define bzWrite			BZ2_bzWrite
#define bzWriteClose		BZ2_bzWriteClose

#endif

#ifdef HAVE_BZ_STREAM_TOTAL_OUT
#define TOTAL_OUT(S) ((S)->total_out)
#else
/* use 64 bit counting struct */
#define TOTAL_OUT(S) \
    ((S)->total_out_lo32 + (((INT64)(S)->total_out_hi32) << 32))
#endif

/*! @module Bz2
 *!
 *! The Bz2 module contains functions to compress and uncompress strings using
 *! the same algorithm as the program @tt{bzip2@}. Compressing and decompressing
 *! can be done in streaming mode feeding the compress and decompress objects 
 *! with arbitrarily large pieces of data.
 *! The Bz2 module consists of three classes; Bz2.Deflate,Bz2.Inflate. and Bz2.File
 *! Bz2.Deflate is used to compress data
 *! and Bz2.Inflate is used to uncompress data. (Think "inflatable boat")
 *! Bz2.File is used to handle Bzip2 files.
 *! @note
 *!   Note that this module is only available if libbzip2 was
 *!   available when Pike was compiled.
 *!
 *!   Note that although the functions in Inflate and Deflate use the same @i{algorithm@} as
 *!   @tt{bzip2@}, they do not use the exact same format, so you can not directly
 *!   zip files or unzip zip-files using those functions. That is why there exists a third 
 *!   class for files.
 */

/*! @class Deflate
 *!
 *! Bz2.Deflate is a builtin program written in C. It interfaces the
 *! packing routines in the bzlib library.
 *!
 *! @note
 *! This program is only available if libz was available and found when
 *! Pike was compiled.
 *!
 *! @seealso
 *! @[Bz2.Inflate()]
 */

#ifdef HAVE_BZ2LIB
#ifdef HAVE_BZLIB_H

#undef class_Deflate_defined
#define class_Deflate_defined
struct program *Deflate_program=NULL;
static int Deflate_program_fun_num=-1;

#undef var_intern_buffer_Deflate_defined
#define var_intern_buffer_Deflate_defined

#undef var_internbuf_Deflate_defined
#define var_internbuf_Deflate_defined

#undef var_strm_Deflate_defined
#define var_strm_Deflate_defined

#undef var_total_out_previous_flush_Deflate_defined
#define var_total_out_previous_flush_Deflate_defined

#undef var_total_out_previous_buf_Deflate_defined
#define var_total_out_previous_buf_Deflate_defined

#undef var_compression_rate_Deflate_defined
#define var_compression_rate_Deflate_defined

#undef var_work_factor_Deflate_defined
#define var_work_factor_Deflate_defined

#undef THIS
#define THIS ((struct Deflate_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_DEFLATE
#define THIS_DEFLATE ((struct Deflate_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_DEFLATE
#define OBJ2_DEFLATE(o) ((struct Deflate_struct *)(o->storage+Deflate_storage_offset))

#undef GET_DEFLATE_STORAGE
#define GET_DEFLATE_STORAGE ((struct Deflate_struct *)(o->storage+Deflate_storage_offset)
static ptrdiff_t Deflate_storage_offset;
struct Deflate_struct {

#ifdef var_intern_buffer_Deflate_defined
#line 111 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
dynamic_buffer intern_buffer;
#endif /* var_intern_buffer_Deflate_defined */

#ifdef var_internbuf_Deflate_defined
#line 112 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
dynamic_buffer *internbuf;
#endif /* var_internbuf_Deflate_defined */

#ifdef var_strm_Deflate_defined
#line 113 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
bz_stream strm;
#endif /* var_strm_Deflate_defined */

#ifdef var_total_out_previous_flush_Deflate_defined
#line 114 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int total_out_previous_flush;
#endif /* var_total_out_previous_flush_Deflate_defined */

#ifdef var_total_out_previous_buf_Deflate_defined
#line 115 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int total_out_previous_buf;
#endif /* var_total_out_previous_buf_Deflate_defined */

#ifdef var_compression_rate_Deflate_defined
#line 116 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int compression_rate;
#endif /* var_compression_rate_Deflate_defined */

#ifdef var_work_factor_Deflate_defined
#line 117 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int work_factor;
#endif /* var_work_factor_Deflate_defined */
};
/*! @decl void create(int(1..9)|void compression, int|void work)
   *!	
   *! If given, @[compression] should be a number from 1 to 9 indicating the
   *! block size used when doing compression. The actual block size will
   *! be a 100000 times this number. Low numbers are considered 'fast',
   *! higher numbers are considered 'slow' but give better packing.
   *! The parameter is set to @tt{9@} if it is omitted.
   *!
   *! This function can also be used to re-initialize a Bz2.Deflate object
   *! so it can be re-used.
   */

  #define f_Deflate_create_defined
ptrdiff_t f_Deflate_create_fun_num = 0;
void f_Deflate_create(INT32 args) {
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * compression;
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * work;
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
if (args > 0) {
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",1,"int|void");
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
compression=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else compression=0;
if (args > 1) {
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",2,"int|void");
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
work=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else work=0;
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    int compression_rate = DEFAULT_COMPRESSION_RATE;
    int work_factor = DEFAULT_WORK_FACTOR;
    int retval;
    bz_stream *s;
    
    switch(args){
    case 0: 
      break;
    case 1:
      if(compression->type != T_INT){
	Pike_error("Wrong type of argument 1 in call to Bz2.Deflate()");
      }
      compression_rate = compression->u.integer;
      break;
    case 2:
      if(work->type != T_INT){
	Pike_error("Wrong type of argument 2 in call to Bz2.Deflate()");
      }
      compression_rate = compression->u.integer;
      work_factor = work->u.integer;
      break;
    default: 
      Pike_error("Wrong number of arguments in call to Bz2.Deflate()");
    
    }
    if(work_factor < 1 || work_factor > 250){
      Pike_error("work_factor out of range for Bz2.Deflate()");
    }

    if(compression_rate < 1 || compression_rate > 9){
      Pike_error("compression_rate out of range for Bz2.Deflate()");
    }
  
    s = &(THIS->strm);

    if(THIS->internbuf != NULL){
      toss_buffer(&(THIS->intern_buffer));
      THIS->internbuf = NULL;
      bzCompressEnd(s);
    }
    
    s->bzalloc = NULL;
    s->bzfree = NULL;
    s->opaque = NULL;
    s->next_in = NULL;
    s->next_out = NULL;
    s->avail_in = 0;
    s->avail_out = 0;

    THIS->total_out_previous_flush = 0;
    THIS->total_out_previous_buf = 0;
    THIS->compression_rate = compression_rate;
    THIS->work_factor = work_factor;
    
    retval = bzCompressInit(s,compression_rate,0,work_factor);  
    
    switch(retval){
    case BZ_PARAM_ERROR:
      Pike_error("Parameter error when initializing Bz2.Deflate object");
      break;
    case BZ_MEM_ERROR:
      Pike_error("Memory error when initialing Bz2.Deflate object");
      break;
    case BZ_OK:
      break;
    default:
      Pike_error("Failed to initialize Bz2.Deflate object");
    }
    pop_n_elems(args);
  }
  }
#line 202 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
/***********************************************************************************/

  /*! @decl void feed(string data)
   *!	
   *! This function feeds the data to the internal buffers of 
   *! the Deflate object. All data is buffered until a read or
   *! a finish is done.
   *! @seealso
   *! @[Bz2.Deflate->read()]
   *! @[Bz2.Deflate->finish()]
   */
  
  #define f_Deflate_feed_defined
ptrdiff_t f_Deflate_feed_fun_num = 0;
void f_Deflate_feed(INT32 args) {
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("feed",args,1);
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("feed",1,"string");
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{

    int retval = 0;
    int i = 1; 
    bz_stream *s;
    char* tmp = NULL;
    
    /* I think CMOD is weird here, or shall we say inconsequent
       since it does the type checking for string but not for
       int|void */
    if(args != 1){
      Pike_error("Bad number of arguments in call to Bz2.Deflate->feed()");
    }
        
    if (THIS->internbuf==NULL){
      /*initialize the internal buffer needed, because libbzip2 is weird*/
      initialize_buf(&(THIS->intern_buffer));
      THIS->internbuf = &(THIS->intern_buffer);
    }
    
    
    s = &(THIS->strm);
    s->next_in=(char *)data->str;
    s->avail_in = data->len;
    
    
    while(1){
      /* need to have a loop here in 
	 case the output-buffer is filled*/
      /* allocate out buffer */
      tmp = malloc(i * DEFL_BUF_SIZE);
      if(tmp == NULL){
	Pike_error("Failed to allocate memory in Bz2.Deflate->feed()");
      }
      s->next_out = tmp;
      s->avail_out = i * DEFL_BUF_SIZE;
      
      retval = bzCompress(s, BZ_RUN);
      if (retval != BZ_RUN_OK){
	bzCompressEnd(s);
	free(tmp);
	Pike_error("Error when compressing in Bz2.feed()");
      }
      
      if(TOTAL_OUT(s) - THIS->total_out_previous_buf > 0){
	/*if something was written to the outbuffer, then buffer it internally*/
	low_my_binary_strcat(tmp, TOTAL_OUT(s) - THIS->total_out_previous_buf,&(THIS->intern_buffer));
	THIS->internbuf = &(THIS->intern_buffer);
	THIS->total_out_previous_buf = TOTAL_OUT(s);
      }
      /*free the outbuffer*/
      free(tmp);
      if (s->avail_out > 0 || s->avail_in == 0){
	break;
      }
      i = 2 * i;
    }
    pop_n_elems(args);
    
  }
  
  }
#line 275 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
void do_deflate(struct pike_string *data, dynamic_buffer *retbuf,
		  int mode, INT32 args){
    char *tmp = NULL;
    int retval;
    int total_out_old = 0;
    int i = 1;
    
    bz_stream *s;
    
    s = &(THIS->strm);
    
    s->next_in = data->str;
    s->avail_in = data->len;
    s->next_out = retbuf->s.str;
    s->avail_out = DEFL_BUF_SIZE;
    
    while(1){    
      retval = bzCompress(s, mode);
    
      if(tmp != NULL){
	low_my_binary_strcat(tmp, TOTAL_OUT(s)-total_out_old, retbuf);
	free(tmp);
      }
      if(retval < 0){
#if 0
	fprintf(stderr,"\nRetval is %d", retval); 
#endif /* 0 */
	bzCompressEnd(s);
	Pike_error("Error when compressing data");
      }
      /* If all data has been finished or flushed then end this loop*/
      if(retval == BZ_STREAM_END || ((retval == BZ_RUN_OK)&&(s->avail_in == 0))){
	break;
      }
      /* If the output buffer is full, then allocate more space
	 and go on compressing*/
      if (s->avail_out == 0){
	i = 2 * i;
	tmp = malloc(i * DEFL_BUF_SIZE);
	if(tmp == NULL){
	  Pike_error("Failed to allocate memory in Bz2.Deflate->read()/finish()");
	}
	s->next_out = tmp;
	s->avail_out = i * DEFL_BUF_SIZE;
	total_out_old = TOTAL_OUT(s);
      }
    }
  }
  
  /*! @decl string read(string data)
   *!
   *! This function feeds the data to the internal buffers of 
   *! the Deflate object. Then it compresses all buffered data
   *! and returns the compressed data as a string
   *! @seealso
   *! @[Bz2.Deflate->feed()]
   *! @[Bz2.Deflate->finish()]
   */

  #define f_Deflate_read_defined
ptrdiff_t f_Deflate_read_fun_num = 0;
void f_Deflate_read(INT32 args) {
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("read",args,1);
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("read",1,"string");
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    struct pike_string *retstr;
    dynamic_buffer retbuf;
    bz_stream *s;
    ONERROR err;

    s = &(THIS->strm);
    
    initialize_buf(&retbuf);
    SET_ONERROR(err, toss_buffer, &retbuf);

    low_make_buf_space(DEFL_BUF_SIZE, &retbuf);
    do_deflate(data, &retbuf, BZ_FLUSH, args);
    
    if(TOTAL_OUT(s) - THIS->total_out_previous_flush > 0){
      if(THIS->total_out_previous_buf > THIS->total_out_previous_flush){
	low_my_binary_strcat(retbuf.s.str,
			     TOTAL_OUT(s) - THIS->total_out_previous_buf,
			     &(THIS->intern_buffer));
	retstr =
	  make_shared_binary_string(THIS->intern_buffer.s.str,
				    TOTAL_OUT(s) - THIS->total_out_previous_flush);
      }   
      else{
	retstr =
	  make_shared_binary_string(retbuf.s.str,
				    TOTAL_OUT(s)-THIS->total_out_previous_flush);
      }
      if(THIS->internbuf != NULL){
	toss_buffer(&THIS->intern_buffer);
	THIS->internbuf = NULL;
      }     
      THIS->total_out_previous_flush = TOTAL_OUT(s);
      THIS->total_out_previous_buf = TOTAL_OUT(s);
    }
    else{
      retstr = make_shared_binary_string("",0);
    }
    
    CALL_AND_UNSET_ONERROR(err);

    do { struct pike_string * ret_=((retstr)); pop_stack(); push_string(ret_); return; }while(0);
#line 376 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  

  }
/*! @decl string finish(string data)
   *!
   *! This method feeds the data to the internal buffers of 
   *! the Deflate object. Then it compresses all buffered data
   *! adds a end of data marker ot it, returns the compressed 
   *! data as a string, and reinitializes the deflate object.
   *! @seealso
   *! @[Bz2.Deflate->feed()]
   *! @[Bz2.Deflate->read()]
   */
  
  #define f_Deflate_finish_defined
ptrdiff_t f_Deflate_finish_fun_num = 0;
void f_Deflate_finish(INT32 args) {
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("finish",args,1);
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("finish",1,"string");
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    struct pike_string *retstr;
    int retval = 0;
    dynamic_buffer retbuf;
    ONERROR err;
    
    bz_stream *s;
    s = &(THIS->strm);
    initialize_buf(&retbuf);
    SET_ONERROR(err, toss_buffer, &retbuf);

    low_make_buf_space(DEFL_BUF_SIZE, &retbuf);
    
    do_deflate(data, &retbuf, BZ_FINISH, args);
        
    /*use perhaps a better check?*/
    if(TOTAL_OUT(s) - THIS->total_out_previous_flush > 0){
      if(THIS->total_out_previous_buf > THIS->total_out_previous_flush){
	low_my_binary_strcat(retbuf.s.str,
			     TOTAL_OUT(s) - THIS->total_out_previous_buf,
			     &(THIS->intern_buffer));
	retstr =
	  make_shared_binary_string(THIS->intern_buffer.s.str,
				    TOTAL_OUT(s) - THIS->total_out_previous_flush);
      }   
      else{
	retstr =
	  make_shared_binary_string(retbuf.s.str,
				    TOTAL_OUT(s) - THIS->total_out_previous_flush);
      }
      
      THIS->total_out_previous_flush = TOTAL_OUT(s);
      THIS->total_out_previous_buf = TOTAL_OUT(s);
    }
    else{
      /* something went wrong*/
      retstr = NULL;
    }
    
    CALL_AND_UNSET_ONERROR(err);

    bzCompressEnd(s);
    
    if(THIS->internbuf != NULL){
      toss_buffer(THIS->internbuf);
      THIS->internbuf = NULL;
    }
    
    s->bzalloc = NULL;
    s->bzfree = NULL;
    s->opaque = NULL;
    s->next_in = NULL;
    s->next_out = NULL;
    s->avail_in = 0;
    s->avail_out = 0;

    THIS->total_out_previous_flush = 0;
    THIS->total_out_previous_buf = 0;
        
    retval = bzCompressInit(s,THIS->compression_rate,0,THIS->work_factor);  
    if(retval < 0){
      Pike_error("Failed to reinitialize stream");
    }

    if(retstr != NULL){
      do { struct pike_string * ret_=((retstr)); pop_stack(); push_string(ret_); return; }while(0);
#line 456 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    else{
      do { struct pike_string * ret_=((0)); pop_stack(); push_string(ret_); return; }while(0);
#line 459 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  }

  }
/*! @decl string deflate(string data, int(0..2)|void flush_mode)
   *!
   *! This function performs bzip2 style compression on a string @[data] and
   *! returns the packed data. Streaming can be done by calling this
   *! function several times and concatenating the returned data.
   *!
   *! The optional argument @[flush_mode] should be one of the following:
   *! @int
   *!   @value Bz2.BZ_RUN
   *!     Runs Bz2.Deflate->feed()
   *!   @value Bz2.BZ_FLUSH
   *!     Runs Bz2.Deflate->read()
   *!   @value Bz2.BZ_FINISH
   *!     Runs Bz2.Deflate->finish()
   *! @endint
   *!
   *! @seealso
   *! @[Bz2.Inflate->inflate()]
   */
  
  #define f_Deflate_deflate_defined
ptrdiff_t f_Deflate_deflate_fun_num = 0;
void f_Deflate_deflate(INT32 args) {
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * mode;
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args < 1) wrong_number_of_args_error("deflate",args,1);
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args > 2) wrong_number_of_args_error("deflate",args,2);
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("deflate",1,"string");
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-args].u.string);
if (args > 1) {
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("deflate",2,"int|void");
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
mode=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else mode=0;
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    struct pike_string *data;
    int flush_mode;
    
    switch (args){
    case 0:
      Pike_error("Too few arguments to method Deflate->deflate()"); 
      break; 
    case 1:
      flush_mode = BZ_FLUSH;
      break;
    case 2:
    if(mode->type == T_INT){
      flush_mode = mode->u.integer;
    }
    else{
      Pike_error("Bad argument 2 in call to Bz2.Deflate->deflate()");
    }
    pop_n_elems(1);
    break;
    default:
      Pike_error("Too many arguments to method Deflate->deflate()");
      break;
    }
    
    switch (flush_mode){
    case BZ_FLUSH:
      f_Deflate_read(1);
      break;
    case BZ_FINISH:
      f_Deflate_finish(1);
      break;
    case BZ_RUN:
      f_Deflate_feed(1);
      push_constant_text("");
      break;
    }
  }

  }

#undef internal_init_Deflate_defined
#define internal_init_Deflate_defined

#undef Deflate_event_handler_defined
#define Deflate_event_handler_defined
static void init_Deflate_struct(void)
#line 522 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      bz_stream *s;
      THIS->internbuf = NULL;
      s =&(THIS->strm);
      s->bzalloc = NULL;
      s->bzfree = NULL;
      s->opaque = NULL;
      s->next_in = NULL;
      s->next_out = NULL;
      s->avail_in = 0;
      s->avail_out = 0;
    }
  
#undef internal_exit_Deflate_defined
#define internal_exit_Deflate_defined

#undef Deflate_event_handler_defined
#define Deflate_event_handler_defined
static void exit_Deflate_struct(void)
#line 535 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      bzCompressEnd(&(THIS->strm));
      if(THIS->internbuf != NULL){
	toss_buffer(&(THIS->intern_buffer));
      }
    }  

#ifdef Deflate_event_handler_defined
static void Deflate_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Deflate_defined
  case PROG_EVENT_INIT: init_Deflate_struct(); break;

#endif /* internal_init_Deflate_defined */

#ifdef internal_exit_Deflate_defined
  case PROG_EVENT_EXIT: exit_Deflate_struct(); break;

#endif /* internal_exit_Deflate_defined */
  default: break; 
  }
}

#endif /* Deflate_event_handler_defined */
/*! @endclass
 */


/*! @class Inflate
 *!
 *! Bz2.Inflate is a builtin program written in C. It interfaces the
 *! unpacking routines in the libz library.
 *!
 *! @note
 *! This program is only available if bzlib was available and found when
 *! Pike was compiled.
 *!
 *! @seealso
 *!   @[Deflate]
 */




#undef class_Inflate_defined
#define class_Inflate_defined
struct program *Inflate_program=NULL;
static int Inflate_program_fun_num=-1;

#undef var_intern_buffer_Inflate_defined
#define var_intern_buffer_Inflate_defined

#undef var_internbuf_Inflate_defined
#define var_internbuf_Inflate_defined

#undef var_strm_Inflate_defined
#define var_strm_Inflate_defined

#undef var_total_out_previous_flush_Inflate_defined
#define var_total_out_previous_flush_Inflate_defined

#undef var_total_out_previous_buf_Inflate_defined
#define var_total_out_previous_buf_Inflate_defined

#undef THIS
#define THIS ((struct Inflate_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_INFLATE
#define THIS_INFLATE ((struct Inflate_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_INFLATE
#define OBJ2_INFLATE(o) ((struct Inflate_struct *)(o->storage+Inflate_storage_offset))

#undef GET_INFLATE_STORAGE
#define GET_INFLATE_STORAGE ((struct Inflate_struct *)(o->storage+Inflate_storage_offset)
static ptrdiff_t Inflate_storage_offset;
struct Inflate_struct {

#ifdef var_intern_buffer_Inflate_defined
#line 565 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
dynamic_buffer intern_buffer;
#endif /* var_intern_buffer_Inflate_defined */

#ifdef var_internbuf_Inflate_defined
#line 566 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
dynamic_buffer *internbuf;
#endif /* var_internbuf_Inflate_defined */

#ifdef var_strm_Inflate_defined
#line 567 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
bz_stream strm;
#endif /* var_strm_Inflate_defined */

#ifdef var_total_out_previous_flush_Inflate_defined
#line 568 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int total_out_previous_flush;
#endif /* var_total_out_previous_flush_Inflate_defined */

#ifdef var_total_out_previous_buf_Inflate_defined
#line 569 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int total_out_previous_buf;
#endif /* var_total_out_previous_buf_Inflate_defined */
};
/*! @decl void create()
   */
  #define f_Inflate_create_defined
ptrdiff_t f_Inflate_create_fun_num = 0;
void f_Inflate_create(INT32 args) {
#line 573 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
#line 573 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
     
    int retval;
    bz_stream *s;
    
    if(args > 0){
      Pike_error("Bz2.Inflate() should be called with NO arguments");
    }
    s = &(THIS->strm);
    
    if(THIS->internbuf != NULL){
      toss_buffer(&(THIS->intern_buffer));
      THIS->internbuf = NULL;
      bzDecompressEnd(s);
    }
    
    s->bzalloc = NULL;
    s->bzfree = NULL;
    s->opaque = NULL;
    
    retval = bzDecompressInit(s, 0, 0);
   
    /* make more detailed*/
    if(retval != BZ_OK){
      Pike_error("Unexpected error in Bz2.Inflate()");
    }
    
    s->next_in = NULL;
    s->next_out = NULL;
    s->avail_in = 0;
    s->avail_out = 0;
    
    
    /*reset the counted bytes*/
    THIS->total_out_previous_flush = 0;
    pop_n_elems(args);
  }

  }
/*! @decl string inflate(string data)
   *!
   *! This function performs bzip2 style decompression. It can do
   *! decompression with arbitrarily large pieces of data. When fed with 
   *! data, it decompresses as much as it can and buffers the rest.
   *! @example
   *! while(..){
   *!   foo = compressed_data[i..i+9]; 
   *!   uncompressed_concatenated_data += inflate_object->inflate(foo);
   *!   i = i+10;
   *! }
   *!
   *! @seealso
   *! @[Bz2.Deflate->deflate()]
   */
  
  #define f_Inflate_inflate_defined
ptrdiff_t f_Inflate_inflate_fun_num = 0;
void f_Inflate_inflate(INT32 args) {
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("inflate",args,1);
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("inflate",1,"string");
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    struct pike_string *retstr;
    int i = 1;
    int retval=0;
    int total_out_old = 0;
    char *tmp = NULL;
    char *tmp_internbuf = NULL;
    dynamic_buffer ret_buffer;
    dynamic_buffer *retbuf = &ret_buffer;
    bz_stream *s;
    s = &(THIS->strm);
    
    /*the incoming string has to be appended to the input buffer*/
    
    if (s->avail_in > 0){
      tmp_internbuf = malloc(s->avail_in);
      if(tmp_internbuf == NULL){
	Pike_error("Failed to allocate memory in Bz2.Inflate->inflate()");
      }
      bcopy(s->next_in, tmp_internbuf, s->avail_in);
    }
    /* free buf space*/
    if(THIS->internbuf != NULL){
      toss_buffer(&(THIS->intern_buffer));
    }
    initialize_buf(&(THIS->intern_buffer));
    
    if(tmp_internbuf != NULL){
      /*copying data that could not be unpacked in previous call*/
      low_my_binary_strcat(tmp_internbuf,s->avail_in,&(THIS->intern_buffer));
      free(tmp_internbuf);
    }
    /*appending the new data*/
    low_my_binary_strcat(data->str,data->len,&(THIS->intern_buffer));
    
    THIS->internbuf = &(THIS->intern_buffer);
    s->next_in = THIS->internbuf->s.str;
    s->avail_in += data->len;
    
    /* the input buffer is now provided, provide an output buffer*/
    
    initialize_buf(retbuf);
    
    low_make_buf_space(INFL_BUF_SIZE, retbuf);
    s->next_out = retbuf->s.str;
    s->avail_out = INFL_BUF_SIZE;
    
    while(1){
      /* This Loop runs bzDecompress and stores the result in retbuf, if retbuf is filled
	 it makes retbuf bigger and calls decompress again until the whole input data string 
	 has been unpacked*/
      retval = bzDecompress(s); /* updates next_in, avail_in, total_in, next_out, avail_out, total_out*/
      
      if(tmp != NULL){
	low_my_binary_strcat(tmp,TOTAL_OUT(s)-total_out_old,&ret_buffer);
	free(tmp);
      }
      /* errorcheck*/
      if(retval == BZ_STREAM_END && s->avail_in > 0){
	bzDecompressEnd(s);
	toss_buffer(&ret_buffer);
	Pike_error("No data may follow after end of stream"); 
      }
      if((retval != BZ_STREAM_END) && (retval != BZ_OK)){
	bzDecompressEnd(s);
	toss_buffer(&ret_buffer);
	Pike_error("Error when decompressing, probably because inflate is fed with invalid data");
      }    
      
      /* If outputbuffer is not full, or input buffer is empty, or end of stream has been detected
	 then compression has been done as far as possible*/
      if((s->avail_out > 0) || (s->avail_in == 0) || (retval == BZ_STREAM_END)){
	break;
      }
      /* If output buffer is full then allocate more output space and call
	 bzDecompress again*/
      if (s->avail_out == 0){
	i = i*2;
	tmp = malloc(i * INFL_BUF_SIZE);
	if(tmp == NULL){
	  toss_buffer(&ret_buffer);
	  Pike_error("Failed to allocate memory in Bz2.Inflate->inflate()");
	}
	s->next_out = tmp;
	s->avail_out = i * INFL_BUF_SIZE;
	total_out_old = TOTAL_OUT(s);
      }
    }
    
    /*return the bytes decompressed since the last time bytes were returned from this stream, in other
      words, return a block*/
    if((retval == BZ_OK) || (retval==BZ_STREAM_END)){
      if(TOTAL_OUT(s) - THIS->total_out_previous_flush > 0){
	retstr = make_shared_binary_string(ret_buffer.s.str,TOTAL_OUT(s)-THIS->total_out_previous_flush);
      }
      else{
	retstr = make_shared_binary_string("",0);
      }
      THIS->total_out_previous_flush = TOTAL_OUT(s);
      if(retval == BZ_STREAM_END){
	bzDecompressEnd(s);
	toss_buffer(&(THIS->intern_buffer));/*free the final buffer*/
	
	if(THIS->internbuf != NULL){
	  toss_buffer(&(THIS->intern_buffer));
	  THIS->internbuf = NULL;
	}
	
	s->bzalloc = NULL;
	s->bzfree = NULL;
	s->opaque = NULL;
	
	retval = bzDecompressInit(s, 0, 0);
	
	/* make more detailed*/
	if(retval != BZ_OK){
	  Pike_error("Unexpected error in Bz2.Inflate()");
	}
	
	s->next_in = NULL;
	s->next_out = NULL;
	s->avail_in = 0;
	s->avail_out = 0;
	
	
	/*reset the counted bytes*/
	THIS->total_out_previous_flush = 0;
      }
      toss_buffer(&ret_buffer);
      do { struct pike_string * ret_=((retstr)); pop_stack(); push_string(ret_); return; }while(0);
#line 757 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    
    else{
      /* something went really wrong*/
      toss_buffer(&ret_buffer);
      do { struct pike_string * ret_=((0)); pop_stack(); push_string(ret_); return; }while(0);
#line 763 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  }
  
  }

#undef internal_init_Inflate_defined
#define internal_init_Inflate_defined

#undef Inflate_event_handler_defined
#define Inflate_event_handler_defined
static void init_Inflate_struct(void)
#line 767 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      bz_stream *s;
      THIS->internbuf = NULL;
      s = &(THIS->strm);
      s->bzalloc = NULL;
      s->bzfree = NULL;
      s->opaque = NULL;
      s->next_in = NULL;
      s->next_out = NULL;
      s->avail_in = 0;
      s->avail_out = 0;
    }

  
#undef internal_exit_Inflate_defined
#define internal_exit_Inflate_defined

#undef Inflate_event_handler_defined
#define Inflate_event_handler_defined
static void exit_Inflate_struct(void)
#line 781 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      bzDecompressEnd(&(THIS->strm));
      if(THIS->internbuf != NULL){
	toss_buffer(&(THIS->intern_buffer));
      }
    }

#ifdef Inflate_event_handler_defined
static void Inflate_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Inflate_defined
  case PROG_EVENT_INIT: init_Inflate_struct(); break;

#endif /* internal_init_Inflate_defined */

#ifdef internal_exit_Inflate_defined
  case PROG_EVENT_EXIT: exit_Inflate_struct(); break;

#endif /* internal_exit_Inflate_defined */
  default: break; 
  }
}

#endif /* Inflate_event_handler_defined */
/*! @endclass
*/

/*! @class File
 *! Low-level implementation of read/write support for Bzip2 files
 */



#undef class_File_defined
#define class_File_defined
struct program *File_program=NULL;
static int File_program_fun_num=-1;

#undef var_file_File_defined
#define var_file_File_defined

#undef var_fp_File_defined
#define var_fp_File_defined

#undef var_mode_File_defined
#define var_mode_File_defined

#undef var_small_File_defined
#define var_small_File_defined

#undef var_bzerror_File_defined
#define var_bzerror_File_defined

#undef THIS
#define THIS ((struct File_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_FILE
#define THIS_FILE ((struct File_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_FILE
#define OBJ2_FILE(o) ((struct File_struct *)(o->storage+File_storage_offset))

#undef GET_FILE_STORAGE
#define GET_FILE_STORAGE ((struct File_struct *)(o->storage+File_storage_offset)
static ptrdiff_t File_storage_offset;
struct File_struct {

#ifdef var_file_File_defined
#line 798 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
BZFILE *file;
#endif /* var_file_File_defined */

#ifdef var_fp_File_defined
#line 799 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
FILE *fp;
#endif /* var_fp_File_defined */

#ifdef var_mode_File_defined
#line 800 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int mode;
#endif /* var_mode_File_defined */

#ifdef var_small_File_defined
#line 801 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int small;
#endif /* var_small_File_defined */

#ifdef var_bzerror_File_defined
#line 802 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
int bzerror;
#endif /* var_bzerror_File_defined */
};
/*! @decl int(0..1) close()
   *! closes the file
   */

  #define f_File_close_defined
ptrdiff_t f_File_close_fun_num = 0;
void f_File_close(INT32 args) {
#line 808 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 0) wrong_number_of_args_error("close",args,0);
#line 808 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    if(args == 0){
      switch(THIS->mode){
      case READ_MODE:
	bzReadClose(&(THIS->bzerror),THIS->file);
	break;
      case WRITE_MODE:
	bzWriteClose ( &(THIS->bzerror), THIS->file,0,NULL,NULL);
	break;
      default:
	Pike_error("This error can never occur");
      }
      fclose(THIS->fp);
      THIS->fp = NULL;
    }
    else{
      Pike_error("Too many arguments in call to Bz2.File()->close(), there should be none");
    }
    THIS->mode = NO_FILE_MODE;
    THIS->small = 0;

    if((THIS->bzerror)==BZ_OK){
      do { INT_TYPE ret_=((1));  push_int(ret_); return; }while(0);
#line 831 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    else{
      do { INT_TYPE ret_=((0));  push_int(ret_); return; }while(0);
#line 834 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}

  }

  }
/*! @decl void create()
   *! Creates a Bz2.File object
   */


  #define f_File_create_defined
ptrdiff_t f_File_create_fun_num = 0;
void f_File_create(INT32 args) {
#line 843 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
#line 843 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    if(THIS->file != NULL){
      f_File_close(0);
    }
    THIS->small = 0;
    THIS->bzerror = 0;
    THIS->mode = NO_FILE_MODE;
    THIS->file = NULL;
    THIS->fp = NULL;
    
    if(args != 0){
      Pike_error("Bz2.File()must be called with NO arguments");
    }
    pop_n_elems(args);
  }

  
  }
/*! @decl int(0..1) read_open(string file)
   *! Opens a file for reading.
   *! @param file
   *! The name of the file to be opened
   */
  
  #define f_File_read_open_defined
ptrdiff_t f_File_read_open_fun_num = 0;
void f_File_read_open(INT32 args) {
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * file_name;
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("read_open",args,1);
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("read_open",1,"string");
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(file_name=Pike_sp[0-1].u.string);
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    FILE *tmp = NULL;
    
    if( THIS->mode == NO_FILE_MODE){
      tmp = fopen(file_name->str,"rb");
    }
    if(tmp != NULL){
      THIS->fp = tmp;
      THIS->file = bzReadOpen(&(THIS->bzerror),tmp,0,0,NULL,0);
      THIS->mode = READ_MODE;
      
      switch(THIS->bzerror){
      case BZ_OK:
	break;
      case BZ_MEM_ERROR:
	if(THIS->small == 0){
	  bzReadClose(&(THIS->bzerror),THIS->file);
	  THIS->small = 1;
	  bzReadOpen(&(THIS->bzerror),tmp,1,0,NULL,0);
	  if(THIS->bzerror != BZ_OK){
	    Pike_error("Bz2.File->read_open() failed");
	  }	    
	}
	else{
	  Pike_error("Bz2.File->read_open() out of memory");
	}
	break;
      default:
	Pike_error("Error in Bz2.File()->read_open");
      }
    }
    if(tmp==NULL){
      do { INT_TYPE ret_=((0)); pop_stack(); push_int(ret_); return; }while(0);
#line 899 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    else{
      do { INT_TYPE ret_=((1)); pop_stack(); push_int(ret_); return; }while(0);
#line 902 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  }

  }
/*! @decl int(0..1) write_open(string file)
   *! Opens a file for writing.
   *! @param file
   *! The name of the file to be opened
   */
  
  #define f_File_write_open_defined
ptrdiff_t f_File_write_open_fun_num = 0;
void f_File_write_open(INT32 args) {
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * file_name;
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * compression;
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * work;
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args < 1) wrong_number_of_args_error("write_open",args,1);
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args > 3) wrong_number_of_args_error("write_open",args,3);
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("write_open",1,"string");
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(file_name=Pike_sp[0-args].u.string);
if (args > 1) {
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("write_open",2,"int|void");
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
compression=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else compression=0;
if (args > 2) {
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[2-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("write_open",3,"int|void");
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
work=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
} else work=0;
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    int work_factor = DEFAULT_WORK_FACTOR;
    int compression_rate = DEFAULT_COMPRESSION_RATE;
    FILE *tmp = NULL;
    
    if(args > 1){
      if(work->type != T_INT){
	Pike_error("Bad argument 2 in call to Bz2.File()->write_open()");
      }
      else{
	compression_rate = compression->u.integer;
      }
      if(args == 3){
	if(work->type != T_INT){
	    Pike_error("Bad argument 3 in call to Bz2.File()->write_open()");
	}
	else{
	  work_factor = work->u.integer;
	  }
      }
    }
    else if (args > 3){
      Pike_error("Too many arguments in call to Bz2.File()->write_open()");
    }
    else if (args < 1){
      Pike_error("Too few arguments in call to Bz2.File()->write_open()");
    }
    
    if(compression_rate < 1 || compression_rate > 9){
      Pike_error("compression rate out of range for Bz2.File()->write_open()");
    }
    if(work_factor < 1 || work_factor > 250){
      Pike_error("work factor out of range for Bz2.File()->write_open()");
    }
    if (THIS->mode == NO_FILE_MODE){
      tmp = fopen(file_name->str,"wb");
    }
    if(tmp != NULL){
      THIS->fp = tmp;
      THIS->file = bzWriteOpen(&(THIS->bzerror),tmp,compression_rate,0,work_factor);
      
      switch(THIS->bzerror){
      case BZ_OK:
	break;
      default:
	fclose(tmp);
	Pike_error("Error in Bz2.File()->write_open");
      }
      THIS->mode = WRITE_MODE;
    }
    
    if(tmp == NULL){
      do { INT_TYPE ret_=((0)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 964 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    else{
      do { INT_TYPE ret_=((1)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 967 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  }

  }
/*! @decl int(0..1) open(string file, void|string mode)
   *!   Opens a file for I/O.
   *!
   *! @param file
   *!   The name of the file to be opened
   *! @param mode
   *!   Mode for the file operations. Can be either @expr{"r"@} (read)
   *!   or @expr{"w"@}. Read is default.
   */
  
  #define f_File_open_defined
ptrdiff_t f_File_open_fun_num = 0;
void f_File_open(INT32 args) {
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * filename;
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * mode;
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args < 1) wrong_number_of_args_error("open",args,1);
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args > 2) wrong_number_of_args_error("open",args,2);
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("open",1,"string");
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(filename=Pike_sp[0-args].u.string);
if ((args > 1) && 
    ((Pike_sp[1-args].type != PIKE_T_INT) ||
     (Pike_sp[1-args].u.integer))) {
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[1-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("open",2,"string|void");
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(mode=Pike_sp[1-args].u.string);
} else mode=0;
#line 981 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    if (!mode) {
      f_File_read_open(1);
      return;
    } else {
      if (!strcmp(mode->str, "w")) {
	pop_stack();
	f_File_write_open(1);
      } else if (!strcmp(mode->str, "r")) {
	pop_stack();
	f_File_read_open(1);
      } else {
	Pike_error("Unknown open mode for file, "
		   "expected either \"w\" or \"r\".");
      }
    }
  }
  

  }
/*! @decl int write(string data)
   *! Writes the data to the file.
   *! @returns 
   *!  the number of bytes written to the file.
   */

  #define f_File_write_defined
ptrdiff_t f_File_write_fun_num = 0;
void f_File_write(INT32 args) {
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct pike_string * data;
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 1) wrong_number_of_args_error("write",args,1);
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("write",1,"string");
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    int len =  data->len;
    
    bzWrite(&(THIS->bzerror), THIS->file, data->str,len);
    switch(THIS->bzerror){
    case BZ_OK:
      break;
    default:
      Pike_error("Error in Bz2.File()->write();");
    }
    
    do { INT_TYPE ret_=((len)); pop_stack(); push_int(ret_); return; }while(0);
#line 1018 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
  
  }
/*! @decl int|string read(int len)
   *! Reads len (uncompressed) bytes from the file.
   *! If len is omitted the whole file is read.
   *! If read is unsuccessful, 0 is returned.
   */
  
  #define f_File_read_defined
ptrdiff_t f_File_read_fun_num = 0;
void f_File_read(INT32 args) {
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
struct svalue * bytes;
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args > 1) wrong_number_of_args_error("read",args,1);
if (args > 0) {
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("read",1,"int|void");
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
bytes=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else bytes=0;
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    void *buf = NULL;
    dynamic_buffer retbuf;
    struct pike_string *retstr;
    int to_be_read = 0;
    int nr_of_bytes = 0;
    int nr_of_bytes_old = 0;
    int i = 1;

    if(args == 1){
      if(bytes->type == T_INT){
	to_be_read = bytes->u.integer;
      }
      else{
	Pike_error("Bad type of argument in call to Bz2.File()->read");
      }
    }
    else if(args == 0){
      /*do not know how long the file will be, think of a better 
       way to set to_be_read */
      to_be_read = INFL_BUF_SIZE;
    }
    else{
      Pike_error("Bad number of arguments in call to Bz2.File->read");
    }
    

	
    initialize_buf(&retbuf);
    THIS->bzerror = BZ_OK;
    while((to_be_read > nr_of_bytes) && (THIS->bzerror != BZ_STREAM_END)){
      buf = malloc(i * INFL_BUF_SIZE);
      if(buf == NULL){
	toss_buffer(&retbuf);
	Pike_error("Failed to allocate memory in Bz2.File->read()");
      }
      nr_of_bytes = nr_of_bytes + bzRead ( &(THIS->bzerror), THIS->file, buf, to_be_read - nr_of_bytes);
            
      if((args == 0) && (to_be_read == nr_of_bytes)){
	/*make sure that we do this loop until end_of_file is reached*/
	to_be_read += i * INFL_BUF_SIZE;
	i = i * 2;
      }

      low_my_binary_strcat(buf, nr_of_bytes - nr_of_bytes_old, &retbuf);
      free(buf);
      nr_of_bytes_old = nr_of_bytes;
      
      switch(THIS->bzerror){
      case BZ_OK:
	break;
      case BZ_STREAM_END:
	break;
      default:
	toss_buffer(&retbuf);
	Pike_error("Error in Bz2.File()->read()");
	}
    }
    
    if(nr_of_bytes <= 0){
      toss_buffer(&retbuf);
      do { struct pike_string * ret_=((0)); pop_n_elems(args); push_string(ret_); return; }while(0);
#line 1088 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    else{
      retstr = (make_shared_binary_string(retbuf.s.str, nr_of_bytes));
      toss_buffer(&retbuf);
      do { struct pike_string * ret_=((retstr)); pop_n_elems(args); push_string(ret_); return; }while(0);
#line 1093 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}  
  }
  
  }
/*! @decl int(0..1) eof()
   *! @returns 
   *!  1 if EOF has been reached,
   *!  0 otherwise
   */

  #define f_File_eof_defined
ptrdiff_t f_File_eof_fun_num = 0;
void f_File_eof(INT32 args) {
#line 1102 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
if(args != 0) wrong_number_of_args_error("eof",args,0);
#line 1102 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
    if(args == 0){
      if(THIS->bzerror == BZ_STREAM_END){
	do { INT_TYPE ret_=((1));  push_int(ret_); return; }while(0);
#line 1106 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
      else{
	do { INT_TYPE ret_=((0));  push_int(ret_); return; }while(0);
#line 1109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
}
    }
    else{
      Pike_error("Too many arguments in call to Bz2.File()->eof()");
    }  
  }

  }

#undef internal_init_File_defined
#define internal_init_File_defined

#undef File_event_handler_defined
#define File_event_handler_defined
static void init_File_struct(void)
#line 1117 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      THIS->small = 0;
      THIS->file = NULL;
      THIS->bzerror = 0;
      THIS->mode = NO_FILE_MODE;
      THIS->file = NULL;
    }
  
  
#undef internal_exit_File_defined
#define internal_exit_File_defined

#undef File_event_handler_defined
#define File_event_handler_defined
static void exit_File_struct(void)
#line 1126 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
{
      if(THIS->fp != NULL){
	switch(THIS->mode){
	case READ_MODE:
	  bzReadClose(&(THIS->bzerror),THIS->file);
	  break;
	case WRITE_MODE:
	  bzWriteClose ( &(THIS->bzerror), THIS->file,0,NULL,NULL);
	  break;
	case NO_FILE_MODE:
	  break;
	default:
	  Pike_error("This error can never occur");
	}
	fclose(THIS->fp);
	THIS->fp = NULL;
	THIS->mode = NO_FILE_MODE;
      }
    }

#ifdef File_event_handler_defined
static void File_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_File_defined
  case PROG_EVENT_INIT: init_File_struct(); break;

#endif /* internal_init_File_defined */

#ifdef internal_exit_File_defined
  case PROG_EVENT_EXIT: exit_File_struct(); break;

#endif /* internal_exit_File_defined */
  default: break; 
  }
}

#endif /* File_event_handler_defined */
#line 1146 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
#endif
#endif  /* end HAVE_LIBLIBZIP2 */

/*! @endclass
 */

/*! @endmodule
 */

PIKE_MODULE_INIT
{
#ifdef HAVE_BZ2LIB
#ifdef HAVE_BZLIB_H
  add_integer_constant("BZ_RUN", BZ_RUN, 0);
  add_integer_constant("BZ_FLUSH", BZ_FLUSH, 0);
  add_integer_constant("BZ_FINISH", BZ_FINISH, 0);
  
#ifdef class_Deflate_defined

#ifdef PROG_DEFLATE_ID
#line 109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  START_NEW_PROGRAM_ID(DEFLATE);
#else
#line 109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  start_new_program();

#endif /* PROG_DEFLATE_ID */

#ifndef tObjImpl_DEFLATE

#undef tObjImpl_DEFLATE
#define tObjImpl_DEFLATE tObj

#endif /* tObjImpl_DEFLATE */

#ifdef THIS_DEFLATE

  Deflate_storage_offset=ADD_STORAGE(struct Deflate_struct);

#endif /* THIS_DEFLATE */

#ifdef Deflate_event_handler_defined
  pike_set_prog_event_callback(Deflate_event_handler);

#endif /* Deflate_event_handler_defined */

#ifdef f_Deflate_create_defined
  f_Deflate_create_fun_num =
#line 131 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("create", f_Deflate_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Deflate_create_defined */

#ifdef f_Deflate_feed_defined
  f_Deflate_feed_fun_num =
#line 214 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("feed", f_Deflate_feed, tFunc(tString,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Deflate_feed_defined */

#ifdef f_Deflate_read_defined
  f_Deflate_read_fun_num =
#line 334 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("read", f_Deflate_read, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Deflate_read_defined */

#ifdef f_Deflate_finish_defined
  f_Deflate_finish_fun_num =
#line 390 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("finish", f_Deflate_finish, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Deflate_finish_defined */

#ifdef f_Deflate_deflate_defined
  f_Deflate_deflate_fun_num =
#line 482 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("deflate", f_Deflate_deflate, tFunc(tString tOr("\10\200\0\0\0\177\377\377\377",tVoid),tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Deflate_deflate_defined */
#line 109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  Deflate_program=end_program();
#line 109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  Deflate_program_fun_num=add_program_constant("Deflate",Deflate_program,0);

#endif /* class_Deflate_defined */

#ifdef class_Inflate_defined

#ifdef PROG_INFLATE_ID
#line 563 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  START_NEW_PROGRAM_ID(INFLATE);
#else
#line 563 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  start_new_program();

#endif /* PROG_INFLATE_ID */

#ifndef tObjImpl_INFLATE

#undef tObjImpl_INFLATE
#define tObjImpl_INFLATE tObj

#endif /* tObjImpl_INFLATE */

#ifdef THIS_INFLATE

  Inflate_storage_offset=ADD_STORAGE(struct Inflate_struct);

#endif /* THIS_INFLATE */

#ifdef Inflate_event_handler_defined
  pike_set_prog_event_callback(Inflate_event_handler);

#endif /* Inflate_event_handler_defined */

#ifdef f_Inflate_create_defined
  f_Inflate_create_fun_num =
#line 573 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("create", f_Inflate_create, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inflate_create_defined */

#ifdef f_Inflate_inflate_defined
  f_Inflate_inflate_fun_num =
#line 627 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("inflate", f_Inflate_inflate, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inflate_inflate_defined */
#line 563 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  Inflate_program=end_program();
#line 563 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  Inflate_program_fun_num=add_program_constant("Inflate",Inflate_program,0);

#endif /* class_Inflate_defined */

#ifdef class_File_defined

#ifdef PROG_FILE_ID
#line 796 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  START_NEW_PROGRAM_ID(FILE);
#else
#line 796 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  start_new_program();

#endif /* PROG_FILE_ID */

#ifndef tObjImpl_FILE

#undef tObjImpl_FILE
#define tObjImpl_FILE tObj

#endif /* tObjImpl_FILE */

#ifdef THIS_FILE

  File_storage_offset=ADD_STORAGE(struct File_struct);

#endif /* THIS_FILE */

#ifdef File_event_handler_defined
  pike_set_prog_event_callback(File_event_handler);

#endif /* File_event_handler_defined */

#ifdef f_File_close_defined
  f_File_close_fun_num =
#line 808 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("close", f_File_close, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_close_defined */

#ifdef f_File_create_defined
  f_File_create_fun_num =
#line 843 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("create", f_File_create, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_create_defined */

#ifdef f_File_read_open_defined
  f_File_read_open_fun_num =
#line 866 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("read_open", f_File_read_open, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_read_open_defined */

#ifdef f_File_write_open_defined
  f_File_write_open_fun_num =
#line 911 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("write_open", f_File_write_open, tFunc(tString tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr("\10\200\0\0\0\177\377\377\377",tVoid),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_write_open_defined */

#ifdef f_File_open_defined
  f_File_open_fun_num =
#line 980 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("open", f_File_open, tFunc(tString tOr(tString,tVoid),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_open_defined */

#ifdef f_File_write_defined
  f_File_write_fun_num =
#line 1006 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("write", f_File_write, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_write_defined */

#ifdef f_File_read_defined
  f_File_read_fun_num =
#line 1026 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("read", f_File_read, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_read_defined */

#ifdef f_File_eof_defined
  f_File_eof_fun_num =
#line 1102 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    ADD_FUNCTION2("eof", f_File_eof, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_File_eof_defined */
#line 796 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  File_program=end_program();
#line 796 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
  File_program_fun_num=add_program_constant("File",File_program,0);

#endif /* class_File_defined */
#line 1163 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
#endif
#endif
}

PIKE_MODULE_EXIT
{
#ifdef HAVE_BZ2LIB
#ifdef HAVE_BZLIB_H	
  
#ifdef class_Deflate_defined
  if(Deflate_program) {
#line 109 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    free_program(Deflate_program);
    Deflate_program=0;
  }

#endif /* class_Deflate_defined */

#ifdef class_Inflate_defined
  if(Inflate_program) {
#line 563 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    free_program(Inflate_program);
    Inflate_program=0;
  }

#endif /* class_Inflate_defined */

#ifdef class_File_defined
  if(File_program) {
#line 796 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
    free_program(File_program);
    File_program=0;
  }

#endif /* class_File_defined */
#line 1172 "/tmp/pikedeb.c9489edcc2/7.6/src/post_modules/Bz2/libbzip2mod.cmod"
#endif
#endif
}



