<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: index.php,v 1.22.4.1 2006/10/24 06:53:05 skwashd Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array
	(
		'enable_nextmatchs_class' => True,
		'enable_categories_class' => True,
		'currentapp'              => 'dj'
	);
	include_once('../header.inc.php');

	$data = $GLOBALS['phpgw']->session->appsession('session_data','dj');
	get_form($data);

	if (!$start)
	{
		$start = 0;
	}

	if ($cat_id)
	{
		$fwhere = ' WHERE ';
		$fand = ' AND ';
		$filtermethod = " song_genre='" . $GLOBALS['phpgw']->categories->id2name($cat_id) . "'";
	}
	if ($order)
	{
		$ordermethod = " ORDER BY " . $order . " " . $sort;
	}
	else
	{
		$ordermethod = 'ORDER BY song_name';
	}

	$GLOBALS['phpgw']->template->set_file(array('list' => 'index.tpl'));
	$GLOBALS['phpgw']->template->set_block('list','index','index');
	$GLOBALS['phpgw']->template->set_block('list','row','row');
	$GLOBALS['phpgw']->template->set_block('list','footer','footer');

	if ($query)
	{
		$sql = "SELECT COUNT(*) FROM phpgw_dj_songlist WHERE ("
			. "song_name    LIKE '%$query%' OR "
			. "song_title   LIKE '%$query%' OR "
			. "song_artist  LIKE '%$query%' OR "
			. "song_year    LIKE '%$query%' OR "
			. "song_comment LIKE '%$query%' OR "
			. "song_genre   LIKE '%$query%') "
			. $fand
			. $filtermethod;
	}
	else
	{
		$sql = "SELECT COUNT(*) FROM phpgw_dj_songlist" . $fwhere . $filtermethod;
	}

	$GLOBALS['phpgw']->db->query($sql);
	$GLOBALS['phpgw']->db->next_record();
	$total = $GLOBALS['phpgw']->db->f(0);

	$GLOBALS['phpgw']->template->set_var('lang_title',$GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,"song_title",$order,"/dj/index.php",lang("Title"),'&cat_id='.$cat_id));
	$GLOBALS['phpgw']->template->set_var('lang_artist',$GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,"song_artist",$order,"/dj/index.php",lang('Artist'),'&cat_id='.$cat_id));
	$GLOBALS['phpgw']->template->set_var('lang_year',$GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,"song_year",$order,"/dj/index.php",lang('Year'),'&cat_id='.$cat_id));
	$GLOBALS['phpgw']->template->set_var('lang_genre',$GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,"song_genre",$order,"/dj/index.php",lang('Genre'),'&cat_id='.$cat_id));

	$GLOBALS['phpgw']->template->set_var('lang_request',lang('Request'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_view',lang('View'));
	$GLOBALS['phpgw']->template->set_var('lang_download',lang('DL'));

	$GLOBALS['phpgw']->template->set_var('lang_showing',$GLOBALS['phpgw']->nextmatchs->show_hits($total,$start));
	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/dj/index.php','cat_id='.$cat_id));
	//$GLOBALS['phpgw']->template->set_var('cats_link',cat_option($cat_id));

	$GLOBALS['phpgw']->template->set_var('next_matchs', $GLOBALS['phpgw']->nextmatchs->show_tpl('/dj/index.php',$start,$total,
		'','80%',$GLOBALS['phpgw_info']["theme"]["th_bg"],0,0,1,0,$cat_id));

	$GLOBALS['phpgw']->template->set_var('song_title_color',' bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '"');
	$GLOBALS['phpgw']->template->set_var('song_artist_color',' bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '"');
	$GLOBALS['phpgw']->template->set_var('song_year_color',' bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '"');
	$GLOBALS['phpgw']->template->set_var('song_genre_color',' bgcolor="' . $GLOBALS['phpgw_info']['theme']['th_bg'] . '"');
	$GLOBALS['phpgw']->template->set_var($order . '_color',' bgcolor="' . $GLOBALS['phpgw_info']['theme']['row_off'] . '"');
	$GLOBALS['phpgw']->template->set_var('start',$start);
	$GLOBALS['phpgw']->template->set_var('sort',$sort);
	$GLOBALS['phpgw']->template->set_var('order',$order);
	$GLOBALS['phpgw']->template->set_var('filter',$filter);
	$GLOBALS['phpgw']->template->set_var('query',$query);
	$GLOBALS['phpgw']->template->set_var('cat_id',$cat_id);
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('lang_request_mult',lang('Add selected to request'));
	$GLOBALS['phpgw']->template->set_var('request_mult_link',$GLOBALS['phpgw']->link('/dj/request.php'));
	$GLOBALS['phpgw']->template->set_var('lang_show',lang('Manage Shows'));
	$GLOBALS['phpgw']->template->set_var('lang_addshow',lang('Add selected to a show'));
	$GLOBALS['phpgw']->template->set_var('show_url',$GLOBALS['phpgw']->link('/dj/show.php'));
	$GLOBALS['phpgw']->template->set_var('check',PHPGW_IMAGES . '/check.gif');
	$GLOBALS['phpgw']->template->set_var('select_all',lang('Select All'));

	if ($query)
	{
		$sql = "SELECT * FROM phpgw_dj_songlist WHERE ("
			. "song_name    LIKE '%$query%' OR "
			. "song_title  LIKE '%$query%' OR "
			. "song_artist LIKE '%$query%' OR "
			. "song_year LIKE '%$query%' OR "
			. "song_comment LIKE '%$query%' OR "
			. "song_genre LIKE '%$query%') "
			. $fand
			. $filtermethod . " " . $ordermethod;
	}
	else
	{
		$sql = "SELECT * FROM phpgw_dj_songlist " . $fwhere
			. $filtermethod . " " . $ordermethod;
	}

	$GLOBALS['phpgw']->db->limit_query($sql,$start,__LINE__,__FILE__);

	while ($GLOBALS['phpgw']->db->next_record())
	{
		$unavail = '';
		if ($GLOBALS['phpgw']->db->f('song_status') == 'N')
		{
			$unavail = ' (' . lang('unavailable') . ')';
		}

		$id     = $GLOBALS['phpgw']->db->f('song_id');
		$title  = trim($GLOBALS['phpgw']->db->f('song_title') . $unavail);
		$artist = trim($GLOBALS['phpgw']->db->f('song_artist'));
		$year   = trim($GLOBALS['phpgw']->db->f('song_year'));
		$genre  = trim($GLOBALS['phpgw']->db->f('song_genre'));

		$GLOBALS['phpgw']->template->set_var('id',$id);
		$GLOBALS['phpgw']->template->set_var('title',$title);
		$GLOBALS['phpgw']->template->set_var('artist',$artist);
		$GLOBALS['phpgw']->template->set_var('year',$year);
		$GLOBALS['phpgw']->template->set_var('genre',$genre);

		$GLOBALS['phpgw']->template->set_var('tr_color',$GLOBALS['phpgw']->nextmatchs->alternate_row_color());
		$GLOBALS['phpgw']->template->set_var('request_link',$GLOBALS['phpgw']->link('/dj/request.php','song_id=' . $GLOBALS['phpgw']->db->f('song_id')));
		$GLOBALS['phpgw']->template->set_var('edit_link',$GLOBALS['phpgw']->link('/dj/edit.php','song_id=' . $GLOBALS['phpgw']->db->f('song_id')));
		$GLOBALS['phpgw']->template->set_var('view_link',$GLOBALS['phpgw']->link('/dj/view.php','song_id=' . $GLOBALS['phpgw']->db->f('song_id')));
		$GLOBALS['phpgw']->template->set_var('download_link',$GLOBALS['phpgw']->link('/dj/download.php','song_id=' . $GLOBALS['phpgw']->db->f('song_id')));

		$GLOBALS['phpgw']->template->set_var('lang_request',lang('Request'));
		$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
		$GLOBALS['phpgw']->template->parse('rows','row',True);
	}

	$GLOBALS['phpgw']->template->set_var('requestlist_link','<a href="' . $GLOBALS['phpgw']->link('/dj/request.php') . '">' . lang('Current request list') . '</a>');
	$GLOBALS['phpgw']->template->set_var('lang_import',lang('Import MP3 list'));
	$GLOBALS['phpgw']->template->set_var('import_url',$GLOBALS['phpgw']->link('/dj/import.php'));
	$GLOBALS['phpgw']->template->set_var('lang_scan',lang('(re)scan directories'));
	$GLOBALS['phpgw']->template->set_var('scan_url',$GLOBALS['phpgw']->link('/dj/scan.php'));
	//$GLOBALS['phpgw']->template->set_var('lang_export',lang("Export ID3 info"));
	//$GLOBALS['phpgw']->template->set_var('export_url',$GLOBALS['phpgw']->link("/dj/export.php"));

	$GLOBALS['phpgw']->template->pfp('out','index');
	$GLOBALS['phpgw']->template->pfp('out','footer');

	$data = array(
		'start'  => $start,
		'query'  => $query,
		'sort'   => $sort,
		'order'  => $order,
		'cat_id' => $cat_id
	);
	$GLOBALS['phpgw']->session->appsession('session_data','dj',$data);

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
