<?php
/**
*
* acp_board [Serbian]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'Овде можете да одредите основне поступке на Вашем форуму, дајући им одговарајуће име и опис, и међу другим поставкама подешавајући задате вредности за временску зону и језик.',
	'CUSTOM_DATEFORMAT'				=> 'Властито…',
	'DEFAULT_DATE_FORMAT'			=> 'Облик датума',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'Облик датума је исти као и код PHP <code>date</code> функције.',
	'DEFAULT_LANGUAGE'				=> 'Задати језик',
	'DEFAULT_STYLE'					=> 'Задати стил',
	'DISABLE_BOARD'					=> 'Затвори форум',
	'DISABLE_BOARD_EXPLAIN'			=> 'Ово ће направити форум недоступним за кориснике. Можете такође унети кратку (255 знакова) поруку за приказ уколико желите.',
	'OVERRIDE_STYLE'				=> 'Препиши преко корисниковог стила',
	'OVERRIDE_STYLE_EXPLAIN'		=> 'Замењује корисников стил са задатим.',
	'SITE_DESC'						=> 'Опис сајта',
	'SITE_NAME'						=> 'Назив сајта',
	'SYSTEM_DST'					=> 'Омогући Летње рачунање времена/<abbr title="Daylight Saving Time">DST</abbr>',
	'SYSTEM_TIMEZONE'				=> 'Временска зона система',
	'WARNINGS_EXPIRE'				=> 'Трајање опомене',
	'WARNINGS_EXPIRE_EXPLAIN'		=> 'Број дана који ће протећи пре него што опомена за корисника аутоматски истекне.',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'Овде можете омогућити/онемогућити неколико могућности форума.',

	'ALLOW_ATTACHMENTS'			=> 'Дозволи прилоге',
	'ALLOW_BIRTHDAYS'			=> 'Дозволи рођендане',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'Дозволи да се рођендани уносе и старост буде приказана у профилима. Молимо знајте да је списак рођендана у оквиру почетне странице форума контролисан посебним поставкама оптерећења.',
	'ALLOW_BOOKMARKS'			=> 'Дозволи да се теме ставе у белешке',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'Корисник може да сачува личне белешке.',
	'ALLOW_BBCODE'				=> 'Дозволи ББКод',
	'ALLOW_FORUM_NOTIFY'		=> 'Дозволи праћење форума',
	'ALLOW_NAME_CHANGE'			=> 'Дозволи промену корисничког имена',
	'ALLOW_NO_CENSORS'			=> 'Дозволи онемогућавање пречистача речи',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'Корисници могу изабрати да онемогуће аутоматско пречишћавање речи у порукама и приватним порукама.',
	'ALLOW_PM_ATTACHMENTS'		=> 'Дозволи прилоге у приватним порукама',
	'ALLOW_PM_REPORT'			=> 'Дозволи корисницима да пријављују приватне поруке',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'Уколико је ова поставка омогућена, корисници имају могућност пријављивања приватне поруке коју су добили или послали уредницима форума. Ове приватне поруке ће потом бити видљиве у Уредничкој Контролној Плочи.',
	'ALLOW_QUICK_REPLY'			=> 'Дозволи брзи одговор',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'Овај прекидач омогућава да поље брзи одговор буде онемогућено широм форума. Када је омогућено, посебне поставке форума ће бити коришћене за одређивање да ли ће брзи одговор бити приказиван у појединачним форумима.',
	'ALLOW_QUICK_REPLY_BUTTON'	=> 'Потврди и омогући брзи одговор у свим форумима',
	'ALLOW_SIG'					=> 'Дозволи потписе',
	'ALLOW_SIG_BBCODE'			=> 'Дозволи ББКод у потписима корисника',
	'ALLOW_SIG_FLASH'			=> 'Дозволи коришћење <code>[FLASH]</code> ББКод тага у потписима корисника',
	'ALLOW_SIG_IMG'				=> 'Дозволи коришћење <code>[IMG]</code> ББКод тага у потписима корисника',
	'ALLOW_SIG_LINKS'			=> 'Дозволи коришћење веза у потписима корисника',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'Уколико је недозвољен <code>[URL]</code> ББКод таг и аутоматски/магични URL-ови су онемогућени.',
	'ALLOW_SIG_SMILIES'			=> 'Дозволи коришћење смајлића у потписима корисника',
	'ALLOW_SMILIES'				=> 'Дозволи смајлиће',
	'ALLOW_TOPIC_NOTIFY'		=> 'Дозволи праћење тема',
	'BOARD_PM'					=> 'Приватне поруке',
	'BOARD_PM_EXPLAIN'			=> 'Дозволи или онемогући приватне поруке за све кориснике.',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'Грбови су углавном мале, јединствене слике које корисник може да споји са собом. У зависности од стила оне су обично приказане испод корисничког имена при прегледу теме. Овде можете да одредите како корисници могу да одреде себи грбове. Молимо знајте да бисте могли да додајете грбове треба да имате направљену фасциклу чији назив унесете испод и проверите да ли је фасцикла уписљива од веб сервера. Молимо знајте такође да су ограничења величине датотеке одређена само за додате грбове, она се не примењују на удаљено повезане слике.',

	'ALLOW_AVATARS'					=> 'Омогући грбове',
	'ALLOW_AVATARS_EXPLAIN'			=> 'Дозвољава општу употребу грбова;<br />Уколико онемогућите грбове уопште или грбове одређеног мода, онемогућени грбови се више неће приказивати на форуму, али ће корисници још увек бити у могућности да преузму њихове грбове у Корисничкој Контролној Плочи.',
	'ALLOW_LOCAL'					=> 'Омогући галерију грбова',
	'ALLOW_REMOTE'					=> 'Омогући удаљене грбове',
	'ALLOW_REMOTE_EXPLAIN'			=> 'Грбови повезани са друге веб странице.',
	'ALLOW_REMOTE_UPLOAD'			=> 'Омогући додавање удаљених грбова',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'Дозвољава додавање грбова са друге веб странице.',
	'ALLOW_UPLOAD'					=> 'Омогући додавање грбова',
	'AVATAR_GALLERY_PATH'			=> 'Путања до галерије грбова',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'Путања под Вашом phpBB root фасциклом за унапред учитане слике, нпр. <samp>images/avatars/gallery</samp>.',
	'AVATAR_STORAGE_PATH'			=> 'Путања за смештање грбова',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'Путања под Вашом phpBB root фасциклом, нпр. <samp>images/avatars/upload</samp>.',
	'MAX_AVATAR_SIZE'				=> 'Највеће димензије грба',
	'MAX_AVATAR_SIZE_EXPLAIN'		=> 'Ширина x Висина у пикселима.',
	'MAX_FILESIZE'					=> 'Највећа величина датотеке грба',
	'MAX_FILESIZE_EXPLAIN'			=> 'За додате датотеке грба.',
	'MIN_AVATAR_SIZE'				=> 'Најмање димензије грба',
	'MIN_AVATAR_SIZE_EXPLAIN'		=> 'Ширина x Висина у пикселима.',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'		=> 'Овде можете подесите све задате вредности за приватне поруке.',

	'ALLOW_BBCODE_PM'			=> 'Дозволи ББКод у приватним порукама',
	'ALLOW_FLASH_PM'			=> 'Дозволи коришћење <code>[FLASH]</code> ББКод тага',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'Молимо знајте да могућност коришћења flash-а у приватним порукама, уколико је омогућено овде, такође зависи од дозвола.',
	'ALLOW_FORWARD_PM'			=> 'Дозволи прослеђивање приватних порука',
	'ALLOW_IMG_PM'				=> 'Дозволи коришћење <code>[IMG]</code> ББКод тага',
	'ALLOW_MASS_PM'				=> 'Дозволи слање приватних порука вишеструким корисницима и групама',
	'ALLOW_MASS_PM_EXPLAIN'		=> 'Слање групама може бити подешено по групи преко странице поставки група.',
	'ALLOW_PRINT_PM'			=> 'Дозволи преглед за штампу у приватним порукама',
	'ALLOW_QUOTE_PM'			=> 'Дозволи цитате у приватним порукама',
	'ALLOW_SIG_PM'				=> 'Дозволи потпис у приватним порукама',
	'ALLOW_SMILIES_PM'			=> 'Дозволи смајлиће у приватним порукама',
	'BOXES_LIMIT'				=> 'Највише приватних порука по сандучту',
	'BOXES_LIMIT_EXPLAIN'		=> 'Корисници могу примити не више од оволико порука у сваком од њихових сандучића приватних порука. Поставите ову вредност на 0 за омогућавање неограниченог броја порука.',
	'BOXES_MAX'					=> 'Највећи број фасцикли за приватне поруке',
	'BOXES_MAX_EXPLAIN'			=> 'Као задато корисници могу направити оволико личних фасцикли за приватне поруке.',
	'ENABLE_PM_ICONS'			=> 'Омогући коришћење иконица за теме у приватним порукама',
	'FULL_FOLDER_ACTION'		=> 'Задати поступак за попуњену фасциклу',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'Задати поступак који ће се предузети уколико је корисникова фасцикла пуна прихватајући да поступак корисника, уколико је уопште подешен, није могуће применити. Једини изузетак је за фасциклу “Послате поруке” где је задати поступак увек брисање старих порука.',
	'HOLD_NEW_MESSAGES'			=> 'Задржи нове поруке',
	'PM_EDIT_TIME'				=> 'Ограничи време учитавања',
	'PM_EDIT_TIME_EXPLAIN'		=> 'Ограничава време расположиво за учитавање приватне поруке која већ није испоручена. Поставка вредности на 0 онемогућава овакво понашање.',
	'PM_MAX_RECIPIENTS'			=> 'Највећи број дозвољених прималаца',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'Највећи број дозвољених прималаца у приватној поруци. Уколико је 0 унешена, дозвољен је неограничен број. Ова поставка може бити подешена за сваку групу преко странице поставки група.',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'			=> 'Овде можете подесити све задате поставке за поруке.',
	'ALLOW_POST_LINKS'					=> 'Дозволи везе у порукама/приватним порукама',
	'ALLOW_POST_LINKS_EXPLAIN'			=> 'Уколико је недозвољен <code>[URL]</code> ББКод таг и аутоматски/магични URL-ови онемогућени.',
	'ALLOW_POST_FLASH'					=> 'Дозволи коришћење <code>[FLASH]</code> ББКод тага у порукама',
	'ALLOW_POST_FLASH_EXPLAIN'			=> 'Уколико је недозвољен <code>[FLASH]</code> ББКод таг је онемогућен у порукама. С друге стране систем дозвола контролише који корисници могу да користе <code>[FLASH]</code> ББКод таг.',

	'BUMP_INTERVAL'					=> 'Интервал гурања',
	'BUMP_INTERVAL_EXPLAIN'			=> 'Број минута, сати или дана између последње поруке у теми и могућности да погурате ову тему. Постављање вредности на 0 онемогућава ову могућност.',
	'CHAR_LIMIT'					=> 'Највише знакова по поруци',
	'CHAR_LIMIT_EXPLAIN'			=> 'Број знакова дозвољен у поруци/приватној поруци. Подесите на 0 за неограничено знакова.',
	'DELETE_TIME'					=> 'Ограничење времена брисања',
	'DELETE_TIME_EXPLAIN'			=> 'Ограничава расположиво време за брисање нове поруке. Постављење вредности на 0 онемогућава ово понашање.',
	'DISPLAY_LAST_EDITED'			=> 'Прикажи податке о времену последњег учитавања',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'Изаберите како би подаци о Учитано од били приказани у порукама.',
	'EDIT_TIME'						=> 'Ограничи време учитавања',
	'EDIT_TIME_EXPLAIN'				=> 'Ограничава време доступно за учитавање нове поруке. Поставка вредности на 0 онемогућава ово понашање.',
	'FLOOD_INTERVAL'				=> 'Интервал поплаве',
	'FLOOD_INTERVAL_EXPLAIN'		=> 'Број секунди колико корисник мора да сачека између слања нових порука. Да бисте омогућили корисницима да игноришу ово измените њихове дозволе.',
	'HOT_THRESHOLD'					=> 'Праг за популарну тему',
	'HOT_THRESHOLD_EXPLAIN'			=> 'Праг порука по теми потребан за означавање теме популарном. Поставите на 0 за онемогућавање популарних тема.',
	'MAX_POLL_OPTIONS'				=> 'Највећи број понуда гласања',
	'MAX_POST_FONT_SIZE'			=> 'Највећа величина фонта по поруци',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'Највећа величина фонта дозвољена у поруци. Поставите на 0 за неограничену величину фонта.',
	'MAX_POST_IMG_HEIGHT'			=> 'Највећа висина слике по поруци',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'Највећа висина слике/flash датотеке у порукама. Поставите на 0 за неограничену величину.',
	'MAX_POST_IMG_WIDTH'			=> 'Највећа ширина слике по поруци',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'Највећа ширина слике/flash датотеке у порукама. Поставите на 0 за неограничену величину.',
	'MAX_POST_URLS'					=> 'Највише веза по поруци',
	'MAX_POST_URLS_EXPLAIN'			=> 'Највећи број URL-ова у поруци. Поставите на 0 за неограничено веза.',
	'MIN_CHAR_LIMIT'				=> 'Најмањи број знакова по поруци',
	'MIN_CHAR_LIMIT_EXPLAIN'		=> 'Најмањи број знакова које корисник треба да унесе у поруци.',
	'POSTING'						=> 'Поруке',
	'POSTS_PER_PAGE'				=> 'Порука по страници',
	'QUOTE_DEPTH_LIMIT'				=> 'Највише угњеждених цитата по поруци',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'		=> 'Највећи број угњеждених цитата по поруци. Поставите на 0 за неограничену дубину.',
	'SMILIES_LIMIT'					=> 'Највише смајлића по поруци',
	'SMILIES_LIMIT_EXPLAIN'			=> 'Највећи број смајлића у поруци. Поставите на 0 за неограничено смајлића.',
	'SMILIES_PER_PAGE'				=> 'Смајлића по страници',
	'TOPICS_PER_PAGE'				=> 'Тема по страници',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'Овде можете да подесите све задате поставке за потписе.',

	'MAX_SIG_FONT_SIZE'				=> 'Највећа величина фонта за потпис',
	'MAX_SIG_FONT_SIZE_EXPLAIN'		=> 'Највећа величина фонта дозвољена у потписима корисника. Поставите на 0 за неограничену величину.',
	'MAX_SIG_IMG_HEIGHT'			=> 'Највећа висина слике за потпис',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'Највећа висина слике/flash датотеке у потписима корисника. Поставите на 0 за неограничену висину.',
	'MAX_SIG_IMG_WIDTH'				=> 'Највећа ширина слике за потпис',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'		=> 'Највећа ширина слике/flash датотеке у потписима корисника. Поставите на 0 за неограничену ширину.',
	'MAX_SIG_LENGTH'				=> 'Највећа дужина потписа',
	'MAX_SIG_LENGTH_EXPLAIN'		=> 'Највећи број знакова у потписима корисника.',
	'MAX_SIG_SMILIES'				=> 'Највише смајлића по потпису',
	'MAX_SIG_SMILIES_EXPLAIN'		=> 'Највећи број смајлића дозвољен у потписима корисника. Поставите на 0 за неограничено смајлића.',
	'MAX_SIG_URLS'					=> 'Највише веза у потпису',
	'MAX_SIG_URLS_EXPLAIN'			=> 'Највећи број веза у потписима корисника. Поставите на 0 за неограничено веза.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'		=> 'Овде можете да одредите регистрацију и поставке везане за профил.',

	'ACC_ACTIVATION'				=> 'Активација налога',
	'ACC_ACTIVATION_EXPLAIN'		=> 'Ово одређује да ли корисници одмах имају приступ форуму или је потребна потврда. Можете такође у потпуности онемогућити нове регистрације.',
	'NEW_MEMBER_POST_LIMIT'			=> 'Ограничење порука новог члана',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'	=> 'Нови чланови су унутар групе <em>Новорегистровани корисници</em> све док не достигну овај број порука. Можете користити ову групу да их држите подаље од коришћења приватних порука или од прегледа њихових порука. <strong>Вредност 0 онемогућава ову поставку.</strong>',
	'NEW_MEMBER_GROUP_DEFAULT'		=> 'Поставља групу Новорегистровани корисници као задату',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'Уколико је постављено на Да и ограничење порука новог члана назначено Новорегистровани корисници неће бити само постављени у <em>Новорегистровани корисници</em> групу, већ ће ова група такође бити и њихова задата група. Ово може бити згодно уколико желите да доделите групно задати чин и/или грб који ода корисник наслеђује.',

	'ACC_ADMIN'					=> 'Од Админа',
	'ACC_DISABLE'				=> 'Онемогући',
	'ACC_NONE'					=> 'Ниједно',
	'ACC_USER'					=> 'Од Корисника',
//	'ACC_USER_ADMIN'			=> 'User + Admin',
	'ALLOW_EMAIL_REUSE'			=> 'Дозволи поновно коришћење мејл адресе',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'Различити корисници се могу регистровати коришћењем исте мејл адресе.',
	'COPPA'						=> 'COPPA',
	'COPPA_FAX'					=> 'COPPA број факса',
	'COPPA_MAIL'				=> 'COPPA адреса',
	'COPPA_MAIL_EXPLAIN'		=> 'Ово је адреса на коју ће родитељи послати COPPA регистрационе обрасце.',
	'ENABLE_COPPA'				=> 'Омогући COPPA',
	'ENABLE_COPPA_EXPLAIN'		=> 'Ово тражи од корисника да се изјасне да ли имају 13 или више година ради поштовања U.S. COPPA. Уколико је ово онемогућено COPPA посебне групе више неће бити приказане.',
	'MAX_CHARS'					=> 'Највише',
	'MIN_CHARS'					=> 'Најмање',
	'NO_AUTH_PLUGIN'			=> 'Није пронађен погодан плагин за потврду.',
	'PASSWORD_LENGTH'			=> 'Дужина лозинке',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'Најмањи и највећи број знакова у лозинкама.',
	'REG_LIMIT'					=> 'Број покушаја за регистрацију',
	'REG_LIMIT_EXPLAIN'			=> 'Број покушаја које корисник може да направи при потврди кода пре него што се сесија закључа.',
	'USERNAME_ALPHA_ONLY'		=> 'Само алфанумерички',
	'USERNAME_ALPHA_SPACERS'	=> 'Алфанумерички и раздвајачи',
	'USERNAME_ASCII'			=> 'ASCII (не међународни уникод)',
	'USERNAME_LETTER_NUM'		=> 'Било које слово и број',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'Било које слово, број, и раздвајач',
	'USERNAME_CHARS'			=> 'Ограничење броја знакова за корисничко име',
	'USERNAME_CHARS_ANY'		=> 'Било који знак',
	'USERNAME_CHARS_EXPLAIN'	=> 'Ограничава тип знака који може бити коришћен у корисничким именима, раздвајачи су: размак, -, +, _, [ и ].',
	'USERNAME_LENGTH'			=> 'Дужина корисничког имена',
	'USERNAME_LENGTH_EXPLAIN'	=> 'Најмањи и највећи број знакова у корисничким именима.',
));

// Feeds
$lang = array_merge($lang, array(
	'ACP_FEED_MANAGEMENT'				=> 'Опште Syndication Feeds поставке',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'Овај модул чини доступним различите ATOM Feeds, провлачећи било које ББкодове у порукама да би их начинио читљивим у спољашњим feeds.',

	'ACP_FEED_GENERAL'					=> 'Опште feed поставке',
	'ACP_FEED_POST_BASED'				=> 'На порукама основане feed поставке',
	'ACP_FEED_TOPIC_BASED'				=> 'На темама основане feed поставке',
	'ACP_FEED_SETTINGS_OTHER'			=> 'Остале feeds и поставке',

	'ACP_FEED_ENABLE'					=> 'Омогући feeds',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'Укључује или искључује ATOM feeds за унутрашњост форума.<br />Онемогућавањем овог искључују се сви feeds, без обзира како су поставке испод постављене.',
	'ACP_FEED_LIMIT'					=> 'Број појединости',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'Највећи број feed појединости за приказ.',

	'ACP_FEED_OVERALL'					=> 'Омогући feed широм форума',
	'ACP_FEED_OVERALL_EXPLAIN'			=> 'Нове поруке широм форума.',
	'ACP_FEED_FORUM'					=> 'Омогући feeds по форуму',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'Нове поруке једног форума и подфорума.',
	'ACP_FEED_TOPIC'					=> 'Омогући feeds по теми',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'Нове поруке једне теме.',

	'ACP_FEED_TOPICS_NEW'				=> 'Омогући нове теме feed',
	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'Омогућава “Нове теме” feed, који приказује последње направљене теме укључујући прву поруку.',
	'ACP_FEED_TOPICS_ACTIVE'			=> 'Омогући активне теме feed',
	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'Омогућава “Активне теме” feed, која приказује последње активне теме укључујући задњу поруку.',
	'ACP_FEED_NEWS'						=> 'News feed',
	'ACP_FEED_NEWS_EXPLAIN'				=> 'Гура прву поруку из ових форума. Одаберите без форума за онемогућавање news feed.<br />Одаберите вишеструке форуме држањем <samp>CTRL</samp> и кликтањем.',

	'ACP_FEED_OVERALL_FORUMS'			=> 'Омогући feed форума',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'Омогућава “Сви форуми” feed, који приказује списак форума.',

	'ACP_FEED_HTTP_AUTH'				=> 'Омогућава HTTP Ауторизацију',
	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'Омогућава HTTP ауторизацију, која омогућава корисницима да примају садржај који је сакривен корисницима гостима додавањем <samp>auth=http</samp> одреднице у feed URL. Молимо запамтите да неке PHP инсталације захтевају додатне промене у .htaccess датотеци. Упутства могу бити пронађена у тој датотеци.',
	'ACP_FEED_ITEM_STATISTICS'			=> 'Статистика појединости',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'Приказује појединачне статистике испод feed појединости<br />(н.пр. послато од, датум и време, одговора, прегледа)',
	'ACP_FEED_EXCLUDE_ID'				=> 'Искључи ове форуме',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'Садржај из ових <strong>неће бити укључен у feeds</strong>. Изаберите без форума за гурање података из свих форума.<br />Означите/Одзначите вишеструке форуме држањем <samp>CTRL</samp> и кликтањем.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'		=> 'Овде можете да означите и подесите CAPTCHA прикључке, који примењују различите начине за одбијање покушаја регистрације од такозваних спамботова.',
	'AVAILABLE_CAPTCHAS'					=> 'Доступни прикључци',
	'CAPTCHA_UNAVAILABLE'					=> 'CAPTCHA не може бити одабрана јер јој недостају потребне ствари.',
	'CAPTCHA_GD'							=> 'GD CAPTCHA',
	'CAPTCHA_GD_3D'							=> 'GD 3D Captcha',
	'CAPTCHA_GD_FOREGROUND_NOISE'			=> 'GD CAPTCHA шум у предњем плану',
	'CAPTCHA_GD_EXPLAIN'					=> 'Користи GD за прављење унапређених CAPTCHA.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'Користи шум у предњем плану за јаче прављење GD основаних CAPTCHA.',
	'CAPTCHA_GD_X_GRID'						=> 'GD CAPTCHA шум у позадини x-осе',
	'CAPTCHA_GD_X_GRID_EXPLAIN'				=> 'Користи доње поставке овога за јаче прављење GD основаних CAPTCHA. 0 ће онемогућити шум у позадини x-осе.',
	'CAPTCHA_GD_Y_GRID'						=> 'GD CAPTCHA шум у позадини y-осе',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'				=> 'Користи доње поставке овога за јаче прављење GD основаних CAPTCHA. 0 ће онемогућити шум у позадини y-осе.',
	'CAPTCHA_GD_WAVE'						=> 'GD CAPTCHA таласасто искривљење',
	'CAPTCHA_GD_WAVE_EXPLAIN'				=> 'Ово примењује таласасто искривљење на CAPTCHA.',
	'CAPTCHA_GD_3D_NOISE'					=> 'Додај 3D-noise објекте',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'			=> 'Ово додаје додатне објекте на CAPTCHA, преко слова.',
	'CAPTCHA_GD_FONTS'						=> 'Користи различите фонтове',
	'CAPTCHA_GD_FONTS_EXPLAIN'				=> 'Ова поставка контролише колико различитих облика слова је коришћено. Можете користити само задате облике или увести различита слова. Додавање малих слова је такође могуће.',
	'CAPTCHA_FONT_DEFAULT'					=> 'Задато',
	'CAPTCHA_FONT_NEW'						=> 'Нови облици',
	'CAPTCHA_FONT_LOWER'					=> 'Такође користи мала слова',
	'CAPTCHA_NO_GD'							=> 'CAPTCHA без GD',
	'CAPTCHA_PREVIEW_MSG'					=> 'Ваше измене поставке за видну потврду нису сачуване. Ово је само преглед.',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'CAPTCHA као што ће изгледати користећи тренутни одабир.',

	'CAPTCHA_SELECT'						=> 'Инсталирани CAPTCHA прикључци',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'CAPTCHA прикључци препознати од форума. Сиви улази нису доступни сада и могу требати подешавања пре употребе.',
	'CAPTCHA_CONFIGURE'						=> 'Подешавање CAPTCHAs',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'Мења поставке за изабрани CAPTCHA.',
	'CONFIGURE'								=> 'Подешавање',
	'CAPTCHA_NO_OPTIONS'					=> 'Ова CAPTCHA нема поставке подешавања.',

	'VISUAL_CONFIRM_POST'					=> 'Омогући видну потврду за поруке госта',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'Тражи од непознатих корисника да унесу случајно изабран код који се поклапа са сликом како би помогло у спречавању масовног слања порука.',
	'VISUAL_CONFIRM_REG'					=> 'Омогући видну потврду за регистрације',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'Тражи од нових корисника да унесу случајно изабран код који се поклапа са сликом како би помогло у спречавању масовног слања порука.',
	'VISUAL_CONFIRM_REFRESH'				=> 'Омогући корисницима да освеже слику за потврду',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'		=> 'Омогућава корисницима да траже нове кодове за потврду, уколико нису у могућности да разреше VC током регистрације. Неки прикључци могу да не подржавају ову могућност.',
));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'		=> 'Ови детаљи одређују податке коришћене за слање колачића прегледачима Ваших корисника. У већини случајева задате вредности за поставке колачића би требале бити довољне. Уколико Вам треба да промените било коју урадите то пажљиво, неисправне поставке могу спречити кориснике да се пријаве.',

	'COOKIE_DOMAIN'				=> 'Домен колачића',
	'COOKIE_NAME'				=> 'Име колачића',
	'COOKIE_PATH'				=> 'Путања колачића',
	'COOKIE_SECURE'				=> 'Безбедни колачићи',
	'COOKIE_SECURE_EXPLAIN'		=> 'Уколико се Ваш сервер покреће преко SSL-а подесите ово да омогућите или пак оставите да онемогућите. Имајући ово омогућено и не покрећући преко SSL-а довешће до грешака сервера приликом преусмеравања.',
	'ONLINE_LENGTH'				=> 'Преглед времена проведеног На вези',
	'ONLINE_LENGTH_EXPLAIN'		=> 'Број минута након кога неактивни корисници неће бити приказани на “Ко је На вези” списку. Повећањем ове вредности већа је обрада потребна за извођење списка.',
	'SESSION_LENGTH'			=> 'Дужина сесије',
	'SESSION_LENGTH_EXPLAIN'	=> 'Сесија ће истећи после овог времена, у секундама.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'Овде можете омогућити и онемогућити одређене функције форума за смањење потребне количине обраде. На већини сервера нема потребе да онемогућите било коју од функција. Међутим на одређеним системима или у окружењима дељеног хостинга може бити корисно да онемогућите могућности које Вам нису стварно потребне. Можете такође одредити ограничења за оптерећење система и активне сесије после којих ће форум постати недоступан.',

	'CUSTOM_PROFILE_FIELDS'			=> 'Властита поља профила',
	'LIMIT_LOAD'					=> 'Ограничи оптерећење система',
	'LIMIT_LOAD_EXPLAIN'			=> 'Уколико просечно оптерећење система током 1-минута премашује ову вредност форум ће аутоматски постати недоступан. Вредност од 1.0 је једнака ~100% искоришћености једног процесора. Ово ради само на UNIX основаним серверима и где је овај податак доступан. Вредност овде се сама враћа на 0 уколико phpBB није у могућности да добије ограничење оптерећења.',
	'LIMIT_SESSIONS'				=> 'Ограничи сесије',
	'LIMIT_SESSIONS_EXPLAIN'		=> 'Уколико број сесија премашује ову вредност током једног минута форум ће постати недоступан. Поставите на 0 за неограничено сесија.',
	'LOAD_CPF_MEMBERLIST'			=> 'Дозволи стилове за приказ властитих поља профила на списку чланова',
	'LOAD_CPF_VIEWPROFILE'			=> 'Прикажи властита поља профила у профилима корисника',
	'LOAD_CPF_VIEWTOPIC'			=> 'Прикажи властита поља профила у темама',
	'LOAD_USER_ACTIVITY'			=> 'Прикажи активност корисника',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'Прикажи активне теме/форум у профилу корисника и Корисничкој Контролној Плочи. Препоручљиво је да онемогућите ово на форумима са више од милион порука.',
	'RECOMPILE_STYLES'				=> 'Опет сакупи заостале састојке стила',
	'RECOMPILE_STYLES_EXPLAIN'		=> 'Проверава ажуриране састојке стила у систему датотека и опет их сакупља.',
	'YES_ANON_READ_MARKING'			=> 'Омогући бележење тема за госте',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'Чува податке статуса прочитан/непрочитан за госте. Уколико је онемогућено поруке су увек прочитане за госте.',
	'YES_BIRTHDAYS'					=> 'Омогући списак рођендана',
	'YES_BIRTHDAYS_EXPLAIN'			=> 'Уколико је онемогућено списак рођендана се више неће приказивати. Како би ова поставка имала утицаја могућност рођендана треба да буде омогућена такође.',
	'YES_JUMPBOX'					=> 'Омогући приказ Скочи на',
	'YES_MODERATORS'				=> 'Омогући приказ уредника',
	'YES_ONLINE'					=> 'Омогући списак Ко је на вези',
	'YES_ONLINE_EXPLAIN'			=> 'Приказује На вези кориснике на почетној страници, на форуму и страницама са темама.',
	'YES_ONLINE_GUESTS'				=> 'Омогући Ко је на вези списак гостију',
	'YES_ONLINE_GUESTS_EXPLAIN'		=> 'Омогућава приказ гостију који су На вези.',
	'YES_ONLINE_TRACK'				=> 'Омогући приказ корисника На вези/Није на вези',
	'YES_ONLINE_TRACK_EXPLAIN'		=> 'Приказује податак На вези за корисника у профилима и прегледима тема.',
	'YES_POST_MARKING'				=> 'Омогући тачкасте теме',
	'YES_POST_MARKING_EXPLAIN'		=> 'Означава да ли је корисник писао у теми.',
	'YES_READ_MARKING'				=> 'Омогући означавање тема од сервера',
	'YES_READ_MARKING_EXPLAIN'		=> 'Смешта податке статуса прочитан/непрочитан у базу пре него у колачић.',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB подржава плагине за потврду, или модуле. Ово Вам омогућава да одредите како су корисници потврђени када се пријаве на форум. Као задато три плагина су обезбеђена; DB, LDAP и Apache. Не траже сви начини додатан податак па зато само попуните поља уколико су одговарајућа за изабрани начин.',

	'AUTH_METHOD'				=> 'Изаберите начин потврде',

	'APACHE_SETUP_BEFORE_USE'	=> 'Морате да подесите apache потврду пре него пребаците phpBB на овај начин потврде. Имајте у виду да корисничко име које користите за apache потврду мора бити исто као и Ваше phpBB корисничко име. Apache потврда може бити коришћена само са mod_php (не са CGI верзијом) и онемогућеним safe_mode.',

	'LDAP_DN'						=> 'LDAP база <var>dn</var>',
	'LDAP_DN_EXPLAIN'				=> 'Ово је Отмено Име, које смешта податке корисника, нпр. <samp>o=Моја компанија,c=RS</samp>.',
	'LDAP_EMAIL'					=> 'LDAP мејл атрибут',
	'LDAP_EMAIL_EXPLAIN'			=> 'Подесите ово на име Вашег уноса мејл атрибута корисника (уколико један постоји) како бисте аутоматски подесили мејл адресу за нове кориснике. Остављајући ово празно доводи до празне мејл адресе за кориснике који се пријављују први пут.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'Повезивање са LDAP сервером није успешно са изабраним корисником/лозинком.',
	'LDAP_NO_EMAIL'					=> 'Изабрани мејл атрибут не постоји.',
	'LDAP_NO_IDENTITY'				=> 'Не могу да пронађем идентитет пријаве за %s.',
	'LDAP_PASSWORD'					=> 'LDAP лозинка',
	'LDAP_PASSWORD_EXPLAIN'			=> 'Оставите празно уколико желите анонимно повезивање. Сем тога испуните лозинку за корисника изнад. Потребно за Active Directory Servers.<br /><em><strong>УПОЗОРЕЊЕ:</strong> Ова лозинка ће бити сачувана као plain text у бази видљиво сваком ко може да приступи Вашој бази или ко може да прегледа ову конфигурациону страницу.</em>',
	'LDAP_PORT'						=> 'LDAP порт сервера',
	'LDAP_PORT_EXPLAIN'				=> 'По избору можете одредити порт који би требао бити коришћен за повезивање на LDAP сервер уместо задатог порта 389.',
	'LDAP_SERVER'					=> 'LDAP име сервера',
	'LDAP_SERVER_EXPLAIN'			=> 'Уколико користите LDAP ово је име сервера или IP адресе LDAP сервера. Други начин је да можете да назначите URL као ldap://hostname:port/',
	'LDAP_UID'						=> 'LDAP <var>uid</var>',
	'LDAP_UID_EXPLAIN'				=> 'Ово је кључ под којим претражује за дати идентитет пријаве, нпр. <var>uid</var>, <var>sn</var>, итд.',
	'LDAP_USER'						=> 'LDAP корисник <var>dn</var>',
	'LDAP_USER_EXPLAIN'				=> 'Оставите празно за коришћење анонимног повезивања. Уколико је попуњено phpBB користи назначено Отмено име при покушајима пријаве за проналажење исправног корисника, нпр. <samp>uid=Корисничко име,ou=Моја јединица,o=Моја компанија,c=RS</samp>. Потребно за Active Directory Servers.',
	'LDAP_USER_FILTER'				=> 'LDAP пречистач корисника',
	'LDAP_USER_FILTER_EXPLAIN'		=> 'По избору можете даље ограничити објекте претраге са додатним пречистачима. На пример <samp>objectClass=posixGroup</samp> ће довести до коришћења <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp>',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'Овде одређујете поставке сервера и домена. Молимо осигурајте да су подаци које сте унели исправни, грешке ће довести да се у мејловима садрже неисправни подаци. Када уносите назив домена запамтите да унесете http:// или други протокол. Број порта мењајте само уколико знате да Ваш сервер користи другачију вредност, порт 80 је исправан у већини случајева.',

	'ENABLE_GZIP'				=> 'Омогући GZip сабијање',
	'ENABLE_GZIP_EXPLAIN'		=> 'Изведени садржај ће бити сабијен пре него што буде био послат кориснику. Ово може смањити мрежни саобраћај али ће такође повећати искоришћеност CPU на оба сервера и код клијента. Потребује zlib PHP екстензију да би био учитан.',
	'FORCE_SERVER_VARS'			=> 'Форсирај серверске URL поставке',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'Уколико је подешено на Да поставке сервера одређене овде биће коришћене уместо аутоматски утврђене вредности.',
	'ICONS_PATH'				=> 'Путања за смештање иконица',
	'ICONS_PATH_EXPLAIN'		=> 'Путања под Вашом phpBB root фасциклом, нпр. <samp>images/icons</samp>.',
	'PATH_SETTINGS'				=> 'Путање поставки',
	'RANKS_PATH'				=> 'Путања за смештање сличица за чин',
	'RANKS_PATH_EXPLAIN'		=> 'Путања под Вашом phpBB root фасциклом, нпр. <samp>images/ranks</samp>.',
	'SCRIPT_PATH'				=> 'Путања скрипте',
	'SCRIPT_PATH_EXPLAIN'		=> 'Путања где је phpBB смештен у односу на назив домена, нпр. <samp>/phpBB3</samp>.',
	'SERVER_NAME'				=> 'Назив домена',
	'SERVER_NAME_EXPLAIN'		=> 'Назив домена са кога се покреће овај форум (на пример: <samp>www.example.com</samp>).',
	'SERVER_PORT'				=> 'Порт сервера',
	'SERVER_PORT_EXPLAIN'		=> 'Порт на коме ради Ваш сервер, обично 80, промените само уколико је другачији.',
	'SERVER_PROTOCOL'			=> 'Протокол сервера',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'Ово је коришћено као протокол сервера уколико су ове поставке форсиране. Уколико је празно или није форсирано протокол је одређен од сигурносних поставки колачића (<samp>http://</samp> или <samp>https://</samp>).',
	'SERVER_URL_SETTINGS'		=> 'Поставке URL сервера',
	'SMILIES_PATH'				=> 'Путања за смештање смајлића',
	'SMILIES_PATH_EXPLAIN'		=> 'Путања под Вашом phpBB root фасциклом, нпр. <samp>images/smilies</samp>.',
	'UPLOAD_ICONS_PATH'			=> 'Путања за смештање проширене групе иконица',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'Путања под Вашом phpBB root фасциклом, нпр. <samp>images/upload_icons</samp>.',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'		=> 'Овде можете да одредите сесију и поставке везане за пријаву.',

	'ALL'							=> 'Све',
	'ALLOW_AUTOLOGIN'				=> 'Дозволи трајне пријаве',
	'ALLOW_AUTOLOGIN_EXPLAIN'		=> 'Одређује да ли корисници могу да се аутоматски пријаве када посете форум.',
	'AUTOLOGIN_LENGTH'				=> 'Дужина трајања трајне пријаве (у данима)',
	'AUTOLOGIN_LENGTH_EXPLAIN'		=> 'Број дана после којег су трајне пријаве уклоњене или 0 за онемогућавање.',
	'BROWSER_VALID'					=> 'Провера прегледача',
	'BROWSER_VALID_EXPLAIN'			=> 'Омогућава проверу прегледача за сваку сесију побољшавајући сигурност.',
	'CHECK_DNSBL'					=> 'Упореди IP са DNS Blackhole List',
	'CHECK_DNSBL_EXPLAIN'			=> 'Уколико је омогућено корисникова IP адреса се упоређује са следећим DNSBL сервисима при регистрацији и слању порука: <a href="http://spamcop.net">spamcop.net</a> и <a href="http://www.spamhaus.org">www.spamhaus.org</a>. Ова провера може потрајати, у зависности од конфигурације сервера. Уколико је присутно успорење или превише лажно позитивних пријављено препоручљиво је да онемогућите ову проверу.',
	'CLASS_B'						=> 'A.B',
	'CLASS_C'						=> 'A.B.C',
	'EMAIL_CHECK_MX'				=> 'Провера мејл домена за исправан MX запис',
	'EMAIL_CHECK_MX_EXPLAIN'		=> 'Уколико је омогућено, мејл домен прибављен при регистрацији и променама профила се проверава за исправан MX запис.',
	'FORCE_PASS_CHANGE'				=> 'Форсирај промену лозинке',
	'FORCE_PASS_CHANGE_EXPLAIN'		=> 'Тражи од корисника да промене њихову лозинку после постављеног броја дана. Поставка ове вредности на 0 онемогућава ово понашање.',
	'FORM_TIME_MAX'					=> 'Највеће време за попуњавање образаца',
	'FORM_TIME_MAX_EXPLAIN'			=> 'Време за које корисник мора да попуни образац. Користите -1 за онемогућавање. Молимо знајте да образац може постати неисправан уколико сесија истекне, без обзира на ову поставку.',
	'FORM_SID_GUESTS'				=> 'Прилагоди обрасце за сесије гостију',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'Уколико је омогућено, симбол обрасца додељен гостима ће бити ексклузиван за сесију. Ово може узроковати сметње са неким ISPs.',
	'FORWARDED_FOR_VALID'			=> 'Проверено <var>X_FORWARDED_FOR</var> заглавље',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'Сесије ће бити настављене само уколико је послато <var>X_FORWARDED_FOR</var> заглавље једнако оним послатим са претходним захтевом. Забране ће бити упоређене са IP адресама у <var>X_FORWARDED_FOR</var> такође.',
	'IP_VALID'						=> 'Провера IP сесије',
	'IP_VALID_EXPLAIN'				=> 'Одређује колико IP адреса корисника је коришћено за проверу сесија; <samp>Све</samp> упоређује потпуне адресе, <samp>A.B.C</samp> прве x.x.x, <samp>A.B</samp> прве x.x, <samp>Ниједно</samp> онемогућава проверу. На IPv6 адресе <samp>A.B.C</samp> упоређује прва 4 блока и <samp>A.B</samp> прва 3 блока.',
	'MAX_LOGIN_ATTEMPTS'			=> 'Највећи број покушаја пријаве',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'После овог броја погрешних пријава корисник треба да додатно потврди своју пријаву видно (видна потврда).',
	'NO_IP_VALIDATION'				=> 'Ниједно',
	'NO_REF_VALIDATION'				=> 'Ниједно',
	'PASSWORD_TYPE'					=> 'Сложеност лозинке',
	'PASSWORD_TYPE_EXPLAIN'			=> 'Одређује колико сложена лозинка треба да буде када се подешава или мења, накнадне могућности укључују претходне.',
	'PASS_TYPE_ALPHA'				=> 'Мора да садржи слова и бројеве',
	'PASS_TYPE_ANY'					=> 'Без захтева',
	'PASS_TYPE_CASE'				=> 'Мора садржати мала и велика слова',
	'PASS_TYPE_SYMBOL'				=> 'Мора да садржи симболе',
	'REF_HOST'						=> 'Само провера хостинга',
	'REF_PATH'						=> 'Такође провери путању',
	'REFERER_VALID'					=> 'Упореди препоручиоца',
	'REFERER_VALID_EXPLAIN'			=> 'Уколико је омогућено, POST захтеви препоручиоца ће бити упоређени са поставкама путање хостинг/скрипте. Ово може проузроковати сметње са форумом користећи неколико домена и или вањских пријава.',
	'TPL_ALLOW_PHP'					=> 'Дозволи php у предлошцима',
	'TPL_ALLOW_PHP_EXPLAIN'			=> 'Уколико је ова поставка омогућена, <code>PHP</code> и <code>INCLUDEPHP</code> саопштења ће бити препозната и обрађена у предлошцима.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'Овај податак се користи када форум шаље мејлове Вашим корисницима. Молимо Вас да проверите да ли су мејл адресе које сте унели исправне, све неиспоручене поруке ће бити послате на ову адресу. Уколико Ваш хостинг не подржава природни (PHP основани) мејл сервис можете уместо тога послати поруке користећи непосредно SMTP. Ово захтева адресу одговарајућег сервера (питајте Вашег провајдера уколико је неопходно). Уколико сервер захтева потврду (и само уколико захтева) унесите неопходно корисничко име, лозинку и начин потврде.',

	'ADMIN_EMAIL'					=> 'Повратна мејл адреса',
	'ADMIN_EMAIL_EXPLAIN'			=> 'Ово ће бити коришћено као повратна адреса за све мејлове, у ствари контакт мејл адреса. Увек ће бити коришћено као <samp>Повратна-Путања</samp> и <samp>Пошиљалац</samp> адреса мејловима.',
	'BOARD_EMAIL_FORM'				=> 'Корисници шаљу мејл преко форума',
	'BOARD_EMAIL_FORM_EXPLAIN'		=> 'Уместо приказивања мејл адреса корисници су у могућности да шаљу мејлове преко форума.',
	'BOARD_HIDE_EMAILS'				=> 'Сакриј мејл адресе',
	'BOARD_HIDE_EMAILS_EXPLAIN'		=> 'Ова функција чува мејл адресе у потпуној приватности.',
	'CONTACT_EMAIL'					=> 'Мејл адреса за контакт',
	'CONTACT_EMAIL_EXPLAIN'			=> 'Ова адреса ће бити коришћена увек када је посебан контакт потребан, нпр. спам, грешка излаза, итд. Увек ће бити коришћена за <samp>Од</samp> и <samp>Одговори на</samp> адресу у мејловима.',
	'EMAIL_FUNCTION_NAME'			=> 'Назив мејл функције',
	'EMAIL_FUNCTION_NAME_EXPLAIN'	=> 'Мејл функција коришћена за слање порука преко PHP.',
	'EMAIL_PACKAGE_SIZE'			=> 'Величина мејл пакета',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'Ово је највећи број мејлова послатих у једном пакету. Ова поставка се примењује на интерне поруке на чекању; поставите ову вредност на 0 уколико имате сметњи са обавештењима о неиспорученим мејловима.',
	'EMAIL_SIG'						=> 'Мејл потпис',
	'EMAIL_SIG_EXPLAIN'				=> 'Овај текст ће бити приложен у свим мејловима које форум шаље.',
	'ENABLE_EMAIL'					=> 'Омогући мејлове путем форума',
	'ENABLE_EMAIL_EXPLAIN'			=> 'Уколико је ово постављено на онемогућено ниједан мејл неће бити послат са форума уопште. <em>Запамтите да поставке активације налога корисника и админа потребују да ова поставка буде омогућена. Уколико тренутно користите “корисник” или “админ” активацију у поставкама активације, онемогућавањем ове поставке неће се тражити никаква активација нових налога.</em>',
	'SMTP_AUTH_METHOD'				=> 'Начин потврде за SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'		=> 'Коришћено само уколико је корисничко име/лозинка подешено, питајте Вашег провајдера уколико нисте сигурни који начин да користите.',
	'SMTP_CRAM_MD5'					=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'				=> 'DIGEST-MD5',
	'SMTP_LOGIN'					=> 'Пријава',
	'SMTP_PASSWORD'					=> 'SMTP лозинка',
	'SMTP_PASSWORD_EXPLAIN'			=> 'Унесите лозинку само уколико Ваш SMTP сервер то захтева.<br /><em><strong>Упозорење:</strong> Ова лозинка ће бити сачувана као plain text у бази видљиво сваком ко може да приступи Вашој бази или ко може да прегледа ову конфигурациону страницу.</em>',
	'SMTP_PLAIN'					=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'			=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'						=> 'SMTP порт сервера',
	'SMTP_PORT_EXPLAIN'				=> 'Промените ово само уколико знате да је Ваш SMTP сервер на другом порту.',
	'SMTP_SERVER'					=> 'SMTP адреса сервера',
	'SMTP_SETTINGS'					=> 'SMTP поставке',
	'SMTP_USERNAME'					=> 'SMTP корисничко име',
	'SMTP_USERNAME_EXPLAIN'			=> 'Унесите корисничко име само уколико га Ваш SMTP сервер захтева.',
	'USE_SMTP'						=> 'Користи SMTP сервер за мејл',
	'USE_SMTP_EXPLAIN'				=> 'Изаберите “Да” уколико желите или морате да пошаљете мејл преко наименованог сервера уместо месне мејл функције.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'Овде можете да омогућите и контролишете употребу Jabber за тренутне поруке и обавештења форума. Jabber је open source протокол и стога доступан за коришћење од било кога. Неки Jabber сервери укључују транспорте који Вам омогућавају да се повежете са корисницима на другим мрежама. Не нуде сви сервери све транспорте и промене у протоколима могу спречити транспорте да раде. Молимо Вас да проверите да ли сте већ унели детаље регистрованог налога - phpBB ће користити детаље које сте унели овде.',

	'JAB_ENABLE'				=> 'Омогући Jabber',
	'JAB_ENABLE_EXPLAIN'		=> 'Омогућава коришћење Jabber порука и обавештења.',
	'JAB_GTALK_NOTE'			=> 'Молимо знајте да GTalk неће радити јер <samp>dns_get_record</samp> функција не може бити пронађена. Ова функција није доступна у PHP4, и не може се примењивати на Windows платформама. Тренутно не ради на BSD-основаним системима, укључујући Mac OS.',
	'JAB_PACKAGE_SIZE'			=> 'Величина Jabber пакета',
	'JAB_PACKAGE_SIZE_EXPLAIN'	=> 'Ово је број порука послат у једном пакету. Уколико је постављено на 0 порука је послата тренутно и неће бити на чекању за касније слање.',
	'JAB_PASSWORD'				=> 'Jabber лозинка',
	'JAB_PASSWORD_EXPLAIN'		=> '<em><strong>Упозорење:</strong> Ова лозинка ће бити сачувана као plain text у бази видљиво сваком ко може да приступи Вашој бази или ко може да прегледа ову конфигурациону страницу.</em>',
	'JAB_PORT'					=> 'Jabber порт',
	'JAB_PORT_EXPLAIN'			=> 'Оставите празно изузев уколико знате да није порт 5222.',
	'JAB_SERVER'				=> 'Jabber сервер',
	'JAB_SERVER_EXPLAIN'		=> 'Погледајте %sjabber.org%s за списак сервера.',
	'JAB_SETTINGS_CHANGED'		=> 'Jabber поставке су успешно промењене.',
	'JAB_USE_SSL'				=> 'Користите SSL за повезивање',
	'JAB_USE_SSL_EXPLAIN'		=> 'Уколико је омогућено покушаће се са успостављањем сигурне везе. Jabber порт ће бити измењен у 5223 уколико је порт 5222 назначен.',
	'JAB_USERNAME'				=> 'Jabber корисничко име или JID',
	'JAB_USERNAME_EXPLAIN'		=> 'Одредите регистровано корисничко име или ваљан JID. Корисничком имену неће бити проверавана ваљаност. Уколико назначите само корисничко име, онда ће Ваш JID бити корисничко име и сервер који сте назначили изнад. У супротном, назначите ваљан JID, на пример user@jabber.org.',
));

?>