<?php
// Call Image_TextTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "imageisthesameTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'imageisthesame.php';

/**
 * Test class for Image_Text.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-15 at 15:14:46.
 */
class imageisthesameTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("imageisthesameTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->dir = dirname(__FILE__) . '/testimages/';
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     *
     */
    public function testSame() {
        //same image
        $this->assertTrue(imageisthesame(
            $this->dir . '10x5-red.png',
            $this->dir . '10x5-red.png'
        ));
        //same image
        $this->assertTrue(imageisthesame(
            imagecreatefrompng($this->dir . '10x5-red.png'),
            imagecreatefrompng($this->dir . '10x5-red.png')
        ));
    }


    public function testSize() {
        //wrong size
        $this->assertFalse(imageisthesame(
            $this->dir . '10x5-red.png',
            $this->dir . '5x10-red.png'
        ));
        $this->assertFalse(imageisthesame(
            imagecreatefrompng($this->dir . '10x5-red.png'),
            imagecreatefrompng($this->dir . '5x10-red.png')
        ));
    }

    public function testWrongColor() {
        //wrong color
        $this->assertFalse(imageisthesame(
            $this->dir . '10x5-red.png',
            $this->dir . '10x5-white.png'
        ));
    }

    public function testIndexed() {
        //same, but indexed
        $this->assertTrue(imageisthesame(
            $this->dir . '10x5-white.png',
            $this->dir . '10x5-white-index.png'
        ));

        //wrong color, but indexed
        $this->assertFalse(imageisthesame(
            $this->dir . '10x5-red.png',
            $this->dir . '10x5-white-index.png'
        ));
    }

    public function testGreyscale() {
       //same, but greyscale
        $this->assertTrue(imageisthesame(
            $this->dir . '10x5-white.png',
            $this->dir . '10x5-white-grey.png'
        ));
        //wrong color, greyscale
        $this->assertFalse(imageisthesame(
            $this->dir . '10x5-red.png',
            $this->dir . '10x5-white-grey.png'
        ));
    }

    public function testImagetypes() {
        //same color, different image type, one color
        $this->assertTrue(imageisthesame(
            $this->dir . '5x10-red-254.jpg',
            $this->dir . '5x10-red-254.png'
        ));
        //same color, different type, gradient
        $this->assertTrue(imageisthesame(
            $this->dir . '5x10-gradient.jpg',
            $this->dir . '5x10-gradient.png'
        ));
    }

}

// Call Image_TextTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "imageisthesameTest::main") {
    imageisthesameTest::main();
}
?>
