#ifndef __EFFECTSELECTOR_H__
#define __EFFECTSELECTOR_H__


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkcombo.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkframe.h>
#include <gtk/gtklabel.h>
#include <gtk/gtktreeview.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtkcellrendererpixbuf.h>


G_BEGIN_DECLS

#define EFFECTSELECTOR_TYPE			(effectselector_get_type())
#define EFFECTSELECTOR(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), EFFECTSELECTOR_TYPE, EffectSelector))
#define EFFECTSELECTOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), EFFECTSELECTOR_TYPE, EffectSelectorClass))
#define IS_EFFECTSELECTOR(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), EFFECTSELECTOR_TYPE))
#define IS_EFFECTSELECTOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), EFFECTSELECTOR_TYPE))

typedef struct _EffectSelector EffectSelector;
typedef struct _EffectSelectorClass EffectSelectorClass;

class EffectListSource;

struct _EffectSelector
{
	GtkVBox box;
	GtkListStore *liststore;
	GtkWidget *treeview;
	GList *imagelist;
	EffectListSource *els;
	GtkWidgetClass *parent_class;
};


struct _EffectSelectorClass
{
	GtkVBoxClass parent_class;

	void (*changed)(EffectSelector *combo);
};

GType effectselector_get_type (void);

GtkWidget* effectselector_new (EffectListSource *els);
class EffectListItem;
EffectListItem *effectselector_get_selected(EffectSelector *es);
gboolean effectselector_refresh(EffectSelector *c);

G_END_DECLS

#endif /* __EFFECTSELECTOR_H__ */
