/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/mainwindow.cc
 *******************************************/

#include "mainwindow.hh"

/*** Constructor ***/
class_window_main::class_window_main() :

expander_permissions(Text::str_PERMISSIONS),

table_rights       (2, 4, false),                 // (x, y, homogenous)
table_encryption   (1, 3, false),
table_split_options(2, 1, false),

vbox_window               (false, 0),             // (homogenous, spacing)
vbox_content              (false, 5),
vbox_merge                (false, 5),
vbox_split                (false, 5),
vbox_stamp                (false, 5),
vbox_attachments          (false, 5),
vbox_permissions_passwords(true,  5),
vbox_passwords            (true,  5),

hbox_merge                 (false, 5),
hbox_merge_buttons         (false, 5),
hbox_merge_options         (false, 5),
hbox_split_sourcefile      (false, 5),
hbox_split_prefix          (false, 5),
hbox_split_digits          (false, 5),
hbox_stamp_sourcefile      (false, 5),
hbox_stamp_background      (false, 5),
hbox_stamp_selection       (false, 5),
hbox_attachments_sourcefile(false, 5),
hbox_attachments_buttons   (false, 5),
hbox_attachments_filepage  (false, 5),
hbox_permissions           (false, 5),
hbox_stamp                 (true,  5),
hbox_save                  (false, 5),

frame_split_sourcefile       (Text::str_SOURCE_FILE),
frame_split_prefix           (Text::str_PREFIX),
frame_split_digits           (Text::str_DIGITS),
frame_stamp_sourcefile       (Text::str_SOURCE_FILE),
frame_stamp_background       (Text::str_BACKGROUND_STAMP_FILE),
frame_stamp_selection        (Text::str_SELECT),
frame_attachments_sourcefile (Text::str_SOURCE_FILE),
frame_rights                 (Text::str_RIGHTS),
frame_passwords_ownerpassword(Text::str_OWNER_PASSWORD),
frame_passwords_userpassword (Text::str_USER_PASSWORD),
frame_encryption             (Text::str_ENCRYPTION),

button_merge_options         (Gtk::Stock::PREFERENCES),
button_split_sourcefile      (Gtk::Stock::ADD),
button_stamp_sourcefile      (Gtk::Stock::ADD),
button_stamp_background      (Gtk::Stock::ADD),
button_attachments_sourcefile(Gtk::Stock::ADD),
button_save                  (Gtk::Stock::SAVE),

checkbutton_rights_printing         (Text::str_PRINTING,           false),
checkbutton_rights_degradedprinting (Text::str_DEGRADED_PRINTING,  false),
checkbutton_rights_modifycontents   (Text::str_MODIFY_CONTENTS,    false),
checkbutton_rights_assembly         (Text::str_ASSEMBLY,           false),
checkbutton_rights_copycontents     (Text::str_COPY_CONTENTS,      false),
checkbutton_rights_screenreaders    (Text::str_SCREENREADERS,      false),
checkbutton_rights_modifyannotations(Text::str_MODIFY_ANNOTATIONS, false),
checkbutton_rights_fillin           (Text::str_FILL_IN,            false),

radiobutton_split_auto       (Text::str_AUTO,        false),
radiobutton_split_manual     (Text::str_MANUAL,      false),
radiobutton_stamp_background (Text::str_BACKGROUND,  false),
radiobutton_stamp_stamp      (Text::str_STAMP,       false),
radiobutton_attachments_file (Text::str_ADD_TO_FILE, false),
radiobutton_attachments_page (Text::str_ADD_TO_PAGE, false),
radiobutton_encryption_none  (Text::str_NONE,        false),
radiobutton_encryption_40bit (Text::str_40_BIT,      false),
radiobutton_encryption_128bit(Text::str_128_BIT,     false),

adjustment_split_digits    (3.0, 1.0, 10.0, 1.0, 1.0, 0.0),
adjustment_attachments_page(1.0, 1.0,  1.0, 1.0, 1.0, 0.0),

spinbutton_split_digits(adjustment_split_digits),
spinbutton_attachments_page(adjustment_attachments_page),

alignment_merge_buttons       (Gtk::ALIGN_LEFT,   Gtk::ALIGN_CENTER, 0.0, 0.0),
alignment_merge_options       (Gtk::ALIGN_RIGHT,  Gtk::ALIGN_CENTER, 0.0, 0.0),
alignment_attachments_buttons (Gtk::ALIGN_LEFT,   Gtk::ALIGN_CENTER, 0.0, 0.0),
alignment_attachments_filepage(Gtk::ALIGN_RIGHT,  Gtk::ALIGN_CENTER, 0.0, 0.0),
alignment_stamp_selectionframe(Gtk::ALIGN_LEFT,   Gtk::ALIGN_CENTER, 0.0, 0.0){
	
	// Window
	set_title(Text::str_PDF_CHAIN);
	set_default_size(650, 500);
	set_border_width(0);
	set_position(Gtk::WIN_POS_CENTER);
	
	// Window -> Icon
	Glib::RefPtr<Gio::File> file = Gio::File::create_for_path(PATH_ICON);
	if(file->query_exists() == true){
		set_default_icon_from_file(PATH_ICON);
	}
	
	// Menu (Action Group)
	ref_menu_window_main = Gtk::ActionGroup::create();
	
	ref_menu_window_main->add(Gtk::Action::create("menu_file", Text::str_FILE));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_file_new", Gtk::Stock::NEW),
							  sigc::mem_fun(*this, &class_window_main::on_menu_file_new));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_file_quit", Gtk::Stock::QUIT),
							  sigc::mem_fun(*this, &class_window_main::on_menu_file_quit));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools", Text::str_TOOLS));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_extract", Text::str_EXTRACT_ATTACHMENTS),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_extract));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_compress", Text::str_UNCOMPRESS_COMPRESS),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_compress));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_dump_data_fields", Text::str_DUMP_DATA_FIELDS),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_dump_data_fields));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_dump_data", Text::str_DUMP_DATA),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_dump_data));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_update_info", Text::str_UPDATE_INFO),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_update_info));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_generate_fdf", Text::str_GENERATE_FDF),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_generate_fdf));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_fill_form", Text::str_FILL_FORM),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_fill_form));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_flatten", Text::str_FLATTEN),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_flatten));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_tools_drop_xfa", Text::str_DROP_XFA),
							  sigc::mem_fun(*this, &class_window_main::on_menu_tools_drop_xfa));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_help", "Help"));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_help_help", Gtk::Stock::HELP),
							  sigc::mem_fun(*this, &class_window_main::on_menu_help_help));
	
	ref_menu_window_main->add(Gtk::Action::create("menu_help_about", Gtk::Stock::ABOUT),
							  sigc::mem_fun(*this, &class_window_main::on_menu_help_about));
	
	
	// UI-Manager
	ref_uimanager_window_main = Gtk::UIManager::create();
	ref_uimanager_window_main->insert_action_group(ref_menu_window_main);
	add_accel_group(ref_uimanager_window_main->get_accel_group());            // Add keyboard shortcuts
	
	Glib::ustring ui_info =
		"<ui>"
		"  <menubar name='menu'>"
		"    <menu action='menu_file'>"
		"      <menuitem action='menu_file_new'/>"
		"      <menuitem action='menu_file_quit'/>"
		"    </menu>"
		"    <menu action='menu_tools'>"
		"      <menuitem action='menu_tools_extract'/>"
		"      <separator/>"
		"      <menuitem action='menu_tools_compress'/>"
		"      <separator/>"
		"      <menuitem action='menu_tools_dump_data_fields'/>"
		"      <menuitem action='menu_tools_dump_data'/>"
		"      <menuitem action='menu_tools_update_info'/>"
		"      <separator/>"
		"      <menuitem action='menu_tools_generate_fdf'/>"
		"      <menuitem action='menu_tools_fill_form'/>"
		"      <menuitem action='menu_tools_flatten'/>"
		"      <menuitem action='menu_tools_drop_xfa'/>"
		"    </menu>"
		"    <menu action='menu_help'>"
		"      <menuitem action='menu_help_help'/>"
		"      <menuitem action='menu_help_about'/>"
		"    </menu>"
		"  </menubar>"
		"</ui>";
	
#ifdef GLIBMM_EXCEPTIONS_ENABLED
	try{
		ref_uimanager_window_main->add_ui_from_string(ui_info);
	}
	catch(const Glib::Error& ex){
		
		// Error Message
		dialogs.error_cerr("class_window_main::class_window_main()", "Building menus failed", ex.what());
	}    
#else
	std::auto_ptr<Glib::Error> ex;
	ref_uimanager_window_main->add_ui_from_string(ui_info, ex);
	if(ex.get()){
		
		// Error Message
		dialogs.error_cerr("class_window_main::class_window_main()", "Building menus faild", ex->what());
	}
#endif // GLIBMM_EXCEPTIONS_ENABLED
	
	pt_menubar = NULL;
	pt_menubar = ref_uimanager_window_main->get_widget("/menu");
	
	
	// Set Dialogs and Parent to TreeViews and Tools
	treeview_merge.set_dialogs(&dialogs);
	treeview_merge.set_parent(this);
	treeview_attachments.set_dialogs(&dialogs);
	treeview_attachments.set_parent(this);

	window_tools_extract.set_dialogs(&dialogs);
	window_tools_compress.set_dialogs(&dialogs);
	window_tools_dump_data_fields.set_dialogs(&dialogs);
	window_tools_dump_data.set_dialogs(&dialogs);
	window_tools_update_info.set_dialogs(&dialogs);
	window_tools_generate_fdf.set_dialogs(&dialogs);
	window_tools_fill_form.set_dialogs(&dialogs);
	window_tools_flatten.set_dialogs(&dialogs);
	window_tools_drop_xfa.set_dialogs(&dialogs);
	
	
	// Signal Handlers
	// Signal Handlers -> Window
	signal_delete_event().connect(sigc::mem_fun
		(*this, &class_window_main::on_quit));
	
	// Signal Handler -> Notebook
	notebook.signal_switch_page().connect(sigc::mem_fun
		(*this, &class_window_main::on_notebook_switch_page));
	
	// Signal Handlers -> Buttons
	button_merge_up.signal_clicked().connect(sigc::mem_fun
		(*this,&class_window_main::on_button_merge_up));
	
	button_merge_down.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_merge_down));
	
	button_merge_copy.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_merge_copy));
	
	button_merge_add.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_merge_add));
	
	button_merge_remove.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_merge_remove));
	
	button_merge_options.signal_toggled().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_merge_options));
	
	button_split_sourcefile.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_split_sourcefile));
	
	button_stamp_sourcefile.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_stamp_sourcefile));
	
	button_stamp_background.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_stamp_background));
	
	button_attachments_sourcefile.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_attachments_sourcefile));
	
	button_attachments_up.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_attachments_up));
	
	button_attachments_down.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_attachments_down));
	
	button_attachments_add.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_attachments_add));
	
	button_attachments_remove.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_attachments_remove));
	
	button_save.signal_clicked().connect(sigc::mem_fun
		(*this, &class_window_main::on_button_save));
	
	
	// Widgets
	// Notebook -> Merge -> Scrolled Window
	scrolledwindow_merge.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow_merge.add(treeview_merge);
	
	// Notebook -> Merge -> Combobox
	combobox_merge_id.set_size_request(150, -1);
	combobox_merge_id.append_text(Text::str_CREATE_NEW_ID);
	combobox_merge_id.append_text(Text::str_ID_FROM_FIRST_PDF);
	combobox_merge_id.append_text(Text::str_ID_FROM_FINAL_PDF);
	combobox_merge_id.set_active(0);
	
	// Notebook -> Merge -> Buttons
	button_merge_options.set_size_request(150,-1);
	
	// Notebook -> Merge -> Buttons (Set Stock Icons only)
	button_merge_up.set_image(*Gtk::manage    (new Gtk::Image(Gtk::Stock::GO_UP,   Gtk::ICON_SIZE_BUTTON)));
	button_merge_down.set_image(*Gtk::manage  (new Gtk::Image(Gtk::Stock::GO_DOWN, Gtk::ICON_SIZE_BUTTON)));
	button_merge_copy.set_image(*Gtk::manage  (new Gtk::Image(Gtk::Stock::COPY,    Gtk::ICON_SIZE_BUTTON)));
	button_merge_add.set_image(*Gtk::manage	  (new Gtk::Image(Gtk::Stock::ADD,     Gtk::ICON_SIZE_BUTTON)));
	button_merge_remove.set_image(*Gtk::manage(new Gtk::Image(Gtk::Stock::REMOVE,  Gtk::ICON_SIZE_BUTTON)));
	
	button_merge_up.set_tooltip_text    (Text::tip_UP);
	button_merge_down.set_tooltip_text  (Text::tip_DOWN);
	button_merge_copy.set_tooltip_text  (Text::tip_COPY);
	button_merge_add.set_tooltip_text   (Text::tip_ADD);
	button_merge_remove.set_tooltip_text(Text::tip_REMOVE);
	
	hbox_merge_buttons.pack_start(button_merge_up,     Gtk::PACK_SHRINK);
	hbox_merge_buttons.pack_start(button_merge_down,   Gtk::PACK_SHRINK);
	hbox_merge_buttons.pack_start(vseparator_merge1,   Gtk::PACK_SHRINK);
	hbox_merge_buttons.pack_start(button_merge_copy,   Gtk::PACK_SHRINK);
	hbox_merge_buttons.pack_start(button_merge_add,    Gtk::PACK_SHRINK);
	hbox_merge_buttons.pack_start(button_merge_remove, Gtk::PACK_SHRINK);
	alignment_merge_buttons.add(hbox_merge_buttons);
	
	hbox_merge_options.pack_start(combobox_merge_id,    Gtk::PACK_SHRINK);
	hbox_merge_options.pack_start(vseparator_merge2,    Gtk::PACK_SHRINK);
	hbox_merge_options.pack_start(button_merge_options, Gtk::PACK_SHRINK);
	alignment_merge_options.add(hbox_merge_options);
	
	hbox_merge.pack_start(alignment_merge_buttons, Gtk::PACK_EXPAND_WIDGET);
	hbox_merge.pack_start(alignment_merge_options, Gtk::PACK_EXPAND_WIDGET);
	
	// Notebook -> Merge
	vbox_merge.set_border_width(5);
	vbox_merge.pack_start(scrolledwindow_merge, Gtk::PACK_EXPAND_WIDGET);
	vbox_merge.pack_start(hbox_merge,           Gtk::PACK_SHRINK);
	
	
	// Notebook -> Split
	button_split_sourcefile.set_size_request(150, -1);
	
	entry_split_sourcefile.set_editable(false);
	entry_split_prefix.set_text(Text::str_SHEET);
	
	spinbutton_split_digits.set_size_request(50, -1);
	spinbutton_split_digits.set_numeric();
	spinbutton_split_digits.set_wrap();
	
	group_radiobutton_split = radiobutton_split_auto.get_group();
	radiobutton_split_manual.set_group(group_radiobutton_split);
	radiobutton_split_auto.set_active();
	
	hbox_split_sourcefile.set_border_width(5);
	hbox_split_sourcefile.pack_start(entry_split_sourcefile,  Gtk::PACK_EXPAND_WIDGET);
	hbox_split_sourcefile.pack_start(button_split_sourcefile, Gtk::PACK_SHRINK);
	
	hbox_split_prefix.set_border_width(5);
	hbox_split_prefix.pack_start(entry_split_prefix, Gtk::PACK_EXPAND_WIDGET);
	
	hbox_split_digits.set_border_width(5);
	hbox_split_digits.pack_start(radiobutton_split_auto,   Gtk::PACK_SHRINK);
	hbox_split_digits.pack_start(radiobutton_split_manual, Gtk::PACK_SHRINK);
	hbox_split_digits.pack_start(spinbutton_split_digits,  Gtk::PACK_SHRINK);
	
	frame_split_sourcefile.add(hbox_split_sourcefile);
	frame_split_prefix.add(hbox_split_prefix);
	frame_split_digits.add(hbox_split_digits);
	
	table_split_options.set_spacings(5);
	table_split_options.attach(frame_split_prefix, 0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND, Gtk::FILL);
	table_split_options.attach(frame_split_digits, 1, 2, 0, 1, Gtk::SHRINK,             Gtk::FILL);
	
	vbox_split.set_border_width(5);
	vbox_split.pack_start(frame_split_sourcefile, Gtk::PACK_SHRINK);
	vbox_split.pack_start(table_split_options,    Gtk::PACK_SHRINK);
	
	
	// Notebook -> Stamp
	button_stamp_sourcefile.set_size_request(150, -1);
	button_stamp_background.set_size_request(150, -1);
	
	entry_stamp_sourcefile.set_editable(false);
	entry_stamp_background.set_editable(false);
	
	group_radiobutton_stamp = radiobutton_stamp_background.get_group();
	radiobutton_stamp_stamp.set_group(group_radiobutton_stamp);
	radiobutton_stamp_background.set_active();
	
	hbox_stamp_sourcefile.set_border_width(5);
	hbox_stamp_sourcefile.pack_start(entry_stamp_sourcefile,  Gtk::PACK_EXPAND_WIDGET);
	hbox_stamp_sourcefile.pack_start(button_stamp_sourcefile, Gtk::PACK_SHRINK);
	
	hbox_stamp_background.set_border_width(5);
	hbox_stamp_background.pack_start(entry_stamp_background,  Gtk::PACK_EXPAND_WIDGET);
	hbox_stamp_background.pack_start(button_stamp_background, Gtk::PACK_SHRINK);
	
	hbox_stamp_selection.set_border_width(5);
	hbox_stamp_selection.pack_start(radiobutton_stamp_background, Gtk::PACK_SHRINK);
	hbox_stamp_selection.pack_start(radiobutton_stamp_stamp,      Gtk::PACK_SHRINK);
	
	frame_stamp_sourcefile.add(hbox_stamp_sourcefile);
	frame_stamp_background.add(hbox_stamp_background);
	frame_stamp_selection.add(hbox_stamp_selection);
	
	hbox_stamp.set_border_width(5);
	hbox_stamp_selectionframe.pack_start(frame_stamp_selection);
	alignment_stamp_selectionframe.add(hbox_stamp_selectionframe);
	
	vbox_stamp.set_border_width(5);
	vbox_stamp.pack_start(frame_stamp_sourcefile,         Gtk::PACK_SHRINK);
	vbox_stamp.pack_start(frame_stamp_background,         Gtk::PACK_SHRINK);
	vbox_stamp.pack_start(alignment_stamp_selectionframe, Gtk::PACK_SHRINK);
	
	
	// Notebook -> Attachments
	entry_attachments_sourcefile.set_editable(false);
	
	// Notebook -> Attachments -> Scrolled Window
	scrolledwindow_attachments.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow_attachments.add(treeview_attachments);
	
	// Notebook -> Attachments -> Frame Sourcefile
	button_attachments_sourcefile.set_size_request(150,-1);
	hbox_attachments_sourcefile.set_border_width(5);
	hbox_attachments_sourcefile.pack_start(entry_attachments_sourcefile,  Gtk::PACK_EXPAND_WIDGET);
	hbox_attachments_sourcefile.pack_start(button_attachments_sourcefile, Gtk::PACK_SHRINK);
	frame_attachments_sourcefile.add(hbox_attachments_sourcefile);
	
	// Notebook -> Attachments -> Buttons (Set Stock Icons only)
	button_attachments_up.set_image(*Gtk::manage
		(new Gtk::Image(Gtk::Stock::GO_UP,   Gtk::ICON_SIZE_BUTTON)));
	
	button_attachments_down.set_image(*Gtk::manage
		(new Gtk::Image(Gtk::Stock::GO_DOWN, Gtk::ICON_SIZE_BUTTON)));
	
	button_attachments_add.set_image(*Gtk::manage   
		(new Gtk::Image(Gtk::Stock::ADD,     Gtk::ICON_SIZE_BUTTON)));
	
	button_attachments_remove.set_image(*Gtk::manage
		(new Gtk::Image(Gtk::Stock::REMOVE,  Gtk::ICON_SIZE_BUTTON)));
	
	button_attachments_up.set_tooltip_text(    Text::tip_UP);
	button_attachments_down.set_tooltip_text(  Text::tip_DOWN);
	button_attachments_add.set_tooltip_text(   Text::tip_ADD);
	button_attachments_remove.set_tooltip_text(Text::tip_REMOVE);
	
	// Notebook -> Attachments -> Radiobuttons
	group_radiobutton_attachments = radiobutton_attachments_file.get_group();
	radiobutton_attachments_page.set_group(group_radiobutton_attachments);
	radiobutton_attachments_file.set_active();
	
	// Notebook -> Attachments -> Spinbutton
	spinbutton_attachments_page.set_size_request(50, -1);
	spinbutton_attachments_page.set_numeric();
	spinbutton_attachments_page.set_wrap();
	
	hbox_attachments_filepage.pack_start(radiobutton_attachments_file, Gtk::PACK_SHRINK);
	hbox_attachments_filepage.pack_start(radiobutton_attachments_page, Gtk::PACK_SHRINK);
	hbox_attachments_filepage.pack_start(spinbutton_attachments_page,  Gtk::PACK_SHRINK);
	alignment_attachments_filepage.add(hbox_attachments_filepage);
	
	// Notebook -> Attachments
	hbox_attachments_buttons.pack_start(button_attachments_up,      Gtk::PACK_SHRINK);
	hbox_attachments_buttons.pack_start(button_attachments_down,    Gtk::PACK_SHRINK);
	hbox_attachments_buttons.pack_start(vseparator_attachments,     Gtk::PACK_SHRINK);
	hbox_attachments_buttons.pack_start(button_attachments_add,     Gtk::PACK_SHRINK);
	hbox_attachments_buttons.pack_start(button_attachments_remove,  Gtk::PACK_SHRINK);
	alignment_attachments_buttons.add(hbox_attachments_buttons);
	
	hbox_attachments.pack_start(alignment_attachments_buttons,  Gtk::PACK_EXPAND_WIDGET);
	hbox_attachments.pack_start(alignment_attachments_filepage, Gtk::PACK_EXPAND_WIDGET);
	
	vbox_attachments.set_border_width(5);
	vbox_attachments.pack_start(frame_attachments_sourcefile, Gtk::PACK_SHRINK);
	vbox_attachments.pack_start(scrolledwindow_attachments,   Gtk::PACK_EXPAND_WIDGET);
	vbox_attachments.pack_start(hbox_attachments,             Gtk::PACK_SHRINK);
	
	// Notebook
	notebook.append_page(vbox_merge,       Text::str_MERGE);
	notebook.append_page(vbox_split,       Text::str_SPLIT);
	notebook.append_page(vbox_stamp,       Text::str_BACKGROUND_STAMP);
	notebook.append_page(vbox_attachments, Text::str_ATTACHMENTS);
	
	
	// Frame Permissions
	// Frame Permissions -> Frame Rights
	checkbutton_rights_printing.set_active();
	checkbutton_rights_degradedprinting.set_active();
	checkbutton_rights_modifycontents.set_active();
	checkbutton_rights_assembly.set_active();
	checkbutton_rights_copycontents.set_active();
	checkbutton_rights_screenreaders.set_active();
	checkbutton_rights_modifyannotations.set_active();
	checkbutton_rights_fillin.set_active();
	
	checkbutton_rights_printing.set_tooltip_text         (Text::tip_PRINTING);
	checkbutton_rights_degradedprinting.set_tooltip_text (Text::tip_DEGRADED_PRINTING);
	checkbutton_rights_modifycontents.set_tooltip_text   (Text::tip_MODIFY_CONTENT);
	checkbutton_rights_assembly.set_tooltip_text         (Text::tip_ASSEMBLY);
	checkbutton_rights_copycontents.set_tooltip_text     (Text::tip_COPY_CONTENTS);
	checkbutton_rights_screenreaders.set_tooltip_text    (Text::tip_SCREENREADERS);
	checkbutton_rights_modifyannotations.set_tooltip_text(Text::tip_MODIFY_ANNOTATIONS);
	checkbutton_rights_fillin.set_tooltip_text           (Text::tip_FILL_IN);
	
	table_rights.set_spacings(5);
	table_rights.set_border_width(5);
	table_rights.attach(checkbutton_rights_printing,          0, 1, 0, 1, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_degradedprinting,  0, 1, 1, 2, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_modifycontents,    0, 1, 2, 3, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_assembly,          0, 1, 3, 4, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_copycontents,      1, 2, 0, 1, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_screenreaders,     1, 2, 1, 2, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_modifyannotations, 1, 2, 2, 3, Gtk::FILL, Gtk::FILL);
	table_rights.attach(checkbutton_rights_fillin,            1, 2, 3, 4, Gtk::FILL, Gtk::FILL);
	
	frame_rights.add(table_rights);
	
	// Frame Permissions -> Frame Passwords
	entry_passwords_userpassword.set_visibility (false);  //Stars for Passwords
	entry_passwords_ownerpassword.set_visibility(false);
	
	hbox_passwords_ownerpassword.set_border_width(5);
	hbox_passwords_ownerpassword.pack_start(entry_passwords_ownerpassword, Gtk::PACK_EXPAND_WIDGET);
	frame_passwords_ownerpassword.add(hbox_passwords_ownerpassword);
	
	hbox_passwords_userpassword.set_border_width(5);
	hbox_passwords_userpassword.pack_start(entry_passwords_userpassword, Gtk::PACK_EXPAND_WIDGET);
	frame_passwords_userpassword.add(hbox_passwords_userpassword);
	
	// Frame Permissions -> Frame Encrytion
	group_radiobutton_encryption = radiobutton_encryption_none.get_group();
	radiobutton_encryption_40bit.set_group(group_radiobutton_encryption);
	radiobutton_encryption_128bit.set_group(group_radiobutton_encryption);
	radiobutton_encryption_none.set_active();
	
	table_encryption.set_spacings(5);
	table_encryption.set_border_width(5);
	table_encryption.attach(radiobutton_encryption_none,   0, 1, 0, 1, Gtk::FILL, Gtk::FILL | Gtk::EXPAND);
	table_encryption.attach(radiobutton_encryption_40bit,  0, 1, 1, 2, Gtk::FILL, Gtk::FILL | Gtk::EXPAND);
	table_encryption.attach(radiobutton_encryption_128bit, 0, 1, 2, 3, Gtk::FILL, Gtk::FILL | Gtk::EXPAND);
	
	frame_encryption.add(table_encryption);
	
	// Frame Permissions
	vbox_permissions_passwords.pack_start(frame_passwords_ownerpassword, Gtk::PACK_EXPAND_WIDGET);
	vbox_permissions_passwords.pack_start(frame_passwords_userpassword,  Gtk::PACK_EXPAND_WIDGET);
	
	hbox_permissions.set_border_width(5);
	hbox_permissions.pack_start(frame_rights,               Gtk::PACK_SHRINK);
	hbox_permissions.pack_start(vbox_permissions_passwords, Gtk::PACK_EXPAND_WIDGET);
	hbox_permissions.pack_start(frame_encryption,           Gtk::PACK_SHRINK);
	
	expander_permissions.add(hbox_permissions);
	frame_permissions.add(expander_permissions);
	
	
	// Frame Save
	button_save.set_size_request(150,-1);
	
	hbox_save.set_border_width(5);
	hbox_save.pack_start(progressbar_save, Gtk::PACK_EXPAND_WIDGET);
	hbox_save.pack_start(button_save,      Gtk::PACK_SHRINK);
	frame_save.add(hbox_save);
	
	
	// Statusbar
	pt_statusbar = NULL;
	//pt_statusbar = new class_statusbar;
	pt_statusbar = manage(new Gtk::Statusbar);
	
	
	// Window Content
	vbox_content.set_border_width(5);
	vbox_content.pack_start(notebook,          Gtk::PACK_EXPAND_WIDGET);
	vbox_content.pack_start(frame_permissions, Gtk::PACK_SHRINK);
	vbox_content.pack_start(frame_save,        Gtk::PACK_SHRINK);
	
	
	// Main Window
	if(pt_menubar)
		vbox_window.pack_start(*pt_menubar,  Gtk::PACK_SHRINK);
	
	vbox_window.pack_start(vbox_content, Gtk::PACK_EXPAND_WIDGET);
	
	if(pt_statusbar)
		vbox_window.pack_start(*pt_statusbar,   Gtk::PACK_SHRINK);
	
	add(vbox_window);
	
	show_all_children();
	return;
}


/*** Signal Handlers ***/
/*** On Quit ***/
bool class_window_main::on_quit(GdkEventAny* event){
	
	on_menu_file_quit();
	return true;
}

/*** On Menu File -> New ***/
void class_window_main::on_menu_file_new(){
	
	if(dialogs.question_message(this, Text::str_NEW, Text::msg_NEW) == Gtk::RESPONSE_YES)
		clear();
	
	return;
}

/*** On Menu File -> Quit ***/
void class_window_main::on_menu_file_quit(){
	
	if(dialogs.question_message(this, Text::str_QUIT, Text::msg_QUIT) == Gtk::RESPONSE_YES)
		hide();
	
	return;
}

/*** On Menu Help -> Help ***/
void class_window_main::on_menu_help_help(){
	
	// xml, link id, GError
	//gnome_help_display("doc/help.xml", NULL, NULL);
	
	return;
}

/*** On Menu Help -> About ***/
void class_window_main::on_menu_help_about(){
	
	dialogs.on_window_main_menu_help_about();
	return;
}



/*** On Menu Tools -> Extract Attachments ***/
void class_window_main::on_menu_tools_extract(){
	
	window_tools_extract.show();
	return;
}

/*** On Menu Tools -> Uncompress / Compress ***/
void class_window_main::on_menu_tools_compress(){
	
	window_tools_compress.show();
	return;
}

/*** On Menu Tools -> Dump Data Fields ***/
void class_window_main::on_menu_tools_dump_data_fields(){
	
	window_tools_dump_data_fields.show();
	return;
}

/*** On Menu Tools -> Dump Data ***/
void class_window_main::on_menu_tools_dump_data(){
	
	window_tools_dump_data.show();
	return;
}

/*** On Menu Tools -> Update Info ***/
void class_window_main::on_menu_tools_update_info(){
	
	window_tools_update_info.show();
	return;
}

/*** On Menu Tools -> Generate FDF ***/
void class_window_main::on_menu_tools_generate_fdf(){
	
	window_tools_generate_fdf.show();
	return;
}

/*** On Menu Tools -> Fill Form from FDF ***/
void class_window_main::on_menu_tools_fill_form(){
	
	window_tools_fill_form.show();
	return;
}

/*** On Menu Tools -> Flatt Form Filled PDF ***/
void class_window_main::on_menu_tools_flatten(){
	
	window_tools_flatten.show();
	return;
}

/*** On Menu Tools -> Drop XFA ***/
void class_window_main::on_menu_tools_drop_xfa(){
	
	window_tools_drop_xfa.show();
	return;
}



/*** On Notebook -> Switch Page ***/
void class_window_main::on_notebook_switch_page(GtkNotebookPage* pt_page, guint page_num){
	
	switch(page_num){
		case Pdfchain::MERGE:       // Tab1: Merge
			push_status(Pdfchain::MERGE);
			break;
		
		case Pdfchain::SPLIT:       // Tab2: Split
			push_status(Pdfchain::SPLIT);
			break;
		
		case Pdfchain::STAMP:       // Tab3: Background / Stamp
			push_status(Pdfchain::STAMP);
			break;
		
		case Pdfchain::ATTACHMENTS: // Tab4: Attachments	
			push_status(Pdfchain::ATTACHMENTS);
			break;
		
		default:
			break;
	}
	
	return;
}



/*** On Button Apply ***/
void class_window_main::on_button_save(){
	
	switch(notebook.get_current_page()){
		case 0: // Tab1: Merge
			save_merge();
		break;
		
		case 1: // Tab2: Split
			save_split();
		break;
		
		case 2: // Tab3: Stamp / Background
			save_stamp();
		break;
		
		case 3: // Tab4: Attachments
			save_attachments();
		break;
		
		default: // Error Message
			dialogs.error_cerr("class_window_main::on_button_save()",
				Text::err_UNKNOWN_SELECTION_TAB,
				"NONE");
		break;
	}
	
	return;
}



/*** Methods ***/
/*** Save - Set Rights ***/
Glib::ustring class_window_main::save_set_rights(){
	
	Glib::ustring command;
	
	// Passwords
	if(entry_passwords_ownerpassword.get_text() != ""){
		command += Command::cmd_OWNER_PW + Command::cmd_SPACE;
		command += entry_passwords_ownerpassword.get_text();
	}
	
	if(entry_passwords_userpassword.get_text() != ""){
		command += Command::cmd_USER_PW + Command::cmd_SPACE;
		command += entry_passwords_userpassword.get_text();
	}
	
	// Rights
	command += Command::cmd_ALLOW;
	
	// If all rights are set
	if(checkbutton_rights_printing.property_active()          == true &&
	   checkbutton_rights_modifycontents.property_active()    == true &&
	   checkbutton_rights_assembly.property_active()          == true &&
	   checkbutton_rights_copycontents.property_active()      == true &&
	   checkbutton_rights_screenreaders.property_active()     == true &&
	   checkbutton_rights_modifyannotations.property_active() == true &&
	   checkbutton_rights_fillin.property_active()            == true){
		   
		   command += Command::cmd_ALL_FEATURES;
	}
	else{
		
		if( checkbutton_rights_printing.property_active()          == true)
			command += Command::cmd_PRINTING;
		
		if( checkbutton_rights_degradedprinting.property_active()  == true)
			command += Command::cmd_DEGRADED_PRINTING;
		
		if( checkbutton_rights_modifycontents.property_active()    == true)
			command += Command::cmd_MODIFY_CONTENTS;
		
		if( checkbutton_rights_assembly.property_active()          == true)
			command += Command::cmd_ASSEMBLY;
		
		if( checkbutton_rights_copycontents.property_active()      == true)
			command += Command::cmd_COPY_CONTENTS;
		
		if( checkbutton_rights_screenreaders.property_active()     == true)
			command += Command::cmd_SCREEN_READERS;
		
		if( checkbutton_rights_modifyannotations.property_active() == true)
			command += Command::cmd_MODIFY_ANNOTATIONS;
		
		if( checkbutton_rights_fillin.property_active()            == true)
			command += Command::cmd_FILL_IN;
	}
	
	// Encrytion
	if(radiobutton_encryption_none.property_active()        == true)
		;                                                              // Do Nothing
	
	else if(radiobutton_encryption_40bit.property_active()  == true)
		command += Command::cmd_ENCRYPT_40BIT;
	
	else if(radiobutton_encryption_128bit.property_active() == true)
		command += Command::cmd_ENCRYPT_128BIT;
	
	else{ // Error Message
		dialogs.error_cerr("class_window_main::save_set_rights()",
			Text::err_UNKNOWN_SELECTION_ENCRYPTION,
			"None");
	}
	
	return command;
}



/*** Push Status ***/
void class_window_main::push_status(Pdfchain::Selection selection){
	
	Glib::ustring message;
	
	switch(selection){
		
		case Pdfchain::MERGE:{
			
			Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = treeview_merge.get_selection();
			Gtk::TreeModel::iterator iter = ref_selection->get_selected();
			Gtk::TreeModel::Children children = treeview_merge.ref_liststore_merge->children();
			
			if(iter){
				Gtk::TreeModel::Row row = *iter;
				
				message = Text::str_QUOTE_BEGIN + row[treeview_merge.treemodel_merge.column_sourcefile] +
					Text::str_QUOTE_END  + " (" + row[treeview_merge.treemodel_merge.column_filepages] +
					" " + Text::str_PAGES + ")";
				
				if(row[treeview_merge.treemodel_merge.column_password] != ""){
					message += " (" + Text::str_PASSWORD_IS_SET + ")";
				}
			}
			
			break;
		}
		case Pdfchain::SPLIT:{
			
			if(ustring_split_sourcefile != ""){
				message = Text::str_QUOTE_BEGIN + ustring_split_sourcefile + Text::str_QUOTE_END +
					" (" + ustring_split_pages + " " + Text::str_PAGES + ")";
			}
			break;
		}
		case Pdfchain::STAMP:{
			
			if(ustring_stamp_sourcefile != ""){
				message = Text::str_QUOTE_BEGIN + ustring_stamp_sourcefile + Text::str_QUOTE_END +
					" (" + ustring_stamp_pages + " " + Text::str_PAGES + ")";
			}
			break;
		}
		case Pdfchain::ATTACHMENTS:{
			
			if(ustring_attachments_sourcefile != ""){
				message = Text::str_QUOTE_BEGIN + ustring_attachments_sourcefile + Text::str_QUOTE_END +
					" (" + ustring_attachments_pages + Text::str_PAGES + ") ";
			}
			break;
		}
		case Pdfchain::CLEAR:{
			break;
		}
		default:
			break;
	}
	
	if(pt_statusbar){
		if(message != ""){
			pt_statusbar->push(message);
		}
	}
	
	return;
}



/*** Clear ***/
void class_window_main::clear(){
	
	// Window Main
	//class_filechoosers::str_current_folder.clear();
	notebook.set_current_page(0);
	//expander_permissions.set_expanded(false);				// Should be done by User
	push_status(Pdfchain::CLEAR);
	
	// Window Main -> Merge
	treeview_merge.clear();
	//button_merge_options.set_active(false);				// Should be done by User
	combobox_merge_id.set_active(0);
	
	// Window Main -> Split
	entry_split_sourcefile.set_text("");
	entry_split_prefix.set_text(Text::str_SHEET);
	ustring_split_sourcefile = "";
	ustring_split_pages ="";
	spinbutton_split_digits.set_value(3.0);
	
	// Window Main -> Background / Stamp
	entry_stamp_sourcefile.set_text("");
	entry_stamp_background.set_text("");
	ustring_stamp_sourcefile = "";
	ustring_stamp_pages = "";
	radiobutton_stamp_background.set_active();
	
	// Window Main -> Attachments
	entry_attachments_sourcefile.set_text("");
	treeview_attachments.clear();
	radiobutton_attachments_file.set_active();
	spinbutton_attachments_page.set_value(1.0);
	adjustment_attachments_page.set_upper(1.0);
	
	// Window Main -> Permissions -> Rights
	checkbutton_rights_printing.set_active();
	checkbutton_rights_degradedprinting.set_active();
	checkbutton_rights_modifycontents.set_active();
	checkbutton_rights_assembly.set_active();
	checkbutton_rights_copycontents.set_active();
	checkbutton_rights_screenreaders.set_active();
	checkbutton_rights_modifyannotations.set_active();
	checkbutton_rights_fillin.set_active();
	
	// Window Main -> Permissions -> Passwords
	entry_passwords_ownerpassword.set_text("");
	entry_passwords_userpassword.set_text("");
	
	// Window Main -> Permissions -> Encryption
	radiobutton_encryption_none.set_active();
	
	// Window Tools -> Extract Attachments
	window_tools_extract.clear();
	
	// Window Tools -> Uncompress / Compress
	window_tools_compress.clear();
	
	// Window Tools -> Dump Data Fields
	window_tools_dump_data_fields.clear();
	
	// Window Tools -> Dump Data
	window_tools_dump_data.clear();
	
	// Window Tools -> Update Info
	window_tools_update_info.clear();
	
	// Window Tools -> Generate FDF
	window_tools_generate_fdf.clear();
	
	// Window Tools -> Fill Form
	window_tools_fill_form.clear();
	
	// Window Tools -> Flatten
	window_tools_flatten.clear();
	
	// Window Tools -> Drop XFA
	window_tools_drop_xfa.clear();
	
	return;
}
