/*  Pcsx - Pc Psx Emulator
 *  Copyright (C) 1999-2002  Pcsx Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <dlfcn.h>
#include <sys/mman.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <dirent.h>
#include <sys/stat.h>

#include "Linux.h"
#include "Sio.h"

int UseGui = 1;
int CancelQuit = 0;

int main(int argc, char *argv[]) {
	char *file = NULL;
    char BIOSDir[MAXPATHLEN];
	char dotdir[MAXPATHLEN];
	char mcd[MAXPATHLEN];
	struct stat buf;
	int runcd = 0;
	int loadst = 0;
	int i;

#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	// switch to plugin dotdir
	// this lets plugins work without modification!
    strncpy(dotdir, getenv("HOME"), MAXPATHLEN-100);
    strcat(dotdir, "/.pcsx/plugins/");
	chdir(dotdir);

    // what is the name of the config file?
    // it may be redefined by -cfg on the command line
    strcpy(cfgfile_basename, "pcsx.cfg");

    // read command line options
	for (i=1; i<argc; i++) {
		if (!strcmp(argv[i], "-runcd")) runcd = 1;
		else if (!strcmp(argv[i], "-runcdbios")) runcd = 2;
		else if (!strcmp(argv[i], "-nogui")) UseGui = 0;
		else if (!strcmp(argv[i], "-psxout")) Config.PsxOut = 1;
		else if (!strcmp(argv[i], "-load")) loadst = atol(argv[++i]);
		else if (!strcmp(argv[i], "-cfg")) {
            strncpy(cfgfile_basename, argv[++i], MAXPATHLEN-100);
            printf("Using config file %s.\n", cfgfile_basename);
        } 	
        else if (!strcmp(argv[i], "-h") ||
			 !strcmp(argv[i], "-help")) {
			 printf("PCSX " "VERSION\n");
			 printf("%s\n", _(
			 				" pcsx [options] [file]\n"
							"\toptions:\n"
							"\t-runcd\t\tRuns CD-ROM\n"
							"\t-runcdbios\tRuns CD-ROM through BIOS\n"
							"\t-nogui\t\tDon't open the GTK GUI\n"
							"\t-cfg FILE\tLoads desired configuration file (default: ~/.pcsx/pcsx.cfg)\n"
							"\t-psxout\t\tEnable PSX output\n"
							"\t-load STATENUM\tLoads savestate STATENUM (1-5)\n"
							"\t-h -help\tDisplay this message\n"
							"\tfile\t\tLoads file\n"));
			 return 0;
		} else file = argv[i];
	}

	memset(&Config, 0, sizeof(PcsxConfig));
	strcpy(Config.Net, _("Disabled"));
    
	if (UseGui == 1) gtk_init(NULL, NULL);

    // try to load config
    // if the config file doesn't exist
	if (LoadConfig() == -1) {
        // Uh oh, no config file found, use some defaults
		Config.PsxAuto = 1;
        
        strncpy(BIOSDir, getenv("HOME"), MAXPATHLEN-20);
        strcat(BIOSDir, "/.pcsx/bios/");
		strcpy(Config.BiosDir,  BIOSDir);
        
		if (UseGui == 0) {
			printf(_("PCSX cannot be configured without using the GUI -- you should restart without -nogui.\n"));
			return 1;
		}
		gtk_init(NULL, NULL);

		// switch to plugin dotdir
		// this lets plugins work without modification!
		strncpy(dotdir, getenv("HOME"), MAXPATHLEN-20);
		strcat(dotdir, "/.pcsx/plugins/");
		chdir(dotdir);

		// scan some default locations to find plugins
		ScanPlugins("/usr/lib/games/psemu/lib/");
		ScanPlugins("/usr/lib/games/psemu/config/");
		ScanPlugins("/usr/local/lib/games/psemu/lib/");
		ScanPlugins("/usr/local/lib/games/psemu/config/");
		strncpy(dotdir, getenv("HOME"), MAXPATHLEN-20);
		strcat(dotdir, "/.psemu-plugins/");
		ScanPlugins(dotdir);
		strncpy(dotdir, getenv("HOME"), MAXPATHLEN-20);
		strcat(dotdir, "/.psemu/");
		ScanPlugins(dotdir);

		// Update available plugins, but not GUI
		UpdatePluginsBIOS();

		// Pick some defaults, if they're available
		if (strlen(GpuConfS.plist[0]) != 0) { strcpy(Config.Gpu, GpuConfS.plist[0]); printf("picking default GPU plugin: %s\n", GpuConfS.plist[0]); }
		if (strlen(SpuConfS.plist[0]) != 0) { strcpy(Config.Spu, SpuConfS.plist[0]); printf("picking default SPU plugin: %s\n", SpuConfS.plist[0]); }
		if (strlen(CdrConfS.plist[0]) != 0) { strcpy(Config.Cdr, CdrConfS.plist[0]); printf("picking default CD-ROM plugin: %s\n", CdrConfS.plist[0]); }
		if (strlen(Pad1ConfS.plist[0]) != 0) { strcpy(Config.Pad1, Pad1ConfS.plist[0]); printf("picking default Controller 1 plugin: %s\n", Pad1ConfS.plist[0]); }
		if (strlen(Pad2ConfS.plist[0]) != 0) { strcpy(Config.Pad2, Pad2ConfS.plist[0]); printf("picking default Controller 2 plugin: %s\n", Pad2ConfS.plist[0]); }
		if (strlen(BiosConfS.plist[0]) != 0) { strcpy(Config.Bios, BiosConfS.plist[0]); printf("picking default BIOS: %s\n", BiosConfS.plist[0]); }

		// create & load default memcards if they don't exist
		strncpy(mcd, getenv("HOME"), MAXPATHLEN-20);
		strcat(mcd, "/.pcsx/memcards/card1.mcr");
		if (stat(mcd, &buf) == -1) {
			strcpy(Config.Mcd1, mcd);
			printf("creating memory card: %s\n", mcd);
			CreateMcd(mcd);
		}
		strncpy(mcd, getenv("HOME"), MAXPATHLEN-20);
		strcat(mcd, "/.pcsx/memcards/card2.mcr");
		if (stat(mcd, &buf) == -1) {
			strcpy(Config.Mcd2, mcd);
			printf("creating memory card: %s\n", mcd);
			CreateMcd(mcd);
		}
		SaveConfig();
		LoadMcds(Config.Mcd1, Config.Mcd2);
	}

	// release and load all plugins
	// don't try to load plugins if they aren't set!
	if (CheckPlugins() != 1) {
		ReleasePlugins();
		LoadPlugins();
		needreset = 1;
	}

	if (SysInit() == -1) return 1;

	if (UseGui == 1) {
		StartGui();
		return 0;
	}

	// the following only occurs if the gui isn't started

	if (OpenPlugins() == -1 || CheckPlugins() == 1) return 1;
	SysReset();

	CheckCdrom();

	if (file != NULL) Load(file);
	else {
		if (runcd == 1) {
			LoadCdBios = 0;
			if (LoadCdrom() == -1) {
				ClosePlugins();
				printf(_("Could not load CD-ROM!\n"));
				return -1;
			}
		} else if (runcd == 2) LoadCdBios = 1;
	}

	if (loadst) {
		char Text[256];
		StatesC = loadst-1;
		sprintf (Text, "sstates/%10.10s.%3.3d", CdromLabel, StatesC);
		LoadState(Text);
	}

	psxCpu->Execute();

	return 0;
}

DIR *dir;

int SysInit() {

#ifdef GTE_DUMP
	gteLog = fopen("gteLog.txt","wb");
	setvbuf(gteLog, NULL, _IONBF, 0);
#endif

#ifdef EMU_LOG
#ifndef LOG_STDOUT
	emuLog = fopen("emuLog.txt","wb");
#else
	emuLog = stdout;
#endif
	setvbuf(emuLog, NULL, _IONBF, 0);
#endif

	psxInit();

	LoadMcds(Config.Mcd1, Config.Mcd2);

	return 0;
}

void SysReset() {
	psxReset();
}

void SysClose() {
	psxShutdown();
	ReleasePlugins();

	if (emuLog != NULL) fclose(emuLog);
}

void SysPrintf(char *fmt, ...) {
	va_list list;
	char msg[512];

	va_start(list, fmt);
	vsprintf(msg, fmt, list);
	va_end(list);

	if (Config.PsxOut) printf ("%s", msg);
#ifdef EMU_LOG
#ifndef LOG_STDOUT
	fprintf(emuLog, "%s", msg);
#endif
#endif
}

void *SysLoadLibrary(char *lib) {
	return dlopen(lib, RTLD_NOW);
}

void *SysLoadSym(void *lib, char *sym) {
	return dlsym(lib, sym);
}

const char *SysLibError() {
	return dlerror();
}

void SysCloseLibrary(void *lib) {
	dlclose(lib);
}

void SysUpdate() {
	PADhandleKey(PAD1_keypressed());
	PADhandleKey(PAD2_keypressed());
}

void SysRunGui() {
	RunGui();
}
