/* This file was generated by the Octave script pythagorean_quadruples.
 * It contains lists of pseudo-Pythagorean quadruples sorted by increasing
 * distance from the origin. A pseudo-Pythagorean quadruple is a set of 4
 * numbers A, B, C, R such that
 *    A * A + B * B + C * C = R * R
 * with A, B, and C having integer values and R being real. (Real
 * Pythagorean quadruples force R to be an integer as well.) Note that
 * the values below are stored as R*R, A, B, C so that all are integers.
 */
int vtkPythagoreanQuadruples[] = {
/* R^2  i   j   k */
    0,  0,  0,  0,
    1,  1,  0,  0,
    2,  1,  1,  0,
    3,  1,  1,  1,
    4,  2,  0,  0,
    5,  2,  1,  0,
    6,  2,  1,  1,
    8,  2,  2,  0,
    9,  2,  2,  1,
    9,  3,  0,  0,
   10,  3,  1,  0,
   11,  3,  1,  1,
   12,  2,  2,  2,
   13,  3,  2,  0,
   14,  3,  2,  1,
   16,  4,  0,  0,
   17,  3,  2,  2,
   17,  4,  1,  0,
   18,  3,  3,  0,
   18,  4,  1,  1,
   19,  3,  3,  1,
   20,  4,  2,  0,
   21,  4,  2,  1,
   22,  3,  3,  2,
   24,  4,  2,  2,
   25,  4,  3,  0,
   25,  5,  0,  0,
   26,  4,  3,  1,
   26,  5,  1,  0,
   27,  3,  3,  3,
   27,  5,  1,  1,
   29,  4,  3,  2,
   29,  5,  2,  0,
   30,  5,  2,  1,
   32,  4,  4,  0,
   33,  4,  4,  1,
   33,  5,  2,  2,
   34,  4,  3,  3,
   34,  5,  3,  0,
   35,  5,  3,  1,
   36,  4,  4,  2,
   36,  6,  0,  0,
   37,  6,  1,  0,
   38,  5,  3,  2,
   38,  6,  1,  1,
   40,  6,  2,  0,
   41,  4,  4,  3,
   41,  5,  4,  0,
   41,  6,  2,  1,
   42,  5,  4,  1,
   43,  5,  3,  3,
   44,  6,  2,  2,
   45,  5,  4,  2,
   45,  6,  3,  0,
   46,  6,  3,  1,
   48,  4,  4,  4,
   49,  6,  3,  2,
   49,  7,  0,  0,
   50,  5,  4,  3,
   50,  5,  5,  0,
   50,  7,  1,  0,
   51,  5,  5,  1,
   51,  7,  1,  1,
   52,  6,  4,  0,
   53,  6,  4,  1,
   53,  7,  2,  0,
   54,  5,  5,  2,
   54,  6,  3,  3,
   54,  7,  2,  1,
   56,  6,  4,  2,
   57,  5,  4,  4,
   57,  7,  2,  2,
   58,  7,  3,  0,
   59,  5,  5,  3,
   59,  7,  3,  1,
   61,  6,  4,  3,
   61,  6,  5,  0,
   62,  6,  5,  1,
   62,  7,  3,  2,
   64,  8,  0,  0,
   65,  6,  5,  2,
   65,  7,  4,  0,
   65,  8,  1,  0,
   66,  5,  5,  4,
   66,  7,  4,  1,
   66,  8,  1,  1,
   67,  7,  3,  3,
   68,  6,  4,  4,
   68,  8,  2,  0,
   69,  7,  4,  2,
   69,  8,  2,  1,
   70,  6,  5,  3,
   72,  6,  6,  0,
   72,  8,  2,  2,
   73,  6,  6,  1,
   73,  8,  3,  0,
   74,  7,  4,  3,
   74,  7,  5,  0,
   74,  8,  3,  1,
   75,  5,  5,  5,
   75,  7,  5,  1,
   76,  6,  6,  2,
   77,  6,  5,  4,
   77,  8,  3,  2,
   78,  7,  5,  2,
   80,  8,  4,  0,
   81,  6,  6,  3,
   81,  7,  4,  4,
   81,  8,  4,  1,
   81,  9,  0,  0,
   82,  8,  3,  3,
   82,  9,  1,  0,
   83,  7,  5,  3,
   83,  9,  1,  1,
   84,  8,  4,  2,
   85,  7,  6,  0,
   85,  9,  2,  0,
   86,  6,  5,  5,
   86,  7,  6,  1,
   86,  9,  2,  1,
   88,  6,  6,  4,
   89,  7,  6,  2,
   89,  8,  4,  3,
   89,  8,  5,  0,
   89,  9,  2,  2,
   90,  7,  5,  4,
   90,  8,  5,  1,
   90,  9,  3,  0,
   91,  9,  3,  1,
   93,  8,  5,  2,
   94,  7,  6,  3,
   94,  9,  3,  2,
   96,  8,  4,  4,
   97,  6,  6,  5,
   97,  9,  4,  0,
   98,  7,  7,  0,
   98,  8,  5,  3,
   98,  9,  4,  1,
   99,  7,  5,  5,
   99,  7,  7,  1,
   99,  9,  3,  3,
  100,  8,  6,  0,
  100, 10,  0,  0,
  101,  7,  6,  4,
  101,  8,  6,  1,
  101,  9,  4,  2,
  101, 10,  1,  0,
  102,  7,  7,  2,
  102, 10,  1,  1,
  104,  8,  6,  2,
  104, 10,  2,  0,
  105,  8,  5,  4,
  105, 10,  2,  1,
  106,  9,  4,  3,
  106,  9,  5,  0,
  107,  7,  7,  3,
  107,  9,  5,  1,
  108,  6,  6,  6,
  108, 10,  2,  2,
  109,  8,  6,  3,
  109, 10,  3,  0,
  110,  7,  6,  5,
  110,  9,  5,  2,
  110, 10,  3,  1,
  113,  8,  7,  0,
  113,  9,  4,  4,
  113, 10,  3,  2,
  114,  7,  7,  4,
  114,  8,  5,  5,
  114,  8,  7,  1,
  115,  9,  5,  3,
  116,  8,  6,  4,
  116, 10,  4,  0,
  117,  8,  7,  2,
  117,  9,  6,  0,
  117, 10,  4,  1,
  118,  9,  6,  1,
  118, 10,  3,  3,
  120, 10,  4,  2,
  121,  7,  6,  6,
  121,  9,  6,  2,
  121, 11,  0,  0,
  122,  8,  7,  3,
  122,  9,  5,  4,
  122, 11,  1,  0,
  123,  7,  7,  5,
  123, 11,  1,  1,
  125,  8,  6,  5,
  125, 10,  4,  3,
  125, 10,  5,  0,
  125, 11,  2,  0,
  126,  9,  6,  3,
  126, 10,  5,  1,
  126, 11,  2,  1,
  128,  8,  8,  0,
  129,  8,  7,  4,
  129,  8,  8,  1,
  129, 10,  5,  2,
  129, 11,  2,  2,
  130,  9,  7,  0,
  130, 11,  3,  0,
  131,  9,  5,  5,
  131,  9,  7,  1,
  131, 11,  3,  1,
  132,  8,  8,  2,
  132, 10,  4,  4,
  133,  9,  6,  4,
  134,  7,  7,  6,
  134,  9,  7,  2,
  134, 10,  5,  3,
  134, 11,  3,  2,
  136,  8,  6,  6,
  136, 10,  6,  0,
  137,  8,  8,  3,
  137, 10,  6,  1,
  137, 11,  4,  0,
  138,  8,  7,  5,
  138, 11,  4,  1,
  139,  9,  7,  3,
  139, 11,  3,  3,
  140, 10,  6,  2,
  141, 10,  5,  4,
  141, 11,  4,  2,
  142,  9,  6,  5,
  144,  8,  8,  4,
  144, 12,  0,  0,
  145,  9,  8,  0,
  145, 10,  6,  3,
  145, 12,  1,  0,
  146,  9,  7,  4,
  146,  9,  8,  1,
  146, 11,  4,  3,
  146, 11,  5,  0,
  146, 12,  1,  1,
  147,  7,  7,  7,
  147, 11,  5,  1,
  148, 12,  2,  0,
  149,  8,  7,  6,
  149,  9,  8,  2,
  149, 10,  7,  0,
  149, 12,  2,  1,
  150, 10,  5,  5,
  150, 10,  7,  1,
  150, 11,  5,  2,
  152, 10,  6,  4,
  152, 12,  2,  2,
  153,  8,  8,  5,
  153,  9,  6,  6,
  153, 10,  7,  2,
  153, 11,  4,  4,
  153, 12,  3,  0,
  154,  9,  8,  3,
  154, 12,  3,  1,
  155,  9,  7,  5,
  155, 11,  5,  3,
  157, 11,  6,  0,
  157, 12,  3,  2,
  158, 10,  7,  3,
  158, 11,  6,  1,
  160, 12,  4,  0,
  161,  9,  8,  4,
  161, 10,  6,  5,
  161, 11,  6,  2,
  161, 12,  4,  1,
  162,  8,  7,  7,
  162,  9,  9,  0,
  162, 11,  5,  4,
  162, 12,  3,  3,
  163,  9,  9,  1,
  164,  8,  8,  6,
  164, 10,  8,  0,
  164, 12,  4,  2,
  165, 10,  7,  4,
  165, 10,  8,  1,
  166,  9,  7,  6,
  166,  9,  9,  2,
  166, 11,  6,  3,
  168, 10,  8,  2,
  169, 12,  4,  3,
  169, 12,  5,  0,
  169, 13,  0,  0,
  170,  9,  8,  5,
  170, 11,  7,  0,
  170, 12,  5,  1,
  170, 13,  1,  0,
  171,  9,  9,  3,
  171, 11,  5,  5,
  171, 11,  7,  1,
  171, 13,  1,  1,
  172, 10,  6,  6,
  173, 10,  8,  3,
  173, 11,  6,  4,
  173, 12,  5,  2,
  173, 13,  2,  0,
  174, 10,  7,  5,
  174, 11,  7,  2,
  174, 13,  2,  1,
  176, 12,  4,  4,
  177,  8,  8,  7,
  177, 13,  2,  2,
  178,  9,  9,  4,
  178, 12,  5,  3,
  178, 13,  3,  0,
  179,  9,  7,  7,
  179, 11,  7,  3,
  179, 13,  3,  1,
  180, 10,  8,  4,
  180, 12,  6,  0,
  181,  9,  8,  6,
  181, 10,  9,  0,
  181, 12,  6,  1,
  182, 10,  9,  1,
  182, 11,  6,  5,
  182, 13,  3,  2,
  184, 12,  6,  2,
  185, 10,  7,  6,
  185, 10,  9,  2,
  185, 11,  8,  0,
  185, 12,  5,  4,
  185, 13,  4,  0,
  186, 11,  7,  4,
  186, 11,  8,  1,
  186, 13,  4,  1,
  187,  9,  9,  5,
  187, 13,  3,  3,
  189, 10,  8,  5,
  189, 11,  8,  2,
  189, 12,  6,  3,
  189, 13,  4,  2,
  190, 10,  9,  3,
  192,  8,  8,  8,
  193, 11,  6,  6,
  193, 12,  7,  0,
  194,  9,  8,  7,
  194, 11,  8,  3,
  194, 12,  5,  5,
  194, 12,  7,  1,
  194, 13,  4,  3,
  194, 13,  5,  0,
  195, 11,  7,  5,
  195, 13,  5,  1,
  196, 12,  6,  4,
  196, 14,  0,  0,
  197, 10,  9,  4,
  197, 12,  7,  2,
  197, 14,  1,  0,
  198,  9,  9,  6,
  198, 10,  7,  7,
  198, 13,  5,  2,
  198, 14,  1,  1,
  200, 10,  8,  6,
  200, 10, 10,  0,
  200, 14,  2,  0,
  201, 10, 10,  1,
  201, 11,  8,  4,
  201, 13,  4,  4,
  201, 14,  2,  1,
  202, 11,  9,  0,
  202, 12,  7,  3,
  203, 11,  9,  1,
  203, 13,  5,  3,
  204, 10, 10,  2,
  204, 14,  2,  2,
  205, 12,  6,  5,
  205, 13,  6,  0,
  205, 14,  3,  0,
  206, 10,  9,  5,
  206, 11,  7,  6,
  206, 11,  9,  2,
  206, 13,  6,  1,
  206, 14,  3,  1,
  208, 12,  8,  0,
  209,  9,  8,  8,
  209, 10, 10,  3,
  209, 12,  7,  4,
  209, 12,  8,  1,
  209, 13,  6,  2,
  209, 14,  3,  2,
  210, 11,  8,  5,
  210, 13,  5,  4,
  211,  9,  9,  7,
  211, 11,  9,  3,
  212, 12,  8,  2,
  212, 14,  4,  0,
  213, 10,  8,  7,
  213, 14,  4,  1,
  214, 13,  6,  3,
  214, 14,  3,  3,
  216, 10, 10,  4,
  216, 12,  6,  6,
  216, 14,  4,  2,
  217, 10,  9,  6,
  217, 12,  8,  3,
  218, 11,  9,  4,
  218, 12,  7,  5,
  218, 13,  7,  0,
  219, 11,  7,  7,
  219, 13,  5,  5,
  219, 13,  7,  1,
  221, 11,  8,  6,
  221, 11, 10,  0,
  221, 13,  6,  4,
  221, 14,  4,  3,
  221, 14,  5,  0,
  222, 11, 10,  1,
  222, 13,  7,  2,
  222, 14,  5,  1,
  224, 12,  8,  4,
  225, 10, 10,  5,
  225, 11, 10,  2,
  225, 12,  9,  0,
  225, 14,  5,  2,
  225, 15,  0,  0,
  226,  9,  9,  8,
  226, 12,  9,  1,
  226, 15,  1,  0,
  227, 11,  9,  5,
  227, 13,  7,  3,
  227, 15,  1,  1,
  228, 10,  8,  8,
  228, 14,  4,  4,
  229, 12,  7,  6,
  229, 12,  9,  2,
  229, 15,  2,  0,
  230, 10,  9,  7,
  230, 11, 10,  3,
  230, 13,  6,  5,
  230, 14,  5,  3,
  230, 15,  2,  1,
  232, 14,  6,  0,
  233, 12,  8,  5,
  233, 13,  8,  0,
  233, 14,  6,  1,
  233, 15,  2,  2,
  234, 11,  8,  7,
  234, 12,  9,  3,
  234, 13,  7,  4,
  234, 13,  8,  1,
  234, 15,  3,  0,
  235, 15,  3,  1,
  236, 10, 10,  6,
  236, 14,  6,  2,
  237, 11, 10,  4,
  237, 13,  8,  2,
  237, 14,  5,  4,
  238, 11,  9,  6,
  238, 15,  3,  2,
  241, 12,  9,  4,
  241, 13,  6,  6,
  241, 14,  6,  3,
  241, 15,  4,  0,
  242, 11, 11,  0,
  242, 12,  7,  7,
  242, 13,  8,  3,
  242, 15,  4,  1,
  243,  9,  9,  9,
  243, 11, 11,  1,
  243, 13,  7,  5,
  243, 15,  3,  3,
  244, 12,  8,  6,
  244, 12, 10,  0,
  245, 10,  9,  8,
  245, 12, 10,  1,
  245, 14,  7,  0,
  245, 15,  4,  2,
  246, 11, 10,  5,
  246, 11, 11,  2,
  246, 14,  5,  5,
  246, 14,  7,  1,
  248, 12, 10,  2,
  248, 14,  6,  4,
  249, 10, 10,  7,
  249, 11,  8,  8,
  249, 13,  8,  4,
  249, 14,  7,  2,
  250, 12,  9,  5,
  250, 13,  9,  0,
  250, 15,  4,  3,
  250, 15,  5,  0,
  251, 11,  9,  7,
  251, 11, 11,  3,
  251, 13,  9,  1,
  251, 15,  5,  1,
  253, 12, 10,  3,
  254, 13,  7,  6,
  254, 13,  9,  2,
  254, 14,  7,  3,
  254, 15,  5,  2,
  256, 16,  0,  0,
  257, 11, 10,  6,
  257, 12,  8,  7,
  257, 14,  6,  5,
  257, 15,  4,  4,
  257, 16,  1,  0,
  258, 11, 11,  4,
  258, 13,  8,  5,
  258, 16,  1,  1,
  259, 13,  9,  3,
  259, 15,  5,  3,
  260, 12, 10,  4,
  260, 14,  8,  0,
  260, 16,  2,  0,
  261, 12,  9,  6,
  261, 14,  7,  4,
  261, 14,  8,  1,
  261, 15,  6,  0,
  261, 16,  2,  1,
  262, 10,  9,  9,
  262, 15,  6,  1,
  264, 10, 10,  8,
  264, 14,  8,  2,
  264, 16,  2,  2,
  265, 12, 11,  0,
  265, 15,  6,  2,
  265, 16,  3,  0,
  266, 11,  9,  8,
  266, 12, 11,  1,
  266, 13,  9,  4,
  266, 15,  5,  4,
  266, 16,  3,  1,
  267, 11, 11,  5,
  267, 13,  7,  7,
  268, 14,  6,  6,
  269, 12, 10,  5,
  269, 12, 11,  2,
  269, 13,  8,  6,
  269, 13, 10,  0,
  269, 14,  8,  3,
  269, 16,  3,  2,
  270, 11, 10,  7,
  270, 13, 10,  1,
  270, 14,  7,  5,
  270, 15,  6,  3,
  272, 12,  8,  8,
  272, 16,  4,  0,
  273, 13, 10,  2,
  273, 16,  4,  1,
  274, 12,  9,  7,
  274, 12, 11,  3,
  274, 15,  7,  0,
  274, 16,  3,  3,
  275, 13,  9,  5,
  275, 15,  5,  5,
  275, 15,  7,  1,
  276, 14,  8,  4,
  276, 16,  4,  2,
  277, 14,  9,  0,
  277, 15,  6,  4,
  278, 11, 11,  6,
  278, 13, 10,  3,
  278, 14,  9,  1,
  278, 15,  7,  2,
  280, 12, 10,  6,
  281, 10, 10,  9,
  281, 12, 11,  4,
  281, 14,  7,  6,
  281, 14,  9,  2,
  281, 16,  4,  3,
  281, 16,  5,  0,
  282, 13,  8,  7,
  282, 16,  5,  1,
  283, 11,  9,  9,
  283, 15,  7,  3,
  285, 11, 10,  8,
  285, 13, 10,  4,
  285, 14,  8,  5,
  285, 16,  5,  2,
  286, 13,  9,  6,
  286, 14,  9,  3,
  286, 15,  6,  5,
  288, 12, 12,  0,
  288, 16,  4,  4,
  289, 12,  9,  8,
  289, 12, 12,  1,
  289, 15,  8,  0,
  289, 17,  0,  0,
  290, 12, 11,  5,
  290, 13, 11,  0,
  290, 15,  7,  4,
  290, 15,  8,  1,
  290, 16,  5,  3,
  290, 17,  1,  0,
  291, 11, 11,  7,
  291, 13, 11,  1,
  291, 17,  1,  1,
  292, 12, 12,  2,
  292, 16,  6,  0,
  293, 12, 10,  7,
  293, 14,  9,  4,
  293, 15,  8,  2,
  293, 16,  6,  1,
  293, 17,  2,  0,
  294, 13, 10,  5,
  294, 13, 11,  2,
  294, 14,  7,  7,
  294, 17,  2,  1,
  296, 14,  8,  6,
  296, 14, 10,  0,
  296, 16,  6,  2,
  297, 12, 12,  3,
  297, 13,  8,  8,
  297, 14, 10,  1,
  297, 15,  6,  6,
  297, 16,  5,  4,
  297, 17,  2,  2,
  298, 15,  8,  3,
  298, 17,  3,  0,
  299, 13,  9,  7,
  299, 13, 11,  3,
  299, 15,  7,  5,
  299, 17,  3,  1,
  300, 10, 10, 10,
  300, 14, 10,  2,
  301, 12, 11,  6,
  301, 16,  6,  3,
  302, 11, 10,  9,
  302, 14,  9,  5,
  302, 17,  3,  2,
  304, 12, 12,  4,
  305, 13, 10,  6,
  305, 14, 10,  3,
  305, 15,  8,  4,
  305, 16,  7,  0,
  305, 17,  4,  0,
  306, 11, 11,  8,
  306, 12,  9,  9,
  306, 13, 11,  4,
  306, 15,  9,  0,
  306, 16,  5,  5,
  306, 16,  7,  1,
  306, 17,  4,  1,
  307, 15,  9,  1,
  307, 17,  3,  3,
  308, 12, 10,  8,
  308, 16,  6,  4,
  309, 14,  8,  7,
  309, 16,  7,  2,
  309, 17,  4,  2,
  310, 15,  7,  6,
  310, 15,  9,  2,
  312, 14, 10,  4,
  313, 12, 12,  5,
  313, 13, 12,  0,
  313, 14,  9,  6,
  314, 12, 11,  7,
  314, 13,  9,  8,
  314, 13, 12,  1,
  314, 15,  8,  5,
  314, 16,  7,  3,
  314, 17,  4,  3,
  314, 17,  5,  0,
  315, 13, 11,  5,
  315, 15,  9,  3,
  315, 17,  5,  1,
  317, 13, 12,  2,
  317, 14, 11,  0,
  317, 16,  6,  5,
  318, 13, 10,  7,
  318, 14, 11,  1,
  318, 17,  5,  2,
  320, 16,  8,  0,
  321, 11, 10, 10,
  321, 14, 10,  5,
  321, 14, 11,  2,
  321, 16,  7,  4,
  321, 16,  8,  1,
  321, 17,  4,  4,
  322, 13, 12,  3,
  322, 15,  9,  4,
  323, 11, 11,  9,
  323, 15,  7,  7,
  323, 17,  5,  3,
  324, 12, 12,  6,
  324, 14,  8,  8,
  324, 16,  8,  2,
  324, 18,  0,  0,
  325, 12, 10,  9,
  325, 15,  8,  6,
  325, 15, 10,  0,
  325, 17,  6,  0,
  325, 18,  1,  0,
  326, 13, 11,  6,
  326, 14,  9,  7,
  326, 14, 11,  3,
  326, 15, 10,  1,
  326, 17,  6,  1,
  326, 18,  1,  1,
  328, 16,  6,  6,
  328, 18,  2,  0,
  329, 12, 11,  8,
  329, 13, 12,  4,
  329, 15, 10,  2,
  329, 16,  8,  3,
  329, 17,  6,  2,
  329, 18,  2,  1,
  330, 16,  7,  5,
  330, 17,  5,  4,
  331, 13,  9,  9,
  331, 15,  9,  5,
  332, 14, 10,  6,
  332, 18,  2,  2,
  333, 13, 10,  8,
  333, 14, 11,  4,
  333, 18,  3,  0,
  334, 15, 10,  3,
  334, 17,  6,  3,
  334, 18,  3,  1,
  336, 16,  8,  4,
  337, 12, 12,  7,
  337, 16,  9,  0,
  337, 18,  3,  2,
  338, 13, 12,  5,
  338, 13, 13,  0,
  338, 15,  8,  7,
  338, 16,  9,  1,
  338, 17,  7,  0,
  339, 13, 11,  7,
  339, 13, 13,  1,
  339, 17,  5,  5,
  339, 17,  7,  1,
  340, 14, 12,  0,
  340, 18,  4,  0,
  341, 14,  9,  8,
  341, 14, 12,  1,
  341, 15, 10,  4,
  341, 16,  7,  6,
  341, 16,  9,  2,
  341, 17,  6,  4,
  341, 18,  4,  1,
  342, 11, 11, 10,
  342, 13, 13,  2,
  342, 14, 11,  5,
  342, 15,  9,  6,
  342, 17,  7,  2,
  342, 18,  3,  3,
  344, 12, 10, 10,
  344, 14, 12,  2,
  344, 18,  4,  2,
  345, 14, 10,  7,
  345, 16,  8,  5,
  346, 12, 11,  9,
  346, 15, 11,  0,
  346, 16,  9,  3,
  347, 13, 13,  3,
  347, 15, 11,  1,
  347, 17,  7,  3,
  349, 13, 12,  6,
  349, 14, 12,  3,
  349, 18,  4,  3,
  349, 18,  5,  0,
  350, 13, 10,  9,
  350, 15, 10,  5,
  350, 15, 11,  2,
  350, 17,  6,  5,
  350, 18,  5,  1,
  352, 12, 12,  8,
  353, 14, 11,  6,
  353, 15,  8,  8,
  353, 16,  9,  4,
  353, 17,  8,  0,
  353, 18,  5,  2,
  354, 13, 11,  8,
  354, 13, 13,  4,
  354, 16,  7,  7,
  354, 17,  7,  4,
  354, 17,  8,  1,
  355, 15,  9,  7,
  355, 15, 11,  3,
  356, 14, 12,  4,
  356, 16,  8,  6,
  356, 16, 10,  0,
  356, 18,  4,  4,
  357, 16, 10,  1,
  357, 17,  8,  2,
  358, 14,  9,  9,
  358, 18,  5,  3,
  360, 14, 10,  8,
  360, 16, 10,  2,
  360, 18,  6,  0,
  361, 15, 10,  6,
  361, 17,  6,  6,
  361, 18,  6,  1,
  361, 19,  0,  0,
  362, 13, 12,  7,
  362, 15, 11,  4,
  362, 16,  9,  5,
  362, 17,  8,  3,
  362, 19,  1,  0,
  363, 11, 11, 11,
  363, 13, 13,  5,
  363, 17,  7,  5,
  363, 19,  1,  1,
  364, 18,  6,  2,
  365, 12, 11, 10,
  365, 14, 12,  5,
  365, 14, 13,  0,
  365, 16, 10,  3,
  365, 18,  5,  4,
  365, 19,  2,  0,
  366, 14, 11,  7,
  366, 14, 13,  1,
  366, 19,  2,  1,
  369, 12, 12,  9,
  369, 13, 10, 10,
  369, 14, 13,  2,
  369, 15, 12,  0,
  369, 16,  8,  7,
  369, 17,  8,  4,
  369, 18,  6,  3,
  369, 19,  2,  2,
  370, 15,  9,  8,
  370, 15, 12,  1,
  370, 17,  9,  0,
  370, 19,  3,  0,
  371, 13, 11,  9,
  371, 15, 11,  5,
  371, 17,  9,  1,
  371, 19,  3,  1,
  372, 16, 10,  4,
  373, 15, 12,  2,
  373, 16,  9,  6,
  373, 18,  7,  0,
  374, 13, 13,  6,
  374, 14, 13,  3,
  374, 15, 10,  7,
  374, 17,  7,  6,
  374, 17,  9,  2,
  374, 18,  5,  5,
  374, 18,  7,  1,
  374, 19,  3,  2,
  376, 14, 12,  6,
  376, 18,  6,  4,
  377, 13, 12,  8,
  377, 14, 10,  9,
  377, 16, 11,  0,
  377, 18,  7,  2,
  377, 19,  4,  0,
  378, 15, 12,  3,
  378, 16, 11,  1,
  378, 17,  8,  5,
  378, 19,  4,  1,
  379, 17,  9,  3,
  379, 19,  3,  3,
  381, 14, 11,  8,
  381, 14, 13,  4,
  381, 16, 10,  5,
  381, 16, 11,  2,
  381, 19,  4,  2,
  382, 15, 11,  6,
  382, 18,  7,  3,
  384, 16,  8,  8,
  385, 15, 12,  4,
  385, 18,  6,  5,
  386, 12, 11, 11,
  386, 16,  9,  7,
  386, 16, 11,  3,
  386, 17,  9,  4,
  386, 19,  4,  3,
  386, 19,  5,  0,
  387, 13, 13,  7,
  387, 15,  9,  9,
  387, 17,  7,  7,
  387, 19,  5,  1,
  388, 12, 12, 10,
  388, 18,  8,  0,
  389, 14, 12,  7,
  389, 15, 10,  8,
  389, 17,  8,  6,
  389, 17, 10,  0,
  389, 18,  7,  4,
  389, 18,  8,  1,
  390, 13, 11, 10,
  390, 14, 13,  5,
  390, 17, 10,  1,
  390, 19,  5,  2,
  392, 14, 14,  0,
  392, 16, 10,  6,
  392, 18,  8,  2,
  393, 14, 14,  1,
  393, 16, 11,  4,
  393, 17, 10,  2,
  393, 19,  4,  4,
  394, 13, 12,  9,
  394, 15, 12,  5,
  394, 15, 13,  0,
  395, 15, 11,  7,
  395, 15, 13,  1,
  395, 17,  9,  5,
  395, 19,  5,  3,
  396, 14, 10, 10,
  396, 14, 14,  2,
  396, 18,  6,  6,
  397, 18,  8,  3,
  397, 19,  6,  0,
  398, 14, 11,  9,
  398, 15, 13,  2,
  398, 17, 10,  3,
  398, 18,  7,  5,
  398, 19,  6,  1,
  400, 16, 12,  0,
  400, 20,  0,  0,
  401, 14, 13,  6,
  401, 14, 14,  3,
  401, 16,  9,  8,
  401, 16, 12,  1,
  401, 19,  6,  2,
  401, 20,  1,  0,
  402, 13, 13,  8,
  402, 16, 11,  5,
  402, 17,  8,  7,
  402, 19,  5,  4,
  402, 20,  1,  1,
  403, 15, 13,  3,
  404, 14, 12,  8,
  404, 16, 12,  2,
  404, 18,  8,  4,
  404, 20,  2,  0,
  405, 15, 12,  6,
  405, 16, 10,  7,
  405, 17, 10,  4,
  405, 18,  9,  0,
  405, 20,  2,  1,
  406, 15, 10,  9,
  406, 17,  9,  6,
  406, 18,  9,  1,
  406, 19,  6,  3,
  408, 14, 14,  4,
  408, 20,  2,  2,
  409, 12, 12, 11,
  409, 16, 12,  3,
  409, 18,  7,  6,
  409, 18,  9,  2,
  409, 20,  3,  0,
  410, 15, 11,  8,
  410, 15, 13,  4,
  410, 17, 11,  0,
  410, 19,  7,  0,
  410, 20,  3,  1,
  411, 13, 11, 11,
  411, 17, 11,  1,
  411, 19,  5,  5,
  411, 19,  7,  1,
  413, 13, 12, 10,
  413, 16, 11,  6,
  413, 18,  8,  5,
  413, 19,  6,  4,
  413, 20,  3,  2,
  414, 14, 13,  7,
  414, 17, 10,  5,
  414, 17, 11,  2,
  414, 18,  9,  3,
  414, 19,  7,  2,
  416, 16, 12,  4,
  416, 20,  4,  0,
  417, 14, 11, 10,
  417, 14, 14,  5,
  417, 17,  8,  8,
  417, 20,  4,  1,
  418, 15, 12,  7,
  418, 16,  9,  9,
  418, 20,  3,  3,
  419, 13, 13,  9,
  419, 15, 13,  5,
  419, 17,  9,  7,
  419, 17, 11,  3,
  419, 19,  7,  3,
  420, 16, 10,  8,
  420, 20,  4,  2,
  421, 14, 12,  9,
  421, 15, 14,  0,
  421, 18,  9,  4,
  422, 15, 14,  1,
  422, 18,  7,  7,
  422, 19,  6,  5,
  424, 18,  8,  6,
  424, 18, 10,  0,
  425, 15, 10, 10,
  425, 15, 14,  2,
  425, 16, 12,  5,
  425, 16, 13,  0,
  425, 17, 10,  6,
  425, 18, 10,  1,
  425, 19,  8,  0,
  425, 20,  4,  3,
  425, 20,  5,  0,
  426, 16, 11,  7,
  426, 16, 13,  1,
  426, 17, 11,  4,
  426, 19,  7,  4,
  426, 19,  8,  1,
  426, 20,  5,  1,
  427, 15, 11,  9,
  428, 14, 14,  6,
  428, 18, 10,  2,
  429, 14, 13,  8,
  429, 16, 13,  2,
  429, 19,  8,  2,
  429, 20,  5,  2,
  430, 15, 13,  6,
  430, 15, 14,  3,
  430, 18,  9,  5,
  432, 12, 12, 12,
  432, 20,  4,  4,
  433, 15, 12,  8,
  433, 17, 12,  0,
  433, 18, 10,  3,
  433, 19,  6,  6,
  434, 13, 12, 11,
  434, 16, 13,  3,
  434, 17,  9,  8,
  434, 17, 12,  1,
  434, 19,  8,  3,
  434, 20,  5,  3,
  435, 17, 11,  5,
  435, 19,  7,  5,
  436, 16, 12,  6,
  436, 20,  6,  0,
  437, 15, 14,  4,
  437, 16, 10,  9,
  437, 17, 12,  2,
  437, 18,  8,  7,
  437, 20,  6,  1,
  438, 13, 13, 10,
  438, 14, 11, 11,
  438, 17, 10,  7,
  440, 14, 12, 10,
  440, 18, 10,  4,
  440, 20,  6,  2,
  441, 14, 14,  7,
  441, 16, 11,  8,
  441, 16, 13,  4,
  441, 18,  9,  6,
  441, 19,  8,  4,
  441, 20,  5,  4,
  441, 21,  0,  0,
  442, 17, 12,  3,
  442, 19,  9,  0,
  442, 21,  1,  0,
  443, 15, 13,  7,
  443, 19,  9,  1,
  443, 21,  1,  1,
  445, 18, 11,  0,
  445, 20,  6,  3,
  445, 21,  2,  0,
  446, 14, 13,  9,
  446, 15, 11, 10,
  446, 15, 14,  5,
  446, 17, 11,  6,
  446, 18, 11,  1,
  446, 19,  7,  6,
  446, 19,  9,  2,
  446, 21,  2,  1,
  449, 16, 12,  7,
  449, 17, 12,  4,
  449, 18, 10,  5,
  449, 18, 11,  2,
  449, 20,  7,  0,
  449, 21,  2,  2,
  450, 15, 12,  9,
  450, 15, 15,  0,
  450, 16, 13,  5,
  450, 19,  8,  5,
  450, 20,  5,  5,
  450, 20,  7,  1,
  450, 21,  3,  0,
  451, 15, 15,  1,
  451, 17,  9,  9,
  451, 19,  9,  3,
  451, 21,  3,  1,
  452, 16, 14,  0,
  452, 18,  8,  8,
  452, 20,  6,  4,
  453, 16, 14,  1,
  453, 17, 10,  8,
  453, 20,  7,  2,
  454, 15, 15,  2,
  454, 18,  9,  7,
  454, 18, 11,  3,
  454, 21,  3,  2,
  456, 14, 14,  8,
  456, 16, 10, 10,
  456, 16, 14,  2,
  457, 13, 12, 12,
  457, 15, 14,  6,
  457, 21,  4,  0,
  458, 15, 13,  8,
  458, 16, 11,  9,
  458, 17, 12,  5,
  458, 17, 13,  0,
  458, 19,  9,  4,
  458, 20,  7,  3,
  458, 21,  4,  1,
  459, 13, 13, 11,
  459, 15, 15,  3,
  459, 17, 11,  7,
  459, 17, 13,  1,
  459, 19,  7,  7,
  459, 21,  3,  3,
  460, 18, 10,  6,
  461, 14, 12, 11,
  461, 16, 13,  6,
  461, 16, 14,  3,
  461, 18, 11,  4,
  461, 19,  8,  6,
  461, 19, 10,  0,
  461, 20,  6,  5,
  461, 21,  4,  2,
  462, 17, 13,  2,
  462, 19, 10,  1,
  464, 16, 12,  8,
  464, 20,  8,  0,
  465, 14, 13, 10,
  465, 19, 10,  2,
  465, 20,  7,  4,
  465, 20,  8,  1,
  466, 15, 15,  4,
  466, 21,  4,  3,
  466, 21,  5,  0,
  467, 15, 11, 11,
  467, 17, 13,  3,
  467, 19,  9,  5,
  467, 21,  5,  1,
  468, 16, 14,  4,
  468, 18, 12,  0,
  468, 20,  8,  2,
  469, 15, 12, 10,
  469, 17, 12,  6,
  469, 18,  9,  8,
  469, 18, 12,  1,
  470, 15, 14,  7,
  470, 17, 10,  9,
  470, 18, 11,  5,
  470, 19, 10,  3,
  470, 21,  5,  2,
  472, 18, 12,  2,
  472, 20,  6,  6,
  473, 14, 14,  9,
  473, 18, 10,  7,
  473, 20,  8,  3,
  473, 21,  4,  4,
  474, 16, 13,  7,
  474, 17, 11,  8,
  474, 17, 13,  4,
  474, 19,  8,  7,
  474, 20,  7,  5,
  475, 15, 13,  9,
  475, 15, 15,  5,
  475, 21,  5,  3,
  477, 16, 11, 10,
  477, 16, 14,  5,
  477, 18, 12,  3,
  477, 19, 10,  4,
  477, 21,  6,  0,
  478, 19,  9,  6,
  478, 21,  6,  1,
  480, 20,  8,  4,
  481, 16, 12,  9,
  481, 16, 15,  0,
  481, 18, 11,  6,
  481, 20,  9,  0,
  481, 21,  6,  2,
  482, 13, 13, 12,
  482, 16, 15,  1,
  482, 17, 12,  7,
  482, 19, 11,  0,
  482, 20,  9,  1,
  482, 21,  5,  4,
  483, 17, 13,  5,
  483, 19, 11,  1,
  484, 14, 12, 12,
  484, 18, 12,  4,
  484, 22,  0,  0,
  485, 15, 14,  8,
  485, 16, 15,  2,
  485, 17, 14,  0,
  485, 20,  7,  6,
  485, 20,  9,  2,
  485, 22,  1,  0,
  486, 14, 13, 11,
  486, 15, 15,  6,
  486, 17, 14,  1,
  486, 18,  9,  9,
  486, 19, 10,  5,
  486, 19, 11,  2,
  486, 21,  6,  3,
  486, 22,  1,  1,
  488, 16, 14,  6,
  488, 18, 10,  8,
  488, 22,  2,  0,
  489, 16, 13,  8,
  489, 17, 10, 10,
  489, 17, 14,  2,
  489, 19,  8,  8,
  489, 20,  8,  5,
  489, 22,  2,  1,
  490, 15, 12, 11,
  490, 16, 15,  3,
  490, 20,  9,  3,
  490, 21,  7,  0,
  491, 17, 11,  9,
  491, 19,  9,  7,
  491, 19, 11,  3,
  491, 21,  5,  5,
  491, 21,  7,  1,
  492, 14, 14, 10,
  492, 22,  2,  2,
  493, 18, 12,  5,
  493, 18, 13,  0,
  493, 21,  6,  4,
  493, 22,  3,  0,
  494, 15, 13, 10,
  494, 17, 13,  6,
  494, 17, 14,  3,
  494, 18, 11,  7,
  494, 18, 13,  1,
  494, 21,  7,  2,
  494, 22,  3,  1,
  497, 16, 15,  4,
  497, 17, 12,  8,
  497, 18, 13,  2,
  497, 19, 10,  6,
  497, 20,  9,  4,
  497, 22,  3,  2,
  498, 16, 11, 11,
  498, 19, 11,  4,
  498, 20,  7,  7,
  499, 15, 15,  7,
  499, 21,  7,  3,
  500, 16, 12, 10,
  500, 20,  8,  6,
  500, 20, 10,  0,
  500, 22,  4,  0,
  501, 16, 14,  7,
  501, 17, 14,  4,
  501, 20, 10,  1,
  501, 22,  4,  1,
  502, 15, 14,  9,
  502, 18, 13,  3,
  502, 21,  6,  5,
  502, 22,  3,  3,
  504, 18, 12,  6,
  504, 20, 10,  2,
  504, 22,  4,  2,
  505, 18, 10,  9,
  505, 19, 12,  0,
  505, 21,  8,  0,
  506, 16, 13,  9,
  506, 16, 15,  5,
  506, 19,  9,  8,
  506, 19, 12,  1,
  506, 20,  9,  5,
  506, 21,  7,  4,
  506, 21,  8,  1,
  507, 13, 13, 13,
  507, 17, 13,  7,
  507, 19, 11,  5,
  509, 14, 13, 12,
  509, 18, 11,  8,
  509, 18, 13,  4,
  509, 19, 12,  2,
  509, 20, 10,  3,
  509, 21,  8,  2,
  509, 22,  4,  3,
  509, 22,  5,  0,
  510, 17, 11, 10,
  510, 17, 14,  5,
  510, 19, 10,  7,
  510, 22,  5,  1,
  512, 16, 16,  0,
  513, 14, 14, 11,
  513, 15, 12, 12,
  513, 16, 16,  1,
  513, 20,  8,  7,
  513, 21,  6,  6,
  513, 22,  5,  2,
  514, 15, 15,  8,
  514, 17, 12,  9,
  514, 17, 15,  0,
  514, 19, 12,  3,
  514, 21,  8,  3,
  515, 15, 13, 11,
  515, 17, 15,  1,
  515, 21,  7,  5,
  516, 16, 14,  8,
  516, 16, 16,  2,
  516, 20, 10,  4,
  516, 22,  4,  4,
  517, 16, 15,  6,
  517, 18, 12,  7,
  517, 20,  9,  6,
  518, 17, 15,  2,
  518, 18, 13,  5,
  518, 19, 11,  6,
  518, 22,  5,  3,
  520, 18, 14,  0,
  520, 22,  6,  0,
  521, 15, 14, 10,
  521, 16, 12, 11,
  521, 16, 16,  3,
  521, 17, 14,  6,
  521, 18, 14,  1,
  521, 19, 12,  4,
  521, 20, 11,  0,
  521, 21,  8,  4,
  521, 22,  6,  1,
  522, 17, 13,  8,
  522, 20, 11,  1,
  522, 21,  9,  0,
  523, 17, 15,  3,
  523, 19,  9,  9,
  523, 21,  9,  1,
  524, 18, 10, 10,
  524, 18, 14,  2,
  524, 22,  6,  2,
  525, 16, 13, 10,
  525, 19, 10,  8,
  525, 20, 10,  5,
  525, 20, 11,  2,
  525, 22,  5,  4,
  526, 18, 11,  9,
  526, 21,  7,  6,
  526, 21,  9,  2,
  528, 16, 16,  4,
  528, 20,  8,  8,
  529, 18, 13,  6,
  529, 18, 14,  3,
  529, 22,  6,  3,
  529, 23,  0,  0,
  530, 16, 15,  7,
  530, 17, 15,  4,
  530, 19, 12,  5,
  530, 19, 13,  0,
  530, 20,  9,  7,
  530, 20, 11,  3,
  530, 21,  8,  5,
  530, 23,  1,  0,
  531, 15, 15,  9,
  531, 17, 11, 11,
  531, 19, 11,  7,
  531, 19, 13,  1,
  531, 21,  9,  3,
  531, 23,  1,  1,
  532, 18, 12,  8,
  533, 16, 14,  9,
  533, 17, 12, 10,
  533, 22,  7,  0,
  533, 23,  2,  0,
  534, 14, 13, 13,
  534, 17, 14,  7,
  534, 19, 13,  2,
  534, 22,  5,  5,
  534, 22,  7,  1,
  534, 23,  2,  1,
  536, 14, 14, 12,
  536, 18, 14,  4,
  536, 20, 10,  6,
  536, 22,  6,  4,
  537, 16, 16,  5,
  537, 20, 11,  4,
  537, 22,  7,  2,
  537, 23,  2,  2,
  538, 15, 13, 12,
  538, 21,  9,  4,
  538, 23,  3,  0,
  539, 17, 13,  9,
  539, 17, 15,  5,
  539, 19, 13,  3,
  539, 21,  7,  7,
  539, 23,  3,  1,
  541, 19, 12,  6,
  541, 21,  8,  6,
  541, 21, 10,  0,
  542, 15, 14, 11,
  542, 18, 13,  7,
  542, 19, 10,  9,
  542, 21, 10,  1,
  542, 22,  7,  3,
  542, 23,  3,  2,
  544, 16, 12, 12,
  544, 20, 12,  0,
  545, 16, 15,  8,
  545, 17, 16,  0,
  545, 18, 11, 10,
  545, 18, 14,  5,
  545, 20,  9,  8,
  545, 20, 12,  1,
  545, 21, 10,  2,
  545, 22,  6,  5,
  545, 23,  4,  0,
  546, 16, 13, 11,
  546, 17, 16,  1,
  546, 19, 11,  8,
  546, 19, 13,  4,
  546, 20, 11,  5,
  546, 23,  4,  1,
  547, 21,  9,  5,
  547, 23,  3,  3,
  548, 16, 16,  6,
  548, 20, 12,  2,
  548, 22,  8,  0,
  549, 17, 14,  8,
  549, 17, 16,  2,
  549, 18, 12,  9,
  549, 18, 15,  0,
  549, 20, 10,  7,
  549, 22,  7,  4,
  549, 22,  8,  1,
  549, 23,  4,  2,
  550, 15, 15, 10,
  550, 17, 15,  6,
  550, 18, 15,  1,
  550, 21, 10,  3,
  552, 16, 14, 10,
  552, 22,  8,  2,
  553, 18, 15,  2,
  553, 20, 12,  3,
  554, 17, 12, 11,
  554, 17, 16,  3,
  554, 19, 12,  7,
  554, 21,  8,  7,
  554, 23,  4,  3,
  554, 23,  5,  0,
  555, 19, 13,  5,
  555, 23,  5,  1,
  556, 18, 14,  6,
  556, 22,  6,  6,
  557, 18, 13,  8,
  557, 19, 14,  0,
  557, 20, 11,  6,
  557, 21, 10,  4,
  557, 22,  8,  3,
  558, 17, 13, 10,
  558, 18, 15,  3,
  558, 19, 14,  1,
  558, 21,  9,  6,
  558, 22,  7,  5,
  558, 23,  5,  2,
  560, 20, 12,  4,
  561, 14, 14, 13,
  561, 16, 16,  7,
  561, 17, 16,  4,
  561, 19, 10, 10,
  561, 19, 14,  2,
  561, 23,  4,  4,
  562, 16, 15,  9,
  562, 20,  9,  9,
  562, 21, 11,  0,
  563, 15, 13, 13,
  563, 17, 15,  7,
  563, 19, 11,  9,
  563, 21, 11,  1,
  563, 23,  5,  3,
  564, 20, 10,  8,
  564, 22,  8,  4,
  565, 15, 14, 12,
  565, 18, 15,  4,
  565, 22,  9,  0,
  565, 23,  6,  0,
  566, 17, 14,  9,
  566, 18, 11, 11,
  566, 19, 13,  6,
  566, 19, 14,  3,
  566, 21, 10,  5,
  566, 21, 11,  2,
  566, 22,  9,  1,
  566, 23,  6,  1,
  568, 18, 12, 10,
  569, 16, 13, 12,
  569, 18, 14,  7,
  569, 19, 12,  8,
  569, 20, 12,  5,
  569, 20, 13,  0,
  569, 21,  8,  8,
  569, 22,  7,  6,
  569, 22,  9,  2,
  569, 23,  6,  2,
  570, 17, 16,  5,
  570, 20, 11,  7,
  570, 20, 13,  1,
  570, 23,  5,  4,
  571, 15, 15, 11,
  571, 21,  9,  7,
  571, 21, 11,  3,
  573, 16, 14, 11,
  573, 19, 14,  4,
  573, 20, 13,  2,
  573, 22,  8,  5,
  574, 18, 13,  9,
  574, 18, 15,  5,
  574, 22,  9,  3,
  574, 23,  6,  3,
  576, 16, 16,  8,
  576, 24,  0,  0,
  577, 17, 12, 12,
  577, 21, 10,  6,
  577, 24,  1,  0,
  578, 17, 15,  8,
  578, 17, 17,  0,
  578, 20, 13,  3,
  578, 21, 11,  4,
  578, 23,  7,  0,
  578, 24,  1,  1,
  579, 17, 13, 11,
  579, 17, 17,  1,
  579, 19, 13,  7,
  579, 23,  5,  5,
  579, 23,  7,  1,
  580, 18, 16,  0,
  580, 20, 12,  6,
  580, 24,  2,  0,
  581, 16, 15, 10,
  581, 17, 16,  6,
  581, 18, 16,  1,
  581, 20, 10,  9,
  581, 22,  9,  4,
  581, 23,  6,  4,
  581, 24,  2,  1,
  582, 17, 17,  2,
  582, 19, 11, 10,
  582, 19, 14,  5,
  582, 22,  7,  7,
  582, 23,  7,  2,
  584, 18, 14,  8,
  584, 18, 16,  2,
  584, 22,  8,  6,
  584, 22, 10,  0,
  584, 24,  2,  2,
  585, 17, 14, 10,
  585, 18, 15,  6,
  585, 20, 11,  8,
  585, 20, 13,  4,
  585, 21, 12,  0,
  585, 22, 10,  1,
  585, 24,  3,  0,
  586, 19, 12,  9,
  586, 19, 15,  0,
  586, 21,  9,  8,
  586, 21, 12,  1,
  586, 24,  3,  1,
  587, 17, 17,  3,
  587, 19, 15,  1,
  587, 21, 11,  5,
  587, 23,  7,  3,
  588, 14, 14, 14,
  588, 22, 10,  2,
  589, 18, 12, 11,
  589, 18, 16,  3,
  589, 21, 12,  2,
  589, 24,  3,  2,
  590, 15, 14, 13,
  590, 19, 15,  2,
  590, 21, 10,  7,
  590, 22,  9,  5,
  590, 23,  6,  5,
  592, 24,  4,  0,
  593, 16, 16,  9,
  593, 18, 13, 10,
  593, 19, 14,  6,
  593, 20, 12,  7,
  593, 22, 10,  3,
  593, 23,  8,  0,
  593, 24,  4,  1,
  594, 15, 15, 12,
  594, 16, 13, 13,
  594, 17, 16,  7,
  594, 17, 17,  4,
  594, 19, 13,  8,
  594, 20, 13,  5,
  594, 21, 12,  3,
  594, 23,  7,  4,
  594, 23,  8,  1,
  594, 24,  3,  3,
  595, 17, 15,  9,
  595, 19, 15,  3,
  596, 16, 14, 12,
  596, 18, 16,  4,
  596, 20, 14,  0,
  596, 24,  4,  2,
  597, 20, 14,  1,
  597, 22,  8,  7,
  597, 23,  8,  2,
  598, 18, 15,  7,
  598, 21, 11,  6,
  600, 20, 10, 10,
  600, 20, 14,  2,
  600, 22, 10,  4,
  601, 18, 14,  9,
  601, 21, 12,  4,
  601, 22,  9,  6,
  601, 23,  6,  6,
  601, 24,  4,  3,
  601, 24,  5,  0,
  602, 16, 15, 11,
  602, 17, 13, 12,
  602, 19, 15,  4,
  602, 20, 11,  9,
  602, 23,  8,  3,
  602, 24,  5,  1,
  603, 17, 17,  5,
  603, 19, 11, 11,
  603, 21,  9,  9,
  603, 23,  7,  5,
  605, 18, 16,  5,
  605, 19, 12, 10,
  605, 20, 13,  6,
  605, 20, 14,  3,
  605, 21, 10,  8,
  605, 22, 11,  0,
  605, 24,  5,  2,
  606, 17, 14, 11,
  606, 19, 14,  7,
  606, 22, 11,  1,
  608, 20, 12,  8,
  608, 24,  4,  4,
  609, 17, 16,  8,
  609, 22, 10,  5,
  609, 22, 11,  2,
  609, 23,  8,  4,
  610, 21, 12,  5,
  610, 21, 13,  0,
  610, 23,  9,  0,
  610, 24,  5,  3,
  611, 19, 13,  9,
  611, 19, 15,  5,
  611, 21, 11,  7,
  611, 21, 13,  1,
  611, 23,  9,  1,
  612, 16, 16, 10,
  612, 18, 12, 12,
  612, 20, 14,  4,
  612, 22,  8,  8,
  612, 24,  6,  0,
  613, 18, 15,  8,
  613, 18, 17,  0,
  613, 24,  6,  1,
  614, 17, 15, 10,
  614, 17, 17,  6,
  614, 18, 13, 11,
  614, 18, 17,  1,
  614, 21, 13,  2,
  614, 22,  9,  7,
  614, 22, 11,  3,
  614, 23,  7,  6,
  614, 23,  9,  2,
  616, 18, 16,  6,
  616, 24,  6,  2,
  617, 15, 14, 14,
  617, 18, 17,  2,
  617, 19, 16,  0,
  617, 24,  5,  4,
  618, 19, 16,  1,
  618, 20, 13,  7,
  618, 23,  8,  5,
  619, 15, 15, 13,
  619, 21, 13,  3,
  619, 23,  9,  3,
  620, 18, 14, 10,
  620, 22, 10,  6,
  621, 16, 14, 13,
  621, 19, 14,  8,
  621, 19, 16,  2,
  621, 20, 11, 10,
  621, 20, 14,  5,
  621, 21, 12,  6,
  621, 22, 11,  4,
  621, 24,  6,  3,
  622, 18, 17,  3,
  622, 19, 15,  6,
  622, 21, 10,  9,
  625, 16, 15, 12,
  625, 20, 12,  9,
  625, 20, 15,  0,
  625, 24,  7,  0,
  625, 25,  0,  0,
  626, 17, 16,  9,
  626, 19, 12, 11,
  626, 19, 16,  3,
  626, 20, 15,  1,
  626, 21, 11,  8,
  626, 21, 13,  4,
  626, 23,  9,  4,
  626, 24,  5,  5,
  626, 24,  7,  1,
  626, 25,  1,  0,
  627, 17, 13, 13,
  627, 17, 17,  7,
  627, 23,  7,  7,
  627, 25,  1,  1,
  628, 22, 12,  0,
  628, 24,  6,  4,
  629, 17, 14, 12,
  629, 18, 16,  7,
  629, 18, 17,  4,
  629, 20, 15,  2,
  629, 22,  9,  8,
  629, 22, 12,  1,
  629, 23,  8,  6,
  629, 23, 10,  0,
  629, 24,  7,  2,
  629, 25,  2,  0,
  630, 18, 15,  9,
  630, 19, 13, 10,
  630, 22, 11,  5,
  630, 23, 10,  1,
  630, 25,  2,  1,
  632, 20, 14,  6,
  632, 22, 12,  2,
  633, 16, 16, 11,
  633, 19, 16,  4,
  633, 20, 13,  8,
  633, 22, 10,  7,
  633, 23, 10,  2,
  633, 25,  2,  2,
  634, 20, 15,  3,
  634, 21, 12,  7,
  634, 24,  7,  3,
  634, 25,  3,  0,
  635, 17, 15, 11,
  635, 19, 15,  7,
  635, 21, 13,  5,
  635, 23,  9,  5,
  635, 25,  3,  1,
  637, 18, 13, 12,
  637, 21, 14,  0,
  637, 22, 12,  3,
  637, 24,  6,  5,
  638, 18, 17,  5,
  638, 19, 14,  9,
  638, 21, 14,  1,
  638, 23, 10,  3,
  638, 25,  3,  2,
  640, 24,  8,  0,
  641, 18, 14, 11,
  641, 20, 15,  4,
  641, 21, 10, 10,
  641, 21, 14,  2,
  641, 22, 11,  6,
  641, 24,  7,  4,
  641, 24,  8,  1,
  641, 25,  4,  0,
  642, 17, 17,  8,
  642, 19, 16,  5,
  642, 20, 11, 11,
  642, 23,  8,  7,
  642, 25,  4,  1,
  643, 21, 11,  9,
  643, 25,  3,  3,
  644, 18, 16,  8,
  644, 20, 12, 10,
  644, 22, 12,  4,
  644, 24,  8,  2,
  645, 17, 16, 10,
  645, 20, 14,  7,
  645, 23, 10,  4,
  645, 25,  4,  2,
  646, 15, 15, 14,
  646, 21, 13,  6,
  646, 21, 14,  3,
  646, 22,  9,  9,
  646, 23,  9,  6,
  648, 16, 14, 14,
  648, 18, 18,  0,
  648, 22, 10,  8,
  648, 24,  6,  6,
  649, 18, 15, 10,
  649, 18, 17,  6,
  649, 18, 18,  1,
  649, 19, 12, 12,
  649, 21, 12,  8,
  649, 24,  8,  3,
  650, 16, 15, 13,
  650, 19, 15,  8,
  650, 19, 17,  0,
  650, 20, 13,  9,
  650, 20, 15,  5,
  650, 23, 11,  0,
  650, 24,  7,  5,
  650, 25,  4,  3,
  650, 25,  5,  0,
  651, 19, 13, 11,
  651, 19, 17,  1,
  651, 23, 11,  1,
  651, 25,  5,  1,
  652, 18, 18,  2,
  653, 19, 16,  6,
  653, 21, 14,  4,
  653, 22, 12,  5,
  653, 22, 13,  0,
  654, 17, 14, 13,
  654, 19, 17,  2,
  654, 22, 11,  7,
  654, 22, 13,  1,
  654, 23, 10,  5,
  654, 23, 11,  2,
  654, 25,  5,  2,
  656, 16, 16, 12,
  656, 20, 16,  0,
  656, 24,  8,  4,
  657, 18, 18,  3,
  657, 19, 14, 10,
  657, 20, 16,  1,
  657, 22, 13,  2,
  657, 23,  8,  8,
  657, 24,  9,  0,
  657, 25,  4,  4,
  658, 17, 15, 12,
  658, 24,  9,  1,
  659, 17, 17,  9,
  659, 19, 17,  3,
  659, 21, 13,  7,
  659, 23,  9,  7,
  659, 23, 11,  3,
  659, 25,  5,  3,
  660, 20, 14,  8,
  660, 20, 16,  2,
  661, 18, 16,  9,
  661, 20, 15,  6,
  661, 24,  7,  6,
  661, 24,  9,  2,
  661, 25,  6,  0,
  662, 18, 13, 13,
  662, 18, 17,  7,
  662, 21, 11, 10,
  662, 21, 14,  5,
  662, 22, 13,  3,
  662, 25,  6,  1,
  664, 18, 14, 12,
  664, 18, 18,  4,
  664, 22, 12,  6,
  665, 20, 12, 11,
  665, 20, 16,  3,
  665, 22, 10,  9,
  665, 23, 10,  6,
  665, 24,  8,  5,
  665, 25,  6,  2,
  666, 17, 16, 11,
  666, 19, 16,  7,
  666, 19, 17,  4,
  666, 21, 12,  9,
  666, 21, 15,  0,
  666, 23, 11,  4,
  666, 24,  9,  3,
  666, 25,  5,  4,
  667, 19, 15,  9,
  667, 21, 15,  1,
  669, 20, 13, 10,
  669, 22, 11,  8,
  669, 22, 13,  4,
  670, 18, 15, 11,
  670, 21, 15,  2,
  670, 25,  6,  3,
  672, 20, 16,  4,
  673, 18, 18,  5,
  673, 21, 14,  6,
  673, 23, 12,  0,
  673, 24,  9,  4,
  674, 19, 13, 12,
  674, 20, 15,  7,
  674, 21, 13,  8,
  674, 23,  9,  8,
  674, 23, 12,  1,
  674, 24,  7,  7,
  674, 25,  7,  0,
  675, 15, 15, 15,
  675, 19, 17,  5,
  675, 21, 15,  3,
  675, 23, 11,  5,
  675, 25,  5,  5,
  675, 25,  7,  1,
  676, 24,  8,  6,
  676, 24, 10,  0,
  676, 26,  0,  0,
  677, 16, 15, 14,
  677, 18, 17,  8,
  677, 20, 14,  9,
  677, 22, 12,  7,
  677, 23, 12,  2,
  677, 24, 10,  1,
  677, 25,  6,  4,
  677, 26,  1,  0,
  678, 17, 17, 10,
  678, 19, 14, 11,
  678, 22, 13,  5,
  678, 23, 10,  7,
  678, 25,  7,  2,
  678, 26,  1,  1,
  680, 18, 16, 10,
  680, 22, 14,  0,
  680, 24, 10,  2,
  680, 26,  2,  0,
  681, 16, 16, 13,
  681, 17, 14, 14,
  681, 19, 16,  8,
  681, 20, 16,  5,
  681, 22, 14,  1,
  681, 26,  2,  1,
  682, 21, 15,  4,
  682, 23, 12,  3,
  682, 24,  9,  5,
  683, 17, 15, 13,
  683, 21, 11, 11,
  683, 25,  7,  3,
  684, 18, 18,  6,
  684, 22, 10, 10,
  684, 22, 14,  2,
  684, 26,  2,  2,
  685, 19, 18,  0,
  685, 21, 12, 10,
  685, 24, 10,  3,
  685, 26,  3,  0,
  686, 19, 15, 10,
  686, 19, 17,  6,
  686, 19, 18,  1,
  686, 21, 14,  7,
  686, 22, 11,  9,
  686, 23, 11,  6,
  686, 25,  6,  5,
  686, 26,  3,  1,
  688, 20, 12, 12,
  689, 17, 16, 12,
  689, 18, 14, 13,
  689, 19, 18,  2,
  689, 20, 15,  8,
  689, 20, 17,  0,
  689, 22, 13,  6,
  689, 22, 14,  3,
  689, 23, 12,  4,
  689, 24,  8,  7,
  689, 25,  8,  0,
  689, 26,  3,  2,
  690, 20, 13, 11,
  690, 20, 17,  1,
  690, 25,  7,  4,
  690, 25,  8,  1,
  691, 21, 13,  9,
  691, 21, 15,  5,
  691, 23,  9,  9,
  692, 20, 16,  6,
  692, 22, 12,  8,
  692, 24, 10,  4,
  692, 26,  4,  0,
  693, 18, 15, 12,
  693, 20, 17,  2,
  693, 23, 10,  8,
  693, 24,  9,  6,
  693, 25,  8,  2,
  693, 26,  4,  1,
  694, 18, 17,  9,
  694, 19, 18,  3,
  694, 26,  3,  3,
  696, 20, 14, 10,
  696, 22, 14,  4,
  696, 26,  4,  2,
  697, 18, 18,  7,
  697, 21, 16,  0,
  697, 24, 11,  0,
  697, 25,  6,  6,
  698, 19, 16,  9,
  698, 20, 17,  3,
  698, 21, 16,  1,
  698, 23, 12,  5,
  698, 23, 13,  0,
  698, 24, 11,  1,
  698, 25,  8,  3,
  699, 17, 17, 11,
  699, 19, 13, 13,
  699, 19, 17,  7,
  699, 23, 11,  7,
  699, 23, 13,  1,
  699, 25,  7,  5,
  701, 18, 16, 11,
  701, 19, 14, 12,
  701, 19, 18,  4,
  701, 21, 14,  8,
  701, 21, 16,  2,
  701, 24, 10,  5,
  701, 24, 11,  2,
  701, 26,  4,  3,
  701, 26,  5,  0,
  702, 21, 15,  6,
  702, 22, 13,  7,
  702, 23, 13,  2,
  702, 26,  5,  1,
  704, 24,  8,  8,
  705, 20, 16,  7,
  705, 20, 17,  4,
  705, 22, 11, 10,
  705, 22, 14,  5,
  705, 25,  8,  4,
  705, 26,  5,  2,
  706, 16, 15, 15,
  706, 20, 15,  9,
  706, 21, 12, 11,
  706, 21, 16,  3,
  706, 24,  9,  7,
  706, 24, 11,  3,
  706, 25,  9,  0,
  707, 19, 15, 11,
  707, 23, 13,  3,
  707, 25,  9,  1,
  708, 16, 16, 14,
  708, 26,  4,  4,
  709, 22, 12,  9,
  709, 22, 15,  0,
  709, 23, 12,  6,
  710, 17, 15, 14,
  710, 19, 18,  5,
  710, 21, 13, 10,
  710, 22, 15,  1,
  710, 23, 10,  9,
  710, 25,  7,  6,
  710, 25,  9,  2,
  710, 26,  5,  3,
  712, 18, 18,  8,
  712, 24, 10,  6,
  712, 26,  6,  0,
  713, 18, 17, 10,
  713, 20, 13, 12,
  713, 21, 16,  4,
  713, 22, 15,  2,
  713, 24, 11,  4,
  713, 26,  6,  1,
  714, 17, 16, 13,
  714, 19, 17,  8,
  714, 20, 17,  5,
  714, 23, 11,  8,
  714, 23, 13,  4,
  714, 25,  8,  5,
  715, 21, 15,  7,
  715, 25,  9,  3,
  716, 18, 14, 14,
  716, 22, 14,  6,
  716, 26,  6,  2,
  717, 19, 16, 10,
  717, 20, 14, 11,
  717, 22, 13,  8,
  717, 26,  5,  4,
  718, 18, 15, 13,
  718, 21, 14,  9,
  718, 22, 15,  3,
  720, 20, 16,  8,
  720, 24, 12,  0,
  721, 19, 18,  6,
  721, 24,  9,  8,
  721, 24, 12,  1,
  721, 26,  6,  3,
  722, 17, 17, 12,
  722, 19, 19,  0,
  722, 21, 16,  5,
  722, 23, 12,  7,
  722, 24, 11,  5,
  722, 25,  9,  4,
  723, 19, 19,  1,
  723, 23, 13,  5,
  723, 25,  7,  7,
  724, 18, 16, 12,
  724, 20, 18,  0,
  724, 24, 12,  2,
  725, 20, 15, 10,
  725, 20, 17,  6,
  725, 20, 18,  1,
  725, 22, 15,  4,
  725, 23, 14,  0,
  725, 24, 10,  7,
  725, 25,  8,  6,
  725, 25, 10,  0,
  725, 26,  7,  0,
  726, 19, 14, 13,
  726, 19, 19,  2,
  726, 22, 11, 11,
  726, 23, 14,  1,
  726, 25, 10,  1,
  726, 26,  5,  5,
  726, 26,  7,  1,
  728, 20, 18,  2,
  728, 22, 12, 10,
  728, 26,  6,  4,
  729, 18, 18,  9,
  729, 21, 12, 12,
  729, 22, 14,  7,
  729, 23, 10, 10,
  729, 23, 14,  2,
  729, 24, 12,  3,
  729, 25, 10,  2,
  729, 26,  7,  2,
  729, 27,  0,  0,
  730, 19, 15, 12,
  730, 21, 15,  8,
  730, 21, 17,  0,
  730, 27,  1,  0,
  731, 19, 17,  9,
  731, 19, 19,  3,
  731, 21, 13, 11,
  731, 21, 17,  1,
  731, 23, 11,  9,
  731, 25,  9,  5,
  731, 27,  1,  1,
  733, 20, 18,  3,
  733, 21, 16,  6,
  733, 24, 11,  6,
  733, 27,  2,  0,
  734, 18, 17, 11,
  734, 19, 18,  7,
  734, 21, 17,  2,
  734, 22, 13,  9,
  734, 22, 15,  5,
  734, 23, 13,  6,
  734, 23, 14,  3,
  734, 25, 10,  3,
  734, 26,  7,  3,
  734, 27,  2,  1,
  736, 24, 12,  4,
  737, 16, 16, 15,
  737, 20, 16,  9,
  737, 21, 14, 10,
  737, 23, 12,  8,
  737, 26,  6,  5,
  737, 27,  2,  2,
  738, 19, 16, 11,
  738, 19, 19,  4,
  738, 20, 13, 13,
  738, 20, 17,  7,
  738, 24,  9,  9,
  738, 25,  8,  7,
  738, 27,  3,  0,
  739, 17, 15, 15,
  739, 21, 17,  3,
  739, 27,  3,  1,
  740, 20, 14, 12,
  740, 20, 18,  4,
  740, 22, 16,  0,
  740, 24, 10,  8,
  740, 26,  8,  0,
  741, 17, 16, 14,
  741, 22, 16,  1,
  741, 23, 14,  4,
  741, 25, 10,  4,
  741, 26,  7,  4,
  741, 26,  8,  1,
  742, 25,  9,  6,
  742, 27,  3,  2,
  744, 22, 14,  8,
  744, 22, 16,  2,
  744, 26,  8,  2,
  745, 18, 15, 14,
  745, 22, 15,  6,
  745, 24, 12,  5,
  745, 24, 13,  0,
  745, 27,  4,  0,
  746, 20, 15, 11,
  746, 21, 16,  7,
  746, 21, 17,  4,
  746, 24, 11,  7,
  746, 24, 13,  1,
  746, 25, 11,  0,
  746, 27,  4,  1,
  747, 17, 17, 13,
  747, 19, 19,  5,
  747, 21, 15,  9,
  747, 23, 13,  7,
  747, 25, 11,  1,
  747, 27,  3,  3,
  748, 18, 18, 10,
  748, 26,  6,  6,
  749, 18, 16, 13,
  749, 19, 18,  8,
  749, 20, 18,  5,
  749, 22, 12, 11,
  749, 22, 16,  3,
  749, 24, 13,  2,
  749, 26,  8,  3,
  749, 27,  4,  2,
  750, 19, 17, 10,
  750, 23, 11, 10,
  750, 23, 14,  5,
  750, 25, 10,  5,
  750, 25, 11,  2,
  750, 26,  7,  5,
  753, 19, 14, 14,
  753, 20, 17,  8,
  753, 22, 13, 10,
  753, 25,  8,  8,
  754, 21, 13, 12,
  754, 23, 12,  9,
  754, 23, 15,  0,
  754, 24, 13,  3,
  754, 27,  4,  3,
  754, 27,  5,  0,
  755, 19, 15, 13,
  755, 21, 17,  5,
  755, 23, 15,  1,
  755, 25,  9,  7,
  755, 25, 11,  3,
  755, 27,  5,  1,
  756, 20, 16, 10,
  756, 22, 16,  4,
  756, 24, 12,  6,
  756, 26,  8,  4,
  757, 18, 17, 12,
  757, 24, 10,  9,
  757, 26,  9,  0,
  758, 19, 19,  6,
  758, 21, 14, 11,
  758, 22, 15,  7,
  758, 23, 15,  2,
  758, 26,  9,  1,
  758, 27,  5,  2,
  760, 20, 18,  6,
  761, 19, 16, 12,
  761, 20, 19,  0,
  761, 21, 16,  8,
  761, 22, 14,  9,
  761, 23, 14,  6,
  761, 24, 11,  8,
  761, 24, 13,  4,
  761, 25, 10,  6,
  761, 26,  7,  6,
  761, 26,  9,  2,
  761, 27,  4,  4,
  762, 20, 19,  1,
  762, 23, 13,  8,
  762, 25, 11,  4,
  763, 23, 15,  3,
  763, 27,  5,  3,
  765, 20, 14, 13,
  765, 20, 19,  2,
  765, 21, 18,  0,
  765, 22, 16,  5,
  765, 26,  8,  5,
  765, 27,  6,  0,
  766, 19, 18,  9,
  766, 21, 15, 10,
  766, 21, 17,  6,
  766, 21, 18,  1,
  766, 26,  9,  3,
  766, 27,  6,  1,
  768, 16, 16, 16,
  769, 18, 18, 11,
  769, 20, 15, 12,
  769, 21, 18,  2,
  769, 24, 12,  7,
  769, 25, 12,  0,
  769, 27,  6,  2,
  770, 17, 16, 15,
  770, 20, 17,  9,
  770, 20, 19,  3,
  770, 23, 15,  4,
  770, 24, 13,  5,
  770, 25,  9,  8,
  770, 25, 12,  1,
  770, 27,  5,  4,
  771, 19, 17, 11,
  771, 19, 19,  7,
  771, 23, 11, 11,
  771, 25, 11,  5,
  772, 22, 12, 12,
  772, 24, 14,  0,
  773, 20, 18,  7,
  773, 22, 15,  8,
  773, 22, 17,  0,
  773, 23, 12, 10,
  773, 24, 14,  1,
  773, 25, 12,  2,
  773, 26,  9,  4,
  774, 17, 17, 14,
  774, 18, 15, 15,
  774, 21, 18,  3,
  774, 22, 13, 11,
  774, 22, 17,  1,
  774, 23, 14,  7,
  774, 25, 10,  7,
  774, 26,  7,  7,
  774, 27,  6,  3,
  776, 18, 16, 14,
  776, 22, 16,  6,
  776, 24, 10, 10,
  776, 24, 14,  2,
  776, 26,  8,  6,
  776, 26, 10,  0,
  777, 20, 16, 11,
  777, 20, 19,  4,
  777, 22, 17,  2,
  777, 26, 10,  1,
  778, 21, 16,  9,
  778, 24, 11,  9,
  778, 25, 12,  3,
  778, 27,  7,  0,
  779, 21, 13, 13,
  779, 21, 17,  7,
  779, 23, 13,  9,
  779, 23, 15,  5,
  779, 27,  5,  5,
  779, 27,  7,  1,
  780, 22, 14, 10,
  780, 26, 10,  2,
  781, 21, 14, 12,
  781, 21, 18,  4,
  781, 24, 13,  6,
  781, 24, 14,  3,
  781, 27,  6,  4,
  782, 18, 17, 13,
  782, 19, 15, 14,
  782, 22, 17,  3,
  782, 25, 11,  6,
  782, 26,  9,  5,
  782, 27,  7,  2,
  784, 24, 12,  8,
  784, 28,  0,  0,
  785, 19, 18, 10,
  785, 23, 16,  0,
  785, 25, 12,  4,
  785, 26, 10,  3,
  785, 28,  1,  0,
  786, 19, 16, 13,
  786, 19, 19,  8,
  786, 20, 19,  5,
  786, 23, 16,  1,
  786, 28,  1,  1,
  787, 21, 15, 11,
  787, 25,  9,  9,
  787, 27,  7,  3,
  788, 20, 18,  8,
  788, 24, 14,  4,
  788, 28,  2,  0,
  789, 20, 17, 10,
  789, 22, 16,  7,
  789, 22, 17,  4,
  789, 23, 14,  8,
  789, 23, 16,  2,
  789, 25, 10,  8,
  789, 26,  8,  7,
  789, 28,  2,  1,
  790, 21, 18,  5,
  790, 22, 15,  9,
  790, 23, 15,  6,
  790, 27,  6,  5,
  792, 18, 18, 12,
  792, 20, 14, 14,
  792, 26, 10,  4,
  792, 28,  2,  2,
  793, 26,  9,  6,
  793, 27,  8,  0,
  793, 28,  3,  0,
  794, 19, 17, 12,
  794, 20, 15, 13,
  794, 21, 17,  8,
  794, 23, 12, 11,
  794, 23, 16,  3,
  794, 24, 13,  7,
  794, 25, 12,  5,
  794, 25, 13,  0,
  794, 27,  7,  4,
  794, 27,  8,  1,
  794, 28,  3,  1,
  795, 25, 11,  7,
  795, 25, 13,  1,
  797, 20, 19,  6,
  797, 21, 16, 10,
  797, 22, 13, 12,
  797, 24, 11, 10,
  797, 24, 14,  5,
  797, 26, 11,  0,
  797, 27,  8,  2,
  797, 28,  3,  2,
  798, 22, 17,  5,
  798, 23, 13, 10,
  798, 25, 13,  2,
  798, 26, 11,  1,
  800, 20, 16, 12,
  800, 20, 20,  0,
  800, 28,  4,  0,
  801, 17, 16, 16,
  801, 20, 20,  1,
  801, 21, 18,  6,
  801, 22, 14, 11,
  801, 23, 16,  4,
  801, 24, 12,  9,
  801, 24, 15,  0,
  801, 26, 10,  5,
  801, 26, 11,  2,
  801, 27,  6,  6,
  801, 28,  4,  1,
  802, 21, 19,  0,
  802, 24, 15,  1,
  802, 27,  8,  3,
  802, 28,  3,  3,
  803, 17, 17, 15,
  803, 19, 19,  9,
  803, 21, 19,  1,
  803, 23, 15,  7,
  803, 25, 13,  3,
  803, 27,  7,  5,
  804, 20, 20,  2,
  804, 22, 16,  8,
  804, 26,  8,  8,
  804, 28,  4,  2,
  805, 18, 16, 15,
  805, 20, 18,  9,
  805, 24, 15,  2,
  805, 25, 12,  6,
  806, 19, 18, 11,
  806, 21, 14, 13,
  806, 21, 19,  2,
  806, 23, 14,  9,
  806, 25, 10,  9,
  806, 26,  9,  7,
  806, 26, 11,  3,
  808, 22, 18,  0,
  808, 24, 14,  6,
  809, 18, 17, 14,
  809, 20, 20,  3,
  809, 22, 15, 10,
  809, 22, 17,  6,
  809, 22, 18,  1,
  809, 24, 13,  8,
  809, 27,  8,  4,
  809, 28,  4,  3,
  809, 28,  5,  0,
  810, 20, 17, 11,
  810, 20, 19,  7,
  810, 21, 15, 12,
  810, 23, 16,  5,
  810, 24, 15,  3,
  810, 25, 11,  8,
  810, 25, 13,  4,
  810, 27,  9,  0,
  810, 28,  5,  1,
  811, 19, 15, 15,
  811, 21, 17,  9,
  811, 21, 19,  3,
  811, 27,  9,  1,
  812, 22, 18,  2,
  812, 26, 10,  6,
  813, 19, 16, 14,
  813, 26, 11,  4,
  813, 28,  5,  2,
  814, 21, 18,  7,
  814, 27,  7,  6,
  814, 27,  9,  2,
  816, 20, 20,  4,
  816, 28,  4,  4,
  817, 18, 18, 13,
  817, 22, 18,  3,
  817, 23, 12, 12,
  817, 24, 15,  4,
  818, 21, 16, 11,
  818, 21, 19,  4,
  818, 23, 15,  8,
  818, 23, 17,  0,
  818, 24, 11, 11,
  818, 25, 12,  7,
  818, 27,  8,  5,
  818, 28,  5,  3,
  819, 19, 17, 13,
  819, 23, 13, 11,
  819, 23, 17,  1,
  819, 25, 13,  5,
  819, 27,  9,  3,
  820, 24, 12, 10,
  820, 26, 12,  0,
  820, 28,  6,  0,
  821, 20, 15, 14,
  821, 22, 16,  9,
  821, 23, 16,  6,
  821, 24, 14,  7,
  821, 25, 14,  0,
  821, 26,  9,  8,
  821, 26, 12,  1,
  821, 28,  6,  1,
  822, 19, 19, 10,
  822, 22, 13, 13,
  822, 22, 17,  7,
  822, 23, 17,  2,
  822, 25, 14,  1,
  822, 26, 11,  5,
  824, 20, 18, 10,
  824, 22, 14, 12,
  824, 22, 18,  4,
  824, 26, 12,  2,
  824, 28,  6,  2,
  825, 20, 16, 13,
  825, 20, 19,  8,
  825, 20, 20,  5,
  825, 23, 14, 10,
  825, 25, 10, 10,
  825, 25, 14,  2,
  825, 26, 10,  7,
  825, 28,  5,  4,
  826, 24, 13,  9,
  826, 24, 15,  5,
  826, 27,  9,  4,
  827, 21, 19,  5,
  827, 23, 17,  3,
  827, 25, 11,  9,
  827, 27,  7,  7,
  829, 19, 18, 12,
  829, 21, 18,  8,
  829, 26, 12,  3,
  829, 27,  8,  6,
  829, 27, 10,  0,
  829, 28,  6,  3,
  830, 21, 17, 10,
  830, 22, 15, 11,
  830, 25, 13,  6,
  830, 25, 14,  3,
  830, 27, 10,  1,
  832, 24, 16,  0,
  833, 20, 17, 12,
  833, 21, 14, 14,
  833, 22, 18,  5,
  833, 24, 16,  1,
  833, 25, 12,  8,
  833, 26, 11,  6,
  833, 27, 10,  2,
  833, 28,  7,  0,
  834, 17, 17, 16,
  834, 23, 16,  7,
  834, 23, 17,  4,
  834, 28,  5,  5,
  834, 28,  7,  1,
  835, 21, 15, 13,
  835, 23, 15,  9,
  835, 27,  9,  5,
  836, 18, 16, 16,
  836, 20, 20,  6,
  836, 24, 14,  8,
  836, 24, 16,  2,
  836, 26, 12,  4,
  836, 28,  6,  4,
  837, 22, 17,  8,
  837, 24, 15,  6,
  837, 25, 14,  4,
  837, 28,  7,  2,
  838, 18, 17, 15,
  838, 21, 19,  6,
  838, 26,  9,  9,
  838, 27, 10,  3,
  840, 22, 16, 10,
  840, 26, 10,  8,
  841, 21, 16, 12,
  841, 21, 20,  0,
  841, 24, 12, 11,
  841, 24, 16,  3,
  841, 29,  0,  0,
  842, 19, 16, 15,
  842, 20, 19,  9,
  842, 21, 20,  1,
  842, 23, 13, 12,
  842, 27,  8,  7,
  842, 28,  7,  3,
  842, 29,  1,  0,
  843, 19, 19, 11,
  843, 23, 17,  5,
  843, 25, 13,  7,
  843, 29,  1,  1,
  844, 18, 18, 14,
  844, 22, 18,  6,
  845, 20, 18, 11,
  845, 21, 20,  2,
  845, 22, 19,  0,
  845, 24, 13, 10,
  845, 26, 12,  5,
  845, 26, 13,  0,
  845, 27, 10,  4,
  845, 28,  6,  5,
  845, 29,  2,  0,
  846, 19, 17, 14,
  846, 21, 18,  9,
  846, 22, 19,  1,
  846, 23, 14, 11,
  846, 25, 11, 10,
  846, 25, 14,  5,
  846, 26, 11,  7,
  846, 26, 13,  1,
  846, 27,  9,  6,
  846, 29,  2,  1,
  848, 24, 16,  4,
  848, 28,  8,  0,
  849, 20, 20,  7,
  849, 22, 14, 13,
  849, 22, 19,  2,
  849, 23, 16,  8,
  849, 26, 13,  2,
  849, 28,  7,  4,
  849, 28,  8,  1,
  849, 29,  2,  2,
  850, 20, 15, 15,
  850, 21, 20,  3,
  850, 24, 15,  7,
  850, 25, 12,  9,
  850, 25, 15,  0,
  850, 27, 11,  0,
  850, 29,  3,  0,
  851, 21, 17, 11,
  851, 21, 19,  7,
  851, 25, 15,  1,
  851, 27, 11,  1,
  851, 29,  3,  1,
  852, 20, 16, 14,
  852, 28,  8,  2,
  853, 22, 15, 12,
  853, 23, 18,  0,
  853, 24, 14,  9,
  854, 19, 18, 13,
  854, 22, 17,  9,
  854, 22, 19,  3,
  854, 23, 15, 10,
  854, 23, 17,  6,
  854, 23, 18,  1,
  854, 25, 15,  2,
  854, 26, 13,  3,
  854, 27, 10,  5,
  854, 27, 11,  2,
  854, 29,  3,  2,
  856, 26, 12,  6,
  856, 28,  6,  6,
  857, 21, 20,  4,
  857, 22, 18,  7,
  857, 23, 18,  2,
  857, 24, 16,  5,
  857, 25, 14,  6,
  857, 26, 10,  9,
  857, 27,  8,  8,
  857, 28,  8,  3,
  857, 29,  4,  0,
  858, 20, 17, 13,
  858, 25, 13,  8,
  858, 28,  7,  5,
  858, 29,  4,  1,
  859, 25, 15,  3,
  859, 27,  9,  7,
  859, 27, 11,  3,
  859, 29,  3,  3,
  861, 20, 19, 10,
  861, 22, 16, 11,
  861, 22, 19,  4,
  861, 26, 11,  8,
  861, 26, 13,  4,
  861, 29,  4,  2,
  862, 21, 15, 14,
  862, 23, 18,  3,
  864, 20, 20,  8,
  864, 24, 12, 12,
  864, 28,  8,  4,
  865, 21, 18, 10,
  865, 24, 15,  8,
  865, 24, 17,  0,
  865, 27, 10,  6,
  865, 28,  9,  0,
  866, 19, 19, 12,
  866, 21, 16, 13,
  866, 21, 19,  8,
  866, 21, 20,  5,
  866, 23, 16,  9,
  866, 24, 13, 11,
  866, 24, 17,  1,
  866, 25, 15,  4,
  866, 27, 11,  4,
  866, 28,  9,  1,
  866, 29,  4,  3,
  866, 29,  5,  0,
  867, 17, 17, 17,
  867, 23, 13, 13,
  867, 23, 17,  7,
  867, 25, 11, 11,
  867, 29,  5,  1,
  868, 20, 18, 12,
  868, 24, 16,  6,
  869, 18, 17, 16,
  869, 23, 14, 12,
  869, 23, 18,  4,
  869, 24, 17,  2,
  869, 25, 12, 10,
  869, 26, 12,  7,
  869, 28,  7,  6,
  869, 28,  9,  2,
  870, 22, 19,  5,
  870, 25, 14,  7,
  870, 26, 13,  5,
  870, 29,  5,  2,
  872, 22, 18,  8,
  872, 24, 14, 10,
  872, 26, 14,  0,
  873, 18, 18, 15,
  873, 19, 16, 16,
  873, 22, 17, 10,
  873, 26, 14,  1,
  873, 27, 12,  0,
  873, 28,  8,  5,
  873, 29,  4,  4,
  874, 21, 17, 12,
  874, 24, 17,  3,
  874, 27,  9,  8,
  874, 27, 12,  1,
  874, 28,  9,  3,
  875, 19, 17, 15,
  875, 23, 15, 11,
  875, 25, 13,  9,
  875, 25, 15,  5,
  875, 27, 11,  5,
  875, 29,  5,  3,
  876, 22, 14, 14,
  876, 26, 10, 10,
  876, 26, 14,  2,
  877, 21, 20,  6,
  877, 27, 12,  2,
  877, 29,  6,  0,
  878, 22, 15, 13,
  878, 23, 18,  5,
  878, 26, 11,  9,
  878, 27, 10,  7,
  878, 29,  6,  1,
  881, 19, 18, 14,
  881, 20, 16, 15,
  881, 20, 20,  9,
  881, 22, 19,  6,
  881, 24, 16,  7,
  881, 24, 17,  4,
  881, 25, 16,  0,
  881, 26, 13,  6,
  881, 26, 14,  3,
  881, 28,  9,  4,
  881, 29,  6,  2,
  882, 20, 19, 11,
  882, 21, 21,  0,
  882, 23, 17,  8,
  882, 24, 15,  9,
  882, 25, 16,  1,
  882, 27, 12,  3,
  882, 28,  7,  7,
  882, 29,  5,  4,
  883, 21, 19,  9,
  883, 21, 21,  1,
  884, 22, 16, 12,
  884, 22, 20,  0,
  884, 26, 12,  8,
  884, 28,  8,  6,
  884, 28, 10,  0,
  885, 20, 17, 14,
  885, 22, 20,  1,
  885, 23, 16, 10,
  885, 25, 14,  8,
  885, 25, 16,  2,
  885, 28, 10,  1,
  886, 21, 18, 11,
  886, 21, 21,  2,
  886, 25, 15,  6,
  886, 27, 11,  6,
  886, 29,  6,  3,
  888, 22, 20,  2,
  888, 26, 14,  4,
  888, 28, 10,  2,
  889, 22, 18,  9,
  889, 23, 18,  6,
  889, 24, 13, 12,
  889, 27, 12,  4,
  890, 21, 20,  7,
  890, 23, 19,  0,
  890, 24, 17,  5,
  890, 25, 12, 11,
  890, 25, 16,  3,
  890, 28,  9,  5,
  890, 29,  7,  0,
  891, 19, 19, 13,
  891, 21, 15, 15,
  891, 21, 21,  3,
  891, 23, 19,  1,
  891, 27,  9,  9,
  891, 29,  5,  5,
  891, 29,  7,  1,
  893, 20, 18, 13,
  893, 21, 16, 14,
  893, 22, 20,  3,
  893, 24, 14, 11,
  893, 27, 10,  8,
  893, 28, 10,  3,
  893, 29,  6,  4,
  894, 22, 17, 11,
  894, 22, 19,  7,
  894, 23, 14, 13,
  894, 23, 19,  2,
  894, 25, 13, 10,
  894, 26, 13,  7,
  894, 29,  7,  2,
  896, 24, 16,  8,
  897, 25, 16,  4,
  897, 26, 11, 10,
  897, 26, 14,  5,
  897, 28,  8,  7,
  898, 21, 21,  4,
  898, 23, 15, 12,
  898, 27, 12,  5,
  898, 27, 13,  0,
  899, 21, 17, 13,
  899, 23, 17,  9,
  899, 23, 19,  3,
  899, 25, 15,  7,
  899, 27, 11,  7,
  899, 27, 13,  1,
  899, 29,  7,  3,
  900, 20, 20, 10,
  900, 22, 20,  4,
  900, 24, 18,  0,
  900, 28, 10,  4,
  900, 30,  0,  0,
  901, 24, 15, 10,
  901, 24, 17,  6,
  901, 24, 18,  1,
  901, 26, 12,  9,
  901, 26, 15,  0,
  901, 28,  9,  6,
  901, 30,  1,  0,
  902, 18, 17, 17,
  902, 21, 19, 10,
  902, 23, 18,  7,
  902, 25, 14,  9,
  902, 26, 15,  1,
  902, 27, 13,  2,
  902, 29,  6,  5,
  902, 30,  1,  1,
  904, 18, 18, 16,
  904, 24, 18,  2,
  904, 30,  2,  0,
  905, 20, 19, 12,
  905, 21, 20,  8,
  905, 22, 15, 14,
  905, 26, 15,  2,
  905, 28, 11,  0,
  905, 29,  8,  0,
  905, 30,  2,  1,
  906, 19, 17, 16,
  906, 23, 16, 11,
  906, 23, 19,  4,
  906, 25, 16,  5,
  906, 28, 11,  1,
  906, 29,  7,  4,
  906, 29,  8,  1,
  907, 21, 21,  5,
  907, 27, 13,  3,
  908, 22, 18, 10,
  908, 26, 14,  6,
  908, 30,  2,  2,
  909, 21, 18, 12,
  909, 22, 16, 13,
  909, 22, 19,  8,
  909, 22, 20,  5,
  909, 24, 18,  3,
  909, 26, 13,  8,
  909, 27, 12,  6,
  909, 28, 10,  5,
  909, 28, 11,  2,
  909, 29,  8,  2,
  909, 30,  3,  0,
  910, 19, 18, 15,
  910, 26, 15,  3,
  910, 27, 10,  9,
  910, 30,  3,  1,
  912, 20, 16, 16,
  912, 28,  8,  8,
  913, 24, 16,  9,
  913, 25, 12, 12,
  913, 29,  6,  6,
  913, 30,  3,  2,
  914, 20, 17, 15,
  914, 24, 13, 13,
  914, 24, 17,  7,
  914, 25, 15,  8,
  914, 25, 17,  0,
  914, 27, 11,  8,
  914, 27, 13,  4,
  914, 28,  9,  7,
  914, 28, 11,  3,
  914, 29,  8,  3,
  915, 23, 19,  5,
  915, 25, 13, 11,
  915, 25, 17,  1,
  915, 29,  7,  5,
  916, 24, 14, 12,
  916, 24, 18,  4,
  916, 30,  4,  0,
  917, 22, 17, 12,
  917, 23, 18,  8,
  917, 25, 16,  6,
  917, 26, 15,  4,
  917, 30,  4,  1,
  918, 19, 19, 14,
  918, 21, 21,  6,
  918, 23, 17, 10,
  918, 25, 17,  2,
  918, 26, 11, 11,
  918, 30,  3,  3,
  920, 20, 18, 14,
  920, 22, 20,  6,
  920, 26, 12, 10,
  920, 28, 10,  6,
  920, 30,  4,  2,
  921, 20, 20, 11,
  921, 23, 14, 14,
  921, 25, 14, 10,
  921, 26, 14,  7,
  921, 28, 11,  4,
  921, 29,  8,  4,
  922, 21, 16, 15,
  922, 21, 20,  9,
  922, 24, 15, 11,
  922, 27, 12,  7,
  922, 29,  9,  0,
  923, 21, 19, 11,
  923, 23, 15, 13,
  923, 25, 17,  3,
  923, 27, 13,  5,
  923, 29,  9,  1,
  925, 22, 21,  0,
  925, 24, 18,  5,
  925, 27, 14,  0,
  925, 30,  4,  3,
  925, 30,  5,  0,
  926, 21, 17, 14,
  926, 22, 19,  9,
  926, 22, 21,  1,
  926, 23, 19,  6,
  926, 26, 13,  9,
  926, 26, 15,  5,
  926, 27, 14,  1,
  926, 29,  7,  6,
  926, 29,  9,  2,
  926, 30,  5,  1,
  928, 28, 12,  0,
  929, 22, 18, 11,
  929, 22, 21,  2,
  929, 23, 16, 12,
  929, 23, 20,  0,
  929, 24, 17,  8,
  929, 27, 10, 10,
  929, 27, 14,  2,
  929, 28,  9,  8,
  929, 28, 12,  1,
  929, 30,  5,  2,
  930, 20, 19, 13,
  930, 23, 20,  1,
  930, 25, 16,  7,
  930, 25, 17,  4,
  930, 28, 11,  5,
  930, 29,  8,  5,
  931, 21, 21,  7,
  931, 25, 15,  9,
  931, 27, 11,  9,
  931, 29,  9,  3,
  932, 24, 16, 10,
  932, 26, 16,  0,
  932, 28, 12,  2,
  932, 30,  4,  4,
  933, 22, 20,  7,
  933, 23, 20,  2,
  933, 26, 16,  1,
  933, 28, 10,  7,
  934, 21, 18, 13,
  934, 22, 15, 15,
  934, 22, 21,  3,
  934, 23, 18,  9,
  934, 27, 13,  6,
  934, 27, 14,  3,
  934, 30,  5,  3,
  936, 22, 16, 14,
  936, 24, 18,  6,
  936, 26, 14,  8,
  936, 26, 16,  2,
  936, 30,  6,  0,
  937, 18, 18, 17,
  937, 24, 19,  0,
  937, 26, 15,  6,
  937, 27, 12,  8,
  937, 28, 12,  3,
  937, 30,  6,  1,
  938, 23, 20,  3,
  938, 24, 19,  1,
  938, 25, 13, 12,
  938, 29,  9,  4,
  939, 19, 17, 17,
  939, 23, 17, 11,
  939, 23, 19,  7,
  939, 25, 17,  5,
  939, 29,  7,  7,
  940, 30,  6,  2,
  941, 19, 18, 16,
  941, 21, 20, 10,
  941, 22, 21,  4,
  941, 24, 14, 13,
  941, 24, 19,  2,
  941, 26, 12, 11,
  941, 26, 16,  3,
  941, 27, 14,  4,
  941, 28, 11,  6,
  941, 29,  8,  6,
  941, 29, 10,  0,
  941, 30,  5,  4,
  942, 22, 17, 13,
  942, 25, 14, 11,
  942, 29, 10,  1,
  944, 20, 20, 12,
  944, 28, 12,  4,
  945, 20, 17, 16,
  945, 22, 19, 10,
  945, 23, 20,  4,
  945, 24, 15, 12,
  945, 25, 16,  8,
  945, 26, 13, 10,
  945, 29, 10,  2,
  945, 30,  6,  3,
  946, 21, 19, 12,
  946, 21, 21,  8,
  946, 24, 17,  9,
  946, 24, 19,  3,
  946, 28,  9,  9,
  947, 19, 19, 15,
  947, 27, 13,  7,
  947, 29,  9,  5,
  948, 22, 20,  8,
  948, 26, 16,  4,
  948, 28, 10,  8,
  949, 20, 18, 15,
  949, 24, 18,  7,
  949, 25, 18,  0,
  949, 30,  7,  0,
  950, 22, 21,  5,
  950, 23, 15, 14,
  950, 25, 15, 10,
  950, 25, 17,  6,
  950, 25, 18,  1,
  950, 26, 15,  7,
  950, 27, 11, 10,
  950, 27, 14,  5,
  950, 29, 10,  3,
  950, 30,  5,  5,
  950, 30,  7,  1,
  952, 22, 18, 12,
  952, 30,  6,  4,
  953, 21, 16, 16,
  953, 23, 18, 10,
  953, 24, 16, 11,
  953, 24, 19,  4,
  953, 25, 18,  2,
  953, 26, 14,  9,
  953, 28, 12,  5,
  953, 28, 13,  0,
  953, 30,  7,  2,
  954, 23, 16, 13,
  954, 23, 19,  8,
  954, 23, 20,  5,
  954, 27, 12,  9,
  954, 27, 15,  0,
  954, 28, 11,  7,
  954, 28, 13,  1,
  954, 29,  8,  7,
  955, 21, 17, 15,
  955, 27, 15,  1,
  957, 20, 19, 14,
  957, 26, 16,  5,
  957, 28, 13,  2,
  957, 29, 10,  4,
  958, 25, 18,  3,
  958, 27, 15,  2,
  958, 29,  9,  6,
  958, 30,  7,  3,
  961, 21, 18, 14,
  961, 22, 21,  6,
  961, 27, 14,  6,
  961, 30,  6,  5,
  961, 31,  0,  0,
  962, 21, 20, 11,
  962, 23, 17, 12,
  962, 24, 19,  5,
  962, 25, 16,  9,
  962, 27, 13,  8,
  962, 28, 13,  3,
  962, 29, 11,  0,
  962, 31,  1,  0,
  963, 21, 21,  9,
  963, 25, 13, 13,
  963, 25, 17,  7,
  963, 27, 15,  3,
  963, 29, 11,  1,
  963, 31,  1,  1,
  964, 24, 18,  8,
  964, 26, 12, 12,
  964, 28, 12,  6,
  964, 30,  8,  0,
  965, 22, 16, 15,
  965, 22, 20,  9,
  965, 23, 20,  6,
  965, 24, 17, 10,
  965, 25, 14, 12,
  965, 25, 18,  4,
  965, 26, 15,  8,
  965, 26, 17,  0,
  965, 28, 10,  9,
  965, 30,  7,  4,
  965, 30,  8,  1,
  965, 31,  2,  0,
  966, 22, 19, 11,
  966, 26, 13, 11,
  966, 26, 17,  1,
  966, 29, 10,  5,
  966, 29, 11,  2,
  966, 31,  2,  1,
  968, 22, 22,  0,
  968, 24, 14, 14,
  968, 26, 16,  6,
  968, 30,  8,  2,
  969, 20, 20, 13,
  969, 22, 17, 14,
  969, 22, 22,  1,
  969, 26, 17,  2,
  969, 28, 11,  8,
  969, 28, 13,  4,
  969, 29,  8,  8,
  969, 31,  2,  2,
  970, 23, 21,  0,
  970, 24, 15, 13,
  970, 27, 15,  4,
  970, 31,  3,  0,
  971, 21, 19, 13,
  971, 23, 19,  9,
  971, 23, 21,  1,
  971, 25, 15, 11,
  971, 27, 11, 11,
  971, 29,  9,  7,
  971, 29, 11,  3,
  971, 31,  3,  1,
  972, 18, 18, 18,
  972, 22, 22,  2,
  972, 26, 14, 10,
  972, 30,  6,  6,
  973, 24, 19,  6,
  973, 27, 12, 10,
  973, 30,  8,  3,
  974, 19, 18, 17,
  974, 22, 21,  7,
  974, 23, 18, 11,
  974, 23, 21,  2,
  974, 25, 18,  5,
  974, 26, 17,  3,
  974, 27, 14,  7,
  974, 30,  7,  5,
  974, 31,  3,  2,
  976, 24, 16, 12,
  976, 24, 20,  0,
  977, 22, 18, 13,
  977, 22, 22,  3,
  977, 24, 20,  1,
  977, 28, 12,  7,
  977, 29, 10,  6,
  977, 31,  4,  0,
  978, 19, 19, 16,
  978, 20, 17, 17,
  978, 23, 20,  7,
  978, 25, 17,  8,
  978, 28, 13,  5,
  978, 29, 11,  4,
  978, 31,  4,  1,
  979, 23, 15, 15,
  979, 23, 21,  3,
  979, 27, 13,  9,
  979, 27, 15,  5,
  979, 31,  3,  3,
  980, 20, 18, 16,
  980, 24, 20,  2,
  980, 28, 14,  0,
  980, 30,  8,  4,
  981, 23, 16, 14,
  981, 24, 18,  9,
  981, 25, 16, 10,
  981, 26, 16,  7,
  981, 26, 17,  4,
  981, 28, 14,  1,
  981, 30,  9,  0,
  981, 31,  4,  2,
  982, 21, 21, 10,
  982, 26, 15,  9,
  982, 30,  9,  1,
  984, 22, 20, 10,
  984, 22, 22,  4,
  984, 28, 10, 10,
  984, 28, 14,  2,
  985, 21, 20, 12,
  985, 24, 20,  3,
  985, 25, 18,  6,
  985, 27, 16,  0,
  985, 29, 12,  0,
  985, 30,  7,  6,
  985, 30,  9,  2,
  986, 20, 19, 15,
  986, 21, 17, 16,
  986, 23, 21,  4,
  986, 24, 17, 11,
  986, 24, 19,  7,
  986, 25, 19,  0,
  986, 27, 16,  1,
  986, 28, 11,  9,
  986, 29,  9,  8,
  986, 29, 12,  1,
  986, 31,  4,  3,
  986, 31,  5,  0,
  987, 23, 17, 13,
  987, 25, 19,  1,
  987, 29, 11,  5,
  987, 31,  5,  1,
  989, 22, 19, 12,
  989, 22, 21,  8,
  989, 26, 13, 12,
  989, 27, 14,  8,
  989, 27, 16,  2,
  989, 28, 13,  6,
  989, 28, 14,  3,
  989, 29, 12,  2,
  989, 30,  8,  5,
  990, 21, 18, 15,
  990, 23, 19, 10,
  990, 25, 14, 13,
  990, 25, 19,  2,
  990, 26, 17,  5,
  990, 27, 15,  6,
  990, 29, 10,  7,
  990, 30,  9,  3,
  990, 31,  5,  2,
  992, 24, 20,  4,
  992, 28, 12,  8,
  993, 22, 22,  5,
  993, 23, 20,  8,
  993, 26, 14, 11,
  993, 31,  4,  4,
  994, 25, 15, 12,
  994, 27, 12, 11,
  994, 27, 16,  3,
  994, 29, 12,  3,
  995, 23, 21,  5,
  995, 25, 17,  9,
  995, 25, 19,  3,
  995, 31,  5,  3,
  996, 20, 20, 14,
  996, 22, 16, 16,
  996, 26, 16,  8,
  996, 28, 14,  4,
  997, 23, 18, 12,
  997, 24, 15, 14,
  997, 30,  9,  4,
  997, 31,  6,  0,
  998, 21, 19, 14,
  998, 22, 17, 15,
  998, 25, 18,  7,
  998, 27, 13, 10,
  998, 29, 11,  6,
  998, 30,  7,  7,
  998, 31,  6,  1,
 1000, 24, 18, 10,
 1000, 26, 18,  0,
 1000, 30,  8,  6,
 1000, 30, 10,  0,
 1001, 24, 16, 13,
 1001, 24, 19,  8,
 1001, 24, 20,  5,
 1001, 26, 15, 10,
 1001, 26, 17,  6,
 1001, 26, 18,  1,
 1001, 27, 16,  4,
 1001, 29, 12,  4,
 1001, 30, 10,  1,
 1001, 31,  6,  2,
 1002, 25, 16, 11,
 1002, 25, 19,  4,
 1002, 28, 13,  7,
 1002, 31,  5,  4,
 1003, 21, 21, 11,
 1003, 27, 15,  7,
 1003, 29,  9,  9,
 1004, 22, 18, 14,
 1004, 22, 22,  6,
 1004, 26, 18,  2,
 1004, 30, 10,  2,
 1005, 22, 20, 11,
 1005, 28, 11, 10,
 1005, 28, 14,  5,
 1005, 29, 10,  8,
 1006, 22, 21,  9,
 1006, 23, 21,  6,
 1006, 27, 14,  9,
 1006, 30,  9,  5,
 1006, 31,  6,  3,
 1009, 19, 18, 18,
 1009, 24, 17, 12,
 1009, 26, 18,  3,
 1009, 28, 12,  9,
 1009, 28, 15,  0,
 1009, 30, 10,  3,
 1010, 21, 20, 13,
 1010, 23, 16, 15,
 1010, 23, 20,  9,
 1010, 27, 16,  5,
 1010, 28, 15,  1,
 1010, 29, 12,  5,
 1010, 29, 13,  0,
 1010, 31,  7,  0,
 1011, 19, 19, 17,
 1011, 23, 19, 11,
 1011, 25, 19,  5,
 1011, 29, 11,  7,
 1011, 29, 13,  1,
 1011, 31,  5,  5,
 1011, 31,  7,  1,
 1012, 24, 20,  6,
 1013, 20, 18, 17,
 1013, 23, 22,  0,
 1013, 25, 18,  8,
 1013, 26, 16,  9,
 1013, 28, 15,  2,
 1013, 30,  8,  7,
 1013, 31,  6,  4,
 1014, 22, 19, 13,
 1014, 23, 17, 14,
 1014, 23, 22,  1,
 1014, 25, 17, 10,
 1014, 26, 13, 13,
 1014, 26, 17,  7,
 1014, 29, 13,  2,
 1014, 31,  7,  2,
 1016, 26, 14, 12,
 1016, 26, 18,  4,
 1016, 28, 14,  6,
 1016, 30, 10,  4,
 1017, 20, 19, 16,
 1017, 22, 22,  7,
 1017, 23, 22,  2,
 1017, 24, 21,  0,
 1017, 25, 14, 14,
 1017, 27, 12, 12,
 1017, 28, 13,  8,
 1017, 30,  9,  6,
 1018, 24, 19,  9,
 1018, 24, 21,  1,
 1018, 27, 15,  8,
 1018, 27, 17,  0,
 1018, 28, 15,  3,
 1019, 21, 17, 17,
 1019, 23, 21,  7,
 1019, 25, 15, 13,
 1019, 27, 13, 11,
 1019, 27, 17,  1,
 1019, 29, 13,  3,
 1019, 31,  7,  3,
 1021, 21, 18, 16,
 1021, 24, 18, 11,
 1021, 24, 21,  2,
 1021, 27, 16,  6,
 1021, 29, 12,  6,
 1021, 30, 11,  0,
 1022, 23, 18, 13,
 1022, 23, 22,  3,
 1022, 25, 19,  6,
 1022, 26, 15, 11,
 1022, 27, 17,  2,
 1022, 29, 10,  9,
 1022, 30, 11,  1,
 1022, 31,  6,  5,
 1024, 32,  0,  0,
 1025, 20, 20, 15,
 1025, 22, 21, 10,
 1025, 24, 20,  7,
 1025, 25, 16, 12,
 1025, 25, 20,  0,
 1025, 26, 18,  5,
 1025, 27, 14, 10,
 1025, 28, 15,  4,
 1025, 30, 10,  5,
 1025, 30, 11,  2,
 1025, 31,  8,  0,
 1025, 32,  1,  0,
 1026, 21, 21, 12,
 1026, 24, 15, 15,
 1026, 24, 21,  3,
 1026, 25, 20,  1,
 1026, 28, 11, 11,
 1026, 29, 11,  8,
 1026, 29, 13,  4,
 1026, 31,  7,  4,
 1026, 31,  8,  1,
 1026, 32,  1,  1,
 1027, 21, 19, 15,
 1027, 27, 17,  3,
 1028, 22, 20, 12,
 1028, 24, 16, 14,
 1028, 28, 12, 10,
 1028, 30,  8,  8,
 1028, 32,  2,  0,
 1029, 22, 17, 16,
 1029, 23, 20, 10,
 1029, 23, 22,  4,
 1029, 25, 20,  2,
 1029, 26, 17,  8,
 1029, 28, 14,  7,
 1029, 31,  8,  2,
 1029, 32,  2,  1,
 1030, 25, 18,  9,
 1030, 30,  9,  7,
 1030, 30, 11,  3,
 1032, 22, 22,  8,
 1032, 26, 16, 10,
 1032, 32,  2,  2,
 1033, 22, 18, 15,
 1033, 24, 21,  4,
 1033, 31,  6,  6,
 1033, 32,  3,  0,
 1034, 23, 19, 12,
 1034, 23, 21,  8,
 1034, 24, 17, 13,
 1034, 25, 20,  3,
 1034, 27, 16,  7,
 1034, 27, 17,  4,
 1034, 28, 13,  9,
 1034, 28, 15,  5,
 1034, 29, 12,  7,
 1034, 31,  8,  3,
 1034, 32,  3,  1,
 1035, 25, 17, 11,
 1035, 25, 19,  7,
 1035, 27, 15,  9,
 1035, 29, 13,  5,
 1035, 31,  7,  5,
 1036, 26, 18,  6,
 1036, 30, 10,  6,
 1037, 21, 20, 14,
 1037, 24, 19, 10,
 1037, 26, 19,  0,
 1037, 29, 14,  0,
 1037, 30, 11,  4,
 1037, 32,  3,  2,
 1038, 23, 22,  5,
 1038, 26, 19,  1,
 1038, 29, 14,  1,
 1040, 24, 20,  8,
 1040, 28, 16,  0,
 1040, 32,  4,  0,
 1041, 22, 19, 14,
 1041, 23, 16, 16,
 1041, 25, 20,  4,
 1041, 26, 14, 13,
 1041, 26, 19,  2,
 1041, 28, 16,  1,
 1041, 29, 10, 10,
 1041, 29, 14,  2,
 1041, 31,  8,  4,
 1041, 32,  4,  1,
 1042, 24, 21,  5,
 1042, 27, 13, 12,
 1042, 31,  9,  0,
 1042, 32,  3,  3,
 1043, 23, 17, 15,
 1043, 27, 17,  5,
 1043, 29, 11,  9,
 1043, 31,  9,  1,
 1044, 24, 18, 12,
 1044, 28, 14,  8,
 1044, 28, 16,  2,
 1044, 30, 12,  0,
 1044, 32,  4,  2,
 1045, 26, 15, 12,
 1045, 28, 15,  6,
 1045, 30,  9,  8,
 1045, 30, 12,  1,
 1046, 19, 19, 18,
 1046, 22, 21, 11,
 1046, 25, 15, 14,
 1046, 26, 17,  9,
 1046, 26, 19,  3,
 1046, 27, 14, 11,
 1046, 29, 13,  6,
 1046, 29, 14,  3,
 1046, 30, 11,  5,
 1046, 31,  7,  6,
 1046, 31,  9,  2,
 1048, 20, 18, 18,
 1048, 30, 12,  2,
 1049, 22, 22,  9,
 1049, 23, 18, 14,
 1049, 23, 22,  6,
 1049, 25, 18, 10,
 1049, 26, 18,  7,
 1049, 27, 16,  8,
 1049, 28, 12, 11,
 1049, 28, 16,  3,
 1049, 29, 12,  8,
 1049, 30, 10,  7,
 1049, 32,  4,  3,
 1049, 32,  5,  0,
 1050, 20, 19, 17,
 1050, 23, 20, 11,
 1050, 25, 16, 13,
 1050, 25, 19,  8,
 1050, 25, 20,  5,
 1050, 31,  8,  5,
 1050, 32,  5,  1,
 1051, 21, 21, 13,
 1051, 23, 21,  9,
 1051, 31,  9,  3,
 1053, 22, 20, 13,
 1053, 24, 21,  6,
 1053, 26, 16, 11,
 1053, 26, 19,  4,
 1053, 27, 18,  0,
 1053, 28, 13, 10,
 1053, 29, 14,  4,
 1053, 30, 12,  3,
 1053, 32,  5,  2,
 1054, 21, 18, 17,
 1054, 27, 15, 10,
 1054, 27, 17,  6,
 1054, 27, 18,  1,
 1056, 20, 20, 16,
 1056, 28, 16,  4,
 1056, 32,  4,  4,
 1057, 24, 16, 15,
 1057, 24, 20,  9,
 1057, 27, 18,  2,
 1057, 30, 11,  6,
 1058, 21, 19, 16,
 1058, 23, 23,  0,
 1058, 24, 19, 11,
 1058, 25, 17, 12,
 1058, 28, 15,  7,
 1058, 31,  9,  4,
 1058, 32,  5,  3,
 1059, 23, 19, 13,
 1059, 23, 23,  1,
 1059, 29, 13,  7,
 1059, 31,  7,  7,
 1060, 24, 22,  0,
 1060, 30, 12,  4,
 1060, 32,  6,  0,
 1061, 24, 17, 14,
 1061, 24, 22,  1,
 1061, 25, 20,  6,
 1061, 28, 14,  9,
 1061, 31,  8,  6,
 1061, 31, 10,  0,
 1061, 32,  6,  1,
 1062, 22, 17, 17,
 1062, 23, 22,  7,
 1062, 23, 23,  2,
 1062, 26, 19,  5,
 1062, 27, 18,  3,
 1062, 29, 11, 10,
 1062, 29, 14,  5,
 1062, 30,  9,  9,
 1062, 31, 10,  1,
 1064, 22, 18, 16,
 1064, 24, 22,  2,
 1064, 26, 18,  8,
 1064, 30, 10,  8,
 1064, 32,  6,  2,
 1065, 26, 17, 10,
 1065, 28, 16,  5,
 1065, 31, 10,  2,
 1065, 32,  5,  4,
 1066, 21, 20, 15,
 1066, 24, 21,  7,
 1066, 25, 21,  0,
 1066, 27, 16,  9,
 1066, 29, 12,  9,
 1066, 29, 15,  0,
 1067, 23, 23,  3,
 1067, 25, 19,  9,
 1067, 25, 21,  1,
 1067, 27, 13, 13,
 1067, 27, 17,  7,
 1067, 29, 15,  1,
 1067, 31,  9,  5,
 1068, 22, 22, 10,
 1068, 26, 14, 14,
 1069, 22, 21, 12,
 1069, 24, 18, 13,
 1069, 24, 22,  3,
 1069, 27, 14, 12,
 1069, 27, 18,  4,
 1069, 30, 12,  5,
 1069, 30, 13,  0,
 1069, 32,  6,  3,
 1070, 22, 19, 15,
 1070, 23, 21, 10,
 1070, 25, 18, 11,
 1070, 25, 21,  2,
 1070, 26, 15, 13,
 1070, 29, 15,  2,
 1070, 30, 11,  7,
 1070, 30, 13,  1,
 1070, 31, 10,  3,
 1072, 28, 12, 12,
 1073, 23, 20, 12,
 1073, 26, 19,  6,
 1073, 28, 15,  8,
 1073, 28, 17,  0,
 1073, 29, 14,  6,
 1073, 30, 13,  2,
 1073, 32,  7,  0,
 1074, 23, 17, 16,
 1074, 23, 23,  4,
 1074, 25, 20,  7,
 1074, 28, 13, 11,
 1074, 28, 17,  1,
 1074, 29, 13,  8,
 1074, 31,  8,  7,
 1074, 32,  5,  5,
 1074, 32,  7,  1,
 1075, 25, 15, 15,
 1075, 25, 21,  3,
 1075, 27, 15, 11,
 1075, 29, 15,  3,
 1076, 24, 20, 10,
 1076, 24, 22,  4,
 1076, 26, 16, 12,
 1076, 26, 20,  0,
 1076, 28, 16,  6,
 1076, 32,  6,  4,
 1077, 23, 22,  8,
 1077, 25, 16, 14,
 1077, 26, 20,  1,
 1077, 28, 17,  2,
 1077, 31, 10,  4,
 1077, 32,  7,  2,
 1078, 21, 21, 14,
 1078, 23, 18, 15,
 1078, 27, 18,  5,
 1078, 30, 13,  3,
 1078, 31,  9,  6,
 1080, 22, 20, 14,
 1080, 26, 20,  2,
 1080, 28, 14, 10,
 1080, 30, 12,  6,
 1081, 24, 19, 12,
 1081, 24, 21,  8,
 1081, 26, 18,  9,
 1081, 30, 10,  9,
 1082, 25, 21,  4,
 1082, 27, 17,  8,
 1082, 28, 17,  3,
 1082, 29, 15,  4,
 1082, 31, 11,  0,
 1082, 32,  7,  3,
 1083, 19, 19, 19,
 1083, 23, 23,  5,
 1083, 25, 17, 13,
 1083, 29, 11, 11,
 1083, 31, 11,  1,
 1085, 20, 19, 18,
 1085, 24, 22,  5,
 1085, 26, 20,  3,
 1085, 27, 16, 10,
 1085, 29, 12, 10,
 1085, 30, 11,  8,
 1085, 30, 13,  4,
 1085, 32,  6,  5,
 1086, 23, 19, 14,
 1086, 25, 19, 10,
 1086, 26, 17, 11,
 1086, 26, 19,  7,
 1086, 29, 14,  7,
 1086, 31, 10,  5,
 1086, 31, 11,  2,
 1088, 24, 16, 16,
 1088, 32,  8,  0,
 1089, 20, 20, 17,
 1089, 21, 18, 18,
 1089, 22, 22, 11,
 1089, 25, 20,  8,
 1089, 27, 18,  6,
 1089, 28, 16,  7,
 1089, 28, 17,  4,
 1089, 31,  8,  8,
 1089, 32,  7,  4,
 1089, 32,  8,  1,
 1089, 33,  0,  0,
 1090, 24, 17, 15,
 1090, 27, 19,  0,
 1090, 28, 15,  9,
 1090, 33,  1,  0,
 1091, 21, 19, 17,
 1091, 23, 21, 11,
 1091, 25, 21,  5,
 1091, 27, 19,  1,
 1091, 29, 13,  9,
 1091, 29, 15,  5,
 1091, 31,  9,  7,
 1091, 31, 11,  3,
 1091, 33,  1,  1,
 1092, 26, 20,  4,
 1092, 32,  8,  2,
 1093, 25, 18, 12,
 1093, 30, 12,  7,
 1093, 33,  2,  0,
 1094, 22, 21, 13,
 1094, 23, 22,  9,
 1094, 23, 23,  6,
 1094, 27, 14, 13,
 1094, 27, 19,  2,
 1094, 30, 13,  5,
 1094, 33,  2,  1,
 1096, 24, 18, 14,
 1096, 24, 22,  6,
 1096, 30, 14,  0,
 1096, 32,  6,  6,
 1097, 21, 20, 16,
 1097, 22, 18, 17,
 1097, 24, 20, 11,
 1097, 26, 15, 14,
 1097, 28, 13, 12,
 1097, 29, 16,  0,
 1097, 30, 14,  1,
 1097, 31, 10,  6,
 1097, 32,  8,  3,
 1097, 33,  2,  2,
 1098, 23, 20, 13,
 1098, 24, 21,  9,
 1098, 27, 15, 12,
 1098, 28, 17,  5,
 1098, 29, 16,  1,
 1098, 31, 11,  4,
 1098, 32,  7,  5,
 1098, 33,  3,  0,
 1099, 27, 17,  9,
 1099, 27, 19,  3,
 1099, 33,  3,  1,
 1100, 26, 18, 10,
 1100, 30, 10, 10,
 1100, 30, 14,  2,
 1101, 22, 19, 16,
 1101, 26, 16, 13,
 1101, 26, 19,  8,
 1101, 26, 20,  5,
 1101, 28, 14, 11,
 1101, 29, 14,  8,
 1101, 29, 16,  2,
 1102, 25, 21,  6,
 1102, 27, 18,  7,
 1102, 29, 15,  6,
 1102, 30, 11,  9,
 1102, 33,  3,  2,
 1104, 28, 16,  8,
 1104, 32,  8,  4,
 1105, 24, 23,  0,
 1105, 30, 13,  6,
 1105, 30, 14,  3,
 1105, 31, 12,  0,
 1105, 32,  9,  0,
 1105, 33,  4,  0,
 1106, 24, 19, 13,
 1106, 24, 23,  1,
 1106, 25, 16, 15,
 1106, 25, 20,  9,
 1106, 27, 16, 11,
 1106, 27, 19,  4,
 1106, 29, 12, 11,
 1106, 29, 16,  3,
 1106, 31,  9,  8,
 1106, 31, 12,  1,
 1106, 32,  9,  1,
 1106, 33,  4,  1,
 1107, 21, 21, 15,
 1107, 23, 17, 17,
 1107, 23, 23,  7,
 1107, 25, 19, 11,
 1107, 31, 11,  5,
 1107, 33,  3,  3,
 1108, 28, 18,  0,
 1108, 30, 12,  8,
 1109, 22, 20, 15,
 1109, 23, 18, 16,
 1109, 24, 22,  7,
 1109, 24, 23,  2,
 1109, 25, 22,  0,
 1109, 26, 17, 12,
 1109, 28, 15, 10,
 1109, 28, 17,  6,
 1109, 28, 18,  1,
 1109, 31, 12,  2,
 1109, 32,  7,  6,
 1109, 32,  9,  2,
 1109, 33,  4,  2,
 1110, 25, 17, 14,
 1110, 25, 22,  1,
 1110, 29, 13, 10,
 1110, 31, 10,  7,
 1112, 22, 22, 12,
 1112, 26, 20,  6,
 1112, 28, 18,  2,
 1112, 30, 14,  4,
 1113, 23, 22, 10,
 1113, 25, 22,  2,
 1113, 29, 16,  4,
 1113, 32,  8,  5,
 1114, 23, 21, 12,
 1114, 24, 23,  3,
 1114, 31, 12,  3,
 1114, 32,  9,  3,
 1114, 33,  4,  3,
 1114, 33,  5,  0,
 1115, 23, 19, 15,
 1115, 25, 21,  7,
 1115, 27, 19,  5,
 1115, 29, 15,  7,
 1115, 33,  5,  1,
 1117, 24, 21, 10,
 1117, 26, 21,  0,
 1117, 27, 18,  8,
 1117, 28, 18,  3,
 1118, 25, 18, 13,
 1118, 25, 22,  3,
 1118, 26, 19,  9,
 1118, 26, 21,  1,
 1118, 27, 17, 10,
 1118, 29, 14,  9,
 1118, 30, 13,  7,
 1118, 31, 11,  6,
 1118, 33,  5,  2,
 1120, 24, 20, 12,
 1121, 22, 21, 14,
 1121, 24, 17, 16,
 1121, 24, 23,  4,
 1121, 26, 18, 11,
 1121, 26, 21,  2,
 1121, 27, 14, 14,
 1121, 28, 16,  9,
 1121, 30, 11, 10,
 1121, 30, 14,  5,
 1121, 31, 12,  4,
 1121, 32,  9,  4,
 1121, 33,  4,  4,
 1122, 20, 19, 19,
 1122, 23, 23,  8,
 1122, 28, 13, 13,
 1122, 28, 17,  7,
 1122, 29, 16,  5,
 1122, 32,  7,  7,
 1123, 27, 15, 13,
 1123, 31,  9,  9,
 1123, 33,  5,  3,
 1124, 20, 20, 18,
 1124, 24, 22,  8,
 1124, 28, 14, 12,
 1124, 28, 18,  4,
 1124, 32,  8,  6,
 1124, 32, 10,  0,
 1125, 23, 20, 14,
 1125, 24, 18, 15,
 1125, 25, 20, 10,
 1125, 25, 22,  4,
 1125, 26, 20,  7,
 1125, 30, 12,  9,
 1125, 30, 15,  0,
 1125, 31, 10,  8,
 1125, 32, 10,  1,
 1125, 33,  6,  0,
 1126, 21, 19, 18,
 1126, 26, 15, 15,
 1126, 26, 21,  3,
 1126, 27, 19,  6,
 1126, 30, 15,  1,
 1126, 33,  6,  1,
 1128, 26, 16, 14,
 1128, 32, 10,  2,
 1129, 27, 16, 12,
 1129, 27, 20,  0,
 1129, 29, 12, 12,
 1129, 30, 15,  2,
 1129, 33,  6,  2,
 1130, 21, 20, 17,
 1130, 24, 23,  5,
 1130, 25, 19, 12,
 1130, 25, 21,  8,
 1130, 27, 20,  1,
 1130, 28, 15, 11,
 1130, 29, 15,  8,
 1130, 29, 17,  0,
 1130, 31, 12,  5,
 1130, 31, 13,  0,
 1130, 32,  9,  5,
 1130, 33,  5,  4,
 1131, 29, 13, 11,
 1131, 29, 17,  1,
 1131, 31, 11,  7,
 1131, 31, 13,  1,
 1132, 22, 18, 18,
 1132, 30, 14,  6,
 1133, 24, 19, 14,
 1133, 26, 21,  4,
 1133, 27, 20,  2,
 1133, 28, 18,  5,
 1133, 29, 16,  6,
 1133, 30, 13,  8,
 1133, 32, 10,  3,
 1134, 22, 19, 17,
 1134, 23, 22, 11,
 1134, 25, 22,  5,
 1134, 26, 17, 13,
 1134, 27, 18,  9,
 1134, 29, 17,  2,
 1134, 30, 15,  3,
 1134, 31, 13,  2,
 1134, 33,  6,  3,
 1137, 22, 22, 13,
 1137, 25, 16, 16,
 1137, 26, 19, 10,
 1137, 28, 17,  8,
 1137, 29, 14, 10,
 1137, 32,  8,  7,
 1138, 21, 21, 16,
 1138, 24, 21, 11,
 1138, 27, 20,  3,
 1138, 33,  7,  0,
 1139, 23, 21, 13,
 1139, 23, 23,  9,
 1139, 25, 17, 15,
 1139, 27, 17, 11,
 1139, 27, 19,  7,
 1139, 29, 17,  3,
 1139, 31, 13,  3,
 1139, 33,  5,  5,
 1139, 33,  7,  1,
 1140, 22, 20, 16,
 1140, 26, 20,  8,
 1140, 28, 16, 10,
 1140, 32, 10,  4,
 1141, 24, 22,  9,
 1141, 24, 23,  6,
 1141, 30, 15,  4,
 1141, 31, 12,  6,
 1141, 32,  9,  6,
 1141, 33,  6,  4,
 1142, 23, 18, 17,
 1142, 26, 21,  5,
 1142, 30, 11, 11,
 1142, 31, 10,  9,
 1142, 33,  7,  2,
 1144, 26, 18, 12,
 1144, 28, 18,  6,
 1144, 30, 12, 10,
 1145, 24, 20, 13,
 1145, 25, 18, 14,
 1145, 25, 22,  6,
 1145, 27, 20,  4,
 1145, 28, 19,  0,
 1145, 30, 14,  7,
 1145, 32, 11,  0,
 1146, 23, 19, 16,
 1146, 25, 20, 11,
 1146, 28, 19,  1,
 1146, 29, 16,  7,
 1146, 29, 17,  4,
 1146, 31, 11,  8,
 1146, 31, 13,  4,
 1146, 32, 11,  1,
 1147, 25, 21,  9,
 1147, 29, 15,  9,
 1147, 33,  7,  3,
 1149, 28, 14, 13,
 1149, 28, 19,  2,
 1149, 32, 10,  5,
 1149, 32, 11,  2,
 1150, 22, 21, 15,
 1150, 27, 15, 14,
 1150, 30, 13,  9,
 1150, 30, 15,  5,
 1150, 33,  6,  5,
 1152, 24, 24,  0,
 1152, 32,  8,  8,
 1153, 24, 24,  1,
 1153, 26, 21,  6,
 1153, 27, 18, 10,
 1153, 28, 15, 12,
 1153, 33,  8,  0,
 1154, 23, 20, 15,
 1154, 24, 17, 17,
 1154, 24, 23,  7,
 1154, 25, 23,  0,
 1154, 27, 16, 13,
 1154, 27, 19,  8,
 1154, 27, 20,  5,
 1154, 28, 17,  9,
 1154, 28, 19,  3,
 1154, 29, 13, 12,
 1154, 31, 12,  7,
 1154, 32,  9,  7,
 1154, 32, 11,  3,
 1154, 33,  7,  4,
 1154, 33,  8,  1,
 1155, 25, 19, 13,
 1155, 25, 23,  1,
 1155, 29, 17,  5,
 1155, 31, 13,  5,
 1156, 24, 18, 16,
 1156, 24, 24,  2,
 1156, 30, 16,  0,
 1156, 34,  0,  0,
 1157, 23, 22, 12,
 1157, 26, 16, 15,
 1157, 26, 20,  9,
 1157, 28, 18,  7,
 1157, 30, 16,  1,
 1157, 31, 14,  0,
 1157, 33,  8,  2,
 1157, 34,  1,  0,
 1158, 23, 23, 10,
 1158, 25, 22,  7,
 1158, 25, 23,  2,
 1158, 26, 19, 11,
 1158, 29, 14, 11,
 1158, 31, 14,  1,
 1158, 34,  1,  1,
 1160, 24, 22, 10,
 1160, 26, 22,  0,
 1160, 30, 14,  8,
 1160, 30, 16,  2,
 1160, 32, 10,  6,
 1160, 34,  2,  0,
 1161, 20, 20, 19,
 1161, 24, 21, 12,
 1161, 24, 24,  3,
 1161, 26, 17, 14,
 1161, 26, 22,  1,
 1161, 28, 16, 11,
 1161, 28, 19,  4,
 1161, 29, 16,  8,
 1161, 30, 15,  6,
 1161, 31, 10, 10,
 1161, 31, 14,  2,
 1161, 32, 11,  4,
 1161, 33,  6,  6,
 1161, 34,  2,  1,
 1162, 24, 19, 15,
 1162, 27, 17, 12,
 1162, 33,  8,  3,
 1163, 21, 19, 19,
 1163, 25, 23,  3,
 1163, 31, 11,  9,
 1163, 33,  7,  5,
 1164, 22, 22, 14,
 1164, 26, 22,  2,
 1164, 34,  2,  2,
 1165, 21, 20, 18,
 1165, 27, 20,  6,
 1165, 29, 18,  0,
 1165, 30, 12, 11,
 1165, 30, 16,  3,
 1165, 34,  3,  0,
 1166, 23, 21, 14,
 1166, 25, 21, 10,
 1166, 26, 21,  7,
 1166, 29, 15, 10,
 1166, 29, 17,  6,
 1166, 29, 18,  1,
 1166, 31, 13,  6,
 1166, 31, 14,  3,
 1166, 34,  3,  1,
 1168, 24, 24,  4,
 1168, 32, 12,  0,
 1169, 22, 19, 18,
 1169, 24, 23,  8,
 1169, 25, 20, 12,
 1169, 26, 18, 13,
 1169, 26, 22,  3,
 1169, 29, 18,  2,
 1169, 30, 13, 10,
 1169, 31, 12,  8,
 1169, 32,  9,  8,
 1169, 32, 12,  1,
 1169, 33,  8,  4,
 1169, 34,  3,  2,
 1170, 25, 17, 16,
 1170, 25, 23,  4,
 1170, 27, 21,  0,
 1170, 28, 19,  5,
 1170, 32, 11,  5,
 1170, 33,  9,  0,
 1171, 21, 21, 17,
 1171, 27, 19,  9,
 1171, 27, 21,  1,
 1171, 33,  9,  1,
 1172, 24, 20, 14,
 1172, 28, 18,  8,
 1172, 30, 16,  4,
 1172, 32, 12,  2,
 1172, 34,  4,  0,
 1173, 22, 20, 17,
 1173, 25, 22,  8,
 1173, 28, 17, 10,
 1173, 31, 14,  4,
 1173, 32, 10,  7,
 1173, 34,  4,  1,
 1174, 25, 18, 15,
 1174, 27, 18, 11,
 1174, 27, 21,  2,
 1174, 29, 18,  3,
 1174, 30, 15,  7,
 1174, 33,  7,  6,
 1174, 33,  9,  2,
 1174, 34,  3,  3,
 1176, 26, 20, 10,
 1176, 26, 22,  4,
 1176, 28, 14, 14,
 1176, 34,  4,  2,
 1177, 23, 18, 18,
 1177, 24, 24,  5,
 1177, 30, 14,  9,
 1177, 32, 12,  3,
 1178, 27, 20,  7,
 1178, 28, 15, 13,
 1178, 29, 16,  9,
 1178, 33,  8,  5,
 1179, 23, 19, 17,
 1179, 23, 23, 11,
 1179, 25, 23,  5,
 1179, 27, 15, 15,
 1179, 27, 21,  3,
 1179, 29, 13, 13,
 1179, 29, 17,  7,
 1179, 31, 13,  7,
 1179, 33,  9,  3,
 1181, 22, 21, 16,
 1181, 24, 22, 11,
 1181, 26, 19, 12,
 1181, 26, 21,  8,
 1181, 27, 16, 14,
 1181, 28, 19,  6,
 1181, 29, 14, 12,
 1181, 29, 18,  4,
 1181, 30, 16,  5,
 1181, 32, 11,  6,
 1181, 34,  4,  3,
 1181, 34,  5,  0,
 1182, 23, 22, 13,
 1182, 25, 19, 14,
 1182, 31, 11, 10,
 1182, 31, 14,  5,
 1182, 34,  5,  1,
 1184, 28, 16, 12,
 1184, 28, 20,  0,
 1184, 32, 12,  4,
 1185, 23, 20, 16,
 1185, 26, 22,  5,
 1185, 28, 20,  1,
 1185, 34,  5,  2,
 1186, 24, 21, 13,
 1186, 24, 23,  9,
 1186, 27, 21,  4,
 1186, 31, 12,  9,
 1186, 31, 15,  0,
 1186, 32,  9,  9,
 1186, 33,  9,  4,
 1187, 25, 21, 11,
 1187, 27, 17, 13,
 1187, 29, 15, 11,
 1187, 31, 15,  1,
 1187, 33,  7,  7,
 1188, 24, 24,  6,
 1188, 26, 16, 16,
 1188, 28, 20,  2,
 1188, 30, 12, 12,
 1188, 32, 10,  8,
 1188, 34,  4,  4,
 1189, 24, 18, 17,
 1189, 28, 18,  9,
 1189, 30, 15,  8,
 1189, 30, 17,  0,
 1189, 33,  8,  6,
 1189, 33, 10,  0,
 1190, 25, 22,  9,
 1190, 25, 23,  6,
 1190, 26, 17, 15,
 1190, 27, 19, 10,
 1190, 29, 18,  5,
 1190, 30, 13, 11,
 1190, 30, 17,  1,
 1190, 31, 15,  2,
 1190, 33, 10,  1,
 1190, 34,  5,  3,
 1192, 30, 16,  6,
 1192, 34,  6,  0,
 1193, 22, 22, 15,
 1193, 24, 19, 16,
 1193, 27, 20,  8,
 1193, 28, 20,  3,
 1193, 30, 17,  2,
 1193, 31, 14,  6,
 1193, 32, 12,  5,
 1193, 32, 13,  0,
 1193, 33, 10,  2,
 1193, 34,  6,  1,
 1194, 25, 20, 13,
 1194, 28, 17, 11,
 1194, 28, 19,  7,
 1194, 29, 17,  8,
 1194, 31, 13,  8,
 1194, 32, 11,  7,
 1194, 32, 13,  1,
 1195, 23, 21, 15,
 1195, 27, 21,  5,
 1195, 31, 15,  3,
 1195, 33,  9,  5,
 1196, 26, 18, 14,
 1196, 26, 22,  6,
 1196, 30, 14, 10,
 1196, 34,  6,  2,
 1197, 26, 20, 11,
 1197, 27, 18, 12,
 1197, 29, 16, 10,
 1197, 32, 13,  2,
 1197, 34,  5,  4,
 1198, 26, 21,  9,
 1198, 30, 17,  3,
 1198, 33, 10,  3,
 1200, 20, 20, 20,
 1200, 28, 20,  4,
 1201, 24, 20, 15,
 1201, 24, 24,  7,
 1201, 25, 24,  0,
 1201, 29, 18,  6,
 1201, 34,  6,  3,
 1202, 21, 20, 19,
 1202, 23, 23, 12,
 1202, 25, 24,  1,
 1202, 29, 19,  0,
 1202, 31, 15,  4,
 1202, 32, 13,  3,
 1202, 33,  8,  7,
 1203, 25, 17, 17,
 1203, 25, 23,  7,
 1203, 29, 19,  1,
 1203, 31, 11, 11,
 1204, 24, 22, 12,
 1204, 32, 12,  6,
 1205, 24, 23, 10,
 1205, 25, 18, 16,
 1205, 25, 24,  2,
 1205, 26, 23,  0,
 1205, 28, 15, 14,
 1205, 30, 16,  7,
 1205, 30, 17,  4,
 1205, 31, 12, 10,
 1205, 32, 10,  9,
 1205, 33, 10,  4,
 1205, 34,  7,  0,
 1206, 21, 21, 18,
 1206, 22, 19, 19,
 1206, 26, 19, 13,
 1206, 26, 23,  1,
 1206, 27, 21,  6,
 1206, 29, 14, 13,
 1206, 29, 19,  2,
 1206, 30, 15,  9,
 1206, 31, 14,  7,
 1206, 33,  9,  6,
 1206, 34,  5,  5,
 1206, 34,  7,  1,
 1208, 22, 20, 18,
 1208, 28, 18, 10,
 1208, 34,  6,  4,
 1209, 23, 22, 14,
 1209, 25, 22, 10,
 1209, 26, 22,  7,
 1209, 26, 23,  2,
 1209, 28, 16, 13,
 1209, 28, 19,  8,
 1209, 28, 20,  5,
 1209, 32, 11,  8,
 1209, 32, 13,  4,
 1209, 34,  7,  2,
 1210, 25, 21, 12,
 1210, 25, 24,  3,
 1210, 27, 16, 15,
 1210, 27, 20,  9,
 1210, 29, 15, 12,
 1210, 33, 11,  0,
 1211, 25, 19, 15,
 1211, 27, 19, 11,
 1211, 29, 17,  9,
 1211, 29, 19,  3,
 1211, 31, 13,  9,
 1211, 31, 15,  5,
 1211, 33, 11,  1,
 1213, 24, 21, 14,
 1213, 27, 22,  0,
 1213, 30, 13, 12,
 1214, 22, 21, 17,
 1214, 23, 19, 18,
 1214, 26, 23,  3,
 1214, 27, 17, 14,
 1214, 27, 22,  1,
 1214, 29, 18,  7,
 1214, 30, 17,  5,
 1214, 33, 10,  5,
 1214, 33, 11,  2,
 1214, 34,  7,  3,
 1216, 24, 24,  8,
 1217, 25, 24,  4,
 1217, 26, 21, 10,
 1217, 27, 22,  2,
 1217, 28, 17, 12,
 1217, 30, 14, 11,
 1217, 31, 16,  0,
 1217, 32, 12,  7,
 1217, 33,  8,  8,
 1217, 34,  6,  5,
 1218, 23, 20, 17,
 1218, 25, 23,  8,
 1218, 29, 16, 11,
 1218, 29, 19,  4,
 1218, 31, 16,  1,
 1218, 32, 13,  5,
 1219, 27, 21,  7,
 1219, 33,  9,  7,
 1219, 33, 11,  3,
 1220, 26, 20, 12,
 1220, 28, 20,  6,
 1220, 30, 16,  8,
 1220, 32, 14,  0,
 1220, 34,  8,  0,
 1221, 25, 20, 14,
 1221, 26, 17, 16,
 1221, 26, 23,  4,
 1221, 31, 14,  8,
 1221, 31, 16,  2,
 1221, 32, 14,  1,
 1221, 34,  7,  4,
 1221, 34,  8,  1,
 1222, 27, 18, 13,
 1222, 27, 22,  3,
 1222, 31, 15,  6,
 1224, 22, 22, 16,
 1224, 24, 18, 18,
 1224, 26, 22,  8,
 1224, 30, 18,  0,
 1224, 32, 10, 10,
 1224, 32, 14,  2,
 1224, 34,  8,  2,
 1225, 26, 18, 15,
 1225, 28, 21,  0,
 1225, 30, 15, 10,
 1225, 30, 17,  6,
 1225, 30, 18,  1,
 1225, 33, 10,  6,
 1225, 35,  0,  0,
 1226, 23, 21, 16,
 1226, 24, 19, 17,
 1226, 24, 23, 11,
 1226, 25, 24,  5,
 1226, 28, 19,  9,
 1226, 28, 21,  1,
 1226, 31, 12, 11,
 1226, 31, 16,  3,
 1226, 32, 11,  9,
 1226, 33, 11,  4,
 1226, 35,  1,  0,
 1227, 23, 23, 13,
 1227, 29, 19,  5,
 1227, 35,  1,  1,
 1228, 30, 18,  2,
 1228, 34,  6,  6,
 1229, 24, 22, 13,
 1229, 27, 20, 10,
 1229, 27, 22,  4,
 1229, 28, 18, 11,
 1229, 28, 21,  2,
 1229, 29, 18,  8,
 1229, 32, 13,  6,
 1229, 32, 14,  3,
 1229, 34,  8,  3,
 1229, 35,  2,  0,
 1230, 25, 22, 11,
 1230, 26, 23,  5,
 1230, 29, 17, 10,
 1230, 31, 13, 10,
 1230, 34,  7,  5,
 1230, 35,  2,  1,
 1232, 24, 20, 16,
 1232, 32, 12,  8,
 1233, 24, 24,  9,
 1233, 26, 19, 14,
 1233, 28, 20,  7,
 1233, 29, 14, 14,
 1233, 30, 18,  3,
 1233, 31, 16,  4,
 1233, 33, 12,  0,
 1233, 35,  2,  2,
 1234, 27, 19, 12,
 1234, 27, 21,  8,
 1234, 28, 15, 15,
 1234, 28, 21,  3,
 1234, 33,  9,  8,
 1234, 33, 12,  1,
 1234, 35,  3,  0,
 1235, 25, 21, 13,
 1235, 25, 23,  9,
 1235, 29, 15, 13,
 1235, 31, 15,  7,
 1235, 33, 11,  5,
 1235, 35,  3,  1,
 1236, 28, 16, 14,
 1236, 32, 14,  4,
 1236, 34,  8,  4,
 1237, 25, 24,  6,
 1237, 30, 16,  9,
 1237, 33, 12,  2,
 1237, 34,  9,  0,
 1238, 23, 22, 15,
 1238, 25, 18, 17,
 1238, 26, 21, 11,
 1238, 27, 22,  5,
 1238, 29, 19,  6,
 1238, 30, 13, 13,
 1238, 30, 17,  7,
 1238, 31, 14,  9,
 1238, 33, 10,  7,
 1238, 34,  9,  1,
 1238, 35,  3,  2,
 1240, 30, 14, 12,
 1240, 30, 18,  4,
 1241, 21, 20, 20,
 1241, 26, 22,  9,
 1241, 26, 23,  6,
 1241, 27, 16, 16,
 1241, 28, 21,  4,
 1241, 29, 16, 12,
 1241, 29, 20,  0,
 1241, 34,  7,  6,
 1241, 34,  9,  2,
 1241, 35,  4,  0,
 1242, 24, 21, 15,
 1242, 25, 19, 16,
 1242, 28, 17, 13,
 1242, 29, 20,  1,
 1242, 31, 16,  5,
 1242, 32, 13,  7,
 1242, 33, 12,  3,
 1242, 35,  4,  1,
 1243, 21, 21, 19,
 1243, 27, 17, 15,
 1243, 35,  3,  3,
 1245, 22, 20, 19,
 1245, 26, 20, 13,
 1245, 28, 19, 10,
 1245, 29, 20,  2,
 1245, 32, 11, 10,
 1245, 32, 14,  5,
 1245, 34,  8,  5,
 1245, 35,  4,  2,
 1246, 29, 18,  9,
 1246, 30, 15, 11,
 1246, 33, 11,  6,
 1246, 34,  9,  3,
 1248, 28, 20,  8,
 1249, 22, 21, 18,
 1249, 24, 23, 12,
 1249, 27, 18, 14,
 1249, 27, 22,  6,
 1249, 30, 18,  5,
 1249, 31, 12, 12,
 1249, 32, 12,  9,
 1249, 32, 15,  0,
 1249, 33, 12,  4,
 1250, 25, 20, 15,
 1250, 25, 24,  7,
 1250, 25, 25,  0,
 1250, 27, 20, 11,
 1250, 28, 21,  5,
 1250, 29, 20,  3,
 1250, 31, 15,  8,
 1250, 31, 17,  0,
 1250, 32, 15,  1,
 1250, 35,  4,  3,
 1250, 35,  5,  0,
 1251, 23, 19, 19,
 1251, 25, 25,  1,
 1251, 27, 21,  9,
 1251, 29, 17, 11,
 1251, 29, 19,  7,
 1251, 31, 13, 11,
 1251, 31, 17,  1,
 1251, 33,  9,  9,
 1251, 35,  5,  1,
 1252, 24, 24, 10,
 1252, 26, 24,  0,
 1252, 28, 18, 12,
 1253, 23, 20, 18,
 1253, 25, 22, 12,
 1253, 26, 24,  1,
 1253, 30, 17,  8,
 1253, 31, 16,  6,
 1253, 32, 15,  2,
 1253, 33, 10,  8,
 1253, 34,  9,  4,
 1254, 23, 23, 14,
 1254, 25, 23, 10,
 1254, 25, 25,  2,
 1254, 26, 17, 17,
 1254, 26, 23,  7,
 1254, 31, 17,  2,
 1254, 34,  7,  7,
 1254, 35,  5,  2,
 1256, 24, 22, 14,
 1256, 26, 18, 16,
 1256, 26, 24,  2,
 1256, 30, 16, 10,
 1256, 32, 14,  6,
 1256, 34,  8,  6,
 1256, 34, 10,  0,
 1257, 22, 22, 17,
 1257, 29, 20,  4,
 1257, 31, 14, 10,
 1257, 32, 13,  8,
 1257, 34, 10,  1,
 1257, 35,  4,  4,
 1258, 27, 23,  0,
 1258, 32, 15,  3,
 1258, 33, 12,  5,
 1258, 33, 13,  0,
 1259, 23, 21, 17,
 1259, 25, 25,  3,
 1259, 27, 19, 13,
 1259, 27, 23,  1,
 1259, 31, 17,  3,
 1259, 33, 11,  7,
 1259, 33, 13,  1,
 1259, 35,  5,  3,
 1260, 26, 22, 10,
 1260, 30, 18,  6,
 1260, 34, 10,  2,
 1261, 24, 19, 18,
 1261, 26, 21, 12,
 1261, 26, 24,  3,
 1261, 28, 21,  6,
 1261, 30, 19,  0,
 1261, 35,  6,  0,
 1262, 25, 21, 14,
 1262, 26, 19, 15,
 1262, 27, 22,  7,
 1262, 27, 23,  2,
 1262, 29, 15, 14,
 1262, 30, 19,  1,
 1262, 33, 13,  2,
 1262, 34,  9,  5,
 1262, 35,  6,  1,
 1265, 24, 20, 17,
 1265, 25, 24,  8,
 1265, 28, 16, 15,
 1265, 28, 20,  9,
 1265, 29, 18, 10,
 1265, 30, 14, 13,
 1265, 30, 19,  2,
 1265, 32, 15,  4,
 1265, 34, 10,  3,
 1265, 35,  6,  2,
 1266, 25, 25,  4,
 1266, 28, 19, 11,
 1266, 29, 16, 13,
 1266, 29, 19,  8,
 1266, 29, 20,  5,
 1266, 31, 16,  7,
 1266, 31, 17,  4,
 1266, 32, 11, 11,
 1266, 35,  5,  4,
 1267, 27, 23,  3,
 1267, 31, 15,  9,
 1267, 33, 13,  3,
 1268, 26, 24,  4,
 1268, 28, 22,  0,
 1268, 32, 12, 10,
 1269, 23, 22, 16,
 1269, 26, 23,  8,
 1269, 28, 17, 14,
 1269, 28, 22,  1,
 1269, 30, 15, 12,
 1269, 32, 14,  7,
 1269, 33, 12,  6,
 1269, 34,  8,  7,
 1270, 27, 21, 10,
 1270, 30, 17,  9,
 1270, 30, 19,  3,
 1270, 33, 10,  9,
 1270, 35,  6,  3,
 1272, 26, 20, 14,
 1272, 28, 22,  2,
 1272, 34, 10,  4,
 1273, 24, 21, 16,
 1273, 24, 24, 11,
 1273, 25, 18, 18,
 1273, 27, 20, 12,
 1273, 30, 18,  7,
 1273, 34,  9,  6,
 1274, 24, 23, 13,
 1274, 27, 17, 16,
 1274, 27, 23,  4,
 1274, 28, 21,  7,
 1274, 29, 17, 12,
 1274, 31, 13, 12,
 1274, 32, 13,  9,
 1274, 32, 15,  5,
 1274, 33, 11,  8,
 1274, 33, 13,  4,
 1274, 35,  7,  0,
 1275, 25, 19, 17,
 1275, 25, 23, 11,
 1275, 25, 25,  5,
 1275, 31, 17,  5,
 1275, 35,  5,  5,
 1275, 35,  7,  1,
 1277, 26, 24,  5,
 1277, 27, 22,  8,
 1277, 28, 18, 13,
 1277, 28, 22,  3,
 1277, 29, 20,  6,
 1277, 30, 16, 11,
 1277, 30, 19,  4,
 1277, 34, 11,  0,
 1277, 35,  6,  4,
 1278, 25, 22, 13,
 1278, 27, 18, 15,
 1278, 31, 14, 11,
 1278, 34, 11,  1,
 1278, 35,  7,  2,
 1280, 32, 16,  0,
 1281, 25, 20, 16,
 1281, 26, 22, 11,
 1281, 31, 16,  8,
 1281, 32, 16,  1,
 1281, 34, 10,  5,
 1281, 34, 11,  2,
 1282, 21, 21, 20,
 1282, 25, 24,  9,
 1282, 29, 21,  0,
 1282, 33, 12,  7,
 1283, 23, 23, 15,
 1283, 27, 23,  5,
 1283, 29, 19,  9,
 1283, 29, 21,  1,
 1283, 33, 13,  5,
 1283, 35,  7,  3,
 1284, 22, 20, 20,
 1284, 28, 20, 10,
 1284, 28, 22,  4,
 1284, 32, 14,  8,
 1284, 32, 16,  2,
 1284, 34,  8,  8,
 1285, 24, 22, 15,
 1285, 31, 18,  0,
 1285, 32, 15,  6,
 1285, 33, 14,  0,
 1286, 22, 21, 19,
 1286, 25, 25,  6,
 1286, 26, 21, 13,
 1286, 26, 23,  9,
 1286, 27, 19, 14,
 1286, 29, 18, 11,
 1286, 29, 21,  2,
 1286, 30, 19,  5,
 1286, 31, 15, 10,
 1286, 31, 17,  6,
 1286, 31, 18,  1,
 1286, 33, 14,  1,
 1286, 34,  9,  7,
 1286, 34, 11,  3,
 1286, 35,  6,  5,
 1288, 26, 24,  6,
 1288, 30, 18,  8,
 1289, 26, 18, 17,
 1289, 28, 19, 12,
 1289, 28, 21,  8,
 1289, 30, 17, 10,
 1289, 31, 18,  2,
 1289, 32, 12, 11,
 1289, 32, 16,  3,
 1289, 33, 10, 10,
 1289, 33, 14,  2,
 1289, 35,  8,  0,
 1290, 23, 20, 19,
 1290, 29, 20,  7,
 1290, 35,  7,  4,
 1290, 35,  8,  1,
 1291, 25, 21, 15,
 1291, 27, 21, 11,
 1291, 29, 15, 15,
 1291, 29, 21,  3,
 1291, 33, 11,  9,
 1292, 22, 22, 18,
 1292, 30, 14, 14,
 1292, 34, 10,  6,
 1293, 26, 19, 16,
 1293, 28, 22,  5,
 1293, 29, 16, 14,
 1293, 32, 13, 10,
 1293, 34, 11,  4,
 1293, 35,  8,  2,
 1294, 23, 21, 18,
 1294, 27, 22,  9,
 1294, 27, 23,  6,
 1294, 30, 15, 13,
 1294, 31, 18,  3,
 1294, 33, 13,  6,
 1294, 33, 14,  3,
 1296, 24, 24, 12,
 1296, 28, 16, 16,
 1296, 32, 16,  4,
 1296, 36,  0,  0,
 1297, 30, 19,  6,
 1297, 33, 12,  8,
 1297, 35,  6,  6,
 1297, 36,  1,  0,
 1298, 24, 19, 19,
 1298, 25, 23, 12,
 1298, 27, 20, 13,
 1298, 28, 17, 15,
 1298, 29, 21,  4,
 1298, 31, 16,  9,
 1298, 32, 15,  7,
 1298, 35,  8,  3,
 1298, 36,  1,  1,
 1299, 25, 25,  7,
 1299, 29, 17, 13,
 1299, 31, 13, 13,
 1299, 31, 17,  7,
 1299, 35,  7,  5,
 1300, 24, 20, 18,
 1300, 30, 16, 12,
 1300, 30, 20,  0,
 1300, 34, 12,  0,
 1300, 36,  2,  0,
 1301, 24, 23, 14,
 1301, 25, 24, 10,
 1301, 26, 20, 15,
 1301, 26, 24,  7,
 1301, 26, 25,  0,
 1301, 30, 20,  1,
 1301, 31, 14, 12,
 1301, 31, 18,  4,
 1301, 32, 14,  9,
 1301, 33, 14,  4,
 1301, 34,  9,  8,
 1301, 34, 12,  1,
 1301, 36,  2,  1,
 1302, 23, 22, 17,
 1302, 26, 25,  1,
 1302, 29, 19, 10,
 1302, 34, 11,  5,
 1304, 26, 22, 12,
 1304, 28, 18, 14,
 1304, 28, 22,  6,
 1304, 30, 20,  2,
 1304, 34, 12,  2,
 1304, 36,  2,  2,
 1305, 25, 22, 14,
 1305, 26, 23, 10,
 1305, 26, 25,  2,
 1305, 27, 24,  0,
 1305, 28, 20, 11,
 1305, 29, 20,  8,
 1305, 30, 18,  9,
 1305, 32, 16,  5,
 1305, 34, 10,  7,
 1305, 35,  8,  4,
 1305, 36,  3,  0,
 1306, 24, 21, 17,
 1306, 27, 24,  1,
 1306, 28, 21,  9,
 1306, 35,  9,  0,
 1306, 36,  3,  1,
 1307, 27, 17, 17,
 1307, 27, 23,  7,
 1307, 29, 21,  5,
 1307, 31, 15, 11,
 1307, 33, 13,  7,
 1307, 35,  9,  1,
 1309, 27, 18, 16,
 1309, 27, 24,  2,
 1309, 29, 18, 12,
 1309, 30, 20,  3,
 1309, 34, 12,  3,
 1309, 36,  3,  2,
 1310, 25, 19, 18,
 1310, 26, 25,  3,
 1310, 30, 17, 11,
 1310, 30, 19,  7,
 1310, 31, 18,  5,
 1310, 33, 11, 10,
 1310, 33, 14,  5,
 1310, 35,  7,  6,
 1310, 35,  9,  2,
 1312, 32, 12, 12,
 1312, 36,  4,  0,
 1313, 26, 21, 14,
 1313, 27, 22, 10,
 1313, 28, 23,  0,
 1313, 32, 15,  8,
 1313, 32, 17,  0,
 1313, 34, 11,  6,
 1313, 36,  4,  1,
 1314, 23, 23, 16,
 1314, 25, 20, 17,
 1314, 25, 25,  8,
 1314, 27, 21, 12,
 1314, 27, 24,  3,
 1314, 28, 19, 13,
 1314, 28, 23,  1,
 1314, 31, 17,  8,
 1314, 32, 13, 11,
 1314, 32, 17,  1,
 1314, 33, 12,  9,
 1314, 33, 15,  0,
 1314, 35,  8,  5,
 1314, 36,  3,  3,
 1315, 27, 19, 15,
 1315, 33, 15,  1,
 1315, 35,  9,  3,
 1316, 24, 22, 16,
 1316, 26, 24,  8,
 1316, 30, 20,  4,
 1316, 32, 16,  6,
 1316, 34, 12,  4,
 1316, 36,  4,  2,
 1317, 26, 25,  4,
 1317, 28, 22,  7,
 1317, 28, 23,  2,
 1317, 31, 16, 10,
 1317, 32, 17,  2,
 1318, 29, 21,  6,
 1318, 33, 15,  2,
 1318, 34,  9,  9,
 1320, 32, 14, 10,
 1320, 34, 10,  8,
 1321, 24, 24, 13,
 1321, 27, 24,  4,
 1321, 30, 15, 14,
 1321, 31, 18,  6,
 1321, 33, 14,  6,
 1321, 36,  4,  3,
 1321, 36,  5,  0,
 1322, 25, 21, 16,
 1322, 25, 24, 11,
 1322, 27, 23,  8,
 1322, 28, 23,  3,
 1322, 29, 16, 15,
 1322, 29, 20,  9,
 1322, 31, 19,  0,
 1322, 32, 17,  3,
 1322, 33, 13,  8,
 1322, 35,  9,  4,
 1322, 36,  5,  1,
 1323, 21, 21, 21,
 1323, 25, 23, 13,
 1323, 29, 19, 11,
 1323, 31, 19,  1,
 1323, 33, 15,  3,
 1323, 35,  7,  7,
 1324, 26, 18, 18,
 1324, 30, 18, 10,
 1325, 22, 21, 20,
 1325, 27, 20, 14,
 1325, 28, 21, 10,
 1325, 29, 22,  0,
 1325, 30, 16, 13,
 1325, 30, 19,  8,
 1325, 30, 20,  5,
 1325, 34, 12,  5,
 1325, 34, 13,  0,
 1325, 35,  8,  6,
 1325, 35, 10,  0,
 1325, 36,  5,  2,
 1326, 26, 19, 17,
 1326, 26, 23, 11,
 1326, 26, 25,  5,
 1326, 29, 17, 14,
 1326, 29, 22,  1,
 1326, 31, 14, 13,
 1326, 31, 19,  2,
 1326, 34, 11,  7,
 1326, 34, 13,  1,
 1326, 35, 10,  1,
 1328, 28, 20, 12,
 1328, 36,  4,  4,
 1329, 22, 22, 19,
 1329, 23, 20, 20,
 1329, 26, 22, 13,
 1329, 28, 17, 16,
 1329, 28, 23,  4,
 1329, 29, 22,  2,
 1329, 32, 16,  7,
 1329, 32, 17,  4,
 1329, 34, 13,  2,
 1329, 35, 10,  2,
 1330, 24, 23, 15,
 1330, 27, 24,  5,
 1330, 31, 15, 12,
 1330, 32, 15,  9,
 1330, 33, 15,  4,
 1330, 36,  5,  3,
 1331, 23, 21, 19,
 1331, 25, 25,  9,
 1331, 29, 21,  7,
 1331, 31, 17,  9,
 1331, 31, 19,  3,
 1331, 33, 11, 11,
 1331, 35,  9,  5,
 1332, 26, 20, 16,
 1332, 28, 22,  8,
 1332, 36,  6,  0,
 1333, 26, 24,  9,
 1333, 28, 18, 15,
 1333, 30, 17, 12,
 1333, 33, 12, 10,
 1333, 36,  6,  1,
 1334, 25, 22, 15,
 1334, 27, 22, 11,
 1334, 29, 18, 13,
 1334, 29, 22,  3,
 1334, 31, 18,  7,
 1334, 33, 14,  7,
 1334, 34, 13,  3,
 1334, 35, 10,  3,
 1336, 30, 20,  6,
 1336, 34, 12,  6,
 1336, 36,  6,  2,
 1337, 23, 22, 18,
 1337, 24, 20, 19,
 1337, 26, 25,  6,
 1337, 32, 13, 12,
 1337, 34, 10,  9,
 1337, 36,  5,  4,
 1338, 28, 23,  5,
 1338, 31, 16, 11,
 1338, 31, 19,  4,
 1338, 32, 17,  5,
 1338, 35,  8,  7,
 1339, 27, 21, 13,
 1339, 27, 23,  9,
 1339, 33, 13,  9,
 1339, 33, 15,  5,
 1341, 24, 21, 18,
 1341, 27, 24,  6,
 1341, 28, 19, 14,
 1341, 29, 20, 10,
 1341, 29, 22,  4,
 1341, 30, 21,  0,
 1341, 32, 14, 11,
 1341, 34, 11,  8,
 1341, 34, 13,  4,
 1341, 35, 10,  4,
 1341, 36,  6,  3,
 1342, 26, 21, 15,
 1342, 27, 18, 17,
 1342, 30, 19,  9,
 1342, 30, 21,  1,
 1342, 35,  9,  6,
 1344, 32, 16,  8,
 1345, 25, 24, 12,
 1345, 30, 18, 11,
 1345, 30, 21,  2,
 1345, 33, 16,  0,
 1345, 36,  7,  0,
 1346, 27, 19, 16,
 1346, 28, 21, 11,
 1346, 29, 19, 12,
 1346, 29, 21,  8,
 1346, 33, 16,  1,
 1346, 35, 11,  0,
 1346, 36,  5,  5,
 1346, 36,  7,  1,
 1347, 23, 23, 17,
 1347, 25, 19, 19,
 1347, 31, 19,  5,
 1347, 35, 11,  1,
 1348, 24, 24, 14,
 1348, 32, 18,  0,
 1348, 36,  6,  4,
 1349, 24, 22, 17,
 1349, 25, 20, 18,
 1349, 26, 23, 12,
 1349, 28, 22,  9,
 1349, 28, 23,  6,
 1349, 30, 20,  7,
 1349, 31, 18,  8,
 1349, 32, 15, 10,
 1349, 32, 17,  6,
 1349, 32, 18,  1,
 1349, 33, 14,  8,
 1349, 33, 16,  2,
 1349, 34, 12,  7,
 1349, 36,  7,  2,
 1350, 25, 23, 14,
 1350, 25, 25, 10,
 1350, 26, 25,  7,
 1350, 29, 22,  5,
 1350, 30, 15, 15,
 1350, 30, 21,  3,
 1350, 31, 17, 10,
 1350, 33, 15,  6,
 1350, 34, 13,  5,
 1350, 35, 10,  5,
 1350, 35, 11,  2,
 1352, 26, 24, 10,
 1352, 26, 26,  0,
 1352, 30, 16, 14,
 1352, 32, 18,  2,
 1352, 34, 14,  0,
 1353, 26, 26,  1,
 1353, 28, 20, 13,
 1353, 29, 16, 16,
 1353, 31, 14, 14,
 1353, 34, 14,  1,
 1353, 35,  8,  8,
 1354, 27, 20, 15,
 1354, 27, 24,  7,
 1354, 27, 25,  0,
 1354, 33, 12, 11,
 1354, 33, 16,  3,
 1354, 36,  7,  3,
 1355, 25, 21, 17,
 1355, 27, 25,  1,
 1355, 29, 17, 15,
 1355, 31, 15, 13,
 1355, 35,  9,  7,
 1355, 35, 11,  3,
 1356, 26, 22, 14,
 1356, 26, 26,  2,
 1356, 34, 10, 10,
 1356, 34, 14,  2,
 1357, 27, 22, 12,
 1357, 30, 21,  4,
 1357, 32, 18,  3,
 1357, 36,  6,  5,
 1358, 27, 23, 10,
 1358, 27, 25,  2,
 1358, 30, 17, 13,
 1358, 31, 19,  6,
 1358, 33, 13, 10,
 1358, 34, 11,  9,
 1360, 28, 24,  0,
 1360, 36,  8,  0,
 1361, 24, 23, 16,
 1361, 26, 19, 18,
 1361, 26, 26,  3,
 1361, 28, 24,  1,
 1361, 29, 18, 14,
 1361, 29, 22,  6,
 1361, 30, 19, 10,
 1361, 31, 16, 12,
 1361, 31, 20,  0,
 1361, 32, 16,  9,
 1361, 33, 16,  4,
 1361, 34, 13,  6,
 1361, 34, 14,  3,
 1361, 35, 10,  6,
 1361, 36,  7,  4,
 1361, 36,  8,  1,
 1362, 28, 17, 17,
 1362, 28, 23,  7,
 1362, 29, 20, 11,
 1362, 31, 20,  1,
 1362, 32, 13, 13,
 1362, 32, 17,  7,
 1362, 35, 11,  4,
 1363, 27, 25,  3,
 1363, 29, 21,  9,
 1363, 33, 15,  7,
 1364, 28, 18, 16,
 1364, 28, 24,  2,
 1364, 30, 20,  8,
 1364, 32, 14, 12,
 1364, 32, 18,  4,
 1364, 34, 12,  8,
 1364, 36,  8,  2,
 1365, 25, 22, 16,
 1365, 26, 20, 17,
 1365, 26, 25,  8,
 1365, 31, 20,  2,
 1366, 22, 21, 21,
 1366, 27, 21, 14,
 1366, 30, 21,  5,
 1366, 31, 18,  9,
 1366, 33, 14,  9,
 1368, 22, 22, 20,
 1368, 26, 26,  4,
 1368, 28, 22, 10,
 1368, 30, 18, 12,
 1368, 34, 14,  4,
 1368, 36,  6,  6,
 1369, 27, 24,  8,
 1369, 28, 21, 12,
 1369, 28, 24,  3,
 1369, 35, 12,  0,
 1369, 36,  8,  3,
 1369, 37,  0,  0,
 1370, 23, 21, 20,
 1370, 25, 24, 13,
 1370, 27, 25,  4,
 1370, 28, 19, 15,
 1370, 29, 23,  0,
 1370, 31, 20,  3,
 1370, 32, 15, 11,
 1370, 33, 16,  5,
 1370, 35,  9,  8,
 1370, 35, 12,  1,
 1370, 36,  7,  5,
 1370, 37,  1,  0,
 1371, 25, 25, 11,
 1371, 29, 19, 13,
 1371, 29, 23,  1,
 1371, 31, 17, 11,
 1371, 31, 19,  7,
 1371, 35, 11,  5,
 1371, 37,  1,  1,
 1373, 26, 21, 16,
 1373, 26, 24, 11,
 1373, 32, 18,  5,
 1373, 35, 12,  2,
 1373, 37,  2,  0,
 1374, 23, 22, 19,
 1374, 26, 23, 13,
 1374, 29, 22,  7,
 1374, 29, 23,  2,
 1374, 34, 13,  7,
 1374, 35, 10,  7,
 1374, 37,  2,  1,
 1376, 24, 20, 20,
 1376, 28, 24,  4,
 1376, 36,  8,  4,
 1377, 24, 24, 15,
 1377, 26, 26,  5,
 1377, 27, 18, 18,
 1377, 28, 23,  8,
 1377, 30, 21,  6,
 1377, 31, 20,  4,
 1377, 32, 17,  8,
 1377, 33, 12, 12,
 1377, 34, 11, 10,
 1377, 34, 14,  5,
 1377, 36,  9,  0,
 1377, 37,  2,  2,
 1378, 24, 21, 19,
 1378, 33, 15,  8,
 1378, 33, 17,  0,
 1378, 35, 12,  3,
 1378, 36,  9,  1,
 1378, 37,  3,  0,
 1379, 25, 23, 15,
 1379, 27, 19, 17,
 1379, 27, 23, 11,
 1379, 27, 25,  5,
 1379, 29, 23,  3,
 1379, 33, 13, 11,
 1379, 33, 17,  1,
 1379, 37,  3,  1,
 1380, 28, 20, 14,
 1380, 32, 16, 10,
 1381, 30, 16, 15,
 1381, 30, 20,  9,
 1381, 33, 16,  6,
 1381, 34, 12,  9,
 1381, 34, 15,  0,
 1381, 36,  7,  6,
 1381, 36,  9,  2,
 1382, 23, 23, 18,
 1382, 26, 25,  9,
 1382, 27, 22, 13,
 1382, 29, 21, 10,
 1382, 30, 19, 11,
 1382, 31, 15, 14,
 1382, 33, 17,  2,
 1382, 34, 15,  1,
 1382, 35, 11,  6,
 1382, 37,  3,  2,
 1384, 24, 22, 18,
 1384, 30, 22,  0,
 1384, 32, 18,  6,
 1385, 26, 22, 15,
 1385, 27, 20, 16,
 1385, 28, 24,  5,
 1385, 29, 20, 12,
 1385, 30, 17, 14,
 1385, 30, 22,  1,
 1385, 31, 18, 10,
 1385, 32, 19,  0,
 1385, 33, 14, 10,
 1385, 34, 15,  2,
 1385, 35, 12,  4,
 1385, 36,  8,  5,
 1385, 37,  4,  0,
 1386, 25, 20, 19,
 1386, 27, 24,  9,
 1386, 29, 17, 16,
 1386, 29, 23,  4,
 1386, 31, 16, 13,
 1386, 31, 19,  8,
 1386, 31, 20,  5,
 1386, 32, 19,  1,
 1386, 36,  9,  3,
 1386, 37,  4,  1,
 1387, 33, 17,  3,
 1387, 35,  9,  9,
 1387, 37,  3,  3,
 1388, 26, 26,  6,
 1388, 30, 22,  2,
 1388, 34, 14,  6,
 1389, 28, 22, 11,
 1389, 29, 22,  8,
 1389, 32, 14, 13,
 1389, 32, 19,  2,
 1389, 34, 13,  8,
 1389, 35, 10,  8,
 1389, 37,  4,  2,
 1390, 25, 21, 18,
 1390, 27, 25,  6,
 1390, 29, 18, 15,
 1390, 30, 21,  7,
 1390, 34, 15,  3,
 1393, 30, 18, 13,
 1393, 30, 22,  3,
 1393, 32, 15, 12,
 1393, 36,  9,  4,
 1394, 24, 23, 17,
 1394, 25, 25, 12,
 1394, 28, 21, 13,
 1394, 28, 23,  9,
 1394, 31, 17, 12,
 1394, 32, 17,  9,
 1394, 32, 19,  3,
 1394, 33, 16,  7,
 1394, 33, 17,  4,
 1394, 35, 12,  5,
 1394, 35, 13,  0,
 1394, 36,  7,  7,
 1394, 37,  4,  3,
 1394, 37,  5,  0,
 1395, 27, 21, 15,
 1395, 29, 23,  5,
 1395, 33, 15,  9,
 1395, 35, 11,  7,
 1395, 35, 13,  1,
 1395, 37,  5,  1,
 1396, 26, 24, 12,
 1396, 28, 24,  6,
 1396, 36,  8,  6,
 1396, 36, 10,  0,
 1397, 25, 24, 14,
 1397, 28, 18, 17,
 1397, 31, 20,  6,
 1397, 32, 18,  7,
 1397, 34, 15,  4,
 1397, 36, 10,  1,
 1398, 25, 22, 17,
 1398, 26, 19, 19,
 1398, 29, 19, 14,
 1398, 34, 11, 11,
 1398, 35, 13,  2,
 1398, 37,  5,  2,
 1400, 26, 20, 18,
 1400, 30, 20, 10,
 1400, 30, 22,  4,
 1400, 34, 12, 10,
 1400, 36, 10,  2,
 1401, 26, 23, 14,
 1401, 26, 25, 10,
 1401, 26, 26,  7,
 1401, 28, 19, 16,
 1401, 32, 16, 11,
 1401, 32, 19,  4,
 1401, 34, 14,  7,
 1401, 37,  4,  4,
 1402, 27, 23, 12,
 1402, 31, 21,  0,
 1402, 33, 13, 12,
 1402, 36,  9,  5,
 1403, 27, 25,  7,
 1403, 29, 21, 11,
 1403, 31, 19,  9,
 1403, 31, 21,  1,
 1403, 33, 17,  5,
 1403, 35, 13,  3,
 1403, 37,  5,  3,
 1405, 27, 24, 10,
 1405, 27, 26,  0,
 1405, 30, 19, 12,
 1405, 30, 21,  8,
 1405, 35, 12,  6,
 1405, 36, 10,  3,
 1405, 37,  6,  0,
 1406, 26, 21, 17,
 1406, 27, 26,  1,
 1406, 29, 22,  9,
 1406, 29, 23,  6,
 1406, 31, 18, 11,
 1406, 31, 21,  2,
 1406, 33, 14, 11,
 1406, 34, 13,  9,
 1406, 34, 15,  5,
 1406, 35, 10,  9,
 1406, 37,  6,  1,
 1408, 24, 24, 16,
 1409, 22, 22, 21,
 1409, 27, 22, 14,
 1409, 27, 26,  2,
 1409, 28, 20, 15,
 1409, 28, 24,  7,
 1409, 28, 25,  0,
 1409, 30, 22,  5,
 1409, 33, 16,  8,
 1409, 36,  8,  7,
 1409, 37,  6,  2,
 1410, 25, 23, 16,
 1410, 28, 25,  1,
 1410, 29, 20, 13,
 1410, 31, 20,  7,
 1410, 32, 19,  5,
 1410, 35, 11,  8,
 1410, 35, 13,  4,
 1410, 37,  5,  4,
 1411, 23, 21, 21,
 1411, 31, 15, 15,
 1411, 31, 21,  3,
 1412, 28, 22, 12,
 1412, 30, 16, 16,
 1412, 32, 18,  8,
 1412, 34, 16,  0,
 1412, 36, 10,  4,
 1413, 23, 22, 20,
 1413, 28, 23, 10,
 1413, 28, 25,  2,
 1413, 31, 16, 14,
 1413, 32, 17, 10,
 1413, 33, 18,  0,
 1413, 34, 16,  1,
 1413, 36,  9,  6,
 1414, 27, 19, 18,
 1414, 27, 26,  3,
 1414, 30, 17, 15,
 1414, 33, 15, 10,
 1414, 33, 17,  6,
 1414, 33, 18,  1,
 1414, 37,  6,  3,
 1416, 26, 22, 16,
 1416, 26, 26,  8,
 1416, 32, 14, 14,
 1416, 34, 14,  8,
 1416, 34, 16,  2,
 1417, 24, 21, 20,
 1417, 29, 24,  0,
 1417, 33, 18,  2,
 1417, 34, 15,  6,
 1417, 36, 11,  0,
 1418, 27, 20, 17,
 1418, 27, 25,  8,
 1418, 28, 25,  3,
 1418, 29, 24,  1,
 1418, 31, 21,  4,
 1418, 32, 15, 13,
 1418, 35, 12,  7,
 1418, 36, 11,  1,
 1418, 37,  7,  0,
 1419, 23, 23, 19,
 1419, 25, 25, 13,
 1419, 29, 17, 17,
 1419, 29, 23,  7,
 1419, 31, 17, 13,
 1419, 35, 13,  5,
 1419, 37,  5,  5,
 1419, 37,  7,  1,
 1420, 30, 18, 14,
 1420, 30, 22,  6,
 1421, 24, 22, 19,
 1421, 26, 24, 13,
 1421, 27, 26,  4,
 1421, 28, 21, 14,
 1421, 29, 18, 16,
 1421, 29, 24,  2,
 1421, 30, 20, 11,
 1421, 32, 19,  6,
 1421, 34, 12, 11,
 1421, 34, 16,  3,
 1421, 35, 14,  0,
 1421, 36, 10,  5,
 1421, 36, 11,  2,
 1421, 37,  6,  4,
 1422, 26, 25, 11,
 1422, 30, 21,  9,
 1422, 31, 19, 10,
 1422, 33, 18,  3,
 1422, 35, 14,  1,
 1422, 37,  7,  2,
 1424, 28, 24,  8,
 1424, 32, 16, 12,
 1424, 32, 20,  0,
 1424, 36,  8,  8,
 1425, 25, 20, 20,
 1425, 28, 25,  4,
 1425, 29, 22, 10,
 1425, 31, 20,  8,
 1425, 32, 20,  1,
 1425, 34, 13, 10,
 1425, 35, 10, 10,
 1425, 35, 14,  2,
 1426, 25, 24, 15,
 1426, 27, 21, 16,
 1426, 27, 24, 11,
 1426, 29, 21, 12,
 1426, 29, 24,  3,
 1426, 33, 16,  9,
 1426, 36,  9,  7,
 1426, 36, 11,  3,
 1427, 25, 21, 19,
 1427, 27, 23, 13,
 1427, 29, 19, 15,
 1427, 31, 21,  5,
 1427, 33, 13, 13,
 1427, 33, 17,  7,
 1427, 35, 11,  9,
 1427, 37,  7,  3,
 1428, 32, 20,  2,
 1428, 34, 16,  4,
 1429, 24, 23, 18,
 1429, 30, 23,  0,
 1429, 31, 18, 12,
 1429, 32, 18,  9,
 1429, 33, 14, 12,
 1429, 33, 18,  4,
 1430, 26, 23, 15,
 1430, 27, 26,  5,
 1430, 30, 19, 13,
 1430, 30, 23,  1,
 1430, 34, 15,  7,
 1430, 35, 13,  6,
 1430, 35, 14,  3,
 1430, 37,  6,  5,
 1432, 28, 18, 18,
 1432, 36, 10,  6,
 1433, 25, 22, 18,
 1433, 26, 26,  9,
 1433, 29, 24,  4,
 1433, 30, 22,  7,
 1433, 30, 23,  2,
 1433, 32, 20,  3,
 1433, 34, 14,  9,
 1433, 35, 12,  8,
 1433, 36, 11,  4,
 1433, 37,  8,  0,
 1434, 28, 19, 17,
 1434, 28, 23, 11,
 1434, 28, 25,  5,
 1434, 29, 23,  8,
 1434, 32, 17, 11,
 1434, 32, 19,  7,
 1434, 37,  7,  4,
 1434, 37,  8,  1,
 1435, 27, 25,  9,
 1435, 33, 15, 11,
 1437, 26, 20, 19,
 1437, 28, 22, 13,
 1437, 29, 20, 14,
 1437, 34, 16,  5,
 1437, 35, 14,  4,
 1437, 37,  8,  2,
 1438, 27, 22, 15,
 1438, 30, 23,  3,
 1438, 31, 21,  6,
 1438, 33, 18,  5,
 1440, 28, 20, 16,
 1440, 32, 20,  4,
 1440, 36, 12,  0,
 1441, 24, 24, 17,
 1441, 26, 21, 18,
 1441, 27, 26,  6,
 1441, 28, 24,  9,
 1441, 30, 21, 10,
 1441, 36,  9,  8,
 1441, 36, 12,  1,
 1441, 37,  6,  6,
 1442, 29, 24,  5,
 1442, 31, 16, 15,
 1442, 31, 20,  9,
 1442, 33, 17,  8,
 1442, 36, 11,  5,
 1442, 37,  8,  3,
 1443, 25, 23, 17,
 1443, 31, 19, 11,
 1443, 35, 13,  7,
 1443, 37,  7,  5,
 1444, 30, 20, 12,
 1444, 34, 12, 12,
 1444, 36, 12,  2,
 1444, 38,  0,  0,
 1445, 26, 25, 12,
 1445, 28, 25,  6,
 1445, 30, 17, 16,
 1445, 30, 23,  4,
 1445, 31, 22,  0,
 1445, 32, 15, 14,
 1445, 33, 16, 10,
 1445, 34, 15,  8,
 1445, 34, 17,  0,
 1445, 36, 10,  7,
 1445, 38,  1,  0,
 1446, 25, 25, 14,
 1446, 29, 22, 11,
 1446, 31, 17, 14,
 1446, 31, 22,  1,
 1446, 34, 13, 11,
 1446, 34, 17,  1,
 1446, 35, 11, 10,
 1446, 35, 14,  5,
 1446, 38,  1,  1,
 1448, 26, 24, 14,
 1448, 30, 22,  8,
 1448, 32, 18, 10,
 1448, 34, 16,  6,
 1448, 38,  2,  0,
 1449, 26, 22, 17,
 1449, 27, 24, 12,
 1449, 30, 18, 15,
 1449, 31, 22,  2,
 1449, 32, 16, 13,
 1449, 32, 19,  8,
 1449, 32, 20,  5,
 1449, 33, 18,  6,
 1449, 34, 17,  2,
 1449, 36, 12,  3,
 1449, 37,  8,  4,
 1449, 38,  2,  1,
 1450, 28, 21, 15,
 1450, 33, 19,  0,
 1450, 35, 12,  9,
 1450, 35, 15,  0,
 1450, 37,  9,  0,
 1451, 27, 19, 19,
 1451, 29, 21, 13,
 1451, 29, 23,  9,
 1451, 31, 21,  7,
 1451, 33, 19,  1,
 1451, 35, 15,  1,
 1451, 37,  9,  1,
 1452, 22, 22, 22,
 1452, 26, 26, 10,
 1452, 34, 14, 10,
 1452, 38,  2,  2,
 1453, 27, 20, 18,
 1453, 29, 24,  6,
 1453, 36, 11,  6,
 1453, 38,  3,  0,
 1454, 23, 22, 21,
 1454, 27, 23, 14,
 1454, 27, 25, 10,
 1454, 27, 26,  7,
 1454, 29, 18, 17,
 1454, 30, 23,  5,
 1454, 31, 18, 13,
 1454, 31, 22,  3,
 1454, 33, 14, 13,
 1454, 33, 19,  2,
 1454, 34, 17,  3,
 1454, 35, 15,  2,
 1454, 37,  7,  6,
 1454, 37,  9,  2,
 1454, 38,  3,  1,
 1456, 36, 12,  4,
 1457, 25, 24, 16,
 1457, 28, 23, 12,
 1457, 30, 19, 14,
 1457, 32, 17, 12,
 1457, 35, 14,  6,
 1457, 38,  3,  2,
 1458, 23, 23, 20,
 1458, 24, 21, 21,
 1458, 27, 27,  0,
 1458, 28, 25,  7,
 1458, 29, 19, 16,
 1458, 33, 15, 12,
 1458, 35, 13,  8,
 1458, 36,  9,  9,
 1458, 37,  8,  5,
 1459, 27, 21, 17,
 1459, 27, 27,  1,
 1459, 33, 17,  9,
 1459, 33, 19,  3,
 1459, 35, 15,  3,
 1459, 37,  9,  3,
 1460, 24, 22, 20,
 1460, 28, 24, 10,
 1460, 28, 26,  0,
 1460, 32, 20,  6,
 1460, 36, 10,  8,
 1460, 38,  4,  0,
 1461, 26, 23, 16,
 1461, 28, 26,  1,
 1461, 31, 20, 10,
 1461, 31, 22,  4,
 1461, 34, 16,  7,
 1461, 34, 17,  4,
 1461, 38,  4,  1,
 1462, 27, 27,  2,
 1462, 30, 21, 11,
 1462, 33, 18,  7,
 1462, 34, 15,  9,
 1462, 38,  3,  3,
 1464, 28, 22, 14,
 1464, 28, 26,  2,
 1464, 38,  4,  2,
 1465, 30, 22,  9,
 1465, 30, 23,  6,
 1465, 32, 21,  0,
 1465, 36, 12,  5,
 1465, 36, 13,  0,
 1466, 24, 23, 19,
 1466, 25, 21, 20,
 1466, 29, 20, 15,
 1466, 29, 24,  7,
 1466, 29, 25,  0,
 1466, 31, 19, 12,
 1466, 31, 21,  8,
 1466, 32, 19,  9,
 1466, 32, 21,  1,
 1466, 33, 16, 11,
 1466, 33, 19,  4,
 1466, 35, 15,  4,
 1466, 36, 11,  7,
 1466, 36, 13,  1,
 1466, 37,  9,  4,
 1467, 27, 27,  3,
 1467, 29, 25,  1,
 1467, 35, 11, 11,
 1467, 37,  7,  7,
 1469, 27, 22, 16,
 1469, 27, 26,  8,
 1469, 28, 19, 18,
 1469, 28, 26,  3,
 1469, 29, 22, 12,
 1469, 30, 20, 13,
 1469, 32, 18, 11,
 1469, 32, 21,  2,
 1469, 34, 13, 12,
 1469, 35, 12, 10,
 1469, 36, 13,  2,
 1469, 37,  8,  6,
 1469, 37, 10,  0,
 1469, 38,  4,  3,
 1469, 38,  5,  0,
 1470, 25, 22, 19,
 1470, 26, 25, 13,
 1470, 29, 23, 10,
 1470, 29, 25,  2,
 1470, 31, 22,  5,
 1470, 34, 17,  5,
 1470, 35, 14,  7,
 1470, 37, 10,  1,
 1470, 38,  5,  1,
 1473, 26, 26, 11,
 1473, 28, 20, 17,
 1473, 28, 25,  8,
 1473, 31, 16, 16,
 1473, 32, 20,  7,
 1473, 34, 14, 11,
 1473, 37, 10,  2,
 1473, 38,  5,  2,
 1474, 27, 24, 13,
 1474, 27, 27,  4,
 1474, 32, 15, 15,
 1474, 32, 21,  3,
 1474, 36, 13,  3,
 1475, 25, 25, 15,
 1475, 27, 25, 11,
 1475, 29, 25,  3,
 1475, 31, 17, 15,
 1475, 33, 19,  5,
 1475, 35, 13,  9,
 1475, 35, 15,  5,
 1475, 37,  9,  5,
 1476, 24, 24, 18,
 1476, 26, 20, 20,
 1476, 28, 26,  4,
 1476, 30, 24,  0,
 1476, 32, 16, 14,
 1476, 34, 16,  8,
 1476, 36, 12,  6,
 1476, 38,  4,  4,
 1477, 26, 24, 15,
 1477, 30, 24,  1,
 1477, 33, 18,  8,
 1477, 36, 10,  9,
 1478, 25, 23, 18,
 1478, 26, 21, 19,
 1478, 29, 21, 14,
 1478, 30, 17, 17,
 1478, 30, 23,  7,
 1478, 33, 17, 10,
 1478, 37, 10,  3,
 1478, 38,  5,  3,
 1480, 30, 18, 16,
 1480, 30, 24,  2,
 1480, 34, 18,  0,
 1480, 38,  6,  0,
 1481, 28, 21, 16,
 1481, 28, 24, 11,
 1481, 29, 24,  8,
 1481, 31, 18, 14,
 1481, 31, 22,  6,
 1481, 32, 21,  4,
 1481, 33, 14, 14,
 1481, 34, 15, 10,
 1481, 34, 17,  6,
 1481, 34, 18,  1,
 1481, 35, 16,  0,
 1481, 36, 11,  8,
 1481, 36, 13,  4,
 1481, 38,  6,  1,
 1482, 28, 23, 13,
 1482, 29, 25,  4,
 1482, 31, 20, 11,
 1482, 32, 17, 13,
 1482, 35, 16,  1,
 1482, 37,  8,  7,
 1483, 27, 23, 15,
 1483, 27, 27,  5,
 1483, 31, 21,  9,
 1483, 33, 15, 13,
 1484, 26, 22, 18,
 1484, 30, 22, 10,
 1484, 34, 18,  2,
 1484, 38,  6,  2,
 1485, 28, 26,  5,
 1485, 30, 21, 12,
 1485, 30, 24,  3,
 1485, 32, 19, 10,
 1485, 35, 14,  8,
 1485, 35, 16,  2,
 1485, 37, 10,  4,
 1485, 38,  5,  4,
 1486, 27, 26,  9,
 1486, 30, 19, 15,
 1486, 33, 19,  6,
 1486, 35, 15,  6,
 1486, 37,  9,  6,
 1488, 32, 20,  8,
 1489, 29, 18, 18,
 1489, 33, 16, 12,
 1489, 33, 20,  0,
 1489, 34, 18,  3,
 1489, 36, 12,  7,
 1489, 38,  6,  3,
 1490, 25, 24, 17,
 1490, 27, 20, 19,
 1490, 28, 25,  9,
 1490, 31, 23,  0,
 1490, 32, 21,  5,
 1490, 33, 20,  1,
 1490, 35, 12, 11,
 1490, 35, 16,  3,
 1490, 36, 13,  5,
 1490, 37, 11,  0,
 1491, 29, 19, 17,
 1491, 29, 23, 11,
 1491, 29, 25,  5,
 1491, 31, 19, 13,
 1491, 31, 23,  1,
 1491, 37, 11,  1,
 1492, 30, 24,  4,
 1492, 32, 18, 12,
 1492, 36, 14,  0,
 1493, 28, 22, 15,
 1493, 30, 23,  8,
 1493, 33, 20,  2,
 1493, 34, 16,  9,
 1493, 36, 14,  1,
 1493, 38,  7,  0,
 1494, 26, 23, 17,
 1494, 27, 21, 18,
 1494, 27, 27,  6,
 1494, 29, 22, 13,
 1494, 31, 22,  7,
 1494, 31, 23,  2,
 1494, 33, 18,  9,
 1494, 34, 13, 13,
 1494, 34, 17,  7,
 1494, 35, 13, 10,
 1494, 37, 10,  5,
 1494, 37, 11,  2,
 1494, 38,  5,  5,
 1494, 38,  7,  1,
 1496, 26, 26, 12,
 1496, 28, 26,  6,
 1496, 30, 20, 14,
 1496, 34, 14, 12,
 1496, 34, 18,  4,
 1496, 36, 10, 10,
 1496, 36, 14,  2,
 1496, 38,  6,  4,
 1497, 23, 22, 22,
 1497, 26, 25, 14,
 1497, 29, 20, 16,
 1497, 35, 16,  4,
 1497, 37,  8,  8,
 1497, 38,  7,  2,
 1498, 27, 25, 12,
 1498, 29, 24,  9,
 1498, 33, 20,  3,
 1498, 36, 11,  9,
 1499, 23, 23, 21,
 1499, 31, 23,  3,
 1499, 33, 17, 11,
 1499, 33, 19,  7,
 1499, 35, 15,  7,
 1499, 37,  9,  7,
 1499, 37, 11,  3,
 1501, 24, 22, 21,
 1501, 27, 24, 14,
 1501, 30, 24,  5,
 1501, 32, 21,  6,
 1501, 36, 13,  6,
 1501, 36, 14,  3,
 1502, 27, 22, 17,
 1502, 29, 25,  6,
 1502, 31, 21, 10,
 1502, 34, 15, 11,
 1502, 35, 14,  9,
 1502, 38,  7,  3,
 1504, 28, 24, 12,
 1504, 36, 12,  8,
 1505, 24, 23, 20,
 1505, 27, 26, 10,
 1505, 30, 22, 11,
 1505, 31, 20, 12,
 1505, 32, 16, 15,
 1505, 32, 20,  9,
 1505, 33, 20,  4,
 1505, 34, 18,  5,
 1505, 37, 10,  6,
 1505, 38,  6,  5,
 1506, 25, 25, 16,
 1506, 28, 19, 19,
 1506, 31, 17, 16,
 1506, 31, 23,  4,
 1506, 32, 19, 11,
 1506, 35, 16,  5,
 1506, 37, 11,  4,
 1507, 25, 21, 21,
 1507, 27, 27,  7,
 1507, 29, 21, 15,
 1508, 26, 24, 16,
 1508, 28, 20, 18,
 1508, 32, 22,  0,
 1508, 36, 14,  4,
 1508, 38,  8,  0,
 1509, 25, 22, 20,
 1509, 28, 23, 14,
 1509, 28, 25, 10,
 1509, 28, 26,  7,
 1509, 31, 22,  8,
 1509, 32, 17, 14,
 1509, 32, 22,  1,
 1509, 34, 17,  8,
 1509, 38,  7,  4,
 1509, 38,  8,  1,
 1510, 30, 21, 13,
 1510, 30, 23,  9,
 1510, 31, 18, 15,
 1510, 33, 15, 14,
 1512, 30, 24,  6,
 1512, 32, 22,  2,
 1512, 34, 16, 10,
 1512, 38,  8,  2,
 1513, 24, 24, 19,
 1513, 28, 27,  0,
 1513, 30, 18, 17,
 1513, 33, 18, 10,
 1513, 35, 12, 12,
 1513, 37, 12,  0,
 1514, 27, 23, 16,
 1514, 28, 21, 17,
 1514, 28, 27,  1,
 1514, 29, 23, 12,
 1514, 32, 21,  7,
 1514, 33, 16, 13,
 1514, 33, 19,  8,
 1514, 33, 20,  5,
 1514, 35, 15,  8,
 1514, 35, 17,  0,
 1514, 36, 13,  7,
 1514, 37,  9,  8,
 1514, 37, 12,  1,
 1515, 25, 23, 19,
 1515, 29, 25,  7,
 1515, 31, 23,  5,
 1515, 35, 13, 11,
 1515, 35, 17,  1,
 1515, 37, 11,  5,
 1516, 34, 18,  6,
 1516, 38,  6,  6,
 1517, 26, 21, 20,
 1517, 28, 27,  2,
 1517, 29, 24, 10,
 1517, 29, 26,  0,
 1517, 30, 19, 16,
 1517, 32, 18, 13,
 1517, 32, 22,  3,
 1517, 34, 19,  0,
 1517, 35, 16,  6,
 1517, 36, 11, 10,
 1517, 36, 14,  5,
 1517, 37, 12,  2,
 1517, 38,  8,  3,
 1518, 29, 26,  1,
 1518, 31, 19, 14,
 1518, 34, 19,  1,
 1518, 35, 17,  2,
 1518, 37, 10,  7,
 1518, 38,  7,  5,
 1521, 26, 22, 19,
 1521, 26, 26, 13,
 1521, 29, 22, 14,
 1521, 29, 26,  2,
 1521, 34, 14, 13,
 1521, 34, 19,  2,
 1521, 35, 14, 10,
 1521, 36, 12,  9,
 1521, 36, 15,  0,
 1521, 39,  0,  0,
 1522, 27, 27,  8,
 1522, 28, 27,  3,
 1522, 33, 17, 12,
 1522, 36, 15,  1,
 1522, 37, 12,  3,
 1522, 39,  1,  0,
 1523, 27, 25, 13,
 1523, 31, 21, 11,
 1523, 35, 17,  3,
 1523, 39,  1,  1,
 1524, 28, 22, 16,
 1524, 28, 26,  8,
 1524, 32, 20, 10,
 1524, 32, 22,  4,
 1524, 38,  8,  4,
 1525, 25, 24, 18,
 1525, 30, 20, 15,
 1525, 30, 24,  7,
 1525, 30, 25,  0,
 1525, 33, 20,  6,
 1525, 34, 15, 12,
 1525, 36, 15,  2,
 1525, 38,  9,  0,
 1525, 39,  2,  0,
 1526, 26, 25, 15,
 1526, 27, 26, 11,
 1526, 29, 19, 18,
 1526, 29, 26,  3,
 1526, 30, 25,  1,
 1526, 31, 22,  9,
 1526, 31, 23,  6,
 1526, 34, 17,  9,
 1526, 34, 19,  3,
 1526, 37, 11,  6,
 1526, 38,  9,  1,
 1526, 39,  2,  1,
 1528, 30, 22, 12,
 1528, 36, 14,  6,
 1529, 26, 23, 18,
 1529, 27, 20, 20,
 1529, 28, 24, 13,
 1529, 28, 27,  4,
 1529, 30, 23, 10,
 1529, 30, 25,  2,
 1529, 32, 19, 12,
 1529, 32, 21,  8,
 1529, 34, 18,  7,
 1529, 36, 13,  8,
 1529, 37, 12,  4,
 1529, 38,  7,  6,
 1529, 38,  9,  2,
 1529, 39,  2,  2,
 1530, 27, 24, 15,
 1530, 28, 25, 11,
 1530, 29, 20, 17,
 1530, 29, 25,  8,
 1530, 31, 20, 13,
 1530, 33, 21,  0,
 1530, 35, 16,  7,
 1530, 35, 17,  4,
 1530, 36, 15,  3,
 1530, 39,  3,  0,
 1531, 27, 21, 19,
 1531, 33, 19,  9,
 1531, 33, 21,  1,
 1531, 35, 15,  9,
 1531, 37,  9,  9,
 1531, 39,  3,  1,
 1533, 29, 26,  4,
 1533, 32, 22,  5,
 1533, 34, 16, 11,
 1533, 34, 19,  4,
 1533, 37, 10,  8,
 1533, 38,  8,  5,
 1534, 30, 25,  3,
 1534, 33, 18, 11,
 1534, 33, 21,  2,
 1534, 38,  9,  3,
 1534, 39,  3,  2,
 1536, 32, 16, 16,
 1537, 27, 22, 18,
 1537, 30, 21, 14,
 1537, 31, 24,  0,
 1537, 36, 15,  4,
 1537, 39,  4,  0,
 1538, 28, 23, 15,
 1538, 28, 27,  5,
 1538, 29, 21, 16,
 1538, 29, 24, 11,
 1538, 31, 24,  1,
 1538, 32, 17, 15,
 1538, 33, 20,  7,
 1538, 35, 13, 12,
 1538, 36, 11, 11,
 1538, 37, 12,  5,
 1538, 37, 13,  0,
 1538, 39,  4,  1,
 1539, 25, 25, 17,
 1539, 27, 27,  9,
 1539, 29, 23, 13,
 1539, 31, 17, 17,
 1539, 31, 23,  7,
 1539, 33, 15, 15,
 1539, 33, 21,  3,
 1539, 35, 17,  5,
 1539, 37, 11,  7,
 1539, 37, 13,  1,
 1539, 39,  3,  3,
 1540, 30, 24,  8,
 1540, 36, 12, 10,
 1541, 26, 24, 17,
 1541, 28, 26,  9,
 1541, 30, 25,  4,
 1541, 31, 18, 16,
 1541, 31, 24,  2,
 1541, 33, 16, 14,
 1541, 36, 14,  7,
 1541, 38,  9,  4,
 1541, 39,  4,  2,
 1542, 23, 23, 22,
 1542, 29, 26,  5,
 1542, 34, 19,  5,
 1542, 35, 14, 11,
 1542, 37, 13,  2,
 1542, 38,  7,  7,
 1544, 24, 22, 22,
 1544, 32, 18, 14,
 1544, 32, 22,  6,
 1544, 34, 18,  8,
 1544, 38,  8,  6,
 1544, 38, 10,  0,
 1545, 28, 20, 19,
 1545, 31, 22, 10,
 1545, 32, 20, 11,
 1545, 34, 17, 10,
 1545, 35, 16,  8,
 1545, 38, 10,  1,
 1546, 24, 23, 21,
 1546, 31, 21, 12,
 1546, 31, 24,  3,
 1546, 32, 21,  9,
 1546, 33, 21,  4,
 1546, 36, 13,  9,
 1546, 36, 15,  5,
 1546, 39,  4,  3,
 1546, 39,  5,  0,
 1547, 27, 23, 17,
 1547, 29, 25,  9,
 1547, 31, 19, 15,
 1547, 33, 17, 13,
 1547, 37, 13,  3,
 1547, 39,  5,  1,
 1548, 26, 26, 14,
 1548, 30, 18, 18,
 1548, 34, 14, 14,
 1548, 38, 10,  2,
 1549, 27, 26, 12,
 1549, 28, 21, 18,
 1549, 28, 27,  6,
 1549, 35, 18,  0,
 1549, 37, 12,  6,
 1550, 25, 22, 21,
 1550, 27, 25, 14,
 1550, 29, 22, 15,
 1550, 30, 19, 17,
 1550, 30, 23, 11,
 1550, 30, 25,  5,
 1550, 33, 19, 10,
 1550, 34, 15, 13,
 1550, 35, 15, 10,
 1550, 35, 17,  6,
 1550, 35, 18,  1,
 1550, 37, 10,  9,
 1550, 38,  9,  5,
 1550, 39,  5,  2,
 1552, 24, 24, 20,
 1552, 36, 16,  0,
 1553, 28, 25, 12,
 1553, 29, 26,  6,
 1553, 30, 22, 13,
 1553, 31, 24,  4,
 1553, 32, 23,  0,
 1553, 33, 20,  8,
 1553, 34, 19,  6,
 1553, 35, 18,  2,
 1553, 36, 16,  1,
 1553, 38, 10,  3,
 1553, 39,  4,  4,
 1554, 25, 23, 20,
 1554, 31, 23,  8,
 1554, 32, 19, 13,
 1554, 32, 23,  1,
 1554, 37, 11,  8,
 1554, 37, 13,  4,
 1555, 33, 21,  5,
 1555, 39,  5,  3,
 1556, 28, 24, 14,
 1556, 30, 20, 16,
 1556, 34, 16, 12,
 1556, 34, 20,  0,
 1556, 36, 14,  8,
 1556, 36, 16,  2,
 1557, 26, 25, 16,
 1557, 28, 22, 17,
 1557, 30, 24,  9,
 1557, 31, 20, 14,
 1557, 32, 22,  7,
 1557, 32, 23,  2,
 1557, 33, 18, 12,
 1557, 34, 20,  1,
 1557, 36, 15,  6,
 1557, 38,  8,  7,
 1557, 39,  6,  0,
 1558, 26, 21, 21,
 1558, 27, 27, 10,
 1558, 35, 18,  3,
 1558, 39,  6,  1,
 1560, 26, 22, 20,
 1560, 28, 26, 10,
 1560, 34, 20,  2,
 1560, 38, 10,  4,
 1561, 27, 24, 16,
 1561, 29, 24, 12,
 1561, 30, 25,  6,
 1561, 34, 18,  9,
 1561, 36, 12, 11,
 1561, 36, 16,  3,
 1561, 38,  9,  6,
 1561, 39,  6,  2,
 1562, 25, 24, 19,
 1562, 28, 27,  7,
 1562, 31, 24,  5,
 1562, 32, 23,  3,
 1562, 35, 16,  9,
 1562, 37, 12,  7,
 1562, 39,  5,  4,
 1563, 29, 19, 19,
 1563, 35, 13, 13,
 1563, 35, 17,  7,
 1563, 37, 13,  5,
 1565, 29, 20, 18,
 1565, 32, 21, 10,
 1565, 34, 20,  3,
 1565, 35, 14, 12,
 1565, 35, 18,  4,
 1565, 36, 13, 10,
 1565, 37, 14,  0,
 1565, 38, 11,  0,
 1566, 26, 23, 19,
 1566, 29, 23, 14,
 1566, 29, 25, 10,
 1566, 29, 26,  7,
 1566, 30, 21, 15,
 1566, 31, 22, 11,
 1566, 33, 21,  6,
 1566, 34, 17, 11,
 1566, 34, 19,  7,
 1566, 37, 14,  1,
 1566, 38, 11,  1,
 1566, 39,  6,  3,
 1568, 28, 28,  0,
 1568, 32, 20, 12,
 1568, 36, 16,  4,
 1569, 28, 23, 16,
 1569, 28, 28,  1,
 1569, 32, 17, 16,
 1569, 32, 23,  4,
 1569, 37, 10, 10,
 1569, 37, 14,  2,
 1569, 38, 10,  5,
 1569, 38, 11,  2,
 1570, 27, 21, 20,
 1570, 29, 27,  0,
 1570, 33, 16, 15,
 1570, 33, 20,  9,
 1570, 36, 15,  7,
 1570, 39,  7,  0,
 1571, 29, 21, 17,
 1571, 29, 27,  1,
 1571, 31, 21, 13,
 1571, 31, 23,  9,
 1571, 33, 19, 11,
 1571, 35, 15, 11,
 1571, 37, 11,  9,
 1571, 39,  5,  5,
 1571, 39,  7,  1,
 1572, 28, 28,  2,
 1572, 32, 22,  8,
 1572, 34, 20,  4,
 1572, 38,  8,  8,
 1573, 30, 23, 12,
 1573, 31, 24,  6,
 1573, 32, 18, 15,
 1573, 33, 22,  0,
 1573, 36, 14,  9,
 1573, 39,  6,  4,
 1574, 25, 25, 18,
 1574, 27, 22, 19,
 1574, 27, 26, 13,
 1574, 29, 27,  2,
 1574, 30, 25,  7,
 1574, 31, 18, 17,
 1574, 33, 17, 14,
 1574, 33, 22,  1,
 1574, 35, 18,  5,
 1574, 37, 13,  6,
 1574, 37, 14,  3,
 1574, 38,  9,  7,
 1574, 38, 11,  3,
 1574, 39,  7,  2,
 1576, 26, 24, 18,
 1576, 30, 24, 10,
 1576, 30, 26,  0,
 1577, 26, 26, 15,
 1577, 28, 27,  8,
 1577, 28, 28,  3,
 1577, 30, 26,  1,
 1577, 33, 22,  2,
 1577, 34, 15, 14,
 1577, 36, 16,  5,
 1577, 37, 12,  8,
 1578, 28, 25, 13,
 1578, 31, 19, 16,
 1578, 32, 23,  5,
 1578, 35, 17,  8,
 1579, 27, 25, 15,
 1579, 27, 27, 11,
 1579, 29, 27,  3,
 1579, 33, 21,  7,
 1579, 39,  7,  3,
 1580, 30, 22, 14,
 1580, 30, 26,  2,
 1580, 34, 18, 10,
 1580, 38, 10,  6,
 1581, 28, 26, 11,
 1581, 29, 22, 16,
 1581, 29, 26,  8,
 1581, 32, 19, 14,
 1581, 34, 16, 13,
 1581, 34, 19,  8,
 1581, 34, 20,  5,
 1581, 35, 16, 10,
 1581, 37, 14,  4,
 1581, 38, 11,  4,
 1582, 27, 23, 18,
 1582, 33, 18, 13,
 1582, 33, 22,  3,
 1582, 39,  6,  5,
 1584, 28, 20, 20,
 1584, 28, 28,  4,
 1584, 36, 12, 12,
 1585, 28, 24, 15,
 1585, 30, 19, 18,
 1585, 30, 26,  3,
 1585, 35, 18,  6,
 1585, 36, 15,  8,
 1585, 36, 17,  0,
 1585, 39,  8,  0,
 1586, 28, 21, 19,
 1586, 29, 24, 13,
 1586, 29, 27,  4,
 1586, 31, 20, 15,
 1586, 31, 24,  7,
 1586, 31, 25,  0,
 1586, 32, 21, 11,
 1586, 35, 19,  0,
 1586, 36, 13, 11,
 1586, 36, 17,  1,
 1586, 39,  7,  4,
 1586, 39,  8,  1,
 1587, 23, 23, 23,
 1587, 29, 25, 11,
 1587, 31, 25,  1,
 1587, 35, 19,  1,
 1587, 37, 13,  7,
 1588, 36, 16,  6,
 1588, 38, 12,  0,
 1589, 24, 23, 22,
 1589, 30, 20, 17,
 1589, 30, 25,  8,
 1589, 31, 22, 12,
 1589, 32, 22,  9,
 1589, 32, 23,  6,
 1589, 33, 20, 10,
 1589, 33, 22,  4,
 1589, 34, 17, 12,
 1589, 36, 17,  2,
 1589, 38,  9,  8,
 1589, 38, 12,  1,
 1589, 39,  8,  2,
 1590, 26, 25, 17,
 1590, 31, 23, 10,
 1590, 31, 25,  2,
 1590, 35, 14, 13,
 1590, 35, 19,  2,
 1590, 37, 11, 10,
 1590, 37, 14,  5,
 1590, 38, 11,  5,
 1592, 28, 22, 18,
 1592, 30, 26,  4,
 1592, 34, 20,  6,
 1592, 36, 14, 10,
 1592, 38, 12,  2,
 1593, 24, 24, 21,
 1593, 25, 22, 22,
 1593, 28, 28,  5,
 1593, 32, 20, 13,
 1593, 38, 10,  7,
 1593, 39,  6,  6,
 1594, 27, 24, 17,
 1594, 28, 27,  9,
 1594, 33, 19, 12,
 1594, 33, 21,  8,
 1594, 35, 15, 12,
 1594, 36, 17,  3,
 1594, 37, 12,  9,
 1594, 37, 15,  0,
 1594, 39,  8,  3,
 1595, 25, 23, 21,
 1595, 29, 23, 15,
 1595, 29, 27,  5,
 1595, 31, 25,  3,
 1595, 35, 17,  9,
 1595, 35, 19,  3,
 1595, 37, 15,  1,
 1595, 39,  7,  5,
 1597, 30, 21, 16,
 1597, 30, 24, 11,
 1597, 34, 21,  0,
 1597, 38, 12,  3,
 1598, 29, 26,  9,
 1598, 30, 23, 13,
 1598, 31, 21, 14,
 1598, 33, 22,  5,
 1598, 34, 19,  9,
 1598, 34, 21,  1,
 1598, 35, 18,  7,
 1598, 37, 15,  2,
 1600, 32, 24,  0,
 1600, 40,  0,  0,
 1601, 25, 24, 20,
 1601, 26, 22, 21,
 1601, 27, 26, 14,
 1601, 30, 26,  5,
 1601, 31, 24,  8,
 1601, 32, 24,  1,
 1601, 33, 16, 16,
 1601, 34, 18, 11,
 1601, 34, 21,  2,
 1601, 36, 16,  7,
 1601, 36, 17,  4,
 1601, 37, 14,  6,
 1601, 38, 11,  6,
 1601, 39,  8,  4,
 1601, 40,  1,  0,
 1602, 27, 27, 12,
 1602, 28, 23, 17,
 1602, 29, 20, 19,
 1602, 31, 25,  4,
 1602, 32, 17, 17,
 1602, 32, 23,  7,
 1602, 35, 16, 11,
 1602, 35, 19,  4,
 1602, 36, 15,  9,
 1602, 37, 13,  8,
 1602, 39,  9,  0,
 1602, 40,  1,  1,
 1603, 33, 17, 15,
 1603, 37, 15,  3,
 1603, 39,  9,  1,
 1604, 28, 26, 12,
 1604, 28, 28,  6,
 1604, 32, 18, 16,
 1604, 32, 24,  2,
 1604, 38, 12,  4,
 1604, 40,  2,  0,
 1605, 26, 23, 20,
 1605, 28, 25, 14,
 1605, 34, 20,  7,
 1605, 40,  2,  1,
 1606, 29, 21, 18,
 1606, 29, 27,  6,
 1606, 30, 25,  9,
 1606, 34, 15, 15,
 1606, 34, 21,  3,
 1606, 38,  9,  9,
 1606, 39,  7,  6,
 1606, 39,  9,  2,
 1608, 26, 26, 16,
 1608, 32, 22, 10,
 1608, 34, 16, 14,
 1608, 38, 10,  8,
 1608, 40,  2,  2,
 1609, 30, 22, 15,
 1609, 31, 18, 18,
 1609, 32, 21, 12,
 1609, 32, 24,  3,
 1609, 33, 18, 14,
 1609, 33, 22,  6,
 1609, 36, 13, 12,
 1609, 40,  3,  0,
 1610, 27, 25, 16,
 1610, 29, 25, 12,
 1610, 32, 19, 15,
 1610, 33, 20, 11,
 1610, 36, 17,  5,
 1610, 37, 15,  4,
 1610, 39,  8,  5,
 1610, 40,  3,  1,
 1611, 25, 25, 19,
 1611, 27, 21, 21,
 1611, 31, 19, 17,
 1611, 31, 23, 11,
 1611, 31, 25,  5,
 1611, 33, 21,  9,
 1611, 35, 19,  5,
 1611, 37, 11, 11,
 1611, 39,  9,  3,
 1612, 30, 26,  6,
 1613, 26, 24, 19,
 1613, 27, 22, 20,
 1613, 28, 27, 10,
 1613, 29, 24, 14,
 1613, 34, 21,  4,
 1613, 35, 18,  8,
 1613, 36, 14, 11,
 1613, 37, 12, 10,
 1613, 38, 12,  5,
 1613, 38, 13,  0,
 1613, 40,  3,  2,
 1614, 29, 22, 17,
 1614, 31, 22, 13,
 1614, 34, 17, 13,
 1614, 35, 17, 10,
 1614, 37, 14,  7,
 1614, 38, 11,  7,
 1614, 38, 13,  1,
 1616, 28, 24, 16,
 1616, 32, 24,  4,
 1616, 36, 16,  8,
 1616, 40,  4,  0,
 1617, 28, 28,  7,
 1617, 29, 26, 10,
 1617, 31, 20, 16,
 1617, 32, 23,  8,
 1617, 34, 19, 10,
 1617, 35, 14, 14,
 1617, 38, 13,  2,
 1617, 40,  4,  1,
 1618, 31, 24,  9,
 1618, 33, 23,  0,
 1618, 39,  9,  4,
 1618, 40,  3,  3,
 1619, 27, 23, 19,
 1619, 29, 27,  7,
 1619, 33, 19, 13,
 1619, 33, 23,  1,
 1619, 35, 15, 13,
 1619, 37, 13,  9,
 1619, 37, 15,  5,
 1619, 39,  7,  7,
 1620, 30, 24, 12,
 1620, 32, 20, 14,
 1620, 34, 20,  8,
 1620, 36, 18,  0,
 1620, 40,  4,  2,
 1621, 36, 15, 10,
 1621, 36, 17,  6,
 1621, 36, 18,  1,
 1621, 39,  8,  6,
 1621, 39, 10,  0,
 1622, 30, 19, 19,
 1622, 31, 25,  6,
 1622, 33, 22,  7,
 1622, 33, 23,  2,
 1622, 34, 21,  5,
 1622, 35, 19,  6,
 1622, 38, 13,  3,
 1622, 39, 10,  1,
 1624, 30, 20, 18,
 1624, 34, 18, 12,
 1624, 36, 18,  2,
 1624, 38, 12,  6,
 1625, 26, 25, 18,
 1625, 28, 21, 20,
 1625, 29, 28,  0,
 1625, 30, 23, 14,
 1625, 30, 25, 10,
 1625, 30, 26,  7,
 1625, 32, 24,  5,
 1625, 35, 16, 12,
 1625, 35, 20,  0,
 1625, 37, 16,  0,
 1625, 38, 10,  9,
 1625, 39, 10,  2,
 1625, 40,  4,  3,
 1625, 40,  5,  0,
 1626, 29, 23, 16,
 1626, 29, 28,  1,
 1626, 35, 20,  1,
 1626, 37, 16,  1,
 1626, 40,  5,  1,
 1627, 27, 27, 13,
 1627, 31, 21, 15,
 1627, 33, 23,  3,
 1627, 39,  9,  5,
 1629, 27, 24, 18,
 1629, 28, 22, 19,
 1629, 28, 26, 13,
 1629, 29, 28,  2,
 1629, 30, 27,  0,
 1629, 32, 22, 11,
 1629, 35, 20,  2,
 1629, 36, 18,  3,
 1629, 37, 14,  8,
 1629, 37, 16,  2,
 1629, 38, 11,  8,
 1629, 38, 13,  4,
 1629, 40,  5,  2,
 1630, 27, 26, 15,
 1630, 30, 21, 17,
 1630, 30, 27,  1,
 1630, 33, 21, 10,
 1630, 35, 18,  9,
 1630, 37, 15,  6,
 1630, 39, 10,  3,
 1632, 28, 28,  8,
 1632, 40,  4,  4,
 1633, 30, 27,  2,
 1633, 33, 20, 12,
 1633, 34, 21,  6,
 1633, 36, 16,  9,
 1634, 24, 23, 23,
 1634, 28, 25, 15,
 1634, 28, 27, 11,
 1634, 29, 27,  8,
 1634, 29, 28,  3,
 1634, 31, 23, 12,
 1634, 32, 21, 13,
 1634, 32, 23,  9,
 1634, 33, 17, 16,
 1634, 33, 23,  4,
 1634, 35, 20,  3,
 1634, 36, 13, 13,
 1634, 36, 17,  7,
 1634, 37, 12, 11,
 1634, 37, 16,  3,
 1634, 39,  8,  7,
 1634, 40,  5,  3,
 1635, 29, 25, 13,
 1635, 31, 25,  7,
 1635, 35, 17, 11,
 1635, 35, 19,  7,
 1636, 24, 24, 22,
 1636, 32, 24,  6,
 1636, 36, 14, 12,
 1636, 36, 18,  4,
 1636, 40,  6,  0,
 1637, 28, 23, 18,
 1637, 31, 24, 10,
 1637, 31, 26,  0,
 1637, 32, 18, 17,
 1637, 33, 22,  8,
 1637, 34, 16, 15,
 1637, 34, 20,  9,
 1637, 38, 12,  7,
 1637, 39, 10,  4,
 1637, 40,  6,  1,
 1638, 25, 23, 22,
 1638, 29, 26, 11,
 1638, 30, 27,  3,
 1638, 31, 26,  1,
 1638, 33, 18, 15,
 1638, 34, 19, 11,
 1638, 37, 13, 10,
 1638, 38, 13,  5,
 1638, 39,  9,  6,
 1640, 30, 22, 16,
 1640, 30, 26,  8,
 1640, 34, 22,  0,
 1640, 38, 14,  0,
 1640, 40,  6,  2,
 1641, 26, 26, 17,
 1641, 29, 20, 20,
 1641, 29, 28,  4,
 1641, 31, 22, 14,
 1641, 31, 26,  2,
 1641, 32, 19, 16,
 1641, 34, 17, 14,
 1641, 34, 22,  1,
 1641, 35, 20,  4,
 1641, 37, 16,  4,
 1641, 38, 14,  1,
 1641, 40,  5,  4,
 1642, 25, 24, 21,
 1642, 29, 24, 15,
 1642, 36, 15, 11,
 1642, 39, 11,  0,
 1643, 27, 25, 17,
 1643, 29, 21, 19,
 1643, 33, 23,  5,
 1643, 37, 15,  7,
 1643, 39, 11,  1,
 1644, 26, 22, 22,
 1644, 34, 22,  2,
 1644, 38, 10, 10,
 1644, 38, 14,  2,
 1645, 30, 24, 13,
 1645, 30, 27,  4,
 1645, 36, 18,  5,
 1645, 40,  6,  3,
 1646, 26, 23, 21,
 1646, 30, 25, 11,
 1646, 31, 19, 18,
 1646, 31, 26,  3,
 1646, 33, 19, 14,
 1646, 34, 21,  7,
 1646, 35, 15, 14,
 1646, 37, 14,  9,
 1646, 38, 11,  9,
 1646, 39, 10,  5,
 1646, 39, 11,  2,
 1649, 28, 24, 17,
 1649, 28, 28,  9,
 1649, 29, 22, 18,
 1649, 32, 20, 15,
 1649, 32, 24,  7,
 1649, 32, 25,  0,
 1649, 34, 18, 13,
 1649, 34, 22,  3,
 1649, 35, 18, 10,
 1649, 36, 17,  8,
 1649, 38, 13,  6,
 1649, 38, 14,  3,
 1649, 39,  8,  8,
 1649, 40,  7,  0,
 1650, 25, 25, 20,
 1650, 29, 28,  5,
 1650, 31, 20, 17,
 1650, 31, 25,  8,
 1650, 32, 25,  1,
 1650, 35, 16, 13,
 1650, 35, 19,  8,
 1650, 35, 20,  5,
 1650, 37, 16,  5,
 1650, 40,  5,  5,
 1650, 40,  7,  1,
 1651, 29, 27,  9,
 1651, 33, 21, 11,
 1651, 39,  9,  7,
 1651, 39, 11,  3,
 1652, 26, 24, 20,
 1652, 32, 22, 12,
 1652, 36, 16, 10,
 1652, 38, 12,  8,
 1652, 40,  6,  4,
 1653, 31, 26,  4,
 1653, 32, 23, 10,
 1653, 32, 25,  2,
 1653, 40,  7,  2,
 1654, 27, 22, 21,
 1654, 27, 27, 14,
 1654, 30, 23, 15,
 1654, 30, 27,  5,
 1654, 33, 22,  9,
 1654, 33, 23,  6,
 1656, 28, 26, 14,
 1656, 34, 20, 10,
 1656, 34, 22,  4,
 1656, 36, 18,  6,
 1656, 38, 14,  4,
 1657, 28, 27, 12,
 1657, 30, 26,  9,
 1657, 36, 19,  0,
 1657, 37, 12, 12,
 1657, 39, 10,  6,
 1658, 27, 23, 20,
 1658, 31, 21, 16,
 1658, 31, 24, 11,
 1658, 32, 25,  3,
 1658, 33, 20, 13,
 1658, 35, 17, 12,
 1658, 36, 19,  1,
 1658, 37, 15,  8,
 1658, 37, 17,  0,
 1658, 39, 11,  4,
 1658, 40,  7,  3,
 1659, 29, 23, 17,
 1659, 31, 23, 13,
 1659, 37, 13, 11,
 1659, 37, 17,  1,
 1661, 27, 26, 16,
 1661, 29, 26, 12,
 1661, 29, 28,  6,
 1661, 30, 20, 19,
 1661, 32, 21, 14,
 1661, 34, 19, 12,
 1661, 34, 21,  8,
 1661, 35, 20,  6,
 1661, 36, 14, 13,
 1661, 36, 19,  2,
 1661, 37, 16,  6,
 1661, 40,  6,  5,
 1662, 26, 25, 19,
 1662, 29, 25, 14,
 1662, 31, 26,  5,
 1662, 37, 17,  2,
 1662, 38, 13,  7,
 1664, 32, 24,  8,
 1664, 40,  8,  0,
 1665, 28, 25, 16,
 1665, 30, 21, 18,
 1665, 30, 27,  6,
 1665, 32, 25,  4,
 1665, 33, 24,  0,
 1665, 34, 22,  5,
 1665, 36, 15, 12,
 1665, 37, 14, 10,
 1665, 38, 11, 10,
 1665, 38, 14,  5,
 1665, 39, 12,  0,
 1665, 40,  7,  4,
 1665, 40,  8,  1,
 1666, 27, 24, 19,
 1666, 28, 21, 21,
 1666, 33, 24,  1,
 1666, 35, 21,  0,
 1666, 36, 17,  9,
 1666, 36, 19,  3,
 1666, 39,  9,  8,
 1666, 39, 12,  1,
 1667, 31, 25,  9,
 1667, 33, 17, 17,
 1667, 33, 23,  7,
 1667, 35, 19,  9,
 1667, 35, 21,  1,
 1667, 37, 17,  3,
 1667, 39, 11,  5,
 1668, 28, 22, 20,
 1668, 28, 28, 10,
 1668, 34, 16, 16,
 1668, 40,  8,  2,
 1669, 30, 25, 12,
 1669, 33, 18, 16,
 1669, 33, 24,  2,
 1669, 36, 18,  7,
 1669, 38, 12,  9,
 1669, 38, 15,  0,
 1669, 39, 12,  2,
 1670, 29, 27, 10,
 1670, 31, 22, 15,
 1670, 34, 17, 15,
 1670, 35, 18, 11,
 1670, 35, 21,  2,
 1670, 38, 15,  1,
 1670, 39, 10,  7,
 1672, 30, 24, 14,
 1672, 32, 18, 18,
 1672, 40,  6,  6,
 1673, 29, 24, 16,
 1673, 30, 22, 17,
 1673, 31, 26,  6,
 1673, 33, 22, 10,
 1673, 36, 16, 11,
 1673, 36, 19,  4,
 1673, 38, 15,  2,
 1673, 40,  8,  3,
 1674, 28, 23, 19,
 1674, 29, 28,  7,
 1674, 32, 19, 17,
 1674, 32, 23, 11,
 1674, 32, 25,  5,
 1674, 33, 21, 12,
 1674, 33, 24,  3,
 1674, 35, 20,  7,
 1674, 37, 16,  7,
 1674, 37, 17,  4,
 1674, 39, 12,  3,
 1674, 40,  7,  5,
 1675, 33, 19, 15,
 1675, 35, 15, 15,
 1675, 35, 21,  3,
 1675, 37, 15,  9,
 1676, 26, 26, 18,
 1676, 30, 26, 10,
 1676, 34, 18, 14,
 1676, 34, 22,  6,
 1676, 38, 14,  6,
 1677, 32, 22, 13,
 1677, 34, 20, 11,
 1677, 35, 16, 14,
 1677, 38, 13,  8,
 1678, 27, 25, 18,
 1678, 30, 27,  7,
 1678, 34, 21,  9,
 1678, 38, 15,  3,
 1678, 39, 11,  6,
 1680, 32, 20, 16,
 1680, 40,  8,  4,
 1681, 24, 24, 23,
 1681, 31, 24, 12,
 1681, 32, 24,  9,
 1681, 33, 24,  4,
 1681, 39, 12,  4,
 1681, 40,  9,  0,
 1682, 28, 27, 13,
 1682, 29, 21, 20,
 1682, 29, 29,  0,
 1682, 33, 23,  8,
 1682, 35, 21,  4,
 1682, 36, 19,  5,
 1682, 37, 13, 12,
 1682, 40,  9,  1,
 1683, 25, 23, 23,
 1683, 27, 27, 15,
 1683, 29, 29,  1,
 1683, 31, 19, 19,
 1683, 35, 17, 13,
 1683, 37, 17,  5,
 1683, 39,  9,  9,
 1684, 28, 24, 18,
 1684, 30, 28,  0,
 1684, 36, 18,  8,
 1685, 25, 24, 22,
 1685, 28, 26, 15,
 1685, 30, 23, 16,
 1685, 30, 28,  1,
 1685, 31, 20, 18,
 1685, 32, 25,  6,
 1685, 33, 20, 14,
 1685, 34, 23,  0,
 1685, 36, 17, 10,
 1685, 38, 15,  4,
 1685, 39, 10,  8,
 1685, 40,  7,  6,
 1685, 40,  9,  2,
 1686, 29, 22, 19,
 1686, 29, 26, 13,
 1686, 29, 29,  2,
 1686, 31, 23, 14,
 1686, 31, 25, 10,
 1686, 31, 26,  7,
 1686, 34, 19, 13,
 1686, 34, 23,  1,
 1686, 35, 19, 10,
 1686, 37, 14, 11,
 1686, 38, 11, 11,
 1688, 30, 28,  2,
 1688, 36, 14, 14,
 1688, 38, 12, 10,
 1689, 26, 23, 22,
 1689, 28, 28, 11,
 1689, 29, 28,  8,
 1689, 34, 22,  7,
 1689, 34, 23,  2,
 1689, 35, 20,  8,
 1689, 37, 16,  8,
 1689, 38, 14,  7,
 1689, 40,  8,  5,
 1690, 31, 27,  0,
 1690, 32, 21, 15,
 1690, 33, 24,  5,
 1690, 36, 15, 13,
 1690, 39, 12,  5,
 1690, 39, 13,  0,
 1690, 40,  9,  3,
 1691, 25, 25, 21,
 1691, 29, 25, 15,
 1691, 29, 27, 11,
 1691, 29, 29,  3,
 1691, 31, 21, 17,
 1691, 31, 27,  1,
 1691, 35, 21,  5,
 1691, 39, 11,  7,
 1691, 39, 13,  1,
 1693, 26, 24, 21,
 1693, 30, 27,  8,
 1693, 30, 28,  3,
 1693, 35, 18, 12,
 1693, 36, 19,  6,
 1693, 37, 18,  0,
 1694, 27, 26, 17,
 1694, 29, 23, 18,
 1694, 30, 25, 13,
 1694, 31, 27,  2,
 1694, 33, 22, 11,
 1694, 34, 23,  3,
 1694, 37, 15, 10,
 1694, 37, 17,  6,
 1694, 37, 18,  1,
 1694, 38, 13,  9,
 1694, 38, 15,  5,
 1694, 39, 13,  2,
 1696, 36, 16, 12,
 1696, 36, 20,  0,
 1697, 27, 22, 22,
 1697, 30, 26, 11,
 1697, 32, 23, 12,
 1697, 34, 21, 10,
 1697, 36, 20,  1,
 1697, 37, 18,  2,
 1697, 40,  9,  4,
 1698, 28, 25, 17,
 1698, 29, 29,  4,
 1698, 32, 25,  7,
 1698, 40,  7,  7,
 1699, 27, 23, 21,
 1699, 31, 27,  3,
 1699, 33, 21, 13,
 1699, 33, 23,  9,
 1699, 39, 13,  3,
 1700, 30, 20, 20,
 1700, 30, 28,  4,
 1700, 32, 24, 10,
 1700, 32, 26,  0,
 1700, 34, 20, 12,
 1700, 36, 20,  2,
 1700, 38, 16,  0,
 1700, 40,  8,  6,
 1700, 40, 10,  0,
 1701, 26, 25, 20,
 1701, 30, 24, 15,
 1701, 31, 22, 16,
 1701, 31, 26,  8,
 1701, 32, 26,  1,
 1701, 33, 24,  6,
 1701, 34, 17, 16,
 1701, 34, 23,  4,
 1701, 36, 18,  9,
 1701, 38, 16,  1,
 1701, 39, 12,  6,
 1701, 40, 10,  1,
 1702, 30, 21, 19,
 1702, 33, 18, 17,
 1702, 35, 21,  6,
 1702, 37, 18,  3,
 1702, 39, 10,  9,
 1704, 32, 22, 14,
 1704, 32, 26,  2,
 1704, 34, 22,  8,
 1704, 38, 14,  8,
 1704, 38, 16,  2,
 1704, 40, 10,  2,
 1705, 27, 24, 20,
 1705, 34, 18, 15,
 1705, 36, 20,  3,
 1705, 38, 15,  6,
 1706, 29, 24, 17,
 1706, 29, 28,  9,
 1706, 31, 24, 13,
 1706, 31, 27,  4,
 1706, 33, 19, 16,
 1706, 35, 16, 15,
 1706, 35, 20,  9,
 1706, 36, 17, 11,
 1706, 36, 19,  7,
 1706, 37, 16,  9,
 1706, 39, 11,  8,
 1706, 39, 13,  4,
 1706, 40,  9,  5,
 1707, 29, 29,  5,
 1707, 31, 25, 11,
 1707, 35, 19, 11,
 1707, 37, 13, 13,
 1707, 37, 17,  7,
 1708, 30, 22, 18,
 1709, 28, 22, 21,
 1709, 28, 27, 14,
 1709, 30, 28,  5,
 1709, 32, 19, 18,
 1709, 32, 26,  3,
 1709, 35, 22,  0,
 1709, 37, 14, 12,
 1709, 37, 18,  4,
 1709, 38, 12, 11,
 1709, 38, 16,  3,
 1709, 40, 10,  3,
 1710, 30, 27,  9,
 1710, 34, 23,  5,
 1710, 35, 17, 14,
 1710, 35, 22,  1,
 1712, 28, 28, 12,
 1712, 36, 20,  4,
 1713, 26, 26, 19,
 1713, 28, 23, 20,
 1713, 29, 26, 14,
 1713, 32, 20, 17,
 1713, 32, 25,  8,
 1713, 34, 19, 14,
 1713, 35, 22,  2,
 1713, 38, 13, 10,
 1713, 40,  8,  7,
 1714, 27, 27, 16,
 1714, 29, 27, 12,
 1714, 33, 20, 15,
 1714, 33, 24,  7,
 1714, 33, 25,  0,
 1714, 39, 12,  7,
 1715, 27, 25, 19,
 1715, 31, 23, 15,
 1715, 31, 27,  5,
 1715, 33, 25,  1,
 1715, 35, 21,  7,
 1715, 37, 15, 11,
 1715, 39, 13,  5,
 1716, 28, 26, 16,
 1716, 32, 26,  4,
 1716, 38, 16,  4,
 1716, 40, 10,  4,
 1717, 33, 22, 12,
 1717, 36, 15, 14,
 1717, 39, 14,  0,
 1717, 40,  9,  6,
 1718, 29, 29,  6,
 1718, 30, 23, 17,
 1718, 31, 26,  9,
 1718, 33, 23, 10,
 1718, 33, 25,  2,
 1718, 34, 21, 11,
 1718, 35, 18, 13,
 1718, 35, 22,  3,
 1718, 37, 18,  5,
 1718, 38, 15,  7,
 1718, 39, 14,  1,
 1720, 30, 26, 12,
 1720, 30, 28,  6,
 1720, 36, 18, 10,
 1721, 28, 24, 19,
 1721, 30, 25, 14,
 1721, 32, 21, 16,
 1721, 32, 24, 11,
 1721, 34, 22,  9,
 1721, 34, 23,  6,
 1721, 36, 16, 13,
 1721, 36, 19,  8,
 1721, 36, 20,  5,
 1721, 38, 14,  9,
 1721, 39, 10, 10,
 1721, 39, 14,  2,
 1721, 40, 11,  0,
 1722, 29, 25, 16,
 1722, 31, 20, 19,
 1722, 32, 23, 13,
 1722, 37, 17,  8,
 1722, 40, 11,  1,
 1723, 29, 21, 21,
 1723, 33, 25,  3,
 1723, 39, 11,  9,
 1725, 29, 22, 20,
 1725, 29, 28, 10,
 1725, 32, 26,  5,
 1725, 34, 20, 13,
 1725, 35, 20, 10,
 1725, 35, 22,  4,
 1725, 37, 16, 10,
 1725, 38, 16,  5,
 1725, 40, 10,  5,
 1725, 40, 11,  2,
 1726, 31, 21, 18,
 1726, 31, 27,  6,
 1726, 33, 21, 14,
 1726, 39, 13,  6,
 1726, 39, 14,  3,
 1728, 24, 24, 24,
 1728, 40,  8,  8,
 1729, 27, 26, 18,
 1729, 30, 27, 10,
 1729, 33, 24,  8,
 1729, 36, 17, 12,
 1729, 37, 18,  6,
 1729, 39, 12,  8,
 1730, 25, 24, 23,
 1730, 31, 25, 12,
 1730, 32, 25,  9,
 1730, 33, 25,  4,
 1730, 35, 19, 12,
 1730, 35, 21,  8,
 1730, 37, 19,  0,
 1730, 40,  9,  7,
 1730, 40, 11,  3,
 1731, 29, 23, 19,
 1731, 29, 29,  7,
 1731, 37, 19,  1,
 1732, 30, 24, 16,
 1732, 34, 24,  0,
 1732, 36, 20,  6,
 1732, 38, 12, 12,
 1733, 28, 25, 18,
 1733, 30, 28,  7,
 1733, 31, 24, 14,
 1733, 32, 22, 15,
 1733, 34, 24,  1,
 1733, 38, 15,  8,
 1733, 38, 17,  0,
 1733, 39, 14,  4,
 1734, 25, 25, 22,
 1734, 26, 23, 23,
 1734, 31, 22, 17,
 1734, 34, 17, 17,
 1734, 34, 23,  7,
 1734, 35, 22,  5,
 1734, 37, 14, 13,
 1734, 37, 19,  2,
 1734, 38, 13, 11,
 1734, 38, 17,  1,
 1736, 26, 24, 22,
 1736, 32, 26,  6,
 1736, 34, 18, 16,
 1736, 34, 24,  2,
 1736, 38, 16,  6,
 1736, 40, 10,  6,
 1737, 28, 28, 13,
 1737, 31, 26, 10,
 1737, 33, 18, 18,
 1737, 35, 16, 16,
 1737, 36, 21,  0,
 1737, 38, 17,  2,
 1737, 40, 11,  4,
 1738, 28, 27, 15,
 1738, 36, 19,  9,
 1738, 36, 21,  1,
 1738, 37, 15, 12,
 1739, 29, 27, 13,
 1739, 31, 27,  7,
 1739, 33, 19, 17,
 1739, 33, 23, 11,
 1739, 33, 25,  5,
 1739, 35, 17, 15,
 1739, 37, 17,  9,
 1739, 37, 19,  3,
 1739, 39, 13,  7,
 1740, 34, 22, 10,
 1740, 38, 14, 10,
 1741, 29, 24, 18,
 1741, 30, 21, 20,
 1741, 30, 29,  0,
 1741, 34, 21, 12,
 1741, 34, 24,  3,
 1741, 36, 18, 11,
 1741, 36, 21,  2,
 1742, 26, 25, 21,
 1742, 27, 23, 22,
 1742, 29, 26, 15,
 1742, 30, 29,  1,
 1742, 33, 22, 13,
 1742, 34, 19, 15,
 1742, 37, 18,  7,
 1742, 38, 17,  3,
 1742, 39, 11, 10,
 1742, 39, 14,  5,
 1744, 32, 24, 12,
 1744, 40, 12,  0,
 1745, 30, 22, 19,
 1745, 30, 26, 13,
 1745, 30, 29,  2,
 1745, 31, 28,  0,
 1745, 33, 20, 16,
 1745, 35, 18, 14,
 1745, 35, 22,  6,
 1745, 36, 20,  7,
 1745, 40,  9,  8,
 1745, 40, 12,  1,
 1746, 27, 24, 21,
 1746, 29, 28, 11,
 1746, 29, 29,  8,
 1746, 31, 23, 16,
 1746, 31, 28,  1,
 1746, 32, 19, 19,
 1746, 33, 24,  9,
 1746, 35, 20, 11,
 1746, 36, 15, 15,
 1746, 36, 21,  3,
 1746, 37, 16, 11,
 1746, 37, 19,  4,
 1746, 39, 12,  9,
 1746, 39, 15,  0,
 1746, 40, 11,  5,
 1747, 27, 27, 17,
 1747, 35, 21,  9,
 1747, 39, 15,  1,
 1748, 30, 28,  8,
 1748, 32, 20, 18,
 1748, 34, 24,  4,
 1748, 36, 16, 14,
 1748, 40, 12,  2,
 1749, 28, 26, 17,
 1749, 31, 28,  2,
 1749, 32, 23, 14,
 1749, 32, 25, 10,
 1749, 32, 26,  7,
 1749, 34, 23,  8,
 1749, 38, 16,  7,
 1749, 38, 17,  4,
 1749, 40, 10,  7,
 1750, 30, 25, 15,
 1750, 30, 27, 11,
 1750, 30, 29,  3,
 1750, 33, 25,  6,
 1750, 38, 15,  9,
 1750, 39, 15,  2,
 1752, 26, 26, 20,
 1752, 28, 22, 22,
 1752, 34, 20, 14,
 1753, 30, 23, 18,
 1753, 32, 27,  0,
 1753, 36, 21,  4,
 1753, 39, 14,  6,
 1753, 40, 12,  3,
 1754, 27, 25, 20,
 1754, 28, 23, 21,
 1754, 31, 27,  8,
 1754, 31, 28,  3,
 1754, 32, 21, 17,
 1754, 32, 27,  1,
 1754, 35, 23,  0,
 1754, 36, 17, 13,
 1754, 39, 13,  8,
 1755, 29, 25, 17,
 1755, 31, 25, 13,
 1755, 33, 21, 15,
 1755, 35, 19, 13,
 1755, 35, 23,  1,
 1755, 37, 19,  5,
 1755, 39, 15,  3,
 1757, 30, 29,  4,
 1757, 32, 27,  2,
 1757, 34, 24,  5,
 1757, 36, 19, 10,
 1757, 37, 18,  8,
 1757, 38, 13, 12,
 1757, 40, 11,  6,
 1758, 31, 26, 11,
 1758, 35, 22,  7,
 1758, 35, 23,  2,
 1758, 37, 17, 10,
 1758, 38, 17,  5,
 1760, 28, 24, 20,
 1760, 36, 20,  8,
 1760, 40, 12,  4,
 1761, 31, 20, 20,
 1761, 31, 28,  4,
 1761, 34, 22, 11,
 1761, 37, 14, 14,
 1761, 38, 14, 11,
 1762, 31, 24, 15,
 1762, 32, 27,  3,
 1762, 33, 23, 12,
 1762, 36, 21,  5,
 1762, 39, 15,  4,
 1762, 40,  9,  9,
 1763, 29, 29,  9,
 1763, 31, 21, 19,
 1763, 33, 25,  7,
 1763, 35, 23,  3,
 1763, 37, 15, 13,
 1763, 39, 11, 11,
 1764, 28, 28, 14,
 1764, 32, 22, 16,
 1764, 32, 26,  8,
 1764, 36, 18, 12,
 1764, 38, 16,  8,
 1764, 40, 10,  8,
 1765, 30, 24, 17,
 1765, 30, 28,  9,
 1765, 33, 24, 10,
 1765, 33, 26,  0,
 1765, 39, 12, 10,
 1766, 27, 26, 19,
 1766, 29, 22, 21,
 1766, 29, 27, 14,
 1766, 30, 29,  5,
 1766, 33, 26,  1,
 1766, 34, 21, 13,
 1766, 34, 23,  9,
 1766, 35, 21, 10,
 1766, 37, 19,  6,
 1766, 39, 14,  7,
 1768, 34, 24,  6,
 1768, 38, 18,  0,
 1769, 28, 27, 16,
 1769, 29, 28, 12,
 1769, 31, 22, 18,
 1769, 32, 24, 13,
 1769, 32, 27,  4,
 1769, 33, 22, 14,
 1769, 33, 26,  2,
 1769, 34, 18, 17,
 1769, 35, 20, 12,
 1769, 37, 16, 12,
 1769, 37, 20,  0,
 1769, 38, 15, 10,
 1769, 38, 17,  6,
 1769, 38, 18,  1,
 1769, 40, 12,  5,
 1769, 40, 13,  0,
 1770, 28, 25, 19,
 1770, 29, 23, 20,
 1770, 31, 28,  5,
 1770, 32, 25, 11,
 1770, 35, 17, 16,
 1770, 35, 23,  4,
 1770, 37, 20,  1,
 1770, 40, 11,  7,
 1770, 40, 13,  1,
 1771, 31, 27,  9,
 1771, 39, 13,  9,
 1771, 39, 15,  5,
 1772, 30, 26, 14,
 1772, 38, 18,  2,
 1773, 29, 26, 16,
 1773, 30, 27, 12,
 1773, 34, 19, 16,
 1773, 35, 22,  8,
 1773, 36, 21,  6,
 1773, 37, 20,  2,
 1773, 40, 13,  2,
 1774, 33, 19, 18,
 1774, 33, 26,  3,
 1774, 35, 18, 15,
 1774, 37, 18,  9,
 1777, 25, 24, 24,
 1777, 30, 29,  6,
 1777, 36, 16, 15,
 1777, 36, 20,  9,
 1777, 38, 18,  3,
 1777, 39, 16,  0,
 1778, 29, 24, 19,
 1778, 32, 23, 15,
 1778, 32, 27,  5,
 1778, 33, 20, 17,
 1778, 33, 25,  8,
 1778, 36, 19, 11,
 1778, 37, 20,  3,
 1778, 39, 16,  1,
 1778, 40, 13,  3,
 1779, 25, 25, 23,
 1779, 31, 23, 17,
 1779, 35, 23,  5,
 1779, 37, 17, 11,
 1779, 37, 19,  7,
 1780, 36, 22,  0,
 1780, 40, 12,  6,
 1781, 26, 24, 23,
 1781, 30, 25, 16,
 1781, 31, 26, 12,
 1781, 31, 28,  6,
 1781, 32, 26,  9,
 1781, 33, 26,  4,
 1781, 34, 20, 15,
 1781, 34, 24,  7,
 1781, 34, 25,  0,
 1781, 36, 17, 14,
 1781, 36, 22,  1,
 1781, 38, 16,  9,
 1781, 39, 14,  8,
 1781, 39, 16,  2,
 1781, 40, 10,  9,
 1782, 27, 27, 18,
 1782, 29, 29, 10,
 1782, 30, 21, 21,
 1782, 31, 25, 14,
 1782, 34, 25,  1,
 1782, 35, 19, 14,
 1782, 38, 13, 13,
 1782, 38, 17,  7,
 1782, 39, 15,  6,
 1784, 28, 26, 18,
 1784, 30, 22, 20,
 1784, 30, 28, 10,
 1784, 34, 22, 12,
 1784, 36, 22,  2,
 1784, 38, 14, 12,
 1784, 38, 18,  4,
 1785, 26, 25, 22,
 1785, 32, 20, 19,
 1785, 34, 23, 10,
 1785, 34, 25,  2,
 1785, 37, 20,  4,
 1785, 40, 11,  8,
 1785, 40, 13,  4,
 1786, 33, 21, 16,
 1786, 33, 24, 11,
 1786, 36, 21,  7,
 1786, 39, 12, 11,
 1786, 39, 16,  3,
 1787, 27, 23, 23,
 1787, 33, 23, 13,
 1787, 35, 21, 11,
 1789, 27, 24, 22,
 1789, 32, 21, 18,
 1789, 32, 27,  6,
 1789, 36, 18, 13,
 1789, 36, 22,  3,
 1790, 29, 25, 18,
 1790, 30, 23, 19,
 1790, 30, 29,  7,
 1790, 31, 27, 10,
 1790, 33, 26,  5,
 1790, 34, 25,  3,
 1790, 35, 22,  9,
 1790, 35, 23,  6,
 1790, 37, 15, 14,
 1790, 38, 15, 11,
 1790, 39, 13, 10,
 1793, 26, 26, 21,
 1793, 28, 28, 15,
 1793, 31, 24, 16,
 1793, 32, 25, 12,
 1793, 34, 21, 14,
 1793, 37, 18, 10,
 1793, 38, 18,  5,
 1793, 39, 16,  4,
 1793, 40, 12,  7,
 1794, 29, 28, 13,
 1794, 31, 28,  7,
 1794, 35, 20, 13,
 1794, 37, 16, 13,
 1794, 37, 19,  8,
 1794, 37, 20,  5,
 1794, 40, 13,  5,
 1795, 27, 25, 21,
 1795, 29, 27, 15,
 1795, 33, 25,  9,
 1795, 39, 15,  7,
 1796, 32, 24, 14,
 1796, 34, 24,  8,
 1796, 36, 20, 10,
 1796, 36, 22,  4,
 1796, 40, 14,  0,
 1797, 28, 23, 22,
 1797, 32, 22, 17,
 1797, 34, 25,  4,
 1797, 38, 17,  8,
 1797, 40, 14,  1,
 1798, 30, 27, 13,
 1798, 33, 22, 15,
 1798, 39, 14,  9,
 1800, 30, 24, 18,
 1800, 30, 30,  0,
 1800, 32, 26, 10,
 1800, 38, 16, 10,
 1800, 40, 10, 10,
 1800, 40, 14,  2,
 1801, 28, 24, 21,
 1801, 30, 26, 15,
 1801, 30, 30,  1,
 1801, 33, 26,  6,
 1801, 35, 24,  0,
 1801, 36, 19, 12,
 1801, 36, 21,  8,
 1802, 28, 27, 17,
 1802, 31, 21, 20,
 1802, 31, 29,  0,
 1802, 32, 27,  7,
 1802, 35, 24,  1,
 1802, 37, 17, 12,
 1802, 39, 16,  5,
 1802, 40, 11,  9,
 1803, 29, 29, 11,
 1803, 31, 29,  1,
 1803, 35, 17, 17,
 1803, 35, 23,  7,
 1804, 30, 30,  2,
 1804, 34, 18, 18,
 1804, 38, 18,  6,
 1805, 27, 26, 20,
 1805, 30, 28, 11,
 1805, 30, 29,  8,
 1805, 35, 18, 16,
 1805, 35, 24,  2,
 1805, 36, 22,  5,
 1805, 37, 20,  6,
 1805, 38, 19,  0,
 1805, 40, 13,  6,
 1805, 40, 14,  3,
 1806, 29, 26, 17,
 1806, 31, 22, 19,
 1806, 31, 26, 13,
 1806, 31, 29,  2,
 1806, 34, 19, 17,
 1806, 34, 23, 11,
 1806, 34, 25,  5,
 1806, 38, 19,  1,
 1808, 32, 28,  0,
 1808, 36, 16, 16,
 1808, 40, 12,  8,
 1809, 28, 25, 20,
 1809, 29, 22, 22,
 1809, 30, 30,  3,
 1809, 31, 28,  8,
 1809, 32, 23, 16,
 1809, 32, 28,  1,
 1809, 33, 24, 12,
 1809, 34, 22, 13,
 1809, 35, 22, 10,
 1809, 38, 14, 13,
 1809, 38, 19,  2,
 1809, 39, 12, 12,
 1810, 35, 21, 12,
 1810, 35, 24,  3,
 1810, 36, 17, 15,
 1810, 37, 21,  0,
 1810, 39, 15,  8,
 1810, 39, 17,  0,
 1811, 29, 23, 21,
 1811, 31, 25, 15,
 1811, 31, 27, 11,
 1811, 31, 29,  3,
 1811, 33, 19, 19,
 1811, 35, 19, 15,
 1811, 37, 19,  9,
 1811, 37, 21,  1,
 1811, 39, 13, 11,
 1811, 39, 17,  1,
 1812, 32, 28,  2,
 1812, 34, 20, 16,
 1812, 40, 14,  4,
 1813, 33, 20, 18,
 1813, 34, 24,  9,
 1813, 38, 15, 12,
 1813, 39, 16,  6,
 1814, 30, 25, 17,
 1814, 31, 23, 18,
 1814, 33, 23, 14,
 1814, 33, 25, 10,
 1814, 33, 26,  7,
 1814, 37, 18, 11,
 1814, 37, 21,  2,
 1814, 38, 17,  9,
 1814, 38, 19,  3,
 1814, 39, 17,  2,
 1816, 30, 30,  4,
 1816, 36, 18, 14,
 1816, 36, 22,  6,
 1817, 29, 24, 20,
 1817, 32, 27,  8,
 1817, 32, 28,  3,
 1817, 34, 25,  6,
 1817, 35, 24,  4,
 1817, 36, 20, 11,
 1817, 38, 18,  7,
 1817, 39, 14, 10,
 1818, 31, 29,  4,
 1818, 32, 25, 13,
 1818, 33, 27,  0,
 1818, 35, 23,  8,
 1818, 36, 21,  9,
 1818, 37, 20,  7,
 1818, 40, 13,  7,
 1819, 27, 27, 19,
 1819, 33, 21, 17,
 1819, 33, 27,  1,
 1819, 37, 15, 15,
 1819, 37, 21,  3,
 1819, 39, 17,  3,
 1821, 28, 26, 19,
 1821, 29, 28, 14,
 1821, 32, 26, 11,
 1821, 35, 20, 14,
 1821, 37, 16, 14,
 1821, 38, 16, 11,
 1821, 38, 19,  4,
 1821, 40, 11, 10,
 1821, 40, 14,  5,
 1822, 30, 29,  9,
 1822, 33, 27,  2,
 1822, 34, 21, 15,
 1824, 28, 28, 16,
 1824, 32, 20, 20,
 1824, 32, 28,  4,
 1825, 30, 22, 21,
 1825, 30, 27, 14,
 1825, 30, 30,  5,
 1825, 32, 24, 15,
 1825, 36, 23,  0,
 1825, 40, 12,  9,
 1825, 40, 15,  0,
 1826, 25, 25, 24,
 1826, 29, 27, 16,
 1826, 29, 29, 12,
 1826, 31, 24, 17,
 1826, 31, 28,  9,
 1826, 32, 21, 19,
 1826, 35, 24,  5,
 1826, 36, 19, 13,
 1826, 36, 23,  1,
 1826, 37, 21,  4,
 1826, 39, 16,  7,
 1826, 39, 17,  4,
 1826, 40, 15,  1,
 1827, 29, 25, 19,
 1827, 31, 29,  5,
 1827, 33, 27,  3,
 1827, 37, 17, 13,
 1827, 39, 15,  9,
 1828, 26, 24, 24,
 1828, 30, 28, 12,
 1829, 30, 23, 20,
 1829, 33, 22, 16,
 1829, 33, 26,  8,
 1829, 34, 23, 12,
 1829, 36, 22,  7,
 1829, 36, 23,  2,
 1829, 40, 15,  2,
 1830, 26, 25, 23,
 1830, 34, 25,  7,
 1830, 35, 22, 11,
 1830, 37, 19, 10,
 1830, 38, 19,  5,
 1832, 30, 26, 16,
 1832, 32, 22, 18,
 1832, 34, 24, 10,
 1832, 34, 26,  0,
 1832, 38, 18,  8,
 1832, 40, 14,  6,
 1833, 31, 26, 14,
 1833, 32, 28,  5,
 1833, 34, 26,  1,
 1833, 37, 20,  8,
 1833, 38, 17, 10,
 1833, 40, 13,  8,
 1834, 27, 24, 23,
 1834, 31, 27, 12,
 1834, 32, 27,  9,
 1834, 33, 24, 13,
 1834, 33, 27,  4,
 1834, 36, 23,  3,
 1834, 39, 13, 12,
 1834, 40, 15,  3,
 1835, 33, 25, 11,
 1835, 35, 21, 13,
 1835, 35, 23,  9,
 1835, 37, 21,  5,
 1835, 39, 17,  5,
 1836, 26, 26, 22,
 1836, 30, 30,  6,
 1836, 34, 22, 14,
 1836, 34, 26,  2,
 1836, 38, 14, 14,
 1837, 28, 27, 18,
 1837, 30, 24, 19,
 1837, 35, 24,  6,
 1837, 36, 21, 10,
 1837, 37, 18, 12,
 1838, 27, 25, 22,
 1838, 31, 29,  6,
 1838, 35, 18, 17,
 1838, 38, 15, 13,
 1838, 39, 14, 11,
 1840, 36, 20, 12,
 1841, 29, 26, 18,
 1841, 30, 29, 10,
 1841, 34, 19, 18,
 1841, 34, 26,  3,
 1841, 36, 17, 16,
 1841, 36, 23,  4,
 1841, 38, 19,  6,
 1841, 39, 16,  8,
 1841, 40, 15,  4,
 1842, 28, 23, 23,
 1842, 31, 25, 16,
 1842, 32, 23, 17,
 1842, 35, 19, 16,
 1842, 40, 11, 11,
 1843, 31, 21, 21,
 1843, 33, 23, 15,
 1843, 33, 27,  5,
 1844, 28, 24, 22,
 1844, 32, 26, 12,
 1844, 32, 28,  6,
 1844, 36, 22,  8,
 1844, 38, 16, 12,
 1844, 38, 20,  0,
 1844, 40, 12, 10,
 1845, 31, 22, 20,
 1845, 31, 28, 10,
 1845, 32, 25, 14,
 1845, 34, 20, 17,
 1845, 34, 25,  8,
 1845, 36, 18, 15,
 1845, 38, 20,  1,
 1845, 39, 18,  0,
 1845, 40, 14,  7,
 1846, 27, 26, 21,
 1846, 33, 26,  9,
 1846, 37, 21,  6,
 1846, 39, 15, 10,
 1846, 39, 17,  6,
 1846, 39, 18,  1,
 1848, 34, 26,  4,
 1848, 38, 20,  2,
 1849, 30, 25, 18,
 1849, 30, 30,  7,
 1849, 38, 18,  9,
 1849, 39, 18,  2,
 1850, 28, 25, 21,
 1850, 29, 28, 15,
 1850, 33, 20, 19,
 1850, 35, 20, 15,
 1850, 35, 24,  7,
 1850, 35, 25,  0,
 1850, 36, 23,  5,
 1850, 37, 16, 15,
 1850, 37, 20,  9,
 1850, 40, 13,  9,
 1850, 40, 15,  5,
 1851, 29, 29, 13,
 1851, 31, 23, 19,
 1851, 31, 29,  7,
 1851, 35, 25,  1,
 1851, 37, 19, 11,
 1853, 30, 28, 13,
 1853, 32, 27, 10,
 1853, 34, 21, 16,
 1853, 34, 24, 11,
 1853, 35, 22, 12,
 1853, 36, 19, 14,
 1853, 37, 22,  0,
 1853, 38, 20,  3,
 1854, 29, 23, 22,
 1854, 30, 27, 15,
 1854, 33, 21, 18,
 1854, 33, 27,  6,
 1854, 34, 23, 13,
 1854, 35, 23, 10,
 1854, 35, 25,  2,
 1854, 37, 17, 14,
 1854, 37, 22,  1,
 1854, 38, 17, 11,
 1854, 38, 19,  7,
 1854, 39, 18,  3,
 1856, 32, 24, 16,
 1856, 40, 16,  0,
 1857, 28, 28, 17,
 1857, 32, 28,  7,
 1857, 34, 26,  5,
 1857, 37, 22,  2,
 1857, 40, 16,  1,
 1858, 27, 27, 20,
 1858, 29, 24, 21,
 1858, 33, 25, 12,
 1858, 36, 21, 11,
 1858, 39, 16,  9,
 1859, 29, 27, 17,
 1859, 31, 27, 13,
 1859, 35, 25,  3,
 1859, 37, 21,  7,
 1859, 39, 13, 13,
 1859, 39, 17,  7,
 1860, 28, 26, 20,
 1860, 38, 20,  4,
 1860, 40, 14,  8,
 1860, 40, 16,  2,
 1861, 31, 24, 18,
 1861, 31, 30,  0,
 1861, 33, 24, 14,
 1861, 36, 22,  9,
 1861, 36, 23,  6,
 1861, 39, 14, 12,
 1861, 39, 18,  4,
 1861, 40, 15,  6,
 1862, 30, 29, 11,
 1862, 31, 26, 15,
 1862, 31, 30,  1,
 1862, 33, 22, 17,
 1862, 34, 25,  9,
 1862, 35, 21, 14,
 1862, 37, 18, 13,
 1862, 37, 22,  3,
 1864, 30, 30,  8,
 1865, 30, 26, 17,
 1865, 31, 30,  2,
 1865, 32, 21, 20,
 1865, 32, 29,  0,
 1865, 33, 26, 10,
 1865, 34, 22, 15,
 1865, 35, 24,  8,
 1865, 36, 20, 13,
 1865, 38, 15, 14,
 1865, 40, 12, 11,
 1865, 40, 16,  3,
 1866, 29, 25, 20,
 1866, 31, 28, 11,
 1866, 31, 29,  8,
 1866, 32, 29,  1,
 1866, 35, 25,  4,
 1867, 33, 27,  7,
 1867, 39, 15, 11,
 1868, 30, 22, 22,
 1868, 34, 26,  6,
 1868, 38, 18, 10,
 1869, 32, 22, 19,
 1869, 32, 26, 13,
 1869, 32, 29,  2,
 1869, 37, 20, 10,
 1869, 37, 22,  4,
 1869, 38, 16, 13,
 1869, 38, 19,  8,
 1869, 38, 20,  5,
 1869, 40, 13, 10,
 1870, 30, 23, 21,
 1870, 31, 30,  3,
 1870, 39, 18,  5,
 1872, 32, 28,  8,
 1872, 36, 24,  0,
 1872, 40, 16,  4,
 1873, 33, 28,  0,
 1873, 35, 18, 18,
 1873, 36, 24,  1,
 1874, 28, 27, 19,
 1874, 32, 25, 15,
 1874, 32, 27, 11,
 1874, 32, 29,  3,
 1874, 33, 23, 16,
 1874, 33, 28,  1,
 1874, 36, 17, 17,
 1874, 36, 23,  7,
 1874, 37, 19, 12,
 1874, 37, 21,  8,
 1874, 39, 17,  8,
 1874, 40, 15,  7,
 1875, 25, 25, 25,
 1875, 31, 25, 17,
 1875, 35, 19, 17,
 1875, 35, 23, 11,
 1875, 35, 25,  5,
 1876, 30, 24, 20,
 1876, 34, 24, 12,
 1876, 36, 18, 16,
 1876, 36, 24,  2,
 1877, 26, 25, 24,
 1877, 31, 30,  4,
 1877, 32, 23, 18,
 1877, 33, 28,  2,
 1877, 38, 17, 12,
 1877, 39, 16, 10,
 1877, 40, 14,  9,
 1878, 29, 26, 19,
 1878, 29, 29, 14,
 1878, 34, 19, 19,
 1878, 35, 22, 13,
 1878, 37, 22,  5,
 1880, 30, 28, 14,
 1880, 34, 20, 18,
 1880, 36, 22, 10,
 1880, 38, 20,  6,
 1881, 26, 26, 23,
 1881, 27, 24, 24,
 1881, 29, 28, 16,
 1881, 30, 30,  9,
 1881, 32, 29,  4,
 1881, 34, 23, 14,
 1881, 34, 25, 10,
 1881, 34, 26,  7,
 1881, 35, 20, 16,
 1881, 36, 21, 12,
 1881, 36, 24,  3,
 1881, 37, 16, 16,
 1881, 39, 18,  6,
 1881, 40, 16,  5,
 1882, 33, 27,  8,
 1882, 33, 28,  3,
 1882, 35, 24,  9,
 1882, 36, 19, 15,
 1882, 39, 19,  0,
 1883, 27, 25, 23,
 1883, 31, 29,  9,
 1883, 33, 25, 13,
 1883, 37, 17, 15,
 1883, 39, 19,  1,
 1885, 30, 27, 16,
 1885, 30, 29, 12,
 1885, 34, 27,  0,
 1885, 38, 21,  0,
 1886, 30, 25, 19,
 1886, 31, 22, 21,
 1886, 31, 27, 14,
 1886, 31, 30,  5,
 1886, 33, 26, 11,
 1886, 34, 21, 17,
 1886, 34, 27,  1,
 1886, 35, 25,  6,
 1886, 38, 19,  9,
 1886, 38, 21,  1,
 1886, 39, 14, 13,
 1886, 39, 19,  2,
 1888, 36, 24,  4,
 1888, 40, 12, 12,
 1889, 27, 26, 22,
 1889, 28, 24, 23,
 1889, 31, 28, 12,
 1889, 32, 24, 17,
 1889, 32, 28,  9,
 1889, 33, 20, 20,
 1889, 33, 28,  4,
 1889, 34, 27,  2,
 1889, 36, 23,  8,
 1889, 37, 18, 14,
 1889, 37, 22,  6,
 1889, 38, 18, 11,
 1889, 38, 21,  2,
 1889, 40, 15,  8,
 1889, 40, 17,  0,
 1890, 31, 23, 20,
 1890, 32, 29,  5,
 1890, 33, 24, 15,
 1890, 37, 20, 11,
 1890, 39, 15, 12,
 1890, 40, 13, 11,
 1890, 40, 17,  1,
 1891, 33, 21, 19,
 1891, 35, 21, 15,
 1891, 37, 21,  9,
 1891, 39, 17,  9,
 1891, 39, 19,  3,
 1892, 28, 28, 18,
 1892, 36, 20, 14,
 1892, 40, 16,  6,
 1893, 28, 25, 22,
 1893, 31, 26, 16,
 1893, 38, 20,  7,
 1893, 40, 17,  2,
 1894, 29, 27, 18,
 1894, 34, 27,  3,
 1894, 38, 15, 15,
 1894, 38, 21,  3,
 1894, 39, 18,  7,
 1896, 32, 26, 14,
 1896, 34, 22, 16,
 1896, 34, 26,  8,
 1896, 38, 16, 14,
 1896, 40, 14, 10,
 1897, 31, 30,  6,
 1897, 32, 27, 12,
 1897, 33, 22, 18,
 1897, 36, 24,  5,
 1898, 31, 24, 19,
 1898, 33, 28,  5,
 1898, 35, 23, 12,
 1898, 37, 23,  0,
 1898, 39, 16, 11,
 1898, 39, 19,  4,
 1898, 40, 17,  3,
 1899, 27, 27, 21,
 1899, 29, 23, 23,
 1899, 33, 27,  9,
 1899, 35, 25,  7,
 1899, 37, 19, 13,
 1899, 37, 23,  1,
 1900, 30, 26, 18,
 1900, 30, 30, 10,
 1901, 28, 26, 21,
 1901, 29, 24, 22,
 1901, 32, 29,  6,
 1901, 34, 24, 13,
 1901, 34, 27,  4,
 1901, 35, 24, 10,
 1901, 35, 26,  0,
 1901, 36, 22, 11,
 1901, 38, 21,  4,
 1902, 31, 29, 10,
 1902, 34, 25, 11,
 1902, 35, 26,  1,
 1902, 37, 22,  7,
 1902, 37, 23,  2,
 1902, 38, 17, 13,
 1905, 32, 25, 16,
 1905, 35, 22, 14,
 1905, 35, 26,  2,
 1905, 38, 19, 10,
 1905, 40, 16,  7,
 1905, 40, 17,  4,
 1906, 32, 21, 21,
 1906, 36, 21, 13,
 1906, 36, 23,  9,
 1906, 40, 15,  9,
 1907, 29, 25, 21,
 1907, 29, 29, 15,
 1907, 33, 23, 17,
 1907, 37, 23,  3,
 1907, 39, 19,  5,
 1908, 32, 22, 20,
 1908, 32, 28, 10,
 1908, 36, 24,  6,
 1908, 38, 20,  8,
 1909, 30, 28, 15,
 1909, 33, 26, 12,
 1909, 33, 28,  6,
 1909, 36, 18, 17,
 1909, 39, 18,  8,
 1910, 30, 29, 13,
 1910, 31, 25, 18,
 1910, 31, 30,  7,
 1910, 33, 25, 14,
 1910, 34, 23, 15,
 1910, 34, 27,  5,
 1910, 35, 19, 18,
 1910, 35, 26,  3,
 1910, 37, 21, 10,
 1910, 38, 21,  5,
 1910, 39, 17, 10,
 1912, 38, 18, 12,
 1913, 28, 27, 20,
 1913, 30, 23, 22,
 1913, 34, 26,  9,
 1913, 36, 19, 16,
 1913, 37, 20, 12,
 1913, 39, 14, 14,
 1913, 40, 13, 12,
 1914, 29, 28, 17,
 1914, 31, 28, 13,
 1914, 32, 23, 19,
 1914, 32, 29,  7,
 1914, 35, 20, 17,
 1914, 35, 25,  8,
 1914, 37, 17, 16,
 1914, 37, 23,  4,
 1914, 40, 17,  5,
 1915, 31, 27, 15,
 1915, 39, 15, 13,
 1917, 29, 26, 20,
 1917, 30, 24, 21,
 1917, 34, 20, 19,
 1917, 35, 26,  4,
 1917, 37, 22,  8,
 1917, 40, 14, 11,
 1918, 30, 27, 17,
 1918, 33, 27, 10,
 1918, 37, 18, 15,
 1918, 39, 19,  6,
 1920, 40, 16,  8,
 1921, 30, 30, 11,
 1921, 33, 24, 16,
 1921, 34, 21, 18,
 1921, 34, 27,  6,
 1921, 36, 20, 15,
 1921, 36, 24,  7,
 1921, 36, 25,  0,
 1921, 38, 21,  6,
 1921, 39, 16, 12,
 1921, 39, 20,  0,
 1922, 31, 31,  0,
 1922, 32, 27, 13,
 1922, 33, 28,  7,
 1922, 35, 21, 16,
 1922, 35, 24, 11,
 1922, 36, 25,  1,
 1922, 39, 20,  1,
 1923, 31, 29, 11,
 1923, 31, 31,  1,
 1923, 35, 23, 13,
 1923, 37, 23,  5,
 1924, 32, 24, 18,
 1924, 32, 30,  0,
 1924, 36, 22, 12,
 1924, 40, 18,  0,
 1925, 30, 25, 20,
 1925, 31, 30,  8,
 1925, 32, 26, 15,
 1925, 32, 30,  1,
 1925, 34, 25, 12,
 1925, 36, 23, 10,
 1925, 36, 25,  2,
 1925, 38, 16, 15,
 1925, 38, 20,  9,
 1925, 39, 20,  2,
 1925, 40, 15, 10,
 1925, 40, 17,  6,
 1925, 40, 18,  1,
 1926, 26, 25, 25,
 1926, 31, 26, 17,
 1926, 31, 31,  2,
 1926, 35, 26,  5,
 1926, 37, 19, 14,
 1926, 38, 19, 11,
 1926, 39, 18,  9,
 1928, 26, 26, 24,
 1928, 32, 30,  2,
 1928, 34, 24, 14,
 1928, 38, 22,  0,
 1928, 40, 18,  2,
 1929, 28, 28, 19,
 1929, 31, 22, 22,
 1929, 32, 28, 11,
 1929, 32, 29,  8,
 1929, 34, 22, 17,
 1929, 38, 17, 14,
 1929, 38, 22,  1,
 1930, 27, 25, 24,
 1930, 33, 21, 20,
 1930, 33, 29,  0,
 1930, 36, 25,  3,
 1930, 39, 20,  3,
 1931, 29, 27, 19,
 1931, 31, 23, 21,
 1931, 31, 31,  3,
 1931, 33, 29,  1,
 1931, 35, 25,  9,
 1931, 37, 21, 11,
 1931, 39, 17, 11,
 1931, 39, 19,  7,
 1932, 34, 26, 10,
 1932, 38, 22,  2,
 1933, 32, 30,  3,
 1933, 36, 21, 14,
 1933, 40, 18,  3,
 1934, 27, 26, 23,
 1934, 33, 22, 19,
 1934, 33, 26, 13,
 1934, 33, 29,  2,
 1934, 34, 27,  7,
 1934, 35, 22, 15,
 1934, 37, 22,  9,
 1934, 37, 23,  6,
 1934, 38, 21,  7,
 1936, 28, 24, 24,
 1936, 36, 24,  8,
 1937, 30, 26, 19,
 1937, 30, 29, 14,
 1937, 31, 24, 20,
 1937, 33, 28,  8,
 1937, 35, 26,  6,
 1937, 36, 25,  4,
 1937, 38, 18, 13,
 1937, 38, 22,  3,
 1937, 39, 20,  4,
 1937, 40, 16,  9,
 1938, 28, 25, 23,
 1938, 29, 29, 16,
 1938, 31, 31,  4,
 1938, 32, 25, 17,
 1938, 37, 20, 13,
 1938, 40, 13, 13,
 1938, 40, 17,  7,
 1939, 33, 25, 15,
 1939, 33, 27, 11,
 1939, 33, 29,  3,
 1940, 30, 28, 16,
 1940, 32, 30,  4,
 1940, 34, 28,  0,
 1940, 40, 14, 12,
 1940, 40, 18,  4,
 1941, 31, 28, 14,
 1941, 34, 23, 16,
 1941, 34, 28,  1,
 1942, 27, 27, 22,
 1942, 31, 30,  9,
 1942, 33, 23, 18,
 1942, 39, 15, 14,
 1944, 28, 26, 22,
 1944, 30, 30, 12,
 1944, 34, 28,  2,
 1944, 36, 18, 18,
 1944, 38, 20, 10,
 1944, 38, 22,  4,
 1945, 35, 24, 12,
 1945, 37, 24,  0,
 1945, 39, 18, 10,
 1946, 29, 24, 23,
 1946, 31, 27, 16,
 1946, 31, 29, 12,
 1946, 32, 29,  9,
 1946, 33, 29,  4,
 1946, 36, 19, 17,
 1946, 36, 23, 11,
 1946, 36, 25,  5,
 1946, 37, 24,  1,
 1946, 39, 16, 13,
 1946, 39, 19,  8,
 1946, 39, 20,  5,
 1946, 40, 15, 11,
 1947, 31, 25, 19,
 1947, 31, 31,  5,
 1947, 35, 19, 19,
 1947, 37, 17, 17,
 1947, 37, 23,  7,
 1949, 29, 28, 18,
 1949, 32, 22, 21,
 1949, 32, 27, 14,
 1949, 32, 30,  5,
 1949, 34, 27,  8,
 1949, 34, 28,  3,
 1949, 35, 20, 18,
 1949, 36, 22, 13,
 1949, 37, 18, 16,
 1949, 37, 24,  2,
 1949, 38, 19, 12,
 1949, 38, 21,  8,
 1949, 40, 18,  5,
 1950, 29, 25, 22,
 1950, 34, 25, 13,
 1950, 35, 23, 14,
 1950, 35, 25, 10,
 1950, 35, 26,  7,
 1952, 32, 28, 12,
 1952, 36, 20, 16,
 1953, 30, 27, 18,
 1953, 32, 23, 20,
 1953, 34, 26, 11,
 1953, 36, 24,  9,
 1953, 37, 22, 10,
 1953, 38, 22,  5,
 1953, 40, 17,  8,
 1954, 28, 27, 21,
 1954, 33, 24, 17,
 1954, 33, 28,  9,
 1954, 35, 27,  0,
 1954, 37, 21, 12,
 1954, 37, 24,  3,
 1954, 39, 17, 12,
 1955, 33, 29,  5,
 1955, 35, 21, 17,
 1955, 35, 27,  1,
 1955, 37, 19, 15,
 1956, 32, 26, 16,
 1956, 34, 20, 20,
 1956, 34, 28,  4,
 1956, 38, 16, 16,
 1956, 40, 16, 10,
 1957, 34, 24, 15,
 1957, 36, 25,  6,
 1957, 39, 20,  6,
 1958, 29, 26, 21,
 1958, 30, 23, 23,
 1958, 31, 31,  6,
 1958, 34, 21, 19,
 1958, 35, 27,  2,
 1958, 38, 17, 15,
 1960, 30, 24, 22,
 1960, 32, 30,  6,
 1960, 40, 18,  6,
 1961, 31, 26, 18,
 1961, 31, 30, 10,
 1961, 32, 24, 19,
 1961, 33, 26, 14,
 1961, 37, 24,  4,
 1961, 40, 19,  0,
 1962, 33, 27, 12,
 1962, 36, 21, 15,
 1962, 37, 23,  8,
 1962, 39, 21,  0,
 1962, 40, 19,  1,
 1963, 35, 27,  3,
 1963, 39, 19,  9,
 1963, 39, 21,  1,
 1964, 34, 22, 18,
 1964, 38, 18, 14,
 1964, 38, 22,  6,
 1965, 32, 29, 10,
 1965, 34, 28,  5,
 1965, 35, 22, 16,
 1965, 35, 26,  8,
 1965, 37, 20, 14,
 1965, 38, 20, 11,
 1965, 40, 14, 13,
 1965, 40, 19,  2,
 1966, 30, 25, 21,
 1966, 30, 29, 15,
 1966, 33, 29,  6,
 1966, 34, 27,  9,
 1966, 38, 21,  9,
 1966, 39, 18, 11,
 1966, 39, 21,  2,
 1968, 28, 28, 20,
 1969, 30, 30, 13,
 1969, 36, 23, 12,
 1969, 40, 15, 12,
 1970, 29, 27, 20,
 1970, 31, 28, 15,
 1970, 33, 25, 16,
 1970, 35, 24, 13,
 1970, 35, 27,  4,
 1970, 36, 25,  7,
 1970, 37, 24,  5,
 1970, 39, 20,  7,
 1970, 40, 17,  9,
 1970, 40, 19,  3,
 1971, 29, 29, 17,
 1971, 31, 29, 13,
 1971, 31, 31,  7,
 1971, 33, 21, 21,
 1971, 35, 25, 11,
 1971, 39, 15, 15,
 1971, 39, 21,  3,
 1972, 36, 24, 10,
 1972, 36, 26,  0,
 1973, 30, 28, 17,
 1973, 32, 25, 18,
 1973, 32, 30,  7,
 1973, 33, 22, 20,
 1973, 33, 28, 10,
 1973, 36, 26,  1,
 1973, 38, 23,  0,
 1973, 39, 16, 14,
 1973, 40, 18,  7,
 1974, 31, 23, 22,
 1974, 34, 23, 17,
 1974, 37, 22, 11,
 1974, 38, 19, 13,
 1974, 38, 23,  1,
 1976, 30, 26, 20,
 1976, 34, 26, 12,
 1976, 34, 28,  6,
 1976, 36, 22, 14,
 1976, 36, 26,  2,
 1977, 26, 26, 25,
 1977, 32, 28, 13,
 1977, 34, 25, 14,
 1977, 38, 22,  7,
 1977, 38, 23,  2,
 1977, 40, 16, 11,
 1977, 40, 19,  4,
 1978, 31, 24, 21,
 1978, 32, 27, 15,
 1978, 39, 21,  4,
 1979, 27, 25, 25,
 1979, 31, 27, 17,
 1979, 33, 23, 19,
 1979, 33, 29,  7,
 1979, 35, 23, 15,
 1979, 35, 27,  5,
 1979, 37, 21, 13,
 1979, 37, 23,  9,
 1979, 39, 17, 13,
 1981, 27, 26, 24,
 1981, 36, 19, 18,
 1981, 36, 26,  3,
 1981, 37, 24,  6,
 1982, 31, 30, 11,
 1982, 35, 26,  9,
 1982, 37, 18, 17,
 1982, 38, 23,  3,
 1982, 39, 19, 10,
 1985, 28, 25, 24,
 1985, 32, 31,  0,
 1985, 34, 27, 10,
 1985, 36, 20, 17,
 1985, 36, 25,  8,
 1985, 38, 21, 10,
 1985, 39, 20,  8,
 1986, 29, 28, 19,
 1986, 31, 25, 20,
 1986, 31, 31,  8,
 1986, 32, 29, 11,
 1986, 32, 31,  1,
 1986, 35, 20, 19,
 1986, 37, 19, 16,
 1986, 40, 19,  5,
 1987, 27, 27, 23,
 1987, 33, 27, 13,
 1987, 39, 21,  5,
 1988, 32, 30,  8,
 1988, 34, 24, 16,
 1988, 36, 26,  4,
 1988, 38, 20, 12,
 1988, 40, 18,  8,
 1989, 28, 26, 23,
 1989, 32, 26, 17,
 1989, 32, 31,  2,
 1989, 33, 24, 18,
 1989, 33, 30,  0,
 1989, 34, 28,  7,
 1989, 38, 17, 16,
 1989, 38, 23,  4,
 1989, 39, 18, 12,
 1989, 40, 17, 10,
 1990, 30, 27, 19,
 1990, 33, 26, 15,
 1990, 33, 30,  1,
 1990, 35, 21, 18,
 1990, 35, 27,  6,
 1992, 32, 22, 22,
 1992, 38, 22,  8,
 1992, 40, 14, 14,
 1993, 29, 24, 24,
 1993, 33, 30,  2,
 1993, 36, 21, 16,
 1993, 36, 24, 11,
 1993, 38, 18, 15,
 1994, 32, 23, 21,
 1994, 32, 31,  3,
 1994, 33, 28, 11,
 1994, 33, 29,  8,
 1994, 35, 25, 12,
 1994, 36, 23, 13,
 1994, 37, 20, 15,
 1994, 37, 24,  7,
 1994, 37, 25,  0,
 1994, 40, 15, 13,
 1995, 29, 25, 23,
 1995, 37, 25,  1,
 1996, 30, 30, 14,
 1997, 28, 27, 22,
 1997, 30, 29, 16,
 1997, 34, 21, 20,
 1997, 34, 29,  0,
 1997, 35, 24, 14,
 1997, 36, 26,  5,
 1997, 37, 22, 12,
 1997, 40, 19,  6,
 1998, 31, 26, 19,
 1998, 31, 29, 14,
 1998, 33, 30,  3,
 1998, 34, 29,  1,
 1998, 35, 22, 17,
 1998, 37, 23, 10,
 1998, 37, 25,  2,
 1998, 38, 23,  5,
 1998, 39, 21,  6,
 2000, 32, 24, 20,
 2000, 40, 16, 12,
 2000, 40, 20,  0,
 2001, 29, 26, 22,
 2001, 31, 28, 16,
 2001, 32, 31,  4,
 2001, 34, 22, 19,
 2001, 34, 26, 13,
 2001, 34, 29,  2,
 2001, 35, 26, 10,
 2001, 38, 19, 14,
 2001, 40, 20,  1,
 2002, 36, 25,  9,
 2002, 39, 16, 15,
 2002, 39, 20,  9,
 2003, 31, 31,  9,
 2003, 33, 25, 17,
 2003, 35, 27,  7,
 2003, 37, 25,  3,
 2003, 39, 19, 11,
 2004, 32, 28, 14,
 2004, 34, 28,  8,
 2004, 40, 20,  2,
 2005, 30, 24, 23,
 2005, 31, 30, 12,
 2005, 32, 30,  9,
 2005, 33, 30,  4,
 2005, 36, 22, 15,
 2005, 39, 22,  0,
 2005, 40, 18,  9,
 2006, 29, 29, 18,
 2006, 34, 25, 15,
 2006, 34, 27, 11,
 2006, 34, 29,  3,
 2006, 37, 21, 14,
 2006, 38, 21, 11,
 2006, 39, 17, 14,
 2006, 39, 22,  1,
 2008, 30, 28, 18,
 2008, 36, 26,  6,
 2009, 28, 28, 21,
 2009, 30, 25, 22,
 2009, 32, 27, 16,
 2009, 32, 29, 12,
 2009, 34, 23, 18,
 2009, 35, 28,  0,
 2009, 37, 24,  8,
 2009, 38, 22,  9,
 2009, 38, 23,  6,
 2009, 39, 22,  2,
 2009, 40, 20,  3,
 2010, 32, 25, 19,
 2010, 32, 31,  5,
 2010, 35, 23, 16,
 2010, 35, 28,  1,
 2010, 37, 25,  4,
 2010, 40, 17, 11,
 2010, 40, 19,  7,
 2011, 29, 27, 21,
 2011, 33, 29,  9,
 2011, 39, 21,  7,
 2013, 34, 29,  4,
 2013, 35, 28,  2,
 2013, 38, 20, 13,
 2014, 31, 27, 18,
 2014, 33, 22, 21,
 2014, 33, 27, 14,
 2014, 33, 30,  5,
 2014, 39, 18, 13,
 2014, 39, 22,  3,
 2016, 36, 24, 12,
 2016, 40, 20,  4,
 2017, 30, 26, 21,
 2017, 33, 28, 12,
 2017, 37, 18, 18,
 2018, 33, 23, 20,
 2018, 35, 27,  8,
 2018, 35, 28,  3,
 2018, 36, 19, 19,
 2019, 31, 23, 23,
 2019, 35, 25, 13,
 2019, 37, 19, 17,
 2019, 37, 23, 11,
 2019, 37, 25,  5,
 2020, 36, 20, 18,
 2020, 38, 24,  0,
 2021, 31, 24, 22,
 2021, 32, 31,  6,
 2021, 33, 26, 16,
 2021, 34, 24, 17,
 2021, 34, 28,  9,
 2021, 36, 23, 14,
 2021, 36, 25, 10,
 2021, 36, 26,  7,
 2021, 38, 24,  1,
 2021, 39, 20, 10,
 2021, 39, 22,  4,
 2021, 40, 15, 14,
 2022, 31, 31, 10,
 2022, 34, 29,  5,
 2022, 35, 26, 11,
 2022, 37, 22, 13,
 2022, 38, 17, 17,
 2022, 38, 23,  7,
 2024, 32, 26, 18,
 2024, 32, 30, 10,
 2024, 38, 18, 16,
 2024, 38, 24,  2,
 2024, 40, 18, 10,
 2025, 29, 28, 20,
 2025, 30, 30, 15,
 2025, 33, 30,  6,
 2025, 35, 20, 20,
 2025, 35, 28,  4,
 2025, 36, 27,  0,
 2025, 37, 20, 16,
 2025, 40, 16, 13,
 2025, 40, 19,  8,
 2025, 40, 20,  5,
 2026, 33, 24, 19,
 2026, 35, 24, 15,
 2026, 36, 21, 17,
 2026, 36, 27,  1,
 2026, 37, 24,  9,
 2026, 39, 19, 12,
 2026, 39, 21,  8,
 2027, 31, 25, 21,
 2027, 31, 29, 15,
 2027, 35, 21, 19,
 2028, 26, 26, 26,
 2028, 34, 26, 14,
 2028, 38, 22, 10,
 2029, 30, 27, 20,
 2029, 34, 27, 12,
 2029, 36, 27,  2,
 2029, 38, 21, 12,
 2029, 38, 24,  3,
 2030, 27, 26, 25,
 2030, 30, 29, 17,
 2030, 31, 30, 13,
 2030, 33, 29, 10,
 2030, 37, 25,  6,
 2030, 38, 19, 15,
 2030, 39, 22,  5,
 2033, 32, 28, 15,
 2033, 34, 29,  6,
 2033, 35, 22, 18,
 2033, 39, 16, 16,
 2033, 40, 17, 12,
 2034, 27, 27, 24,
 2034, 28, 25, 25,
 2034, 31, 28, 17,
 2034, 32, 29, 13,
 2034, 32, 31,  7,
 2034, 35, 28,  5,
 2034, 36, 27,  3,
 2035, 35, 27,  9,
 2035, 37, 21, 15,
 2035, 39, 17, 15,
 2036, 28, 26, 24,
 2036, 36, 22, 16,
 2036, 36, 26,  8,
 2036, 38, 24,  4,
 2036, 40, 20,  6,
 2037, 31, 26, 20,
 2037, 32, 23, 22,
 2037, 34, 25, 16,
 2037, 38, 23,  8,
 2038, 33, 25, 18,
 2038, 33, 30,  7,
 2038, 34, 21, 21,
 2040, 34, 22, 20,
 2040, 34, 28, 10,
 2040, 38, 20, 14,
 2041, 32, 24, 21,
 2041, 36, 24, 13,
 2041, 36, 27,  4,
 2041, 39, 18, 14,
 2041, 39, 22,  6,
 2041, 40, 21,  0,
 2042, 28, 27, 23,
 2042, 29, 25, 24,
 2042, 32, 27, 17,
 2042, 33, 28, 13,
 2042, 36, 25, 11,
 2042, 37, 23, 12,
 2042, 39, 20, 11,
 2042, 40, 19,  9,
 2042, 40, 21,  1,
 2043, 29, 29, 19,
 2043, 31, 31, 11,
 2043, 33, 27, 15,
 2043, 35, 23, 17,
 2043, 37, 25,  7,
 2043, 39, 21,  9,
 2045, 30, 28, 19,
 2045, 32, 30, 11,
 2045, 35, 26, 12,
 2045, 35, 28,  6,
 2045, 37, 24, 10,
 2045, 37, 26,  0,
 2045, 38, 24,  5,
 2045, 40, 18, 11,
 2045, 40, 21,  2,
 2046, 29, 26, 23,
 2046, 34, 23, 19,
 2046, 34, 29,  7,
 2046, 35, 25, 14,
 2046, 37, 26,  1,
 2048, 32, 32,  0,
 2049, 32, 25, 20,
 2049, 32, 31,  8,
 2049, 32, 32,  1,
 2049, 37, 22, 14,
 2049, 37, 26,  2,
 2049, 38, 22, 11,
 2049, 40, 20,  7,
 2050, 33, 31,  0,
 2050, 36, 23, 15,
 2050, 36, 27,  5,
 2050, 39, 23,  0,
 2050, 40, 15, 15,
 2050, 40, 21,  3,
 2051, 31, 27, 19,
 2051, 33, 29, 11,
 2051, 33, 31,  1,
 2051, 39, 19, 13,
 2051, 39, 23,  1,
 2052, 28, 28, 22,
 2052, 30, 24, 24,
 2052, 32, 32,  2,
 2052, 40, 16, 14,
 2053, 33, 30,  8,
 2053, 36, 26,  9,
 2054, 29, 27, 22,
 2054, 30, 25, 23,
 2054, 33, 26, 17,
 2054, 33, 31,  2,
 2054, 34, 27, 13,
 2054, 35, 27, 10,
 2054, 37, 19, 18,
 2054, 37, 26,  3,
 2054, 38, 21, 13,
 2054, 38, 23,  9,
 2054, 39, 22,  7,
 2054, 39, 23,  2,
 2056, 30, 30, 16,
 2056, 34, 24, 18,
 2056, 34, 30,  0,
 2056, 38, 24,  6,
 2057, 31, 30, 14,
 2057, 32, 32,  3,
 2057, 33, 22, 22,
 2057, 34, 26, 15,
 2057, 34, 30,  1,
 2057, 35, 24, 16,
 2057, 36, 20, 19,
 2057, 38, 18, 17,
 2057, 40, 21,  4,
 2058, 31, 29, 16,
 2058, 35, 28,  7,
 2058, 37, 20, 17,
 2058, 37, 25,  8,
 2058, 40, 17, 13,
 2059, 33, 23, 21,
 2059, 33, 31,  3,
 2059, 39, 23,  3,
 2060, 30, 26, 22,
 2060, 34, 30,  2,
 2061, 32, 26, 19,
 2061, 32, 29, 14,
 2061, 34, 28, 11,
 2061, 34, 29,  8,
 2061, 36, 21, 18,
 2061, 36, 27,  6,
 2061, 37, 26,  4,
 2061, 38, 19, 16,
 2061, 40, 19, 10,
 2062, 39, 21, 10,
 2064, 32, 28, 16,
 2064, 32, 32,  4,
 2064, 40, 20,  8,
 2065, 30, 29, 18,
 2065, 33, 24, 20,
 2065, 34, 30,  3,
 2065, 36, 25, 12,
 2065, 39, 20, 12,
 2066, 29, 28, 21,
 2066, 31, 24, 23,
 2066, 31, 31, 12,
 2066, 32, 31,  9,
 2066, 33, 31,  4,
 2066, 35, 21, 20,
 2066, 35, 29,  0,
 2066, 37, 21, 16,
 2066, 37, 24, 11,
 2066, 39, 17, 16,
 2066, 39, 23,  4,
 2066, 40, 21,  5,
 2067, 35, 29,  1,
 2067, 37, 23, 13,
 2068, 32, 30, 12,
 2068, 36, 24, 14,
 2068, 40, 18, 12,
 2069, 31, 28, 18,
 2069, 33, 28, 14,
 2069, 36, 22, 17,
 2069, 38, 20, 15,
 2069, 38, 24,  7,
 2069, 38, 25,  0,
 2069, 39, 22,  8,
 2070, 30, 27, 21,
 2070, 31, 25, 22,
 2070, 33, 30,  9,
 2070, 34, 25, 17,
 2070, 35, 22, 19,
 2070, 35, 26, 13,
 2070, 35, 29,  2,
 2070, 37, 26,  5,
 2070, 38, 25,  1,
 2070, 39, 18, 15,
 2072, 34, 30,  4,
 2072, 36, 26, 10,
 2072, 38, 22, 12,
 2073, 32, 32,  5,
 2073, 35, 28,  8,
 2073, 38, 23, 10,
 2073, 38, 25,  2,
 2074, 33, 27, 16,
 2074, 33, 29, 12,
 2074, 36, 27,  7,
 2075, 33, 25, 19,
 2075, 33, 31,  5,
 2075, 35, 25, 15,
 2075, 35, 27, 11,
 2075, 35, 29,  3,
 2075, 37, 25,  9,
 2075, 39, 23,  5,
 2077, 32, 27, 18,
 2077, 40, 21,  6,
 2078, 31, 26, 21,
 2078, 34, 29,  9,
 2078, 35, 23, 18,
 2078, 37, 22, 15,
 2078, 38, 25,  3,
 2078, 39, 19, 14,
 2080, 36, 28,  0,
 2081, 27, 26, 26,
 2081, 34, 22, 21,
 2081, 34, 27, 14,
 2081, 34, 30,  5,
 2081, 36, 23, 16,
 2081, 36, 28,  1,
 2081, 37, 26,  6,
 2081, 38, 21, 14,
 2081, 40, 16, 15,
 2081, 40, 20,  9,
 2082, 29, 29, 20,
 2082, 32, 23, 23,
 2082, 35, 29,  4,
 2082, 40, 19, 11,
 2083, 27, 27, 25,
 2083, 39, 21, 11,
 2084, 30, 28, 20,
 2084, 32, 24, 22,
 2084, 32, 32,  6,
 2084, 34, 28, 12,
 2084, 36, 28,  2,
 2084, 38, 24,  8,
 2084, 40, 22,  0,
 2085, 28, 26, 25,
 2085, 32, 31, 10,
 2085, 34, 23, 20,
 2085, 38, 25,  4,
 2085, 40, 17, 14,
 2085, 40, 22,  1,
 2086, 31, 30, 15,
 2086, 33, 31,  6,
 2086, 39, 22,  9,
 2086, 39, 23,  6,
 2088, 34, 26, 16,
 2088, 40, 22,  2,
 2089, 28, 27, 24,
 2089, 30, 30, 17,
 2089, 33, 26, 18,
 2089, 33, 30, 10,
 2089, 36, 27,  8,
 2089, 36, 28,  3,
 2089, 37, 24, 12,
 2090, 31, 27, 20,
 2090, 32, 25, 21,
 2090, 32, 29, 15,
 2090, 35, 24, 17,
 2090, 35, 28,  9,
 2090, 36, 25, 13,
 2090, 39, 20, 13,
 2090, 40, 21,  7,
 2091, 29, 25, 25,
 2091, 31, 29, 17,
 2091, 31, 31, 13,
 2091, 35, 29,  5,
 2091, 37, 19, 19,
 2092, 34, 30,  6,
 2092, 38, 18, 18,
 2093, 29, 26, 24,
 2093, 32, 30, 13,
 2093, 34, 24, 19,
 2093, 36, 26, 11,
 2093, 37, 20, 18,
 2093, 40, 18, 13,
 2093, 40, 22,  3,
 2094, 37, 23, 14,
 2094, 37, 25, 10,
 2094, 37, 26,  7,
 2094, 38, 19, 17,
 2094, 38, 23, 11,
 2094, 38, 25,  5,
 2096, 36, 20, 20,
 2096, 36, 28,  4,
 2097, 28, 28, 23,
 2097, 32, 28, 17,
 2097, 32, 32,  7,
 2097, 34, 29, 10,
 2097, 35, 26, 14,
 2097, 36, 24, 15,
 2097, 38, 22, 13,
 2097, 39, 24,  0,
 2098, 33, 28, 15,
 2098, 35, 27, 12,
 2098, 36, 21, 19,
 2098, 37, 27,  0,
 2098, 39, 24,  1,
 2099, 29, 27, 23,
 2099, 33, 29, 13,
 2099, 33, 31,  7,
 2099, 37, 21, 17,
 2099, 37, 27,  1,
 2099, 39, 17, 17,
 2099, 39, 23,  7,
 2100, 32, 26, 20,
 2100, 38, 20, 16,
 2100, 40, 20, 10,
 2100, 40, 22,  4,
 2101, 30, 25, 24,
 2101, 38, 24,  9,
 2101, 39, 18, 16,
 2101, 39, 24,  2,
 2102, 30, 29, 19,
 2102, 33, 23, 22,
 2102, 35, 29,  6,
 2102, 37, 27,  2,
 2104, 36, 22, 18,
 2105, 30, 26, 23,
 2105, 34, 25, 18,
 2105, 34, 30,  7,
 2105, 36, 28,  5,
 2105, 38, 25,  6,
 2105, 39, 22, 10,
 2105, 40, 19, 12,
 2105, 40, 21,  8,
 2106, 31, 28, 19,
 2106, 32, 31, 11,
 2106, 33, 24, 21,
 2106, 35, 25, 16,
 2106, 36, 27,  9,
 2106, 39, 21, 12,
 2106, 39, 24,  3,
 2107, 33, 27, 17,
 2107, 35, 21, 21,
 2107, 37, 27,  3,
 2107, 39, 19, 15,
 2109, 29, 28, 22,
 2109, 34, 28, 13,
 2109, 35, 22, 20,
 2109, 35, 28, 10,
 2109, 37, 22, 16,
 2109, 37, 26,  8,
 2109, 40, 22,  5,
 2110, 33, 30, 11,
 2110, 34, 27, 15,
 2110, 38, 21, 15,
 2112, 32, 32,  8,
 2112, 40, 16, 16,
 2113, 30, 27, 22,
 2113, 31, 24, 24,
 2113, 33, 32,  0,
 2113, 39, 24,  4,
 2114, 32, 27, 19,
 2114, 33, 25, 20,
 2114, 33, 31,  8,
 2114, 33, 32,  1,
 2114, 36, 23, 17,
 2114, 37, 24, 13,
 2114, 37, 27,  4,
 2114, 39, 23,  8,
 2114, 40, 17, 15,
 2115, 31, 25, 23,
 2115, 35, 23, 19,
 2115, 35, 29,  7,
 2115, 37, 25, 11,
 2116, 36, 26, 12,
 2116, 36, 28,  6,
 2117, 31, 30, 16,
 2117, 33, 32,  2,
 2117, 34, 31,  0,
 2117, 36, 25, 14,
 2117, 38, 23, 12,
 2117, 39, 20, 14,
 2118, 31, 31, 14,
 2118, 34, 29, 11,
 2118, 34, 31,  1,
 2118, 38, 25,  7,
 2120, 32, 30, 14,
 2120, 34, 30,  8,
 2120, 38, 24, 10,
 2120, 38, 26,  0,
 2120, 40, 18, 14,
 2120, 40, 22,  6,
 2121, 31, 26, 22,
 2121, 32, 29, 16,
 2121, 34, 26, 17,
 2121, 34, 31,  2,
 2121, 38, 26,  1,
 2121, 40, 20, 11,
 2122, 33, 32,  3,
 2122, 39, 24,  5,
 2122, 40, 21,  9,
 2123, 29, 29, 21,
 2123, 35, 27, 13,
 2123, 37, 23, 15,
 2123, 37, 27,  5,
 2124, 30, 30, 18,
 2124, 34, 22, 22,
 2124, 38, 22, 14,
 2124, 38, 26,  2,
 2125, 30, 28, 21,
 2125, 35, 24, 18,
 2125, 35, 30,  0,
 2125, 36, 27, 10,
 2126, 31, 29, 18,
 2126, 33, 26, 19,
 2126, 33, 29, 14,
 2126, 34, 23, 21,
 2126, 34, 31,  3,
 2126, 35, 26, 15,
 2126, 35, 30,  1,
 2126, 37, 26,  9,
 2126, 39, 22, 11,
 2128, 36, 24, 16,
 2129, 32, 24, 23,
 2129, 32, 31, 12,
 2129, 32, 32,  9,
 2129, 33, 28, 16,
 2129, 33, 32,  4,
 2129, 35, 30,  2,
 2129, 36, 28,  7,
 2129, 38, 19, 18,
 2129, 38, 26,  3,
 2129, 40, 23,  0,
 2130, 35, 28, 11,
 2130, 35, 29,  8,
 2130, 37, 20, 19,
 2130, 40, 19, 13,
 2130, 40, 23,  1,
 2131, 31, 27, 21,
 2131, 33, 31,  9,
 2131, 39, 21, 13,
 2131, 39, 23,  9,
 2132, 32, 28, 18,
 2132, 34, 24, 20,
 2133, 32, 25, 22,
 2133, 33, 30, 12,
 2133, 34, 31,  4,
 2133, 38, 20, 17,
 2133, 38, 25,  8,
 2133, 39, 24,  6,
 2133, 40, 22,  7,
 2133, 40, 23,  2,
 2134, 27, 27, 26,
 2134, 35, 30,  3,
 2134, 37, 21, 18,
 2134, 37, 27,  6,
 2134, 39, 18, 17,
 2136, 28, 26, 26,
 2136, 34, 28, 14,
 2136, 38, 26,  4,
 2137, 34, 30,  9,
 2137, 36, 21, 20,
 2137, 36, 29,  0,
 2138, 28, 27, 25,
 2138, 33, 32,  5,
 2138, 36, 29,  1,
 2138, 37, 25, 12,
 2138, 39, 19, 16,
 2138, 40, 23,  3,
 2139, 35, 25, 17,
 2141, 30, 29, 20,
 2141, 32, 26, 21,
 2141, 34, 27, 16,
 2141, 34, 29, 12,
 2141, 35, 30,  4,
 2141, 36, 22, 19,
 2141, 36, 26, 13,
 2141, 36, 29,  2,
 2141, 37, 24, 14,
 2141, 38, 21, 16,
 2141, 38, 24, 11,
 2141, 40, 21, 10,
 2142, 29, 26, 25,
 2142, 33, 27, 18,
 2142, 34, 25, 19,
 2142, 34, 31,  5,
 2142, 37, 22, 17,
 2142, 38, 23, 13,
 2144, 28, 28, 24,
 2144, 36, 28,  8,
 2144, 40, 20, 12,
 2145, 31, 28, 20,
 2145, 37, 26, 10,
 2145, 38, 26,  5,
 2145, 40, 17, 16,
 2145, 40, 23,  4,
 2146, 29, 27, 24,
 2146, 36, 25, 15,
 2146, 36, 27, 11,
 2146, 36, 29,  3,
 2146, 39, 20, 15,
 2146, 39, 24,  7,
 2146, 39, 25,  0,
 2147, 31, 31, 15,
 2147, 33, 23, 23,
 2147, 35, 29,  9,
 2147, 37, 27,  7,
 2147, 39, 25,  1,
 2148, 32, 32, 10,
 2148, 40, 22,  8,
 2149, 32, 30, 15,
 2149, 33, 24, 22,
 2149, 33, 32,  6,
 2149, 36, 23, 18,
 2149, 39, 22, 12,
 2149, 40, 18, 15,
 2150, 30, 25, 25,
 2150, 31, 30, 17,
 2150, 33, 31, 10,
 2150, 35, 22, 21,
 2150, 35, 27, 14,
 2150, 35, 30,  5,
 2150, 38, 25,  9,
 2150, 39, 23, 10,
 2150, 39, 25,  2,
 2152, 30, 26, 24,
 2153, 32, 27, 20,
 2153, 34, 31,  6,
 2153, 35, 28, 12,
 2153, 36, 29,  4,
 2153, 37, 28,  0,
 2153, 38, 22, 15,
 2154, 29, 28, 23,
 2154, 32, 29, 17,
 2154, 32, 31, 13,
 2154, 35, 23, 20,
 2154, 37, 23, 16,
 2154, 37, 28,  1,
 2154, 40, 23,  5,
 2155, 33, 25, 21,
 2155, 33, 29, 15,
 2155, 39, 25,  3,
 2156, 34, 26, 18,
 2156, 34, 30, 10,
 2156, 38, 26,  6,
 2157, 35, 26, 16,
 2157, 37, 28,  2,
 2157, 40, 19, 14,
 2158, 30, 27, 23,
 2158, 33, 30, 13,
 2158, 39, 21, 14,
 2161, 30, 30, 19,
 2161, 35, 30,  6,
 2161, 36, 24, 17,
 2161, 36, 28,  9,
 2161, 39, 24,  8,
 2162, 31, 25, 24,
 2162, 33, 28, 17,
 2162, 33, 32,  7,
 2162, 35, 24, 19,
 2162, 36, 29,  5,
 2162, 37, 27,  8,
 2162, 37, 28,  3,
 2162, 39, 25,  4,
 2162, 40, 21, 11,
 2163, 31, 29, 19,
 2163, 37, 25, 13,
 2164, 38, 24, 12,
 2165, 33, 26, 20,
 2165, 34, 28, 15,
 2165, 40, 22,  9,
 2165, 40, 23,  6,
 2166, 29, 29, 22,
 2166, 31, 26, 23,
 2166, 34, 29, 13,
 2166, 34, 31,  7,
 2166, 35, 29, 10,
 2166, 37, 26, 11,
 2166, 38, 19, 19,
 2168, 30, 28, 22,
 2168, 36, 26, 14,
 2168, 38, 20, 18,
 2169, 32, 28, 19,
 2169, 32, 32, 11,
 2169, 34, 23, 22,
 2169, 36, 27, 12,
 2169, 37, 20, 20,
 2169, 37, 28,  4,
 2169, 38, 23, 14,
 2169, 38, 25, 10,
 2169, 38, 26,  7,
 2169, 39, 18, 18,
 2169, 40, 20, 13,
 2170, 37, 24, 15,
 2171, 33, 31, 11,
 2171, 37, 21, 19,
 2171, 39, 19, 17,
 2171, 39, 23, 11,
 2171, 39, 25,  5,
 2173, 34, 24, 21,
 2173, 36, 29,  6,
 2173, 38, 27,  0,
 2174, 31, 27, 22,
 2174, 34, 27, 17,
 2174, 35, 25, 18,
 2174, 35, 30,  7,
 2174, 38, 21, 17,
 2174, 38, 27,  1,
 2174, 39, 22, 13,
 2176, 32, 24, 24,
 2176, 40, 24,  0,
 2177, 33, 32,  8,
 2177, 34, 30, 11,
 2177, 36, 25, 16,
 2177, 37, 22, 18,
 2177, 38, 27,  2,
 2177, 39, 20, 16,
 2177, 40, 24,  1,
 2178, 31, 31, 16,
 2178, 32, 25, 23,
 2178, 33, 33,  0,
 2178, 35, 28, 13,
 2178, 36, 21, 21,
 2178, 37, 28,  5,
 2178, 39, 24,  9,
 2178, 40, 17, 17,
 2178, 40, 23,  7,
 2179, 33, 27, 19,
 2179, 33, 33,  1,
 2179, 35, 27, 15,
 2179, 37, 27,  9,
 2180, 32, 30, 16,
 2180, 34, 32,  0,
 2180, 36, 22, 20,
 2180, 36, 28, 10,
 2180, 40, 18, 16,
 2180, 40, 24,  2,
 2181, 32, 31, 14,
 2181, 34, 25, 20,
 2181, 34, 31,  8,
 2181, 34, 32,  1,
 2182, 30, 29, 21,
 2182, 33, 33,  2,
 2182, 38, 27,  3,
 2182, 39, 25,  6,
 2184, 32, 26, 22,
 2184, 34, 32,  2,
 2184, 38, 22, 16,
 2184, 38, 26,  8,
 2184, 40, 22, 10,
 2185, 31, 30, 18,
 2185, 33, 30, 14,
 2185, 40, 21, 12,
 2185, 40, 24,  3,
 2186, 31, 28, 21,
 2186, 33, 29, 16,
 2186, 35, 31,  0,
 2186, 36, 23, 19,
 2186, 36, 29,  7,
 2186, 40, 19, 15,
 2187, 27, 27, 27,
 2187, 33, 33,  3,
 2187, 35, 29, 11,
 2187, 35, 31,  1,
 2187, 37, 23, 17,
 2187, 39, 21, 15,
 2189, 28, 27, 26,
 2189, 32, 29, 18,
 2189, 34, 32,  3,
 2189, 35, 30,  8,
 2189, 37, 26, 12,
 2189, 37, 28,  6,
 2189, 38, 24, 13,
 2189, 38, 27,  4,
 2190, 35, 26, 17,
 2190, 35, 31,  2,
 2190, 37, 25, 14,
 2190, 38, 25, 11,
 2192, 32, 32, 12,
 2192, 40, 24,  4,
 2193, 28, 28, 25,
 2193, 29, 26, 26,
 2193, 34, 26, 19,
 2193, 34, 29, 14,
 2193, 35, 22, 22,
 2193, 40, 23,  8,
 2194, 32, 27, 21,
 2194, 33, 24, 23,
 2194, 33, 31, 12,
 2194, 33, 32,  9,
 2194, 33, 33,  4,
 2194, 36, 27, 13,
 2194, 39, 23, 12,
 2195, 29, 27, 25,
 2195, 35, 23, 21,
 2195, 35, 31,  3,
 2195, 39, 25,  7,
 2196, 34, 28, 16,
 2196, 34, 32,  4,
 2196, 36, 24, 18,
 2196, 36, 30,  0,
 2196, 40, 20, 14,
 2197, 33, 28, 18,
 2197, 36, 26, 15,
 2197, 36, 30,  1,
 2197, 39, 24, 10,
 2197, 39, 26,  0,
 2198, 33, 25, 22,
 2198, 34, 31,  9,
 2198, 37, 27, 10,
 2198, 38, 23, 15,
 2198, 38, 27,  5,
 2198, 39, 26,  1,
 2200, 30, 30, 20,
 2200, 34, 30, 12,
 2200, 36, 30,  2,
 2201, 29, 28, 24,
 2201, 30, 26, 25,
 2201, 35, 24, 20,
 2201, 36, 28, 11,
 2201, 36, 29,  8,
 2201, 37, 24, 16,
 2201, 38, 26,  9,
 2201, 39, 22, 14,
 2201, 39, 26,  2,
 2201, 40, 24,  5,
 2202, 31, 29, 20,
 2202, 35, 31,  4,
 2202, 37, 28,  7,
 2203, 33, 33,  5,
 2205, 30, 27, 24,
 2205, 34, 32,  5,
 2205, 35, 28, 14,
 2205, 36, 30,  3,
 2205, 38, 20, 19,
 2205, 40, 22, 11,
 2206, 33, 26, 21,
 2206, 35, 30,  9,
 2206, 39, 19, 18,
 2206, 39, 26,  3,
 2208, 32, 28, 20,
 2209, 34, 27, 18,
 2209, 38, 21, 18,
 2209, 38, 27,  6,
 2210, 32, 31, 15,
 2210, 35, 27, 16,
 2210, 35, 29, 12,
 2210, 36, 25, 17,
 2210, 37, 21, 20,
 2210, 37, 29,  0,
 2210, 39, 20, 17,
 2210, 39, 25,  8,
 2210, 40, 21, 13,
 2210, 40, 23,  9,
 2211, 29, 29, 23,
 2211, 31, 25, 25,
 2211, 31, 31, 17,
 2211, 35, 25, 19,
 2211, 35, 31,  5,
 2211, 37, 29,  1,
 2212, 36, 30,  4,
 2212, 40, 24,  6,
 2213, 30, 28, 23,
 2213, 31, 26, 24,
 2213, 32, 30, 17,
 2213, 33, 32, 10,
 2213, 38, 25, 12,
 2213, 39, 26,  4,
 2213, 40, 18, 17,
 2214, 33, 30, 15,
 2214, 33, 33,  6,
 2214, 34, 23, 23,
 2214, 37, 22, 19,
 2214, 37, 26, 13,
 2214, 37, 29,  2,
 2216, 34, 24, 22,
 2216, 34, 32,  6,
 2216, 38, 24, 14,
 2217, 32, 32, 13,
 2217, 34, 31, 10,
 2217, 37, 28,  8,
 2217, 38, 22, 17,
 2217, 40, 19, 16,
 2218, 33, 27, 20,
 2218, 36, 29,  9,
 2218, 39, 21, 16,
 2218, 39, 24, 11,
 2219, 31, 27, 23,
 2219, 33, 29, 17,
 2219, 33, 31, 13,
 2219, 37, 25, 15,
 2219, 37, 27, 11,
 2219, 37, 29,  3,
 2219, 39, 23, 13,
 2220, 38, 26, 10,
 2221, 36, 22, 21,
 2221, 36, 27, 14,
 2221, 36, 30,  5,
 2222, 31, 30, 19,
 2222, 34, 25, 21,
 2222, 34, 29, 15,
 2222, 35, 31,  6,
 2222, 37, 23, 18,
 2222, 38, 27,  7,
 2222, 39, 26,  5,
 2224, 36, 28, 12,
 2225, 30, 29, 22,
 2225, 32, 25, 24,
 2225, 34, 30, 13,
 2225, 35, 26, 18,
 2225, 35, 30, 10,
 2225, 36, 23, 20,
 2225, 40, 20, 15,
 2225, 40, 24,  7,
 2225, 40, 25,  0,
 2226, 32, 29, 19,
 2226, 37, 29,  4,
 2226, 40, 25,  1,
 2227, 33, 33,  7,
 2227, 39, 25,  9,
 2228, 36, 26, 16,
 2228, 38, 28,  0,
 2228, 40, 22, 12,
 2229, 31, 28, 22,
 2229, 32, 26, 23,
 2229, 34, 28, 17,
 2229, 34, 32,  7,
 2229, 38, 23, 16,
 2229, 38, 28,  1,
 2229, 40, 23, 10,
 2229, 40, 25,  2,
 2230, 39, 22, 15,
 2232, 34, 26, 20,
 2232, 36, 30,  6,
 2232, 38, 28,  2,
 2233, 36, 24, 19,
 2233, 39, 26,  6,
 2234, 33, 28, 19,
 2234, 33, 32, 11,
 2234, 35, 28, 15,
 2234, 37, 24, 17,
 2234, 37, 28,  9,
 2234, 40, 25,  3,
 2235, 35, 29, 13,
 2235, 35, 31,  7,
 2235, 37, 29,  5,
 2237, 32, 27, 22,
 2237, 36, 29, 10,
 2237, 38, 27,  8,
 2237, 38, 28,  3,
 2237, 40, 21, 14,
 2238, 34, 31, 11,
 2238, 35, 23, 22,
 2238, 38, 25, 13,
 2240, 40, 24,  8,
 2241, 30, 30, 21,
 2241, 32, 31, 16,
 2241, 33, 24, 24,
 2241, 37, 26, 14,
 2241, 38, 26, 11,
 2241, 39, 24, 12,
 2241, 40, 25,  4,
 2242, 28, 27, 27,
 2242, 33, 33,  8,
 2242, 35, 24, 21,
 2242, 37, 27, 12,
 2243, 31, 29, 21,
 2243, 33, 25, 23,
 2243, 35, 27, 17,
 2243, 39, 19, 19,
 2244, 28, 28, 26,
 2244, 32, 32, 14,
 2244, 34, 32,  8,
 2244, 38, 20, 20,
 2244, 38, 28,  4,
 2245, 33, 30, 16,
 2245, 34, 33,  0,
 2245, 36, 25, 18,
 2245, 36, 30,  7,
 2245, 38, 24, 15,
 2245, 39, 20, 18,
 2246, 29, 27, 26,
 2246, 31, 31, 18,
 2246, 33, 31, 14,
 2246, 34, 27, 19,
 2246, 34, 33,  1,
 2246, 35, 30, 11,
 2246, 37, 29,  6,
 2246, 38, 21, 19,
 2246, 39, 23, 14,
 2246, 39, 25, 10,
 2246, 39, 26,  7,
 2248, 32, 30, 18,
 2248, 40, 18, 18,
 2249, 32, 28, 21,
 2249, 33, 26, 22,
 2249, 34, 33,  2,
 2249, 35, 32,  0,
 2249, 36, 28, 13,
 2250, 29, 28, 25,
 2250, 35, 25, 20,
 2250, 35, 31,  8,
 2250, 35, 32,  1,
 2250, 36, 27, 15,
 2250, 37, 25, 16,
 2250, 39, 27,  0,
 2250, 40, 19, 17,
 2250, 40, 23, 11,
 2250, 40, 25,  5,
 2251, 37, 21, 21,
 2251, 39, 21, 17,
 2251, 39, 27,  1,
 2252, 30, 26, 26,
 2252, 34, 30, 14,
 2252, 38, 22, 18,
 2253, 34, 29, 16,
 2253, 35, 32,  2,
 2253, 37, 22, 20,
 2253, 37, 28, 10,
 2253, 38, 28,  5,
 2253, 40, 22, 13,
 2254, 30, 27, 25,
 2254, 33, 29, 18,
 2254, 34, 33,  3,
 2254, 38, 27,  9,
 2254, 39, 27,  2,
 2256, 40, 20, 16,
 2257, 33, 32, 12,
 2257, 36, 31,  0,
 2257, 40, 24,  9,
 2258, 29, 29, 24,
 2258, 35, 32,  3,
 2258, 36, 29, 11,
 2258, 36, 31,  1,
 2259, 33, 27, 21,
 2259, 33, 33,  9,
 2259, 37, 23, 19,
 2259, 37, 29,  7,
 2259, 39, 27,  3,
 2260, 30, 28, 24,
 2260, 36, 30,  8,
 2261, 31, 30, 20,
 2261, 34, 24, 23,
 2261, 34, 31, 12,
 2261, 34, 32,  9,
 2261, 34, 33,  4,
 2261, 36, 26, 17,
 2261, 36, 31,  2,
 2261, 39, 22, 16,
 2261, 39, 26,  8,
 2261, 40, 25,  6,
 2262, 31, 26, 25,
 2262, 35, 26, 19,
 2262, 35, 29, 14,
 2262, 38, 23, 17,
 2264, 34, 28, 18,
 2264, 36, 22, 22,
 2264, 38, 26, 12,
 2264, 38, 28,  6,
 2265, 32, 29, 20,
 2265, 34, 25, 22,
 2265, 35, 28, 16,
 2265, 35, 32,  4,
 2265, 38, 25, 14,
 2266, 31, 27, 24,
 2266, 36, 23, 21,
 2266, 36, 31,  3,
 2266, 39, 24, 13,
 2266, 39, 27,  4,
 2266, 40, 21, 15,
 2267, 35, 31,  9,
 2267, 37, 27, 13,
 2267, 39, 25, 11,
 2269, 35, 30, 12,
 2269, 37, 24, 18,
 2269, 37, 30,  0,
 2270, 30, 29, 23,
 2270, 34, 33,  5,
 2270, 37, 26, 15,
 2270, 37, 30,  1,
 2272, 36, 24, 20,
 2273, 32, 32, 15,
 2273, 33, 28, 20,
 2273, 34, 26, 21,
 2273, 36, 31,  4,
 2273, 37, 30,  2,
 2273, 38, 27, 10,
 2273, 40, 23, 12,
 2274, 31, 28, 23,
 2274, 32, 25, 25,
 2274, 32, 31, 17,
 2274, 35, 32,  5,
 2274, 37, 28, 11,
 2274, 37, 29,  8,
 2274, 40, 25,  7,
 2275, 33, 31, 15,
 2275, 39, 23, 15,
 2275, 39, 27,  5,
 2276, 32, 26, 24,
 2276, 36, 28, 14,
 2276, 38, 24, 16,
 2276, 40, 24, 10,
 2276, 40, 26,  0,
 2277, 36, 30,  9,
 2277, 38, 28,  7,
 2277, 40, 26,  1,
 2278, 33, 30, 17,
 2278, 33, 33, 10,
 2278, 35, 27, 18,
 2278, 37, 30,  3,
 2278, 39, 26,  9,
 2280, 34, 32, 10,
 2280, 40, 22, 14,
 2280, 40, 26,  2,
 2281, 34, 30, 15,
 2281, 34, 33,  6,
 2281, 36, 27, 16,
 2281, 36, 29, 12,
 2282, 32, 27, 23,
 2282, 33, 32, 13,
 2282, 36, 25, 19,
 2282, 36, 31,  5,
 2282, 39, 20, 19,
 2283, 31, 31, 19,
 2283, 35, 23, 23,
 2283, 37, 25, 17,
 2284, 30, 30, 22,
 2285, 32, 30, 19,
 2285, 34, 27, 20,
 2285, 35, 24, 22,
 2285, 35, 32,  6,
 2285, 37, 30,  4,
 2285, 38, 21, 20,
 2285, 38, 29,  0,
 2285, 40, 19, 18,
 2285, 40, 26,  3,
 2286, 31, 29, 22,
 2286, 34, 29, 17,
 2286, 34, 31, 13,
 2286, 35, 31, 10,
 2286, 38, 29,  1,
 2286, 39, 21, 18,
 2286, 39, 27,  6,
 2289, 38, 22, 19,
 2289, 38, 26, 13,
 2289, 38, 29,  2,
 2289, 40, 20, 17,
 2289, 40, 25,  8,
 2290, 33, 25, 24,
 2290, 39, 25, 12,
 2291, 33, 29, 19,
 2291, 35, 25, 21,
 2291, 35, 29, 15,
 2291, 37, 29,  9,
 2292, 32, 28, 22,
 2292, 38, 28,  8,
 2292, 40, 26,  4,
 2293, 36, 31,  6,
 2293, 39, 24, 14,
 2294, 33, 26, 23,
 2294, 34, 33,  7,
 2294, 35, 30, 13,
 2294, 37, 22, 21,
 2294, 37, 27, 14,
 2294, 37, 30,  5,
 2294, 38, 25, 15,
 2294, 38, 27, 11,
 2294, 38, 29,  3,
 2294, 39, 22, 17,
 2296, 36, 26, 18,
 2296, 36, 30, 10,
 2297, 28, 28, 27,
 2297, 37, 28, 12,
 2297, 38, 23, 18,
 2297, 39, 26, 10,
 2297, 40, 21, 16,
 2297, 40, 24, 11,
 2298, 35, 28, 17,
 2298, 35, 32,  7,
 2298, 37, 23, 20,
 2298, 40, 23, 13,
 2299, 29, 27, 27,
 2299, 33, 33, 11,
 2299, 39, 27,  7,
 2301, 29, 28, 26,
 2301, 34, 28, 19,
 2301, 34, 32, 11,
 2301, 35, 26, 20,
 2301, 37, 26, 16,
 2301, 38, 29,  4,
 2301, 40, 26,  5,
 2302, 31, 30, 21,
 2302, 33, 27, 22,
 2304, 32, 32, 16,
 2305, 30, 27, 26,
 2305, 36, 28, 15,
 2305, 37, 30,  6,
 2305, 39, 28,  0,
 2306, 32, 29, 21,
 2306, 33, 31, 16,
 2306, 36, 29, 13,
 2306, 36, 31,  7,
 2306, 37, 24, 19,
 2306, 39, 23, 16,
 2306, 39, 28,  1,
 2306, 40, 25,  9,
 2307, 29, 29, 25,
 2307, 35, 31, 11,
 2308, 34, 24, 24,
 2309, 30, 28, 25,
 2309, 32, 31, 18,
 2309, 33, 32, 14,
 2309, 34, 33,  8,
 2309, 36, 23, 22,
 2309, 38, 24, 17,
 2309, 38, 28,  9,
 2309, 39, 28,  2,
 2309, 40, 22, 15,
 2310, 34, 25, 23,
 2310, 37, 29, 10,
 2310, 38, 29,  5,
 2312, 34, 30, 16,
 2312, 34, 34,  0,
 2312, 40, 26,  6,
 2313, 31, 26, 26,
 2313, 33, 30, 18,
 2313, 34, 31, 14,
 2313, 34, 34,  1,
 2313, 35, 32,  8,
 2313, 36, 24, 21,
 2314, 33, 28, 21,
 2314, 35, 33,  0,
 2314, 36, 27, 17,
 2314, 39, 27,  8,
 2314, 39, 28,  3,
 2315, 31, 27, 25,
 2315, 35, 27, 19,
 2315, 35, 33,  1,
 2315, 39, 25, 13,
 2316, 34, 26, 22,
 2316, 34, 34,  2,
 2316, 38, 26, 14,
 2317, 30, 29, 24,
 2317, 36, 30, 11,
 2317, 38, 27, 12,
 2318, 35, 33,  2,
 2318, 37, 25, 18,
 2318, 37, 30,  7,
 2318, 39, 26, 11,
 2320, 36, 32,  0,
 2320, 40, 24, 12,
 2321, 31, 28, 24,
 2321, 34, 29, 18,
 2321, 34, 34,  3,
 2321, 35, 30, 14,
 2321, 36, 25, 20,
 2321, 36, 31,  8,
 2321, 36, 32,  1,
 2321, 38, 29,  6,
 2321, 39, 20, 20,
 2321, 39, 28,  4,
 2322, 31, 31, 20,
 2322, 33, 33, 12,
 2322, 35, 29, 16,
 2322, 37, 28, 13,
 2322, 39, 24, 15,
 2322, 40, 19, 19,
 2323, 35, 33,  3,
 2323, 37, 27, 15,
 2323, 39, 21, 19,
 2324, 32, 30, 20,
 2324, 34, 32, 12,
 2324, 36, 32,  2,
 2324, 40, 20, 18,
 2325, 32, 26, 25,
 2325, 38, 25, 16,
 2325, 40, 23, 14,
 2325, 40, 25, 10,
 2325, 40, 26,  7,
 2326, 34, 27, 21,
 2326, 34, 33,  9,
 2326, 38, 21, 21,
 2328, 34, 34,  4,
 2328, 38, 22, 20,
 2328, 38, 28, 10,
 2329, 30, 30, 23,
 2329, 32, 27, 24,
 2329, 36, 32,  3,
 2329, 39, 22, 18,
 2329, 40, 27,  0,
 2330, 33, 29, 20,
 2330, 35, 24, 23,
 2330, 35, 31, 12,
 2330, 35, 32,  9,
 2330, 35, 33,  4,
 2330, 37, 31,  0,
 2330, 39, 28,  5,
 2330, 40, 21, 17,
 2330, 40, 27,  1,
 2331, 31, 29, 23,
 2331, 37, 29, 11,
 2331, 37, 31,  1,
 2331, 39, 27,  9,
 2333, 35, 28, 18,
 2333, 36, 26, 19,
 2333, 36, 29, 14,
 2333, 37, 30,  8,
 2333, 40, 27,  2,
 2334, 35, 25, 22,
 2334, 37, 26, 17,
 2334, 37, 31,  2,
 2334, 38, 23, 19,
 2334, 38, 29,  7,
 2336, 36, 28, 16,
 2336, 36, 32,  4,
 2337, 32, 28, 23,
 2337, 32, 32, 17,
 2337, 34, 34,  5,
 2337, 37, 22, 22,
 2338, 33, 32, 15,
 2338, 36, 31,  9,
 2338, 40, 27,  3,
 2339, 33, 25, 25,
 2339, 33, 31, 17,
 2339, 35, 33,  5,
 2339, 37, 23, 21,
 2339, 37, 31,  3,
 2339, 39, 23, 17,
 2340, 34, 28, 20,
 2340, 36, 30, 12,
 2340, 40, 22, 16,
 2340, 40, 26,  8,
 2341, 33, 26, 24,
 2341, 39, 26, 12,
 2341, 39, 28,  6,
 2342, 34, 31, 15,
 2342, 35, 26, 21,
 2342, 38, 27, 13,
 2342, 39, 25, 14,
 2344, 38, 24, 18,
 2344, 38, 30,  0,
 2345, 31, 30, 22,
 2345, 34, 30, 17,
 2345, 34, 33, 10,
 2345, 36, 32,  5,
 2345, 37, 24, 20,
 2345, 38, 26, 15,
 2345, 38, 30,  1,
 2345, 40, 24, 13,
 2345, 40, 27,  4,
 2346, 32, 31, 19,
 2346, 37, 31,  4,
 2346, 40, 25, 11,
 2347, 33, 27, 23,
 2347, 33, 33, 13,
 2348, 34, 34,  6,
 2348, 38, 30,  2,
 2349, 32, 29, 22,
 2349, 34, 32, 13,
 2349, 35, 32, 10,
 2349, 36, 27, 18,
 2349, 37, 28, 14,
 2349, 38, 28, 11,
 2349, 38, 29,  8,
 2350, 33, 30, 19,
 2350, 35, 30, 15,
 2350, 35, 33,  6,
 2350, 37, 30,  9,
 2350, 39, 27, 10,
 2352, 28, 28, 28,
 2353, 38, 30,  3,
 2353, 39, 24, 16,
 2354, 29, 28, 27,
 2354, 35, 27, 20,
 2354, 36, 23, 23,
 2354, 37, 27, 16,
 2354, 37, 29, 12,
 2354, 39, 28,  7,
 2354, 40, 23, 15,
 2354, 40, 27,  5,
 2355, 35, 29, 17,
 2355, 35, 31, 13,
 2355, 37, 25, 19,
 2355, 37, 31,  5,
 2356, 36, 24, 22,
 2356, 36, 32,  6,
 2357, 33, 28, 22,
 2357, 34, 25, 24,
 2357, 36, 31, 10,
 2357, 40, 26,  9,
 2358, 29, 29, 26,
 2358, 30, 27, 27,
 2358, 34, 29, 19,
 2358, 38, 25, 17,
 2360, 30, 28, 26,
 2360, 38, 30,  4,
 2361, 34, 26, 23,
 2361, 34, 34,  7,
 2361, 40, 20, 19,
 2362, 36, 25, 21,
 2362, 36, 29, 15,
 2362, 39, 21, 20,
 2362, 39, 29,  0,
 2363, 31, 31, 21,
 2363, 35, 33,  7,
 2363, 39, 29,  1,
 2365, 32, 30, 21,
 2365, 36, 30, 13,
 2365, 40, 21, 18,
 2365, 40, 27,  6,
 2366, 30, 29, 25,
 2366, 31, 27, 26,
 2366, 34, 33, 11,
 2366, 37, 31,  6,
 2366, 38, 29,  9,
 2366, 39, 22, 19,
 2366, 39, 26, 13,
 2366, 39, 29,  2,
 2369, 33, 32, 16,
 2369, 34, 27, 22,
 2369, 36, 28, 17,
 2369, 36, 32,  7,
 2369, 37, 26, 18,
 2369, 37, 30, 10,
 2369, 38, 22, 21,
 2369, 38, 27, 14,
 2369, 38, 30,  5,
 2369, 39, 28,  8,
 2369, 40, 25, 12,
 2370, 31, 28, 25,
 2370, 35, 28, 19,
 2370, 35, 32, 11,
 2371, 33, 29, 21,
 2371, 39, 25, 15,
 2371, 39, 27, 11,
 2371, 39, 29,  3,
 2372, 32, 32, 18,
 2372, 36, 26, 20,
 2372, 38, 28, 12,
 2372, 40, 24, 14,
 2373, 34, 31, 16,
 2373, 38, 23, 20,
 2373, 40, 22, 17,
 2374, 33, 31, 18,
 2374, 33, 33, 14,
 2374, 39, 23, 18,
 2376, 30, 30, 24,
 2376, 32, 26, 26,
 2376, 34, 32, 14,
 2376, 34, 34,  8,
 2376, 38, 26, 16,
 2376, 40, 26, 10,
 2377, 35, 24, 24,
 2378, 31, 29, 24,
 2378, 32, 27, 25,
 2378, 35, 33,  8,
 2378, 36, 31, 11,
 2378, 37, 28, 15,
 2378, 39, 29,  4,
 2378, 40, 27,  7,
 2379, 35, 25, 23,
 2379, 37, 29, 13,
 2379, 37, 31,  7,
 2380, 34, 30, 18,
 2380, 38, 30,  6,
 2381, 34, 28, 21,
 2381, 35, 30, 16,
 2381, 35, 34,  0,
 2381, 38, 24, 19,
 2382, 35, 31, 14,
 2382, 35, 34,  1,
 2382, 37, 23, 22,
 2384, 32, 28, 24,
 2384, 36, 32,  8,
 2384, 40, 28,  0,
 2385, 32, 31, 20,
 2385, 35, 26, 22,
 2385, 35, 34,  2,
 2385, 36, 33,  0,
 2385, 38, 29, 10,
 2385, 40, 23, 16,
 2385, 40, 28,  1,
 2386, 36, 27, 19,
 2386, 36, 33,  1,
 2386, 37, 24, 21,
 2386, 39, 24, 17,
 2386, 39, 28,  9,
 2387, 37, 27, 17,
 2387, 39, 29,  5,
 2388, 40, 28,  2,
 2389, 33, 30, 20,
 2389, 34, 33, 12,
 2389, 36, 33,  2,
 2390, 31, 30, 23,
 2390, 33, 26, 25,
 2390, 35, 29, 18,
 2390, 35, 34,  3,
 2390, 37, 30, 11,
 2392, 36, 30, 14,
 2393, 34, 34,  9,
 2393, 35, 32, 12,
 2393, 36, 29, 16,
 2393, 37, 32,  0,
 2393, 38, 25, 18,
 2393, 38, 30,  7,
 2393, 39, 26, 14,
 2393, 40, 27,  8,
 2393, 40, 28,  3,
 2394, 32, 29, 23,
 2394, 33, 27, 24,
 2394, 36, 33,  3,
 2394, 37, 25, 20,
 2394, 37, 31,  8,
 2394, 37, 32,  1,
 2394, 39, 27, 12,
 2394, 40, 25, 13,
 2395, 35, 27, 21,
 2395, 35, 33,  9,
 2397, 34, 29, 20,
 2397, 35, 34,  4,
 2397, 37, 32,  2,
 2397, 38, 28, 13,
 2397, 40, 26, 11,
 2398, 38, 27, 15,
 2398, 39, 29,  6,
 2400, 40, 20, 20,
 2400, 40, 28,  4,
 2401, 36, 24, 23,
 2401, 36, 31, 12,
 2401, 36, 32,  9,
 2401, 36, 33,  4,
 2401, 40, 24, 15,
 2402, 33, 28, 23,
 2402, 33, 32, 17,
 2402, 37, 32,  3,
 2402, 39, 25, 16,
 2402, 40, 21, 19,
 2403, 33, 33, 15,
 2403, 39, 21, 21,
 2404, 36, 28, 18,
 2405, 34, 32, 15,
 2405, 36, 25, 22,
 2405, 38, 31,  0,
 2405, 39, 22, 20,
 2405, 39, 28, 10,
 2406, 31, 31, 22,
 2406, 34, 25, 25,
 2406, 34, 31, 17,
 2406, 35, 34,  5,
 2406, 37, 26, 19,
 2406, 37, 29, 14,
 2406, 38, 29, 11,
 2406, 38, 31,  1,
 2408, 32, 30, 22,
 2408, 34, 26, 24,
 2408, 38, 30,  8,
 2408, 40, 22, 18,
 2409, 29, 28, 28,
 2409, 32, 32, 19,
 2409, 35, 28, 20,
 2409, 37, 28, 16,
 2409, 37, 32,  4,
 2409, 38, 26, 17,
 2409, 38, 31,  2,
 2409, 40, 28,  5,
 2410, 36, 33,  5,
 2410, 40, 27,  9,
 2411, 29, 29, 27,
 2411, 33, 31, 19,
 2411, 35, 31, 15,
 2411, 37, 31,  9,
 2411, 39, 23, 19,
 2411, 39, 29,  7,
 2412, 34, 34, 10,
 2412, 38, 22, 22,
 2413, 30, 28, 27,
 2413, 36, 26, 21,
 2413, 37, 30, 12,
 2414, 33, 29, 22,
 2414, 34, 27, 23,
 2414, 34, 33, 13,
 2414, 35, 30, 17,
 2414, 35, 33, 10,
 2414, 38, 23, 21,
 2414, 38, 31,  3,
 2417, 30, 29, 26,
 2417, 34, 30, 19,
 2417, 35, 34,  6,
 2418, 35, 32, 13,
 2418, 37, 32,  5,
 2418, 40, 23, 17,
 2419, 31, 27, 27,
 2419, 39, 27, 13,
 2420, 36, 32, 10,
 2420, 38, 24, 20,
 2420, 40, 26, 12,
 2420, 40, 28,  6,
 2421, 31, 28, 26,
 2421, 36, 30, 15,
 2421, 36, 33,  6,
 2421, 38, 31,  4,
 2421, 39, 24, 18,
 2421, 39, 30,  0,
 2421, 40, 25, 14,
 2422, 37, 27, 18,
 2422, 39, 26, 15,
 2422, 39, 30,  1,
 2424, 34, 28, 22,
 2424, 38, 28, 14,
 2425, 30, 30, 25,
 2425, 36, 27, 20,
 2425, 38, 30,  9,
 2425, 39, 30,  2,
 2426, 32, 31, 21,
 2426, 35, 25, 24,
 2426, 36, 29, 17,
 2426, 36, 31, 13,
 2426, 39, 28, 11,
 2426, 39, 29,  8,
 2427, 31, 29, 25,
 2427, 35, 29, 19,
 2427, 37, 23, 23,
 2429, 32, 27, 26,
 2429, 37, 24, 22,
 2429, 37, 32,  6,
 2429, 38, 27, 16,
 2429, 38, 29, 12,
 2429, 40, 27, 10,
 2430, 33, 30, 21,
 2430, 35, 26, 23,
 2430, 35, 34,  7,
 2430, 37, 31, 10,
 2430, 38, 25, 19,
 2430, 38, 31,  5,
 2430, 39, 30,  3,
 2432, 40, 24, 16,
 2433, 32, 28, 25,
 2433, 34, 34, 11,
 2433, 40, 28,  7,
 2434, 33, 33, 16,
 2434, 36, 33,  7,
 2435, 35, 33, 11,
 2435, 37, 25, 21,
 2435, 37, 29, 15,
 2435, 39, 25, 17,
 2436, 34, 32, 16,
 2437, 31, 30, 24,
 2437, 33, 32, 18,
 2437, 39, 30,  4,
 2438, 34, 29, 21,
 2438, 35, 27, 22,
 2438, 37, 30, 13,
 2441, 32, 29, 24,
 2441, 33, 26, 26,
 2441, 34, 31, 18,
 2441, 34, 33, 14,
 2441, 36, 28, 19,
 2441, 36, 32, 11,
 2441, 38, 31,  6,
 2441, 40, 21, 20,
 2441, 40, 29,  0,
 2442, 35, 31, 16,
 2442, 37, 28, 17,
 2442, 37, 32,  7,
 2442, 40, 29,  1,
 2443, 33, 27, 25,
 2443, 39, 29,  9,
 2444, 38, 26, 18,
 2444, 38, 30, 10,
 2445, 35, 32, 14,
 2445, 35, 34,  8,
 2445, 37, 26, 20,
 2445, 40, 22, 19,
 2445, 40, 26, 13,
 2445, 40, 29,  2,
 2446, 39, 22, 21,
 2446, 39, 27, 14,
 2446, 39, 30,  5,
 2448, 32, 32, 20,
 2448, 36, 24, 24,
 2448, 40, 28,  8,
 2449, 33, 28, 24,
 2449, 35, 30, 18,
 2449, 36, 33,  8,
 2449, 39, 28, 12,
 2450, 33, 31, 20,
 2450, 35, 28, 21,
 2450, 35, 35,  0,
 2450, 36, 25, 23,
 2450, 39, 23, 20,
 2450, 40, 25, 15,
 2450, 40, 27, 11,
 2450, 40, 29,  3,
 2451, 31, 31, 23,
 2451, 35, 35,  1,
 2451, 37, 31, 11,
 2452, 36, 30, 16,
 2452, 36, 34,  0,
 2453, 32, 30, 23,
 2453, 36, 31, 14,
 2453, 36, 34,  1,
 2453, 38, 28, 15,
 2453, 39, 26, 16,
 2453, 40, 23, 18,
 2454, 35, 35,  2,
 2454, 38, 29, 13,
 2454, 38, 31,  7,
 2456, 34, 30, 20,
 2456, 34, 34, 12,
 2456, 36, 26, 22,
 2456, 36, 34,  2,
 2457, 34, 26, 25,
 2457, 37, 32,  8,
 2457, 38, 23, 22,
 2457, 39, 30,  6,
 2457, 40, 29,  4,
 2458, 35, 33, 12,
 2458, 37, 33,  0,
 2458, 39, 24, 19,
 2459, 33, 29, 23,
 2459, 35, 35,  3,
 2459, 37, 27, 19,
 2459, 37, 33,  1,
 2461, 34, 27, 24,
 2461, 36, 29, 18,
 2461, 36, 34,  3,
 2461, 38, 24, 21,
 2462, 35, 34,  9,
 2462, 37, 33,  2,
 2462, 38, 27, 17,
 2462, 39, 29, 10,
 2464, 36, 32, 12,
 2465, 37, 30, 14,
 2465, 38, 30, 11,
 2465, 40, 24, 17,
 2465, 40, 28,  9,
 2466, 29, 29, 28,
 2466, 35, 29, 20,
 2466, 35, 35,  4,
 2466, 36, 27, 21,
 2466, 36, 33,  9,
 2466, 37, 29, 16,
 2466, 40, 29,  5,
 2467, 33, 33, 17,
 2467, 37, 33,  3,
 2468, 30, 28, 28,
 2468, 36, 34,  4,
 2468, 38, 32,  0,
 2469, 32, 31, 22,
 2469, 34, 28, 23,
 2469, 34, 32, 17,
 2469, 38, 25, 20,
 2469, 38, 31,  8,
 2469, 38, 32,  1,
 2470, 30, 29, 27,
 2470, 34, 33, 15,
 2470, 39, 25, 18,
 2470, 39, 30,  7,
 2472, 38, 32,  2,
 2472, 40, 26, 14,
 2473, 33, 30, 22,
 2473, 40, 27, 12,
 2474, 31, 28, 27,
 2474, 33, 32, 19,
 2474, 35, 32, 15,
 2474, 37, 24, 23,
 2474, 37, 31, 12,
 2474, 37, 32,  9,
 2474, 37, 33,  4,
 2474, 39, 28, 13,
 2475, 35, 25, 25,
 2475, 35, 31, 17,
 2475, 35, 35,  5,
 2475, 39, 27, 15,
 2476, 30, 30, 26,
 2477, 35, 26, 24,
 2477, 36, 34,  5,
 2477, 37, 28, 18,
 2477, 38, 32,  3,
 2477, 40, 29,  6,
 2478, 31, 29, 26,
 2478, 34, 31, 19,
 2478, 37, 25, 22,
 2480, 36, 28, 20,
 2481, 34, 29, 22,
 2481, 34, 34, 13,
 2481, 35, 34, 10,
 2481, 38, 26, 19,
 2481, 38, 29, 14,
 2481, 40, 25, 16,
 2482, 32, 27, 27,
 2482, 36, 31, 15,
 2482, 39, 31,  0,
 2482, 40, 21, 21,
 2483, 35, 27, 23,
 2483, 35, 33, 13,
 2483, 37, 33,  5,
 2483, 39, 29, 11,
 2483, 39, 31,  1,
 2484, 32, 28, 26,
 2484, 38, 28, 16,
 2484, 38, 32,  4,
 2484, 40, 22, 20,
 2484, 40, 28, 10,
 2485, 36, 30, 17,
 2485, 36, 33, 10,
 2485, 39, 30,  8,
 2486, 31, 30, 25,
 2486, 35, 30, 19,
 2486, 35, 35,  6,
 2486, 37, 26, 21,
 2486, 38, 31,  9,
 2486, 39, 26, 17,
 2486, 39, 31,  2,
 2488, 36, 34,  6,
 2488, 38, 30, 12,
 2489, 32, 32, 21,
 2489, 36, 32, 13,
 2489, 39, 22, 22,
 2490, 32, 29, 25,
 2490, 40, 23, 19,
 2490, 40, 29,  7,
 2491, 33, 31, 21,
 2491, 39, 23, 21,
 2491, 39, 31,  3,
 2493, 35, 28, 22,
 2493, 37, 32, 10,
 2493, 38, 32,  5,
 2494, 33, 27, 26,
 2494, 37, 30, 15,
 2494, 37, 33,  6,
 2497, 34, 30, 21,
 2497, 36, 25, 24,
 2497, 38, 27, 18,
 2497, 39, 24, 20,
 2498, 31, 31, 24,
 2498, 33, 28, 25,
 2498, 36, 29, 19,
 2498, 37, 27, 20,
 2498, 39, 31,  4,
 2498, 40, 27, 13,
 2499, 35, 35,  7,
 2499, 37, 29, 17,
 2499, 37, 31, 13,
 2500, 32, 30, 24,
 2500, 40, 24, 18,
 2500, 40, 30,  0,
 2501, 34, 33, 16,
 2501, 36, 26, 23,
 2501, 36, 34,  7,
 2501, 39, 28, 14,
 2501, 40, 26, 15,
 2501, 40, 30,  1,
 2502, 33, 33, 18,
 2502, 35, 34, 11,
 2502, 38, 23, 23,
 2502, 39, 30,  9,
 2504, 34, 32, 18,
 2504, 38, 24, 22,
 2504, 38, 32,  6,
 2504, 40, 30,  2,
 2505, 35, 32, 16,
 2505, 38, 31, 10,
 2505, 40, 28, 11,
 2505, 40, 29,  8,
 2506, 33, 29, 24,
 2506, 36, 33, 11,
 2506, 39, 27, 16,
 2506, 39, 29, 12,
 2507, 35, 29, 21,
 2507, 37, 33,  7,
 2507, 39, 25, 19,
 2507, 39, 31,  5,
 2508, 34, 26, 26,
 2508, 34, 34, 14,
 2509, 36, 27, 22,
 2509, 40, 30,  3,
 2510, 34, 27, 25,
 2510, 35, 31, 18,
 2510, 35, 33, 14,
 2510, 38, 25, 21,
 2510, 38, 29, 15,
 2513, 33, 32, 20,
 2513, 36, 31, 16,
 2513, 38, 30, 13,
 2514, 32, 31, 23,
 2514, 35, 35,  8,
 2514, 37, 28, 19,
 2514, 37, 32, 11,
 2514, 40, 25, 17,
 2516, 34, 28, 24,
 2516, 36, 32, 14,
 2516, 36, 34,  8,
 2516, 40, 30,  4,
 2517, 34, 31, 20,
 2517, 38, 28, 17,
 2517, 38, 32,  7,
 2518, 33, 30, 23,
 2518, 39, 31,  6,
 2520, 36, 30, 18,
 2520, 38, 26, 20,
 2521, 36, 28, 21,
 2521, 36, 35,  0,
 2521, 37, 24, 24,
 2521, 39, 26, 18,
 2521, 39, 30, 10,
 2522, 36, 35,  1,
 2522, 37, 33,  8,
 2522, 40, 29,  9,
 2523, 29, 29, 29,
 2523, 37, 25, 23,
 2525, 30, 29, 28,
 2525, 35, 30, 20,
 2525, 35, 34, 12,
 2525, 36, 35,  2,
 2525, 37, 30, 16,
 2525, 37, 34,  0,
 2525, 40, 22, 21,
 2525, 40, 27, 14,
 2525, 40, 30,  5,
 2526, 34, 29, 23,
 2526, 35, 26, 25,
 2526, 37, 31, 14,
 2526, 37, 34,  1,
 2526, 38, 31, 11,
 2528, 40, 28, 12,
 2529, 30, 30, 27,
 2529, 31, 28, 28,
 2529, 36, 33, 12,
 2529, 37, 26, 22,
 2529, 37, 34,  2,
 2529, 40, 23, 20,
 2530, 35, 27, 24,
 2530, 36, 35,  3,
 2530, 39, 28, 15,
 2531, 31, 29, 27,
 2531, 35, 35,  9,
 2531, 39, 29, 13,
 2531, 39, 31,  7,
 2532, 32, 32, 22,
 2532, 38, 32,  8,
 2532, 40, 26, 16,
 2533, 36, 34,  9,
 2533, 38, 33,  0,
 2534, 33, 31, 22,
 2534, 34, 33, 17,
 2534, 37, 29, 18,
 2534, 37, 34,  3,
 2534, 38, 27, 19,
 2534, 38, 33,  1,
 2534, 39, 23, 22,
 2536, 40, 30,  6,
 2537, 31, 30, 26,
 2537, 32, 28, 27,
 2537, 34, 34, 15,
 2537, 36, 29, 20,
 2537, 36, 35,  4,
 2537, 37, 32, 12,
 2537, 38, 33,  2,
 2537, 40, 24, 19,
 2538, 35, 28, 23,
 2538, 35, 32, 17,
 2538, 39, 24, 21,
 2539, 33, 33, 19,
 2539, 35, 33, 15,
 2539, 37, 27, 21,
 2539, 37, 33,  9,
 2539, 39, 27, 17,
 2540, 34, 30, 22,
 2540, 38, 30, 14,
 2541, 32, 29, 26,
 2541, 34, 32, 19,
 2541, 37, 34,  4,
 2541, 38, 29, 16,
 2541, 40, 29, 10,
 2542, 38, 33,  3,
 2542, 39, 30, 11,
 2545, 36, 32, 15,
 2545, 39, 32,  0,
 2546, 36, 25, 25,
 2546, 36, 31, 17,
 2546, 36, 35,  5,
 2546, 39, 25, 20,
 2546, 39, 31,  8,
 2546, 39, 32,  1,
 2547, 31, 31, 25,
 2547, 33, 27, 27,
 2547, 35, 31, 19,
 2548, 36, 26, 24,
 2549, 32, 30, 25,
 2549, 33, 28, 26,
 2549, 38, 24, 23,
 2549, 38, 31, 12,
 2549, 38, 32,  9,
 2549, 38, 33,  4,
 2549, 39, 32,  2,
 2549, 40, 25, 18,
 2549, 40, 30,  7,
 2550, 35, 29, 22,
 2550, 35, 34, 13,
 2550, 35, 35, 10,
 2550, 37, 34,  5,
 2552, 36, 34, 10,
 2552, 38, 28, 18,
 2553, 37, 28, 20,
 2553, 38, 25, 22,
 2553, 40, 28, 13,
 2554, 33, 32, 21,
 2554, 36, 27, 23,
 2554, 36, 33, 13,
 2554, 39, 32,  3,
 2554, 40, 27, 15,
 2555, 33, 29, 25,
 2555, 37, 31, 15,
 2557, 36, 30, 19,
 2557, 36, 35,  6,
 2558, 34, 31, 21,
 2558, 37, 30, 17,
 2558, 37, 33, 10,
 2558, 38, 33,  5,
 2558, 39, 26, 19,
 2558, 39, 29, 14,
 2561, 32, 31, 24,
 2561, 34, 27, 26,
 2561, 37, 34,  6,
 2561, 38, 26, 21,
 2561, 39, 28, 16,
 2561, 39, 32,  4,
 2561, 40, 31,  0,
 2562, 37, 32, 13,
 2562, 40, 29, 11,
 2562, 40, 31,  1,
 2563, 39, 31,  9,
 2564, 36, 28, 22,
 2564, 40, 30,  8,
 2565, 33, 30, 24,
 2565, 34, 28, 25,
 2565, 39, 30, 12,
 2565, 40, 26, 17,
 2565, 40, 31,  2,
 2566, 35, 30, 21,
 2568, 34, 34, 16,
 2568, 38, 32, 10,
 2568, 40, 22, 22,
 2569, 34, 33, 18,
 2569, 38, 30, 15,
 2569, 38, 33,  6,
 2570, 35, 33, 16,
 2570, 36, 35,  7,
 2570, 37, 25, 24,
 2570, 39, 32,  5,
 2570, 40, 23, 21,
 2570, 40, 31,  3,
 2571, 35, 35, 11,
 2571, 37, 29, 19,
 2573, 34, 29, 24,
 2573, 35, 32, 18,
 2573, 36, 34, 11,
 2573, 38, 27, 20,
 2574, 37, 26, 23,
 2574, 37, 34,  7,
 2574, 38, 29, 17,
 2574, 38, 31, 13,
 2574, 39, 27, 18,
 2576, 36, 32, 16,
 2576, 40, 24, 20,
 2577, 32, 32, 23,
 2577, 35, 26, 26,
 2577, 35, 34, 14,
 2577, 40, 31,  4,
 2578, 33, 33, 20,
 2578, 36, 29, 21,
 2579, 33, 31, 23,
 2579, 35, 27, 25,
 2579, 37, 33, 11,
 2579, 39, 23, 23,
 2580, 34, 32, 20,
 2580, 40, 28, 14,
 2581, 36, 31, 18,
 2581, 36, 33, 14,
 2581, 39, 24, 22,
 2581, 39, 32,  6,
 2581, 40, 30,  9,
 2582, 30, 29, 29,
 2582, 37, 27, 22,
 2582, 38, 33,  7,
 2582, 39, 31, 10,
 2584, 30, 30, 28,
 2585, 34, 30, 23,
 2585, 35, 28, 24,
 2585, 36, 35,  8,
 2585, 40, 27, 16,
 2585, 40, 29, 12,
 2586, 31, 29, 28,
 2586, 35, 31, 20,
 2586, 37, 31, 16,
 2586, 40, 25, 19,
 2586, 40, 31,  5,
 2587, 39, 25, 21,
 2587, 39, 29, 15,
 2589, 37, 32, 14,
 2589, 37, 34,  8,
 2589, 38, 28, 19,
 2589, 38, 32, 11,
 2590, 31, 30, 27,
 2590, 39, 30, 13,
 2592, 32, 28, 28,
 2592, 36, 36,  0,
 2593, 36, 36,  1,
 2593, 37, 30, 18,
 2594, 32, 29, 27,
 2594, 35, 35, 12,
 2594, 37, 28, 21,
 2594, 37, 35,  0,
 2594, 39, 28, 17,
 2594, 39, 32,  7,
 2595, 35, 29, 23,
 2595, 37, 35,  1,
 2596, 36, 30, 20,
 2596, 36, 34, 12,
 2596, 36, 36,  2,
 2596, 38, 24, 24,
 2597, 33, 32, 22,
 2597, 36, 26, 25,
 2597, 38, 33,  8,
 2597, 39, 26, 20,
 2597, 40, 31,  6,
 2598, 31, 31, 26,
 2598, 37, 35,  2,
 2598, 38, 25, 23,
 2600, 32, 30, 26,
 2600, 38, 30, 16,
 2600, 38, 34,  0,
 2600, 40, 26, 18,
 2600, 40, 30, 10,
 2601, 34, 31, 22,
 2601, 34, 34, 17,
 2601, 36, 27, 24,
 2601, 36, 36,  3,
 2601, 38, 31, 14,
 2601, 38, 34,  1,
 2602, 33, 28, 27,
 2602, 36, 35,  9,
 2602, 37, 33, 12,
 2603, 35, 33, 17,
 2603, 37, 35,  3,
 2603, 39, 31, 11,
 2604, 38, 26, 22,
 2604, 38, 34,  2,
 2606, 33, 29, 26,
 2606, 34, 33, 19,
 2606, 35, 34, 15,
 2606, 37, 34,  9,
 2608, 36, 36,  4,
 2609, 35, 30, 22,
 2609, 36, 28, 23,
 2609, 36, 32, 17,
 2609, 38, 29, 18,
 2609, 38, 34,  3,
 2609, 39, 32,  8,
 2609, 40, 28, 15,
 2610, 32, 31, 25,
 2610, 35, 32, 19,
 2610, 36, 33, 15,
 2610, 37, 29, 20,
 2610, 37, 35,  4,
 2610, 39, 33,  0,
 2610, 40, 29, 13,
 2610, 40, 31,  7,
 2611, 39, 27, 19,
 2611, 39, 33,  1,
 2612, 38, 32, 12,
 2613, 40, 23, 22,
 2614, 33, 30, 25,
 2614, 34, 27, 27,
 2614, 38, 27, 21,
 2614, 38, 33,  9,
 2614, 39, 33,  2,
 2616, 34, 28, 26,
 2616, 38, 34,  4,
 2617, 36, 36,  5,
 2617, 39, 30, 14,
 2617, 40, 24, 21,
 2618, 36, 31, 19,
 2618, 37, 32, 15,
 2618, 39, 29, 16,
 2618, 40, 27, 17,
 2619, 33, 33, 21,
 2619, 35, 35, 13,
 2619, 37, 25, 25,
 2619, 37, 31, 17,
 2619, 37, 35,  5,
 2619, 39, 33,  3,
 2621, 34, 32, 21,
 2621, 36, 29, 22,
 2621, 36, 34, 13,
 2621, 36, 35, 10,
 2621, 37, 26, 24,
 2621, 40, 30, 11,
 2622, 34, 29, 25,
 2624, 32, 32, 24,
 2624, 40, 32,  0,
 2625, 37, 34, 10,
 2625, 38, 34,  5,
 2625, 40, 25, 20,
 2625, 40, 31,  8,
 2625, 40, 32,  1,
 2626, 33, 31, 24,
 2626, 39, 24, 23,
 2626, 39, 31, 12,
 2626, 39, 32,  9,
 2626, 39, 33,  4,
 2627, 35, 31, 21,
 2627, 37, 27, 23,
 2627, 37, 33, 13,
 2628, 36, 36,  6,
 2628, 38, 28, 20,
 2628, 40, 32,  2,
 2629, 39, 28, 18,
 2630, 35, 27, 26,
 2630, 37, 30, 19,
 2630, 37, 35,  6,
 2630, 38, 31, 15,
 2630, 39, 25, 22,
 2632, 34, 30, 24,
 2633, 38, 30, 17,
 2633, 38, 33, 10,
 2633, 40, 32,  3,
 2634, 35, 28, 25,
 2635, 39, 33,  5,
 2636, 34, 34, 18,
 2636, 38, 34,  6,
 2637, 35, 34, 16,
 2637, 36, 30, 21,
 2637, 37, 28, 22,
 2637, 38, 32, 13,
 2637, 40, 26, 19,
 2637, 40, 29, 14,
 2638, 35, 33, 18,
 2638, 39, 26, 21,
 2640, 40, 28, 16,
 2640, 40, 32,  4,
 2641, 30, 30, 29,
 2641, 36, 33, 16,
 2641, 36, 36,  7,
 2642, 33, 32, 23,
 2642, 35, 29, 24,
 2642, 36, 35, 11,
 2642, 40, 31,  9,
 2643, 31, 29, 29,
 2643, 37, 35,  7,
 2644, 36, 32, 18,
 2644, 40, 30, 12,
 2645, 31, 30, 28,
 2645, 34, 33, 20,
 2645, 38, 25, 24,
 2645, 39, 32, 10,
 2646, 34, 31, 23,
 2646, 35, 35, 14,
 2646, 37, 34, 11,
 2646, 38, 29, 19,
 2646, 39, 30, 15,
 2646, 39, 33,  6,
 2648, 36, 26, 26,
 2648, 36, 34, 14,
 2649, 32, 29, 28,
 2649, 35, 32, 20,
 2649, 37, 32, 16,
 2649, 38, 26, 23,
 2649, 38, 34,  7,
 2649, 40, 32,  5,
 2650, 36, 27, 25,
 2650, 39, 27, 20,
 2651, 31, 31, 27,
 2651, 37, 29, 21,
 2651, 39, 29, 17,
 2651, 39, 31, 13,
 2653, 32, 30, 27,
 2653, 40, 27, 18,
 2654, 35, 30, 23,
 2654, 37, 31, 18,
 2654, 37, 33, 14,
 2654, 38, 33, 11,
 2656, 36, 28, 24,
 2656, 36, 36,  8,
 2657, 33, 28, 28,
 2657, 36, 31, 20,
 2657, 38, 27, 22,
 2658, 37, 35,  8,
 2658, 40, 23, 23,
 2659, 33, 29, 27,
 2659, 39, 33,  7,
 2660, 40, 24, 22,
 2660, 40, 32,  6,
 2661, 32, 31, 26,
 2661, 38, 31, 16,
 2661, 40, 31, 10,
 2662, 33, 33, 22,
 2664, 34, 32, 22,
 2664, 38, 32, 14,
 2664, 38, 34,  8,
 2665, 33, 30, 26,
 2665, 36, 35, 12,
 2665, 37, 36,  0,
 2666, 36, 29, 23,
 2666, 37, 36,  1,
 2666, 39, 28, 19,
 2666, 39, 32, 11,
 2666, 40, 25, 21,
 2666, 40, 29, 15,
 2668, 38, 30, 18,
 2669, 34, 28, 27,
 2669, 37, 30, 20,
 2669, 37, 34, 12,
 2669, 37, 36,  2,
 2669, 38, 28, 21,
 2669, 38, 35,  0,
 2669, 40, 30, 13,
 2670, 35, 31, 22,
 2670, 35, 34, 17,
 2670, 37, 26, 25,
 2670, 38, 35,  1,
 2673, 32, 32, 25,
 2673, 34, 29, 26,
 2673, 34, 34, 19,
 2673, 36, 36,  9,
 2673, 38, 35,  2,
 2673, 39, 24, 24,
 2673, 40, 28, 17,
 2673, 40, 32,  7,
 2674, 36, 33, 17,
 2674, 37, 27, 24,
 2674, 37, 36,  3,
 2674, 39, 33,  8,
 2675, 33, 31, 25,
 2675, 35, 33, 19,
 2675, 35, 35, 15,
 2675, 37, 35,  9,
 2675, 39, 25, 23,
 2676, 40, 26, 20,
 2677, 36, 34, 15,
 2677, 38, 33, 12,
 2677, 39, 30, 16,
 2677, 39, 34,  0,
 2678, 38, 35,  3,
 2678, 39, 31, 14,
 2678, 39, 34,  1,
 2680, 36, 30, 22,
 2681, 34, 30, 25,
 2681, 36, 32, 19,
 2681, 37, 36,  4,
 2681, 38, 34,  9,
 2681, 39, 26, 22,
 2681, 39, 34,  2,
 2682, 37, 28, 23,
 2682, 37, 32, 17,
 2682, 40, 31, 11,
 2683, 35, 27, 27,
 2683, 37, 33, 15,
 2685, 35, 28, 26,
 2685, 38, 29, 20,
 2685, 38, 35,  4,
 2686, 34, 33, 21,
 2686, 39, 29, 18,
 2686, 39, 34,  3,
 2688, 40, 32,  8,
 2689, 33, 32, 24,
 2689, 39, 32, 12,
 2689, 40, 33,  0,
 2690, 35, 32, 21,
 2690, 36, 35, 13,
 2690, 37, 36,  5,
 2690, 40, 27, 19,
 2690, 40, 33,  1,
 2691, 35, 29, 25,
 2691, 37, 31, 19,
 2691, 39, 27, 21,
 2691, 39, 33,  9,
 2692, 36, 36, 10,
 2693, 34, 31, 24,
 2693, 38, 32, 15,
 2693, 39, 34,  4,
 2693, 40, 33,  2,
 2694, 37, 29, 22,
 2694, 37, 34, 13,
 2694, 37, 35, 10,
 2694, 38, 25, 25,
 2694, 38, 31, 17,
 2694, 38, 35,  5,
 2696, 38, 26, 24,
 2696, 40, 30, 14,
 2697, 40, 29, 16,
 2698, 36, 31, 21,
 2698, 40, 33,  3,
 2700, 30, 30, 30,
 2700, 38, 34, 10,
 2701, 35, 30, 24,
 2701, 36, 27, 26,
 2701, 37, 36,  6,
 2702, 31, 30, 29,
 2702, 38, 27, 23,
 2702, 38, 33, 13,
 2702, 39, 34,  5,
 2705, 35, 34, 18,
 2705, 36, 28, 25,
 2705, 38, 30, 19,
 2705, 38, 35,  6,
 2705, 39, 28, 20,
 2705, 40, 24, 23,
 2705, 40, 31, 12,
 2705, 40, 32,  9,
 2705, 40, 33,  4,
 2706, 31, 31, 28,
 2706, 32, 29, 29,
 2706, 35, 35, 16,
 2707, 33, 33, 23,
 2707, 39, 31, 15,
 2708, 32, 30, 28,
 2708, 36, 34, 16,
 2708, 40, 28, 18,
 2709, 34, 32, 23,
 2709, 36, 33, 18,
 2709, 40, 25, 22,
 2710, 37, 30, 21,
 2710, 39, 30, 17,
 2710, 39, 33, 10,
 2712, 34, 34, 20,
 2712, 38, 28, 22,
 2713, 36, 29, 24,
 2713, 36, 36, 11,
 2713, 39, 34,  6,
 2714, 32, 31, 27,
 2714, 33, 29, 28,
 2714, 35, 33, 20,
 2714, 37, 33, 16,
 2714, 37, 36,  7,
 2714, 39, 32, 13,
 2714, 40, 33,  5,
 2715, 35, 31, 23,
 2715, 37, 35, 11,
 2717, 36, 35, 14,
 2717, 37, 32, 18,
 2717, 40, 26, 21,
 2718, 33, 30, 27,
 2718, 38, 35,  7,
 2720, 36, 32, 20,
 2721, 37, 26, 26,
 2721, 37, 34, 14,
 2721, 38, 34, 11,
 2722, 39, 25, 24,
 2723, 37, 27, 25,
 2723, 39, 29, 19,
 2724, 32, 32, 26,
 2724, 34, 28, 28,
 2724, 38, 32, 16,
 2724, 40, 32, 10,
 2725, 36, 30, 23,
 2725, 40, 30, 15,
 2725, 40, 33,  6,
 2726, 33, 31, 26,
 2726, 34, 29, 27,
 2726, 38, 29, 21,
 2726, 39, 26, 23,
 2726, 39, 34,  7,
 2729, 34, 33, 22,
 2729, 37, 28, 24,
 2729, 37, 36,  8,
 2729, 38, 31, 18,
 2729, 38, 33, 14,
 2729, 40, 27, 20,
 2730, 37, 31, 20,
 2730, 40, 29, 17,
 2730, 40, 31, 13,
 2731, 39, 33, 11,
 2732, 34, 30, 26,
 2733, 35, 32, 22,
 2733, 38, 35,  8,
 2734, 39, 27, 22,
 2736, 36, 36, 12,
 2738, 33, 32, 25,
 2738, 35, 28, 27,
 2738, 37, 35, 12,
 2738, 37, 37,  0,
 2738, 39, 31, 16,
 2738, 40, 33,  7,
 2739, 35, 35, 17,
 2739, 37, 29, 23,
 2739, 37, 37,  1,
 2740, 38, 36,  0,
 2741, 36, 31, 22,
 2741, 36, 34, 17,
 2741, 38, 36,  1,
 2741, 39, 32, 14,
 2741, 39, 34,  8,
 2742, 34, 31, 25,
 2742, 35, 29, 26,
 2742, 35, 34, 19,
 2742, 37, 37,  2,
 2744, 38, 30, 20,
 2744, 38, 34, 12,
 2744, 38, 36,  2,
 2745, 38, 26, 25,
 2745, 39, 30, 18,
 2745, 40, 28, 19,
 2745, 40, 32, 11,
 2746, 36, 33, 19,
 2746, 36, 35, 15,
 2746, 37, 36,  9,
 2746, 39, 28, 21,
 2746, 39, 35,  0,
 2747, 37, 33, 17,
 2747, 37, 37,  3,
 2747, 39, 35,  1,
 2749, 38, 27, 24,
 2749, 38, 36,  3,
 2750, 35, 30, 25,
 2750, 37, 34, 15,
 2750, 38, 35,  9,
 2750, 39, 35,  2,
 2752, 40, 24, 24,
 2753, 34, 34, 21,
 2753, 37, 30, 22,
 2753, 40, 33,  8,
 2754, 33, 33, 24,
 2754, 36, 27, 27,
 2754, 37, 32, 19,
 2754, 37, 37,  4,
 2754, 39, 33, 12,
 2754, 40, 25, 23,
 2755, 35, 33, 21,
 2755, 39, 35,  3,
 2756, 34, 32, 24,
 2756, 36, 28, 26,
 2756, 38, 36,  4,
 2756, 40, 30, 16,
 2756, 40, 34,  0,
 2757, 38, 28, 23,
 2757, 38, 32, 17,
 2757, 40, 31, 14,
 2757, 40, 34,  1,
 2758, 38, 33, 15,
 2758, 39, 34,  9,
 2760, 40, 26, 22,
 2760, 40, 34,  2,
 2761, 31, 30, 30,
 2761, 36, 32, 21,
 2761, 36, 36, 13,
 2762, 35, 31, 24,
 2762, 36, 29, 25,
 2762, 39, 29, 20,
 2762, 39, 35,  4,
 2763, 31, 31, 29,
 2763, 37, 35, 13,
 2763, 37, 37,  5,
 2765, 32, 30, 29,
 2765, 37, 36, 10,
 2765, 38, 36,  5,
 2765, 40, 29, 18,
 2765, 40, 34,  3,
 2766, 38, 31, 19,
 2768, 40, 32, 12,
 2769, 32, 31, 28,
 2769, 38, 29, 22,
 2769, 38, 34, 13,
 2769, 38, 35, 10,
 2770, 39, 32, 15,
 2770, 40, 27, 21,
 2770, 40, 33,  9,
 2771, 33, 29, 29,
 2771, 37, 31, 21,
 2771, 39, 25, 25,
 2771, 39, 31, 17,
 2771, 39, 35,  5,
 2772, 36, 30, 24,
 2772, 40, 34,  4,
 2773, 33, 30, 28,
 2773, 39, 26, 24,
 2774, 34, 33, 23,
 2774, 35, 35, 18,
 2774, 37, 27, 26,
 2774, 37, 37,  6,
 2776, 36, 34, 18,
 2776, 38, 36,  6,
 2777, 32, 32, 27,
 2777, 36, 35, 16,
 2777, 39, 34, 10,
 2778, 35, 32, 23,
 2778, 37, 28, 25,
 2779, 33, 31, 27,
 2779, 39, 27, 23,
 2779, 39, 33, 13,
 2781, 34, 29, 28,
 2781, 35, 34, 20,
 2781, 37, 34, 16,
 2781, 40, 34,  5,
 2782, 37, 33, 18,
 2782, 39, 30, 19,
 2782, 39, 35,  6,
 2784, 40, 28, 20,
 2785, 34, 30, 27,
 2785, 36, 33, 20,
 2785, 38, 30, 21,
 2786, 36, 31, 23,
 2786, 37, 29, 24,
 2786, 37, 36, 11,
 2786, 40, 31, 15,
 2787, 37, 37,  7,
 2788, 36, 36, 14,
 2789, 33, 32, 26,
 2789, 38, 33, 16,
 2789, 38, 36,  7,
 2789, 39, 28, 22,
 2789, 40, 30, 17,
 2789, 40, 33, 10,
 2790, 37, 35, 14,
 2790, 38, 35, 11,
 2792, 38, 32, 18,
 2792, 40, 34,  6,
 2793, 34, 31, 26,
 2793, 35, 28, 28,
 2793, 37, 32, 20,
 2793, 40, 32, 13,
 2795, 35, 29, 27,
 2795, 39, 35,  7,
 2796, 34, 34, 22,
 2796, 38, 26, 26,
 2796, 38, 34, 14,
 2798, 35, 33, 22,
 2798, 37, 30, 23,
 2798, 38, 27, 25,
 2798, 39, 34, 11,
 2801, 35, 30, 26,
 2801, 39, 32, 16,
 2801, 40, 25, 24,
 2802, 37, 37,  8,
 2802, 40, 29, 19,
 2803, 33, 33, 25,
 2803, 39, 29, 21,
 2804, 36, 32, 22,
 2804, 38, 28, 24,
 2804, 38, 36,  8,
 2805, 34, 32, 25,
 2805, 38, 31, 20,
 2805, 40, 26, 23,
 2805, 40, 34,  7,
 2806, 39, 31, 18,
 2806, 39, 33, 14,
 2809, 36, 28, 27,
 2809, 37, 36, 12,
 2810, 36, 35, 17,
 2810, 39, 35,  8,
 2810, 40, 33, 11,
 2811, 35, 31, 25,
 2811, 35, 35, 19,
 2813, 36, 29, 26,
 2813, 36, 34, 19,
 2813, 38, 35, 12,
 2813, 38, 37,  0,
 2813, 40, 27, 22,
 2814, 37, 31, 22,
 2814, 37, 34, 17,
 2814, 38, 29, 23,
 2814, 38, 37,  1,
 2817, 36, 36, 15,
 2817, 38, 37,  2,
 2817, 39, 36,  0,
 2817, 40, 31, 16,
 2818, 39, 36,  1,
 2819, 37, 33, 19,
 2819, 37, 35, 15,
 2819, 37, 37,  9,
 2820, 40, 32, 14,
 2820, 40, 34,  8,
 2821, 34, 33, 24,
 2821, 36, 30, 25,
 2821, 38, 36,  9,
 2821, 39, 30, 20,
 2821, 39, 34, 12,
 2821, 39, 36,  2,
 2822, 31, 31, 30,
 2822, 35, 34, 21,
 2822, 38, 33, 17,
 2822, 38, 37,  3,
 2822, 39, 26, 25,
 2824, 32, 30, 30,
 2824, 40, 30, 18,
 2825, 35, 32, 24,
 2825, 38, 34, 15,
 2825, 40, 28, 21,
 2825, 40, 35,  0,
 2826, 32, 31, 29,
 2826, 36, 33, 21,
 2826, 39, 27, 24,
 2826, 39, 36,  3,
 2826, 40, 35,  1,
 2827, 37, 27, 27,
 2827, 39, 35,  9,
 2828, 38, 30, 22,
 2829, 37, 28, 26,
 2829, 38, 32, 19,
 2829, 38, 37,  4,
 2829, 40, 35,  2,
 2830, 33, 30, 29,
 2832, 32, 32, 28,
 2833, 36, 31, 24,
 2833, 39, 36,  4,
 2833, 40, 33, 12,
 2834, 33, 31, 28,
 2834, 37, 32, 21,
 2834, 37, 36, 13,
 2834, 39, 28, 23,
 2834, 39, 32, 17,
 2834, 40, 35,  3,
 2835, 37, 29, 25,
 2835, 39, 33, 15,
 2837, 40, 34,  9,
 2838, 34, 29, 29,
 2838, 37, 37, 10,
 2838, 38, 35, 13,
 2838, 38, 37,  5,
 2840, 34, 30, 28,
 2840, 38, 36, 10,
 2841, 34, 34, 23,
 2841, 40, 29, 20,
 2841, 40, 35,  4,
 2842, 33, 32, 27,
 2842, 39, 36,  5,
 2843, 35, 33, 23,
 2843, 39, 31, 19,
 2845, 36, 35, 18,
 2845, 37, 30, 24,
 2846, 34, 31, 27,
 2846, 38, 31, 21,
 2846, 39, 29, 22,
 2846, 39, 34, 13,
 2846, 39, 35, 10,
 2848, 36, 36, 16,
 2849, 36, 32, 23,
 2849, 37, 34, 18,
 2849, 38, 27, 26,
 2849, 38, 37,  6,
 2849, 40, 32, 15,
 2850, 35, 29, 28,
 2850, 35, 35, 20,
 2850, 37, 35, 16,
 2850, 40, 25, 25,
 2850, 40, 31, 17,
 2850, 40, 35,  5,
 2852, 36, 34, 20,
 2852, 40, 26, 24,
 2853, 38, 28, 25,
 2853, 39, 36,  6,
 2854, 33, 33, 26,
 2854, 35, 30, 27,
 2856, 34, 32, 26,
 2856, 38, 34, 16,
 2856, 40, 34, 10,
 2857, 38, 33, 18,
 2858, 37, 33, 20,
 2858, 40, 27, 23,
 2858, 40, 33, 13,
 2859, 37, 31, 23,
 2859, 37, 37, 11,
 2861, 37, 36, 14,
 2861, 38, 29, 24,
 2861, 38, 36, 11,
 2861, 40, 30, 19,
 2861, 40, 35,  6,
 2862, 35, 31, 26,
 2862, 38, 37,  7,
 2862, 39, 30, 21,
 2864, 36, 28, 28,
 2865, 35, 34, 22,
 2865, 38, 35, 14,
 2866, 36, 29, 27,
 2866, 39, 33, 16,
 2866, 39, 36,  7,
 2867, 39, 35, 11,
 2868, 38, 32, 20,
 2868, 40, 28, 22,
 2869, 36, 33, 22,
 2869, 39, 32, 18,
 2870, 34, 33, 25,
 2872, 36, 30, 26,
 2873, 38, 30, 23,
 2873, 39, 26, 26,
 2873, 39, 34, 14,
 2874, 35, 32, 25,
 2874, 40, 35,  7,
 2875, 39, 27, 25,
 2877, 37, 32, 22,
 2877, 38, 37,  8,
 2877, 40, 34, 11,
 2880, 40, 32, 16,
 2881, 36, 36, 17,
 2881, 39, 28, 24,
 2881, 39, 36,  8,
 2882, 36, 31, 25,
 2882, 36, 35, 19,
 2882, 37, 28, 27,
 2882, 37, 37, 12,
 2882, 39, 31, 20,
 2882, 40, 29, 21,
 2883, 31, 31, 31,
 2883, 37, 35, 17,
 2884, 38, 36, 12,
 2885, 32, 31, 30,
 2885, 40, 31, 18,
 2885, 40, 33, 14,
 2886, 37, 29, 26,
 2886, 37, 34, 19,
 2888, 34, 34, 24,
 2888, 38, 38,  0,
 2889, 32, 32, 29,
 2889, 33, 30, 30,
 2889, 38, 31, 22,
 2889, 38, 34, 17,
 2889, 38, 38,  1,
 2889, 40, 35,  8,
 2890, 35, 33, 24,
 2890, 37, 36, 15,
 2890, 39, 35, 12,
 2890, 39, 37,  0,
 2891, 33, 31, 29,
 2891, 35, 35, 21,
 2891, 39, 29, 23,
 2891, 39, 37,  1,
 2892, 38, 38,  2,
 2893, 36, 34, 21,
 2894, 37, 30, 25,
 2894, 38, 33, 19,
 2894, 38, 35, 15,
 2894, 38, 37,  9,
 2894, 39, 37,  2,
 2896, 36, 32, 24,
 2896, 40, 36,  0,
 2897, 33, 32, 28,
 2897, 34, 30, 29,
 2897, 38, 38,  3,
 2897, 40, 36,  1,
 2898, 39, 36,  9,
 2899, 37, 33, 21,
 2899, 39, 33, 17,
 2899, 39, 37,  3,
 2900, 40, 30, 20,
 2900, 40, 34, 12,
 2900, 40, 36,  2,
 2901, 34, 31, 28,
 2901, 40, 26, 25,
 2902, 38, 27, 27,
 2902, 39, 34, 15,
 2904, 38, 28, 26,
 2904, 38, 38,  4,
 2905, 39, 30, 22,
 2905, 40, 27, 24,
 2905, 40, 36,  3,
 2906, 37, 31, 24,
 2906, 39, 32, 19,
 2906, 39, 37,  4,
 2906, 40, 35,  9,
 2907, 33, 33, 27,
 2907, 35, 29, 29,
 2907, 37, 37, 13,
 2909, 34, 32, 27,
 2909, 35, 30, 28,
 2909, 38, 32, 21,
 2909, 38, 36, 13,
 2910, 35, 34, 23,
 2910, 38, 29, 25,
 2912, 40, 36,  4,
 2913, 38, 37, 10,
 2913, 38, 38,  5,
 2913, 40, 28, 23,
 2913, 40, 32, 17,
 2914, 36, 33, 23,
 2914, 40, 33, 15,
 2915, 35, 31, 27,
 2915, 39, 35, 13,
 2915, 39, 37,  5,
 2916, 36, 36, 18,
 2917, 39, 36, 10,
 2918, 37, 35, 18,
 2920, 38, 30, 24,
 2921, 34, 33, 26,
 2921, 36, 29, 28,
 2921, 36, 35, 20,
 2921, 37, 36, 16,
 2921, 40, 36,  5,
 2922, 37, 32, 23,
 2922, 40, 31, 19,
 2923, 39, 31, 21,
 2924, 38, 34, 18,
 2924, 38, 38,  6,
 2925, 35, 32, 26,
 2925, 36, 30, 27,
 2925, 37, 34, 20,
 2925, 38, 35, 16,
 2925, 40, 29, 22,
 2925, 40, 34, 13,
 2925, 40, 35, 10,
 2926, 39, 27, 26,
 2926, 39, 37,  6,
 2930, 39, 28, 25,
 2932, 40, 36,  6,
 2933, 36, 31, 26,
 2933, 38, 33, 20,
 2933, 39, 34, 16,
 2934, 35, 35, 22,
 2934, 37, 37, 14,
 2934, 38, 31, 23,
 2934, 38, 37, 11,
 2934, 39, 33, 18,
 2936, 36, 34, 22,
 2936, 38, 36, 14,
 2937, 34, 34, 25,
 2937, 37, 28, 28,
 2937, 38, 38,  7,
 2938, 39, 29, 24,
 2938, 39, 36, 11,
 2939, 35, 33, 25,
 2939, 37, 29, 27,
 2939, 39, 37,  7,
 2941, 40, 30, 21,
 2942, 37, 33, 22,
 2942, 39, 35, 14,
 2945, 36, 32, 25,
 2945, 37, 30, 26,
 2945, 39, 32, 20,
 2945, 40, 33, 16,
 2945, 40, 36,  7,
 2946, 32, 31, 31,
 2946, 40, 35, 11,
 2948, 32, 32, 30,
 2948, 40, 32, 18,
 2950, 33, 31, 30,
 2950, 39, 30, 23,
 2952, 38, 32, 22,
 2952, 38, 38,  8,
 2952, 40, 26, 26,
 2952, 40, 34, 14,
 2953, 36, 36, 19,
 2954, 33, 32, 29,
 2954, 37, 36, 17,
 2954, 39, 37,  8,
 2954, 40, 27, 25,
 2955, 37, 31, 25,
 2955, 37, 35, 19,
 2956, 34, 30, 30,
 2957, 35, 34, 24,
 2957, 38, 28, 27,
 2957, 38, 37, 12,
 2958, 34, 31, 29,
 2958, 38, 35, 17,
 2960, 40, 28, 24,
 2960, 40, 36,  8,
 2961, 36, 33, 24,
 2961, 38, 29, 26,
 2961, 38, 34, 19,
 2961, 39, 36, 12,
 2961, 40, 31, 20,
 2962, 33, 33, 28,
 2962, 36, 35, 21,
 2963, 37, 37, 15,
 2964, 34, 32, 28,
 2965, 38, 36, 15,
 2965, 39, 38,  0,
 2966, 35, 30, 29,
 2966, 37, 34, 21,
 2966, 39, 31, 22,
 2966, 39, 34, 17,
 2966, 39, 38,  1,
 2969, 37, 32, 24,
 2969, 38, 30, 25,
 2969, 38, 38,  9,
 2969, 39, 38,  2,
 2969, 40, 35, 12,
 2969, 40, 37,  0,
 2970, 35, 31, 28,
 2970, 40, 29, 23,
 2970, 40, 37,  1,
 2971, 39, 33, 19,
 2971, 39, 35, 15,
 2971, 39, 37,  9,
 2973, 40, 37,  2,
 2974, 34, 33, 27,
 2974, 38, 33, 21,
 2974, 39, 38,  3,
 2977, 40, 36,  9,
 2978, 35, 32, 27,
 2978, 36, 29, 29,
 2978, 40, 33, 17,
 2978, 40, 37,  3,
 2979, 35, 35, 23,
 2979, 39, 27, 27,
 2980, 36, 30, 28,
 2981, 36, 34, 23,
 2981, 38, 31, 24,
 2981, 39, 28, 26,
 2981, 39, 38,  4,
 2981, 40, 34, 15,
 2982, 38, 37, 13,
 2984, 40, 30, 22,
 2985, 40, 32, 19,
 2985, 40, 37,  4,
 2986, 36, 31, 27,
 2986, 39, 32, 21,
 2986, 39, 36, 13,
 2987, 37, 33, 23,
 2987, 39, 29, 25,
 2988, 34, 34, 26,
 2988, 38, 38, 10,
 2989, 37, 36, 18,
 2990, 35, 33, 26,
 2990, 39, 37, 10,
 2990, 39, 38,  5,
 2992, 36, 36, 20,
 2993, 38, 35, 18,
 2994, 37, 29, 28,
 2994, 37, 35, 20,
 2994, 37, 37, 16,
 2994, 40, 35, 13,
 2994, 40, 37,  5,
 2996, 36, 32, 26,
 2996, 38, 36, 16,
 2996, 40, 36, 10,
 2997, 38, 32, 23,
 2997, 39, 30, 24,
 2998, 37, 30, 27,
 3000, 38, 34, 20,
 3001, 39, 34, 18,
 3001, 39, 38,  6,
 3002, 39, 35, 16,
 3002, 40, 31, 21,
 3005, 36, 35, 22,
 3005, 40, 27, 26,
 3005, 40, 37,  6,
 3006, 35, 34, 25,
 3006, 37, 31, 26,
 3009, 32, 32, 31,
 3009, 37, 34, 22,
 3009, 38, 37, 14,
 3009, 38, 38, 11,
 3009, 40, 28, 25,
 3010, 36, 33, 25,
 3010, 39, 33, 20,
 3011, 33, 31, 31,
 3011, 39, 31, 23,
 3011, 39, 37, 11,
 3012, 38, 28, 28,
 3012, 40, 34, 16,
 3013, 33, 32, 30,
 3013, 39, 36, 14,
 3013, 40, 33, 18,
 3014, 38, 29, 27,
 3014, 39, 38,  7,
 3017, 34, 31, 30,
 3017, 38, 33, 22,
 3017, 40, 29, 24,
 3017, 40, 36, 11,
 3018, 37, 32, 25,
 3018, 40, 37,  7,
 3019, 33, 33, 29,
 3020, 38, 30, 26,
 3021, 34, 32, 29,
 3021, 40, 35, 14,
 3024, 40, 32, 20,
 3025, 35, 30, 30,
 3026, 35, 35, 24,
 3026, 37, 36, 19,
 3027, 35, 31, 29,
 3027, 37, 37, 17,
 3028, 36, 34, 24,
 3029, 34, 33, 28,
 3029, 38, 36, 17,
 3029, 39, 32, 22,
 3029, 39, 38,  8,
 3029, 40, 30, 23,
 3030, 38, 31, 25,
 3030, 38, 35, 19,
 3032, 38, 38, 12,
 3033, 35, 32, 28,
 3033, 36, 36, 21,
 3033, 40, 37,  8,
 3034, 37, 33, 24,
 3034, 39, 28, 27,
 3034, 39, 37, 12,
 3035, 37, 35, 21,
 3035, 39, 35, 17,
 3037, 36, 30, 29,
 3038, 38, 37, 15,
 3038, 39, 29, 26,
 3038, 39, 34, 19,
 3040, 40, 36, 12,
 3041, 34, 34, 27,
 3041, 36, 31, 28,
 3041, 38, 34, 21,
 3042, 39, 36, 15,
 3042, 39, 39,  0,
 3043, 35, 33, 27,
 3043, 39, 39,  1,
 3044, 38, 32, 24,
 3044, 40, 38,  0,
 3045, 40, 31, 22,
 3045, 40, 34, 17,
 3045, 40, 38,  1,
 3046, 39, 30, 25,
 3046, 39, 38,  9,
 3046, 39, 39,  2,
 3048, 40, 38,  2,
 3049, 36, 32, 27,
 3050, 36, 35, 23,
 3050, 40, 33, 19,
 3050, 40, 35, 15,
 3050, 40, 37,  9,
 3051, 37, 29, 29,
 3051, 39, 33, 21,
 3051, 39, 39,  3,
 3053, 37, 30, 28,
 3053, 40, 38,  3,
 3054, 37, 34, 23,
 3057, 35, 34, 26,
 3057, 38, 38, 13,
 3058, 39, 31, 24,
 3058, 39, 39,  4,
 3058, 40, 27, 27,
 3059, 37, 31, 27,
 3059, 39, 37, 13,
 3060, 40, 28, 26,
 3060, 40, 38,  4,
 3061, 36, 33, 26,
 3062, 37, 37, 18,
 3062, 38, 33, 23,
 3064, 38, 36, 18,
 3065, 37, 36, 20,
 3065, 39, 38, 10,
 3065, 40, 32, 21,
 3065, 40, 36, 13,
 3066, 40, 29, 25,
 3067, 39, 39,  5,
 3069, 37, 32, 26,
 3069, 38, 29, 28,
 3069, 38, 35, 20,
 3069, 38, 37, 16,
 3069, 40, 37, 10,
 3069, 40, 38,  5,
 3070, 39, 35, 18,
 3072, 32, 32, 32,
 3073, 38, 30, 27,
 3073, 39, 36, 16,
 3074, 33, 32, 31,
 3074, 39, 32, 23,
 3075, 35, 35, 25,
 3076, 36, 36, 22,
 3076, 40, 30, 24,
 3077, 36, 34, 25,
 3077, 39, 34, 20,
 3078, 33, 33, 30,
 3078, 34, 31, 31,
 3078, 37, 35, 22,
 3078, 39, 39,  6,
 3080, 34, 32, 30,
 3080, 40, 34, 18,
 3080, 40, 38,  6,
 3081, 38, 31, 26,
 3081, 40, 35, 16,
 3083, 37, 33, 25,
 3084, 38, 34, 22,
 3084, 38, 38, 14,
 3086, 34, 33, 29,
 3086, 35, 31, 30,
 3086, 39, 37, 14,
 3086, 39, 38, 11,
 3089, 39, 28, 28,
 3089, 40, 33, 20,
 3090, 35, 32, 29,
 3090, 40, 31, 23,
 3090, 40, 37, 11,
 3091, 39, 29, 27,
 3091, 39, 39,  7,
 3092, 40, 36, 14,
 3093, 38, 32, 25,
 3093, 40, 38,  7,
 3094, 39, 33, 22,
 3096, 34, 34, 28,
 3096, 36, 30, 30,
 3097, 36, 35, 24,
 3097, 39, 30, 26,
 3098, 35, 33, 28,
 3098, 36, 31, 29,
 3099, 37, 37, 19,
 3101, 37, 34, 24,
 3101, 38, 36, 19,
 3102, 38, 37, 17,
 3104, 36, 32, 28,
 3106, 37, 36, 21,
 3106, 39, 36, 17,
 3106, 39, 39,  8,
 3107, 39, 31, 25,
 3107, 39, 35, 19,
 3108, 40, 32, 22,
 3108, 40, 38,  8,
 3109, 38, 33, 24,
 3109, 39, 38, 12,
 3110, 35, 34, 27,
 3110, 37, 30, 29,
 3110, 38, 35, 21,
 3113, 38, 38, 15,
 3113, 40, 28, 27,
 3113, 40, 37, 12,
 3114, 36, 33, 27,
 3114, 37, 31, 28,
 3114, 40, 35, 17,
 3115, 39, 37, 15,
 3117, 40, 29, 26,
 3117, 40, 34, 19,
 3118, 39, 34, 21,
 3121, 36, 36, 23,
 3121, 39, 32, 24,
 3121, 40, 36, 15,
 3121, 40, 39,  0,
 3122, 37, 32, 27,
 3122, 40, 39,  1,
 3123, 37, 35, 23,
 3123, 39, 39,  9,
 3125, 40, 30, 25,
 3125, 40, 38,  9,
 3125, 40, 39,  2,
 3126, 35, 35, 26,
 3126, 38, 29, 29,
 3128, 36, 34, 26,
 3128, 38, 30, 28,
 3129, 38, 34, 23,
 3130, 40, 33, 21,
 3130, 40, 39,  3,
 3134, 37, 33, 26,
 3134, 38, 31, 27,
 3134, 39, 38, 13,
 3137, 33, 32, 32,
 3137, 38, 37, 18,
 3137, 40, 31, 24,
 3137, 40, 39,  4,
 3138, 37, 37, 20,
 3138, 40, 37, 13,
 3139, 33, 33, 31,
 3139, 39, 33, 23,
 3140, 38, 36, 20,
 3141, 34, 32, 31,
 3141, 39, 36, 18,
 3142, 39, 39, 10,
 3144, 38, 32, 26,
 3144, 38, 38, 16,
 3144, 40, 38, 10,
 3145, 34, 33, 30,
 3146, 36, 35, 25,
 3146, 39, 29, 28,
 3146, 39, 35, 20,
 3146, 39, 37, 16,
 3146, 40, 39,  5,
 3147, 35, 31, 31,
 3149, 35, 32, 30,
 3149, 37, 36, 22,
 3149, 40, 35, 18,
 3150, 37, 34, 25,
 3150, 39, 30, 27,
 3152, 40, 36, 16,
 3153, 34, 34, 29,
 3153, 38, 35, 22,
 3153, 40, 32, 23,
 3155, 35, 33, 29,
 3156, 40, 34, 20,
 3157, 36, 31, 30,
 3157, 40, 39,  6,
 3158, 38, 33, 25,
 3158, 39, 31, 26,
 3161, 36, 32, 29,
 3161, 39, 34, 22,
 3161, 39, 38, 14,
 3163, 39, 39, 11,
 3165, 35, 34, 28,
 3165, 40, 37, 14,
 3165, 40, 38, 11,
 3168, 36, 36, 24,
 3168, 40, 28, 28,
 3169, 36, 33, 28,
 3169, 37, 30, 30,
 3170, 37, 35, 24,
 3170, 39, 32, 25,
 3170, 40, 29, 27,
 3170, 40, 39,  7,
 3171, 37, 31, 29,
 3173, 40, 33, 22,
 3174, 38, 37, 19,
 3176, 38, 34, 24,
 3176, 40, 30, 26,
 3177, 37, 32, 28,
 3177, 38, 38, 17,
 3178, 39, 36, 19,
 3179, 35, 35, 27,
 3179, 37, 37, 21,
 3179, 39, 37, 17,
 3181, 36, 34, 27,
 3181, 38, 36, 21,
 3185, 38, 30, 29,
 3185, 40, 36, 17,
 3185, 40, 39,  8,
 3186, 39, 33, 24,
 3186, 39, 39, 12,
 3186, 40, 31, 25,
 3186, 40, 35, 19,
 3187, 37, 33, 27,
 3187, 39, 35, 21,
 3188, 40, 38, 12,
 3189, 38, 31, 28,
 3190, 39, 38, 15,
 3194, 37, 36, 23,
 3194, 40, 37, 15,
 3197, 36, 35, 26,
 3197, 38, 32, 27,
 3197, 40, 34, 21,
 3198, 38, 35, 23,
 3200, 40, 32, 24,
 3200, 40, 40,  0,
 3201, 37, 34, 26,
 3201, 40, 40,  1,
 3202, 33, 33, 32,
 3202, 40, 39,  9,
 3203, 39, 29, 29,
 3204, 34, 32, 32,
 3204, 40, 40,  2,
 3205, 39, 30, 28,
 3206, 34, 33, 31,
 3206, 39, 34, 23,
 3209, 38, 33, 26,
 3209, 40, 40,  3,
 3210, 35, 32, 31,
 3211, 39, 31, 27,
 3211, 39, 39, 13,
 3212, 34, 34, 30,
 3212, 38, 38, 18,
 3213, 38, 37, 20,
 3213, 40, 38, 13,
 3214, 35, 33, 30,
 3214, 39, 37, 18,
 3216, 40, 40,  4,
 3217, 36, 36, 25,
 3217, 39, 36, 20,
 3218, 36, 31, 31,
 3218, 40, 33, 23,
 3219, 37, 35, 25,
 3220, 36, 32, 30,
 3220, 40, 36, 18,
 3221, 39, 32, 26,
 3221, 39, 38, 16,
 3221, 40, 39, 10,
 3222, 35, 34, 29,
 3222, 37, 37, 22,
 3224, 38, 36, 22,
 3225, 38, 34, 25,
 3225, 40, 29, 28,
 3225, 40, 35, 20,
 3225, 40, 37, 16,
 3225, 40, 40,  5,
 3226, 36, 33, 29,
 3229, 40, 30, 27,
 3230, 37, 31, 30,
 3230, 39, 35, 22,
 3234, 35, 35, 28,
 3234, 37, 32, 29,
 3235, 39, 33, 25,
 3236, 36, 34, 28,
 3236, 40, 40,  6,
 3237, 40, 31, 26,
 3238, 39, 39, 14,
 3240, 40, 34, 22,
 3240, 40, 38, 14,
 3241, 37, 36, 24,
 3242, 37, 33, 28,
 3242, 40, 39, 11,
 3244, 38, 30, 30,
 3245, 38, 35, 24,
 3246, 38, 31, 29,
 3249, 38, 38, 19,
 3249, 40, 32, 25,
 3249, 40, 40,  7,
 3250, 36, 35, 27,
 3251, 39, 37, 19,
 3252, 38, 32, 28,
 3253, 39, 34, 24,
 3254, 37, 34, 27,
 3254, 38, 37, 21,
 3254, 39, 38, 17,
 3257, 40, 36, 19,
 3258, 39, 36, 21,
 3258, 40, 37, 17,
 3262, 38, 33, 27,
 3262, 39, 30, 29,
 3264, 40, 40,  8,
 3265, 40, 33, 24,
 3265, 40, 39, 12,
 3266, 39, 31, 28,
 3266, 40, 35, 21,
 3267, 33, 33, 33,
 3267, 37, 37, 23,
 3267, 39, 39, 15,
 3268, 36, 36, 26,
 3269, 34, 33, 32,
 3269, 38, 36, 23,
 3269, 40, 38, 15,
 3270, 37, 35, 26,
 3273, 34, 34, 31,
 3273, 35, 32, 32,
 3274, 39, 32, 27,
 3275, 35, 33, 31,
 3275, 39, 35, 23,
 3276, 38, 34, 26,
 3281, 35, 34, 30,
 3281, 36, 32, 31,
 3281, 40, 40,  9,
 3282, 40, 29, 29,
 3284, 40, 30, 28,
 3285, 36, 33, 30,
 3285, 40, 34, 23,
 3286, 39, 33, 26,
 3288, 38, 38, 20,
 3289, 39, 38, 18,
 3290, 37, 36, 25,
 3290, 39, 37, 20,
 3290, 40, 31, 27,
 3290, 40, 39, 13,
 3291, 35, 35, 29,
 3291, 37, 31, 31,
 3293, 36, 34, 29,
 3293, 37, 32, 30,
 3293, 40, 37, 18,
 3294, 38, 35, 25,
 3296, 40, 36, 20,
 3297, 38, 37, 22,
 3298, 39, 39, 16,
 3299, 37, 33, 29,
 3300, 40, 32, 26,
 3300, 40, 38, 16,
 3300, 40, 40, 10,
 3301, 39, 36, 22,
 3302, 39, 34, 25,
 3305, 36, 35, 28,
 3305, 38, 31, 30,
 3309, 37, 34, 28,
 3309, 38, 32, 29,
 3309, 40, 35, 22,
 3314, 37, 37, 24,
 3314, 40, 33, 25,
 3316, 38, 36, 24,
 3317, 38, 33, 28,
 3317, 40, 39, 14,
 3321, 36, 36, 27,
 3321, 39, 30, 30,
 3321, 40, 40, 11,
 3322, 39, 35, 24,
 3323, 37, 35, 27,
 3323, 39, 31, 29,
 3326, 39, 38, 19,
 3329, 38, 34, 27,
 3329, 38, 38, 21,
 3329, 39, 32, 28,
 3330, 40, 37, 19,
 3331, 39, 37, 21,
 3331, 39, 39, 17,
 3332, 40, 34, 24,
 3333, 40, 38, 17,
 3334, 34, 33, 33,
 3336, 34, 34, 32,
 3337, 40, 36, 21,
 3338, 35, 33, 32,
 3339, 39, 33, 27,
 3341, 37, 36, 26,
 3341, 40, 30, 29,
 3342, 35, 34, 31,
 3342, 38, 37, 23,
 3344, 36, 32, 32,
 3344, 40, 40, 12,
 3345, 38, 35, 26,
 3345, 40, 31, 28,
 3346, 36, 33, 31,
 3346, 39, 36, 23,
 3346, 40, 39, 15,
 3350, 35, 35, 30,
 3352, 36, 34, 30,
 3353, 39, 34, 26,
 3353, 40, 32, 27,
 3354, 37, 32, 31,
 3354, 40, 35, 23,
 3358, 37, 33, 30,
 3362, 36, 35, 29,
 3363, 37, 37, 25,
 3365, 38, 36, 25,
 3365, 39, 38, 20,
 3365, 40, 33, 26,
 3366, 37, 34, 29,
 3366, 38, 31, 31,
 3366, 39, 39, 18,
 3368, 38, 32, 30,
 3368, 40, 38, 18,
 3369, 40, 37, 20,
 3369, 40, 40, 13,
 3371, 39, 35, 25,
 3372, 38, 38, 22,
 3374, 38, 33, 29,
 3374, 39, 37, 22,
 3376, 36, 36, 28,
 3377, 40, 39, 16,
 3378, 37, 35, 28,
 3380, 40, 36, 22,
 3381, 40, 34, 25,
 3382, 39, 31, 30,
 3384, 38, 34, 28,
 3386, 39, 32, 29,
 3389, 38, 37, 24,
 3393, 39, 36, 24,
 3394, 37, 36, 27,
 3394, 39, 33, 28,
 3396, 40, 40, 14,
 3398, 38, 35, 27,
 3400, 40, 30, 30,
 3401, 34, 34, 33,
 3401, 40, 35, 24,
 3402, 40, 31, 29,
 3403, 35, 33, 33,
 3403, 39, 39, 19,
 3405, 35, 34, 32,
 3405, 40, 38, 19,
 3406, 39, 34, 27,
 3406, 39, 38, 21,
 3408, 40, 32, 28,
 3409, 36, 33, 32,
 3410, 40, 37, 21,
 3410, 40, 39, 17,
 3411, 35, 35, 31,
 3413, 36, 34, 31,
 3414, 37, 37, 26,
 3416, 38, 36, 26,
 3417, 37, 32, 32,
 3417, 38, 38, 23,
 3418, 40, 33, 27,
 3419, 37, 33, 31,
 3419, 39, 37, 23,
 3421, 36, 35, 30,
 3422, 39, 35, 26,
 3425, 37, 34, 30,
 3425, 40, 36, 23,
 3425, 40, 40, 15,
 3429, 38, 32, 31,
 3432, 40, 34, 26,
 3433, 36, 36, 29,
 3433, 38, 33, 30,
 3435, 37, 35, 29,
 3438, 38, 37, 25,
 3441, 38, 34, 29,
 3442, 39, 36, 25,
 3442, 39, 39, 20,
 3443, 39, 31, 31,
 3444, 40, 38, 20,
 3445, 39, 32, 30,
 3445, 40, 39, 18,
 3449, 37, 36, 28,
 3449, 39, 38, 22,
 3450, 40, 35, 25,
 3451, 39, 33, 29,
 3453, 38, 35, 28,
 3453, 40, 37, 22,
 3456, 40, 40, 16,
 3461, 39, 34, 28,
 3461, 40, 31, 30,
 3464, 38, 38, 24,
 3465, 40, 32, 29,
 3466, 39, 37, 24,
 3467, 37, 37, 27,
 3468, 34, 34, 34,
 3469, 38, 36, 27,
 3470, 35, 34, 33,
 3472, 40, 36, 24,
 3473, 40, 33, 28,
 3474, 35, 35, 32,
 3474, 36, 33, 33,
 3475, 39, 35, 27,
 3476, 36, 34, 32,
 3482, 36, 35, 31,
 3482, 37, 33, 32,
 3482, 40, 39, 19,
 3483, 39, 39, 21,
 3485, 40, 34, 27,
 3485, 40, 38, 21,
 3486, 37, 34, 31,
 3489, 38, 37, 26,
 3489, 40, 40, 17,
 3492, 36, 36, 30,
 3492, 38, 32, 32,
 3493, 39, 36, 26,
 3494, 37, 35, 30,
 3494, 38, 33, 31,
 3494, 39, 38, 23,
 3498, 40, 37, 23,
 3500, 38, 34, 30,
 3501, 40, 35, 26,
 3506, 37, 36, 29,
 3506, 39, 32, 31,
 3510, 38, 35, 29,
 3510, 39, 33, 30,
 3513, 38, 38, 25,
 3515, 39, 37, 25,
 3518, 39, 34, 29,
 3521, 40, 36, 25,
 3521, 40, 39, 20,
 3522, 37, 37, 28,
 3522, 40, 31, 31,
 3524, 38, 36, 28,
 3524, 40, 32, 30,
 3524, 40, 40, 18,
 3526, 39, 39, 22,
 3528, 40, 38, 22,
 3530, 39, 35, 28,
 3530, 40, 33, 29,
 3537, 35, 34, 34,
 3539, 35, 35, 33,
 3540, 40, 34, 28,
 3541, 36, 34, 33,
 3541, 39, 38, 24,
 3542, 38, 37, 27,
 3545, 36, 35, 32,
 3545, 40, 37, 24,
 3546, 39, 36, 27,
 3547, 37, 33, 33,
 3549, 37, 34, 32,
 3553, 36, 36, 31,
 3554, 40, 35, 27,
 3555, 37, 35, 31,
 3557, 38, 33, 32,
 3561, 38, 34, 31,
 3561, 40, 40, 19,
 3562, 40, 39, 21,
 3564, 38, 38, 26,
 3565, 37, 36, 30,
 3566, 39, 37, 26,
 3569, 38, 35, 30,
 3569, 39, 32, 32,
 3571, 39, 33, 31,
 3571, 39, 39, 23,
 3572, 40, 36, 26,
 3573, 40, 38, 23,
 3577, 39, 34, 30,
 3579, 37, 37, 29,
 3581, 38, 36, 29,
 3585, 40, 32, 31,
 3587, 39, 35, 29,
 3589, 40, 33, 30,
 3590, 39, 38, 25,
 3594, 40, 37, 25,
 3597, 38, 37, 28,
 3597, 40, 34, 29,
 3600, 40, 40, 20,
 3601, 39, 36, 28,
 3605, 40, 39, 22,
 3606, 35, 35, 34,
 3608, 36, 34, 34,
 3609, 40, 35, 28,
 3610, 36, 35, 33,
 3614, 37, 34, 33,
 3616, 36, 36, 32,
 3617, 38, 38, 27,
 3618, 37, 35, 32,
 3618, 39, 39, 24,
 3619, 39, 37, 27,
 3620, 40, 38, 24,
 3622, 38, 33, 33,
 3624, 38, 34, 32,
 3625, 40, 36, 27,
 3626, 37, 36, 31,
 3630, 38, 35, 31,
 3634, 39, 33, 32,
 3638, 37, 37, 30,
 3638, 39, 34, 31,
 3640, 38, 36, 30,
 3641, 39, 38, 26,
 3641, 40, 40, 21,
 3645, 40, 37, 26,
 3646, 39, 35, 30,
 3648, 40, 32, 32,
 3650, 40, 33, 31,
 3650, 40, 39, 23,
 3654, 38, 37, 29,
 3656, 40, 34, 30,
 3658, 39, 36, 29,
 3666, 40, 35, 29,
 3667, 39, 39, 25,
 3669, 40, 38, 25,
 3672, 38, 38, 28,
 3674, 39, 37, 28,
 3675, 35, 35, 35,
 3677, 36, 35, 34,
 3680, 40, 36, 28,
 3681, 36, 36, 33,
 3681, 37, 34, 34,
 3683, 37, 35, 33,
 3684, 40, 40, 22,
 3689, 37, 36, 32,
 3689, 38, 34, 33,
 3693, 38, 35, 32,
 3694, 39, 38, 27,
 3697, 40, 39, 24,
 3698, 40, 37, 27,
 3699, 37, 37, 31,
 3699, 39, 33, 33,
 3701, 38, 36, 31,
 3701, 39, 34, 32,
 3707, 39, 35, 31,
 3713, 38, 37, 30,
 3713, 40, 33, 32,
 3717, 39, 36, 30,
 3717, 40, 34, 31,
 3718, 39, 39, 26,
 3720, 40, 38, 26,
 3725, 40, 35, 30,
 3729, 38, 38, 29,
 3729, 40, 40, 23,
 3731, 39, 37, 29,
 3737, 40, 36, 29,
 3746, 36, 35, 35,
 3746, 40, 39, 25,
 3748, 36, 36, 34,
 3749, 39, 38, 28,
 3750, 37, 35, 34,
 3753, 40, 37, 28,
 3754, 37, 36, 33,
 3756, 38, 34, 34,
 3758, 38, 35, 33,
 3762, 37, 37, 32,
 3764, 38, 36, 32,
 3766, 39, 34, 33,
 3770, 39, 35, 32,
 3771, 39, 39, 27,
 3773, 40, 38, 27,
 3774, 38, 37, 31,
 3776, 40, 40, 24,
 3778, 39, 36, 31,
 3778, 40, 33, 33,
 3780, 40, 34, 32,
 3786, 40, 35, 31,
 3788, 38, 38, 30,
 3790, 39, 37, 30,
 3796, 40, 36, 30,
 3797, 40, 39, 26,
 3806, 39, 38, 29,
 3810, 40, 37, 29,
 3817, 36, 36, 35,
 3819, 37, 35, 35,
 3821, 37, 36, 34,
 3825, 38, 35, 34,
 3825, 40, 40, 25,
 3826, 39, 39, 28,
 3827, 37, 37, 33,
 3828, 40, 38, 28,
 3829, 38, 36, 33,
 3833, 39, 34, 34,
 3835, 39, 35, 33,
 3837, 38, 37, 32,
 3841, 39, 36, 32,
 3845, 40, 34, 33,
 3849, 38, 38, 31,
 3849, 40, 35, 32,
 3850, 40, 39, 27,
 3851, 39, 37, 31,
 3857, 40, 36, 31,
 3865, 39, 38, 30,
 3869, 40, 37, 30,
 3876, 40, 40, 26,
 3883, 39, 39, 29,
 3885, 40, 38, 29,
 3888, 36, 36, 36,
 3890, 37, 36, 35,
 3894, 37, 37, 34,
 3894, 38, 35, 35,
 3896, 38, 36, 34,
 3902, 38, 37, 33,
 3902, 39, 35, 34,
 3905, 40, 39, 28,
 3906, 39, 36, 33,
 3912, 38, 38, 32,
 3912, 40, 34, 34,
 3914, 39, 37, 32,
 3914, 40, 35, 33,
 3920, 40, 36, 32,
 3926, 39, 38, 31,
 3929, 40, 40, 27,
 3930, 40, 37, 31,
 3942, 39, 39, 30,
 3944, 40, 38, 30,
 3961, 37, 36, 36,
 3962, 40, 39, 29,
 3963, 37, 37, 35,
 3965, 38, 36, 35,
 3969, 38, 37, 34,
 3971, 39, 35, 35,
 3973, 39, 36, 34,
 3977, 38, 38, 33,
 3979, 39, 37, 33,
 3981, 40, 35, 34,
 3984, 40, 40, 28,
 3985, 40, 36, 33,
 3989, 39, 38, 32,
 3993, 40, 37, 32,
 4003, 39, 39, 31,
 4005, 40, 38, 31,
 4021, 40, 39, 30,
 4034, 37, 37, 36,
 4036, 38, 36, 36,
 4038, 38, 37, 35,
 4041, 40, 40, 29,
 4042, 39, 36, 35,
 4044, 38, 38, 34,
 4046, 39, 37, 34,
 4050, 40, 35, 35,
 4052, 40, 36, 34,
 4054, 39, 38, 33,
 4058, 40, 37, 33,
 4066, 39, 39, 32,
 4068, 40, 38, 32,
 4082, 40, 39, 31,
 4100, 40, 40, 30,
 4107, 37, 37, 37,
 4109, 38, 37, 36,
 4113, 38, 38, 35,
 4113, 39, 36, 36,
 4115, 39, 37, 35,
 4121, 39, 38, 34,
 4121, 40, 36, 35,
 4125, 40, 37, 34,
 4131, 39, 39, 33,
 4133, 40, 38, 33,
 4145, 40, 39, 32,
 4161, 40, 40, 31,
 4182, 38, 37, 37,
 4184, 38, 38, 36,
 4186, 39, 37, 36,
 4190, 39, 38, 35,
 4192, 40, 36, 36,
 4194, 40, 37, 35,
 4198, 39, 39, 34,
 4200, 40, 38, 34,
 4210, 40, 39, 33,
 4224, 40, 40, 32,
 4257, 38, 38, 37,
 4259, 39, 37, 37,
 4261, 39, 38, 36,
 4265, 40, 37, 36,
 4267, 39, 39, 35,
 4269, 40, 38, 35,
 4277, 40, 39, 34,
 4289, 40, 40, 33,
 4332, 38, 38, 38,
 4334, 39, 38, 37,
 4338, 39, 39, 36,
 4338, 40, 37, 37,
 4340, 40, 38, 36,
 4346, 40, 39, 35,
 4356, 40, 40, 34,
 4409, 39, 38, 38,
 4411, 39, 39, 37,
 4413, 40, 38, 37,
 4417, 40, 39, 36,
 4425, 40, 40, 35,
 4486, 39, 39, 38,
 4488, 40, 38, 38,
 4490, 40, 39, 37,
 4496, 40, 40, 36,
 4563, 39, 39, 39,
 4565, 40, 39, 38,
 4569, 40, 40, 37,
 4642, 40, 39, 39,
 4644, 40, 40, 38,
 4721, 40, 40, 39,
 4800, 40, 40, 40,
   -1, -1, -1, -1
};

static int vtkMaxPythagoreanQuadrupleId = sizeof(vtkPythagoreanQuadruples)/sizeof(vtkPythagoreanQuadruples[0])/4 - 1;
// VTK-HeaderTest-Exclude: vtkPythagoreanQuadruples.h
