#include <netinet/in.h>
#include "command.h"
#define VERSION "1.0"

typedef enum {
  /* Not connected, and not trying. */
  ConnDisconnected,

  /* Not connected to a server yet, but trying. */
  ConnConnecting,

  /* Someone is calling us. */
  ConnWaitingForConnectString,

  /* We've sent the connect string to the remote end. */
  ConnWaitingForConnectResponse,

  /* Connected, normal command data. */
  ConnConnected
} ConnStatus;

typedef enum {
  ProtoZChat,
  ProtoMudMaster
} Protocol;

struct zmudheader {
  uint16_t id;
  uint16_t len;
};

struct client_info {

  char * name; /* The remote users chat name. */
  char * version; /* The version of the remote user's client. */
  char * email; /* The email address of the client. */

  uint8_t status; /* 0 - None, 1 - Normal, 2 - InActive, 3 - AFK */

};

struct connection {

  int fd; /* The file descriptor */
  ConnStatus status; /* The connection status */
  Protocol proto; /* The protocol used for this connection. */

  struct sockaddr_in * client; /* Information about the client end. */
  char * hostname; /* The hostname, once it has been resolved. */
  struct connection * next;

  char inbuf[32768];
  int inbuf_pos;

  int server_connection; // 1 if another client connected to us, otherwise 0

  /* This is where all the info related to the client is put. */
  struct client_info clientinfo;
};


/**
 * Function declarations.
 */

struct connection * new_connection(int fd);
void delete_connection(struct connection * conn);
int connect_to_client(char *, int);
void check_connection_data();
void read_connection(struct connection *);

int server_init(int);
void output_append(char *); 
void build_command(struct command *);
void send_command(struct connection *, struct command *);
void send_command_to_all(struct command *);

char * get_chat_name();
char * get_chat_ID();
char * get_client_addr();
int get_port();

void zchat_name_change(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_request_connections(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_connection_list(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_text_everybody(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_text_personal(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_text_group(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_message(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_version(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_ping_request(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_ping_response(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_icon(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_status(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_email_address(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_request_pgp_key(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_pgpkey(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_send_command(struct connection * c, struct zmudheader * zhead, char * data) ;


void zchat_stamp(struct connection * c, struct zmudheader * zhead, char * data) ;

uint16_t host_to_zchat(uint16_t);
uint16_t zchat_to_host(uint16_t);
