# Generic Turf game protocol implementation.  Allows negotiation to play
# any turf game following the generic wannaplay, willplay, challenge, deny
# gameon structure.

# See oxo.py for an example on how to use this, particularly the
# turfgame_register function.

import papaya
import re

def turfgame_init():
    global parser

    global turfgame_players
    global turfgame_playing
    global turfgame_windows
    global turfgame_clists
    global turfgame_challenge_window
    global turfgame_games
    global turfgame_players_total

    # Callbacks
    global turfgame_accept_callback
    global turfgame_decline_callback
    global turfgame_terminate_callback
    global turfgame_reset_callback

    parser = re.compile("([^ ]+) ([^ ]+)\.([^ ]+)(.*)")

    turfgame_players = {}
    turfgame_playing = {}
    turfgame_windows = {}
    turfgame_clists = {}
    turfgame_challenge_window = {}
    turfgame_games = []
    turfgame_accept_callback = {}
    turfgame_decline_callback = {}
    turfgame_terminate_callback = {}
    turfgame_reset_callback = {}
    turfgame_players_total = {}

    papaya.turf_add("turfgame_client_protocol")
    papaya.input_add("turfgame_input")

def turfgame_input(input):
    if input == "turfgames":
        turfgame_get_players()
        return ""

    return input

def turfgame_register(game, accept_callback, decline_callback, terminate_callback, reset_callback):

    global turfgame_players
    global turfgame_playing
    global turfgame_windows
    global turfgame_clists
    global turfgame_challenge_window
    global turfgame_games
    
    global turfgame_accept_callback
    global turfgame_decline_callback
    global turfgame_terminate_callback
    global turfgame_reset_callback

    turfgame_players[game] = {}
    turfgame_playing[game] = {}
    turfgame_challenge_window[game] = {}
    turfgame_games.append(game)

    turfgame_accept_callback[game] = accept_callback
    turfgame_decline_callback[game] = decline_callback
    turfgame_terminate_callback[game] = terminate_callback
    turfgame_reset_callback[game] = reset_callback


def turfgame_registered(game):
    global turfgame_games

    for i in turfgame_games:
        if i == game:
            return 1

    return 0

def turfgame_client_protocol(input):
    global parser

    result = parser.match(input)
    if result == None:
        return input

    player = result.group(1)
    game = result.group(2)
    cmd = result.group(3)
    arg = result.group(4)

    # @@ Ensure that this game is supported before calling any functions.
    if turfgame_registered(game) == 0:
        return input

    if cmd == 'wannaplay':
        turfgame_wannaplay_from(player, game)
        return ''

    if cmd == 'willplay':
        turfgame_willplay_from(player, game)
        return ''

    if cmd == 'challenge':
        turfgame_challenge_from(player, game)
        return ''

    if cmd == 'deny':
        turfgame_deny_from(player, game)
        return ''

    if cmd == 'gameon':
        turfgame_gameon_from(player, game)
        return ''

    if cmd == 'quit':
        turfgame_terminate_from(player, game)
        return ''

    if cmd == 'reset':
        turfgame_reset_from(player, game)
        return ''
    
    return input

def turfgame_wannaplay_from(player, game):

    global turfgame_windows
    global turfgame_players

    msg = "c15 c" + player + " " + game + ".willplay";
    papaya.send(msg);

    return


def turfgame_get_players():

    global turfgame_games
    global turfgame_players_total

    turfgame_players_total[papaya_connection] = []
    
    for game in turfgame_games:
        turfgame_wannaplay_to(game)

    if turfgame_windows.has_key(papaya_connection) == 0:
        turfgame_create_widget(papaya_connection)

    turfgame_widget_redraw(papaya_connection)    
    
def turfgame_wannaplay_to(game):

    global turfgame_players
    global turfgame_windows

    turfgame_players[game][papaya_connection] = []

    msg = "c15 call " + game + ".wannaplay"
    papaya.send(msg)

def turfgame_willplay_from(player, game):
    global turfgame_players
    global turfgame_players_total
    global papaya_connection

    found = 0
    for p in turfgame_players_total[papaya_connection]:
        if p == player:
            found = 1
        
    if found == 0:
        print "Appending " + player + " to turfgame_players_total"
        turfgame_players_total[papaya_connection].append(player)

    turfgame_players[game][papaya_connection].append(player)
    turfgame_widget_redraw(papaya_connection)

    return

def turfgame_challenge_from(player, game):
    global turfgame_challenge_window
    global turfgame_playing

    turfgame_playing[game][papaya_connection] = player
    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(papaya_connection + " " + game)
    window.show()

    vbox = GtkVBox(FALSE, 2)
    vbox.show()
    window.add(vbox)

    label = GtkLabel(game + " challenge from " + player + ".  Accept or decline?")
    label.show()

    vbox.pack_start(label)

    hbuttonbox = GtkHButtonBox()
    hbuttonbox.show()
    vbox.pack_start(hbuttonbox)

    ok_button = GtkButton("Accept")
    cancel_button = GtkButton("Decline")

    ok_button.show()
    cancel_button.show()

    hbuttonbox.pack_start(ok_button)
    hbuttonbox.pack_start(cancel_button)

    turfgame_challenge_window[game][papaya_connection] = window

    # Add callbacks for the ok and cancel buttons
    ok_button.connect("clicked", turfgame_accept_challenge, (papaya_connection, game))
    cancel_button.connect("clicked", turfgame_decline_challenge, (papaya_connection, game))

    return

def turfgame_accept_challenge(widget, list):
    global turfgame_accept_callback
    global turfgame_challenge_window
    global papaya_connection
    global turfgame_playing

    conn = list[0]
    game = list[1]

    turfgame_challenge_window[game][conn].destroy()
    del turfgame_challenge_window[game][conn]

    papaya_connection = conn
    player = turfgame_playing[game][conn]
    papaya.send("c15 c" + player + " " + game + ".gameon")

    # Need to call the accept challenge callback for this game
    turfgame_accept_callback[game](player, 0)
    
def turfgame_decline_challenge(widget, list):
    global turfgame_decline_callback
    global turfgame_challenge_window
    global turfgame_playing
    global papaya_connection

    conn = list[0]
    game = list[1]

    turfgame_challenge_window[game][conn].destroy()
    del turfgame_challenge_window[game][conn]

    papaya_connection = conn
    player = turfgame_playing[game][conn]
    papaya.send("c15 c" + player + " " + game + ".deny")

    del turfgame_playing[game][conn]
    turfgame_decline_callback[game](player)

def turfgame_deny_from(player, game):
    papaya.message(game, player + " doesn't want to play " + game + ".")
    return

def turfgame_gameon_from(player, game):
    global turfgame_playing

    turfgame_playing[game][papaya_connection] = player
    turfgame_accept_callback[game](player, 1)

def turfgame_terminate_from(player, game):
    turfgame_terminate_callback[game](player)

def turfgame_reset_from(player, game):
    turfgame_reset_callback[game](player)

def turfgame_create_widget(conn):
    global turfgame_windows
    global turfgame_clists
    global turfgame_games
    
    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(conn + " - " + 'Turf Games')
    window.connect("destroy", turfgame_destroyed, conn)
    window.show(window)

    i = 1
    list = ['Players']
    for game in turfgame_games:
        i = i + 1
        list.append(game)

    clist = GtkCList(i, list)
    clist.show()
    window.add(clist)

    clist.connect("select_row", turfgame_clicked, conn)

    turfgame_windows[conn] = window
    turfgame_clists[conn] = clist

def turfgame_clicked(extra, row, column, more, conn):
    global turfgame_clists
    global papaya_connection

    name = turfgame_clists[conn].get_text(row, 0)
    game = turfgame_clists[conn].get_column_title(column)

    papaya_connection = conn
    papaya.send("c15 c" + name + " " + game + ".challenge")

def turfgame_destroy_widget(conn):
    global turfgame_windows
    global turfgame_clists
    global turfgame_players

    if turfgame_windows.has_key(conn) == 1:
        del turfgame_windows[conn]
    if turfgame_clists.has_key(conn) == 1:
        del turfgame_clists[conn]
    if turfgame_players[game].has_key(conn) == 1:
        del turfgame_players[game][conn]

def turfgame_destroyed(object, conn):
    global turfgame_windows

    for key in turfgame_windows.keys():
        if turfgame_windows[key] == object:
            turfgame_destroy_widget(key)

def turfgame_widget_redraw(conn):
    global turfgame_clists
    global turfgame_players
    global turfgame_players_total
    global turfgame_games

    turfgame_clists[conn].clear()

    i = 0
    for game in turfgame_games:
        i = i + 1
        turfgame_clists[conn].set_column_title(i, game)
        
    for player in turfgame_players_total[conn]:
        list = [player]
        for game in turfgame_games:
            found = 0
            for p in turfgame_players[game][conn]:
                if p == player:
                    found = 1

            if found == 0:
                list.append('no')
            else:
                list.append('yes')

        turfgame_clists[conn].append(list)

turfgame_init()
