# I'm sure this isn't what Cath meant when she said `example plugin' ;}

# Import papaya stuff for hooks
import papaya

# Import regular expression library
import re

# Import RNG stuff
import random

# We want to split some strings in the command muncher
import string

# Setup the patterns used for mangling the output
#   con handles stripping colour codes
#   wordfetch handles picking out words
con = re.compile("\033[^a-zA-Z]+[a-zA-Z]")
wordfetch = re.compile("\w+")
firstthree = re.compile("[^\s]+\s+[^\s]+\s+[^\s]+")

# Papaya Input filter to mix up two random letters in words
def munch_commands(cmd):
    commands = string.split(cmd)

    save = firstthree.search(cmd)
    cmd = firstthree.sub("", cmd, 1)

    # If it doesn't have at least four things to it then it may be a literal
    # command rather than communication, so ignore it
    if len(commands) < 4:
        return cmd

    # Mix up the letters in each individual word
    return save.group(0) + wordfetch.sub(mash, cmd)

# Swap two random letters per string
def mash(match):
    # We don't want to tyop the string toooo much
    if random.random() < 0.7:
        return match.group(0)

    # Set mash for building up the string
    mash = ""

    # Copy the string to a local var for speed
    string = match.group(0)

    # Generate an array of numbers which we will swap about
    pos = range(0, len(string))

    # Pick two numbers in pos to swap
    s1 = random.randrange(0, len(string))
    s2 = random.randrange(0, len(string))

    # Swap the two random indexes in pos
    temp = pos[s1]
    pos[s1] = pos[s2]
    pos[s2] = temp

    # Build the string a character at a time - silly Python strings.
    for index in pos:
        mash = mash + string[index]

    return mash

# Add random pastel colours to the output
#   unfortunately this mashes up the prompt a bit :(
def grant_headache(output):
    # Ignore prompts - example readers take note - they end in \001
    if output[-1] == '\001':
        return output

    # Strip out the old colour
    output = con.sub("", output)

    # Add in the new
    return wordfetch.sub(colourise, output)

# Add random pastels around a given word
def colourise(match):
    r = 0
    g = 0
    b = 0

    # Rejecting dull colours gives nice pastels ...
    while (r < 170 or g < 170 or b < 170):
        r = random.randrange(0, 255)
        g = random.randrange(0, 255)
        b = random.randrange(0, 255)

    # Setup a colour format string
    return ("\033[%3.3d;%3.3d;%3.3dp%s\033[q" % (r, g, b, match.group(0)))

# Add the PapayaVT output filter
papaya.output_add("grant_headache")

# Add the player input filter
papaya.input_add("munch_commands")
