/**
 * Copyright (C) 2001 John Carpenter (barak@wi.rr.com).
 * Released under GPL 2.0 (details in COPYING).
 *
 * May 21st 2002 - Plugin interface modified to support new Win32 plugins.
 */

#include <stdlib.h>
#include <string.h>

#include "Multi.h"
#include "Win32PluginAPI.cpp"

static Multi * Mti;

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
	plugin_address_table_init(pat);
	Mti = new Multi();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  delete Mti;
}

#define MAJOR "0"
#define MINOR "2"
 
extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "Multi";
}
 
extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return _("Allows setting up aliases and triggers in one session that can send commands to another session.");
}
 
extern "C" G_MODULE_EXPORT char * plugin_query_major() {
  return MAJOR;
}
 
extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

Multi::Multi() {
  version = 1.0;
  name = strdup("Multi");
  register_plugin(this, VERSION);
  plugin_handler_add_input_filter(get_plugin_handler(), this);
}

Multi::~Multi() {
  if (name) {
    free(name);
    name = NULL;
  }
  unregister_plugin(this);
}

void Multi::input(Connection * c, char * in) {

  CommandInterpreter * ci = get_command_interpreter();
  if (!ci) {
    printf ("No command interpreter.\n");
    return;
  }
  
  if(*in == '#')
    {
      Connection * con = get_first_connection();
      do
    {
      if((strlen(in) > 3) && !strncasecmp(in+1, "ALL", 3))
	{
	  char *t_in = strdup(in+5);
	  
	  command_interpreter_interpret(ci, con, t_in);
	  free(t_in);
	}
      else if((strlen(in) > strlen(connection_get_name(con))) &&
	      !strncasecmp(in+1, connection_get_name(con), strlen(connection_get_name(con))))
	{
	  break;
	}
      con = connection_get_next(con);
    }while(con);
      
      if((strlen(in) > 3) && !strncasecmp(in+1, "ALL", 3))
	{
	  in[0] = '\0';
	  return;
	}
      
      if(!con)
	return;
      
      command_interpreter_interpret(ci, con, in+2+strlen(connection_get_name(con)));
      in[0] = '\0';
    }
}

