#include "papaya/Plugin.h"

#include "BSXScene.h"
#include "BSXCache.h"

#include <list>
#include <algorithm>

typedef struct bsx_data_ {
  BSXCache * scenes;
  BSXCache * objects;
  BSXScene * scene;
  char incoming[16384];
  int prev_cmd;
  Connection * connection;
} BSXData;

class BSX : public Plugin {

 public:
  BSX();
  ~BSX();

  void output(Connection *, char *);

 private:
  
  void parseRFS(Connection *, char *);
  void parseSCE(Connection *, char *);
  void parseVIO(Connection *, char *);
  void parseDFS(Connection *, char *);
  void parseDFO(Connection *, char *);
  void parseRMO(Connection *, char *);
  void parseTMS(Connection *, char *);
  void parseRQV(Connection *, char *);

  void add_data(BSXData *);
  BSXData * find_data(Connection *);
  void remove_data(BSXData *);

  typedef std::list<BSXData *> BSXDataList;
  std::list<BSXData *> BSXList;
};
