/**
 * This file should be included by plugins.  It provides them with access to the
 * C plugin API.
 */

#include "papaya/Win32PluginAPI.h"

#ifdef WIN32
#include "Win32PluginApiDecl.h"

void plugin_address_table_init(plugin_address_table_t * pat) {
	p_register_plugin = pat->p_register_plugin;
	p_unregister_plugin = pat->p_unregister_plugin;

	p_preference_add_editor = pat->p_preference_add_editor;
	p_preference_remove_editor = pat->p_preference_remove_editor;

	p_connection_get_socket = pat->p_connection_get_socket;
	p_connection_get_vt = pat->p_connection_get_vt;
	p_connection_get_name = pat->p_connection_get_name;
	p_connection_get_mud = pat->p_connection_get_mud;
        p_connection_get_next = pat->p_connection_get_next;
	p_connection_query_preferences = pat->p_connection_query_preferences;

	p_event_get_type = pat->p_event_get_type;
    
	p_vt_append = pat->p_vt_append;
	p_vt_add_to_tray = pat->p_vt_add_to_tray;
	p_vt_remove_from_tray = pat->p_vt_remove_from_tray;
	p_vt_scroll = pat->p_vt_scroll;

	p_socket_write = pat->p_socket_write;
	p_socket_get_telnet_option = pat->p_socket_get_telnet_option;

	p_get_prefix = pat->p_get_prefix;
	p_get_global_preferences = pat->p_get_global_preferences;
	p_get_command_interpreter = pat->p_get_command_interpreter;
	p_get_first_connection = pat->p_get_first_connection;
	p_get_main_window = pat->p_get_main_window;
	p_get_entity_handler = pat->p_get_entity_handler;
	p_get_plugin_handler = pat->p_get_plugin_handler;
    p_get_connection_by_name = pat->p_get_connection_by_name;

	p_main_window_get_item_factory = pat->p_main_window_get_item_factory;
	p_main_window_get_current_connection = pat->p_main_window_get_current_connection;
	p_main_window_add_page_for_app = pat->p_main_window_add_page_for_app;

	p_entity_handler_add_entity = pat->p_entity_handler_add_entity;
	p_entity_handler_remove_entity = pat->p_entity_handler_remove_entity;

	p_system_trigger_entity_new = pat->p_system_trigger_entity_new;

	p_plugin_handler_client_message = pat->p_plugin_handler_client_message;
	p_plugin_handler_add_input_filter = pat->p_plugin_handler_add_input_filter;
	p_plugin_handler_add_output_filter = pat->p_plugin_handler_add_output_filter;
	p_plugin_handler_add_prompt_filter = pat->p_plugin_handler_add_prompt_filter;
	p_plugin_handler_add_telopt_filter = pat->p_plugin_handler_add_telopt_filter;
	p_plugin_handler_remove_input_filter = pat->p_plugin_handler_remove_input_filter;
	p_plugin_handler_remove_output_filter = pat->p_plugin_handler_remove_output_filter;
	p_plugin_handler_remove_prompt_filter = pat->p_plugin_handler_remove_prompt_filter;
	p_plugin_handler_remove_telopt_filter = pat->p_plugin_handler_remove_telopt_filter;
	p_plugin_handler_remove_telopt_filters = pat->p_plugin_handler_remove_telopt_filters;

	p_turf_protocol_add_command = pat->p_turf_protocol_add_command;
	p_turf_protocol_is_supported = pat->p_turf_protocol_is_supported;

	p_command_interpreter_interpret = pat->p_command_interpreter_interpret;

	p_preferences_get_preference = pat->p_preferences_get_preference;
	p_preferences_set_preference = pat->p_preferences_set_preference;
    p_preferences_get_preference_boolean = pat->p_preferences_get_preference_boolean;
	p_preferences_get_preference_integer = pat->p_preferences_get_preference_integer;
    p_preferences_set_preference_boolean = pat->p_preferences_set_preference_boolean;
	p_preferences_set_preference_integer = pat->p_preferences_set_preference_integer;

	p_mud_get_preferences = pat->p_mud_get_preferences;
	p_mud_set_password = pat->p_mud_set_password;
	p_mud_get_password = pat->p_mud_get_password;
	p_mud_set_login_name = pat->p_mud_set_login_name;
	p_mud_get_login_name = pat->p_mud_get_login_name;
	p_mud_set_login_trigger = pat->p_mud_set_login_trigger;
	p_mud_get_login_trigger = pat->p_mud_get_login_trigger;
	p_mud_set_password_trigger = pat->p_mud_set_password_trigger;
	p_mud_get_password_trigger = pat->p_mud_get_password_trigger;

	p_message_new = pat->p_message_new;

	p_fade_get_shade = pat->p_fade_get_shade;
	p_fade_get_editor = pat->p_fade_get_editor;
	p_fade_on_prefs_cancel = pat->p_fade_on_prefs_cancel;
	p_fade_on_prefs_apply = pat->p_fade_on_prefs_apply;
	p_fade_string_max_colour = pat->p_fade_string_max_colour;
	p_fade_string_mid_colour = pat->p_fade_string_mid_colour;
	p_fade_string_min_colour = pat->p_fade_string_min_colour;
	p_fade_string_use_three = pat->p_fade_string_use_three;
	p_fade_new = pat->p_fade_new;
	p_fade_reset = pat->p_fade_reset;
	p_fade_delete = pat->p_fade_delete;
}


#endif // WIN32
