#include "InputPreference.h"
#include "mudclient.h"

extern PreferenceHandler * preferenceHandler;

InputPreference::InputPreference() {
  xml = NULL;
  echo_editor = NULL;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("Echo", "echo_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("Semicolon", "semicolon_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("clearinput", "clear_input_checkbox", WidgetToggle));
}

InputPreference::~InputPreference() {
  if (xml)
    g_object_unref(xml);
}

GtkWidget * InputPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/inputpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, "vbox", NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);

  echo_editor = new ColourEditor(0,0,0);

  GtkWidget * hbox3 = glade_xml_get_widget(xml, "hbox3");
  gtk_box_pack_start(GTK_BOX(hbox3), echo_editor->getPreview(), false, false, 0);

  return vbox;
}

void InputPreference::destroyWidget() {

  if (echo_editor)
    echo_editor = NULL;

  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * InputPreference::getCategories() {
  return (Category *)input_categories;
}

void StringToRGB(char * string, gushort * red, gushort * green, gushort * blue);
char * RGBToString(gushort red, gushort green, gushort blue);

void InputPreference::loadPreferences(Prefs * prefs) {

  Preference::loadPreferences(prefs);

  printf ("Loading prefs.\n");

  gushort red, green, blue;

  StringToRGB(prefs->getPreference("Echo_RGB"), &red, &green, &blue);
  echo_editor->setRGB(red, green, blue);
}

void InputPreference::applyPreferences(Prefs * prefs) {
  Preference::applyPreferences(prefs);

  printf ("saving preferences.\n");

  prefs->setPreference("Echo_RGB", RGBToString(echo_editor->getRed(), echo_editor->getGreen(), echo_editor->getBlue()));
}
