#ifndef INCLUDE_SYSTEM_TRIGGER_ENTITY_H
#define INCLUDE_SYSTEM_TRIGGER_ENTITY_H
#include <sys/types.h>
#include <stdlib.h>
#ifdef WIN32
extern "C" {
#endif
#include <regex.h>
#ifdef WIN32
}
#endif
#include "Connection.h"
#include "Entity.h"

typedef int (*SystemTriggerCallbackFunction)(regex_t *, Connection *, char *, char *, void *);

class SystemTriggerEntity : public Entity {
  
 public:

  SystemTriggerEntity();
  SystemTriggerEntity(char *, Connection *, SystemTriggerCallbackFunction, void *);

  ~SystemTriggerEntity();

  bool findExecute(EntityType, char *, char *, void *, bool);

  GtkWidget * getWidgets();
  void save(FILE *);

 private:

  void setText(char *);
  void setCallback(SystemTriggerCallbackFunction);
  void setCallbackData(void *);
  void setConnection(Connection *);
  void compile();

  void execute(Connection *, char *);

  Connection * connection;
  char * text;

  SystemTriggerCallbackFunction callback;
  void * callback_data;

  regex_t regexp;

};

#endif // INCLUDE_SYSTEM_TRIGGER_ENTITY_H
