#ifndef INCLUDE_SOCKS5_H
#define INCLUDE_SOCKS5_H

#include "Connection.h"

#define SOCKS_INITIAL 0
#define SOCKS_NEGOTIATION_INPROGRESS 1
#define SOCKS_AUTH_COMPLETE 2
#define SOCKS_AUTHENTICATE_USERNAME_PASSWORD_RESPONSE 3
#define SOCKS_AUTHENTICATE_USERNAME_PASSWORD 4
#define SOCKS_CONNECTION_REQUESTED 5
#define SOCKS_CONNECTED 6

#define SOCKS5_NO_AUTH 0x00
#define SOCKS5_GSSAPI_AUTH 0x01
#define SOCKS5_USERNAME_PASSWORD_AUTH 0x02

#define SOCKS5_OK 0x00
#define SOCKS5_SERVER_FAILED 0x01
#define SOCKS5_PERMISSION_DENIED 0x02
#define SOCKS5_NETWORK_UNREACHABLE 0x03
#define SOCKS5_HOST_UNREACHABLE 0x04
#define SOCKS5_CONNECTION_REFUSED 0x05
#define SOCKS5_TTL_EXPIRED 0x06
#define SOCKS5_NOT_SUPPORTED 0x07
#define SOCKS5_ADDR_NOT_SUPPORTED 0x08

#define SOCKS5_V4ADDR 0x01
#define SOCKS5_DOMAINNAME 0x02
#define SOCKS5_V6ADDR 0x04

// This is the number of authentication methods we support.
#define MAX_METHODS 2

class SocksFive : public Socket {

 public:

  SocksFive(Connection * c);
  ~SocksFive();

  int create(char *, int);
  int connected();

 private:
  int state;
  char * dest_host;
  int dest_port;

};

struct socks5_request {
  uint8_t version;
  uint8_t nmethods;
  uint8_t methods[MAX_METHODS];
};

struct socks5_method_response {
  uint8_t version;
  uint8_t method;
};

struct socks5_fqdn_request {
  uint8_t version;
  uint8_t command;
  uint8_t pad; // Must be 0x00.
  uint8_t atyp; // 0x01 for IPv4, 0x03 for domainname, 0x04 for IPv6
  uint32_t daddr;
  uint16_t dport;
};

struct socks5_fqdn_response {
  uint8_t version;
  uint8_t code;
  uint8_t reserved;
  uint8_t atyp;
};

struct socks5_username_request {
  uint8_t version;
  uint8_t ulen;
  char * uname;
  uint8_t plen;
  char * password;
};

struct socks5_username_response {
  uint8_t version;
  uint8_t status;
};

#endif





