#include <stdio.h>

#include <glade/glade.h>

// Holds the name of an entry and its offset into the mudlist.txt file.

struct mce {
  char * name;
  long offset;

  struct mce * next;
  struct mce * prev;

};

class MUDConnectorMUD {

 public:
  MUDConnectorMUD();
  ~MUDConnectorMUD();

  void setName(char *);
  char * getName();

  void setCodeBase(char *);
  char * getCodeBase();

  void setTelnet(char *);
  char * getHost();
  int getPort();

  void setWWW(char *);
  char * getWWW();

  void appendDescription(char *);
  char * getDescription();

 private:

  char * name;
  char * codebase;
  char * www;
  char * description;
  char * host;
  int port;

};

class MUDConnectorList {

 public:
  MUDConnectorList();
  ~MUDConnectorList();

  void readMudlist();

  MUDConnectorMUD * getEntry(char *);
  MUDConnectorMUD * readEntry(struct mce *);

  void appendList(struct mce *);

  void createInterface();
  void destroyInterface();

  struct mce * firstEntry;

  void setCurrentMUD(gchar * name);
  void selectByMUD(GtkTreeIter * iter, gpointer data);

  GtkTreeSelection * selection; // So that GTK C functions can access it.
  void search();
  void displayAll();

 private:

  GladeXML * xml;
  GtkListStore * mud_list_store;
  FILE * fp;

  MUDConnectorMUD * currentMUD;

};

