#ifndef INCLUDE_ENTITY_H
#define INCLUDE_ENTITY_H

#include "mudclient.h"

#include <stdio.h>
#include "papaya/system.h"

#include <glade/glade.h>

typedef enum {
  EntityNone,
  EntityAlias,
  EntityTrigger,
  EntitySystemTrigger,
  EntityGroupGroup
} EntityType;

class Entity {

 public:

  Entity();
  virtual ~Entity();

  void setName(char *);
  void setDescription(char *);

  char * getName();
  char * getDescription();

  virtual bool findExecute(EntityType, char *, char *, void *, bool);
  virtual GtkWidget * getWidgets();

  virtual void save(FILE *);
  int getID();

  virtual void apply();

  EntityType getType();

  void setDisabled(bool);
  virtual void destroyWidgets();

  void setSave(bool);

 protected:
  char * loadBlock(FILE *, char *);
  void setType(EntityType);
  bool disabled;
  GtkWidget * widget;
  bool save_entity;

  GladeXML * xml;
  GtkTextBuffer * description_buffer;
  
 private:

  char * name;
  char * description;

  EntityType type;
  int id;


};

#endif // INCLUDE_ENTITY_H
