#
# spec file for package papaya (Version 0.97.20030627)
#
# Copyright (c) 2003 James Ogley
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# please send bugfixes or comments to feedback@usr-local-bin.org
#

Name:         papaya
%define prefix /opt/gnome2
%define sysconfdir /etc%{prefix}
License:      GPL
Group:        Amusements/Games/RPG
Autoreqprov:  on
Version:      0.97.20030627
Release:      SuSE.ulb.1
Summary:      GTK2 based MUD client with plugins
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
URL:          http://www.gtk-papaya.org
#Source:       papaya-src-%{version}.tar.gz
Source:       papaya-current.tar.bz2
Source2:      papaya.desktop
Patch:        asylum-mcw.dif
Patch2:       workingkeepalivetimer.dif

%description
Papaya is a great MUD client, designed with GTK2.

%package plugins
Summary:      Papaya plugins
Group:        Amusements/Games/RPG
Requires:     papaya = %{version}

%description plugins
Papaya plugins extend the functionality of Papaya.

%package devel
Summary:      Development headers for Papaya
Group:        Amusements/Games/RPG
Requires:     papaya = %{version}

%description devel
This package contains the development headers and libraries required for
building Papaya plugins

%prep
%setup -q -n papaya
%patch -p1
%patch2 -p1
aclocal
automake
autoconf
./configure \
    --sysconfdir=%sysconfdir \
    --prefix=%prefix \
    --enable-plugins=yes

%build
make

%install
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/opt/gnome2/share/applications
install -m 755 %SOURCE2 $RPM_BUILD_ROOT/opt/gnome2/share/applications
mkdir -p $RPM_BUILD_ROOT/usr/lib/pkgconfig
cp -a $RPM_BUILD_ROOT/opt/gnome2/lib/* $RPM_BUILD_ROOT/usr/lib/pkgconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc doc/CREDITS doc/Changelog doc/FEATURES doc/INSTALLING doc/LICENSE doc/manual/manual.pdf
%{prefix}/bin/papaya
%{prefix}/share/papaya
%{prefix}/share/locale/*/*/*
%{prefix}/share/applications/papaya.desktop

%files plugins
%{prefix}/lib/papaya/plugins

%files devel
%{prefix}/include/papaya
/usr/lib/pkgconfig/*

%changelog -n papaya
* Fri Jun 27 2003 - james@usr-local-bin.org
- Now with working keep alive patch - w00t!
* Thu Jun 26 2003 - james@usr-local-bin.org
- Update to latest CVS
- Updated Keep Alive patch to debug to STDOUT
* Mon Jun 09 2003 - james@usr-local-bin.org
- Update to latest CVS
- Added patch to fix Keep Alive text bug
* Mon Jun 02 2003 - james@usr-local-bin.org
- Update to today's CVS
* Fri May 30 2003 - james@usr-local-bin.org
- split out -devel package
* Mon May 19 2003 - james@usr-local-bin.org
- Update to today's CVS
- Includes my patch to Buffer.cpp
* Thu May 01 2003 - james@usr-local-bin.org
- Build today's CVS
- Build plugins
- Include devel stuff
* Wed Apr 30 2003 - james@usr-local-bin.org
- built latest CVS snapshot
- include Asylum in MCW
- include documentation
- include locale files
* Thu Apr 17 2003 - james@usr-local-bin.org
- build for SuSE 8.2
* Tue Dec 24 2002 - james@usr-local-bin.org
- initial build, version 0.96
- Merry Christmas!
