#ifndef __DEBTAGSPLUGINCONTAINER_H_2004_06_23
#define __DEBTAGSPLUGINCONTAINER_H_2004_06_23

#include <string>

#include <QObject>
#include <QString>

//#include <ept/configuration/apt.h>

#include <baseplugincontainer.h>

using namespace std;

namespace ept {
namespace debtags {
class Facet;
class Debtags;
class Vocabulary;
}
}

namespace NApplication
{
	class RunCommand;
}

namespace NTagModel
{
	class VocabularyModel;
}

class DebtagsSettingsWidget;

namespace NPlugin
{

class DebtagsPlugin;
class RelatedPlugin;

/** @brief This class provides plugins using the debtags system.
  * 
  * It manages the shared data and offers the possibility to update the debtags database.
  *
  * @author Benjamin Mesing
  */
class DebtagsPluginContainer : public QObject, public BasePluginContainer 
{
	Q_OBJECT
	
	typedef ept::debtags::Facet Facet;
	typedef ept::debtags::Debtags Debtags;
	typedef ept::debtags::Vocabulary Vocabulary;

	/** @brief This holds a list of the names of all the plugins offered by this 
	  * plugin container. 
	  *
	  * @see offeredPlugins() 
	  */
	vector<QString> _offeredPlugins;
	
	
	NTagModel::VocabularyModel* _pVocabularyModel;

	/** @brief This holds if the debtags operations are currently enabled. 
	  * 
	  * This will be set to false if the reading of the tag database failed. 
	  */
	bool _debtagsEnabled;

	/** Holds the debtags plugin created. */
	DebtagsPlugin* _pDebtagsPlugin;
	/** Holds the related plugin created. */
	RelatedPlugin* _pRelatedPlugin;
	/** This pointer is used to run the <tt>debtags update</tt> command. */
	NApplication::RunCommand* _pCommand;
	/** @brief This holds a pointer to the settings widget currently active.
	  * 
	  * This pointer must not be deleted and should only be used in applySettings(). 
	  */
	DebtagsSettingsWidget* _pSettingsWidget;
public:
	/** Empty Constructor  */
	DebtagsPluginContainer();
	~DebtagsPluginContainer();
	/** @name PluginContainer Interface
	  *
	  * These functions implement the PluginContainer interface.
	  */
	//@{
	virtual bool init(IProvider* pProvider);
	/** @returns "debtagsplugin" */
	virtual string name() const {	return "debtagsplugin"; };
	virtual QString title() const	{ return tr("Debtags Plugins"); };
	/** @brief This returns a list with one entry which is the "Debtags Update" entry
	  *
	  * The QString specifies the menu the action should be added to, the action is
	  * a QAction which is connected to the operation to perform.\n
	  * The default implementation returns an empty vector.
	  */
	vector< pair<QString, QAction*> > actions();
	virtual QWidget* getSettingsWidget(QWidget* pParent);
	virtual void applySettings();
	//@}
	
	/** @name BasePluginContainer Overloads
	  *
	  * These functions implement saving and loading of the container settings
	  * as described in BasePluginContainer.
	  */
	//@{
	virtual QDomElement loadContainerSettings(const QDomElement source);
	virtual void saveContainerSettings(NXml::XmlData& outData, QDomElement parent) const;
	//@}
	
	/** @brief Returns the #_debtagsEnabled property. */
	bool debtagsEnabled()	{ return _debtagsEnabled; };
	/** @brief Returns the facets from the vocabulary. */
	const std::set<Facet> facets() const;
	/** @brief Returns a pointer to the the tag collection currently available. 
	  *
	  * Every item (package) appears only ones in the collection. 
	  */
	const Debtags* collection() const;
	/** @brief Returns a pointer to the model used to store the information about the vocabulary
	  *
	  * This information includes selected tags, hidden facets and possibly more.
	  */
	NTagModel::VocabularyModel* vocabularyModel() const { return _pVocabularyModel; };
protected:
	/** @brief This sets the debtags operations to be enabled/ disabled 
	  *
	  * If set to false all widgets will be disabled, else they will be enabled.
	  * @see #_debtagsEnabled 
	  */
	void setDebtagsEnabled(bool enabled);
	/** @brief Loads the latest debtags database and informs the plugins about the changing of the
	  * database.
	  * 
	  * Behaves sound when loading fails (informing plugins about set to zero).
	  */
	void updateDebtags();
	/** @brief This loads the vocabulary data and filling the #_facets set. 
	  *
	  * The contained plugins will be informed that the debtags data has changed.
	  * If loading fails #_facets will be left empty. 
	  * @param informPlugins if true the plugins will be informed about changing of
	  * the debtags data, set to false if they will be informed on another way
	  */
	void updateVocabulary(bool informPlugins = true);
};

}	// namespace NPlugin

#endif //	__DEBTAGSPLUGINCONTAINER_H_2004_06_23

