//
// C++ Interface: emptytagfilter
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NTAGMODEL_EMPTYTAGFILTER_H_2007_04_06
#define __NTAGMODEL_EMPTYTAGFILTER_H_2007_04_06

#include <set>

#include <QSortFilterProxyModel>

namespace ept {
namespace debtags {
class Tag;
class Debtags;
}
}


using namespace std;

namespace NPlugin
{
	class DebtagsPluginContainer;
}

namespace NTagModel {

class VocabularyModel;

/** Filters out all tags, that would lead to an empty search result.
  *
  * To filter out the tags, the set of currently selected tags (_selectedTags) is considered
  * and only tags which are assigned to at least one of packages selected by that tag set are shown.
  *
  * @author Benjamin Mesing <bensmail@gmx.net>
  */
class EmptyTagFilter : public QSortFilterProxyModel
{
	Q_OBJECT
	
	typedef ept::debtags::Tag Tag;
	typedef ept::debtags::Debtags Debtags;

	/** Pointer to the plugin container which provides access to the vocabulary. */
	const NPlugin::DebtagsPluginContainer* _pContainer;
	/** The model holding the information about the selected tags.
	  *
	  * This information is required, to be able to access the selected tags.
	  */
	const VocabularyModel* _pVocabularyModel;
public:
	EmptyTagFilter(const VocabularyModel* pModel, QObject* pParent = 0);

	virtual ~EmptyTagFilter();
	virtual bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const;
	
	// TODO: debug
// 	virtual QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const
// 	{
// 		if (role == Qt::DisplayRole)
// 		{
// 			qDebug("[EmptyTagFilter::data()] row: %d column: %d", index.row(), index.column());
// 			qDebug("[EmptyTagFilter::data()] tag name " + sourceModel()->data(mapToSource(index), role).toString());
// 		}
// 		return QSortFilterProxyModel::data(index, role);
// 	}
	
public slots:
	void tagSelectionChanged();
};

}



#endif
