///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <base/Base.h>
#include <base/linalg/Vector3.h>
#include <base/linalg/Vector2.h>
#include <base/linalg/VectorN.h>

namespace Base {

/// This dummy instance should be passed to the Vector_3/Vector_2 constructor to initialize itto the null vector.
NullVector NULL_VECTOR;

// Define the default Vector_3 template instance.
template class BASE_DLLEXPORT	Vector_3<FloatType>;
template class BASE_DLLEXPORT	Vector_3<int>;

// Define the default Vector_2 template instance.
template class BASE_DLLEXPORT Vector_2<FloatType>;
template class BASE_DLLEXPORT Vector_2<int>;

// Define the default Vector4 template instance.
template class BASE_DLLEXPORT VectorN<FloatType, 4>;

};	// End of namespace Base
