///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __DXA_FILE_PARSER_H
#define __DXA_FILE_PARSER_H

#include <core/Core.h>
#include "../MultiFileParser.h"

namespace AtomViz {

/******************************************************************************
* This file import class parses DXA (dislocation extraction algorithm)
* preprocessed files written by the DXA LAMMPS module.
******************************************************************************/
class ATOMVIZ_DLLEXPORT DXAFileParser : public MultiFileParser
{
public:
	/// Default constructor.
	DXAFileParser(bool isLoading = false) : MultiFileParser(isLoading) {}

public:

	/// Opens the settings dialog for this parser.
	/// \return \a true if the dialog has been approved by the user; \a false when the user has canceled the operation.
	virtual bool showSettingsDialog(QWidget* parent);

	/// \brief Returns whether this import filter provides a settings dialog box.
	virtual bool hasSettingsDialog() { return true; }

	/// \brief Checks if the given file has format that can be read by this importer.
	virtual bool checkFileFormat(const QString& filePath);

protected:

	/// \brief Reads an atomic data set from the input file.
	virtual EvaluationStatus loadTimeStep(AtomsObject* destination, int movieFrame, const QString& filename, streampos byteOffset, int lineNumber, bool suppressDialogs);

	/// \brief Parses the header of the given file and returns the number of data columns contained in the file.
	virtual bool inspectFileHeader(const QString& filename, int& numberOfColumns, QStringList& columnNames);

private:

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(DXAFileParser)
};

};	// End of namespace AtomViz

#endif // __DXA_FILE_PARSER_H
