///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <atomviz/atoms/AtomsRenderer.h>
#include "AtomVizSettingsPage.h"

namespace AtomViz {

IMPLEMENT_PLUGIN_CLASS(AtomVizSettingsPage, ApplicationSettingsPage)

/******************************************************************************
* Creates the widget that contains the plugin specific setting controls.
******************************************************************************/
void AtomVizSettingsPage::insertSettingsDialogPage(SettingsDialog* settingsDialog, QTabWidget* tabWidget)
{
	QWidget* page = new QWidget();
	tabWidget->addTab(page, tr("AtomViz"));

	QGridLayout* layout1 = new QGridLayout(page);

	QGroupBox* renderingMethodGroupBox = new QGroupBox(tr("Atom rendering method"), page);
	layout1->addWidget(renderingMethodGroupBox, 0, 0);
	QVBoxLayout* layout2 = new QVBoxLayout(renderingMethodGroupBox);

	useOGLPointParametersBox = new QCheckBox(tr("Use point sprites"));
	layout2->addWidget(useOGLPointParametersBox);

	useShaderProgramsBox = new QCheckBox(tr("Use hardware shader programs"));
	layout2->addWidget(useShaderProgramsBox);

	useOGLPointParametersBox->setChecked(AtomsRenderer::arePointSpritesEnabled());
	useShaderProgramsBox->setChecked(AtomsRenderer::areHWShadersEnabled());
}

/******************************************************************************
* Lets the settings page to save all
******************************************************************************/
void AtomVizSettingsPage::saveValues(SettingsDialog* settingsDialog)
{
	AtomsRenderer::enablePointSprites(useOGLPointParametersBox->isChecked());
	AtomsRenderer::enableHWShaders(useShaderProgramsBox->isChecked());
}

};	// End of namespace AtomViz
