//
// $Id: TestedItem.cpp 4140 2007-06-22 14:13:33Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "TestedItem.h"

//****************************************************************************************//
//								Test Class												  //	
//****************************************************************************************//
TestedItem::TestedItem() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete Test object
	//
	// -----------------------------------------------------------------------

	this->SetResult(OvalEnum::RESULT_NOT_EVALUATED);
}

TestedItem::~TestedItem() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------
	
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//

Item* TestedItem::GetItem() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the item field's value
	//
	// -----------------------------------------------------------------------

	return this->item;
}

void TestedItem::SetItem(Item* item) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the item field's value
	//
	// -----------------------------------------------------------------------

	this->item = item;
}

OvalEnum::ResultEnumeration TestedItem::GetResult() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the result field's value
	//
	// -----------------------------------------------------------------------

	return this->result;
}

void TestedItem::SetResult(OvalEnum::ResultEnumeration result) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the result field's value
	//
	// -----------------------------------------------------------------------

	this->result = result;
}

void TestedItem::Write(DOMElement* parentElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	writes a TestedItem element
	//
	// -----------------------------------------------------------------------	

	// get the parent document
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* resultDoc = parentElm->getOwnerDocument();

	// create a new tested_item element
	DOMElement* testedItemElm = XmlCommon::AddChildElement(resultDoc, parentElm, "tested_item");

	// add the attributes
	XmlCommon::AddAttribute(testedItemElm, "item_id", Common::ToString(this->GetItem()->GetId()));
	XmlCommon::AddAttribute(testedItemElm, "result", OvalEnum::ResultToString(this->GetResult()));
}

void TestedItem::Parse(DOMElement* itemElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	parses itme elm to a Item obj
	//
	// -----------------------------------------------------------------------
	Item* item = new Item();
	Item::Cache(item);
	this->SetItem(item);
	this->GetItem()->Parse(itemElm);
}
