/**
  @file btcond-dbus.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _BTCOND_DBUS_H_
#define _BTCOND_DBUS_H_

#include <dbus/dbus.h>

/** Bind functions to corresponding D-Bus messages
 * @param connection D-Bus connection
 */
void init_dbus_handlers(DBusConnection *connection);

/** Free memory allocated to handlers
 * @param connection D-Bus connection
 */
void destroy_dbus_handlers(DBusConnection *connection);

#endif /* _BTCOND_DBUS_H_ */
