from base64 import b64encode, b64decode
from cStringIO import StringIO
from gzip import GzipFile

_META_DATA_LATE_COMMAND_TEMPLATE = """
seed_d=/var/lib/cloud/seed/nocloud-net
mkdir -p "$seed_d"
cat > "$seed_d"/meta-data <<"EOF"
instance-id: %s
local-hostname: %s
EOF
"""

_USER_DATA_LATE_COMMAND_TEMPLATE = """
seed_d=/var/lib/cloud/seed/nocloud-net
mkdir -p "$seed_d"
cat > "$seed_d"/user-data <<"EOF"
%s
EOF
"""

_KSMETA_LATE_COMMAND_TEMPLATE = (
    "in-target sh -c '"
        "f=$1; "
        "shift; "
        "echo $0 | base64 --decode | gunzip > $f "
        "&& chmod u+x $f "
        "&& $f $*"
    "' %s /root/%s-late-command")

def base64_gzip(content):
    gzipped = StringIO()
    gzip_file = GzipFile(fileobj=gzipped, mode="wb", compresslevel=9)
    gzip_file.write(content)
    gzip_file.close()
    return b64encode(gzipped.getvalue())

def get_meta_data_late_command(instance_id=None, hostname=None):
    late_command = _META_DATA_LATE_COMMAND_TEMPLATE % (instance_id, hostname)
    return _KSMETA_LATE_COMMAND_TEMPLATE % (base64_gzip(late_command), "meta-data")

def get_user_data_late_command(user_data_base64):
    user_data = b64decode(user_data_base64)
    late_command = _USER_DATA_LATE_COMMAND_TEMPLATE % (user_data)
    return _KSMETA_LATE_COMMAND_TEMPLATE % (base64_gzip(late_command), "user-data")
