class mpi_client($clustername = $uniqueid)
{
  apt::ppa{"ppa:canonical-sig/thirdparty":}
  package{ "john": ensure => installed, require => Apt::Ppa["ppa:canonical-sig/thirdparty"] }
  package{ "mpich2": ensure => installed }
  package{ "openssh-client": ensure => installed }
  package{ "build-essential": ensure => installed }
  package{ "libmpich2-dev": ensure => installed }

  exec{"create_mpi_dir":
    command => "mkdir -p /etc/mpi",
    require => Package["mpich2"],
    unless => "test -d /etc/mpi",
  } -> File <<| tag == "mpi_${clustername}" |>>

  file{"${clustername}_mpd_link":
    name => "/etc/mpd.conf",
    ensure => link,
    target => "/etc/mpi/mpd.conf",
    require => File["${clustername}_mpd_config"],
  }

  exec{"/usr/bin/mpd --daemon":
    require => File["${clustername}_mpd_link"],
    unless => "/bin/ps axf | /bin/grep \"/usr/bin/mpd --daemon\" | /bin/grep -v grep",
  }


} 
