# Hadoop NameNode/JobTracker


class hadoop_namenode_jobtracker($clustername = $uniqueid, $namenode = $ipaddress_eth0, $jobtracker = $ipaddress_eth0, $hdfsdatadir = '/var/lib/hadoop-0.20/dfs/data') {
	include hadoop

	@@file{ "/etc/hadoop/cluster_data/${clustername}.cluster_data": content => "${clustername}:${namenode}:${jobtracker}:${hdfsdatadir}", tag => "hadoop_${clustername}" }

	exec{ "mkdir -p /etc/hadoop/cluster_data": } -> exec{ "hadoop_config_save": command => "/bin/echo ${clustername}:${namenode}:${jobtracker}:${hdfsdatadir} > /etc/hadoop/cluster_data/${clustername}.cluster_data" } -> package{"debconf": ensure => installed} -> exec{"echo debconf hadoop/namenode string ${namenode} | debconf-set-selections": require => Package["debconf"]} -> exec{"echo debconf hadoop/jobtracker string ${jobtracker} | debconf-set-selections": require => Package["debconf"]} -> exec{"echo debconf hadoop/hdfsdatadir string ${hdfsdatadir} | debconf-set-selections": require => Package["debconf"]} -> package{"hadoop-0.20-namenode": ensure => installed} -> package{"hadoop-0.20-jobtracker": ensure => installed } -> File <<| tag == "hadoop_${clustername}" |>> -> File <<| tag == "hadoop_${clustername}" |>>

}
