//---------------------------------------------------------------------------
//
// Project: OpenWalnut ( http://www.openwalnut.org )
//
// Copyright 2009 OpenWalnut Community, BSV@Uni-Leipzig and CNCF@MPI-CBS
// For more information see http://www.openwalnut.org/copying
//
// This file is part of OpenWalnut.
//
// OpenWalnut is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// OpenWalnut is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with OpenWalnut. If not, see <http://www.gnu.org/licenses/>.
//
//---------------------------------------------------------------------------

#ifndef WTERMINALCOLOR_TEST_H
#define WTERMINALCOLOR_TEST_H

#include <string>
#include <sstream>

#include <boost/shared_ptr.hpp>
#include <cxxtest/TestSuite.h>

#include "../WTerminalColor.h"

/**
 * Test WTerminalColor. Just some simple test to verify the control strings.
 */
class WTerminalColorTest : public CxxTest::TestSuite
{
public:
    /**
     * An instantiation should never throw an exception.
     */
    void testInstantiation( void )
    {
        TS_ASSERT_THROWS_NOTHING( WTerminalColor c() );
        TS_ASSERT_THROWS_NOTHING( WTerminalColor( WTerminalColor::Bold, WTerminalColor::FGRed, WTerminalColor::BGNone ) );
    }

    /**
     * Test control string generated by class.
     */
    void testColorControlString( void )
    {
        WTerminalColor c;
        TS_ASSERT_THROWS_NOTHING( c = WTerminalColor( WTerminalColor::Bold, WTerminalColor::FGRed, WTerminalColor::BGGreen ) );

        // generate an own control string
        std::ostringstream ss;
#if defined( __linux__ ) || defined( __APPLE__ )
        char cStart = 0x1B; // this is an indirect cast to char, otherwise 0x1B whould be interpreted as number 27
        ss << cStart << "[" << 1 << ";" << 31 << ";" << 42 << "m";
#endif
        // compare them
        TS_ASSERT_EQUALS( ss.str(), c.m_colorString );
    }

    /**
     * Test control string (reset) generated by class.
     */
    void testColorResetControlString( void )
    {
        WTerminalColor c;
        TS_ASSERT_THROWS_NOTHING( c = WTerminalColor( WTerminalColor::Bold, WTerminalColor::FGRed, WTerminalColor::BGGreen ) );

        // generate an own control string
        std::ostringstream ss;
#if defined( __linux__ ) || defined( __APPLE__ )
        char cStart = 0x1B;
        ss << cStart << "[0m";
#endif
        // compare them
        TS_ASSERT( ss.str() == c.m_colorResetString );
    }

    /**
     * Test whether the class returns empty control strings when colors are disabled.
     */
    void testColorDisabled( void )
    {
        WTerminalColor c;
        TS_ASSERT_THROWS_NOTHING( c = WTerminalColor( WTerminalColor::Bold, WTerminalColor::FGRed, WTerminalColor::BGGreen ) );

        c.setEnabled( false );
        TS_ASSERT( c.m_colorResetString == "" );
        TS_ASSERT( c.m_colorString == "" );
    }
};

#endif  // WTERMINALCOLOR_TEST_H
