# -*- rpm-spec -*-
Name:           openvrml
Version:        0.15.10
Release:        1
Summary:        VRML97 runtime library.
License:        LGPL
Group:          System Environment/Libraries
Packager:       The OpenVRML Development Team <openvrml-develop@lists.sf.net>
Source:         http://prdownloads.sf.net/openvrml/%{name}-%{version}.tar.gz
URL:            http://openvrml.org
BuildRoot:      %{_tmppath}/%{name}-root
BuildRequires:  pkgconfig >= 0.12.0
BuildRequires:  boost-devel >= 1.30.2
BuildRequires:  zlib-devel >= 1.1.3
BuildRequires:  libpng-devel >= 1.0.12
BuildRequires:  libjpeg-devel >= 6b
BuildRequires:  fontconfig-devel >= 2.0
BuildRequires:  freetype-devel >= 2.1.2
BuildRequires:  mozilla-devel >= 1.6
BuildRequires:  xorg-x11-devel >= 6.7
BuildRequires:  SDL-devel >= 1.2
BuildRequires:  gtk2-devel
Requires:       zlib >= 1.1.3
Requires:       libpng >= 1.0.12
Requires:       libjpeg >= 6b
Requires:       fontconfig >= 2.0
Requires:       freetype >= 2.1.2
Requires:       mozilla >= 1.6

%description
OpenVRML is a VRML support library, including a runtime and facilities for
reading and writing VRML models.


%package devel
Summary:        Headers and static library for developing C++ programs with OpenVRML
Group:          Development/Libraries
Requires:	%{name}
%description devel
Headers and static library that programmers will need to develop C++ programs
using OpenVRML

%package gl
Summary:        OpenGL renderer for OpenVRML
Group:          System Environment/Libraries
Requires:       %{name} = %{version}
Requires:       xorg-x11-Mesa-libGLU >= 6.7
%description gl
OpenGL renderer for OpenVRML.

%package gl-devel
Summary:        OpenVRML OpenGL renderer headers and static library.
Group:          Development/Libraries
Requires:       %{name}-gl = %{version}
Requires:       xorg-x11-devel >= 6.7
%description gl-devel
Headers and static library that programmers will need to develop C++ programs
using the OpenVRML OpenGL renderer.

%package -n lookat
Summary:        VRML viewer
Group:          Applications/Multimedia
Requires:       %{name}-gl = %{version}
Requires:       mozilla = %(rpm -q mozilla --qf='%%{epoch}:%%{version}')
Requires:       SDL >= 1.2
%description -n lookat
SDL-based VRML viewer.

%package mozilla-plugin
Summary:        VRML browser plug-in for Mozilla-based browsers.
Group:          Applications/Internet
License:        GPL
Requires:       %{name}-gl = %{version}
Requires:       gtk2
Requires:       mozilla >= 1.6
%description mozilla-plugin
VRML browser plug-in for Mozilla-based browsers.

%prep
%setup

%build
%configure --disable-script-node-java CPPFLAGS="-DNDEBUG"
make %{?_smp_mflags}

%install
%makeinstall
rm $RPM_BUILD_ROOT%{_libdir}/mozilla/plugins/openvrml.la

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc AUTHORS COPYING.LESSER ChangeLog NEWS README THANKS
%{_libdir}/libopenvrml.so.*

%files devel
%doc AUTHORS COPYING.LESSER ChangeLog NEWS README THANKS
%doc doc/manual
%{_includedir}/%{name}/openvrml/*.h
%{_libdir}/libopenvrml.la
%{_libdir}/libopenvrml.a
%{_libdir}/libopenvrml.so
%{_libdir}/pkgconfig/openvrml.pc

%files gl
%doc AUTHORS COPYING.LESSER ChangeLog NEWS README THANKS
%{_libdir}/libopenvrml-gl.so.*

%files gl-devel
%doc AUTHORS COPYING.LESSER ChangeLog NEWS README THANKS
%{_includedir}/%{name}/openvrml/gl
%{_libdir}/libopenvrml-gl.la
%{_libdir}/libopenvrml-gl.a
%{_libdir}/libopenvrml-gl.so
%{_libdir}/pkgconfig/openvrml-gl.pc

%files -n lookat
%doc AUTHORS COPYING ChangeLog NEWS README THANKS
%{_bindir}/lookat
%{_datadir}/pixmaps/lookat.xpm

%files mozilla-plugin
%doc AUTHORS COPYING ChangeLog NEWS README THANKS
%{_libdir}/mozilla/plugins/openvrml.so
%{_libdir}/mozilla/plugins/openvrml.xpt
%{_libexecdir}/openvrml-player
%{_datadir}/idl/%{name}-%{version}/openvrml.idl


%changelog
* Tue Apr 19 2005  Braden McDaniel  <braden@endoframe.com>
- Removed dejagnu build prerequisite.

* Wed Jan 26 2005  Braden McDaniel  <braden@endoframe.com>
- configure with --disable-script-node-java.  The Script node Java binding
  is not currently usable.

* Fri Jan 07 2005  Braden McDaniel  <braden@endoframe.com>
- Added %{_libexecdir}/openvrml-player to the openvrml-mozilla-plugin package.

* Fri Dec 29 2004  Braden McDaniel  <braden@endoframe.com>
- Fixed name of xorg-x11-devel prerequisite for the openvrml-gl-devel package.

* Fri Dec 24 2004  Braden McDaniel  <braden@endoframe.com>
- Require mozilla >= 1.6.  The plug-in now must link with libxpcom.
- Removed GtkGLExt dependency; added GTK+ 2.x dependency.  GtkGLExt is
  now included in the distribution.

* Thu Dec 03 2004  Braden McDaniel  <braden@endoframe.com>
- Use %makeinstall macro.
- Install COPYING (GPL) with lookat documentation rather than COPYING.LESSER
  (LGPL).

* Tue Nov 30 2004  Braden McDaniel  <braden@endoframe.com>
- Added dejagnu >= 1.4 as a build prerequisite.

* Fri Nov 26 2004  Braden McDaniel  <braden@endoframe.com>
- Changed Mozilla plug-in RPM name to openvrml-mozilla-plugin.
- Refer to the plug-in in comments as "for Mozilla-based browsers" rather than
  "for Mozilla".

* Sun Nov 21 2004  Braden McDaniel  <braden@endoframe.com>
- Changed openvrml-gl-devel dependency on XFree86-devel to xorg-X11-devel.
- Removed openvrml-mozilla dependency on mozilla.  Other browsers (e.g.,
  Firefox) could use the plug-in, too.

* Sat May 15 2004  Braden McDaniel  <braden@endoframe.com>
- Use "License" instead of "Copyright".
- Require xorg-x11 packages instead of XFree86.
- Removed "Prefix" specification.
- Use "%configure" macro.
- Install script.jar.
- Use %{_libdir}, etc. macros.
- Install openvrml.idl.

* Sun May 09 2004  Braden McDaniel  <braden@endoframe.com>
- Corrected description of lookat RPM to reflect the change to using SDL.
- Define NDEBUG when configuring.

* Wed May 05 2004  Braden McDaniel  <braden@endoframe.com>
- Made Mozilla plug-in scriptable.

* Mon Apr 26 2004  Braden McDaniel  <braden@endoframe.com>
- Added Mozilla plug-in.

* Thu Nov 20 2003  Braden McDaniel  <braden@endoframe.com>
- Require SDL for lookat instead of glut.
- Set "DESTDIR" for "make install" rather than "prefix".

* Sun Nov 16 2003  Braden McDaniel  <braden@endoframe.com>
- Removed unused ARCH_FLAGS variable from "configure" invocation.
- Added _smp_mflags macro to invocation of make.

* Fri Nov 07 2003  Braden McDaniel  <braden@endoframe.com>
- Added "BuildRequires: libgcj-devel >= 3.3" and analogous Requires. Script
  node Java support is now included in the build, and older versions of libgcj
  have a bug that prevents OpenVRML from compiling.
- Removed glut requirement from opevrml-gl package. (Should have been done
  some time ago.)
- Added glut requirement to lookat package.
- Changed XFree86 requirement of openvrml-gl to XFree86-Mesa-libGLU to
  correspond to Fedora Core package name. Upped required version of XFree86 to
  4.3 to correspond to this.

* Mon Nov 03 2003  Braden McDaniel  <braden@endoframe.com>
- Removed lookat-bin from lookat package.
- Added mozilla requirement for lookat.  lookat is now built with -rpath for
  the Mozilla library directory; so the binary package requires the same
  Mozilla version it was built against.

* Mon Oct 27 2003  Braden McDaniel  <braden@endoframe.com>
- Added lookat-bin to lookat package.

* Tue Sep 30 2003  Braden McDaniel  <braden@endoframe.com>
- Added BuildRequires: boost-devel.

* Sun Sep 28 2003  Braden McDaniel  <braden@endoframe.com>
- Changed COPYING.LIB to COPYING.LESSER.
- Moved pkg-config metadata files to devel packages.
- Changes for parity with installation directory names.

* Tue Dec 17 2002  Braden McDaniel  <braden@endoframe.com>
- Removed conformance.html from %doc.  This doc now incorporated into doxygen
  docs.

* Tue Dec 10 2002  Braden McDaniel  <braden@endoframe.com>
- Added BuildRequires for pkgconfig, fontconfig-devel, freetype-devel.
- Added Requires for fontconfig, freetype.
- Updated configure arguments.
- Added conformance.html to openvrml's %doc.
- Added API (doxygen) docs to openvrml-devel's %doc.
- Removed GL renderer headers in openvrml-devel.
- Added AUTHORS, COPYING.LIB, ChangeLog, NEWS, README, THANKS to %doc for all
  packages.

* Sun Dec 08 2002  Braden McDaniel  <braden@endoframe.com>
- Removed COPYING from %doc.

* Thu Dec 05 2002  Braden McDaniel  <braden@endoframe.com>
- Added minimum versions to BuildRequires dependencies.
- configure --without-ftflibs.
- Require Mozilla 1.2.1; removed obsolete CPPFLAGS and LDFLAGS when
  configuring.

* Sun Jun 30 2002  Braden McDaniel  <braden@endoframe.com>
- configure --without-doxygen.
- Removed "doc/conformance.html" from %doc.

* Sat Jun 15 2002  Braden McDaniel  <braden@endoframe.com>
- Use CPPFLAGS and LDFLAGS for Mozilla 1.0.0 when running configure.
- Require Mozilla 1.0.0.

* Mon May 20 2002  Braden McDaniel  <braden@endoframe.com>
- Fixed pkgconfig metafile names.
- Updated dependencies to reflect RPMs shipping with Red Hat 7.3.
- Updated source download URI.
- Removed prefix.
- Added BuildRequires.
- Added Requires for zlib, libpng, libjpeg, mozilla.
- configure --without-jdk.

* Thu Jan 24 2002  Braden McDaniel  <braden@endoframe.com>
- Added package metafiles for pkgconfig.
- Removed autoconf macros for use by client packages.

* Fri Jun 29 2001  Braden McDaniel  <braden@endoframe.com>
- Removed MPL-1.1.txt from %doc. File nolonger distributed.
- Prefer the shorter "sf.net" to "sourceforge.net".

* Wed Jun 6 2001  Braden McDaniel  <braden@endoframe.com>
- Added COPYING to %doc.
- Changed URL to <http://openvrml.org>
- Corrected packager e-mail address.

* Thu Jan 25 2001  Braden McDaniel  <braden@endoframe.com>
- Fixed location of lookat icon in %files section for lookat
- Added Mesa >= 3.2 as a requirement for openvrml-gl.

* Tue Jan 2 2001  Braden McDaniel  <braden@endoframe.com>
- Removed obsolete TODO from %doc.

* Sun Dec 31 2000  Clayton Cottingham <drfrog@smartt.com>
- Change in install section rm command is now recursive

* Fri Dec 15 2000  Braden McDaniel  <braden@endoframe.com>
- Added lookat.xpm to files section for lookat.

* Fri Dec 8 2000  Braden McDaniel  <braden@endoframe.com>
- Changes to reflect library name and header location changes.

* Sun Dec 3 2000  Braden McDaniel  <braden@endoframe.com>
- Removed README.SOUND from %doc

* Sun Nov 26 2000  Braden McDaniel  <braden@endoframe.com>
- Added conformance.html to %doc.
- Removed obsolete COPYING.ANTLR from %doc.
- Changed URL to <http://openvrml.sourceforge.net>.
- Removed obsolete NODES from %doc.

* Thu Nov 23 2000  Braden McDaniel  <braden@endoframe.com>
- Gave much love. Checked into CVS. Still not guaranteed to work, though.

* Tue Oct 24 2000  Braden McDaniel  <braden@endoframe.com>
- Received initial spec file from Clayton Cottingham <drfrog@smartt.com>.
