///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2012 DreamWorks Animation LLC
//
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
//
// Redistributions of source code must retain the above copyright
// and license notice and the following restrictions and disclaimer.
//
// *     Neither the name of DreamWorks Animation nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
// LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
//
///////////////////////////////////////////////////////////////////////////

#ifndef OPENVDB_TOOLS_QUADRATICINTERP_HAS_BEEN_INCLUDED
#define OPENVDB_TOOLS_QUADRATICINTERP_HAS_BEEN_INCLUDED

#include <openvdb/Types.h>
#include "GridSampling.h"
#include "GridTransformer.h" // for QuadraticSampler


namespace openvdb {
OPENVDB_USE_VERSION_NAMESPACE
namespace OPENVDB_VERSION_NAME {
namespace tools {

template<typename TreeType>
class QuadraticInterp: public GridSampling<TreeType>
{
public:
    typedef GridSampling<TreeType>                        BaseType;
    typedef boost::shared_ptr<QuadraticInterp<TreeType> > Ptr;

    typedef typename TreeType::Ptr                        TreePtr;
    typedef typename TreeType::ValueType                  ValueType;

    /// use GridSampler<TreeType, openvdb::tools::QaudraticSampler> 
    OPENVDB_DEPRECATED explicit QuadraticInterp(const TreeType& tree):
        BaseType(tree) {}
    virtual ~QuadraticInterp() {}

    /// Triquadratically sample a grid at (x, y, z).
    virtual ValueType sampleVoxel(Real x, Real y, Real z) const
     { 
         ValueType result = zeroVal<ValueType>();
         QuadraticSampler::sample(BaseType::mTree, Vec3R(x, y, z), result);
         return result;
     }

private:
    // Disallow copying of instances of this class.
    QuadraticInterp(const QuadraticInterp&);
    QuadraticInterp& operator=(const QuadraticInterp&);
};


} // namespace tools
} // namespace OPENVDB_VERSION_NAME
} // namespace openvdb

#endif // OPENVDB_TOOLS_QUADRATICINTERP_HAS_BEEN_INCLUDED

// Copyright (c) 2012 DreamWorks Animation LLC
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
