###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for samba MDVA-2010:056 (samba)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830870);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:056");
  script_name("Mandriva Update for samba MDVA-2010:056 (samba)");
  desc = "

  Vulnerability Insight:

  This is a maintenance update of samba in order to support Windows 7
  hosts integration in Samba domain.
  
  Additionally on 2009.0 and MES5 samba has been upgraded from 3.2.15
  to 3.3.10 which brings many upstream fixes besides those that mainly
  conserns Windows 7 interoperabilities.

  Affected Software/OS:
  samba on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64,
  Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtalloc1", rpm:"libtalloc1~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtdb1", rpm:"libtdb1~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi0", rpm:"lib64netapi0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi-devel", rpm:"lib64netapi-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes0", rpm:"lib64smbsharemodes0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes-devel", rpm:"lib64smbsharemodes-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64talloc1", rpm:"lib64talloc1~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64talloc-devel", rpm:"lib64talloc-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64tdb1", rpm:"lib64tdb1~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64tdb-devel", rpm:"lib64tdb-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient0", rpm:"lib64wbclient0~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient-devel", rpm:"lib64wbclient-devel~3.3.10~0.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi0", rpm:"lib64netapi0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi-devel", rpm:"lib64netapi-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes0", rpm:"lib64smbsharemodes0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes-devel", rpm:"lib64smbsharemodes-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient0", rpm:"lib64wbclient0~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient-devel", rpm:"lib64wbclient-devel~3.3.10~0.1mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtalloc1", rpm:"libtalloc1~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtdb1", rpm:"libtdb1~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi0", rpm:"lib64netapi0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64netapi-devel", rpm:"lib64netapi-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes0", rpm:"lib64smbsharemodes0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbsharemodes-devel", rpm:"lib64smbsharemodes-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64talloc1", rpm:"lib64talloc1~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64talloc-devel", rpm:"lib64talloc-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64tdb1", rpm:"lib64tdb1~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64tdb-devel", rpm:"lib64tdb-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient0", rpm:"lib64wbclient0~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wbclient-devel", rpm:"lib64wbclient-devel~3.3.10~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}